"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdktf_1 = require("cdktf");
const _1 = require(".");
const app = new cdktf_1.App();
const stack = new cdktf_1.TerraformStack(app, 'cdktf-eks-demo');
const cluster = new _1.Cluster(stack, 'EcsCluster');
cluster.addAsgCapacity('ASGCapacity', {
    maxCapacity: 10,
    minCapacity: 0,
    desiredCapacity: 2,
});
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuZGVmYXVsdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9pbnRlZy5kZWZhdWx0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsaUNBQTRDO0FBQzVDLHdCQUE0QjtBQUU1QixNQUFNLEdBQUcsR0FBRyxJQUFJLFdBQUcsRUFBRSxDQUFDO0FBRXRCLE1BQU0sS0FBSyxHQUFHLElBQUksc0JBQWMsQ0FBQyxHQUFHLEVBQUUsZ0JBQWdCLENBQUMsQ0FBQztBQUV4RCxNQUFNLE9BQU8sR0FBRyxJQUFJLFVBQU8sQ0FBQyxLQUFLLEVBQUUsWUFBWSxDQUFDLENBQUM7QUFFakQsT0FBTyxDQUFDLGNBQWMsQ0FBQyxhQUFhLEVBQUU7SUFDcEMsV0FBVyxFQUFFLEVBQUU7SUFDZixXQUFXLEVBQUUsQ0FBQztJQUNkLGVBQWUsRUFBRSxDQUFDO0NBQ25CLENBQUMsQ0FBQztBQUVILEdBQUcsQ0FBQyxLQUFLLEVBQUUsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEFwcCwgVGVycmFmb3JtU3RhY2sgfSBmcm9tICdjZGt0Zic7XG5pbXBvcnQgeyBDbHVzdGVyIH0gZnJvbSAnLic7XG5cbmNvbnN0IGFwcCA9IG5ldyBBcHAoKTtcblxuY29uc3Qgc3RhY2sgPSBuZXcgVGVycmFmb3JtU3RhY2soYXBwLCAnY2RrdGYtZWtzLWRlbW8nKTtcblxuY29uc3QgY2x1c3RlciA9IG5ldyBDbHVzdGVyKHN0YWNrLCAnRWNzQ2x1c3RlcicpO1xuXG5jbHVzdGVyLmFkZEFzZ0NhcGFjaXR5KCdBU0dDYXBhY2l0eScsIHtcbiAgbWF4Q2FwYWNpdHk6IDEwLFxuICBtaW5DYXBhY2l0eTogMCxcbiAgZGVzaXJlZENhcGFjaXR5OiAyLFxufSk7XG5cbmFwcC5zeW50aCgpO1xuIl19