"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cluster = exports.ClusterProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const provider_aws_1 = require("@cdktf/provider-aws");
const cdktf_1 = require("cdktf");
const constructs_1 = require("constructs");
const _1 = require(".");
const awsEcs = require("./imports/modules/terraform-aws-modules/ecs/aws");
const awsVpc = require("./imports/modules/terraform-aws-modules/vpc/aws");
/**
 * @stability stable
 */
class ClusterProps {
}
exports.ClusterProps = ClusterProps;
_a = JSII_RTTI_SYMBOL_1;
ClusterProps[_a] = { fqn: "@pahud/cdktf-aws-ecs.ClusterProps", version: "0.1.3" };
/**
 * @stability stable
 */
class Cluster extends constructs_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props = {}) {
        var _c, _d;
        super(scope, id);
        this.id = id;
        this.props = props;
        this.region = (_c = props.region) !== null && _c !== void 0 ? _c : 'us-east-1';
        new provider_aws_1.AwsProvider(this, 'aws', { region: this.region });
        this.clusterName = (_d = props.name) !== null && _d !== void 0 ? _d : `${id}-cluster`;
        // no private subnets given
        if (!props.vpcSubnets) {
            const vpc = this._createVpc();
            this.vpc = vpc;
            this.vpcId = cdktf_1.Token.asString(vpc.vpcIdOutput);
            this.vpcSubnets = cdktf_1.Token.asList(vpc.privateSubnetsOutput);
        }
        else {
            this.vpcSubnets = props.vpcSubnets;
        }
        // cluster
        new awsEcs.TerraformAwsModulesEcsAws(this, 'Cluster', {
            name: this.clusterName,
        });
    }
    _createContainerServiceforEC2Role() {
        const role = new provider_aws_1.IamRole(this, 'ecs-instance-role', {
            name: `${this.id}-ecs-instance-role`,
            // name: 'ecs-instance-role',
            assumeRolePolicy: JSON.stringify({
                Version: '2012-10-17',
                Statement: [
                    {
                        Action: 'sts:AssumeRole',
                        Effect: 'Allow',
                        Sid: '',
                        Principal: {
                            Service: 'ec2.amazonaws.com',
                        },
                    },
                ],
            }),
        });
        new provider_aws_1.IamPolicyAttachment(this, ' AmazonEC2ContainerServiceforEC2RoleAttachment', {
            name: 'AmazonEC2ContainerServiceforEC2RoleAttachment',
            policyArn: 'arn:aws:iam::aws:policy/service-role/AmazonEC2ContainerServiceforEC2Role',
            roles: [role.name],
        });
        return role;
    }
    _createIamInstanceProfile(roleName) {
        return new provider_aws_1.IamInstanceProfile(this, 'InstanceProfile', {
            role: roleName,
        });
    }
    _createVpc() {
        const vpc = new awsVpc.TerraformAwsModulesVpcAws(this, 'Vpc', {
            cidr: '10.0.0.0/16',
            azs: new provider_aws_1.DataAwsAvailabilityZones(this, 'AZs', {
                state: 'available',
            }).names,
            publicSubnets: ['10.0.1.0/24', '10.0.2.0/24', '10.0.3.0/24'],
            privateSubnets: ['10.0.11.0/24', '10.0.12.0/24', '10.0.13.0/24'],
            singleNatGateway: true,
            enableNatGateway: true,
            oneNatGatewayPerAz: false,
        });
        return vpc;
    }
    _createLaunchTemplate(instanceProfileArn) {
        var _c;
        return new provider_aws_1.LaunchTemplate(this, 'LT', {
            imageId: new _1.EcsOptimizedAmi(this, {
                generation: _1.AmazonLinuxGeneration.AMAZON_LINUX_2,
            }).amiId,
            iamInstanceProfile: [{ arn: instanceProfileArn }],
            instanceType: (_c = this.props.instanceType) !== null && _c !== void 0 ? _c : 't3.large',
        });
    }
    /**
     * @stability stable
     */
    addAsgCapacity(id, options) {
        var _c, _d, _e;
        const instanceRole = this._createContainerServiceforEC2Role();
        const instanceProfile = this._createIamInstanceProfile(instanceRole.name);
        const lt = this._createLaunchTemplate(instanceProfile.arn);
        let userData = `#!/bin/bash\necho ECS_CLUSTER=${this.clusterName} > /etc/ecs/ecs.config`;
        let b64userdata = Buffer.from(userData).toString('base64');
        lt.addOverride('user_data', b64userdata);
        const minCapacity = (_c = options.minCapacity) !== null && _c !== void 0 ? _c : 0;
        const desiredCapacity = (_d = options.desiredCapacity) !== null && _d !== void 0 ? _d : minCapacity;
        const maxCapacity = ((_e = options.maxCapacity) !== null && _e !== void 0 ? _e : (desiredCapacity > 0)) ?
            desiredCapacity : 1;
        const asg = new provider_aws_1.AutoscalingGroup(this, `${id}-ASG`, {
            maxSize: maxCapacity,
            desiredCapacity: desiredCapacity,
            minSize: minCapacity,
            vpcZoneIdentifier: this.vpcSubnets,
            launchTemplate: [
                {
                    id: lt.id,
                },
            ],
        });
        new provider_aws_1.EcsCapacityProvider(this, 'EcsCapacityProvider', {
            name: `cp-${this.id}`,
            autoScalingGroupProvider: [
                {
                    autoScalingGroupArn: asg.arn,
                },
            ],
        });
    }
}
exports.Cluster = Cluster;
_b = JSII_RTTI_SYMBOL_1;
Cluster[_b] = { fqn: "@pahud/cdktf-aws-ecs.Cluster", version: "0.1.3" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2x1c3Rlci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9jbHVzdGVyLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsc0RBQTJMO0FBQzNMLGlDQUE4QjtBQUM5QiwyQ0FBdUM7QUFDdkMsd0JBQTJEO0FBQzNELDBFQUEwRTtBQUMxRSwwRUFBMEU7Ozs7QUFHMUUsTUFBYSxZQUFZOztBQUF6QixvQ0FRQzs7Ozs7O0FBUUQsTUFBYSxPQUFRLFNBQVEsc0JBQVM7Ozs7SUFRcEMsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxRQUFzQixFQUFFOztRQUNoRSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRWpCLElBQUksQ0FBQyxFQUFFLEdBQUcsRUFBRSxDQUFDO1FBQ2IsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUM7UUFDbkIsSUFBSSxDQUFDLE1BQU0sU0FBRyxLQUFLLENBQUMsTUFBTSxtQ0FBSSxXQUFXLENBQUM7UUFDMUMsSUFBSSwwQkFBVyxDQUFDLElBQUksRUFBRSxLQUFLLEVBQUUsRUFBRSxNQUFNLEVBQUUsSUFBSSxDQUFDLE1BQU0sRUFBRSxDQUFDLENBQUM7UUFFdEQsSUFBSSxDQUFDLFdBQVcsU0FBRyxLQUFLLENBQUMsSUFBSSxtQ0FBSSxHQUFHLEVBQUUsVUFBVSxDQUFDO1FBRWpELDJCQUEyQjtRQUMzQixJQUFJLENBQUMsS0FBSyxDQUFDLFVBQVUsRUFBRTtZQUNyQixNQUFNLEdBQUcsR0FBRyxJQUFJLENBQUMsVUFBVSxFQUFFLENBQUM7WUFDOUIsSUFBSSxDQUFDLEdBQUcsR0FBRyxHQUFHLENBQUM7WUFDZixJQUFJLENBQUMsS0FBSyxHQUFHLGFBQUssQ0FBQyxRQUFRLENBQUMsR0FBRyxDQUFDLFdBQVcsQ0FBQyxDQUFDO1lBQzdDLElBQUksQ0FBQyxVQUFVLEdBQUcsYUFBSyxDQUFDLE1BQU0sQ0FBQyxHQUFHLENBQUMsb0JBQW9CLENBQUMsQ0FBQztTQUMxRDthQUFNO1lBQ0wsSUFBSSxDQUFDLFVBQVUsR0FBRyxLQUFLLENBQUMsVUFBVyxDQUFDO1NBQ3JDO1FBRUQsVUFBVTtRQUNWLElBQUksTUFBTSxDQUFDLHlCQUF5QixDQUFDLElBQUksRUFBRSxTQUFTLEVBQUU7WUFDcEQsSUFBSSxFQUFFLElBQUksQ0FBQyxXQUFXO1NBQ3ZCLENBQUMsQ0FBQztJQUNMLENBQUM7SUFDTyxpQ0FBaUM7UUFDdkMsTUFBTSxJQUFJLEdBQUcsSUFBSSxzQkFBTyxDQUFDLElBQUksRUFBRSxtQkFBbUIsRUFBRTtZQUNsRCxJQUFJLEVBQUUsR0FBRyxJQUFJLENBQUMsRUFBRSxvQkFBb0I7WUFDcEMsNkJBQTZCO1lBQzdCLGdCQUFnQixFQUFFLElBQUksQ0FBQyxTQUFTLENBQUM7Z0JBQy9CLE9BQU8sRUFBRSxZQUFZO2dCQUNyQixTQUFTLEVBQUU7b0JBQ1Q7d0JBQ0UsTUFBTSxFQUFFLGdCQUFnQjt3QkFDeEIsTUFBTSxFQUFFLE9BQU87d0JBQ2YsR0FBRyxFQUFFLEVBQUU7d0JBQ1AsU0FBUyxFQUFFOzRCQUNULE9BQU8sRUFBRSxtQkFBbUI7eUJBQzdCO3FCQUNGO2lCQUNGO2FBQ0YsQ0FBQztTQUNILENBQUMsQ0FBQztRQUNILElBQUksa0NBQW1CLENBQUMsSUFBSSxFQUFFLGdEQUFnRCxFQUFFO1lBQzlFLElBQUksRUFBRSwrQ0FBK0M7WUFDckQsU0FBUyxFQUFFLDBFQUEwRTtZQUNyRixLQUFLLEVBQUUsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDO1NBQ25CLENBQUMsQ0FBQztRQUNILE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUNPLHlCQUF5QixDQUFDLFFBQWdCO1FBQ2hELE9BQU8sSUFBSSxpQ0FBa0IsQ0FBQyxJQUFJLEVBQUUsaUJBQWlCLEVBQUU7WUFDckQsSUFBSSxFQUFFLFFBQVE7U0FDZixDQUFDLENBQUM7SUFDTCxDQUFDO0lBQ08sVUFBVTtRQUNoQixNQUFNLEdBQUcsR0FBRyxJQUFJLE1BQU0sQ0FBQyx5QkFBeUIsQ0FBQyxJQUFJLEVBQUUsS0FBSyxFQUFFO1lBQzVELElBQUksRUFBRSxhQUFhO1lBQ25CLEdBQUcsRUFBRSxJQUFJLHVDQUFFLENBQUMsSUFBSSxFQUFFLEtBQUssRUFBRTtnQkFDdkIsS0FBSyxFQUFFLFdBQVc7YUFDbkIsQ0FBQyxDQUFDLEtBQUs7WUFDUixhQUFhLEVBQUUsQ0FBQyxhQUFhLEVBQUUsYUFBYSxFQUFFLGFBQWEsQ0FBQztZQUM1RCxjQUFjLEVBQUUsQ0FBQyxjQUFjLEVBQUUsY0FBYyxFQUFFLGNBQWMsQ0FBQztZQUNoRSxnQkFBZ0IsRUFBRSxJQUFJO1lBQ3RCLGdCQUFnQixFQUFFLElBQUk7WUFDdEIsa0JBQWtCLEVBQUUsS0FBSztTQUMxQixDQUFDLENBQUM7UUFDSCxPQUFPLEdBQUcsQ0FBQztJQUNiLENBQUM7SUFDTyxxQkFBcUIsQ0FBQyxrQkFBMEI7O1FBQ3RELE9BQU8sSUFBSSw2QkFBYyxDQUFDLElBQUksRUFBRSxJQUFJLEVBQUU7WUFDcEMsT0FBTyxFQUFFLElBQUksa0JBQWUsQ0FBQyxJQUFJLEVBQUU7Z0JBQ2pDLFVBQVUsRUFBRSx3QkFBcUIsQ0FBQyxjQUFjO2FBQ2pELENBQUMsQ0FBQyxLQUFLO1lBQ1Isa0JBQWtCLEVBQUUsQ0FBQyxFQUFFLEdBQUcsRUFBRSxrQkFBa0IsRUFBRSxDQUFDO1lBQ2pELFlBQVksUUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLFlBQVksbUNBQUksVUFBVTtTQUNwRCxDQUFDLENBQUM7SUFDTCxDQUFDOzs7O0lBQ00sY0FBYyxDQUFDLEVBQVUsRUFBRSxPQUEyQjs7UUFDM0QsTUFBTSxZQUFZLEdBQUcsSUFBSSxDQUFDLGlDQUFpQyxFQUFFLENBQUM7UUFDOUQsTUFBTSxlQUFlLEdBQUcsSUFBSSxDQUFDLHlCQUF5QixDQUFDLFlBQVksQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUMxRSxNQUFNLEVBQUUsR0FBRyxJQUFJLENBQUMscUJBQXFCLENBQUMsZUFBZSxDQUFDLEdBQUcsQ0FBQyxDQUFDO1FBQzNELElBQUksUUFBUSxHQUFHLGlDQUFpQyxJQUFJLENBQUMsV0FBVyx3QkFBd0IsQ0FBQztRQUN6RixJQUFJLFdBQVcsR0FBRyxNQUFNLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxDQUFDLFFBQVEsQ0FBQyxRQUFRLENBQUMsQ0FBQztRQUMzRCxFQUFFLENBQUMsV0FBVyxDQUFDLFdBQVcsRUFBRSxXQUFXLENBQUMsQ0FBQztRQUV6QyxNQUFNLFdBQVcsU0FBRyxPQUFPLENBQUMsV0FBVyxtQ0FBSSxDQUFDLENBQUM7UUFDN0MsTUFBTSxlQUFlLFNBQUcsT0FBTyxDQUFDLGVBQWUsbUNBQUksV0FBVyxDQUFDO1FBQy9ELE1BQU0sV0FBVyxHQUFHLE9BQUEsT0FBTyxDQUFDLFdBQVcsbUNBQUksQ0FBQyxlQUFlLEdBQUcsQ0FBQyxDQUFDLEVBQUMsQ0FBQztZQUNoRSxlQUFlLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztRQUV0QixNQUFNLEdBQUcsR0FBRyxJQUFJLCtCQUFnQixDQUFDLElBQUksRUFBRSxHQUFHLEVBQUUsTUFBTSxFQUFFO1lBQ2xELE9BQU8sRUFBRSxXQUFXO1lBQ3BCLGVBQWUsRUFBRSxlQUFlO1lBQ2hDLE9BQU8sRUFBRSxXQUFXO1lBQ3BCLGlCQUFpQixFQUFFLElBQUksQ0FBQyxVQUFVO1lBQ2xDLGNBQWMsRUFBRTtnQkFDZDtvQkFDRSxFQUFFLEVBQUUsRUFBRSxDQUFDLEVBQUU7aUJBQ1Y7YUFDRjtTQUNGLENBQUMsQ0FBQztRQUNILElBQUksa0NBQW1CLENBQUMsSUFBSSxFQUFFLHFCQUFxQixFQUFFO1lBQ25ELElBQUksRUFBRSxNQUFNLElBQUksQ0FBQyxFQUFFLEVBQUU7WUFDckIsd0JBQXdCLEVBQUU7Z0JBQ3hCO29CQUNFLG1CQUFtQixFQUFFLEdBQUcsQ0FBQyxHQUFHO2lCQUM3QjthQUNGO1NBQ0YsQ0FBQyxDQUFDO0lBQ0wsQ0FBQzs7QUF0SEgsMEJBdUhDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQXdzUHJvdmlkZXIsIEF1dG9zY2FsaW5nR3JvdXAsIEVjc0NhcGFjaXR5UHJvdmlkZXIsIExhdW5jaFRlbXBsYXRlLCBJYW1Sb2xlLCBJYW1JbnN0YW5jZVByb2ZpbGUsIElhbVBvbGljeUF0dGFjaG1lbnQsIERhdGFBd3NBdmFpbGFiaWxpdHlab25lcyBhcyBBWiB9IGZyb20gJ0BjZGt0Zi9wcm92aWRlci1hd3MnO1xuaW1wb3J0IHsgVG9rZW4gfSBmcm9tICdjZGt0Zic7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCB7IEFtYXpvbkxpbnV4R2VuZXJhdGlvbiwgRWNzT3B0aW1pemVkQW1pIH0gZnJvbSAnLic7XG5pbXBvcnQgKiBhcyBhd3NFY3MgZnJvbSAnLi9pbXBvcnRzL21vZHVsZXMvdGVycmFmb3JtLWF3cy1tb2R1bGVzL2Vjcy9hd3MnO1xuaW1wb3J0ICogYXMgYXdzVnBjIGZyb20gJy4vaW1wb3J0cy9tb2R1bGVzL3RlcnJhZm9ybS1hd3MtbW9kdWxlcy92cGMvYXdzJztcblxuXG5leHBvcnQgY2xhc3MgQ2x1c3RlclByb3BzIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSByZWdpb24/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IG5hbWU/OiBzdHJpbmc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgaW5zdGFuY2VUeXBlPzogc3RyaW5nO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHZwY1N1Ym5ldHM/OiBzdHJpbmdbXTtcbn1cblxuZXhwb3J0IGludGVyZmFjZSBBc2dDYXBhY2l0eU9wdGlvbnMge1xuICByZWFkb25seSBtYXhDYXBhY2l0eT86IG51bWJlcjtcbiAgcmVhZG9ubHkgbWluQ2FwYWNpdHk/OiBudW1iZXI7XG4gIHJlYWRvbmx5IGRlc2lyZWRDYXBhY2l0eT86IG51bWJlcjtcbn1cblxuZXhwb3J0IGNsYXNzIENsdXN0ZXIgZXh0ZW5kcyBDb25zdHJ1Y3Qge1xuICByZWFkb25seSByZWdpb246IHN0cmluZztcbiAgcmVhZG9ubHkgY2x1c3Rlck5hbWU6IHN0cmluZztcbiAgcmVhZG9ubHkgdnBjPzogYW55O1xuICByZWFkb25seSB2cGNJZD86IHN0cmluZztcbiAgcHJpdmF0ZSByZWFkb25seSBpZDogc3RyaW5nO1xuICBwcml2YXRlIHJlYWRvbmx5IHZwY1N1Ym5ldHM6IHN0cmluZ1tdO1xuICBwcml2YXRlIHJlYWRvbmx5IHByb3BzOiBDbHVzdGVyUHJvcHM7XG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBDbHVzdGVyUHJvcHMgPSB7fSkge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICB0aGlzLmlkID0gaWQ7XG4gICAgdGhpcy5wcm9wcyA9IHByb3BzO1xuICAgIHRoaXMucmVnaW9uID0gcHJvcHMucmVnaW9uID8/ICd1cy1lYXN0LTEnO1xuICAgIG5ldyBBd3NQcm92aWRlcih0aGlzLCAnYXdzJywgeyByZWdpb246IHRoaXMucmVnaW9uIH0pO1xuXG4gICAgdGhpcy5jbHVzdGVyTmFtZSA9IHByb3BzLm5hbWUgPz8gYCR7aWR9LWNsdXN0ZXJgO1xuXG4gICAgLy8gbm8gcHJpdmF0ZSBzdWJuZXRzIGdpdmVuXG4gICAgaWYgKCFwcm9wcy52cGNTdWJuZXRzKSB7XG4gICAgICBjb25zdCB2cGMgPSB0aGlzLl9jcmVhdGVWcGMoKTtcbiAgICAgIHRoaXMudnBjID0gdnBjO1xuICAgICAgdGhpcy52cGNJZCA9IFRva2VuLmFzU3RyaW5nKHZwYy52cGNJZE91dHB1dCk7XG4gICAgICB0aGlzLnZwY1N1Ym5ldHMgPSBUb2tlbi5hc0xpc3QodnBjLnByaXZhdGVTdWJuZXRzT3V0cHV0KTtcbiAgICB9IGVsc2Uge1xuICAgICAgdGhpcy52cGNTdWJuZXRzID0gcHJvcHMudnBjU3VibmV0cyE7XG4gICAgfVxuXG4gICAgLy8gY2x1c3RlclxuICAgIG5ldyBhd3NFY3MuVGVycmFmb3JtQXdzTW9kdWxlc0Vjc0F3cyh0aGlzLCAnQ2x1c3RlcicsIHtcbiAgICAgIG5hbWU6IHRoaXMuY2x1c3Rlck5hbWUsXG4gICAgfSk7XG4gIH1cbiAgcHJpdmF0ZSBfY3JlYXRlQ29udGFpbmVyU2VydmljZWZvckVDMlJvbGUoKTogSWFtUm9sZSB7XG4gICAgY29uc3Qgcm9sZSA9IG5ldyBJYW1Sb2xlKHRoaXMsICdlY3MtaW5zdGFuY2Utcm9sZScsIHtcbiAgICAgIG5hbWU6IGAke3RoaXMuaWR9LWVjcy1pbnN0YW5jZS1yb2xlYCxcbiAgICAgIC8vIG5hbWU6ICdlY3MtaW5zdGFuY2Utcm9sZScsXG4gICAgICBhc3N1bWVSb2xlUG9saWN5OiBKU09OLnN0cmluZ2lmeSh7XG4gICAgICAgIFZlcnNpb246ICcyMDEyLTEwLTE3JyxcbiAgICAgICAgU3RhdGVtZW50OiBbXG4gICAgICAgICAge1xuICAgICAgICAgICAgQWN0aW9uOiAnc3RzOkFzc3VtZVJvbGUnLFxuICAgICAgICAgICAgRWZmZWN0OiAnQWxsb3cnLFxuICAgICAgICAgICAgU2lkOiAnJyxcbiAgICAgICAgICAgIFByaW5jaXBhbDoge1xuICAgICAgICAgICAgICBTZXJ2aWNlOiAnZWMyLmFtYXpvbmF3cy5jb20nLFxuICAgICAgICAgICAgfSxcbiAgICAgICAgICB9LFxuICAgICAgICBdLFxuICAgICAgfSksXG4gICAgfSk7XG4gICAgbmV3IElhbVBvbGljeUF0dGFjaG1lbnQodGhpcywgJyBBbWF6b25FQzJDb250YWluZXJTZXJ2aWNlZm9yRUMyUm9sZUF0dGFjaG1lbnQnLCB7XG4gICAgICBuYW1lOiAnQW1hem9uRUMyQ29udGFpbmVyU2VydmljZWZvckVDMlJvbGVBdHRhY2htZW50JyxcbiAgICAgIHBvbGljeUFybjogJ2Fybjphd3M6aWFtOjphd3M6cG9saWN5L3NlcnZpY2Utcm9sZS9BbWF6b25FQzJDb250YWluZXJTZXJ2aWNlZm9yRUMyUm9sZScsXG4gICAgICByb2xlczogW3JvbGUubmFtZV0sXG4gICAgfSk7XG4gICAgcmV0dXJuIHJvbGU7XG4gIH1cbiAgcHJpdmF0ZSBfY3JlYXRlSWFtSW5zdGFuY2VQcm9maWxlKHJvbGVOYW1lOiBzdHJpbmcpOiBJYW1JbnN0YW5jZVByb2ZpbGUge1xuICAgIHJldHVybiBuZXcgSWFtSW5zdGFuY2VQcm9maWxlKHRoaXMsICdJbnN0YW5jZVByb2ZpbGUnLCB7XG4gICAgICByb2xlOiByb2xlTmFtZSxcbiAgICB9KTtcbiAgfVxuICBwcml2YXRlIF9jcmVhdGVWcGMoKSB7XG4gICAgY29uc3QgdnBjID0gbmV3IGF3c1ZwYy5UZXJyYWZvcm1Bd3NNb2R1bGVzVnBjQXdzKHRoaXMsICdWcGMnLCB7XG4gICAgICBjaWRyOiAnMTAuMC4wLjAvMTYnLFxuICAgICAgYXpzOiBuZXcgQVoodGhpcywgJ0FacycsIHtcbiAgICAgICAgc3RhdGU6ICdhdmFpbGFibGUnLFxuICAgICAgfSkubmFtZXMsXG4gICAgICBwdWJsaWNTdWJuZXRzOiBbJzEwLjAuMS4wLzI0JywgJzEwLjAuMi4wLzI0JywgJzEwLjAuMy4wLzI0J10sXG4gICAgICBwcml2YXRlU3VibmV0czogWycxMC4wLjExLjAvMjQnLCAnMTAuMC4xMi4wLzI0JywgJzEwLjAuMTMuMC8yNCddLFxuICAgICAgc2luZ2xlTmF0R2F0ZXdheTogdHJ1ZSxcbiAgICAgIGVuYWJsZU5hdEdhdGV3YXk6IHRydWUsXG4gICAgICBvbmVOYXRHYXRld2F5UGVyQXo6IGZhbHNlLFxuICAgIH0pO1xuICAgIHJldHVybiB2cGM7XG4gIH1cbiAgcHJpdmF0ZSBfY3JlYXRlTGF1bmNoVGVtcGxhdGUoaW5zdGFuY2VQcm9maWxlQXJuOiBzdHJpbmcpOiBMYXVuY2hUZW1wbGF0ZSB7XG4gICAgcmV0dXJuIG5ldyBMYXVuY2hUZW1wbGF0ZSh0aGlzLCAnTFQnLCB7XG4gICAgICBpbWFnZUlkOiBuZXcgRWNzT3B0aW1pemVkQW1pKHRoaXMsIHtcbiAgICAgICAgZ2VuZXJhdGlvbjogQW1hem9uTGludXhHZW5lcmF0aW9uLkFNQVpPTl9MSU5VWF8yLFxuICAgICAgfSkuYW1pSWQsXG4gICAgICBpYW1JbnN0YW5jZVByb2ZpbGU6IFt7IGFybjogaW5zdGFuY2VQcm9maWxlQXJuIH1dLFxuICAgICAgaW5zdGFuY2VUeXBlOiB0aGlzLnByb3BzLmluc3RhbmNlVHlwZSA/PyAndDMubGFyZ2UnLFxuICAgIH0pO1xuICB9XG4gIHB1YmxpYyBhZGRBc2dDYXBhY2l0eShpZDogc3RyaW5nLCBvcHRpb25zOiBBc2dDYXBhY2l0eU9wdGlvbnMpIHtcbiAgICBjb25zdCBpbnN0YW5jZVJvbGUgPSB0aGlzLl9jcmVhdGVDb250YWluZXJTZXJ2aWNlZm9yRUMyUm9sZSgpO1xuICAgIGNvbnN0IGluc3RhbmNlUHJvZmlsZSA9IHRoaXMuX2NyZWF0ZUlhbUluc3RhbmNlUHJvZmlsZShpbnN0YW5jZVJvbGUubmFtZSk7XG4gICAgY29uc3QgbHQgPSB0aGlzLl9jcmVhdGVMYXVuY2hUZW1wbGF0ZShpbnN0YW5jZVByb2ZpbGUuYXJuKTtcbiAgICBsZXQgdXNlckRhdGEgPSBgIyEvYmluL2Jhc2hcXG5lY2hvIEVDU19DTFVTVEVSPSR7dGhpcy5jbHVzdGVyTmFtZX0gPiAvZXRjL2Vjcy9lY3MuY29uZmlnYDtcbiAgICBsZXQgYjY0dXNlcmRhdGEgPSBCdWZmZXIuZnJvbSh1c2VyRGF0YSkudG9TdHJpbmcoJ2Jhc2U2NCcpO1xuICAgIGx0LmFkZE92ZXJyaWRlKCd1c2VyX2RhdGEnLCBiNjR1c2VyZGF0YSk7XG5cbiAgICBjb25zdCBtaW5DYXBhY2l0eSA9IG9wdGlvbnMubWluQ2FwYWNpdHkgPz8gMDtcbiAgICBjb25zdCBkZXNpcmVkQ2FwYWNpdHkgPSBvcHRpb25zLmRlc2lyZWRDYXBhY2l0eSA/PyBtaW5DYXBhY2l0eTtcbiAgICBjb25zdCBtYXhDYXBhY2l0eSA9IG9wdGlvbnMubWF4Q2FwYWNpdHkgPz8gKGRlc2lyZWRDYXBhY2l0eSA+IDApID9cbiAgICAgIGRlc2lyZWRDYXBhY2l0eSA6IDE7XG5cbiAgICBjb25zdCBhc2cgPSBuZXcgQXV0b3NjYWxpbmdHcm91cCh0aGlzLCBgJHtpZH0tQVNHYCwge1xuICAgICAgbWF4U2l6ZTogbWF4Q2FwYWNpdHksXG4gICAgICBkZXNpcmVkQ2FwYWNpdHk6IGRlc2lyZWRDYXBhY2l0eSxcbiAgICAgIG1pblNpemU6IG1pbkNhcGFjaXR5LFxuICAgICAgdnBjWm9uZUlkZW50aWZpZXI6IHRoaXMudnBjU3VibmV0cyxcbiAgICAgIGxhdW5jaFRlbXBsYXRlOiBbXG4gICAgICAgIHtcbiAgICAgICAgICBpZDogbHQuaWQsXG4gICAgICAgIH0sXG4gICAgICBdLFxuICAgIH0pO1xuICAgIG5ldyBFY3NDYXBhY2l0eVByb3ZpZGVyKHRoaXMsICdFY3NDYXBhY2l0eVByb3ZpZGVyJywge1xuICAgICAgbmFtZTogYGNwLSR7dGhpcy5pZH1gLFxuICAgICAgYXV0b1NjYWxpbmdHcm91cFByb3ZpZGVyOiBbXG4gICAgICAgIHtcbiAgICAgICAgICBhdXRvU2NhbGluZ0dyb3VwQXJuOiBhc2cuYXJuLFxuICAgICAgICB9LFxuICAgICAgXSxcbiAgICB9KTtcbiAgfVxufVxuIl19