import { Construct } from 'constructs';
/**
 * @stability stable
 */
export declare class ClusterProps {
    /**
     * The AWS region to deploy.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * @stability stable
     */
    readonly name?: string;
    /**
     * instance type for the default capacity.
     *
     * @default t3.large
     * @stability stable
     */
    readonly instanceType?: string;
    /**
     * VPC subnet IDs for the container instances.
     *
     * @default - private subnets of a new VPC.
     * @stability stable
     */
    readonly vpcSubnets?: string[];
}
/**
 * @stability stable
 */
export interface AsgCapacityOptions {
    /**
     * @stability stable
     */
    readonly maxCapacity?: number;
    /**
     * @stability stable
     */
    readonly minCapacity?: number;
    /**
     * @stability stable
     */
    readonly desiredCapacity?: number;
}
/**
 * @stability stable
 */
export declare class Cluster extends Construct {
    /**
     * @stability stable
     */
    readonly region: string;
    /**
     * @stability stable
     */
    readonly clusterName: string;
    /**
     * @stability stable
     */
    readonly vpc?: any;
    /**
     * @stability stable
     */
    readonly vpcId?: string;
    private readonly id;
    private readonly vpcSubnets;
    private readonly props;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props?: ClusterProps);
    private _createContainerServiceforEC2Role;
    private _createIamInstanceProfile;
    private _createVpc;
    private _createLaunchTemplate;
    /**
     * @stability stable
     */
    addAsgCapacity(id: string, options: AsgCapacityOptions): void;
}
