"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EcsOptimizedAmi = exports.AmiHardwareType = exports.AmazonLinuxGeneration = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const _1 = require(".");
/**
 * @stability stable
 */
var AmazonLinuxGeneration;
(function (AmazonLinuxGeneration) {
    AmazonLinuxGeneration[AmazonLinuxGeneration["AMAZON_LINUX"] = 0] = "AMAZON_LINUX";
    AmazonLinuxGeneration[AmazonLinuxGeneration["AMAZON_LINUX_2"] = 1] = "AMAZON_LINUX_2";
})(AmazonLinuxGeneration = exports.AmazonLinuxGeneration || (exports.AmazonLinuxGeneration = {}));
/**
 * @stability stable
 */
var AmiHardwareType;
(function (AmiHardwareType) {
    AmiHardwareType["STANDARD"] = "Standard";
    AmiHardwareType["GPU"] = "GPU";
    AmiHardwareType["ARM"] = "ARM64";
})(AmiHardwareType = exports.AmiHardwareType || (exports.AmiHardwareType = {}));
/**
 * @stability stable
 */
class EcsOptimizedAmi {
    /**
     * @stability stable
     */
    constructor(scope, props) {
        var _b, _c;
        this.generation = (_b = props === null || props === void 0 ? void 0 : props.generation) !== null && _b !== void 0 ? _b : AmazonLinuxGeneration.AMAZON_LINUX_2,
            this.hwType = (_c = props === null || props === void 0 ? void 0 : props.hwtype) !== null && _c !== void 0 ? _c : AmiHardwareType.STANDARD,
            this.scope = scope;
        // set the SSM parameter name
        this.amiParameterName = '/aws/service/ecs/optimized-ami/'
            + (this.generation === AmazonLinuxGeneration.AMAZON_LINUX ? 'amazon-linux/' : '')
            + (this.generation === AmazonLinuxGeneration.AMAZON_LINUX_2 ? 'amazon-linux-2/' : '')
            + (this.hwType === AmiHardwareType.GPU ? 'gpu/' : '')
            + (this.hwType === AmiHardwareType.ARM ? 'arm64/' : '')
            + 'recommended/image_id';
    }
    /**
     * Return the correct image.
     *
     * @stability stable
     */
    get amiId() {
        return lookupImage(this.scope, 'EcsOptimizedAmiId', this.amiParameterName);
    }
}
exports.EcsOptimizedAmi = EcsOptimizedAmi;
_a = JSII_RTTI_SYMBOL_1;
EcsOptimizedAmi[_a] = { fqn: "@pahud/cdktf-aws-ecs.EcsOptimizedAmi", version: "0.1.3" };
function lookupImage(scope, id, parameterName) {
    return _1.StringParameter.valueFromLookup(scope, id, parameterName);
}
//# sourceMappingURL=data:application/json;base64,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