import { Construct } from 'constructs';
/**
 * @stability stable
 */
export declare enum AmazonLinuxGeneration {
    /**
     * @stability stable
     */
    AMAZON_LINUX = 0,
    /**
     * @stability stable
     */
    AMAZON_LINUX_2 = 1
}
/**
 * @stability stable
 */
export declare enum AmiHardwareType {
    /**
     * Use the standard Amazon ECS-optimized AMI.
     *
     * @stability stable
     */
    STANDARD = "Standard",
    /**
     * Use the Amazon ECS GPU-optimized AMI.
     *
     * @stability stable
     */
    GPU = "GPU",
    /**
     * Use the Amazon ECS-optimized Amazon Linux 2 (arm64) AMI.
     *
     * @stability stable
     */
    ARM = "ARM64"
}
/**
 * @stability stable
 */
export interface EcsOptimizedAmiProps {
    /**
     * @stability stable
     */
    readonly generation?: AmazonLinuxGeneration;
    /**
     * @stability stable
     */
    readonly hwtype?: AmiHardwareType;
}
/**
 * @stability stable
 */
export declare class EcsOptimizedAmi {
    /**
     * @stability stable
     */
    readonly amiParameterName: string;
    /**
     * @stability stable
     */
    readonly generation: AmazonLinuxGeneration;
    /**
     * @stability stable
     */
    readonly hwType: AmiHardwareType;
    /**
     * @stability stable
     */
    readonly scope: Construct;
    /**
     * @stability stable
     */
    constructor(scope: Construct, props?: EcsOptimizedAmiProps);
    /**
     * Return the correct image.
     *
     * @stability stable
     */
    get amiId(): string;
}
