"""
This type stub file was generated by pyright.
"""

from typing import Dict

logger = ...
def get_allowed_tasks(tasks_dict): # -> list[Unknown]:
    ...

def push_to_hub(model_id: str, task_type: str, dataset_type: str, dataset_name: str, metric_type: str, metric_name: str, metric_value: float, task_name: str = ..., dataset_config: str = ..., dataset_split: str = ..., dataset_revision: str = ..., dataset_args: Dict[str, int] = ..., metric_config: str = ..., metric_args: Dict[str, int] = ..., overwrite: bool = ...): # -> str:
    r"""
    Pushes the result of a metric to the metadata of a model repository in the Hub.

    Args:
        model_id (``str``): Model id from https://hf.co/models.
        task_type (``str``): Task id, refer to
            https://github.com/huggingface/datasets/blob/master/src/datasets/utils/resources/tasks.json for allowed values.
        dataset_type (``str``): Dataset id from https://hf.co/datasets.
        dataset_name (``str``): Pretty name for the dataset.
        metric_type (``str``): Metric id from https://hf.co/metrics.
        metric_name (``str``): Pretty name for the metric.
        metric_value (``float``): Computed metric value.
        task_name (``str``, optional): Pretty name for the task.
        dataset_config (``str``, optional): Dataset configuration used in datasets.load_dataset().
            See huggingface/datasets docs for more info: https://huggingface.co/docs/datasets/package_reference/loading_methods#datasets.load_dataset.name
        dataset_split (``str``, optional): Name of split used for metric computation.
        dataset_revision (``str``, optional): Git hash for the specific version of the dataset.
        dataset_args (``dict[str, int]``, optional): Additional arguments passed to datasets.load_dataset().
        metric_config (``str``, optional): Configuration for the metric (e.g. the GLUE metric has a configuration for each subset)
        metric_args (``dict[str, int]``, optional): Arguments passed during Metric.compute().
        overwrite (``bool``, optional, defaults to `False`): If set to `True` an existing metric field can be overwritten, otherwise
             attempting to overwrite any existing fields will cause an error.

    Example:

    ```python
    >>> push_to_hub(
    ...     model_id="huggingface/gpt2-wikitext2",
    ...     metric_value=0.5
    ...     metric_type="bleu",
    ...     metric_name="BLEU",
    ...     dataset_name="WikiText",
    ...     dataset_type="wikitext",
    ...     dataset_split="test",
    ...     task_type="text-generation",
    ...     task_name="Text Generation"
    ... )
    ```"""
    ...

