"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PerformanceInsightRetention = exports.SnapshotCredentials = exports.Credentials = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Username and password combination
 */
class Credentials {
    /**
     * Creates Credentials with a password generated and stored in Secrets Manager.
     */
    static fromGeneratedSecret(username, options = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_rds_CredentialsBaseOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromGeneratedSecret);
            }
            throw error;
        }
        return {
            ...options,
            username,
            usernameAsString: true,
        };
    }
    /**
     * Creates Credentials from a password
     *
     * Do not put passwords in your CDK code directly.
     */
    static fromPassword(username, password) {
        return {
            username,
            password,
            usernameAsString: true,
        };
    }
    /**
     * Creates Credentials for the given username, and optional password and key.
     * If no password is provided, one will be generated and stored in Secrets Manager.
     */
    static fromUsername(username, options = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_rds_CredentialsFromUsernameOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromUsername);
            }
            throw error;
        }
        return {
            ...options,
            username,
        };
    }
    /**
     * Creates Credentials from an existing Secrets Manager ``Secret`` (or ``DatabaseSecret``)
     *
     * The Secret must be a JSON string with a ``username`` and ``password`` field:
     * ```
     * {
     *   ...
     *   "username": <required: username>,
     *   "password": <required: password>,
     * }
     * ```
     *
     * @param secret The secret where the credentials are stored
     * @param username The username defined in the secret. If specified the username
     *   will be referenced as a string and not a dynamic reference to the username
     *   field in the secret. This allows to replace the secret without replacing the
     *   instance or cluster.
     */
    static fromSecret(secret, username) {
        return {
            username: username !== null && username !== void 0 ? username : secret.secretValueFromJson('username').unsafeUnwrap(),
            password: secret.secretValueFromJson('password'),
            encryptionKey: secret.encryptionKey,
            secret,
        };
    }
}
exports.Credentials = Credentials;
_a = JSII_RTTI_SYMBOL_1;
Credentials[_a] = { fqn: "@aws-cdk/aws-rds.Credentials", version: "1.158.0" };
/**
 * Credentials to update the password for a ``DatabaseInstanceFromSnapshot``.
 */
class SnapshotCredentials {
    /**
     * Generate a new password for the snapshot, using the existing username and an optional encryption key.
     * The new credentials are stored in Secrets Manager.
     *
     * Note - The username must match the existing master username of the snapshot.
     */
    static fromGeneratedSecret(username, options = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_rds_SnapshotCredentialsFromGeneratedPasswordOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromGeneratedSecret);
            }
            throw error;
        }
        return {
            ...options,
            generatePassword: true,
            replaceOnPasswordCriteriaChanges: true,
            username,
        };
    }
    /**
     * Generate a new password for the snapshot, using the existing username and an optional encryption key.
     *
     * Note - The username must match the existing master username of the snapshot.
     *
     * NOTE: use `fromGeneratedSecret()` for new Clusters and Instances. Switching from
     * `fromGeneratedPassword()` to `fromGeneratedSecret()` for already deployed Clusters
     * or Instances will update their master password.
     */
    static fromGeneratedPassword(username, options = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_rds_SnapshotCredentialsFromGeneratedPasswordOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromGeneratedPassword);
            }
            throw error;
        }
        return {
            ...options,
            generatePassword: true,
            username,
        };
    }
    /**
     * Update the snapshot login with an existing password.
     */
    static fromPassword(password) {
        return { generatePassword: false, password };
    }
    /**
     * Update the snapshot login with an existing password from a Secret.
     *
     * The Secret must be a JSON string with a ``password`` field:
     * ```
     * {
     *   ...
     *   "password": <required: password>,
     * }
     * ```
     */
    static fromSecret(secret) {
        return {
            generatePassword: false,
            password: secret.secretValueFromJson('password'),
            secret,
        };
    }
}
exports.SnapshotCredentials = SnapshotCredentials;
_b = JSII_RTTI_SYMBOL_1;
SnapshotCredentials[_b] = { fqn: "@aws-cdk/aws-rds.SnapshotCredentials", version: "1.158.0" };
/**
 * The retention period for Performance Insight.
 */
var PerformanceInsightRetention;
(function (PerformanceInsightRetention) {
    /**
     * Default retention period of 7 days.
     */
    PerformanceInsightRetention[PerformanceInsightRetention["DEFAULT"] = 7] = "DEFAULT";
    /**
     * Long term retention period of 2 years.
     */
    PerformanceInsightRetention[PerformanceInsightRetention["LONG_TERM"] = 731] = "LONG_TERM";
})(PerformanceInsightRetention = exports.PerformanceInsightRetention || (exports.PerformanceInsightRetention = {}));
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicHJvcHMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJwcm9wcy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFzTEE7O0dBRUc7QUFDSCxNQUFzQixXQUFXO0lBQy9COztPQUVHO0lBQ0ksTUFBTSxDQUFDLG1CQUFtQixDQUFDLFFBQWdCLEVBQUUsVUFBa0MsRUFBRTs7Ozs7Ozs7OztRQUN0RixPQUFPO1lBQ0wsR0FBRyxPQUFPO1lBQ1YsUUFBUTtZQUNSLGdCQUFnQixFQUFFLElBQUk7U0FDdkIsQ0FBQztLQUNIO0lBRUQ7Ozs7T0FJRztJQUNJLE1BQU0sQ0FBQyxZQUFZLENBQUMsUUFBZ0IsRUFBRSxRQUFxQjtRQUNoRSxPQUFPO1lBQ0wsUUFBUTtZQUNSLFFBQVE7WUFDUixnQkFBZ0IsRUFBRSxJQUFJO1NBQ3ZCLENBQUM7S0FDSDtJQUVEOzs7T0FHRztJQUNJLE1BQU0sQ0FBQyxZQUFZLENBQUMsUUFBZ0IsRUFBRSxVQUEwQyxFQUFFOzs7Ozs7Ozs7O1FBQ3ZGLE9BQU87WUFDTCxHQUFHLE9BQU87WUFDVixRQUFRO1NBQ1QsQ0FBQztLQUNIO0lBRUQ7Ozs7Ozs7Ozs7Ozs7Ozs7O09BaUJHO0lBQ0ksTUFBTSxDQUFDLFVBQVUsQ0FBQyxNQUE4QixFQUFFLFFBQWlCO1FBQ3hFLE9BQU87WUFDTCxRQUFRLEVBQUUsUUFBUSxhQUFSLFFBQVEsY0FBUixRQUFRLEdBQUksTUFBTSxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQyxDQUFDLFlBQVksRUFBRTtZQUMzRSxRQUFRLEVBQUUsTUFBTSxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQztZQUNoRCxhQUFhLEVBQUUsTUFBTSxDQUFDLGFBQWE7WUFDbkMsTUFBTTtTQUNQLENBQUM7S0FDSDs7QUE3REgsa0NBeUhDOzs7QUE0QkQ7O0dBRUc7QUFDSCxNQUFzQixtQkFBbUI7SUFDdkM7Ozs7O09BS0c7SUFDSSxNQUFNLENBQUMsbUJBQW1CLENBQUMsUUFBZ0IsRUFBRSxVQUEyRCxFQUFFOzs7Ozs7Ozs7O1FBQy9HLE9BQU87WUFDTCxHQUFHLE9BQU87WUFDVixnQkFBZ0IsRUFBRSxJQUFJO1lBQ3RCLGdDQUFnQyxFQUFFLElBQUk7WUFDdEMsUUFBUTtTQUNULENBQUM7S0FDSDtJQUVEOzs7Ozs7OztPQVFHO0lBQ0ksTUFBTSxDQUFDLHFCQUFxQixDQUFDLFFBQWdCLEVBQUUsVUFBMkQsRUFBRTs7Ozs7Ozs7OztRQUNqSCxPQUFPO1lBQ0wsR0FBRyxPQUFPO1lBQ1YsZ0JBQWdCLEVBQUUsSUFBSTtZQUN0QixRQUFRO1NBQ1QsQ0FBQztLQUNIO0lBRUQ7O09BRUc7SUFDSSxNQUFNLENBQUMsWUFBWSxDQUFDLFFBQXFCO1FBQzlDLE9BQU8sRUFBRSxnQkFBZ0IsRUFBRSxLQUFLLEVBQUUsUUFBUSxFQUFFLENBQUM7S0FDOUM7SUFFRDs7Ozs7Ozs7OztPQVVHO0lBQ0ksTUFBTSxDQUFDLFVBQVUsQ0FBQyxNQUE4QjtRQUNyRCxPQUFPO1lBQ0wsZ0JBQWdCLEVBQUUsS0FBSztZQUN2QixRQUFRLEVBQUUsTUFBTSxDQUFDLG1CQUFtQixDQUFDLFVBQVUsQ0FBQztZQUNoRCxNQUFNO1NBQ1AsQ0FBQztLQUNIOztBQXpESCxrREFzSEM7OztBQW9FRDs7R0FFRztBQUNILElBQVksMkJBVVg7QUFWRCxXQUFZLDJCQUEyQjtJQUNyQzs7T0FFRztJQUNILG1GQUFXLENBQUE7SUFFWDs7T0FFRztJQUNILHlGQUFlLENBQUE7QUFDakIsQ0FBQyxFQVZXLDJCQUEyQixHQUEzQixtQ0FBMkIsS0FBM0IsbUNBQTJCLFFBVXRDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgZWMyIGZyb20gJ0Bhd3MtY2RrL2F3cy1lYzInO1xuaW1wb3J0ICogYXMga21zIGZyb20gJ0Bhd3MtY2RrL2F3cy1rbXMnO1xuaW1wb3J0ICogYXMgc2VjcmV0c21hbmFnZXIgZnJvbSAnQGF3cy1jZGsvYXdzLXNlY3JldHNtYW5hZ2VyJztcbmltcG9ydCB7IER1cmF0aW9uLCBTZWNyZXRWYWx1ZSB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0IHsgSVBhcmFtZXRlckdyb3VwIH0gZnJvbSAnLi9wYXJhbWV0ZXItZ3JvdXAnO1xuXG4vKipcbiAqIEluc3RhbmNlIHByb3BlcnRpZXMgZm9yIGRhdGFiYXNlIGluc3RhbmNlc1xuICovXG5leHBvcnQgaW50ZXJmYWNlIEluc3RhbmNlUHJvcHMge1xuICAvKipcbiAgICogV2hhdCB0eXBlIG9mIGluc3RhbmNlIHRvIHN0YXJ0IGZvciB0aGUgcmVwbGljYXMuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gdDMubWVkaXVtIChvciwgbW9yZSBwcmVjaXNlbHksIGRiLnQzLm1lZGl1bSlcbiAgICovXG4gIHJlYWRvbmx5IGluc3RhbmNlVHlwZT86IGVjMi5JbnN0YW5jZVR5cGU7XG5cbiAgLyoqXG4gICAqIFdoYXQgc3VibmV0cyB0byBydW4gdGhlIFJEUyBpbnN0YW5jZXMgaW4uXG4gICAqXG4gICAqIE11c3QgYmUgYXQgbGVhc3QgMiBzdWJuZXRzIGluIHR3byBkaWZmZXJlbnQgQVpzLlxuICAgKi9cbiAgcmVhZG9ubHkgdnBjOiBlYzIuSVZwYztcblxuICAvKipcbiAgICogV2hlcmUgdG8gcGxhY2UgdGhlIGluc3RhbmNlcyB3aXRoaW4gdGhlIFZQQ1xuICAgKlxuICAgKiBAZGVmYXVsdCAtIHRoZSBWcGMgZGVmYXVsdCBzdHJhdGVneSBpZiBub3Qgc3BlY2lmaWVkLlxuICAgKi9cbiAgcmVhZG9ubHkgdnBjU3VibmV0cz86IGVjMi5TdWJuZXRTZWxlY3Rpb247XG5cbiAgLyoqXG4gICAqIFNlY3VyaXR5IGdyb3VwLlxuICAgKlxuICAgKiBAZGVmYXVsdCBhIG5ldyBzZWN1cml0eSBncm91cCBpcyBjcmVhdGVkLlxuICAgKi9cbiAgcmVhZG9ubHkgc2VjdXJpdHlHcm91cHM/OiBlYzIuSVNlY3VyaXR5R3JvdXBbXTtcblxuICAvKipcbiAgICogVGhlIERCIHBhcmFtZXRlciBncm91cCB0byBhc3NvY2lhdGUgd2l0aCB0aGUgaW5zdGFuY2UuXG4gICAqXG4gICAqIEBkZWZhdWx0IG5vIHBhcmFtZXRlciBncm91cFxuICAgKi9cbiAgcmVhZG9ubHkgcGFyYW1ldGVyR3JvdXA/OiBJUGFyYW1ldGVyR3JvdXA7XG5cbiAgLyoqXG4gICAqIFRoZSBwYXJhbWV0ZXJzIGluIHRoZSBEQlBhcmFtZXRlckdyb3VwIHRvIGNyZWF0ZSBhdXRvbWF0aWNhbGx5XG4gICAqXG4gICAqIFlvdSBjYW4gb25seSBzcGVjaWZ5IHBhcmFtZXRlckdyb3VwIG9yIHBhcmFtZXRlcnMgYnV0IG5vdCBib3RoLlxuICAgKiBZb3UgbmVlZCB0byB1c2UgYSB2ZXJzaW9uZWQgZW5naW5lIHRvIGF1dG8tZ2VuZXJhdGUgYSBEQlBhcmFtZXRlckdyb3VwLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIE5vbmVcbiAgICovXG4gIHJlYWRvbmx5IHBhcmFtZXRlcnM/OiB7IFtrZXk6IHN0cmluZ106IHN0cmluZyB9O1xuXG4gIC8qKlxuICAgKiBXaGV0aGVyIHRvIGVuYWJsZSBQZXJmb3JtYW5jZSBJbnNpZ2h0cyBmb3IgdGhlIERCIGluc3RhbmNlLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIGZhbHNlLCB1bmxlc3MgYGBwZXJmb3JtYW5jZUluc2lnaHRSZW50ZW50aW9uYGAgb3IgYGBwZXJmb3JtYW5jZUluc2lnaHRFbmNyeXB0aW9uS2V5YGAgaXMgc2V0LlxuICAgKi9cbiAgcmVhZG9ubHkgZW5hYmxlUGVyZm9ybWFuY2VJbnNpZ2h0cz86IGJvb2xlYW47XG5cbiAgLyoqXG4gICAqIFRoZSBhbW91bnQgb2YgdGltZSwgaW4gZGF5cywgdG8gcmV0YWluIFBlcmZvcm1hbmNlIEluc2lnaHRzIGRhdGEuXG4gICAqXG4gICAqIEBkZWZhdWx0IDdcbiAgICovXG4gIHJlYWRvbmx5IHBlcmZvcm1hbmNlSW5zaWdodFJldGVudGlvbj86IFBlcmZvcm1hbmNlSW5zaWdodFJldGVudGlvbjtcblxuICAvKipcbiAgICogVGhlIEFXUyBLTVMga2V5IGZvciBlbmNyeXB0aW9uIG9mIFBlcmZvcm1hbmNlIEluc2lnaHRzIGRhdGEuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gZGVmYXVsdCBtYXN0ZXIga2V5XG4gICAqL1xuICByZWFkb25seSBwZXJmb3JtYW5jZUluc2lnaHRFbmNyeXB0aW9uS2V5Pzoga21zLklLZXk7XG5cbiAgLyoqXG4gICAqIFdoZXRoZXIgdG8gZW5hYmxlIGF1dG9tYXRpYyB1cGdyYWRlIG9mIG1pbm9yIHZlcnNpb24gZm9yIHRoZSBEQiBpbnN0YW5jZS5cbiAgICpcbiAgICogQGRlZmF1bHQgLSB0cnVlXG4gICAqL1xuICByZWFkb25seSBhdXRvTWlub3JWZXJzaW9uVXBncmFkZT86IGJvb2xlYW47XG5cbiAgLyoqXG4gICAqIFdoZXRoZXIgdG8gYWxsb3cgdXBncmFkZSBvZiBtYWpvciB2ZXJzaW9uIGZvciB0aGUgREIgaW5zdGFuY2UuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gZmFsc2VcbiAgICovXG4gIHJlYWRvbmx5IGFsbG93TWFqb3JWZXJzaW9uVXBncmFkZT86IGJvb2xlYW47XG5cbiAgLyoqXG4gICAqICBXaGV0aGVyIHRvIHJlbW92ZSBhdXRvbWF0ZWQgYmFja3VwcyBpbW1lZGlhdGVseSBhZnRlciB0aGUgREIgaW5zdGFuY2UgaXMgZGVsZXRlZCBmb3IgdGhlIERCIGluc3RhbmNlLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIHRydWVcbiAgICovXG4gIHJlYWRvbmx5IGRlbGV0ZUF1dG9tYXRlZEJhY2t1cHM/OiBib29sZWFuO1xuXG4gIC8qKlxuICAgKiBJbmRpY2F0ZXMgd2hldGhlciB0aGUgREIgaW5zdGFuY2UgaXMgYW4gaW50ZXJuZXQtZmFjaW5nIGluc3RhbmNlLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIGB0cnVlYCBpZiBgdnBjU3VibmV0c2AgaXMgYHN1Ym5ldFR5cGU6IFN1Ym5ldFR5cGUuUFVCTElDYCwgYGZhbHNlYCBvdGhlcndpc2VcbiAgICovXG4gIHJlYWRvbmx5IHB1YmxpY2x5QWNjZXNzaWJsZT86IGJvb2xlYW47XG59XG5cbi8qKlxuICogQmFja3VwIGNvbmZpZ3VyYXRpb24gZm9yIFJEUyBkYXRhYmFzZXNcbiAqXG4gKiBAZGVmYXVsdCAtIFRoZSByZXRlbnRpb24gcGVyaW9kIGZvciBhdXRvbWF0ZWQgYmFja3VwcyBpcyAxIGRheS5cbiAqIFRoZSBwcmVmZXJyZWQgYmFja3VwIHdpbmRvdyB3aWxsIGJlIGEgMzAtbWludXRlIHdpbmRvdyBzZWxlY3RlZCBhdCByYW5kb21cbiAqIGZyb20gYW4gOC1ob3VyIGJsb2NrIG9mIHRpbWUgZm9yIGVhY2ggQVdTIFJlZ2lvbi5cbiAqIEBzZWUgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FtYXpvblJEUy9sYXRlc3QvVXNlckd1aWRlL1VTRVJfV29ya2luZ1dpdGhBdXRvbWF0ZWRCYWNrdXBzLmh0bWwjVVNFUl9Xb3JraW5nV2l0aEF1dG9tYXRlZEJhY2t1cHMuQmFja3VwV2luZG93XG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgQmFja3VwUHJvcHMge1xuXG4gIC8qKlxuICAgKiBIb3cgbWFueSBkYXlzIHRvIHJldGFpbiB0aGUgYmFja3VwXG4gICAqL1xuICByZWFkb25seSByZXRlbnRpb246IER1cmF0aW9uO1xuXG4gIC8qKlxuICAgKiBBIGRhaWx5IHRpbWUgcmFuZ2UgaW4gMjQtaG91cnMgVVRDIGZvcm1hdCBpbiB3aGljaCBiYWNrdXBzIHByZWZlcmFibHkgZXhlY3V0ZS5cbiAgICpcbiAgICogTXVzdCBiZSBhdCBsZWFzdCAzMCBtaW51dGVzIGxvbmcuXG4gICAqXG4gICAqIEV4YW1wbGU6ICcwMTowMC0wMjowMCdcbiAgICpcbiAgICogQGRlZmF1bHQgLSBhIDMwLW1pbnV0ZSB3aW5kb3cgc2VsZWN0ZWQgYXQgcmFuZG9tIGZyb20gYW4gOC1ob3VyIGJsb2NrIG9mXG4gICAqIHRpbWUgZm9yIGVhY2ggQVdTIFJlZ2lvbi4gVG8gc2VlIHRoZSB0aW1lIGJsb2NrcyBhdmFpbGFibGUsIHNlZVxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQW1hem9uUkRTL2xhdGVzdC9Vc2VyR3VpZGUvVVNFUl9Xb3JraW5nV2l0aEF1dG9tYXRlZEJhY2t1cHMuaHRtbCNVU0VSX1dvcmtpbmdXaXRoQXV0b21hdGVkQmFja3Vwcy5CYWNrdXBXaW5kb3dcbiAgICovXG4gIHJlYWRvbmx5IHByZWZlcnJlZFdpbmRvdz86IHN0cmluZztcbn1cblxuLyoqXG4gKiBCYXNlIG9wdGlvbnMgZm9yIGNyZWF0aW5nIENyZWRlbnRpYWxzLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIENyZWRlbnRpYWxzQmFzZU9wdGlvbnMge1xuICAvKipcbiAgICogVGhlIG5hbWUgb2YgdGhlIHNlY3JldC5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBBIG5hbWUgaXMgZ2VuZXJhdGVkIGJ5IENsb3VkRm9ybWF0aW9uLlxuICAgKi9cbiAgcmVhZG9ubHkgc2VjcmV0TmFtZT86IHN0cmluZztcblxuICAvKipcbiAgICogS01TIGVuY3J5cHRpb24ga2V5IHRvIGVuY3J5cHQgdGhlIGdlbmVyYXRlZCBzZWNyZXQuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gZGVmYXVsdCBtYXN0ZXIga2V5XG4gICAqL1xuICByZWFkb25seSBlbmNyeXB0aW9uS2V5Pzoga21zLklLZXk7XG5cbiAgLyoqXG4gICAqIFRoZSBjaGFyYWN0ZXJzIHRvIGV4Y2x1ZGUgZnJvbSB0aGUgZ2VuZXJhdGVkIHBhc3N3b3JkLlxuICAgKiBIYXMgbm8gZWZmZWN0IGlmIHtAbGluayBwYXNzd29yZH0gaGFzIGJlZW4gcHJvdmlkZWQuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gdGhlIERhdGFiYXNlU2VjcmV0IGRlZmF1bHQgZXhjbHVkZSBjaGFyYWN0ZXIgc2V0IChcIiAlK35gIyQmKigpfFtde306Ozw+PyEnL0BcXFwiXFxcXFwiKVxuICAgKi9cbiAgcmVhZG9ubHkgZXhjbHVkZUNoYXJhY3RlcnM/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIEEgbGlzdCBvZiByZWdpb25zIHdoZXJlIHRvIHJlcGxpY2F0ZSB0aGlzIHNlY3JldC5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBTZWNyZXQgaXMgbm90IHJlcGxpY2F0ZWRcbiAgICovXG4gIHJlYWRvbmx5IHJlcGxpY2FSZWdpb25zPzogc2VjcmV0c21hbmFnZXIuUmVwbGljYVJlZ2lvbltdO1xufVxuXG4vKipcbiAqIE9wdGlvbnMgZm9yIGNyZWF0aW5nIENyZWRlbnRpYWxzIGZyb20gYSB1c2VybmFtZS5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBDcmVkZW50aWFsc0Zyb21Vc2VybmFtZU9wdGlvbnMgZXh0ZW5kcyBDcmVkZW50aWFsc0Jhc2VPcHRpb25zIHtcbiAgLyoqXG4gICAqIFBhc3N3b3JkXG4gICAqXG4gICAqIERvIG5vdCBwdXQgcGFzc3dvcmRzIGluIHlvdXIgQ0RLIGNvZGUgZGlyZWN0bHkuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gYSBTZWNyZXRzIE1hbmFnZXIgZ2VuZXJhdGVkIHBhc3N3b3JkXG4gICAqL1xuICByZWFkb25seSBwYXNzd29yZD86IFNlY3JldFZhbHVlO1xufVxuXG4vKipcbiAqIFVzZXJuYW1lIGFuZCBwYXNzd29yZCBjb21iaW5hdGlvblxuICovXG5leHBvcnQgYWJzdHJhY3QgY2xhc3MgQ3JlZGVudGlhbHMge1xuICAvKipcbiAgICogQ3JlYXRlcyBDcmVkZW50aWFscyB3aXRoIGEgcGFzc3dvcmQgZ2VuZXJhdGVkIGFuZCBzdG9yZWQgaW4gU2VjcmV0cyBNYW5hZ2VyLlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBmcm9tR2VuZXJhdGVkU2VjcmV0KHVzZXJuYW1lOiBzdHJpbmcsIG9wdGlvbnM6IENyZWRlbnRpYWxzQmFzZU9wdGlvbnMgPSB7fSk6IENyZWRlbnRpYWxzIHtcbiAgICByZXR1cm4ge1xuICAgICAgLi4ub3B0aW9ucyxcbiAgICAgIHVzZXJuYW1lLFxuICAgICAgdXNlcm5hbWVBc1N0cmluZzogdHJ1ZSxcbiAgICB9O1xuICB9XG5cbiAgLyoqXG4gICAqIENyZWF0ZXMgQ3JlZGVudGlhbHMgZnJvbSBhIHBhc3N3b3JkXG4gICAqXG4gICAqIERvIG5vdCBwdXQgcGFzc3dvcmRzIGluIHlvdXIgQ0RLIGNvZGUgZGlyZWN0bHkuXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIGZyb21QYXNzd29yZCh1c2VybmFtZTogc3RyaW5nLCBwYXNzd29yZDogU2VjcmV0VmFsdWUpOiBDcmVkZW50aWFscyB7XG4gICAgcmV0dXJuIHtcbiAgICAgIHVzZXJuYW1lLFxuICAgICAgcGFzc3dvcmQsXG4gICAgICB1c2VybmFtZUFzU3RyaW5nOiB0cnVlLFxuICAgIH07XG4gIH1cblxuICAvKipcbiAgICogQ3JlYXRlcyBDcmVkZW50aWFscyBmb3IgdGhlIGdpdmVuIHVzZXJuYW1lLCBhbmQgb3B0aW9uYWwgcGFzc3dvcmQgYW5kIGtleS5cbiAgICogSWYgbm8gcGFzc3dvcmQgaXMgcHJvdmlkZWQsIG9uZSB3aWxsIGJlIGdlbmVyYXRlZCBhbmQgc3RvcmVkIGluIFNlY3JldHMgTWFuYWdlci5cbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgZnJvbVVzZXJuYW1lKHVzZXJuYW1lOiBzdHJpbmcsIG9wdGlvbnM6IENyZWRlbnRpYWxzRnJvbVVzZXJuYW1lT3B0aW9ucyA9IHt9KTogQ3JlZGVudGlhbHMge1xuICAgIHJldHVybiB7XG4gICAgICAuLi5vcHRpb25zLFxuICAgICAgdXNlcm5hbWUsXG4gICAgfTtcbiAgfVxuXG4gIC8qKlxuICAgKiBDcmVhdGVzIENyZWRlbnRpYWxzIGZyb20gYW4gZXhpc3RpbmcgU2VjcmV0cyBNYW5hZ2VyIGBgU2VjcmV0YGAgKG9yIGBgRGF0YWJhc2VTZWNyZXRgYClcbiAgICpcbiAgICogVGhlIFNlY3JldCBtdXN0IGJlIGEgSlNPTiBzdHJpbmcgd2l0aCBhIGBgdXNlcm5hbWVgYCBhbmQgYGBwYXNzd29yZGBgIGZpZWxkOlxuICAgKiBgYGBcbiAgICoge1xuICAgKiAgIC4uLlxuICAgKiAgIFwidXNlcm5hbWVcIjogPHJlcXVpcmVkOiB1c2VybmFtZT4sXG4gICAqICAgXCJwYXNzd29yZFwiOiA8cmVxdWlyZWQ6IHBhc3N3b3JkPixcbiAgICogfVxuICAgKiBgYGBcbiAgICpcbiAgICogQHBhcmFtIHNlY3JldCBUaGUgc2VjcmV0IHdoZXJlIHRoZSBjcmVkZW50aWFscyBhcmUgc3RvcmVkXG4gICAqIEBwYXJhbSB1c2VybmFtZSBUaGUgdXNlcm5hbWUgZGVmaW5lZCBpbiB0aGUgc2VjcmV0LiBJZiBzcGVjaWZpZWQgdGhlIHVzZXJuYW1lXG4gICAqICAgd2lsbCBiZSByZWZlcmVuY2VkIGFzIGEgc3RyaW5nIGFuZCBub3QgYSBkeW5hbWljIHJlZmVyZW5jZSB0byB0aGUgdXNlcm5hbWVcbiAgICogICBmaWVsZCBpbiB0aGUgc2VjcmV0LiBUaGlzIGFsbG93cyB0byByZXBsYWNlIHRoZSBzZWNyZXQgd2l0aG91dCByZXBsYWNpbmcgdGhlXG4gICAqICAgaW5zdGFuY2Ugb3IgY2x1c3Rlci5cbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgZnJvbVNlY3JldChzZWNyZXQ6IHNlY3JldHNtYW5hZ2VyLklTZWNyZXQsIHVzZXJuYW1lPzogc3RyaW5nKTogQ3JlZGVudGlhbHMge1xuICAgIHJldHVybiB7XG4gICAgICB1c2VybmFtZTogdXNlcm5hbWUgPz8gc2VjcmV0LnNlY3JldFZhbHVlRnJvbUpzb24oJ3VzZXJuYW1lJykudW5zYWZlVW53cmFwKCksXG4gICAgICBwYXNzd29yZDogc2VjcmV0LnNlY3JldFZhbHVlRnJvbUpzb24oJ3Bhc3N3b3JkJyksXG4gICAgICBlbmNyeXB0aW9uS2V5OiBzZWNyZXQuZW5jcnlwdGlvbktleSxcbiAgICAgIHNlY3JldCxcbiAgICB9O1xuICB9XG5cbiAgLyoqXG4gICAqIFVzZXJuYW1lXG4gICAqL1xuICBwdWJsaWMgYWJzdHJhY3QgcmVhZG9ubHkgdXNlcm5hbWU6IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIG5hbWUgdG8gdXNlIGZvciB0aGUgU2VjcmV0IGlmIGEgbmV3IFNlY3JldCBpcyB0byBiZSBnZW5lcmF0ZWQgaW5cbiAgICogU2VjcmV0c01hbmFnZXIgZm9yIHRoZXNlIENyZWRlbnRpYWxzLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIEEgbmFtZSBpcyBnZW5lcmF0ZWQgYnkgQ2xvdWRGb3JtYXRpb24uXG4gICAqL1xuICBwdWJsaWMgYWJzdHJhY3QgcmVhZG9ubHkgc2VjcmV0TmFtZT86IHN0cmluZztcblxuICAvKipcbiAgICogV2hldGhlciB0aGUgdXNlcm5hbWUgc2hvdWxkIGJlIHJlZmVyZW5jZWQgYXMgYSBzdHJpbmcgYW5kIG5vdCBhcyBhIGR5bmFtaWNcbiAgICogcmVmZXJlbmNlIHRvIHRoZSB1c2VybmFtZSBpbiB0aGUgc2VjcmV0LlxuICAgKlxuICAgKiBAZGVmYXVsdCBmYWxzZVxuICAgKi9cbiAgcHVibGljIGFic3RyYWN0IHJlYWRvbmx5IHVzZXJuYW1lQXNTdHJpbmc/OiBib29sZWFuO1xuXG4gIC8qKlxuICAgKiBQYXNzd29yZFxuICAgKlxuICAgKiBEbyBub3QgcHV0IHBhc3N3b3JkcyBpbiB5b3VyIENESyBjb2RlIGRpcmVjdGx5LlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIGEgU2VjcmV0cyBNYW5hZ2VyIGdlbmVyYXRlZCBwYXNzd29yZFxuICAgKi9cbiAgcHVibGljIGFic3RyYWN0IHJlYWRvbmx5IHBhc3N3b3JkPzogU2VjcmV0VmFsdWU7XG5cbiAgLyoqXG4gICAqIEtNUyBlbmNyeXB0aW9uIGtleSB0byBlbmNyeXB0IHRoZSBnZW5lcmF0ZWQgc2VjcmV0LlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIGRlZmF1bHQgbWFzdGVyIGtleVxuICAgKi9cbiAgcHVibGljIGFic3RyYWN0IHJlYWRvbmx5IGVuY3J5cHRpb25LZXk/OiBrbXMuSUtleTtcblxuICAvKipcbiAgICogU2VjcmV0IHVzZWQgdG8gaW5zdGFudGlhdGUgdGhpcyBMb2dpbi5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBub25lXG4gICAqL1xuICBwdWJsaWMgYWJzdHJhY3QgcmVhZG9ubHkgc2VjcmV0Pzogc2VjcmV0c21hbmFnZXIuSVNlY3JldDtcblxuICAvKipcbiAgICogVGhlIGNoYXJhY3RlcnMgdG8gZXhjbHVkZSBmcm9tIHRoZSBnZW5lcmF0ZWQgcGFzc3dvcmQuXG4gICAqIE9ubHkgdXNlZCBpZiB7QGxpbmsgcGFzc3dvcmR9IGhhcyBub3QgYmVlbiBzZXQuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gdGhlIERhdGFiYXNlU2VjcmV0IGRlZmF1bHQgZXhjbHVkZSBjaGFyYWN0ZXIgc2V0IChcIiAlK35gIyQmKigpfFtde306Ozw+PyEnL0BcXFwiXFxcXFwiKVxuICAgKi9cbiAgcHVibGljIGFic3RyYWN0IHJlYWRvbmx5IGV4Y2x1ZGVDaGFyYWN0ZXJzPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBBIGxpc3Qgb2YgcmVnaW9ucyB3aGVyZSB0byByZXBsaWNhdGUgdGhlIGdlbmVyYXRlZCBzZWNyZXQuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gU2VjcmV0IGlzIG5vdCByZXBsaWNhdGVkXG4gICAqL1xuICBwdWJsaWMgYWJzdHJhY3QgcmVhZG9ubHkgcmVwbGljYVJlZ2lvbnM/OiBzZWNyZXRzbWFuYWdlci5SZXBsaWNhUmVnaW9uW107XG59XG5cbi8qKlxuICogT3B0aW9ucyB1c2VkIGluIHRoZSB7QGxpbmsgU25hcHNob3RDcmVkZW50aWFscy5mcm9tR2VuZXJhdGVkUGFzc3dvcmR9IG1ldGhvZC5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBTbmFwc2hvdENyZWRlbnRpYWxzRnJvbUdlbmVyYXRlZFBhc3N3b3JkT3B0aW9ucyB7XG4gIC8qKlxuICAgKiBLTVMgZW5jcnlwdGlvbiBrZXkgdG8gZW5jcnlwdCB0aGUgZ2VuZXJhdGVkIHNlY3JldC5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBkZWZhdWx0IG1hc3RlciBrZXlcbiAgICovXG4gIHJlYWRvbmx5IGVuY3J5cHRpb25LZXk/OiBrbXMuSUtleTtcblxuICAvKipcbiAgICogVGhlIGNoYXJhY3RlcnMgdG8gZXhjbHVkZSBmcm9tIHRoZSBnZW5lcmF0ZWQgcGFzc3dvcmQuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gdGhlIERhdGFiYXNlU2VjcmV0IGRlZmF1bHQgZXhjbHVkZSBjaGFyYWN0ZXIgc2V0IChcIiAlK35gIyQmKigpfFtde306Ozw+PyEnL0BcXFwiXFxcXFwiKVxuICAgKi9cbiAgcmVhZG9ubHkgZXhjbHVkZUNoYXJhY3RlcnM/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIEEgbGlzdCBvZiByZWdpb25zIHdoZXJlIHRvIHJlcGxpY2F0ZSB0aGlzIHNlY3JldC5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBTZWNyZXQgaXMgbm90IHJlcGxpY2F0ZWRcbiAgICovXG4gIHJlYWRvbmx5IHJlcGxpY2FSZWdpb25zPzogc2VjcmV0c21hbmFnZXIuUmVwbGljYVJlZ2lvbltdO1xufVxuXG4vKipcbiAqIENyZWRlbnRpYWxzIHRvIHVwZGF0ZSB0aGUgcGFzc3dvcmQgZm9yIGEgYGBEYXRhYmFzZUluc3RhbmNlRnJvbVNuYXBzaG90YGAuXG4gKi9cbmV4cG9ydCBhYnN0cmFjdCBjbGFzcyBTbmFwc2hvdENyZWRlbnRpYWxzIHtcbiAgLyoqXG4gICAqIEdlbmVyYXRlIGEgbmV3IHBhc3N3b3JkIGZvciB0aGUgc25hcHNob3QsIHVzaW5nIHRoZSBleGlzdGluZyB1c2VybmFtZSBhbmQgYW4gb3B0aW9uYWwgZW5jcnlwdGlvbiBrZXkuXG4gICAqIFRoZSBuZXcgY3JlZGVudGlhbHMgYXJlIHN0b3JlZCBpbiBTZWNyZXRzIE1hbmFnZXIuXG4gICAqXG4gICAqIE5vdGUgLSBUaGUgdXNlcm5hbWUgbXVzdCBtYXRjaCB0aGUgZXhpc3RpbmcgbWFzdGVyIHVzZXJuYW1lIG9mIHRoZSBzbmFwc2hvdC5cbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgZnJvbUdlbmVyYXRlZFNlY3JldCh1c2VybmFtZTogc3RyaW5nLCBvcHRpb25zOiBTbmFwc2hvdENyZWRlbnRpYWxzRnJvbUdlbmVyYXRlZFBhc3N3b3JkT3B0aW9ucyA9IHt9KTogU25hcHNob3RDcmVkZW50aWFscyB7XG4gICAgcmV0dXJuIHtcbiAgICAgIC4uLm9wdGlvbnMsXG4gICAgICBnZW5lcmF0ZVBhc3N3b3JkOiB0cnVlLFxuICAgICAgcmVwbGFjZU9uUGFzc3dvcmRDcml0ZXJpYUNoYW5nZXM6IHRydWUsXG4gICAgICB1c2VybmFtZSxcbiAgICB9O1xuICB9XG5cbiAgLyoqXG4gICAqIEdlbmVyYXRlIGEgbmV3IHBhc3N3b3JkIGZvciB0aGUgc25hcHNob3QsIHVzaW5nIHRoZSBleGlzdGluZyB1c2VybmFtZSBhbmQgYW4gb3B0aW9uYWwgZW5jcnlwdGlvbiBrZXkuXG4gICAqXG4gICAqIE5vdGUgLSBUaGUgdXNlcm5hbWUgbXVzdCBtYXRjaCB0aGUgZXhpc3RpbmcgbWFzdGVyIHVzZXJuYW1lIG9mIHRoZSBzbmFwc2hvdC5cbiAgICpcbiAgICogTk9URTogdXNlIGBmcm9tR2VuZXJhdGVkU2VjcmV0KClgIGZvciBuZXcgQ2x1c3RlcnMgYW5kIEluc3RhbmNlcy4gU3dpdGNoaW5nIGZyb21cbiAgICogYGZyb21HZW5lcmF0ZWRQYXNzd29yZCgpYCB0byBgZnJvbUdlbmVyYXRlZFNlY3JldCgpYCBmb3IgYWxyZWFkeSBkZXBsb3llZCBDbHVzdGVyc1xuICAgKiBvciBJbnN0YW5jZXMgd2lsbCB1cGRhdGUgdGhlaXIgbWFzdGVyIHBhc3N3b3JkLlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBmcm9tR2VuZXJhdGVkUGFzc3dvcmQodXNlcm5hbWU6IHN0cmluZywgb3B0aW9uczogU25hcHNob3RDcmVkZW50aWFsc0Zyb21HZW5lcmF0ZWRQYXNzd29yZE9wdGlvbnMgPSB7fSk6IFNuYXBzaG90Q3JlZGVudGlhbHMge1xuICAgIHJldHVybiB7XG4gICAgICAuLi5vcHRpb25zLFxuICAgICAgZ2VuZXJhdGVQYXNzd29yZDogdHJ1ZSxcbiAgICAgIHVzZXJuYW1lLFxuICAgIH07XG4gIH1cblxuICAvKipcbiAgICogVXBkYXRlIHRoZSBzbmFwc2hvdCBsb2dpbiB3aXRoIGFuIGV4aXN0aW5nIHBhc3N3b3JkLlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBmcm9tUGFzc3dvcmQocGFzc3dvcmQ6IFNlY3JldFZhbHVlKTogU25hcHNob3RDcmVkZW50aWFscyB7XG4gICAgcmV0dXJuIHsgZ2VuZXJhdGVQYXNzd29yZDogZmFsc2UsIHBhc3N3b3JkIH07XG4gIH1cblxuICAvKipcbiAgICogVXBkYXRlIHRoZSBzbmFwc2hvdCBsb2dpbiB3aXRoIGFuIGV4aXN0aW5nIHBhc3N3b3JkIGZyb20gYSBTZWNyZXQuXG4gICAqXG4gICAqIFRoZSBTZWNyZXQgbXVzdCBiZSBhIEpTT04gc3RyaW5nIHdpdGggYSBgYHBhc3N3b3JkYGAgZmllbGQ6XG4gICAqIGBgYFxuICAgKiB7XG4gICAqICAgLi4uXG4gICAqICAgXCJwYXNzd29yZFwiOiA8cmVxdWlyZWQ6IHBhc3N3b3JkPixcbiAgICogfVxuICAgKiBgYGBcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgZnJvbVNlY3JldChzZWNyZXQ6IHNlY3JldHNtYW5hZ2VyLklTZWNyZXQpOiBTbmFwc2hvdENyZWRlbnRpYWxzIHtcbiAgICByZXR1cm4ge1xuICAgICAgZ2VuZXJhdGVQYXNzd29yZDogZmFsc2UsXG4gICAgICBwYXNzd29yZDogc2VjcmV0LnNlY3JldFZhbHVlRnJvbUpzb24oJ3Bhc3N3b3JkJyksXG4gICAgICBzZWNyZXQsXG4gICAgfTtcbiAgfVxuXG4gIC8qKlxuICAgKiBUaGUgbWFzdGVyIHVzZXIgbmFtZS5cbiAgICpcbiAgICogTXVzdCBiZSB0aGUgKipjdXJyZW50KiogbWFzdGVyIHVzZXIgbmFtZSBvZiB0aGUgc25hcHNob3QuXG4gICAqIEl0IGlzIG5vdCBwb3NzaWJsZSB0byBjaGFuZ2UgdGhlIG1hc3RlciB1c2VyIG5hbWUgb2YgYSBSRFMgaW5zdGFuY2UuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gdGhlIGV4aXN0aW5nIHVzZXJuYW1lIGZyb20gdGhlIHNuYXBzaG90XG4gICAqL1xuICBwdWJsaWMgYWJzdHJhY3QgcmVhZG9ubHkgdXNlcm5hbWU/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFdoZXRoZXIgYSBuZXcgcGFzc3dvcmQgc2hvdWxkIGJlIGdlbmVyYXRlZC5cbiAgICovXG4gIHB1YmxpYyBhYnN0cmFjdCByZWFkb25seSBnZW5lcmF0ZVBhc3N3b3JkOiBib29sZWFuO1xuXG4gIC8qKlxuICAgKiBXaGV0aGVyIHRvIHJlcGxhY2UgdGhlIGdlbmVyYXRlZCBzZWNyZXQgd2hlbiB0aGUgY3JpdGVyaWEgZm9yIHRoZSBwYXNzd29yZCBjaGFuZ2UuXG4gICAqXG4gICAqIEBkZWZhdWx0IGZhbHNlXG4gICAqL1xuICBwdWJsaWMgYWJzdHJhY3QgcmVhZG9ubHkgcmVwbGFjZU9uUGFzc3dvcmRDcml0ZXJpYUNoYW5nZXM/OiBib29sZWFuO1xuXG4gIC8qKlxuICAgKiBUaGUgbWFzdGVyIHVzZXIgcGFzc3dvcmQuXG4gICAqXG4gICAqIERvIG5vdCBwdXQgcGFzc3dvcmRzIGluIHlvdXIgQ0RLIGNvZGUgZGlyZWN0bHkuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gdGhlIGV4aXN0aW5nIHBhc3N3b3JkIGZyb20gdGhlIHNuYXBzaG90XG4gICAqL1xuICBwdWJsaWMgYWJzdHJhY3QgcmVhZG9ubHkgcGFzc3dvcmQ/OiBTZWNyZXRWYWx1ZTtcblxuICAvKipcbiAgICogS01TIGVuY3J5cHRpb24ga2V5IHRvIGVuY3J5cHQgdGhlIGdlbmVyYXRlZCBzZWNyZXQuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gZGVmYXVsdCBtYXN0ZXIga2V5XG4gICAqL1xuICBwdWJsaWMgYWJzdHJhY3QgcmVhZG9ubHkgZW5jcnlwdGlvbktleT86IGttcy5JS2V5O1xuXG4gIC8qKlxuICAgKiBTZWNyZXQgdXNlZCB0byBpbnN0YW50aWF0ZSB0aGlzIExvZ2luLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIG5vbmVcbiAgICovXG4gIHB1YmxpYyBhYnN0cmFjdCByZWFkb25seSBzZWNyZXQ/OiBzZWNyZXRzbWFuYWdlci5JU2VjcmV0O1xuXG4gIC8qKlxuICAgKiBUaGUgY2hhcmFjdGVycyB0byBleGNsdWRlIGZyb20gdGhlIGdlbmVyYXRlZCBwYXNzd29yZC5cbiAgICogT25seSB1c2VkIGlmIHtAbGluayBnZW5lcmF0ZVBhc3N3b3JkfSBpZiB0cnVlLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIHRoZSBEYXRhYmFzZVNlY3JldCBkZWZhdWx0IGV4Y2x1ZGUgY2hhcmFjdGVyIHNldCAoXCIgJSt+YCMkJiooKXxbXXt9Ojs8Pj8hJy9AXFxcIlxcXFxcIilcbiAgICovXG4gIHB1YmxpYyBhYnN0cmFjdCByZWFkb25seSBleGNsdWRlQ2hhcmFjdGVycz86IHN0cmluZztcblxuICAvKipcbiAgICogQSBsaXN0IG9mIHJlZ2lvbnMgd2hlcmUgdG8gcmVwbGljYXRlIHRoZSBnZW5lcmF0ZWQgc2VjcmV0LlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIFNlY3JldCBpcyBub3QgcmVwbGljYXRlZFxuICAgKi9cbiAgcHVibGljIGFic3RyYWN0IHJlYWRvbmx5IHJlcGxpY2FSZWdpb25zPzogc2VjcmV0c21hbmFnZXIuUmVwbGljYVJlZ2lvbltdO1xufVxuXG4vKipcbiAqIFByb3BlcnRpZXMgY29tbW9uIHRvIHNpbmdsZS11c2VyIGFuZCBtdWx0aS11c2VyIHJvdGF0aW9uIG9wdGlvbnMuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgQ29tbW9uUm90YXRpb25Vc2VyT3B0aW9ucyB7XG4gIC8qKlxuICAgKiBTcGVjaWZpZXMgdGhlIG51bWJlciBvZiBkYXlzIGFmdGVyIHRoZSBwcmV2aW91cyByb3RhdGlvblxuICAgKiBiZWZvcmUgU2VjcmV0cyBNYW5hZ2VyIHRyaWdnZXJzIHRoZSBuZXh0IGF1dG9tYXRpYyByb3RhdGlvbi5cbiAgICpcbiAgICogQGRlZmF1bHQgLSAzMCBkYXlzXG4gICAqL1xuICByZWFkb25seSBhdXRvbWF0aWNhbGx5QWZ0ZXI/OiBEdXJhdGlvbjtcblxuICAvKipcbiAgICogU3BlY2lmaWVzIGNoYXJhY3RlcnMgdG8gbm90IGluY2x1ZGUgaW4gZ2VuZXJhdGVkIHBhc3N3b3Jkcy5cbiAgICpcbiAgICogQGRlZmF1bHQgXCIgJSt+YCMkJiooKXxbXXt9Ojs8Pj8hJy9AXFxcIlxcXFxcIlxuICAgKi9cbiAgcmVhZG9ubHkgZXhjbHVkZUNoYXJhY3RlcnM/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFdoZXJlIHRvIHBsYWNlIHRoZSByb3RhdGlvbiBMYW1iZGEgZnVuY3Rpb25cbiAgICpcbiAgICogQGRlZmF1bHQgLSBzYW1lIHBsYWNlbWVudCBhcyBpbnN0YW5jZSBvciBjbHVzdGVyXG4gICAqL1xuICByZWFkb25seSB2cGNTdWJuZXRzPzogZWMyLlN1Ym5ldFNlbGVjdGlvbjtcblxuICAvKipcbiAgICogVGhlIFZQQyBpbnRlcmZhY2UgZW5kcG9pbnQgdG8gdXNlIGZvciB0aGUgU2VjcmV0cyBNYW5hZ2VyIEFQSVxuICAgKlxuICAgKiBJZiB5b3UgZW5hYmxlIHByaXZhdGUgRE5TIGhvc3RuYW1lcyBmb3IgeW91ciBWUEMgcHJpdmF0ZSBlbmRwb2ludCAodGhlIGRlZmF1bHQpLCB5b3UgZG9uJ3RcbiAgICogbmVlZCB0byBzcGVjaWZ5IGFuIGVuZHBvaW50LiBUaGUgc3RhbmRhcmQgU2VjcmV0cyBNYW5hZ2VyIEROUyBob3N0bmFtZSB0aGUgU2VjcmV0cyBNYW5hZ2VyXG4gICAqIENMSSBhbmQgU0RLcyB1c2UgYnkgZGVmYXVsdCAoaHR0cHM6Ly9zZWNyZXRzbWFuYWdlci48cmVnaW9uPi5hbWF6b25hd3MuY29tKSBhdXRvbWF0aWNhbGx5XG4gICAqIHJlc29sdmVzIHRvIHlvdXIgVlBDIGVuZHBvaW50LlxuICAgKlxuICAgKiBAZGVmYXVsdCBodHRwczovL3NlY3JldHNtYW5hZ2VyLjxyZWdpb24+LmFtYXpvbmF3cy5jb21cbiAgICovXG4gIHJlYWRvbmx5IGVuZHBvaW50PzogZWMyLklJbnRlcmZhY2VWcGNFbmRwb2ludDtcbn1cblxuLyoqXG4gKiBPcHRpb25zIHRvIGFkZCB0aGUgbXVsdGkgdXNlciByb3RhdGlvblxuICovXG5leHBvcnQgaW50ZXJmYWNlIFJvdGF0aW9uU2luZ2xlVXNlck9wdGlvbnMgZXh0ZW5kcyBDb21tb25Sb3RhdGlvblVzZXJPcHRpb25zIHtcbn1cblxuLyoqXG4gKiBPcHRpb25zIHRvIGFkZCB0aGUgbXVsdGkgdXNlciByb3RhdGlvblxuICovXG5leHBvcnQgaW50ZXJmYWNlIFJvdGF0aW9uTXVsdGlVc2VyT3B0aW9ucyBleHRlbmRzIENvbW1vblJvdGF0aW9uVXNlck9wdGlvbnMge1xuICAvKipcbiAgICogVGhlIHNlY3JldCB0byByb3RhdGUuIEl0IG11c3QgYmUgYSBKU09OIHN0cmluZyB3aXRoIHRoZSBmb2xsb3dpbmcgZm9ybWF0OlxuICAgKiBgYGBcbiAgICoge1xuICAgKiAgIFwiZW5naW5lXCI6IDxyZXF1aXJlZDogZGF0YWJhc2UgZW5naW5lPixcbiAgICogICBcImhvc3RcIjogPHJlcXVpcmVkOiBpbnN0YW5jZSBob3N0IG5hbWU+LFxuICAgKiAgIFwidXNlcm5hbWVcIjogPHJlcXVpcmVkOiB1c2VybmFtZT4sXG4gICAqICAgXCJwYXNzd29yZFwiOiA8cmVxdWlyZWQ6IHBhc3N3b3JkPixcbiAgICogICBcImRibmFtZVwiOiA8b3B0aW9uYWw6IGRhdGFiYXNlIG5hbWU+LFxuICAgKiAgIFwicG9ydFwiOiA8b3B0aW9uYWw6IGlmIG5vdCBzcGVjaWZpZWQsIGRlZmF1bHQgcG9ydCB3aWxsIGJlIHVzZWQ+LFxuICAgKiAgIFwibWFzdGVyYXJuXCI6IDxyZXF1aXJlZDogdGhlIGFybiBvZiB0aGUgbWFzdGVyIHNlY3JldCB3aGljaCB3aWxsIGJlIHVzZWQgdG8gY3JlYXRlIHVzZXJzL2NoYW5nZSBwYXNzd29yZHM+XG4gICAqIH1cbiAgICogYGBgXG4gICAqL1xuICByZWFkb25seSBzZWNyZXQ6IHNlY3JldHNtYW5hZ2VyLklTZWNyZXQ7XG59XG5cbi8qKlxuICogVGhlIHJldGVudGlvbiBwZXJpb2QgZm9yIFBlcmZvcm1hbmNlIEluc2lnaHQuXG4gKi9cbmV4cG9ydCBlbnVtIFBlcmZvcm1hbmNlSW5zaWdodFJldGVudGlvbiB7XG4gIC8qKlxuICAgKiBEZWZhdWx0IHJldGVudGlvbiBwZXJpb2Qgb2YgNyBkYXlzLlxuICAgKi9cbiAgREVGQVVMVCA9IDcsXG5cbiAgLyoqXG4gICAqIExvbmcgdGVybSByZXRlbnRpb24gcGVyaW9kIG9mIDIgeWVhcnMuXG4gICAqL1xuICBMT05HX1RFUk0gPSA3MzFcbn1cbiJdfQ==