import { IBucket } from "@aws-cdk/aws-s3";
import { Construct, Duration, Stack } from "@aws-cdk/core";
/**
 * @stability stable
 */
export interface CacheProps {
    /**
     * The infix of the physical cache bucket name.
     *
     * @default "runner-cache"
     * @stability stable
     */
    readonly bucketName?: string;
    /**
     * The number of days after which the created cache objects are deleted from S3.
     *
     * @default 30 days
     * @stability stable
     */
    readonly expiration?: Duration;
}
/**
 * A GitLab Runner cache consisting of an Amazon S3 bucket.
 *
 * The bucket is encrypted with a KMS managed master key, it has public access blocked and will be cleared and deleted on CFN stack deletion.
 *
 * @stability stable
 */
export declare class Cache extends Construct {
    /**
     * @stability stable
     */
    readonly bucket: IBucket;
    /**
     * @stability stable
     */
    readonly lifeCycleRuleEnabled: boolean;
    /**
     * @stability stable
     */
    readonly expiration: Duration;
    /**
     * @stability stable
     */
    constructor(scope: Stack, id: string, props?: CacheProps);
}
