# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['fastq_handler']

package_data = \
{'': ['*']}

install_requires = \
['dataclasses==0.6',
 'natsort==8.3.1',
 'pandas==1.5.3',
 'pip==21.2.3',
 'setuptools==57.4.0',
 'xopen==1.7.0']

entry_points = \
{'console_scripts': ['fastq_handler = fastq_handler.__main__:main']}

setup_kwargs = {
    'name': 'fastq-handler',
    'version': '0.1.1',
    'description': 'A python module to process minion fastq files by concatenating reads as they are generated',
    'long_description': '# Fastq Handler\n\nA python module to process minion fastq files by concatenating reads as they are generated.\n\n## INTRODUCTION\n\nThe _fastq_handler_ mmodule screens folders and subfolders for fastq files as they are generated by the MinION sequencer and concatenates them iteratively. This is useful for long reads that are split into multiple files. The output is a one file per\noutput fastq.gz, containing all reads from the previous files. The output directory structure is maintained.\n\n## INPUT\n\nA directory containing fastq files. The files can be in subfolders. The files can be gzipped or not.\n\n## USAGE\n\n```bash\nusage: fastq_handler.py [-h] [-i INPUT] [-o OUTPUT] [-n TAG] [--keep_names]\n\nparse arguments\n\noptional arguments:\n    -h, --help            show this help message and exit\n    -i INPUT, --input INPUT\n                        Input directory\n    -o OUTPUT, --output OUTPUT\n                        Output directory\n    -n TAG, --tag TAG     Tag to add to output file name\n    --keep_names          Keep original file names in output file\n    --monitor             run indefinitely\n```\n\n## REQUIREMENTS\n\n**Modules**\n\n- dataclasses==0.6\n- natsort==8.3.1\n- pandas==1.5.3\n- pip==21.2.3\n- pytest==7.2.2\n- setuptools==57.4.0\n- xopen==1.7.0\n\n## INSTALLATION\n\n```bash\npython -m venv .venv\nsource .venv/bin/activate\npython -m pip install fastq_handler\n```\n\n## MAIN OUTPUTS\n\n> **Note:** The output directory structure is maintained.\n\n- **fastq.gz** files containing all reads from the previous files.\n- **log.txt** file containing the concatenation process.\n\n## Maintainers\n\n- [**@xiaodre21**](https://github.com/xiaodre21)\n- [**@santosjgnd**](https://github.com/SantosJGND)\n- [**@insaflu**](https://github.com/insapathogenomics)\n',
    'author': 'SantosJGND',
    'author_email': 'dourado.jns@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
