# Fastq Handler

A python module to process minion fastq files by concatenating reads as they are generated.

## INTRODUCTION

The _fastq_handler_ mmodule screens folders and subfolders for fastq files as they are generated by the MinION sequencer and concatenates them iteratively. This is useful for long reads that are split into multiple files. The output is a one file per
output fastq.gz, containing all reads from the previous files. The output directory structure is maintained.

## INPUT

A directory containing fastq files. The files can be in subfolders. The files can be gzipped or not.

## USAGE

```bash
usage: fastq_handler.py [-h] [-i INPUT] [-o OUTPUT] [-n TAG] [--keep_names]

parse arguments

optional arguments:
    -h, --help            show this help message and exit
    -i INPUT, --input INPUT
                        Input directory
    -o OUTPUT, --output OUTPUT
                        Output directory
    -n TAG, --tag TAG     Tag to add to output file name
    --keep_names          Keep original file names in output file
    --monitor             run indefinitely
```

## REQUIREMENTS

**Modules**

- dataclasses==0.6
- natsort==8.3.1
- pandas==1.5.3
- pip==21.2.3
- pytest==7.2.2
- setuptools==57.4.0
- xopen==1.7.0

## INSTALLATION

```bash
python -m venv .venv
source .venv/bin/activate
python -m pip install fastq_handler
```

## MAIN OUTPUTS

> **Note:** The output directory structure is maintained.

- **fastq.gz** files containing all reads from the previous files.
- **log.txt** file containing the concatenation process.

## Maintainers

- [**@xiaodre21**](https://github.com/xiaodre21)
- [**@santosjgnd**](https://github.com/SantosJGND)
- [**@insaflu**](https://github.com/insapathogenomics)
