# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = ['WorkflowExecutionArgs', 'WorkflowExecution']

@pulumi.input_type
class WorkflowExecutionArgs:
    def __init__(__self__, *,
                 executions_id: pulumi.Input[str],
                 locations_id: pulumi.Input[str],
                 projects_id: pulumi.Input[str],
                 workflows_id: pulumi.Input[str],
                 argument: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a WorkflowExecution resource.
        :param pulumi.Input[str] argument: Input parameters of the execution represented as a JSON string. The size limit is 32KB. *Note*: If you are using the REST API directly to run your workflow, you must escape any JSON string value of `argument`. Example: `'{"argument":"{\"firstName\":\"FIRST\",\"lastName\":\"LAST\"}"}'`
        """
        pulumi.set(__self__, "executions_id", executions_id)
        pulumi.set(__self__, "locations_id", locations_id)
        pulumi.set(__self__, "projects_id", projects_id)
        pulumi.set(__self__, "workflows_id", workflows_id)
        if argument is not None:
            pulumi.set(__self__, "argument", argument)

    @property
    @pulumi.getter(name="executionsId")
    def executions_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "executions_id")

    @executions_id.setter
    def executions_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "executions_id", value)

    @property
    @pulumi.getter(name="locationsId")
    def locations_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "locations_id")

    @locations_id.setter
    def locations_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "locations_id", value)

    @property
    @pulumi.getter(name="projectsId")
    def projects_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "projects_id")

    @projects_id.setter
    def projects_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "projects_id", value)

    @property
    @pulumi.getter(name="workflowsId")
    def workflows_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "workflows_id")

    @workflows_id.setter
    def workflows_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "workflows_id", value)

    @property
    @pulumi.getter
    def argument(self) -> Optional[pulumi.Input[str]]:
        """
        Input parameters of the execution represented as a JSON string. The size limit is 32KB. *Note*: If you are using the REST API directly to run your workflow, you must escape any JSON string value of `argument`. Example: `'{"argument":"{\"firstName\":\"FIRST\",\"lastName\":\"LAST\"}"}'`
        """
        return pulumi.get(self, "argument")

    @argument.setter
    def argument(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "argument", value)


class WorkflowExecution(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 argument: Optional[pulumi.Input[str]] = None,
                 executions_id: Optional[pulumi.Input[str]] = None,
                 locations_id: Optional[pulumi.Input[str]] = None,
                 projects_id: Optional[pulumi.Input[str]] = None,
                 workflows_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates a new execution using the latest revision of the given workflow.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] argument: Input parameters of the execution represented as a JSON string. The size limit is 32KB. *Note*: If you are using the REST API directly to run your workflow, you must escape any JSON string value of `argument`. Example: `'{"argument":"{\"firstName\":\"FIRST\",\"lastName\":\"LAST\"}"}'`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkflowExecutionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a new execution using the latest revision of the given workflow.

        :param str resource_name: The name of the resource.
        :param WorkflowExecutionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkflowExecutionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 argument: Optional[pulumi.Input[str]] = None,
                 executions_id: Optional[pulumi.Input[str]] = None,
                 locations_id: Optional[pulumi.Input[str]] = None,
                 projects_id: Optional[pulumi.Input[str]] = None,
                 workflows_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkflowExecutionArgs.__new__(WorkflowExecutionArgs)

            __props__.__dict__["argument"] = argument
            if executions_id is None and not opts.urn:
                raise TypeError("Missing required property 'executions_id'")
            __props__.__dict__["executions_id"] = executions_id
            if locations_id is None and not opts.urn:
                raise TypeError("Missing required property 'locations_id'")
            __props__.__dict__["locations_id"] = locations_id
            if projects_id is None and not opts.urn:
                raise TypeError("Missing required property 'projects_id'")
            __props__.__dict__["projects_id"] = projects_id
            if workflows_id is None and not opts.urn:
                raise TypeError("Missing required property 'workflows_id'")
            __props__.__dict__["workflows_id"] = workflows_id
            __props__.__dict__["end_time"] = None
            __props__.__dict__["error"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["result"] = None
            __props__.__dict__["start_time"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["workflow_revision_id"] = None
        super(WorkflowExecution, __self__).__init__(
            'google-native:workflowexecutions/v1beta:WorkflowExecution',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'WorkflowExecution':
        """
        Get an existing WorkflowExecution resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = WorkflowExecutionArgs.__new__(WorkflowExecutionArgs)

        __props__.__dict__["argument"] = None
        __props__.__dict__["end_time"] = None
        __props__.__dict__["error"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["result"] = None
        __props__.__dict__["start_time"] = None
        __props__.__dict__["state"] = None
        __props__.__dict__["workflow_revision_id"] = None
        return WorkflowExecution(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def argument(self) -> pulumi.Output[str]:
        """
        Input parameters of the execution represented as a JSON string. The size limit is 32KB. *Note*: If you are using the REST API directly to run your workflow, you must escape any JSON string value of `argument`. Example: `'{"argument":"{\"firstName\":\"FIRST\",\"lastName\":\"LAST\"}"}'`
        """
        return pulumi.get(self, "argument")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> pulumi.Output[str]:
        """
        Marks the end of execution, successful or not.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter
    def error(self) -> pulumi.Output['outputs.ErrorResponse']:
        """
        The error which caused the execution to finish prematurely. The value is only present if the execution's state is `FAILED` or `CANCELLED`.
        """
        return pulumi.get(self, "error")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The resource name of the execution. Format: projects/{project}/locations/{location}/workflows/{workflow}/executions/{execution}
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def result(self) -> pulumi.Output[str]:
        """
        Output of the execution represented as a JSON string. The value can only be present if the execution's state is `SUCCEEDED`.
        """
        return pulumi.get(self, "result")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Output[str]:
        """
        Marks the beginning of execution.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        Current state of the execution.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="workflowRevisionId")
    def workflow_revision_id(self) -> pulumi.Output[str]:
        """
        Revision of the workflow this execution is using.
        """
        return pulumi.get(self, "workflow_revision_id")

