# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'AndroidAppInfoResponse',
    'AndroidInstrumentationTestResponse',
    'AndroidRoboTestResponse',
    'AndroidTestLoopResponse',
    'AndroidTestResponse',
    'AnyResponse',
    'BasicPerfSampleSeriesResponse',
    'DurationResponse',
    'FailureDetailResponse',
    'FileReferenceResponse',
    'InconclusiveDetailResponse',
    'IndividualOutcomeResponse',
    'IosAppInfoResponse',
    'IosRoboTestResponse',
    'IosTestLoopResponse',
    'IosTestResponse',
    'IosXcTestResponse',
    'MatrixDimensionDefinitionResponse',
    'MultiStepResponse',
    'OutcomeResponse',
    'PrimaryStepResponse',
    'SkippedDetailResponse',
    'SpecificationResponse',
    'StackTraceResponse',
    'StepDimensionValueEntryResponse',
    'StepLabelsEntryResponse',
    'SuccessDetailResponse',
    'TestCaseReferenceResponse',
    'TestExecutionStepResponse',
    'TestIssueResponse',
    'TestSuiteOverviewResponse',
    'TestTimingResponse',
    'TimestampResponse',
    'ToolExecutionResponse',
    'ToolExecutionStepResponse',
    'ToolExitCodeResponse',
    'ToolOutputReferenceResponse',
]

@pulumi.output_type
class AndroidAppInfoResponse(dict):
    """
    Android app information.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "packageName":
            suggest = "package_name"
        elif key == "versionCode":
            suggest = "version_code"
        elif key == "versionName":
            suggest = "version_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AndroidAppInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AndroidAppInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AndroidAppInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 package_name: str,
                 version_code: str,
                 version_name: str):
        """
        Android app information.
        :param str name: The name of the app. Optional
        :param str package_name: The package name of the app. Required.
        :param str version_code: The internal version code of the app. Optional.
        :param str version_name: The version name of the app. Optional.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "package_name", package_name)
        pulumi.set(__self__, "version_code", version_code)
        pulumi.set(__self__, "version_name", version_name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the app. Optional
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="packageName")
    def package_name(self) -> str:
        """
        The package name of the app. Required.
        """
        return pulumi.get(self, "package_name")

    @property
    @pulumi.getter(name="versionCode")
    def version_code(self) -> str:
        """
        The internal version code of the app. Optional.
        """
        return pulumi.get(self, "version_code")

    @property
    @pulumi.getter(name="versionName")
    def version_name(self) -> str:
        """
        The version name of the app. Optional.
        """
        return pulumi.get(self, "version_name")


@pulumi.output_type
class AndroidInstrumentationTestResponse(dict):
    """
    A test of an Android application that can control an Android component independently of its normal lifecycle. See for more information on types of Android tests.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "testPackageId":
            suggest = "test_package_id"
        elif key == "testRunnerClass":
            suggest = "test_runner_class"
        elif key == "testTargets":
            suggest = "test_targets"
        elif key == "useOrchestrator":
            suggest = "use_orchestrator"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AndroidInstrumentationTestResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AndroidInstrumentationTestResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AndroidInstrumentationTestResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 test_package_id: str,
                 test_runner_class: str,
                 test_targets: Sequence[str],
                 use_orchestrator: bool):
        """
        A test of an Android application that can control an Android component independently of its normal lifecycle. See for more information on types of Android tests.
        :param str test_package_id: The java package for the test to be executed. Required
        :param str test_runner_class: The InstrumentationTestRunner class. Required
        :param Sequence[str] test_targets: Each target must be fully qualified with the package name or class name, in one of these formats: - "package package_name" - "class package_name.class_name" - "class package_name.class_name#method_name" If empty, all targets in the module will be run.
        :param bool use_orchestrator: The flag indicates whether Android Test Orchestrator will be used to run test or not.
        """
        pulumi.set(__self__, "test_package_id", test_package_id)
        pulumi.set(__self__, "test_runner_class", test_runner_class)
        pulumi.set(__self__, "test_targets", test_targets)
        pulumi.set(__self__, "use_orchestrator", use_orchestrator)

    @property
    @pulumi.getter(name="testPackageId")
    def test_package_id(self) -> str:
        """
        The java package for the test to be executed. Required
        """
        return pulumi.get(self, "test_package_id")

    @property
    @pulumi.getter(name="testRunnerClass")
    def test_runner_class(self) -> str:
        """
        The InstrumentationTestRunner class. Required
        """
        return pulumi.get(self, "test_runner_class")

    @property
    @pulumi.getter(name="testTargets")
    def test_targets(self) -> Sequence[str]:
        """
        Each target must be fully qualified with the package name or class name, in one of these formats: - "package package_name" - "class package_name.class_name" - "class package_name.class_name#method_name" If empty, all targets in the module will be run.
        """
        return pulumi.get(self, "test_targets")

    @property
    @pulumi.getter(name="useOrchestrator")
    def use_orchestrator(self) -> bool:
        """
        The flag indicates whether Android Test Orchestrator will be used to run test or not.
        """
        return pulumi.get(self, "use_orchestrator")


@pulumi.output_type
class AndroidRoboTestResponse(dict):
    """
    A test of an android application that explores the application on a virtual or physical Android device, finding culprits and crashes as it goes.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appInitialActivity":
            suggest = "app_initial_activity"
        elif key == "bootstrapPackageId":
            suggest = "bootstrap_package_id"
        elif key == "bootstrapRunnerClass":
            suggest = "bootstrap_runner_class"
        elif key == "maxDepth":
            suggest = "max_depth"
        elif key == "maxSteps":
            suggest = "max_steps"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AndroidRoboTestResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AndroidRoboTestResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AndroidRoboTestResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_initial_activity: str,
                 bootstrap_package_id: str,
                 bootstrap_runner_class: str,
                 max_depth: int,
                 max_steps: int):
        """
        A test of an android application that explores the application on a virtual or physical Android device, finding culprits and crashes as it goes.
        :param str app_initial_activity: The initial activity that should be used to start the app. Optional
        :param str bootstrap_package_id: The java package for the bootstrap. Optional
        :param str bootstrap_runner_class: The runner class for the bootstrap. Optional
        :param int max_depth: The max depth of the traversal stack Robo can explore. Optional
        :param int max_steps: The max number of steps/actions Robo can execute. Default is no limit (0). Optional
        """
        pulumi.set(__self__, "app_initial_activity", app_initial_activity)
        pulumi.set(__self__, "bootstrap_package_id", bootstrap_package_id)
        pulumi.set(__self__, "bootstrap_runner_class", bootstrap_runner_class)
        pulumi.set(__self__, "max_depth", max_depth)
        pulumi.set(__self__, "max_steps", max_steps)

    @property
    @pulumi.getter(name="appInitialActivity")
    def app_initial_activity(self) -> str:
        """
        The initial activity that should be used to start the app. Optional
        """
        return pulumi.get(self, "app_initial_activity")

    @property
    @pulumi.getter(name="bootstrapPackageId")
    def bootstrap_package_id(self) -> str:
        """
        The java package for the bootstrap. Optional
        """
        return pulumi.get(self, "bootstrap_package_id")

    @property
    @pulumi.getter(name="bootstrapRunnerClass")
    def bootstrap_runner_class(self) -> str:
        """
        The runner class for the bootstrap. Optional
        """
        return pulumi.get(self, "bootstrap_runner_class")

    @property
    @pulumi.getter(name="maxDepth")
    def max_depth(self) -> int:
        """
        The max depth of the traversal stack Robo can explore. Optional
        """
        return pulumi.get(self, "max_depth")

    @property
    @pulumi.getter(name="maxSteps")
    def max_steps(self) -> int:
        """
        The max number of steps/actions Robo can execute. Default is no limit (0). Optional
        """
        return pulumi.get(self, "max_steps")


@pulumi.output_type
class AndroidTestLoopResponse(dict):
    """
    Test Loops are tests that can be launched by the app itself, determining when to run by listening for an intent.
    """
    def __init__(__self__):
        """
        Test Loops are tests that can be launched by the app itself, determining when to run by listening for an intent.
        """
        pass


@pulumi.output_type
class AndroidTestResponse(dict):
    """
    An Android mobile test specification.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "androidAppInfo":
            suggest = "android_app_info"
        elif key == "androidInstrumentationTest":
            suggest = "android_instrumentation_test"
        elif key == "androidRoboTest":
            suggest = "android_robo_test"
        elif key == "androidTestLoop":
            suggest = "android_test_loop"
        elif key == "testTimeout":
            suggest = "test_timeout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AndroidTestResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AndroidTestResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AndroidTestResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 android_app_info: 'outputs.AndroidAppInfoResponse',
                 android_instrumentation_test: 'outputs.AndroidInstrumentationTestResponse',
                 android_robo_test: 'outputs.AndroidRoboTestResponse',
                 android_test_loop: 'outputs.AndroidTestLoopResponse',
                 test_timeout: 'outputs.DurationResponse'):
        """
        An Android mobile test specification.
        :param 'AndroidAppInfoResponse' android_app_info: Information about the application under test.
        :param 'AndroidInstrumentationTestResponse' android_instrumentation_test: An Android instrumentation test.
        :param 'AndroidRoboTestResponse' android_robo_test: An Android robo test.
        :param 'AndroidTestLoopResponse' android_test_loop: An Android test loop.
        :param 'DurationResponse' test_timeout: Max time a test is allowed to run before it is automatically cancelled.
        """
        pulumi.set(__self__, "android_app_info", android_app_info)
        pulumi.set(__self__, "android_instrumentation_test", android_instrumentation_test)
        pulumi.set(__self__, "android_robo_test", android_robo_test)
        pulumi.set(__self__, "android_test_loop", android_test_loop)
        pulumi.set(__self__, "test_timeout", test_timeout)

    @property
    @pulumi.getter(name="androidAppInfo")
    def android_app_info(self) -> 'outputs.AndroidAppInfoResponse':
        """
        Information about the application under test.
        """
        return pulumi.get(self, "android_app_info")

    @property
    @pulumi.getter(name="androidInstrumentationTest")
    def android_instrumentation_test(self) -> 'outputs.AndroidInstrumentationTestResponse':
        """
        An Android instrumentation test.
        """
        return pulumi.get(self, "android_instrumentation_test")

    @property
    @pulumi.getter(name="androidRoboTest")
    def android_robo_test(self) -> 'outputs.AndroidRoboTestResponse':
        """
        An Android robo test.
        """
        return pulumi.get(self, "android_robo_test")

    @property
    @pulumi.getter(name="androidTestLoop")
    def android_test_loop(self) -> 'outputs.AndroidTestLoopResponse':
        """
        An Android test loop.
        """
        return pulumi.get(self, "android_test_loop")

    @property
    @pulumi.getter(name="testTimeout")
    def test_timeout(self) -> 'outputs.DurationResponse':
        """
        Max time a test is allowed to run before it is automatically cancelled.
        """
        return pulumi.get(self, "test_timeout")


@pulumi.output_type
class AnyResponse(dict):
    """
     `Any` contains an arbitrary serialized protocol buffer message along with a URL that describes the type of the serialized message. Protobuf library provides support to pack/unpack Any values in the form of utility functions or additional generated methods of the Any type. Example 1: Pack and unpack a message in C++. Foo foo = ...; Any any; any.PackFrom(foo); ... if (any.UnpackTo(&foo)) { ... } Example 2: Pack and unpack a message in Java. Foo foo = ...; Any any = Any.pack(foo); ... if (any.is(Foo.class)) { foo = any.unpack(Foo.class); } Example 3: Pack and unpack a message in Python. foo = Foo(...) any = Any() any.Pack(foo) ... if any.Is(Foo.DESCRIPTOR): any.Unpack(foo) ... Example 4: Pack and unpack a message in Go foo := &pb.Foo{...} any, err := ptypes.MarshalAny(foo) ... foo := &pb.Foo{} if err := ptypes.UnmarshalAny(any, foo); err != nil { ... } The pack methods provided by protobuf library will by default use 'type.googleapis.com/full.type.name' as the type URL and the unpack methods only use the fully qualified type name after the last '/' in the type URL, for example "foo.bar.com/x/y.z" will yield type name "y.z". # JSON The JSON representation of an `Any` value uses the regular representation of the deserialized, embedded message, with an additional field `@type` which contains the type URL. Example: package google.profile; message Person { string first_name = 1; string last_name = 2; } { "@type": "type.googleapis.com/google.profile.Person", "firstName": , "lastName": } If the embedded message type is well-known and has a custom JSON representation, that representation will be embedded adding a field `value` which holds the custom JSON in addition to the `@type` field. Example (for message google.protobuf.Duration): { "@type": "type.googleapis.com/google.protobuf.Duration", "value": "1.212s" }
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "typeUrl":
            suggest = "type_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AnyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AnyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AnyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type_url: str,
                 value: str):
        """
         `Any` contains an arbitrary serialized protocol buffer message along with a URL that describes the type of the serialized message. Protobuf library provides support to pack/unpack Any values in the form of utility functions or additional generated methods of the Any type. Example 1: Pack and unpack a message in C++. Foo foo = ...; Any any; any.PackFrom(foo); ... if (any.UnpackTo(&foo)) { ... } Example 2: Pack and unpack a message in Java. Foo foo = ...; Any any = Any.pack(foo); ... if (any.is(Foo.class)) { foo = any.unpack(Foo.class); } Example 3: Pack and unpack a message in Python. foo = Foo(...) any = Any() any.Pack(foo) ... if any.Is(Foo.DESCRIPTOR): any.Unpack(foo) ... Example 4: Pack and unpack a message in Go foo := &pb.Foo{...} any, err := ptypes.MarshalAny(foo) ... foo := &pb.Foo{} if err := ptypes.UnmarshalAny(any, foo); err != nil { ... } The pack methods provided by protobuf library will by default use 'type.googleapis.com/full.type.name' as the type URL and the unpack methods only use the fully qualified type name after the last '/' in the type URL, for example "foo.bar.com/x/y.z" will yield type name "y.z". # JSON The JSON representation of an `Any` value uses the regular representation of the deserialized, embedded message, with an additional field `@type` which contains the type URL. Example: package google.profile; message Person { string first_name = 1; string last_name = 2; } { "@type": "type.googleapis.com/google.profile.Person", "firstName": , "lastName": } If the embedded message type is well-known and has a custom JSON representation, that representation will be embedded adding a field `value` which holds the custom JSON in addition to the `@type` field. Example (for message google.protobuf.Duration): { "@type": "type.googleapis.com/google.protobuf.Duration", "value": "1.212s" }
        :param str type_url: A URL/resource name that uniquely identifies the type of the serialized protocol buffer message. This string must contain at least one "/" character. The last segment of the URL's path must represent the fully qualified name of the type (as in `path/google.protobuf.Duration`). The name should be in a canonical form (e.g., leading "." is not accepted). In practice, teams usually precompile into the binary all types that they expect it to use in the context of Any. However, for URLs which use the scheme `http`, `https`, or no scheme, one can optionally set up a type server that maps type URLs to message definitions as follows: * If no scheme is provided, `https` is assumed. * An HTTP GET on the URL must yield a google.protobuf.Type value in binary format, or produce an error. * Applications are allowed to cache lookup results based on the URL, or have them precompiled into a binary to avoid any lookup. Therefore, binary compatibility needs to be preserved on changes to types. (Use versioned type names to manage breaking changes.) Note: this functionality is not currently available in the official protobuf release, and it is not used for type URLs beginning with type.googleapis.com. Schemes other than `http`, `https` (or the empty scheme) might be used with implementation specific semantics.
        :param str value: Must be a valid serialized protocol buffer of the above specified type.
        """
        pulumi.set(__self__, "type_url", type_url)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="typeUrl")
    def type_url(self) -> str:
        """
        A URL/resource name that uniquely identifies the type of the serialized protocol buffer message. This string must contain at least one "/" character. The last segment of the URL's path must represent the fully qualified name of the type (as in `path/google.protobuf.Duration`). The name should be in a canonical form (e.g., leading "." is not accepted). In practice, teams usually precompile into the binary all types that they expect it to use in the context of Any. However, for URLs which use the scheme `http`, `https`, or no scheme, one can optionally set up a type server that maps type URLs to message definitions as follows: * If no scheme is provided, `https` is assumed. * An HTTP GET on the URL must yield a google.protobuf.Type value in binary format, or produce an error. * Applications are allowed to cache lookup results based on the URL, or have them precompiled into a binary to avoid any lookup. Therefore, binary compatibility needs to be preserved on changes to types. (Use versioned type names to manage breaking changes.) Note: this functionality is not currently available in the official protobuf release, and it is not used for type URLs beginning with type.googleapis.com. Schemes other than `http`, `https` (or the empty scheme) might be used with implementation specific semantics.
        """
        return pulumi.get(self, "type_url")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Must be a valid serialized protocol buffer of the above specified type.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class BasicPerfSampleSeriesResponse(dict):
    """
    Encapsulates the metadata for basic sample series represented by a line chart
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "perfMetricType":
            suggest = "perf_metric_type"
        elif key == "perfUnit":
            suggest = "perf_unit"
        elif key == "sampleSeriesLabel":
            suggest = "sample_series_label"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BasicPerfSampleSeriesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BasicPerfSampleSeriesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BasicPerfSampleSeriesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 perf_metric_type: str,
                 perf_unit: str,
                 sample_series_label: str):
        """
        Encapsulates the metadata for basic sample series represented by a line chart
        """
        pulumi.set(__self__, "perf_metric_type", perf_metric_type)
        pulumi.set(__self__, "perf_unit", perf_unit)
        pulumi.set(__self__, "sample_series_label", sample_series_label)

    @property
    @pulumi.getter(name="perfMetricType")
    def perf_metric_type(self) -> str:
        return pulumi.get(self, "perf_metric_type")

    @property
    @pulumi.getter(name="perfUnit")
    def perf_unit(self) -> str:
        return pulumi.get(self, "perf_unit")

    @property
    @pulumi.getter(name="sampleSeriesLabel")
    def sample_series_label(self) -> str:
        return pulumi.get(self, "sample_series_label")


@pulumi.output_type
class DurationResponse(dict):
    """
     A Duration represents a signed, fixed-length span of time represented as a count of seconds and fractions of seconds at nanosecond resolution. It is independent of any calendar and concepts like "day" or "month". It is related to Timestamp in that the difference between two Timestamp values is a Duration and it can be added or subtracted from a Timestamp. Range is approximately +-10,000 years.
    """
    def __init__(__self__, *,
                 nanos: int,
                 seconds: str):
        """
         A Duration represents a signed, fixed-length span of time represented as a count of seconds and fractions of seconds at nanosecond resolution. It is independent of any calendar and concepts like "day" or "month". It is related to Timestamp in that the difference between two Timestamp values is a Duration and it can be added or subtracted from a Timestamp. Range is approximately +-10,000 years.
        :param int nanos: Signed fractions of a second at nanosecond resolution of the span of time. Durations less than one second are represented with a 0 `seconds` field and a positive or negative `nanos` field. For durations of one second or more, a non-zero value for the `nanos` field must be of the same sign as the `seconds` field. Must be from -999,999,999 to +999,999,999 inclusive.
        :param str seconds: Signed seconds of the span of time. Must be from -315,576,000,000 to +315,576,000,000 inclusive. Note: these bounds are computed from: 60 sec/min * 60 min/hr * 24 hr/day * 365.25 days/year * 10000 years
        """
        pulumi.set(__self__, "nanos", nanos)
        pulumi.set(__self__, "seconds", seconds)

    @property
    @pulumi.getter
    def nanos(self) -> int:
        """
        Signed fractions of a second at nanosecond resolution of the span of time. Durations less than one second are represented with a 0 `seconds` field and a positive or negative `nanos` field. For durations of one second or more, a non-zero value for the `nanos` field must be of the same sign as the `seconds` field. Must be from -999,999,999 to +999,999,999 inclusive.
        """
        return pulumi.get(self, "nanos")

    @property
    @pulumi.getter
    def seconds(self) -> str:
        """
        Signed seconds of the span of time. Must be from -315,576,000,000 to +315,576,000,000 inclusive. Note: these bounds are computed from: 60 sec/min * 60 min/hr * 24 hr/day * 365.25 days/year * 10000 years
        """
        return pulumi.get(self, "seconds")


@pulumi.output_type
class FailureDetailResponse(dict):
    """
    Details for an outcome with a FAILURE outcome summary.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deviceOutOfMemory":
            suggest = "device_out_of_memory"
        elif key == "failedRoboscript":
            suggest = "failed_roboscript"
        elif key == "notInstalled":
            suggest = "not_installed"
        elif key == "otherNativeCrash":
            suggest = "other_native_crash"
        elif key == "timedOut":
            suggest = "timed_out"
        elif key == "unableToCrawl":
            suggest = "unable_to_crawl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FailureDetailResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FailureDetailResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FailureDetailResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 crashed: bool,
                 device_out_of_memory: bool,
                 failed_roboscript: bool,
                 not_installed: bool,
                 other_native_crash: bool,
                 timed_out: bool,
                 unable_to_crawl: bool):
        """
        Details for an outcome with a FAILURE outcome summary.
        :param bool crashed: If the failure was severe because the system (app) under test crashed.
        :param bool device_out_of_memory: If the device ran out of memory during a test, causing the test to crash.
        :param bool failed_roboscript: If the Roboscript failed to complete successfully, e.g., because a Roboscript action or assertion failed or a Roboscript action could not be matched during the entire crawl.
        :param bool not_installed: If an app is not installed and thus no test can be run with the app. This might be caused by trying to run a test on an unsupported platform.
        :param bool other_native_crash: If a native process (including any other than the app) crashed.
        :param bool timed_out: If the test overran some time limit, and that is why it failed.
        :param bool unable_to_crawl: If the robo was unable to crawl the app; perhaps because the app did not start.
        """
        pulumi.set(__self__, "crashed", crashed)
        pulumi.set(__self__, "device_out_of_memory", device_out_of_memory)
        pulumi.set(__self__, "failed_roboscript", failed_roboscript)
        pulumi.set(__self__, "not_installed", not_installed)
        pulumi.set(__self__, "other_native_crash", other_native_crash)
        pulumi.set(__self__, "timed_out", timed_out)
        pulumi.set(__self__, "unable_to_crawl", unable_to_crawl)

    @property
    @pulumi.getter
    def crashed(self) -> bool:
        """
        If the failure was severe because the system (app) under test crashed.
        """
        return pulumi.get(self, "crashed")

    @property
    @pulumi.getter(name="deviceOutOfMemory")
    def device_out_of_memory(self) -> bool:
        """
        If the device ran out of memory during a test, causing the test to crash.
        """
        return pulumi.get(self, "device_out_of_memory")

    @property
    @pulumi.getter(name="failedRoboscript")
    def failed_roboscript(self) -> bool:
        """
        If the Roboscript failed to complete successfully, e.g., because a Roboscript action or assertion failed or a Roboscript action could not be matched during the entire crawl.
        """
        return pulumi.get(self, "failed_roboscript")

    @property
    @pulumi.getter(name="notInstalled")
    def not_installed(self) -> bool:
        """
        If an app is not installed and thus no test can be run with the app. This might be caused by trying to run a test on an unsupported platform.
        """
        return pulumi.get(self, "not_installed")

    @property
    @pulumi.getter(name="otherNativeCrash")
    def other_native_crash(self) -> bool:
        """
        If a native process (including any other than the app) crashed.
        """
        return pulumi.get(self, "other_native_crash")

    @property
    @pulumi.getter(name="timedOut")
    def timed_out(self) -> bool:
        """
        If the test overran some time limit, and that is why it failed.
        """
        return pulumi.get(self, "timed_out")

    @property
    @pulumi.getter(name="unableToCrawl")
    def unable_to_crawl(self) -> bool:
        """
        If the robo was unable to crawl the app; perhaps because the app did not start.
        """
        return pulumi.get(self, "unable_to_crawl")


@pulumi.output_type
class FileReferenceResponse(dict):
    """
    A reference to a file.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fileUri":
            suggest = "file_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FileReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FileReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FileReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file_uri: str):
        """
        A reference to a file.
        :param str file_uri: The URI of a file stored in Google Cloud Storage. For example: http://storage.googleapis.com/mybucket/path/to/test.xml or in gsutil format: gs://mybucket/path/to/test.xml with version-specific info, gs://mybucket/path/to/test.xml#1360383693690000 An INVALID_ARGUMENT error will be returned if the URI format is not supported. - In response: always set - In create/update request: always set
        """
        pulumi.set(__self__, "file_uri", file_uri)

    @property
    @pulumi.getter(name="fileUri")
    def file_uri(self) -> str:
        """
        The URI of a file stored in Google Cloud Storage. For example: http://storage.googleapis.com/mybucket/path/to/test.xml or in gsutil format: gs://mybucket/path/to/test.xml with version-specific info, gs://mybucket/path/to/test.xml#1360383693690000 An INVALID_ARGUMENT error will be returned if the URI format is not supported. - In response: always set - In create/update request: always set
        """
        return pulumi.get(self, "file_uri")


@pulumi.output_type
class InconclusiveDetailResponse(dict):
    """
    Details for an outcome with an INCONCLUSIVE outcome summary.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "abortedByUser":
            suggest = "aborted_by_user"
        elif key == "hasErrorLogs":
            suggest = "has_error_logs"
        elif key == "infrastructureFailure":
            suggest = "infrastructure_failure"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InconclusiveDetailResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InconclusiveDetailResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InconclusiveDetailResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aborted_by_user: bool,
                 has_error_logs: bool,
                 infrastructure_failure: bool):
        """
        Details for an outcome with an INCONCLUSIVE outcome summary.
        :param bool aborted_by_user: If the end user aborted the test execution before a pass or fail could be determined. For example, the user pressed ctrl-c which sent a kill signal to the test runner while the test was running.
        :param bool has_error_logs: If results are being provided to the user in certain cases of infrastructure failures
        :param bool infrastructure_failure: If the test runner could not determine success or failure because the test depends on a component other than the system under test which failed. For example, a mobile test requires provisioning a device where the test executes, and that provisioning can fail.
        """
        pulumi.set(__self__, "aborted_by_user", aborted_by_user)
        pulumi.set(__self__, "has_error_logs", has_error_logs)
        pulumi.set(__self__, "infrastructure_failure", infrastructure_failure)

    @property
    @pulumi.getter(name="abortedByUser")
    def aborted_by_user(self) -> bool:
        """
        If the end user aborted the test execution before a pass or fail could be determined. For example, the user pressed ctrl-c which sent a kill signal to the test runner while the test was running.
        """
        return pulumi.get(self, "aborted_by_user")

    @property
    @pulumi.getter(name="hasErrorLogs")
    def has_error_logs(self) -> bool:
        """
        If results are being provided to the user in certain cases of infrastructure failures
        """
        return pulumi.get(self, "has_error_logs")

    @property
    @pulumi.getter(name="infrastructureFailure")
    def infrastructure_failure(self) -> bool:
        """
        If the test runner could not determine success or failure because the test depends on a component other than the system under test which failed. For example, a mobile test requires provisioning a device where the test executes, and that provisioning can fail.
        """
        return pulumi.get(self, "infrastructure_failure")


@pulumi.output_type
class IndividualOutcomeResponse(dict):
    """
    Step Id and outcome of each individual step that was run as a group with other steps with the same configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "multistepNumber":
            suggest = "multistep_number"
        elif key == "outcomeSummary":
            suggest = "outcome_summary"
        elif key == "runDuration":
            suggest = "run_duration"
        elif key == "stepId":
            suggest = "step_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IndividualOutcomeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IndividualOutcomeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IndividualOutcomeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 multistep_number: int,
                 outcome_summary: str,
                 run_duration: 'outputs.DurationResponse',
                 step_id: str):
        """
        Step Id and outcome of each individual step that was run as a group with other steps with the same configuration.
        :param int multistep_number: Unique int given to each step. Ranges from 0(inclusive) to total number of steps(exclusive). The primary step is 0.
        :param 'DurationResponse' run_duration: How long it took for this step to run.
        """
        pulumi.set(__self__, "multistep_number", multistep_number)
        pulumi.set(__self__, "outcome_summary", outcome_summary)
        pulumi.set(__self__, "run_duration", run_duration)
        pulumi.set(__self__, "step_id", step_id)

    @property
    @pulumi.getter(name="multistepNumber")
    def multistep_number(self) -> int:
        """
        Unique int given to each step. Ranges from 0(inclusive) to total number of steps(exclusive). The primary step is 0.
        """
        return pulumi.get(self, "multistep_number")

    @property
    @pulumi.getter(name="outcomeSummary")
    def outcome_summary(self) -> str:
        return pulumi.get(self, "outcome_summary")

    @property
    @pulumi.getter(name="runDuration")
    def run_duration(self) -> 'outputs.DurationResponse':
        """
        How long it took for this step to run.
        """
        return pulumi.get(self, "run_duration")

    @property
    @pulumi.getter(name="stepId")
    def step_id(self) -> str:
        return pulumi.get(self, "step_id")


@pulumi.output_type
class IosAppInfoResponse(dict):
    """
    iOS app information
    """
    def __init__(__self__, *,
                 name: str):
        """
        iOS app information
        :param str name: The name of the app. Required
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the app. Required
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class IosRoboTestResponse(dict):
    """
    A Robo test for an iOS application.
    """
    def __init__(__self__):
        """
        A Robo test for an iOS application.
        """
        pass


@pulumi.output_type
class IosTestLoopResponse(dict):
    """
    A game loop test of an iOS application.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bundleId":
            suggest = "bundle_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IosTestLoopResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IosTestLoopResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IosTestLoopResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bundle_id: str):
        """
        A game loop test of an iOS application.
        :param str bundle_id: Bundle ID of the app.
        """
        pulumi.set(__self__, "bundle_id", bundle_id)

    @property
    @pulumi.getter(name="bundleId")
    def bundle_id(self) -> str:
        """
        Bundle ID of the app.
        """
        return pulumi.get(self, "bundle_id")


@pulumi.output_type
class IosTestResponse(dict):
    """
    A iOS mobile test specification
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "iosAppInfo":
            suggest = "ios_app_info"
        elif key == "iosRoboTest":
            suggest = "ios_robo_test"
        elif key == "iosTestLoop":
            suggest = "ios_test_loop"
        elif key == "iosXcTest":
            suggest = "ios_xc_test"
        elif key == "testTimeout":
            suggest = "test_timeout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IosTestResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IosTestResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IosTestResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ios_app_info: 'outputs.IosAppInfoResponse',
                 ios_robo_test: 'outputs.IosRoboTestResponse',
                 ios_test_loop: 'outputs.IosTestLoopResponse',
                 ios_xc_test: 'outputs.IosXcTestResponse',
                 test_timeout: 'outputs.DurationResponse'):
        """
        A iOS mobile test specification
        :param 'IosAppInfoResponse' ios_app_info: Information about the application under test.
        :param 'IosRoboTestResponse' ios_robo_test: An iOS Robo test.
        :param 'IosTestLoopResponse' ios_test_loop: An iOS test loop.
        :param 'IosXcTestResponse' ios_xc_test: An iOS XCTest.
        :param 'DurationResponse' test_timeout: Max time a test is allowed to run before it is automatically cancelled.
        """
        pulumi.set(__self__, "ios_app_info", ios_app_info)
        pulumi.set(__self__, "ios_robo_test", ios_robo_test)
        pulumi.set(__self__, "ios_test_loop", ios_test_loop)
        pulumi.set(__self__, "ios_xc_test", ios_xc_test)
        pulumi.set(__self__, "test_timeout", test_timeout)

    @property
    @pulumi.getter(name="iosAppInfo")
    def ios_app_info(self) -> 'outputs.IosAppInfoResponse':
        """
        Information about the application under test.
        """
        return pulumi.get(self, "ios_app_info")

    @property
    @pulumi.getter(name="iosRoboTest")
    def ios_robo_test(self) -> 'outputs.IosRoboTestResponse':
        """
        An iOS Robo test.
        """
        return pulumi.get(self, "ios_robo_test")

    @property
    @pulumi.getter(name="iosTestLoop")
    def ios_test_loop(self) -> 'outputs.IosTestLoopResponse':
        """
        An iOS test loop.
        """
        return pulumi.get(self, "ios_test_loop")

    @property
    @pulumi.getter(name="iosXcTest")
    def ios_xc_test(self) -> 'outputs.IosXcTestResponse':
        """
        An iOS XCTest.
        """
        return pulumi.get(self, "ios_xc_test")

    @property
    @pulumi.getter(name="testTimeout")
    def test_timeout(self) -> 'outputs.DurationResponse':
        """
        Max time a test is allowed to run before it is automatically cancelled.
        """
        return pulumi.get(self, "test_timeout")


@pulumi.output_type
class IosXcTestResponse(dict):
    """
    A test of an iOS application that uses the XCTest framework.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bundleId":
            suggest = "bundle_id"
        elif key == "xcodeVersion":
            suggest = "xcode_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IosXcTestResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IosXcTestResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IosXcTestResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bundle_id: str,
                 xcode_version: str):
        """
        A test of an iOS application that uses the XCTest framework.
        :param str bundle_id: Bundle ID of the app.
        :param str xcode_version: Xcode version that the test was run with.
        """
        pulumi.set(__self__, "bundle_id", bundle_id)
        pulumi.set(__self__, "xcode_version", xcode_version)

    @property
    @pulumi.getter(name="bundleId")
    def bundle_id(self) -> str:
        """
        Bundle ID of the app.
        """
        return pulumi.get(self, "bundle_id")

    @property
    @pulumi.getter(name="xcodeVersion")
    def xcode_version(self) -> str:
        """
        Xcode version that the test was run with.
        """
        return pulumi.get(self, "xcode_version")


@pulumi.output_type
class MatrixDimensionDefinitionResponse(dict):
    """
    One dimension of the matrix of different runs of a step.
    """
    def __init__(__self__):
        """
        One dimension of the matrix of different runs of a step.
        """
        pass


@pulumi.output_type
class MultiStepResponse(dict):
    """
    Details when multiple steps are run with the same configuration as a group.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "multistepNumber":
            suggest = "multistep_number"
        elif key == "primaryStep":
            suggest = "primary_step"
        elif key == "primaryStepId":
            suggest = "primary_step_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MultiStepResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MultiStepResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MultiStepResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 multistep_number: int,
                 primary_step: 'outputs.PrimaryStepResponse',
                 primary_step_id: str):
        """
        Details when multiple steps are run with the same configuration as a group.
        :param int multistep_number: Unique int given to each step. Ranges from 0(inclusive) to total number of steps(exclusive). The primary step is 0.
        :param 'PrimaryStepResponse' primary_step: Present if it is a primary (original) step.
        :param str primary_step_id: Step Id of the primary (original) step, which might be this step.
        """
        pulumi.set(__self__, "multistep_number", multistep_number)
        pulumi.set(__self__, "primary_step", primary_step)
        pulumi.set(__self__, "primary_step_id", primary_step_id)

    @property
    @pulumi.getter(name="multistepNumber")
    def multistep_number(self) -> int:
        """
        Unique int given to each step. Ranges from 0(inclusive) to total number of steps(exclusive). The primary step is 0.
        """
        return pulumi.get(self, "multistep_number")

    @property
    @pulumi.getter(name="primaryStep")
    def primary_step(self) -> 'outputs.PrimaryStepResponse':
        """
        Present if it is a primary (original) step.
        """
        return pulumi.get(self, "primary_step")

    @property
    @pulumi.getter(name="primaryStepId")
    def primary_step_id(self) -> str:
        """
        Step Id of the primary (original) step, which might be this step.
        """
        return pulumi.get(self, "primary_step_id")


@pulumi.output_type
class OutcomeResponse(dict):
    """
    Interprets a result so that humans and machines can act on it.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failureDetail":
            suggest = "failure_detail"
        elif key == "inconclusiveDetail":
            suggest = "inconclusive_detail"
        elif key == "skippedDetail":
            suggest = "skipped_detail"
        elif key == "successDetail":
            suggest = "success_detail"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OutcomeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OutcomeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OutcomeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failure_detail: 'outputs.FailureDetailResponse',
                 inconclusive_detail: 'outputs.InconclusiveDetailResponse',
                 skipped_detail: 'outputs.SkippedDetailResponse',
                 success_detail: 'outputs.SuccessDetailResponse',
                 summary: str):
        """
        Interprets a result so that humans and machines can act on it.
        :param 'FailureDetailResponse' failure_detail: More information about a FAILURE outcome. Returns INVALID_ARGUMENT if this field is set but the summary is not FAILURE. Optional
        :param 'InconclusiveDetailResponse' inconclusive_detail: More information about an INCONCLUSIVE outcome. Returns INVALID_ARGUMENT if this field is set but the summary is not INCONCLUSIVE. Optional
        :param 'SkippedDetailResponse' skipped_detail: More information about a SKIPPED outcome. Returns INVALID_ARGUMENT if this field is set but the summary is not SKIPPED. Optional
        :param 'SuccessDetailResponse' success_detail: More information about a SUCCESS outcome. Returns INVALID_ARGUMENT if this field is set but the summary is not SUCCESS. Optional
        :param str summary: The simplest way to interpret a result. Required
        """
        pulumi.set(__self__, "failure_detail", failure_detail)
        pulumi.set(__self__, "inconclusive_detail", inconclusive_detail)
        pulumi.set(__self__, "skipped_detail", skipped_detail)
        pulumi.set(__self__, "success_detail", success_detail)
        pulumi.set(__self__, "summary", summary)

    @property
    @pulumi.getter(name="failureDetail")
    def failure_detail(self) -> 'outputs.FailureDetailResponse':
        """
        More information about a FAILURE outcome. Returns INVALID_ARGUMENT if this field is set but the summary is not FAILURE. Optional
        """
        return pulumi.get(self, "failure_detail")

    @property
    @pulumi.getter(name="inconclusiveDetail")
    def inconclusive_detail(self) -> 'outputs.InconclusiveDetailResponse':
        """
        More information about an INCONCLUSIVE outcome. Returns INVALID_ARGUMENT if this field is set but the summary is not INCONCLUSIVE. Optional
        """
        return pulumi.get(self, "inconclusive_detail")

    @property
    @pulumi.getter(name="skippedDetail")
    def skipped_detail(self) -> 'outputs.SkippedDetailResponse':
        """
        More information about a SKIPPED outcome. Returns INVALID_ARGUMENT if this field is set but the summary is not SKIPPED. Optional
        """
        return pulumi.get(self, "skipped_detail")

    @property
    @pulumi.getter(name="successDetail")
    def success_detail(self) -> 'outputs.SuccessDetailResponse':
        """
        More information about a SUCCESS outcome. Returns INVALID_ARGUMENT if this field is set but the summary is not SUCCESS. Optional
        """
        return pulumi.get(self, "success_detail")

    @property
    @pulumi.getter
    def summary(self) -> str:
        """
        The simplest way to interpret a result. Required
        """
        return pulumi.get(self, "summary")


@pulumi.output_type
class PrimaryStepResponse(dict):
    """
    Stores rollup test status of multiple steps that were run as a group and outcome of each individual step.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "individualOutcome":
            suggest = "individual_outcome"
        elif key == "rollUp":
            suggest = "roll_up"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrimaryStepResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrimaryStepResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrimaryStepResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 individual_outcome: Sequence['outputs.IndividualOutcomeResponse'],
                 roll_up: str):
        """
        Stores rollup test status of multiple steps that were run as a group and outcome of each individual step.
        :param Sequence['IndividualOutcomeResponse'] individual_outcome: Step Id and outcome of each individual step.
        :param str roll_up: Rollup test status of multiple steps that were run with the same configuration as a group.
        """
        pulumi.set(__self__, "individual_outcome", individual_outcome)
        pulumi.set(__self__, "roll_up", roll_up)

    @property
    @pulumi.getter(name="individualOutcome")
    def individual_outcome(self) -> Sequence['outputs.IndividualOutcomeResponse']:
        """
        Step Id and outcome of each individual step.
        """
        return pulumi.get(self, "individual_outcome")

    @property
    @pulumi.getter(name="rollUp")
    def roll_up(self) -> str:
        """
        Rollup test status of multiple steps that were run with the same configuration as a group.
        """
        return pulumi.get(self, "roll_up")


@pulumi.output_type
class SkippedDetailResponse(dict):
    """
    Details for an outcome with a SKIPPED outcome summary.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "incompatibleAppVersion":
            suggest = "incompatible_app_version"
        elif key == "incompatibleArchitecture":
            suggest = "incompatible_architecture"
        elif key == "incompatibleDevice":
            suggest = "incompatible_device"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SkippedDetailResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SkippedDetailResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SkippedDetailResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 incompatible_app_version: bool,
                 incompatible_architecture: bool,
                 incompatible_device: bool):
        """
        Details for an outcome with a SKIPPED outcome summary.
        :param bool incompatible_app_version: If the App doesn't support the specific API level.
        :param bool incompatible_architecture: If the App doesn't run on the specific architecture, for example, x86.
        :param bool incompatible_device: If the requested OS version doesn't run on the specific device model.
        """
        pulumi.set(__self__, "incompatible_app_version", incompatible_app_version)
        pulumi.set(__self__, "incompatible_architecture", incompatible_architecture)
        pulumi.set(__self__, "incompatible_device", incompatible_device)

    @property
    @pulumi.getter(name="incompatibleAppVersion")
    def incompatible_app_version(self) -> bool:
        """
        If the App doesn't support the specific API level.
        """
        return pulumi.get(self, "incompatible_app_version")

    @property
    @pulumi.getter(name="incompatibleArchitecture")
    def incompatible_architecture(self) -> bool:
        """
        If the App doesn't run on the specific architecture, for example, x86.
        """
        return pulumi.get(self, "incompatible_architecture")

    @property
    @pulumi.getter(name="incompatibleDevice")
    def incompatible_device(self) -> bool:
        """
        If the requested OS version doesn't run on the specific device model.
        """
        return pulumi.get(self, "incompatible_device")


@pulumi.output_type
class SpecificationResponse(dict):
    """
    The details about how to run the execution.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "androidTest":
            suggest = "android_test"
        elif key == "iosTest":
            suggest = "ios_test"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SpecificationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SpecificationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SpecificationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 android_test: 'outputs.AndroidTestResponse',
                 ios_test: 'outputs.IosTestResponse'):
        """
        The details about how to run the execution.
        :param 'AndroidTestResponse' android_test: An Android mobile test execution specification.
        :param 'IosTestResponse' ios_test: An iOS mobile test execution specification.
        """
        pulumi.set(__self__, "android_test", android_test)
        pulumi.set(__self__, "ios_test", ios_test)

    @property
    @pulumi.getter(name="androidTest")
    def android_test(self) -> 'outputs.AndroidTestResponse':
        """
        An Android mobile test execution specification.
        """
        return pulumi.get(self, "android_test")

    @property
    @pulumi.getter(name="iosTest")
    def ios_test(self) -> 'outputs.IosTestResponse':
        """
        An iOS mobile test execution specification.
        """
        return pulumi.get(self, "ios_test")


@pulumi.output_type
class StackTraceResponse(dict):
    """
    A stacktrace.
    """
    def __init__(__self__, *,
                 exception: str):
        """
        A stacktrace.
        :param str exception: The stack trace message. Required
        """
        pulumi.set(__self__, "exception", exception)

    @property
    @pulumi.getter
    def exception(self) -> str:
        """
        The stack trace message. Required
        """
        return pulumi.get(self, "exception")


@pulumi.output_type
class StepDimensionValueEntryResponse(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class StepLabelsEntryResponse(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class SuccessDetailResponse(dict):
    """
    Details for an outcome with a SUCCESS outcome summary. LINT.IfChange
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "otherNativeCrash":
            suggest = "other_native_crash"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SuccessDetailResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SuccessDetailResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SuccessDetailResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 other_native_crash: bool):
        """
        Details for an outcome with a SUCCESS outcome summary. LINT.IfChange
        :param bool other_native_crash: If a native process other than the app crashed.
        """
        pulumi.set(__self__, "other_native_crash", other_native_crash)

    @property
    @pulumi.getter(name="otherNativeCrash")
    def other_native_crash(self) -> bool:
        """
        If a native process other than the app crashed.
        """
        return pulumi.get(self, "other_native_crash")


@pulumi.output_type
class TestCaseReferenceResponse(dict):
    """
    A reference to a test case. Test case references are canonically ordered lexicographically by these three factors: * First, by test_suite_name. * Second, by class_name. * Third, by name.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "className":
            suggest = "class_name"
        elif key == "testSuiteName":
            suggest = "test_suite_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TestCaseReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TestCaseReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TestCaseReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 class_name: str,
                 name: str,
                 test_suite_name: str):
        """
        A reference to a test case. Test case references are canonically ordered lexicographically by these three factors: * First, by test_suite_name. * Second, by class_name. * Third, by name.
        :param str class_name: The name of the class.
        :param str name: The name of the test case. Required.
        :param str test_suite_name: The name of the test suite to which this test case belongs.
        """
        pulumi.set(__self__, "class_name", class_name)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "test_suite_name", test_suite_name)

    @property
    @pulumi.getter(name="className")
    def class_name(self) -> str:
        """
        The name of the class.
        """
        return pulumi.get(self, "class_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the test case. Required.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="testSuiteName")
    def test_suite_name(self) -> str:
        """
        The name of the test suite to which this test case belongs.
        """
        return pulumi.get(self, "test_suite_name")


@pulumi.output_type
class TestExecutionStepResponse(dict):
    """
    A step that represents running tests. It accepts ant-junit xml files which will be parsed into structured test results by the service. Xml file paths are updated in order to append more files, however they can't be deleted. Users can also add test results manually by using the test_result field.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "testIssues":
            suggest = "test_issues"
        elif key == "testSuiteOverviews":
            suggest = "test_suite_overviews"
        elif key == "testTiming":
            suggest = "test_timing"
        elif key == "toolExecution":
            suggest = "tool_execution"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TestExecutionStepResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TestExecutionStepResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TestExecutionStepResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 test_issues: Sequence['outputs.TestIssueResponse'],
                 test_suite_overviews: Sequence['outputs.TestSuiteOverviewResponse'],
                 test_timing: 'outputs.TestTimingResponse',
                 tool_execution: 'outputs.ToolExecutionResponse'):
        """
        A step that represents running tests. It accepts ant-junit xml files which will be parsed into structured test results by the service. Xml file paths are updated in order to append more files, however they can't be deleted. Users can also add test results manually by using the test_result field.
        :param Sequence['TestIssueResponse'] test_issues: Issues observed during the test execution. For example, if the mobile app under test crashed during the test, the error message and the stack trace content can be recorded here to assist debugging. - In response: present if set by create or update - In create/update request: optional
        :param Sequence['TestSuiteOverviewResponse'] test_suite_overviews: List of test suite overview contents. This could be parsed from xUnit XML log by server, or uploaded directly by user. This references should only be called when test suites are fully parsed or uploaded. The maximum allowed number of test suite overviews per step is 1000. - In response: always set - In create request: optional - In update request: never (use publishXunitXmlFiles custom method instead)
        :param 'TestTimingResponse' test_timing: The timing break down of the test execution. - In response: present if set by create or update - In create/update request: optional
        :param 'ToolExecutionResponse' tool_execution: Represents the execution of the test runner. The exit code of this tool will be used to determine if the test passed. - In response: always set - In create/update request: optional
        """
        pulumi.set(__self__, "test_issues", test_issues)
        pulumi.set(__self__, "test_suite_overviews", test_suite_overviews)
        pulumi.set(__self__, "test_timing", test_timing)
        pulumi.set(__self__, "tool_execution", tool_execution)

    @property
    @pulumi.getter(name="testIssues")
    def test_issues(self) -> Sequence['outputs.TestIssueResponse']:
        """
        Issues observed during the test execution. For example, if the mobile app under test crashed during the test, the error message and the stack trace content can be recorded here to assist debugging. - In response: present if set by create or update - In create/update request: optional
        """
        return pulumi.get(self, "test_issues")

    @property
    @pulumi.getter(name="testSuiteOverviews")
    def test_suite_overviews(self) -> Sequence['outputs.TestSuiteOverviewResponse']:
        """
        List of test suite overview contents. This could be parsed from xUnit XML log by server, or uploaded directly by user. This references should only be called when test suites are fully parsed or uploaded. The maximum allowed number of test suite overviews per step is 1000. - In response: always set - In create request: optional - In update request: never (use publishXunitXmlFiles custom method instead)
        """
        return pulumi.get(self, "test_suite_overviews")

    @property
    @pulumi.getter(name="testTiming")
    def test_timing(self) -> 'outputs.TestTimingResponse':
        """
        The timing break down of the test execution. - In response: present if set by create or update - In create/update request: optional
        """
        return pulumi.get(self, "test_timing")

    @property
    @pulumi.getter(name="toolExecution")
    def tool_execution(self) -> 'outputs.ToolExecutionResponse':
        """
        Represents the execution of the test runner. The exit code of this tool will be used to determine if the test passed. - In response: always set - In create/update request: optional
        """
        return pulumi.get(self, "tool_execution")


@pulumi.output_type
class TestIssueResponse(dict):
    """
    An issue detected occurring during a test execution.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorMessage":
            suggest = "error_message"
        elif key == "stackTrace":
            suggest = "stack_trace"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TestIssueResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TestIssueResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TestIssueResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 category: str,
                 error_message: str,
                 severity: str,
                 stack_trace: 'outputs.StackTraceResponse',
                 type: str,
                 warning: 'outputs.AnyResponse'):
        """
        An issue detected occurring during a test execution.
        :param str category: Category of issue. Required.
        :param str error_message: A brief human-readable message describing the issue. Required.
        :param str severity: Severity of issue. Required.
        :param 'StackTraceResponse' stack_trace: Deprecated in favor of stack trace fields inside specific warnings.
        :param str type: Type of issue. Required.
        :param 'AnyResponse' warning: Warning message with additional details of the issue. Should always be a message from com.google.devtools.toolresults.v1.warnings
        """
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "error_message", error_message)
        pulumi.set(__self__, "severity", severity)
        pulumi.set(__self__, "stack_trace", stack_trace)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "warning", warning)

    @property
    @pulumi.getter
    def category(self) -> str:
        """
        Category of issue. Required.
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> str:
        """
        A brief human-readable message describing the issue. Required.
        """
        return pulumi.get(self, "error_message")

    @property
    @pulumi.getter
    def severity(self) -> str:
        """
        Severity of issue. Required.
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter(name="stackTrace")
    def stack_trace(self) -> 'outputs.StackTraceResponse':
        """
        Deprecated in favor of stack trace fields inside specific warnings.
        """
        return pulumi.get(self, "stack_trace")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of issue. Required.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def warning(self) -> 'outputs.AnyResponse':
        """
        Warning message with additional details of the issue. Should always be a message from com.google.devtools.toolresults.v1.warnings
        """
        return pulumi.get(self, "warning")


@pulumi.output_type
class TestSuiteOverviewResponse(dict):
    """
    A summary of a test suite result either parsed from XML or uploaded directly by a user. Note: the API related comments are for StepService only. This message is also being used in ExecutionService in a read only mode for the corresponding step.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "elapsedTime":
            suggest = "elapsed_time"
        elif key == "errorCount":
            suggest = "error_count"
        elif key == "failureCount":
            suggest = "failure_count"
        elif key == "flakyCount":
            suggest = "flaky_count"
        elif key == "skippedCount":
            suggest = "skipped_count"
        elif key == "totalCount":
            suggest = "total_count"
        elif key == "xmlSource":
            suggest = "xml_source"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TestSuiteOverviewResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TestSuiteOverviewResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TestSuiteOverviewResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 elapsed_time: 'outputs.DurationResponse',
                 error_count: int,
                 failure_count: int,
                 flaky_count: int,
                 name: str,
                 skipped_count: int,
                 total_count: int,
                 xml_source: 'outputs.FileReferenceResponse'):
        """
        A summary of a test suite result either parsed from XML or uploaded directly by a user. Note: the API related comments are for StepService only. This message is also being used in ExecutionService in a read only mode for the corresponding step.
        :param 'DurationResponse' elapsed_time: Elapsed time of test suite.
        :param int error_count: Number of test cases in error, typically set by the service by parsing the xml_source. - In create/response: always set - In update request: never
        :param int failure_count: Number of failed test cases, typically set by the service by parsing the xml_source. May also be set by the user. - In create/response: always set - In update request: never
        :param int flaky_count: Number of flaky test cases, set by the service by rolling up flaky test attempts. Present only for rollup test suite overview at environment level. A step cannot have flaky test cases.
        :param str name: The name of the test suite. - In create/response: always set - In update request: never
        :param int skipped_count: Number of test cases not run, typically set by the service by parsing the xml_source. - In create/response: always set - In update request: never
        :param int total_count: Number of test cases, typically set by the service by parsing the xml_source. - In create/response: always set - In update request: never
        :param 'FileReferenceResponse' xml_source: If this test suite was parsed from XML, this is the URI where the original XML file is stored. Note: Multiple test suites can share the same xml_source Returns INVALID_ARGUMENT if the uri format is not supported. - In create/response: optional - In update request: never
        """
        pulumi.set(__self__, "elapsed_time", elapsed_time)
        pulumi.set(__self__, "error_count", error_count)
        pulumi.set(__self__, "failure_count", failure_count)
        pulumi.set(__self__, "flaky_count", flaky_count)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "skipped_count", skipped_count)
        pulumi.set(__self__, "total_count", total_count)
        pulumi.set(__self__, "xml_source", xml_source)

    @property
    @pulumi.getter(name="elapsedTime")
    def elapsed_time(self) -> 'outputs.DurationResponse':
        """
        Elapsed time of test suite.
        """
        return pulumi.get(self, "elapsed_time")

    @property
    @pulumi.getter(name="errorCount")
    def error_count(self) -> int:
        """
        Number of test cases in error, typically set by the service by parsing the xml_source. - In create/response: always set - In update request: never
        """
        return pulumi.get(self, "error_count")

    @property
    @pulumi.getter(name="failureCount")
    def failure_count(self) -> int:
        """
        Number of failed test cases, typically set by the service by parsing the xml_source. May also be set by the user. - In create/response: always set - In update request: never
        """
        return pulumi.get(self, "failure_count")

    @property
    @pulumi.getter(name="flakyCount")
    def flaky_count(self) -> int:
        """
        Number of flaky test cases, set by the service by rolling up flaky test attempts. Present only for rollup test suite overview at environment level. A step cannot have flaky test cases.
        """
        return pulumi.get(self, "flaky_count")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the test suite. - In create/response: always set - In update request: never
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="skippedCount")
    def skipped_count(self) -> int:
        """
        Number of test cases not run, typically set by the service by parsing the xml_source. - In create/response: always set - In update request: never
        """
        return pulumi.get(self, "skipped_count")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        Number of test cases, typically set by the service by parsing the xml_source. - In create/response: always set - In update request: never
        """
        return pulumi.get(self, "total_count")

    @property
    @pulumi.getter(name="xmlSource")
    def xml_source(self) -> 'outputs.FileReferenceResponse':
        """
        If this test suite was parsed from XML, this is the URI where the original XML file is stored. Note: Multiple test suites can share the same xml_source Returns INVALID_ARGUMENT if the uri format is not supported. - In create/response: optional - In update request: never
        """
        return pulumi.get(self, "xml_source")


@pulumi.output_type
class TestTimingResponse(dict):
    """
    Testing timing break down to know phases.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "testProcessDuration":
            suggest = "test_process_duration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TestTimingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TestTimingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TestTimingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 test_process_duration: 'outputs.DurationResponse'):
        """
        Testing timing break down to know phases.
        :param 'DurationResponse' test_process_duration: How long it took to run the test process. - In response: present if previously set. - In create/update request: optional
        """
        pulumi.set(__self__, "test_process_duration", test_process_duration)

    @property
    @pulumi.getter(name="testProcessDuration")
    def test_process_duration(self) -> 'outputs.DurationResponse':
        """
        How long it took to run the test process. - In response: present if previously set. - In create/update request: optional
        """
        return pulumi.get(self, "test_process_duration")


@pulumi.output_type
class TimestampResponse(dict):
    """
    A Timestamp represents a point in time independent of any time zone or local calendar, encoded as a count of seconds and fractions of seconds at nanosecond resolution. The count is relative to an epoch at UTC midnight on January 1, 1970, in the proleptic Gregorian calendar which extends the Gregorian calendar backwards to year one. All minutes are 60 seconds long. Leap seconds are "smeared" so that no leap second table is needed for interpretation, using a [24-hour linear smear](https://developers.google.com/time/smear). The range is from 0001-01-01T00:00:00Z to 9999-12-31T23:59:59.999999999Z. By restricting to that range, we ensure that we can convert to and from [RFC 3339](https://www.ietf.org/rfc/rfc3339.txt) date strings.
    """
    def __init__(__self__, *,
                 nanos: int,
                 seconds: str):
        """
        A Timestamp represents a point in time independent of any time zone or local calendar, encoded as a count of seconds and fractions of seconds at nanosecond resolution. The count is relative to an epoch at UTC midnight on January 1, 1970, in the proleptic Gregorian calendar which extends the Gregorian calendar backwards to year one. All minutes are 60 seconds long. Leap seconds are "smeared" so that no leap second table is needed for interpretation, using a [24-hour linear smear](https://developers.google.com/time/smear). The range is from 0001-01-01T00:00:00Z to 9999-12-31T23:59:59.999999999Z. By restricting to that range, we ensure that we can convert to and from [RFC 3339](https://www.ietf.org/rfc/rfc3339.txt) date strings.
        :param int nanos: Non-negative fractions of a second at nanosecond resolution. Negative second values with fractions must still have non-negative nanos values that count forward in time. Must be from 0 to 999,999,999 inclusive.
        :param str seconds: Represents seconds of UTC time since Unix epoch 1970-01-01T00:00:00Z. Must be from 0001-01-01T00:00:00Z to 9999-12-31T23:59:59Z inclusive.
        """
        pulumi.set(__self__, "nanos", nanos)
        pulumi.set(__self__, "seconds", seconds)

    @property
    @pulumi.getter
    def nanos(self) -> int:
        """
        Non-negative fractions of a second at nanosecond resolution. Negative second values with fractions must still have non-negative nanos values that count forward in time. Must be from 0 to 999,999,999 inclusive.
        """
        return pulumi.get(self, "nanos")

    @property
    @pulumi.getter
    def seconds(self) -> str:
        """
        Represents seconds of UTC time since Unix epoch 1970-01-01T00:00:00Z. Must be from 0001-01-01T00:00:00Z to 9999-12-31T23:59:59Z inclusive.
        """
        return pulumi.get(self, "seconds")


@pulumi.output_type
class ToolExecutionResponse(dict):
    """
    An execution of an arbitrary tool. It could be a test runner or a tool copying artifacts or deploying code.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "commandLineArguments":
            suggest = "command_line_arguments"
        elif key == "exitCode":
            suggest = "exit_code"
        elif key == "toolLogs":
            suggest = "tool_logs"
        elif key == "toolOutputs":
            suggest = "tool_outputs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ToolExecutionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ToolExecutionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ToolExecutionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 command_line_arguments: Sequence[str],
                 exit_code: 'outputs.ToolExitCodeResponse',
                 tool_logs: Sequence['outputs.FileReferenceResponse'],
                 tool_outputs: Sequence['outputs.ToolOutputReferenceResponse']):
        """
        An execution of an arbitrary tool. It could be a test runner or a tool copying artifacts or deploying code.
        :param Sequence[str] command_line_arguments: The full tokenized command line including the program name (equivalent to argv in a C program). - In response: present if set by create request - In create request: optional - In update request: never set
        :param 'ToolExitCodeResponse' exit_code: Tool execution exit code. This field will be set once the tool has exited. - In response: present if set by create/update request - In create request: optional - In update request: optional, a FAILED_PRECONDITION error will be returned if an exit_code is already set.
        :param Sequence['FileReferenceResponse'] tool_logs: References to any plain text logs output the tool execution. This field can be set before the tool has exited in order to be able to have access to a live view of the logs while the tool is running. The maximum allowed number of tool logs per step is 1000. - In response: present if set by create/update request - In create request: optional - In update request: optional, any value provided will be appended to the existing list
        :param Sequence['ToolOutputReferenceResponse'] tool_outputs: References to opaque files of any format output by the tool execution. The maximum allowed number of tool outputs per step is 1000. - In response: present if set by create/update request - In create request: optional - In update request: optional, any value provided will be appended to the existing list
        """
        pulumi.set(__self__, "command_line_arguments", command_line_arguments)
        pulumi.set(__self__, "exit_code", exit_code)
        pulumi.set(__self__, "tool_logs", tool_logs)
        pulumi.set(__self__, "tool_outputs", tool_outputs)

    @property
    @pulumi.getter(name="commandLineArguments")
    def command_line_arguments(self) -> Sequence[str]:
        """
        The full tokenized command line including the program name (equivalent to argv in a C program). - In response: present if set by create request - In create request: optional - In update request: never set
        """
        return pulumi.get(self, "command_line_arguments")

    @property
    @pulumi.getter(name="exitCode")
    def exit_code(self) -> 'outputs.ToolExitCodeResponse':
        """
        Tool execution exit code. This field will be set once the tool has exited. - In response: present if set by create/update request - In create request: optional - In update request: optional, a FAILED_PRECONDITION error will be returned if an exit_code is already set.
        """
        return pulumi.get(self, "exit_code")

    @property
    @pulumi.getter(name="toolLogs")
    def tool_logs(self) -> Sequence['outputs.FileReferenceResponse']:
        """
        References to any plain text logs output the tool execution. This field can be set before the tool has exited in order to be able to have access to a live view of the logs while the tool is running. The maximum allowed number of tool logs per step is 1000. - In response: present if set by create/update request - In create request: optional - In update request: optional, any value provided will be appended to the existing list
        """
        return pulumi.get(self, "tool_logs")

    @property
    @pulumi.getter(name="toolOutputs")
    def tool_outputs(self) -> Sequence['outputs.ToolOutputReferenceResponse']:
        """
        References to opaque files of any format output by the tool execution. The maximum allowed number of tool outputs per step is 1000. - In response: present if set by create/update request - In create request: optional - In update request: optional, any value provided will be appended to the existing list
        """
        return pulumi.get(self, "tool_outputs")


@pulumi.output_type
class ToolExecutionStepResponse(dict):
    """
    Generic tool step to be used for binaries we do not explicitly support. For example: running cp to copy artifacts from one location to another.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "toolExecution":
            suggest = "tool_execution"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ToolExecutionStepResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ToolExecutionStepResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ToolExecutionStepResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 tool_execution: 'outputs.ToolExecutionResponse'):
        """
        Generic tool step to be used for binaries we do not explicitly support. For example: running cp to copy artifacts from one location to another.
        :param 'ToolExecutionResponse' tool_execution: A Tool execution. - In response: present if set by create/update request - In create/update request: optional
        """
        pulumi.set(__self__, "tool_execution", tool_execution)

    @property
    @pulumi.getter(name="toolExecution")
    def tool_execution(self) -> 'outputs.ToolExecutionResponse':
        """
        A Tool execution. - In response: present if set by create/update request - In create/update request: optional
        """
        return pulumi.get(self, "tool_execution")


@pulumi.output_type
class ToolExitCodeResponse(dict):
    """
    Exit code from a tool execution.
    """
    def __init__(__self__, *,
                 number: int):
        """
        Exit code from a tool execution.
        :param int number: Tool execution exit code. A value of 0 means that the execution was successful. - In response: always set - In create/update request: always set
        """
        pulumi.set(__self__, "number", number)

    @property
    @pulumi.getter
    def number(self) -> int:
        """
        Tool execution exit code. A value of 0 means that the execution was successful. - In response: always set - In create/update request: always set
        """
        return pulumi.get(self, "number")


@pulumi.output_type
class ToolOutputReferenceResponse(dict):
    """
    A reference to a ToolExecution output file.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "creationTime":
            suggest = "creation_time"
        elif key == "testCase":
            suggest = "test_case"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ToolOutputReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ToolOutputReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ToolOutputReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 creation_time: 'outputs.TimestampResponse',
                 output: 'outputs.FileReferenceResponse',
                 test_case: 'outputs.TestCaseReferenceResponse'):
        """
        A reference to a ToolExecution output file.
        :param 'TimestampResponse' creation_time: The creation time of the file. - In response: present if set by create/update request - In create/update request: optional
        :param 'FileReferenceResponse' output: A FileReference to an output file. - In response: always set - In create/update request: always set
        :param 'TestCaseReferenceResponse' test_case: The test case to which this output file belongs. - In response: present if set by create/update request - In create/update request: optional
        """
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "output", output)
        pulumi.set(__self__, "test_case", test_case)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> 'outputs.TimestampResponse':
        """
        The creation time of the file. - In response: present if set by create/update request - In create/update request: optional
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def output(self) -> 'outputs.FileReferenceResponse':
        """
        A FileReference to an output file. - In response: always set - In create/update request: always set
        """
        return pulumi.get(self, "output")

    @property
    @pulumi.getter(name="testCase")
    def test_case(self) -> 'outputs.TestCaseReferenceResponse':
        """
        The test case to which this output file belongs. - In response: present if set by create/update request - In create/update request: optional
        """
        return pulumi.get(self, "test_case")


