# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'AwsAccessKeyResponse',
    'AwsS3DataResponse',
    'AzureBlobStorageDataResponse',
    'AzureCredentialsResponse',
    'DateResponse',
    'GcsDataResponse',
    'HttpDataResponse',
    'NotificationConfigResponse',
    'ObjectConditionsResponse',
    'ScheduleResponse',
    'TimeOfDayResponse',
    'TransferOptionsResponse',
    'TransferSpecResponse',
]

@pulumi.output_type
class AwsAccessKeyResponse(dict):
    """
    AWS access key (see [AWS Security Credentials](https://docs.aws.amazon.com/general/latest/gr/aws-security-credentials.html)). For information on our data retention policy for user credentials, see [User credentials](/storage-transfer/docs/data-retention#user-credentials).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKeyId":
            suggest = "access_key_id"
        elif key == "secretAccessKey":
            suggest = "secret_access_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AwsAccessKeyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AwsAccessKeyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AwsAccessKeyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_key_id: str,
                 secret_access_key: str):
        """
        AWS access key (see [AWS Security Credentials](https://docs.aws.amazon.com/general/latest/gr/aws-security-credentials.html)). For information on our data retention policy for user credentials, see [User credentials](/storage-transfer/docs/data-retention#user-credentials).
        :param str access_key_id: Required. AWS access key ID.
        :param str secret_access_key: Required. AWS secret access key. This field is not returned in RPC responses.
        """
        pulumi.set(__self__, "access_key_id", access_key_id)
        pulumi.set(__self__, "secret_access_key", secret_access_key)

    @property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> str:
        """
        Required. AWS access key ID.
        """
        return pulumi.get(self, "access_key_id")

    @property
    @pulumi.getter(name="secretAccessKey")
    def secret_access_key(self) -> str:
        """
        Required. AWS secret access key. This field is not returned in RPC responses.
        """
        return pulumi.get(self, "secret_access_key")


@pulumi.output_type
class AwsS3DataResponse(dict):
    """
    An AwsS3Data resource can be a data source, but not a data sink. In an AwsS3Data resource, an object's name is the S3 object's key name.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "awsAccessKey":
            suggest = "aws_access_key"
        elif key == "bucketName":
            suggest = "bucket_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AwsS3DataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AwsS3DataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AwsS3DataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aws_access_key: 'outputs.AwsAccessKeyResponse',
                 bucket_name: str,
                 path: str):
        """
        An AwsS3Data resource can be a data source, but not a data sink. In an AwsS3Data resource, an object's name is the S3 object's key name.
        :param 'AwsAccessKeyResponse' aws_access_key: Required. Input only. AWS access key used to sign the API requests to the AWS S3 bucket. Permissions on the bucket must be granted to the access ID of the AWS access key. For information on our data retention policy for user credentials, see [User credentials](/storage-transfer/docs/data-retention#user-credentials).
        :param str bucket_name: Required. S3 Bucket name (see [Creating a bucket](https://docs.aws.amazon.com/AmazonS3/latest/dev/create-bucket-get-location-example.html)).
        :param str path: Root path to transfer objects. Must be an empty string or full path name that ends with a '/'. This field is treated as an object prefix. As such, it should generally not begin with a '/'.
        """
        pulumi.set(__self__, "aws_access_key", aws_access_key)
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="awsAccessKey")
    def aws_access_key(self) -> 'outputs.AwsAccessKeyResponse':
        """
        Required. Input only. AWS access key used to sign the API requests to the AWS S3 bucket. Permissions on the bucket must be granted to the access ID of the AWS access key. For information on our data retention policy for user credentials, see [User credentials](/storage-transfer/docs/data-retention#user-credentials).
        """
        return pulumi.get(self, "aws_access_key")

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        """
        Required. S3 Bucket name (see [Creating a bucket](https://docs.aws.amazon.com/AmazonS3/latest/dev/create-bucket-get-location-example.html)).
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        Root path to transfer objects. Must be an empty string or full path name that ends with a '/'. This field is treated as an object prefix. As such, it should generally not begin with a '/'.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class AzureBlobStorageDataResponse(dict):
    """
    An AzureBlobStorageData resource can be a data source, but not a data sink. An AzureBlobStorageData resource represents one Azure container. The storage account determines the [Azure endpoint](https://docs.microsoft.com/en-us/azure/storage/common/storage-create-storage-account#storage-account-endpoints). In an AzureBlobStorageData resource, a blobs's name is the [Azure Blob Storage blob's key name](https://docs.microsoft.com/en-us/rest/api/storageservices/naming-and-referencing-containers--blobs--and-metadata#blob-names).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "azureCredentials":
            suggest = "azure_credentials"
        elif key == "storageAccount":
            suggest = "storage_account"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureBlobStorageDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureBlobStorageDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureBlobStorageDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 azure_credentials: 'outputs.AzureCredentialsResponse',
                 container: str,
                 path: str,
                 storage_account: str):
        """
        An AzureBlobStorageData resource can be a data source, but not a data sink. An AzureBlobStorageData resource represents one Azure container. The storage account determines the [Azure endpoint](https://docs.microsoft.com/en-us/azure/storage/common/storage-create-storage-account#storage-account-endpoints). In an AzureBlobStorageData resource, a blobs's name is the [Azure Blob Storage blob's key name](https://docs.microsoft.com/en-us/rest/api/storageservices/naming-and-referencing-containers--blobs--and-metadata#blob-names).
        :param 'AzureCredentialsResponse' azure_credentials: Required. Input only. Credentials used to authenticate API requests to Azure. For information on our data retention policy for user credentials, see [User credentials](/storage-transfer/docs/data-retention#user-credentials).
        :param str container: Required. The container to transfer from the Azure Storage account.
        :param str path: Root path to transfer objects. Must be an empty string or full path name that ends with a '/'. This field is treated as an object prefix. As such, it should generally not begin with a '/'.
        :param str storage_account: Required. The name of the Azure Storage account.
        """
        pulumi.set(__self__, "azure_credentials", azure_credentials)
        pulumi.set(__self__, "container", container)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "storage_account", storage_account)

    @property
    @pulumi.getter(name="azureCredentials")
    def azure_credentials(self) -> 'outputs.AzureCredentialsResponse':
        """
        Required. Input only. Credentials used to authenticate API requests to Azure. For information on our data retention policy for user credentials, see [User credentials](/storage-transfer/docs/data-retention#user-credentials).
        """
        return pulumi.get(self, "azure_credentials")

    @property
    @pulumi.getter
    def container(self) -> str:
        """
        Required. The container to transfer from the Azure Storage account.
        """
        return pulumi.get(self, "container")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        Root path to transfer objects. Must be an empty string or full path name that ends with a '/'. This field is treated as an object prefix. As such, it should generally not begin with a '/'.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="storageAccount")
    def storage_account(self) -> str:
        """
        Required. The name of the Azure Storage account.
        """
        return pulumi.get(self, "storage_account")


@pulumi.output_type
class AzureCredentialsResponse(dict):
    """
    Azure credentials For information on our data retention policy for user credentials, see [User credentials](/storage-transfer/docs/data-retention#user-credentials).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sasToken":
            suggest = "sas_token"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AzureCredentialsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AzureCredentialsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AzureCredentialsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sas_token: str):
        """
        Azure credentials For information on our data retention policy for user credentials, see [User credentials](/storage-transfer/docs/data-retention#user-credentials).
        :param str sas_token: Required. Azure shared access signature. (see [Grant limited access to Azure Storage resources using shared access signatures (SAS)](https://docs.microsoft.com/en-us/azure/storage/common/storage-sas-overview)).
        """
        pulumi.set(__self__, "sas_token", sas_token)

    @property
    @pulumi.getter(name="sasToken")
    def sas_token(self) -> str:
        """
        Required. Azure shared access signature. (see [Grant limited access to Azure Storage resources using shared access signatures (SAS)](https://docs.microsoft.com/en-us/azure/storage/common/storage-sas-overview)).
        """
        return pulumi.get(self, "sas_token")


@pulumi.output_type
class DateResponse(dict):
    """
    Represents a whole or partial calendar date, such as a birthday. The time of day and time zone are either specified elsewhere or are insignificant. The date is relative to the Gregorian Calendar. This can represent one of the following: * A full date, with non-zero year, month, and day values * A month and day value, with a zero year, such as an anniversary * A year on its own, with zero month and day values * A year and month value, with a zero day, such as a credit card expiration date Related types are google.type.TimeOfDay and `google.protobuf.Timestamp`.
    """
    def __init__(__self__, *,
                 day: int,
                 month: int,
                 year: int):
        """
        Represents a whole or partial calendar date, such as a birthday. The time of day and time zone are either specified elsewhere or are insignificant. The date is relative to the Gregorian Calendar. This can represent one of the following: * A full date, with non-zero year, month, and day values * A month and day value, with a zero year, such as an anniversary * A year on its own, with zero month and day values * A year and month value, with a zero day, such as a credit card expiration date Related types are google.type.TimeOfDay and `google.protobuf.Timestamp`.
        :param int day: Day of a month. Must be from 1 to 31 and valid for the year and month, or 0 to specify a year by itself or a year and month where the day isn't significant.
        :param int month: Month of a year. Must be from 1 to 12, or 0 to specify a year without a month and day.
        :param int year: Year of the date. Must be from 1 to 9999, or 0 to specify a date without a year.
        """
        pulumi.set(__self__, "day", day)
        pulumi.set(__self__, "month", month)
        pulumi.set(__self__, "year", year)

    @property
    @pulumi.getter
    def day(self) -> int:
        """
        Day of a month. Must be from 1 to 31 and valid for the year and month, or 0 to specify a year by itself or a year and month where the day isn't significant.
        """
        return pulumi.get(self, "day")

    @property
    @pulumi.getter
    def month(self) -> int:
        """
        Month of a year. Must be from 1 to 12, or 0 to specify a year without a month and day.
        """
        return pulumi.get(self, "month")

    @property
    @pulumi.getter
    def year(self) -> int:
        """
        Year of the date. Must be from 1 to 9999, or 0 to specify a date without a year.
        """
        return pulumi.get(self, "year")


@pulumi.output_type
class GcsDataResponse(dict):
    """
    In a GcsData resource, an object's name is the Cloud Storage object's name and its "last modification time" refers to the object's `updated` property of Cloud Storage objects, which changes when the content or the metadata of the object is updated.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GcsDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GcsDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GcsDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: str,
                 path: str):
        """
        In a GcsData resource, an object's name is the Cloud Storage object's name and its "last modification time" refers to the object's `updated` property of Cloud Storage objects, which changes when the content or the metadata of the object is updated.
        :param str bucket_name: Required. Cloud Storage bucket name (see [Bucket Name Requirements](https://cloud.google.com/storage/docs/naming#requirements)).
        :param str path: Root path to transfer objects. Must be an empty string or full path name that ends with a '/'. This field is treated as an object prefix. As such, it should generally not begin with a '/'. (must meet Object Name Requirements](https://cloud.google.com/storage/docs/naming#objectnames)).
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        """
        Required. Cloud Storage bucket name (see [Bucket Name Requirements](https://cloud.google.com/storage/docs/naming#requirements)).
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        Root path to transfer objects. Must be an empty string or full path name that ends with a '/'. This field is treated as an object prefix. As such, it should generally not begin with a '/'. (must meet Object Name Requirements](https://cloud.google.com/storage/docs/naming#objectnames)).
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class HttpDataResponse(dict):
    """
    An HttpData resource specifies a list of objects on the web to be transferred over HTTP. The information of the objects to be transferred is contained in a file referenced by a URL. The first line in the file must be `"TsvHttpData-1.0"`, which specifies the format of the file. Subsequent lines specify the information of the list of objects, one object per list entry. Each entry has the following tab-delimited fields: * **HTTP URL** — The location of the object. * **Length** — The size of the object in bytes. * **MD5** — The base64-encoded MD5 hash of the object. For an example of a valid TSV file, see [Transferring data from URLs](https://cloud.google.com/storage-transfer/docs/create-url-list). When transferring data based on a URL list, keep the following in mind: * When an object located at `http(s)://hostname:port/` is transferred to a data sink, the name of the object at the data sink is `/`. * If the specified size of an object does not match the actual size of the object fetched, the object will not be transferred. * If the specified MD5 does not match the MD5 computed from the transferred bytes, the object transfer will fail. * Ensure that each URL you specify is publicly accessible. For example, in Cloud Storage you can [share an object publicly] (https://cloud.google.com/storage/docs/cloud-console#_sharingdata) and get a link to it. * Storage Transfer Service obeys `robots.txt` rules and requires the source HTTP server to support `Range` requests and to return a `Content-Length` header in each response. * ObjectConditions have no effect when filtering objects to transfer.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "listUrl":
            suggest = "list_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HttpDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HttpDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HttpDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 list_url: str):
        """
        An HttpData resource specifies a list of objects on the web to be transferred over HTTP. The information of the objects to be transferred is contained in a file referenced by a URL. The first line in the file must be `"TsvHttpData-1.0"`, which specifies the format of the file. Subsequent lines specify the information of the list of objects, one object per list entry. Each entry has the following tab-delimited fields: * **HTTP URL** — The location of the object. * **Length** — The size of the object in bytes. * **MD5** — The base64-encoded MD5 hash of the object. For an example of a valid TSV file, see [Transferring data from URLs](https://cloud.google.com/storage-transfer/docs/create-url-list). When transferring data based on a URL list, keep the following in mind: * When an object located at `http(s)://hostname:port/` is transferred to a data sink, the name of the object at the data sink is `/`. * If the specified size of an object does not match the actual size of the object fetched, the object will not be transferred. * If the specified MD5 does not match the MD5 computed from the transferred bytes, the object transfer will fail. * Ensure that each URL you specify is publicly accessible. For example, in Cloud Storage you can [share an object publicly] (https://cloud.google.com/storage/docs/cloud-console#_sharingdata) and get a link to it. * Storage Transfer Service obeys `robots.txt` rules and requires the source HTTP server to support `Range` requests and to return a `Content-Length` header in each response. * ObjectConditions have no effect when filtering objects to transfer.
        :param str list_url: Required. The URL that points to the file that stores the object list entries. This file must allow public access. Currently, only URLs with HTTP and HTTPS schemes are supported.
        """
        pulumi.set(__self__, "list_url", list_url)

    @property
    @pulumi.getter(name="listUrl")
    def list_url(self) -> str:
        """
        Required. The URL that points to the file that stores the object list entries. This file must allow public access. Currently, only URLs with HTTP and HTTPS schemes are supported.
        """
        return pulumi.get(self, "list_url")


@pulumi.output_type
class NotificationConfigResponse(dict):
    """
    Specification to configure notifications published to Cloud Pub/Sub. Notifications will be published to the customer-provided topic using the following `PubsubMessage.attributes`: * `"eventType"`: one of the EventType values * `"payloadFormat"`: one of the PayloadFormat values * `"projectId"`: the project_id of the `TransferOperation` * `"transferJobName"`: the transfer_job_name of the `TransferOperation` * `"transferOperationName"`: the name of the `TransferOperation` The `PubsubMessage.data` will contain a TransferOperation resource formatted according to the specified `PayloadFormat`.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventTypes":
            suggest = "event_types"
        elif key == "payloadFormat":
            suggest = "payload_format"
        elif key == "pubsubTopic":
            suggest = "pubsub_topic"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NotificationConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NotificationConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NotificationConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 event_types: Sequence[str],
                 payload_format: str,
                 pubsub_topic: str):
        """
        Specification to configure notifications published to Cloud Pub/Sub. Notifications will be published to the customer-provided topic using the following `PubsubMessage.attributes`: * `"eventType"`: one of the EventType values * `"payloadFormat"`: one of the PayloadFormat values * `"projectId"`: the project_id of the `TransferOperation` * `"transferJobName"`: the transfer_job_name of the `TransferOperation` * `"transferOperationName"`: the name of the `TransferOperation` The `PubsubMessage.data` will contain a TransferOperation resource formatted according to the specified `PayloadFormat`.
        :param Sequence[str] event_types: Event types for which a notification is desired. If empty, send notifications for all event types.
        :param str payload_format: Required. The desired format of the notification message payloads.
        :param str pubsub_topic: Required. The `Topic.name` of the Cloud Pub/Sub topic to which to publish notifications. Must be of the format: `projects/{project}/topics/{topic}`. Not matching this format will result in an INVALID_ARGUMENT error.
        """
        pulumi.set(__self__, "event_types", event_types)
        pulumi.set(__self__, "payload_format", payload_format)
        pulumi.set(__self__, "pubsub_topic", pubsub_topic)

    @property
    @pulumi.getter(name="eventTypes")
    def event_types(self) -> Sequence[str]:
        """
        Event types for which a notification is desired. If empty, send notifications for all event types.
        """
        return pulumi.get(self, "event_types")

    @property
    @pulumi.getter(name="payloadFormat")
    def payload_format(self) -> str:
        """
        Required. The desired format of the notification message payloads.
        """
        return pulumi.get(self, "payload_format")

    @property
    @pulumi.getter(name="pubsubTopic")
    def pubsub_topic(self) -> str:
        """
        Required. The `Topic.name` of the Cloud Pub/Sub topic to which to publish notifications. Must be of the format: `projects/{project}/topics/{topic}`. Not matching this format will result in an INVALID_ARGUMENT error.
        """
        return pulumi.get(self, "pubsub_topic")


@pulumi.output_type
class ObjectConditionsResponse(dict):
    """
    Conditions that determine which objects will be transferred. Applies only to Cloud Data Sources such as S3, Azure, and Cloud Storage. The "last modification time" refers to the time of the last change to the object's content or metadata — specifically, this is the `updated` property of Cloud Storage objects, the `LastModified` field of S3 objects, and the `Last-Modified` header of Azure blobs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "excludePrefixes":
            suggest = "exclude_prefixes"
        elif key == "includePrefixes":
            suggest = "include_prefixes"
        elif key == "lastModifiedBefore":
            suggest = "last_modified_before"
        elif key == "lastModifiedSince":
            suggest = "last_modified_since"
        elif key == "maxTimeElapsedSinceLastModification":
            suggest = "max_time_elapsed_since_last_modification"
        elif key == "minTimeElapsedSinceLastModification":
            suggest = "min_time_elapsed_since_last_modification"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObjectConditionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObjectConditionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObjectConditionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exclude_prefixes: Sequence[str],
                 include_prefixes: Sequence[str],
                 last_modified_before: str,
                 last_modified_since: str,
                 max_time_elapsed_since_last_modification: str,
                 min_time_elapsed_since_last_modification: str):
        """
        Conditions that determine which objects will be transferred. Applies only to Cloud Data Sources such as S3, Azure, and Cloud Storage. The "last modification time" refers to the time of the last change to the object's content or metadata — specifically, this is the `updated` property of Cloud Storage objects, the `LastModified` field of S3 objects, and the `Last-Modified` header of Azure blobs.
        :param Sequence[str] exclude_prefixes: If you specify `exclude_prefixes`, Storage Transfer Service uses the items in the `exclude_prefixes` array to determine which objects to exclude from a transfer. Objects must not start with one of the matching `exclude_prefixes` for inclusion in a transfer. The following are requirements of `exclude_prefixes`: * Each exclude-prefix can contain any sequence of Unicode characters, to a max length of 1024 bytes when UTF8-encoded, and must not contain Carriage Return or Line Feed characters. Wildcard matching and regular expression matching are not supported. * Each exclude-prefix must omit the leading slash. For example, to exclude the object `s3://my-aws-bucket/logs/y=2015/requests.gz`, specify the exclude-prefix as `logs/y=2015/requests.gz`. * None of the exclude-prefix values can be empty, if specified. * Each exclude-prefix must exclude a distinct portion of the object namespace. No exclude-prefix may be a prefix of another exclude-prefix. * If include_prefixes is specified, then each exclude-prefix must start with the value of a path explicitly included by `include_prefixes`. The max size of `exclude_prefixes` is 1000. For more information, see [Filtering objects from transfers](/storage-transfer/docs/filtering-objects-from-transfers).
        :param Sequence[str] include_prefixes: If you specify `include_prefixes`, Storage Transfer Service uses the items in the `include_prefixes` array to determine which objects to include in a transfer. Objects must start with one of the matching `include_prefixes` for inclusion in the transfer. If exclude_prefixes is specified, objects must not start with any of the `exclude_prefixes` specified for inclusion in the transfer. The following are requirements of `include_prefixes`: * Each include-prefix can contain any sequence of Unicode characters, to a max length of 1024 bytes when UTF8-encoded, and must not contain Carriage Return or Line Feed characters. Wildcard matching and regular expression matching are not supported. * Each include-prefix must omit the leading slash. For example, to include the object `s3://my-aws-bucket/logs/y=2015/requests.gz`, specify the include-prefix as `logs/y=2015/requests.gz`. * None of the include-prefix values can be empty, if specified. * Each include-prefix must include a distinct portion of the object namespace. No include-prefix may be a prefix of another include-prefix. The max size of `include_prefixes` is 1000. For more information, see [Filtering objects from transfers](/storage-transfer/docs/filtering-objects-from-transfers).
        :param str last_modified_before: If specified, only objects with a "last modification time" before this timestamp and objects that don't have a "last modification time" will be transferred.
        :param str last_modified_since: If specified, only objects with a "last modification time" on or after this timestamp and objects that don't have a "last modification time" are transferred. The `last_modified_since` and `last_modified_before` fields can be used together for chunked data processing. For example, consider a script that processes each day's worth of data at a time. For that you'd set each of the fields as follows: * `last_modified_since` to the start of the day * `last_modified_before` to the end of the day
        :param str max_time_elapsed_since_last_modification: If specified, only objects with a "last modification time" on or after `NOW` - `max_time_elapsed_since_last_modification` and objects that don't have a "last modification time" are transferred. For each TransferOperation started by this TransferJob, `NOW` refers to the start_time of the `TransferOperation`.
        :param str min_time_elapsed_since_last_modification: If specified, only objects with a "last modification time" before `NOW` - `min_time_elapsed_since_last_modification` and objects that don't have a "last modification time" are transferred. For each TransferOperation started by this TransferJob, `NOW` refers to the start_time of the `TransferOperation`.
        """
        pulumi.set(__self__, "exclude_prefixes", exclude_prefixes)
        pulumi.set(__self__, "include_prefixes", include_prefixes)
        pulumi.set(__self__, "last_modified_before", last_modified_before)
        pulumi.set(__self__, "last_modified_since", last_modified_since)
        pulumi.set(__self__, "max_time_elapsed_since_last_modification", max_time_elapsed_since_last_modification)
        pulumi.set(__self__, "min_time_elapsed_since_last_modification", min_time_elapsed_since_last_modification)

    @property
    @pulumi.getter(name="excludePrefixes")
    def exclude_prefixes(self) -> Sequence[str]:
        """
        If you specify `exclude_prefixes`, Storage Transfer Service uses the items in the `exclude_prefixes` array to determine which objects to exclude from a transfer. Objects must not start with one of the matching `exclude_prefixes` for inclusion in a transfer. The following are requirements of `exclude_prefixes`: * Each exclude-prefix can contain any sequence of Unicode characters, to a max length of 1024 bytes when UTF8-encoded, and must not contain Carriage Return or Line Feed characters. Wildcard matching and regular expression matching are not supported. * Each exclude-prefix must omit the leading slash. For example, to exclude the object `s3://my-aws-bucket/logs/y=2015/requests.gz`, specify the exclude-prefix as `logs/y=2015/requests.gz`. * None of the exclude-prefix values can be empty, if specified. * Each exclude-prefix must exclude a distinct portion of the object namespace. No exclude-prefix may be a prefix of another exclude-prefix. * If include_prefixes is specified, then each exclude-prefix must start with the value of a path explicitly included by `include_prefixes`. The max size of `exclude_prefixes` is 1000. For more information, see [Filtering objects from transfers](/storage-transfer/docs/filtering-objects-from-transfers).
        """
        return pulumi.get(self, "exclude_prefixes")

    @property
    @pulumi.getter(name="includePrefixes")
    def include_prefixes(self) -> Sequence[str]:
        """
        If you specify `include_prefixes`, Storage Transfer Service uses the items in the `include_prefixes` array to determine which objects to include in a transfer. Objects must start with one of the matching `include_prefixes` for inclusion in the transfer. If exclude_prefixes is specified, objects must not start with any of the `exclude_prefixes` specified for inclusion in the transfer. The following are requirements of `include_prefixes`: * Each include-prefix can contain any sequence of Unicode characters, to a max length of 1024 bytes when UTF8-encoded, and must not contain Carriage Return or Line Feed characters. Wildcard matching and regular expression matching are not supported. * Each include-prefix must omit the leading slash. For example, to include the object `s3://my-aws-bucket/logs/y=2015/requests.gz`, specify the include-prefix as `logs/y=2015/requests.gz`. * None of the include-prefix values can be empty, if specified. * Each include-prefix must include a distinct portion of the object namespace. No include-prefix may be a prefix of another include-prefix. The max size of `include_prefixes` is 1000. For more information, see [Filtering objects from transfers](/storage-transfer/docs/filtering-objects-from-transfers).
        """
        return pulumi.get(self, "include_prefixes")

    @property
    @pulumi.getter(name="lastModifiedBefore")
    def last_modified_before(self) -> str:
        """
        If specified, only objects with a "last modification time" before this timestamp and objects that don't have a "last modification time" will be transferred.
        """
        return pulumi.get(self, "last_modified_before")

    @property
    @pulumi.getter(name="lastModifiedSince")
    def last_modified_since(self) -> str:
        """
        If specified, only objects with a "last modification time" on or after this timestamp and objects that don't have a "last modification time" are transferred. The `last_modified_since` and `last_modified_before` fields can be used together for chunked data processing. For example, consider a script that processes each day's worth of data at a time. For that you'd set each of the fields as follows: * `last_modified_since` to the start of the day * `last_modified_before` to the end of the day
        """
        return pulumi.get(self, "last_modified_since")

    @property
    @pulumi.getter(name="maxTimeElapsedSinceLastModification")
    def max_time_elapsed_since_last_modification(self) -> str:
        """
        If specified, only objects with a "last modification time" on or after `NOW` - `max_time_elapsed_since_last_modification` and objects that don't have a "last modification time" are transferred. For each TransferOperation started by this TransferJob, `NOW` refers to the start_time of the `TransferOperation`.
        """
        return pulumi.get(self, "max_time_elapsed_since_last_modification")

    @property
    @pulumi.getter(name="minTimeElapsedSinceLastModification")
    def min_time_elapsed_since_last_modification(self) -> str:
        """
        If specified, only objects with a "last modification time" before `NOW` - `min_time_elapsed_since_last_modification` and objects that don't have a "last modification time" are transferred. For each TransferOperation started by this TransferJob, `NOW` refers to the start_time of the `TransferOperation`.
        """
        return pulumi.get(self, "min_time_elapsed_since_last_modification")


@pulumi.output_type
class ScheduleResponse(dict):
    """
    Transfers can be scheduled to recur or to run just once.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTimeOfDay":
            suggest = "end_time_of_day"
        elif key == "repeatInterval":
            suggest = "repeat_interval"
        elif key == "scheduleEndDate":
            suggest = "schedule_end_date"
        elif key == "scheduleStartDate":
            suggest = "schedule_start_date"
        elif key == "startTimeOfDay":
            suggest = "start_time_of_day"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_time_of_day: 'outputs.TimeOfDayResponse',
                 repeat_interval: str,
                 schedule_end_date: 'outputs.DateResponse',
                 schedule_start_date: 'outputs.DateResponse',
                 start_time_of_day: 'outputs.TimeOfDayResponse'):
        """
        Transfers can be scheduled to recur or to run just once.
        :param 'TimeOfDayResponse' end_time_of_day: The time in UTC that no further transfer operations are scheduled. Combined with schedule_end_date, `end_time_of_day` specifies the end date and time for starting new transfer operations. This field must be greater than or equal to the timestamp corresponding to the combintation of schedule_start_date and start_time_of_day, and is subject to the following: * If `end_time_of_day` is not set and `schedule_end_date` is set, then a default value of `23:59:59` is used for `end_time_of_day`. * If `end_time_of_day` is set and `schedule_end_date` is not set, then INVALID_ARGUMENT is returned.
        :param str repeat_interval: Interval between the start of each scheduled TransferOperation. If unspecified, the default value is 24 hours. This value may not be less than 1 hour.
        :param 'DateResponse' schedule_end_date: The last day a transfer runs. Date boundaries are determined relative to UTC time. A job will run once per 24 hours within the following guidelines: * If `schedule_end_date` and schedule_start_date are the same and in the future relative to UTC, the transfer is executed only one time. * If `schedule_end_date` is later than `schedule_start_date` and `schedule_end_date` is in the future relative to UTC, the job will run each day at start_time_of_day through `schedule_end_date`.
        :param 'DateResponse' schedule_start_date: Required. The start date of a transfer. Date boundaries are determined relative to UTC time. If `schedule_start_date` and start_time_of_day are in the past relative to the job's creation time, the transfer starts the day after you schedule the transfer request. **Note:** When starting jobs at or near midnight UTC it is possible that a job will start later than expected. For example, if you send an outbound request on June 1 one millisecond prior to midnight UTC and the Storage Transfer Service server receives the request on June 2, then it will create a TransferJob with `schedule_start_date` set to June 2 and a `start_time_of_day` set to midnight UTC. The first scheduled TransferOperation will take place on June 3 at midnight UTC.
        :param 'TimeOfDayResponse' start_time_of_day: The time in UTC that a transfer job is scheduled to run. Transfers may start later than this time. If `start_time_of_day` is not specified: * One-time transfers run immediately. * Recurring transfers run immediately, and each day at midnight UTC, through schedule_end_date. If `start_time_of_day` is specified: * One-time transfers run at the specified time. * Recurring transfers run at the specified time each day, through `schedule_end_date`.
        """
        pulumi.set(__self__, "end_time_of_day", end_time_of_day)
        pulumi.set(__self__, "repeat_interval", repeat_interval)
        pulumi.set(__self__, "schedule_end_date", schedule_end_date)
        pulumi.set(__self__, "schedule_start_date", schedule_start_date)
        pulumi.set(__self__, "start_time_of_day", start_time_of_day)

    @property
    @pulumi.getter(name="endTimeOfDay")
    def end_time_of_day(self) -> 'outputs.TimeOfDayResponse':
        """
        The time in UTC that no further transfer operations are scheduled. Combined with schedule_end_date, `end_time_of_day` specifies the end date and time for starting new transfer operations. This field must be greater than or equal to the timestamp corresponding to the combintation of schedule_start_date and start_time_of_day, and is subject to the following: * If `end_time_of_day` is not set and `schedule_end_date` is set, then a default value of `23:59:59` is used for `end_time_of_day`. * If `end_time_of_day` is set and `schedule_end_date` is not set, then INVALID_ARGUMENT is returned.
        """
        return pulumi.get(self, "end_time_of_day")

    @property
    @pulumi.getter(name="repeatInterval")
    def repeat_interval(self) -> str:
        """
        Interval between the start of each scheduled TransferOperation. If unspecified, the default value is 24 hours. This value may not be less than 1 hour.
        """
        return pulumi.get(self, "repeat_interval")

    @property
    @pulumi.getter(name="scheduleEndDate")
    def schedule_end_date(self) -> 'outputs.DateResponse':
        """
        The last day a transfer runs. Date boundaries are determined relative to UTC time. A job will run once per 24 hours within the following guidelines: * If `schedule_end_date` and schedule_start_date are the same and in the future relative to UTC, the transfer is executed only one time. * If `schedule_end_date` is later than `schedule_start_date` and `schedule_end_date` is in the future relative to UTC, the job will run each day at start_time_of_day through `schedule_end_date`.
        """
        return pulumi.get(self, "schedule_end_date")

    @property
    @pulumi.getter(name="scheduleStartDate")
    def schedule_start_date(self) -> 'outputs.DateResponse':
        """
        Required. The start date of a transfer. Date boundaries are determined relative to UTC time. If `schedule_start_date` and start_time_of_day are in the past relative to the job's creation time, the transfer starts the day after you schedule the transfer request. **Note:** When starting jobs at or near midnight UTC it is possible that a job will start later than expected. For example, if you send an outbound request on June 1 one millisecond prior to midnight UTC and the Storage Transfer Service server receives the request on June 2, then it will create a TransferJob with `schedule_start_date` set to June 2 and a `start_time_of_day` set to midnight UTC. The first scheduled TransferOperation will take place on June 3 at midnight UTC.
        """
        return pulumi.get(self, "schedule_start_date")

    @property
    @pulumi.getter(name="startTimeOfDay")
    def start_time_of_day(self) -> 'outputs.TimeOfDayResponse':
        """
        The time in UTC that a transfer job is scheduled to run. Transfers may start later than this time. If `start_time_of_day` is not specified: * One-time transfers run immediately. * Recurring transfers run immediately, and each day at midnight UTC, through schedule_end_date. If `start_time_of_day` is specified: * One-time transfers run at the specified time. * Recurring transfers run at the specified time each day, through `schedule_end_date`.
        """
        return pulumi.get(self, "start_time_of_day")


@pulumi.output_type
class TimeOfDayResponse(dict):
    """
    Represents a time of day. The date and time zone are either not significant or are specified elsewhere. An API may choose to allow leap seconds. Related types are google.type.Date and `google.protobuf.Timestamp`.
    """
    def __init__(__self__, *,
                 hours: int,
                 minutes: int,
                 nanos: int,
                 seconds: int):
        """
        Represents a time of day. The date and time zone are either not significant or are specified elsewhere. An API may choose to allow leap seconds. Related types are google.type.Date and `google.protobuf.Timestamp`.
        :param int hours: Hours of day in 24 hour format. Should be from 0 to 23. An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        :param int minutes: Minutes of hour of day. Must be from 0 to 59.
        :param int nanos: Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        :param int seconds: Seconds of minutes of the time. Must normally be from 0 to 59. An API may allow the value 60 if it allows leap-seconds.
        """
        pulumi.set(__self__, "hours", hours)
        pulumi.set(__self__, "minutes", minutes)
        pulumi.set(__self__, "nanos", nanos)
        pulumi.set(__self__, "seconds", seconds)

    @property
    @pulumi.getter
    def hours(self) -> int:
        """
        Hours of day in 24 hour format. Should be from 0 to 23. An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        """
        return pulumi.get(self, "hours")

    @property
    @pulumi.getter
    def minutes(self) -> int:
        """
        Minutes of hour of day. Must be from 0 to 59.
        """
        return pulumi.get(self, "minutes")

    @property
    @pulumi.getter
    def nanos(self) -> int:
        """
        Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        """
        return pulumi.get(self, "nanos")

    @property
    @pulumi.getter
    def seconds(self) -> int:
        """
        Seconds of minutes of the time. Must normally be from 0 to 59. An API may allow the value 60 if it allows leap-seconds.
        """
        return pulumi.get(self, "seconds")


@pulumi.output_type
class TransferOptionsResponse(dict):
    """
    TransferOptions define the actions to be performed on objects in a transfer.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deleteObjectsFromSourceAfterTransfer":
            suggest = "delete_objects_from_source_after_transfer"
        elif key == "deleteObjectsUniqueInSink":
            suggest = "delete_objects_unique_in_sink"
        elif key == "overwriteObjectsAlreadyExistingInSink":
            suggest = "overwrite_objects_already_existing_in_sink"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransferOptionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransferOptionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransferOptionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delete_objects_from_source_after_transfer: bool,
                 delete_objects_unique_in_sink: bool,
                 overwrite_objects_already_existing_in_sink: bool):
        """
        TransferOptions define the actions to be performed on objects in a transfer.
        :param bool delete_objects_from_source_after_transfer: Whether objects should be deleted from the source after they are transferred to the sink. **Note:** This option and delete_objects_unique_in_sink are mutually exclusive.
        :param bool delete_objects_unique_in_sink: Whether objects that exist only in the sink should be deleted. **Note:** This option and delete_objects_from_source_after_transfer are mutually exclusive.
        :param bool overwrite_objects_already_existing_in_sink: When to overwrite objects that already exist in the sink. The default is that only objects that are different from the source are ovewritten. If true, all objects in the sink whose name matches an object in the source will be overwritten with the source object.
        """
        pulumi.set(__self__, "delete_objects_from_source_after_transfer", delete_objects_from_source_after_transfer)
        pulumi.set(__self__, "delete_objects_unique_in_sink", delete_objects_unique_in_sink)
        pulumi.set(__self__, "overwrite_objects_already_existing_in_sink", overwrite_objects_already_existing_in_sink)

    @property
    @pulumi.getter(name="deleteObjectsFromSourceAfterTransfer")
    def delete_objects_from_source_after_transfer(self) -> bool:
        """
        Whether objects should be deleted from the source after they are transferred to the sink. **Note:** This option and delete_objects_unique_in_sink are mutually exclusive.
        """
        return pulumi.get(self, "delete_objects_from_source_after_transfer")

    @property
    @pulumi.getter(name="deleteObjectsUniqueInSink")
    def delete_objects_unique_in_sink(self) -> bool:
        """
        Whether objects that exist only in the sink should be deleted. **Note:** This option and delete_objects_from_source_after_transfer are mutually exclusive.
        """
        return pulumi.get(self, "delete_objects_unique_in_sink")

    @property
    @pulumi.getter(name="overwriteObjectsAlreadyExistingInSink")
    def overwrite_objects_already_existing_in_sink(self) -> bool:
        """
        When to overwrite objects that already exist in the sink. The default is that only objects that are different from the source are ovewritten. If true, all objects in the sink whose name matches an object in the source will be overwritten with the source object.
        """
        return pulumi.get(self, "overwrite_objects_already_existing_in_sink")


@pulumi.output_type
class TransferSpecResponse(dict):
    """
    Configuration for running a transfer.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "awsS3DataSource":
            suggest = "aws_s3_data_source"
        elif key == "azureBlobStorageDataSource":
            suggest = "azure_blob_storage_data_source"
        elif key == "gcsDataSink":
            suggest = "gcs_data_sink"
        elif key == "gcsDataSource":
            suggest = "gcs_data_source"
        elif key == "httpDataSource":
            suggest = "http_data_source"
        elif key == "objectConditions":
            suggest = "object_conditions"
        elif key == "transferOptions":
            suggest = "transfer_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransferSpecResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransferSpecResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransferSpecResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aws_s3_data_source: 'outputs.AwsS3DataResponse',
                 azure_blob_storage_data_source: 'outputs.AzureBlobStorageDataResponse',
                 gcs_data_sink: 'outputs.GcsDataResponse',
                 gcs_data_source: 'outputs.GcsDataResponse',
                 http_data_source: 'outputs.HttpDataResponse',
                 object_conditions: 'outputs.ObjectConditionsResponse',
                 transfer_options: 'outputs.TransferOptionsResponse'):
        """
        Configuration for running a transfer.
        :param 'AwsS3DataResponse' aws_s3_data_source: An AWS S3 data source.
        :param 'AzureBlobStorageDataResponse' azure_blob_storage_data_source: An Azure Blob Storage data source.
        :param 'GcsDataResponse' gcs_data_sink: A Cloud Storage data sink.
        :param 'GcsDataResponse' gcs_data_source: A Cloud Storage data source.
        :param 'HttpDataResponse' http_data_source: An HTTP URL data source.
        :param 'ObjectConditionsResponse' object_conditions: Only objects that satisfy these object conditions are included in the set of data source and data sink objects. Object conditions based on objects' "last modification time" do not exclude objects in a data sink.
        :param 'TransferOptionsResponse' transfer_options: If the option delete_objects_unique_in_sink is `true` and time-based object conditions such as 'last modification time' are specified, the request fails with an INVALID_ARGUMENT error.
        """
        pulumi.set(__self__, "aws_s3_data_source", aws_s3_data_source)
        pulumi.set(__self__, "azure_blob_storage_data_source", azure_blob_storage_data_source)
        pulumi.set(__self__, "gcs_data_sink", gcs_data_sink)
        pulumi.set(__self__, "gcs_data_source", gcs_data_source)
        pulumi.set(__self__, "http_data_source", http_data_source)
        pulumi.set(__self__, "object_conditions", object_conditions)
        pulumi.set(__self__, "transfer_options", transfer_options)

    @property
    @pulumi.getter(name="awsS3DataSource")
    def aws_s3_data_source(self) -> 'outputs.AwsS3DataResponse':
        """
        An AWS S3 data source.
        """
        return pulumi.get(self, "aws_s3_data_source")

    @property
    @pulumi.getter(name="azureBlobStorageDataSource")
    def azure_blob_storage_data_source(self) -> 'outputs.AzureBlobStorageDataResponse':
        """
        An Azure Blob Storage data source.
        """
        return pulumi.get(self, "azure_blob_storage_data_source")

    @property
    @pulumi.getter(name="gcsDataSink")
    def gcs_data_sink(self) -> 'outputs.GcsDataResponse':
        """
        A Cloud Storage data sink.
        """
        return pulumi.get(self, "gcs_data_sink")

    @property
    @pulumi.getter(name="gcsDataSource")
    def gcs_data_source(self) -> 'outputs.GcsDataResponse':
        """
        A Cloud Storage data source.
        """
        return pulumi.get(self, "gcs_data_source")

    @property
    @pulumi.getter(name="httpDataSource")
    def http_data_source(self) -> 'outputs.HttpDataResponse':
        """
        An HTTP URL data source.
        """
        return pulumi.get(self, "http_data_source")

    @property
    @pulumi.getter(name="objectConditions")
    def object_conditions(self) -> 'outputs.ObjectConditionsResponse':
        """
        Only objects that satisfy these object conditions are included in the set of data source and data sink objects. Object conditions based on objects' "last modification time" do not exclude objects in a data sink.
        """
        return pulumi.get(self, "object_conditions")

    @property
    @pulumi.getter(name="transferOptions")
    def transfer_options(self) -> 'outputs.TransferOptionsResponse':
        """
        If the option delete_objects_unique_in_sink is `true` and time-based object conditions such as 'last modification time' are specified, the request fails with an INVALID_ARGUMENT error.
        """
        return pulumi.get(self, "transfer_options")


