# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = [
    'BucketAccessControlArgs',
    'BucketAccessControlProjectTeamArgs',
    'BucketActionArgs',
    'BucketBillingArgs',
    'BucketBucketPolicyOnlyArgs',
    'BucketConditionArgs',
    'BucketCorsItemArgs',
    'BucketEncryptionArgs',
    'BucketIamConfigurationArgs',
    'BucketIamPolicyBindingsItemArgs',
    'BucketLifecycleArgs',
    'BucketLoggingArgs',
    'BucketOwnerArgs',
    'BucketProjectTeamArgs',
    'BucketRetentionPolicyArgs',
    'BucketRuleItemArgs',
    'BucketUniformBucketLevelAccessArgs',
    'BucketVersioningArgs',
    'BucketWebsiteArgs',
    'DefaultObjectAccessControlProjectTeamArgs',
    'ExprArgs',
    'ObjectAccessControlArgs',
    'ObjectAccessControlProjectTeamArgs',
    'ObjectCustomerEncryptionArgs',
    'ObjectIamPolicyBindingsItemArgs',
    'ObjectOwnerArgs',
]

@pulumi.input_type
class BucketAccessControlArgs:
    def __init__(__self__, *,
                 bucket: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 entity: Optional[pulumi.Input[str]] = None,
                 entity_id: Optional[pulumi.Input[str]] = None,
                 etag: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 project_team: Optional[pulumi.Input['BucketProjectTeamArgs']] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 self_link: Optional[pulumi.Input[str]] = None):
        """
        An access-control entry.
        :param pulumi.Input[str] bucket: The name of the bucket.
        :param pulumi.Input[str] domain: The domain associated with the entity, if any.
        :param pulumi.Input[str] email: The email address associated with the entity, if any.
        :param pulumi.Input[str] entity: The entity holding the permission, in one of the following forms: 
               - user-userId 
               - user-email 
               - group-groupId 
               - group-email 
               - domain-domain 
               - project-team-projectId 
               - allUsers 
               - allAuthenticatedUsers Examples: 
               - The user liz@example.com would be user-liz@example.com. 
               - The group example@googlegroups.com would be group-example@googlegroups.com. 
               - To refer to all members of the Google Apps for Business domain example.com, the entity would be domain-example.com.
        :param pulumi.Input[str] entity_id: The ID for the entity, if any.
        :param pulumi.Input[str] etag: HTTP 1.1 Entity tag for the access-control entry.
        :param pulumi.Input[str] id: The ID of the access-control entry.
        :param pulumi.Input[str] kind: The kind of item this is. For bucket access control entries, this is always storage#bucketAccessControl.
        :param pulumi.Input['BucketProjectTeamArgs'] project_team: The project team associated with the entity, if any.
        :param pulumi.Input[str] role: The access permission for the entity.
        :param pulumi.Input[str] self_link: The link to this access-control entry.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if entity is not None:
            pulumi.set(__self__, "entity", entity)
        if entity_id is not None:
            pulumi.set(__self__, "entity_id", entity_id)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if project_team is not None:
            pulumi.set(__self__, "project_team", project_team)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the bucket.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        The domain associated with the entity, if any.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[str]]:
        """
        The email address associated with the entity, if any.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter
    def entity(self) -> Optional[pulumi.Input[str]]:
        """
        The entity holding the permission, in one of the following forms: 
        - user-userId 
        - user-email 
        - group-groupId 
        - group-email 
        - domain-domain 
        - project-team-projectId 
        - allUsers 
        - allAuthenticatedUsers Examples: 
        - The user liz@example.com would be user-liz@example.com. 
        - The group example@googlegroups.com would be group-example@googlegroups.com. 
        - To refer to all members of the Google Apps for Business domain example.com, the entity would be domain-example.com.
        """
        return pulumi.get(self, "entity")

    @entity.setter
    def entity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entity", value)

    @property
    @pulumi.getter(name="entityId")
    def entity_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID for the entity, if any.
        """
        return pulumi.get(self, "entity_id")

    @entity_id.setter
    def entity_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entity_id", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        """
        HTTP 1.1 Entity tag for the access-control entry.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the access-control entry.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        The kind of item this is. For bucket access control entries, this is always storage#bucketAccessControl.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="projectTeam")
    def project_team(self) -> Optional[pulumi.Input['BucketProjectTeamArgs']]:
        """
        The project team associated with the entity, if any.
        """
        return pulumi.get(self, "project_team")

    @project_team.setter
    def project_team(self, value: Optional[pulumi.Input['BucketProjectTeamArgs']]):
        pulumi.set(self, "project_team", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        The access permission for the entity.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[str]]:
        """
        The link to this access-control entry.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "self_link", value)


@pulumi.input_type
class BucketAccessControlProjectTeamArgs:
    def __init__(__self__, *,
                 project_number: Optional[pulumi.Input[str]] = None,
                 team: Optional[pulumi.Input[str]] = None):
        """
        The project team associated with the entity, if any.
        :param pulumi.Input[str] project_number: The project number.
        :param pulumi.Input[str] team: The team.
        """
        if project_number is not None:
            pulumi.set(__self__, "project_number", project_number)
        if team is not None:
            pulumi.set(__self__, "team", team)

    @property
    @pulumi.getter(name="projectNumber")
    def project_number(self) -> Optional[pulumi.Input[str]]:
        """
        The project number.
        """
        return pulumi.get(self, "project_number")

    @project_number.setter
    def project_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_number", value)

    @property
    @pulumi.getter
    def team(self) -> Optional[pulumi.Input[str]]:
        """
        The team.
        """
        return pulumi.get(self, "team")

    @team.setter
    def team(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "team", value)


@pulumi.input_type
class BucketActionArgs:
    def __init__(__self__, *,
                 storage_class: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        The action to take.
        :param pulumi.Input[str] storage_class: Target storage class. Required iff the type of the action is SetStorageClass.
        :param pulumi.Input[str] type: Type of the action. Currently, only Delete and SetStorageClass are supported.
        """
        if storage_class is not None:
            pulumi.set(__self__, "storage_class", storage_class)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> Optional[pulumi.Input[str]]:
        """
        Target storage class. Required iff the type of the action is SetStorageClass.
        """
        return pulumi.get(self, "storage_class")

    @storage_class.setter
    def storage_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_class", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of the action. Currently, only Delete and SetStorageClass are supported.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class BucketBillingArgs:
    def __init__(__self__, *,
                 requester_pays: Optional[pulumi.Input[bool]] = None):
        """
        The bucket's billing configuration.
        :param pulumi.Input[bool] requester_pays: When set to true, Requester Pays is enabled for this bucket.
        """
        if requester_pays is not None:
            pulumi.set(__self__, "requester_pays", requester_pays)

    @property
    @pulumi.getter(name="requesterPays")
    def requester_pays(self) -> Optional[pulumi.Input[bool]]:
        """
        When set to true, Requester Pays is enabled for this bucket.
        """
        return pulumi.get(self, "requester_pays")

    @requester_pays.setter
    def requester_pays(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "requester_pays", value)


@pulumi.input_type
class BucketBucketPolicyOnlyArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 locked_time: Optional[pulumi.Input[str]] = None):
        """
        The bucket's uniform bucket-level access configuration. The feature was formerly known as Bucket Policy Only. For backward compatibility, this field will be populated with identical information as the uniformBucketLevelAccess field. We recommend using the uniformBucketLevelAccess field to enable and disable the feature.
        :param pulumi.Input[bool] enabled: If set, access is controlled only by bucket-level or above IAM policies.
        :param pulumi.Input[str] locked_time: The deadline for changing iamConfiguration.bucketPolicyOnly.enabled from true to false in RFC 3339 format. iamConfiguration.bucketPolicyOnly.enabled may be changed from true to false until the locked time, after which the field is immutable.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if locked_time is not None:
            pulumi.set(__self__, "locked_time", locked_time)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        If set, access is controlled only by bucket-level or above IAM policies.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="lockedTime")
    def locked_time(self) -> Optional[pulumi.Input[str]]:
        """
        The deadline for changing iamConfiguration.bucketPolicyOnly.enabled from true to false in RFC 3339 format. iamConfiguration.bucketPolicyOnly.enabled may be changed from true to false until the locked time, after which the field is immutable.
        """
        return pulumi.get(self, "locked_time")

    @locked_time.setter
    def locked_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "locked_time", value)


@pulumi.input_type
class BucketConditionArgs:
    def __init__(__self__, *,
                 age: Optional[pulumi.Input[int]] = None,
                 created_before: Optional[pulumi.Input[str]] = None,
                 custom_time_before: Optional[pulumi.Input[str]] = None,
                 days_since_custom_time: Optional[pulumi.Input[int]] = None,
                 days_since_noncurrent_time: Optional[pulumi.Input[int]] = None,
                 is_live: Optional[pulumi.Input[bool]] = None,
                 matches_pattern: Optional[pulumi.Input[str]] = None,
                 matches_storage_class: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 noncurrent_time_before: Optional[pulumi.Input[str]] = None,
                 num_newer_versions: Optional[pulumi.Input[int]] = None):
        """
        The condition(s) under which the action will be taken.
        :param pulumi.Input[int] age: Age of an object (in days). This condition is satisfied when an object reaches the specified age.
        :param pulumi.Input[str] created_before: A date in RFC 3339 format with only the date part (for instance, "2013-01-15"). This condition is satisfied when an object is created before midnight of the specified date in UTC.
        :param pulumi.Input[str] custom_time_before: A date in RFC 3339 format with only the date part (for instance, "2013-01-15"). This condition is satisfied when the custom time on an object is before this date in UTC.
        :param pulumi.Input[int] days_since_custom_time: Number of days elapsed since the user-specified timestamp set on an object. The condition is satisfied if the days elapsed is at least this number. If no custom timestamp is specified on an object, the condition does not apply.
        :param pulumi.Input[int] days_since_noncurrent_time: Number of days elapsed since the noncurrent timestamp of an object. The condition is satisfied if the days elapsed is at least this number. This condition is relevant only for versioned objects. The value of the field must be a nonnegative integer. If it's zero, the object version will become eligible for Lifecycle action as soon as it becomes noncurrent.
        :param pulumi.Input[bool] is_live: Relevant only for versioned objects. If the value is true, this condition matches live objects; if the value is false, it matches archived objects.
        :param pulumi.Input[str] matches_pattern: A regular expression that satisfies the RE2 syntax. This condition is satisfied when the name of the object matches the RE2 pattern. Note: This feature is currently in the "Early Access" launch stage and is only available to a whitelisted set of users; that means that this feature may be changed in backward-incompatible ways and that it is not guaranteed to be released.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] matches_storage_class: Objects having any of the storage classes specified by this condition will be matched. Values include MULTI_REGIONAL, REGIONAL, NEARLINE, COLDLINE, ARCHIVE, STANDARD, and DURABLE_REDUCED_AVAILABILITY.
        :param pulumi.Input[str] noncurrent_time_before: A date in RFC 3339 format with only the date part (for instance, "2013-01-15"). This condition is satisfied when the noncurrent time on an object is before this date in UTC. This condition is relevant only for versioned objects.
        :param pulumi.Input[int] num_newer_versions: Relevant only for versioned objects. If the value is N, this condition is satisfied when there are at least N versions (including the live version) newer than this version of the object.
        """
        if age is not None:
            pulumi.set(__self__, "age", age)
        if created_before is not None:
            pulumi.set(__self__, "created_before", created_before)
        if custom_time_before is not None:
            pulumi.set(__self__, "custom_time_before", custom_time_before)
        if days_since_custom_time is not None:
            pulumi.set(__self__, "days_since_custom_time", days_since_custom_time)
        if days_since_noncurrent_time is not None:
            pulumi.set(__self__, "days_since_noncurrent_time", days_since_noncurrent_time)
        if is_live is not None:
            pulumi.set(__self__, "is_live", is_live)
        if matches_pattern is not None:
            pulumi.set(__self__, "matches_pattern", matches_pattern)
        if matches_storage_class is not None:
            pulumi.set(__self__, "matches_storage_class", matches_storage_class)
        if noncurrent_time_before is not None:
            pulumi.set(__self__, "noncurrent_time_before", noncurrent_time_before)
        if num_newer_versions is not None:
            pulumi.set(__self__, "num_newer_versions", num_newer_versions)

    @property
    @pulumi.getter
    def age(self) -> Optional[pulumi.Input[int]]:
        """
        Age of an object (in days). This condition is satisfied when an object reaches the specified age.
        """
        return pulumi.get(self, "age")

    @age.setter
    def age(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "age", value)

    @property
    @pulumi.getter(name="createdBefore")
    def created_before(self) -> Optional[pulumi.Input[str]]:
        """
        A date in RFC 3339 format with only the date part (for instance, "2013-01-15"). This condition is satisfied when an object is created before midnight of the specified date in UTC.
        """
        return pulumi.get(self, "created_before")

    @created_before.setter
    def created_before(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_before", value)

    @property
    @pulumi.getter(name="customTimeBefore")
    def custom_time_before(self) -> Optional[pulumi.Input[str]]:
        """
        A date in RFC 3339 format with only the date part (for instance, "2013-01-15"). This condition is satisfied when the custom time on an object is before this date in UTC.
        """
        return pulumi.get(self, "custom_time_before")

    @custom_time_before.setter
    def custom_time_before(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_time_before", value)

    @property
    @pulumi.getter(name="daysSinceCustomTime")
    def days_since_custom_time(self) -> Optional[pulumi.Input[int]]:
        """
        Number of days elapsed since the user-specified timestamp set on an object. The condition is satisfied if the days elapsed is at least this number. If no custom timestamp is specified on an object, the condition does not apply.
        """
        return pulumi.get(self, "days_since_custom_time")

    @days_since_custom_time.setter
    def days_since_custom_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "days_since_custom_time", value)

    @property
    @pulumi.getter(name="daysSinceNoncurrentTime")
    def days_since_noncurrent_time(self) -> Optional[pulumi.Input[int]]:
        """
        Number of days elapsed since the noncurrent timestamp of an object. The condition is satisfied if the days elapsed is at least this number. This condition is relevant only for versioned objects. The value of the field must be a nonnegative integer. If it's zero, the object version will become eligible for Lifecycle action as soon as it becomes noncurrent.
        """
        return pulumi.get(self, "days_since_noncurrent_time")

    @days_since_noncurrent_time.setter
    def days_since_noncurrent_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "days_since_noncurrent_time", value)

    @property
    @pulumi.getter(name="isLive")
    def is_live(self) -> Optional[pulumi.Input[bool]]:
        """
        Relevant only for versioned objects. If the value is true, this condition matches live objects; if the value is false, it matches archived objects.
        """
        return pulumi.get(self, "is_live")

    @is_live.setter
    def is_live(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_live", value)

    @property
    @pulumi.getter(name="matchesPattern")
    def matches_pattern(self) -> Optional[pulumi.Input[str]]:
        """
        A regular expression that satisfies the RE2 syntax. This condition is satisfied when the name of the object matches the RE2 pattern. Note: This feature is currently in the "Early Access" launch stage and is only available to a whitelisted set of users; that means that this feature may be changed in backward-incompatible ways and that it is not guaranteed to be released.
        """
        return pulumi.get(self, "matches_pattern")

    @matches_pattern.setter
    def matches_pattern(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "matches_pattern", value)

    @property
    @pulumi.getter(name="matchesStorageClass")
    def matches_storage_class(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Objects having any of the storage classes specified by this condition will be matched. Values include MULTI_REGIONAL, REGIONAL, NEARLINE, COLDLINE, ARCHIVE, STANDARD, and DURABLE_REDUCED_AVAILABILITY.
        """
        return pulumi.get(self, "matches_storage_class")

    @matches_storage_class.setter
    def matches_storage_class(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "matches_storage_class", value)

    @property
    @pulumi.getter(name="noncurrentTimeBefore")
    def noncurrent_time_before(self) -> Optional[pulumi.Input[str]]:
        """
        A date in RFC 3339 format with only the date part (for instance, "2013-01-15"). This condition is satisfied when the noncurrent time on an object is before this date in UTC. This condition is relevant only for versioned objects.
        """
        return pulumi.get(self, "noncurrent_time_before")

    @noncurrent_time_before.setter
    def noncurrent_time_before(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "noncurrent_time_before", value)

    @property
    @pulumi.getter(name="numNewerVersions")
    def num_newer_versions(self) -> Optional[pulumi.Input[int]]:
        """
        Relevant only for versioned objects. If the value is N, this condition is satisfied when there are at least N versions (including the live version) newer than this version of the object.
        """
        return pulumi.get(self, "num_newer_versions")

    @num_newer_versions.setter
    def num_newer_versions(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "num_newer_versions", value)


@pulumi.input_type
class BucketCorsItemArgs:
    def __init__(__self__, *,
                 max_age_seconds: Optional[pulumi.Input[int]] = None,
                 method: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 origin: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 response_header: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[int] max_age_seconds: The value, in seconds, to return in the  Access-Control-Max-Age header used in preflight responses.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] method: The list of HTTP methods on which to include CORS response headers, (GET, OPTIONS, POST, etc) Note: "*" is permitted in the list of methods, and means "any method".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] origin: The list of Origins eligible to receive CORS response headers. Note: "*" is permitted in the list of origins, and means "any Origin".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] response_header: The list of HTTP headers other than the simple response headers to give permission for the user-agent to share across domains.
        """
        if max_age_seconds is not None:
            pulumi.set(__self__, "max_age_seconds", max_age_seconds)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if origin is not None:
            pulumi.set(__self__, "origin", origin)
        if response_header is not None:
            pulumi.set(__self__, "response_header", response_header)

    @property
    @pulumi.getter(name="maxAgeSeconds")
    def max_age_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The value, in seconds, to return in the  Access-Control-Max-Age header used in preflight responses.
        """
        return pulumi.get(self, "max_age_seconds")

    @max_age_seconds.setter
    def max_age_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_age_seconds", value)

    @property
    @pulumi.getter
    def method(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of HTTP methods on which to include CORS response headers, (GET, OPTIONS, POST, etc) Note: "*" is permitted in the list of methods, and means "any method".
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "method", value)

    @property
    @pulumi.getter
    def origin(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of Origins eligible to receive CORS response headers. Note: "*" is permitted in the list of origins, and means "any Origin".
        """
        return pulumi.get(self, "origin")

    @origin.setter
    def origin(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "origin", value)

    @property
    @pulumi.getter(name="responseHeader")
    def response_header(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of HTTP headers other than the simple response headers to give permission for the user-agent to share across domains.
        """
        return pulumi.get(self, "response_header")

    @response_header.setter
    def response_header(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "response_header", value)


@pulumi.input_type
class BucketEncryptionArgs:
    def __init__(__self__, *,
                 default_kms_key_name: Optional[pulumi.Input[str]] = None):
        """
        Encryption configuration for a bucket.
        :param pulumi.Input[str] default_kms_key_name: A Cloud KMS key that will be used to encrypt objects inserted into this bucket, if no encryption method is specified.
        """
        if default_kms_key_name is not None:
            pulumi.set(__self__, "default_kms_key_name", default_kms_key_name)

    @property
    @pulumi.getter(name="defaultKmsKeyName")
    def default_kms_key_name(self) -> Optional[pulumi.Input[str]]:
        """
        A Cloud KMS key that will be used to encrypt objects inserted into this bucket, if no encryption method is specified.
        """
        return pulumi.get(self, "default_kms_key_name")

    @default_kms_key_name.setter
    def default_kms_key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_kms_key_name", value)


@pulumi.input_type
class BucketIamConfigurationArgs:
    def __init__(__self__, *,
                 bucket_policy_only: Optional[pulumi.Input['BucketBucketPolicyOnlyArgs']] = None,
                 public_access_prevention: Optional[pulumi.Input[str]] = None,
                 uniform_bucket_level_access: Optional[pulumi.Input['BucketUniformBucketLevelAccessArgs']] = None):
        """
        The bucket's IAM configuration.
        :param pulumi.Input['BucketBucketPolicyOnlyArgs'] bucket_policy_only: The bucket's uniform bucket-level access configuration. The feature was formerly known as Bucket Policy Only. For backward compatibility, this field will be populated with identical information as the uniformBucketLevelAccess field. We recommend using the uniformBucketLevelAccess field to enable and disable the feature.
        :param pulumi.Input[str] public_access_prevention: The bucket's Public Access Prevention configuration. Currently, 'unspecified' and 'enforced' are supported.
        :param pulumi.Input['BucketUniformBucketLevelAccessArgs'] uniform_bucket_level_access: The bucket's uniform bucket-level access configuration.
        """
        if bucket_policy_only is not None:
            pulumi.set(__self__, "bucket_policy_only", bucket_policy_only)
        if public_access_prevention is not None:
            pulumi.set(__self__, "public_access_prevention", public_access_prevention)
        if uniform_bucket_level_access is not None:
            pulumi.set(__self__, "uniform_bucket_level_access", uniform_bucket_level_access)

    @property
    @pulumi.getter(name="bucketPolicyOnly")
    def bucket_policy_only(self) -> Optional[pulumi.Input['BucketBucketPolicyOnlyArgs']]:
        """
        The bucket's uniform bucket-level access configuration. The feature was formerly known as Bucket Policy Only. For backward compatibility, this field will be populated with identical information as the uniformBucketLevelAccess field. We recommend using the uniformBucketLevelAccess field to enable and disable the feature.
        """
        return pulumi.get(self, "bucket_policy_only")

    @bucket_policy_only.setter
    def bucket_policy_only(self, value: Optional[pulumi.Input['BucketBucketPolicyOnlyArgs']]):
        pulumi.set(self, "bucket_policy_only", value)

    @property
    @pulumi.getter(name="publicAccessPrevention")
    def public_access_prevention(self) -> Optional[pulumi.Input[str]]:
        """
        The bucket's Public Access Prevention configuration. Currently, 'unspecified' and 'enforced' are supported.
        """
        return pulumi.get(self, "public_access_prevention")

    @public_access_prevention.setter
    def public_access_prevention(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_access_prevention", value)

    @property
    @pulumi.getter(name="uniformBucketLevelAccess")
    def uniform_bucket_level_access(self) -> Optional[pulumi.Input['BucketUniformBucketLevelAccessArgs']]:
        """
        The bucket's uniform bucket-level access configuration.
        """
        return pulumi.get(self, "uniform_bucket_level_access")

    @uniform_bucket_level_access.setter
    def uniform_bucket_level_access(self, value: Optional[pulumi.Input['BucketUniformBucketLevelAccessArgs']]):
        pulumi.set(self, "uniform_bucket_level_access", value)


@pulumi.input_type
class BucketIamPolicyBindingsItemArgs:
    def __init__(__self__, *,
                 condition: Optional[pulumi.Input['ExprArgs']] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 role: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input['ExprArgs'] condition: The condition that is associated with this binding. NOTE: an unsatisfied condition will not allow user access via current binding. Different bindings, including their conditions, are examined independently.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] members: A collection of identifiers for members who may assume the provided role. Recognized identifiers are as follows:  
               - allUsers — A special identifier that represents anyone on the internet; with or without a Google account.  
               - allAuthenticatedUsers — A special identifier that represents anyone who is authenticated with a Google account or a service account.  
               - user:emailid — An email address that represents a specific account. For example, user:alice@gmail.com or user:joe@example.com.  
               - serviceAccount:emailid — An email address that represents a service account. For example,  serviceAccount:my-other-app@appspot.gserviceaccount.com .  
               - group:emailid — An email address that represents a Google group. For example, group:admins@example.com.  
               - domain:domain — A Google Apps domain name that represents all the users of that domain. For example, domain:google.com or domain:example.com.  
               - projectOwner:projectid — Owners of the given project. For example, projectOwner:my-example-project  
               - projectEditor:projectid — Editors of the given project. For example, projectEditor:my-example-project  
               - projectViewer:projectid — Viewers of the given project. For example, projectViewer:my-example-project
        :param pulumi.Input[str] role: The role to which members belong. Two types of roles are supported: new IAM roles, which grant permissions that do not map directly to those provided by ACLs, and legacy IAM roles, which do map directly to ACL permissions. All roles are of the format roles/storage.specificRole.
               The new IAM roles are:  
               - roles/storage.admin — Full control of Google Cloud Storage resources.  
               - roles/storage.objectViewer — Read-Only access to Google Cloud Storage objects.  
               - roles/storage.objectCreator — Access to create objects in Google Cloud Storage.  
               - roles/storage.objectAdmin — Full control of Google Cloud Storage objects.   The legacy IAM roles are:  
               - roles/storage.legacyObjectReader — Read-only access to objects without listing. Equivalent to an ACL entry on an object with the READER role.  
               - roles/storage.legacyObjectOwner — Read/write access to existing objects without listing. Equivalent to an ACL entry on an object with the OWNER role.  
               - roles/storage.legacyBucketReader — Read access to buckets with object listing. Equivalent to an ACL entry on a bucket with the READER role.  
               - roles/storage.legacyBucketWriter — Read access to buckets with object listing/creation/deletion. Equivalent to an ACL entry on a bucket with the WRITER role.  
               - roles/storage.legacyBucketOwner — Read and write access to existing buckets with object listing/creation/deletion. Equivalent to an ACL entry on a bucket with the OWNER role.
        """
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input['ExprArgs']]:
        """
        The condition that is associated with this binding. NOTE: an unsatisfied condition will not allow user access via current binding. Different bindings, including their conditions, are examined independently.
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input['ExprArgs']]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A collection of identifiers for members who may assume the provided role. Recognized identifiers are as follows:  
        - allUsers — A special identifier that represents anyone on the internet; with or without a Google account.  
        - allAuthenticatedUsers — A special identifier that represents anyone who is authenticated with a Google account or a service account.  
        - user:emailid — An email address that represents a specific account. For example, user:alice@gmail.com or user:joe@example.com.  
        - serviceAccount:emailid — An email address that represents a service account. For example,  serviceAccount:my-other-app@appspot.gserviceaccount.com .  
        - group:emailid — An email address that represents a Google group. For example, group:admins@example.com.  
        - domain:domain — A Google Apps domain name that represents all the users of that domain. For example, domain:google.com or domain:example.com.  
        - projectOwner:projectid — Owners of the given project. For example, projectOwner:my-example-project  
        - projectEditor:projectid — Editors of the given project. For example, projectEditor:my-example-project  
        - projectViewer:projectid — Viewers of the given project. For example, projectViewer:my-example-project
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "members", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        The role to which members belong. Two types of roles are supported: new IAM roles, which grant permissions that do not map directly to those provided by ACLs, and legacy IAM roles, which do map directly to ACL permissions. All roles are of the format roles/storage.specificRole.
        The new IAM roles are:  
        - roles/storage.admin — Full control of Google Cloud Storage resources.  
        - roles/storage.objectViewer — Read-Only access to Google Cloud Storage objects.  
        - roles/storage.objectCreator — Access to create objects in Google Cloud Storage.  
        - roles/storage.objectAdmin — Full control of Google Cloud Storage objects.   The legacy IAM roles are:  
        - roles/storage.legacyObjectReader — Read-only access to objects without listing. Equivalent to an ACL entry on an object with the READER role.  
        - roles/storage.legacyObjectOwner — Read/write access to existing objects without listing. Equivalent to an ACL entry on an object with the OWNER role.  
        - roles/storage.legacyBucketReader — Read access to buckets with object listing. Equivalent to an ACL entry on a bucket with the READER role.  
        - roles/storage.legacyBucketWriter — Read access to buckets with object listing/creation/deletion. Equivalent to an ACL entry on a bucket with the WRITER role.  
        - roles/storage.legacyBucketOwner — Read and write access to existing buckets with object listing/creation/deletion. Equivalent to an ACL entry on a bucket with the OWNER role.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)


@pulumi.input_type
class BucketLifecycleArgs:
    def __init__(__self__, *,
                 rule: Optional[pulumi.Input[Sequence[pulumi.Input['BucketRuleItemArgs']]]] = None):
        """
        The bucket's lifecycle configuration. See lifecycle management for more information.
        :param pulumi.Input[Sequence[pulumi.Input['BucketRuleItemArgs']]] rule: A lifecycle management rule, which is made of an action to take and the condition(s) under which the action will be taken.
        """
        if rule is not None:
            pulumi.set(__self__, "rule", rule)

    @property
    @pulumi.getter
    def rule(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BucketRuleItemArgs']]]]:
        """
        A lifecycle management rule, which is made of an action to take and the condition(s) under which the action will be taken.
        """
        return pulumi.get(self, "rule")

    @rule.setter
    def rule(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BucketRuleItemArgs']]]]):
        pulumi.set(self, "rule", value)


@pulumi.input_type
class BucketLoggingArgs:
    def __init__(__self__, *,
                 log_bucket: Optional[pulumi.Input[str]] = None,
                 log_object_prefix: Optional[pulumi.Input[str]] = None):
        """
        The bucket's logging configuration, which defines the destination bucket and optional name prefix for the current bucket's logs.
        :param pulumi.Input[str] log_bucket: The destination bucket where the current bucket's logs should be placed.
        :param pulumi.Input[str] log_object_prefix: A prefix for log object names.
        """
        if log_bucket is not None:
            pulumi.set(__self__, "log_bucket", log_bucket)
        if log_object_prefix is not None:
            pulumi.set(__self__, "log_object_prefix", log_object_prefix)

    @property
    @pulumi.getter(name="logBucket")
    def log_bucket(self) -> Optional[pulumi.Input[str]]:
        """
        The destination bucket where the current bucket's logs should be placed.
        """
        return pulumi.get(self, "log_bucket")

    @log_bucket.setter
    def log_bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_bucket", value)

    @property
    @pulumi.getter(name="logObjectPrefix")
    def log_object_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        A prefix for log object names.
        """
        return pulumi.get(self, "log_object_prefix")

    @log_object_prefix.setter
    def log_object_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_object_prefix", value)


@pulumi.input_type
class BucketOwnerArgs:
    def __init__(__self__, *,
                 entity: Optional[pulumi.Input[str]] = None,
                 entity_id: Optional[pulumi.Input[str]] = None):
        """
        The owner of the bucket. This is always the project team's owner group.
        :param pulumi.Input[str] entity: The entity, in the form project-owner-projectId.
        :param pulumi.Input[str] entity_id: The ID for the entity.
        """
        if entity is not None:
            pulumi.set(__self__, "entity", entity)
        if entity_id is not None:
            pulumi.set(__self__, "entity_id", entity_id)

    @property
    @pulumi.getter
    def entity(self) -> Optional[pulumi.Input[str]]:
        """
        The entity, in the form project-owner-projectId.
        """
        return pulumi.get(self, "entity")

    @entity.setter
    def entity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entity", value)

    @property
    @pulumi.getter(name="entityId")
    def entity_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID for the entity.
        """
        return pulumi.get(self, "entity_id")

    @entity_id.setter
    def entity_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entity_id", value)


@pulumi.input_type
class BucketProjectTeamArgs:
    def __init__(__self__, *,
                 project_number: Optional[pulumi.Input[str]] = None,
                 team: Optional[pulumi.Input[str]] = None):
        """
        The project team associated with the entity, if any.
        :param pulumi.Input[str] project_number: The project number.
        :param pulumi.Input[str] team: The team.
        """
        if project_number is not None:
            pulumi.set(__self__, "project_number", project_number)
        if team is not None:
            pulumi.set(__self__, "team", team)

    @property
    @pulumi.getter(name="projectNumber")
    def project_number(self) -> Optional[pulumi.Input[str]]:
        """
        The project number.
        """
        return pulumi.get(self, "project_number")

    @project_number.setter
    def project_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_number", value)

    @property
    @pulumi.getter
    def team(self) -> Optional[pulumi.Input[str]]:
        """
        The team.
        """
        return pulumi.get(self, "team")

    @team.setter
    def team(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "team", value)


@pulumi.input_type
class BucketRetentionPolicyArgs:
    def __init__(__self__, *,
                 effective_time: Optional[pulumi.Input[str]] = None,
                 is_locked: Optional[pulumi.Input[bool]] = None,
                 retention_period: Optional[pulumi.Input[str]] = None):
        """
        The bucket's retention policy. The retention policy enforces a minimum retention time for all objects contained in the bucket, based on their creation time. Any attempt to overwrite or delete objects younger than the retention period will result in a PERMISSION_DENIED error. An unlocked retention policy can be modified or removed from the bucket via a storage.buckets.update operation. A locked retention policy cannot be removed or shortened in duration for the lifetime of the bucket. Attempting to remove or decrease period of a locked retention policy will result in a PERMISSION_DENIED error.
        :param pulumi.Input[str] effective_time: Server-determined value that indicates the time from which policy was enforced and effective. This value is in RFC 3339 format.
        :param pulumi.Input[bool] is_locked: Once locked, an object retention policy cannot be modified.
        :param pulumi.Input[str] retention_period: The duration in seconds that objects need to be retained. Retention duration must be greater than zero and less than 100 years. Note that enforcement of retention periods less than a day is not guaranteed. Such periods should only be used for testing purposes.
        """
        if effective_time is not None:
            pulumi.set(__self__, "effective_time", effective_time)
        if is_locked is not None:
            pulumi.set(__self__, "is_locked", is_locked)
        if retention_period is not None:
            pulumi.set(__self__, "retention_period", retention_period)

    @property
    @pulumi.getter(name="effectiveTime")
    def effective_time(self) -> Optional[pulumi.Input[str]]:
        """
        Server-determined value that indicates the time from which policy was enforced and effective. This value is in RFC 3339 format.
        """
        return pulumi.get(self, "effective_time")

    @effective_time.setter
    def effective_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "effective_time", value)

    @property
    @pulumi.getter(name="isLocked")
    def is_locked(self) -> Optional[pulumi.Input[bool]]:
        """
        Once locked, an object retention policy cannot be modified.
        """
        return pulumi.get(self, "is_locked")

    @is_locked.setter
    def is_locked(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_locked", value)

    @property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> Optional[pulumi.Input[str]]:
        """
        The duration in seconds that objects need to be retained. Retention duration must be greater than zero and less than 100 years. Note that enforcement of retention periods less than a day is not guaranteed. Such periods should only be used for testing purposes.
        """
        return pulumi.get(self, "retention_period")

    @retention_period.setter
    def retention_period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "retention_period", value)


@pulumi.input_type
class BucketRuleItemArgs:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input['BucketActionArgs']] = None,
                 condition: Optional[pulumi.Input['BucketConditionArgs']] = None):
        """
        :param pulumi.Input['BucketActionArgs'] action: The action to take.
        :param pulumi.Input['BucketConditionArgs'] condition: The condition(s) under which the action will be taken.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input['BucketActionArgs']]:
        """
        The action to take.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input['BucketActionArgs']]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input['BucketConditionArgs']]:
        """
        The condition(s) under which the action will be taken.
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input['BucketConditionArgs']]):
        pulumi.set(self, "condition", value)


@pulumi.input_type
class BucketUniformBucketLevelAccessArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 locked_time: Optional[pulumi.Input[str]] = None):
        """
        The bucket's uniform bucket-level access configuration.
        :param pulumi.Input[bool] enabled: If set, access is controlled only by bucket-level or above IAM policies.
        :param pulumi.Input[str] locked_time: The deadline for changing iamConfiguration.uniformBucketLevelAccess.enabled from true to false in RFC 3339  format. iamConfiguration.uniformBucketLevelAccess.enabled may be changed from true to false until the locked time, after which the field is immutable.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if locked_time is not None:
            pulumi.set(__self__, "locked_time", locked_time)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        If set, access is controlled only by bucket-level or above IAM policies.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="lockedTime")
    def locked_time(self) -> Optional[pulumi.Input[str]]:
        """
        The deadline for changing iamConfiguration.uniformBucketLevelAccess.enabled from true to false in RFC 3339  format. iamConfiguration.uniformBucketLevelAccess.enabled may be changed from true to false until the locked time, after which the field is immutable.
        """
        return pulumi.get(self, "locked_time")

    @locked_time.setter
    def locked_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "locked_time", value)


@pulumi.input_type
class BucketVersioningArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        The bucket's versioning configuration.
        :param pulumi.Input[bool] enabled: While set to true, versioning is fully enabled for this bucket.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        While set to true, versioning is fully enabled for this bucket.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class BucketWebsiteArgs:
    def __init__(__self__, *,
                 main_page_suffix: Optional[pulumi.Input[str]] = None,
                 not_found_page: Optional[pulumi.Input[str]] = None):
        """
        The bucket's website configuration, controlling how the service behaves when accessing bucket contents as a web site. See the Static Website Examples for more information.
        :param pulumi.Input[str] main_page_suffix: If the requested object path is missing, the service will ensure the path has a trailing '/', append this suffix, and attempt to retrieve the resulting object. This allows the creation of index.html objects to represent directory pages.
        :param pulumi.Input[str] not_found_page: If the requested object path is missing, and any mainPageSuffix object is missing, if applicable, the service will return the named object from this bucket as the content for a 404 Not Found result.
        """
        if main_page_suffix is not None:
            pulumi.set(__self__, "main_page_suffix", main_page_suffix)
        if not_found_page is not None:
            pulumi.set(__self__, "not_found_page", not_found_page)

    @property
    @pulumi.getter(name="mainPageSuffix")
    def main_page_suffix(self) -> Optional[pulumi.Input[str]]:
        """
        If the requested object path is missing, the service will ensure the path has a trailing '/', append this suffix, and attempt to retrieve the resulting object. This allows the creation of index.html objects to represent directory pages.
        """
        return pulumi.get(self, "main_page_suffix")

    @main_page_suffix.setter
    def main_page_suffix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "main_page_suffix", value)

    @property
    @pulumi.getter(name="notFoundPage")
    def not_found_page(self) -> Optional[pulumi.Input[str]]:
        """
        If the requested object path is missing, and any mainPageSuffix object is missing, if applicable, the service will return the named object from this bucket as the content for a 404 Not Found result.
        """
        return pulumi.get(self, "not_found_page")

    @not_found_page.setter
    def not_found_page(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "not_found_page", value)


@pulumi.input_type
class DefaultObjectAccessControlProjectTeamArgs:
    def __init__(__self__, *,
                 project_number: Optional[pulumi.Input[str]] = None,
                 team: Optional[pulumi.Input[str]] = None):
        """
        The project team associated with the entity, if any.
        :param pulumi.Input[str] project_number: The project number.
        :param pulumi.Input[str] team: The team.
        """
        if project_number is not None:
            pulumi.set(__self__, "project_number", project_number)
        if team is not None:
            pulumi.set(__self__, "team", team)

    @property
    @pulumi.getter(name="projectNumber")
    def project_number(self) -> Optional[pulumi.Input[str]]:
        """
        The project number.
        """
        return pulumi.get(self, "project_number")

    @project_number.setter
    def project_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_number", value)

    @property
    @pulumi.getter
    def team(self) -> Optional[pulumi.Input[str]]:
        """
        The team.
        """
        return pulumi.get(self, "team")

    @team.setter
    def team(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "team", value)


@pulumi.input_type
class ExprArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 expression: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        Represents an expression text. Example: title: "User account presence" description: "Determines whether the request has a user account" expression: "size(request.user) > 0"
        :param pulumi.Input[str] description: An optional description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param pulumi.Input[str] expression: Textual representation of an expression in Common Expression Language syntax. The application context of the containing message determines which well-known feature set of CEL is supported.
        :param pulumi.Input[str] location: An optional string indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param pulumi.Input[str] title: An optional title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def expression(self) -> Optional[pulumi.Input[str]]:
        """
        Textual representation of an expression in Common Expression Language syntax. The application context of the containing message determines which well-known feature set of CEL is supported.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        An optional string indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        An optional title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class ObjectAccessControlArgs:
    def __init__(__self__, *,
                 bucket: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 entity: Optional[pulumi.Input[str]] = None,
                 entity_id: Optional[pulumi.Input[str]] = None,
                 etag: Optional[pulumi.Input[str]] = None,
                 generation: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 object: Optional[pulumi.Input[str]] = None,
                 project_team: Optional[pulumi.Input['BucketProjectTeamArgs']] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 self_link: Optional[pulumi.Input[str]] = None):
        """
        An access-control entry.
        :param pulumi.Input[str] bucket: The name of the bucket.
        :param pulumi.Input[str] domain: The domain associated with the entity, if any.
        :param pulumi.Input[str] email: The email address associated with the entity, if any.
        :param pulumi.Input[str] entity: The entity holding the permission, in one of the following forms: 
               - user-userId 
               - user-email 
               - group-groupId 
               - group-email 
               - domain-domain 
               - project-team-projectId 
               - allUsers 
               - allAuthenticatedUsers Examples: 
               - The user liz@example.com would be user-liz@example.com. 
               - The group example@googlegroups.com would be group-example@googlegroups.com. 
               - To refer to all members of the Google Apps for Business domain example.com, the entity would be domain-example.com.
        :param pulumi.Input[str] entity_id: The ID for the entity, if any.
        :param pulumi.Input[str] etag: HTTP 1.1 Entity tag for the access-control entry.
        :param pulumi.Input[str] generation: The content generation of the object, if applied to an object.
        :param pulumi.Input[str] id: The ID of the access-control entry.
        :param pulumi.Input[str] kind: The kind of item this is. For object access control entries, this is always storage#objectAccessControl.
        :param pulumi.Input[str] object: The name of the object, if applied to an object.
        :param pulumi.Input['BucketProjectTeamArgs'] project_team: The project team associated with the entity, if any.
        :param pulumi.Input[str] role: The access permission for the entity.
        :param pulumi.Input[str] self_link: The link to this access-control entry.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if entity is not None:
            pulumi.set(__self__, "entity", entity)
        if entity_id is not None:
            pulumi.set(__self__, "entity_id", entity_id)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if generation is not None:
            pulumi.set(__self__, "generation", generation)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if object is not None:
            pulumi.set(__self__, "object", object)
        if project_team is not None:
            pulumi.set(__self__, "project_team", project_team)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the bucket.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        The domain associated with the entity, if any.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[str]]:
        """
        The email address associated with the entity, if any.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter
    def entity(self) -> Optional[pulumi.Input[str]]:
        """
        The entity holding the permission, in one of the following forms: 
        - user-userId 
        - user-email 
        - group-groupId 
        - group-email 
        - domain-domain 
        - project-team-projectId 
        - allUsers 
        - allAuthenticatedUsers Examples: 
        - The user liz@example.com would be user-liz@example.com. 
        - The group example@googlegroups.com would be group-example@googlegroups.com. 
        - To refer to all members of the Google Apps for Business domain example.com, the entity would be domain-example.com.
        """
        return pulumi.get(self, "entity")

    @entity.setter
    def entity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entity", value)

    @property
    @pulumi.getter(name="entityId")
    def entity_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID for the entity, if any.
        """
        return pulumi.get(self, "entity_id")

    @entity_id.setter
    def entity_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entity_id", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        """
        HTTP 1.1 Entity tag for the access-control entry.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def generation(self) -> Optional[pulumi.Input[str]]:
        """
        The content generation of the object, if applied to an object.
        """
        return pulumi.get(self, "generation")

    @generation.setter
    def generation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "generation", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the access-control entry.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        The kind of item this is. For object access control entries, this is always storage#objectAccessControl.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def object(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the object, if applied to an object.
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object", value)

    @property
    @pulumi.getter(name="projectTeam")
    def project_team(self) -> Optional[pulumi.Input['BucketProjectTeamArgs']]:
        """
        The project team associated with the entity, if any.
        """
        return pulumi.get(self, "project_team")

    @project_team.setter
    def project_team(self, value: Optional[pulumi.Input['BucketProjectTeamArgs']]):
        pulumi.set(self, "project_team", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        The access permission for the entity.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[str]]:
        """
        The link to this access-control entry.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "self_link", value)


@pulumi.input_type
class ObjectAccessControlProjectTeamArgs:
    def __init__(__self__, *,
                 project_number: Optional[pulumi.Input[str]] = None,
                 team: Optional[pulumi.Input[str]] = None):
        """
        The project team associated with the entity, if any.
        :param pulumi.Input[str] project_number: The project number.
        :param pulumi.Input[str] team: The team.
        """
        if project_number is not None:
            pulumi.set(__self__, "project_number", project_number)
        if team is not None:
            pulumi.set(__self__, "team", team)

    @property
    @pulumi.getter(name="projectNumber")
    def project_number(self) -> Optional[pulumi.Input[str]]:
        """
        The project number.
        """
        return pulumi.get(self, "project_number")

    @project_number.setter
    def project_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_number", value)

    @property
    @pulumi.getter
    def team(self) -> Optional[pulumi.Input[str]]:
        """
        The team.
        """
        return pulumi.get(self, "team")

    @team.setter
    def team(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "team", value)


@pulumi.input_type
class ObjectCustomerEncryptionArgs:
    def __init__(__self__, *,
                 encryption_algorithm: Optional[pulumi.Input[str]] = None,
                 key_sha256: Optional[pulumi.Input[str]] = None):
        """
        Metadata of customer-supplied encryption key, if the object is encrypted by such a key.
        :param pulumi.Input[str] encryption_algorithm: The encryption algorithm.
        :param pulumi.Input[str] key_sha256: SHA256 hash value of the encryption key.
        """
        if encryption_algorithm is not None:
            pulumi.set(__self__, "encryption_algorithm", encryption_algorithm)
        if key_sha256 is not None:
            pulumi.set(__self__, "key_sha256", key_sha256)

    @property
    @pulumi.getter(name="encryptionAlgorithm")
    def encryption_algorithm(self) -> Optional[pulumi.Input[str]]:
        """
        The encryption algorithm.
        """
        return pulumi.get(self, "encryption_algorithm")

    @encryption_algorithm.setter
    def encryption_algorithm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encryption_algorithm", value)

    @property
    @pulumi.getter(name="keySha256")
    def key_sha256(self) -> Optional[pulumi.Input[str]]:
        """
        SHA256 hash value of the encryption key.
        """
        return pulumi.get(self, "key_sha256")

    @key_sha256.setter
    def key_sha256(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_sha256", value)


@pulumi.input_type
class ObjectIamPolicyBindingsItemArgs:
    def __init__(__self__, *,
                 condition: Optional[pulumi.Input['ExprArgs']] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 role: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input['ExprArgs'] condition: The condition that is associated with this binding. NOTE: an unsatisfied condition will not allow user access via current binding. Different bindings, including their conditions, are examined independently.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] members: A collection of identifiers for members who may assume the provided role. Recognized identifiers are as follows:  
               - allUsers — A special identifier that represents anyone on the internet; with or without a Google account.  
               - allAuthenticatedUsers — A special identifier that represents anyone who is authenticated with a Google account or a service account.  
               - user:emailid — An email address that represents a specific account. For example, user:alice@gmail.com or user:joe@example.com.  
               - serviceAccount:emailid — An email address that represents a service account. For example,  serviceAccount:my-other-app@appspot.gserviceaccount.com .  
               - group:emailid — An email address that represents a Google group. For example, group:admins@example.com.  
               - domain:domain — A Google Apps domain name that represents all the users of that domain. For example, domain:google.com or domain:example.com.  
               - projectOwner:projectid — Owners of the given project. For example, projectOwner:my-example-project  
               - projectEditor:projectid — Editors of the given project. For example, projectEditor:my-example-project  
               - projectViewer:projectid — Viewers of the given project. For example, projectViewer:my-example-project
        :param pulumi.Input[str] role: The role to which members belong. Two types of roles are supported: new IAM roles, which grant permissions that do not map directly to those provided by ACLs, and legacy IAM roles, which do map directly to ACL permissions. All roles are of the format roles/storage.specificRole.
               The new IAM roles are:  
               - roles/storage.admin — Full control of Google Cloud Storage resources.  
               - roles/storage.objectViewer — Read-Only access to Google Cloud Storage objects.  
               - roles/storage.objectCreator — Access to create objects in Google Cloud Storage.  
               - roles/storage.objectAdmin — Full control of Google Cloud Storage objects.   The legacy IAM roles are:  
               - roles/storage.legacyObjectReader — Read-only access to objects without listing. Equivalent to an ACL entry on an object with the READER role.  
               - roles/storage.legacyObjectOwner — Read/write access to existing objects without listing. Equivalent to an ACL entry on an object with the OWNER role.  
               - roles/storage.legacyBucketReader — Read access to buckets with object listing. Equivalent to an ACL entry on a bucket with the READER role.  
               - roles/storage.legacyBucketWriter — Read access to buckets with object listing/creation/deletion. Equivalent to an ACL entry on a bucket with the WRITER role.  
               - roles/storage.legacyBucketOwner — Read and write access to existing buckets with object listing/creation/deletion. Equivalent to an ACL entry on a bucket with the OWNER role.
        """
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input['ExprArgs']]:
        """
        The condition that is associated with this binding. NOTE: an unsatisfied condition will not allow user access via current binding. Different bindings, including their conditions, are examined independently.
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input['ExprArgs']]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A collection of identifiers for members who may assume the provided role. Recognized identifiers are as follows:  
        - allUsers — A special identifier that represents anyone on the internet; with or without a Google account.  
        - allAuthenticatedUsers — A special identifier that represents anyone who is authenticated with a Google account or a service account.  
        - user:emailid — An email address that represents a specific account. For example, user:alice@gmail.com or user:joe@example.com.  
        - serviceAccount:emailid — An email address that represents a service account. For example,  serviceAccount:my-other-app@appspot.gserviceaccount.com .  
        - group:emailid — An email address that represents a Google group. For example, group:admins@example.com.  
        - domain:domain — A Google Apps domain name that represents all the users of that domain. For example, domain:google.com or domain:example.com.  
        - projectOwner:projectid — Owners of the given project. For example, projectOwner:my-example-project  
        - projectEditor:projectid — Editors of the given project. For example, projectEditor:my-example-project  
        - projectViewer:projectid — Viewers of the given project. For example, projectViewer:my-example-project
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "members", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        The role to which members belong. Two types of roles are supported: new IAM roles, which grant permissions that do not map directly to those provided by ACLs, and legacy IAM roles, which do map directly to ACL permissions. All roles are of the format roles/storage.specificRole.
        The new IAM roles are:  
        - roles/storage.admin — Full control of Google Cloud Storage resources.  
        - roles/storage.objectViewer — Read-Only access to Google Cloud Storage objects.  
        - roles/storage.objectCreator — Access to create objects in Google Cloud Storage.  
        - roles/storage.objectAdmin — Full control of Google Cloud Storage objects.   The legacy IAM roles are:  
        - roles/storage.legacyObjectReader — Read-only access to objects without listing. Equivalent to an ACL entry on an object with the READER role.  
        - roles/storage.legacyObjectOwner — Read/write access to existing objects without listing. Equivalent to an ACL entry on an object with the OWNER role.  
        - roles/storage.legacyBucketReader — Read access to buckets with object listing. Equivalent to an ACL entry on a bucket with the READER role.  
        - roles/storage.legacyBucketWriter — Read access to buckets with object listing/creation/deletion. Equivalent to an ACL entry on a bucket with the WRITER role.  
        - roles/storage.legacyBucketOwner — Read and write access to existing buckets with object listing/creation/deletion. Equivalent to an ACL entry on a bucket with the OWNER role.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)


@pulumi.input_type
class ObjectOwnerArgs:
    def __init__(__self__, *,
                 entity: Optional[pulumi.Input[str]] = None,
                 entity_id: Optional[pulumi.Input[str]] = None):
        """
        The owner of the object. This will always be the uploader of the object.
        :param pulumi.Input[str] entity: The entity, in the form user-userId.
        :param pulumi.Input[str] entity_id: The ID for the entity.
        """
        if entity is not None:
            pulumi.set(__self__, "entity", entity)
        if entity_id is not None:
            pulumi.set(__self__, "entity_id", entity_id)

    @property
    @pulumi.getter
    def entity(self) -> Optional[pulumi.Input[str]]:
        """
        The entity, in the form user-userId.
        """
        return pulumi.get(self, "entity")

    @entity.setter
    def entity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entity", value)

    @property
    @pulumi.getter(name="entityId")
    def entity_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID for the entity.
        """
        return pulumi.get(self, "entity_id")

    @entity_id.setter
    def entity_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entity_id", value)


