# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'CapabilitiesResponse',
    'ConfigMapEnvSourceResponse',
    'ConfigMapKeySelectorResponse',
    'ConfigMapVolumeSourceResponse',
    'ContainerPortResponse',
    'ContainerResponse',
    'EnvFromSourceResponse',
    'EnvVarResponse',
    'EnvVarSourceResponse',
    'ExecActionResponse',
    'HTTPGetActionResponse',
    'HTTPHeaderResponse',
    'HandlerResponse',
    'InstanceSpecResponse',
    'InstanceStatusResponse',
    'InstanceTemplateSpecResponse',
    'IntOrStringResponse',
    'JobConditionResponse',
    'JobSpecResponse',
    'JobStatusResponse',
    'KeyToPathResponse',
    'LifecycleResponse',
    'LocalObjectReferenceResponse',
    'ObjectMetaResponse',
    'OwnerReferenceResponse',
    'ProbeResponse',
    'ResourceRequirementsResponse',
    'SELinuxOptionsResponse',
    'SecretEnvSourceResponse',
    'SecretKeySelectorResponse',
    'SecretVolumeSourceResponse',
    'SecurityContextResponse',
    'TCPSocketActionResponse',
    'VolumeDeviceResponse',
    'VolumeMountResponse',
    'VolumeResponse',
]

@pulumi.output_type
class CapabilitiesResponse(dict):
    """
    Adds and removes POSIX capabilities from running containers.
    """
    def __init__(__self__, *,
                 add: Sequence[str],
                 drop: Sequence[str]):
        """
        Adds and removes POSIX capabilities from running containers.
        :param Sequence[str] add: Added capabilities +optional
        :param Sequence[str] drop: Removed capabilities +optional
        """
        pulumi.set(__self__, "add", add)
        pulumi.set(__self__, "drop", drop)

    @property
    @pulumi.getter
    def add(self) -> Sequence[str]:
        """
        Added capabilities +optional
        """
        return pulumi.get(self, "add")

    @property
    @pulumi.getter
    def drop(self) -> Sequence[str]:
        """
        Removed capabilities +optional
        """
        return pulumi.get(self, "drop")


@pulumi.output_type
class ConfigMapEnvSourceResponse(dict):
    """
    ConfigMapEnvSource selects a ConfigMap to populate the environment variables with. The contents of the target ConfigMap's Data field will represent the key-value pairs as environment variables.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "localObjectReference":
            suggest = "local_object_reference"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigMapEnvSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigMapEnvSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigMapEnvSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 local_object_reference: 'outputs.LocalObjectReferenceResponse',
                 name: str,
                 optional: bool):
        """
        ConfigMapEnvSource selects a ConfigMap to populate the environment variables with. The contents of the target ConfigMap's Data field will represent the key-value pairs as environment variables.
        :param 'LocalObjectReferenceResponse' local_object_reference: This field should not be used directly as it is meant to be inlined directly into the message. Use the "name" field instead.
        :param str name: Cloud Run fully managed: not supported Cloud Run for Anthos: supported The ConfigMap to select from.
        :param bool optional: Cloud Run fully managed: not supported Cloud Run for Anthos: supported Specify whether the ConfigMap must be defined +optional
        """
        pulumi.set(__self__, "local_object_reference", local_object_reference)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "optional", optional)

    @property
    @pulumi.getter(name="localObjectReference")
    def local_object_reference(self) -> 'outputs.LocalObjectReferenceResponse':
        """
        This field should not be used directly as it is meant to be inlined directly into the message. Use the "name" field instead.
        """
        return pulumi.get(self, "local_object_reference")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Cloud Run fully managed: not supported Cloud Run for Anthos: supported The ConfigMap to select from.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def optional(self) -> bool:
        """
        Cloud Run fully managed: not supported Cloud Run for Anthos: supported Specify whether the ConfigMap must be defined +optional
        """
        return pulumi.get(self, "optional")


@pulumi.output_type
class ConfigMapKeySelectorResponse(dict):
    """
    Cloud Run fully managed: not supported Cloud Run on GKE: supported Selects a key from a ConfigMap.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "localObjectReference":
            suggest = "local_object_reference"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigMapKeySelectorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigMapKeySelectorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigMapKeySelectorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key: str,
                 local_object_reference: 'outputs.LocalObjectReferenceResponse',
                 name: str,
                 optional: bool):
        """
        Cloud Run fully managed: not supported Cloud Run on GKE: supported Selects a key from a ConfigMap.
        :param str key: Cloud Run fully managed: not supported Cloud Run on GKE: supported The key to select.
        :param 'LocalObjectReferenceResponse' local_object_reference: This field should not be used directly as it is meant to be inlined directly into the message. Use the "name" field instead.
        :param str name: Cloud Run fully managed: not supported Cloud Run on GKE: supported The ConfigMap to select from.
        :param bool optional: Cloud Run fully managed: not supported Cloud Run on GKE: supported Specify whether the ConfigMap or its key must be defined +optional
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "local_object_reference", local_object_reference)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "optional", optional)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Cloud Run fully managed: not supported Cloud Run on GKE: supported The key to select.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="localObjectReference")
    def local_object_reference(self) -> 'outputs.LocalObjectReferenceResponse':
        """
        This field should not be used directly as it is meant to be inlined directly into the message. Use the "name" field instead.
        """
        return pulumi.get(self, "local_object_reference")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Cloud Run fully managed: not supported Cloud Run on GKE: supported The ConfigMap to select from.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def optional(self) -> bool:
        """
        Cloud Run fully managed: not supported Cloud Run on GKE: supported Specify whether the ConfigMap or its key must be defined +optional
        """
        return pulumi.get(self, "optional")


@pulumi.output_type
class ConfigMapVolumeSourceResponse(dict):
    """
    Adapts a ConfigMap into a volume. The contents of the target ConfigMap's Data field will be presented in a volume as files using the keys in the Data field as the file names, unless the items element is populated with specific mappings of keys to paths.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultMode":
            suggest = "default_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigMapVolumeSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigMapVolumeSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigMapVolumeSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_mode: int,
                 items: Sequence['outputs.KeyToPathResponse'],
                 name: str,
                 optional: bool):
        """
        Adapts a ConfigMap into a volume. The contents of the target ConfigMap's Data field will be presented in a volume as files using the keys in the Data field as the file names, unless the items element is populated with specific mappings of keys to paths.
        :param int default_mode: Mode bits to use on created files by default. Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        :param Sequence['KeyToPathResponse'] items: If unspecified, each key-value pair in the Data field of the referenced Secret will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the Secret, the volume setup will error unless it is marked optional.
        :param str name: Name of the config.
        :param bool optional: Specify whether the Secret or its keys must be defined.
        """
        pulumi.set(__self__, "default_mode", default_mode)
        pulumi.set(__self__, "items", items)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "optional", optional)

    @property
    @pulumi.getter(name="defaultMode")
    def default_mode(self) -> int:
        """
        Mode bits to use on created files by default. Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        """
        return pulumi.get(self, "default_mode")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.KeyToPathResponse']:
        """
        If unspecified, each key-value pair in the Data field of the referenced Secret will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the Secret, the volume setup will error unless it is marked optional.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the config.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def optional(self) -> bool:
        """
        Specify whether the Secret or its keys must be defined.
        """
        return pulumi.get(self, "optional")


@pulumi.output_type
class ContainerPortResponse(dict):
    """
    ContainerPort represents a network port in a single container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerPort":
            suggest = "container_port"
        elif key == "hostIP":
            suggest = "host_ip"
        elif key == "hostPort":
            suggest = "host_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerPortResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerPortResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerPortResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_port: int,
                 host_ip: str,
                 host_port: int,
                 name: str,
                 protocol: str):
        """
        ContainerPort represents a network port in a single container.
        :param int container_port: Number of port to expose on the pod's IP address. This must be a valid port number, 0 < x < 65536.
        :param str host_ip: What host IP to bind the external port to. +optional
        :param int host_port: Number of port to expose on the host. If specified, this must be a valid port number, 0 < x < 65536. If HostNetwork is specified, this must match ContainerPort. Most containers do not need this. +optional
        :param str name: If specified, this must be an IANA_SVC_NAME and unique within the pod. Each named port in a pod must have a unique name. Name for the port that can be referred to by services. +optional
        :param str protocol: Protocol for port. Must be UDP or TCP. Defaults to "TCP". +optional
        """
        pulumi.set(__self__, "container_port", container_port)
        pulumi.set(__self__, "host_ip", host_ip)
        pulumi.set(__self__, "host_port", host_port)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter(name="containerPort")
    def container_port(self) -> int:
        """
        Number of port to expose on the pod's IP address. This must be a valid port number, 0 < x < 65536.
        """
        return pulumi.get(self, "container_port")

    @property
    @pulumi.getter(name="hostIP")
    def host_ip(self) -> str:
        """
        What host IP to bind the external port to. +optional
        """
        return pulumi.get(self, "host_ip")

    @property
    @pulumi.getter(name="hostPort")
    def host_port(self) -> int:
        """
        Number of port to expose on the host. If specified, this must be a valid port number, 0 < x < 65536. If HostNetwork is specified, this must match ContainerPort. Most containers do not need this. +optional
        """
        return pulumi.get(self, "host_port")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        If specified, this must be an IANA_SVC_NAME and unique within the pod. Each named port in a pod must have a unique name. Name for the port that can be referred to by services. +optional
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        Protocol for port. Must be UDP or TCP. Defaults to "TCP". +optional
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class ContainerResponse(dict):
    """
    A single application container. This specifies both the container to run, the command to run in the container and the arguments to supply to it. Note that additional arguments may be supplied by the system to the container at runtime.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "envFrom":
            suggest = "env_from"
        elif key == "imagePullPolicy":
            suggest = "image_pull_policy"
        elif key == "livenessProbe":
            suggest = "liveness_probe"
        elif key == "readinessProbe":
            suggest = "readiness_probe"
        elif key == "securityContext":
            suggest = "security_context"
        elif key == "stdinOnce":
            suggest = "stdin_once"
        elif key == "terminationMessagePath":
            suggest = "termination_message_path"
        elif key == "terminationMessagePolicy":
            suggest = "termination_message_policy"
        elif key == "volumeDevices":
            suggest = "volume_devices"
        elif key == "volumeMounts":
            suggest = "volume_mounts"
        elif key == "workingDir":
            suggest = "working_dir"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 args: Sequence[str],
                 command: Sequence[str],
                 env: Sequence['outputs.EnvVarResponse'],
                 env_from: Sequence['outputs.EnvFromSourceResponse'],
                 image: str,
                 image_pull_policy: str,
                 lifecycle: 'outputs.LifecycleResponse',
                 liveness_probe: 'outputs.ProbeResponse',
                 name: str,
                 ports: Sequence['outputs.ContainerPortResponse'],
                 readiness_probe: 'outputs.ProbeResponse',
                 resources: 'outputs.ResourceRequirementsResponse',
                 security_context: 'outputs.SecurityContextResponse',
                 stdin: bool,
                 stdin_once: bool,
                 termination_message_path: str,
                 termination_message_policy: str,
                 tty: bool,
                 volume_devices: Sequence['outputs.VolumeDeviceResponse'],
                 volume_mounts: Sequence['outputs.VolumeMountResponse'],
                 working_dir: str):
        """
        A single application container. This specifies both the container to run, the command to run in the container and the arguments to supply to it. Note that additional arguments may be supplied by the system to the container at runtime.
        :param Sequence[str] args: Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell +optional
        :param Sequence[str] command: Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell +optional
        :param Sequence['EnvVarResponse'] env: List of environment variables to set in the container. Cannot be updated. +optional
        :param Sequence['EnvFromSourceResponse'] env_from: List of sources to populate environment variables in the container. The keys defined within a source must be a C_IDENTIFIER. All invalid keys will be reported as an event when the container is starting. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by an Env with a duplicate key will take precedence. Cannot be updated. +optional
        :param str image: Docker image name. More info: https://kubernetes.io/docs/concepts/containers/images
        :param str image_pull_policy: Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images +optional
        :param 'LifecycleResponse' lifecycle: Actions that the management system should take in response to container lifecycle events. Cannot be updated. +optional
        :param 'ProbeResponse' liveness_probe: Periodic probe of container liveness. Container will be restarted if the probe fails. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes +optional
        :param str name: Name of the container specified as a DNS_LABEL. Each container must have a unique name (DNS_LABEL). Cannot be updated.
        :param Sequence['ContainerPortResponse'] ports: List of ports to expose from the container. Exposing a port here gives the system additional information about the network connections a container uses, but is primarily informational. Not specifying a port here DOES NOT prevent that port from being exposed. Any port which is listening on the default "0.0.0.0" address inside a container will be accessible from the network. Cannot be updated. +optional
        :param 'ProbeResponse' readiness_probe: Periodic probe of container service readiness. Container will be removed from service endpoints if the probe fails. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes +optional
        :param 'ResourceRequirementsResponse' resources: Compute Resources required by this container. Cannot be updated. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources +optional
        :param 'SecurityContextResponse' security_context: Security options the pod should run with. More info: https://kubernetes.io/docs/concepts/policy/security-context/ More info: https://kubernetes.io/docs/tasks/configure-pod-container/security-context/ +optional
        :param bool stdin: Whether this container should allocate a buffer for stdin in the container runtime. If this is not set, reads from stdin in the container will always result in EOF. Default is false. +optional
        :param bool stdin_once: Whether the container runtime should close the stdin channel after it has been opened by a single attach. When stdin is true the stdin stream will remain open across multiple attach sessions. If stdinOnce is set to true, stdin is opened on container start, is empty until the first client attaches to stdin, and then remains open and accepts data until the client disconnects, at which time stdin is closed and remains closed until the container is restarted. If this flag is false, a container processes that reads from stdin will never receive an EOF. Default is false +optional
        :param str termination_message_path: Optional: Path at which the file to which the container's termination message will be written is mounted into the container's filesystem. Message written is intended to be brief final status, such as an assertion failure message. Will be truncated by the node if greater than 4096 bytes. The total message length across all containers will be limited to 12kb. Defaults to /dev/termination-log. Cannot be updated. +optional
        :param str termination_message_policy: Indicate how the termination message should be populated. File will use the contents of terminationMessagePath to populate the container status message on both success and failure. FallbackToLogsOnError will use the last chunk of container log output if the termination message file is empty and the container exited with an error. The log output is limited to 2048 bytes or 80 lines, whichever is smaller. Defaults to File. Cannot be updated. +optional
        :param bool tty: Whether this container should allocate a TTY for itself, also requires 'stdin' to be true. Default is false. +optional
        :param Sequence['VolumeDeviceResponse'] volume_devices: volumeDevices is the list of block devices to be used by the container. This is an alpha feature and may change in the future. +optional
        :param Sequence['VolumeMountResponse'] volume_mounts: Pod volumes to mount into the container's filesystem. Cannot be updated. +optional
        :param str working_dir: Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated. +optional
        """
        pulumi.set(__self__, "args", args)
        pulumi.set(__self__, "command", command)
        pulumi.set(__self__, "env", env)
        pulumi.set(__self__, "env_from", env_from)
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "image_pull_policy", image_pull_policy)
        pulumi.set(__self__, "lifecycle", lifecycle)
        pulumi.set(__self__, "liveness_probe", liveness_probe)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "ports", ports)
        pulumi.set(__self__, "readiness_probe", readiness_probe)
        pulumi.set(__self__, "resources", resources)
        pulumi.set(__self__, "security_context", security_context)
        pulumi.set(__self__, "stdin", stdin)
        pulumi.set(__self__, "stdin_once", stdin_once)
        pulumi.set(__self__, "termination_message_path", termination_message_path)
        pulumi.set(__self__, "termination_message_policy", termination_message_policy)
        pulumi.set(__self__, "tty", tty)
        pulumi.set(__self__, "volume_devices", volume_devices)
        pulumi.set(__self__, "volume_mounts", volume_mounts)
        pulumi.set(__self__, "working_dir", working_dir)

    @property
    @pulumi.getter
    def args(self) -> Sequence[str]:
        """
        Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell +optional
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter
    def command(self) -> Sequence[str]:
        """
        Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell +optional
        """
        return pulumi.get(self, "command")

    @property
    @pulumi.getter
    def env(self) -> Sequence['outputs.EnvVarResponse']:
        """
        List of environment variables to set in the container. Cannot be updated. +optional
        """
        return pulumi.get(self, "env")

    @property
    @pulumi.getter(name="envFrom")
    def env_from(self) -> Sequence['outputs.EnvFromSourceResponse']:
        """
        List of sources to populate environment variables in the container. The keys defined within a source must be a C_IDENTIFIER. All invalid keys will be reported as an event when the container is starting. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by an Env with a duplicate key will take precedence. Cannot be updated. +optional
        """
        return pulumi.get(self, "env_from")

    @property
    @pulumi.getter
    def image(self) -> str:
        """
        Docker image name. More info: https://kubernetes.io/docs/concepts/containers/images
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="imagePullPolicy")
    def image_pull_policy(self) -> str:
        """
        Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images +optional
        """
        return pulumi.get(self, "image_pull_policy")

    @property
    @pulumi.getter
    def lifecycle(self) -> 'outputs.LifecycleResponse':
        """
        Actions that the management system should take in response to container lifecycle events. Cannot be updated. +optional
        """
        return pulumi.get(self, "lifecycle")

    @property
    @pulumi.getter(name="livenessProbe")
    def liveness_probe(self) -> 'outputs.ProbeResponse':
        """
        Periodic probe of container liveness. Container will be restarted if the probe fails. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes +optional
        """
        return pulumi.get(self, "liveness_probe")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the container specified as a DNS_LABEL. Each container must have a unique name (DNS_LABEL). Cannot be updated.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def ports(self) -> Sequence['outputs.ContainerPortResponse']:
        """
        List of ports to expose from the container. Exposing a port here gives the system additional information about the network connections a container uses, but is primarily informational. Not specifying a port here DOES NOT prevent that port from being exposed. Any port which is listening on the default "0.0.0.0" address inside a container will be accessible from the network. Cannot be updated. +optional
        """
        return pulumi.get(self, "ports")

    @property
    @pulumi.getter(name="readinessProbe")
    def readiness_probe(self) -> 'outputs.ProbeResponse':
        """
        Periodic probe of container service readiness. Container will be removed from service endpoints if the probe fails. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes +optional
        """
        return pulumi.get(self, "readiness_probe")

    @property
    @pulumi.getter
    def resources(self) -> 'outputs.ResourceRequirementsResponse':
        """
        Compute Resources required by this container. Cannot be updated. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources +optional
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter(name="securityContext")
    def security_context(self) -> 'outputs.SecurityContextResponse':
        """
        Security options the pod should run with. More info: https://kubernetes.io/docs/concepts/policy/security-context/ More info: https://kubernetes.io/docs/tasks/configure-pod-container/security-context/ +optional
        """
        return pulumi.get(self, "security_context")

    @property
    @pulumi.getter
    def stdin(self) -> bool:
        """
        Whether this container should allocate a buffer for stdin in the container runtime. If this is not set, reads from stdin in the container will always result in EOF. Default is false. +optional
        """
        return pulumi.get(self, "stdin")

    @property
    @pulumi.getter(name="stdinOnce")
    def stdin_once(self) -> bool:
        """
        Whether the container runtime should close the stdin channel after it has been opened by a single attach. When stdin is true the stdin stream will remain open across multiple attach sessions. If stdinOnce is set to true, stdin is opened on container start, is empty until the first client attaches to stdin, and then remains open and accepts data until the client disconnects, at which time stdin is closed and remains closed until the container is restarted. If this flag is false, a container processes that reads from stdin will never receive an EOF. Default is false +optional
        """
        return pulumi.get(self, "stdin_once")

    @property
    @pulumi.getter(name="terminationMessagePath")
    def termination_message_path(self) -> str:
        """
        Optional: Path at which the file to which the container's termination message will be written is mounted into the container's filesystem. Message written is intended to be brief final status, such as an assertion failure message. Will be truncated by the node if greater than 4096 bytes. The total message length across all containers will be limited to 12kb. Defaults to /dev/termination-log. Cannot be updated. +optional
        """
        return pulumi.get(self, "termination_message_path")

    @property
    @pulumi.getter(name="terminationMessagePolicy")
    def termination_message_policy(self) -> str:
        """
        Indicate how the termination message should be populated. File will use the contents of terminationMessagePath to populate the container status message on both success and failure. FallbackToLogsOnError will use the last chunk of container log output if the termination message file is empty and the container exited with an error. The log output is limited to 2048 bytes or 80 lines, whichever is smaller. Defaults to File. Cannot be updated. +optional
        """
        return pulumi.get(self, "termination_message_policy")

    @property
    @pulumi.getter
    def tty(self) -> bool:
        """
        Whether this container should allocate a TTY for itself, also requires 'stdin' to be true. Default is false. +optional
        """
        return pulumi.get(self, "tty")

    @property
    @pulumi.getter(name="volumeDevices")
    def volume_devices(self) -> Sequence['outputs.VolumeDeviceResponse']:
        """
        volumeDevices is the list of block devices to be used by the container. This is an alpha feature and may change in the future. +optional
        """
        return pulumi.get(self, "volume_devices")

    @property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Sequence['outputs.VolumeMountResponse']:
        """
        Pod volumes to mount into the container's filesystem. Cannot be updated. +optional
        """
        return pulumi.get(self, "volume_mounts")

    @property
    @pulumi.getter(name="workingDir")
    def working_dir(self) -> str:
        """
        Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated. +optional
        """
        return pulumi.get(self, "working_dir")


@pulumi.output_type
class EnvFromSourceResponse(dict):
    """
    EnvFromSource represents the source of a set of ConfigMaps
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configMapRef":
            suggest = "config_map_ref"
        elif key == "secretRef":
            suggest = "secret_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvFromSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvFromSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvFromSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config_map_ref: 'outputs.ConfigMapEnvSourceResponse',
                 prefix: str,
                 secret_ref: 'outputs.SecretEnvSourceResponse'):
        """
        EnvFromSource represents the source of a set of ConfigMaps
        :param 'ConfigMapEnvSourceResponse' config_map_ref: The ConfigMap to select from +optional
        :param str prefix: An optional identifier to prepend to each key in the ConfigMap. Must be a C_IDENTIFIER. +optional
        :param 'SecretEnvSourceResponse' secret_ref: The Secret to select from +optional
        """
        pulumi.set(__self__, "config_map_ref", config_map_ref)
        pulumi.set(__self__, "prefix", prefix)
        pulumi.set(__self__, "secret_ref", secret_ref)

    @property
    @pulumi.getter(name="configMapRef")
    def config_map_ref(self) -> 'outputs.ConfigMapEnvSourceResponse':
        """
        The ConfigMap to select from +optional
        """
        return pulumi.get(self, "config_map_ref")

    @property
    @pulumi.getter
    def prefix(self) -> str:
        """
        An optional identifier to prepend to each key in the ConfigMap. Must be a C_IDENTIFIER. +optional
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter(name="secretRef")
    def secret_ref(self) -> 'outputs.SecretEnvSourceResponse':
        """
        The Secret to select from +optional
        """
        return pulumi.get(self, "secret_ref")


@pulumi.output_type
class EnvVarResponse(dict):
    """
    EnvVar represents an environment variable present in a Container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "valueFrom":
            suggest = "value_from"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvVarResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvVarResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvVarResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 value: str,
                 value_from: 'outputs.EnvVarSourceResponse'):
        """
        EnvVar represents an environment variable present in a Container.
        :param str name: Name of the environment variable. Must be a C_IDENTIFIER.
        :param str value: Variable references $(VAR_NAME) are expanded using the previous defined environment variables in the container and any route environment variables. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to "". +optional
        :param 'EnvVarSourceResponse' value_from: Cloud Run fully managed: not supported Cloud Run on GKE: supported Source for the environment variable's value. Cannot be used if value is not empty. +optional
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)
        pulumi.set(__self__, "value_from", value_from)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the environment variable. Must be a C_IDENTIFIER.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Variable references $(VAR_NAME) are expanded using the previous defined environment variables in the container and any route environment variables. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to "". +optional
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="valueFrom")
    def value_from(self) -> 'outputs.EnvVarSourceResponse':
        """
        Cloud Run fully managed: not supported Cloud Run on GKE: supported Source for the environment variable's value. Cannot be used if value is not empty. +optional
        """
        return pulumi.get(self, "value_from")


@pulumi.output_type
class EnvVarSourceResponse(dict):
    """
    Cloud Run fully managed: not supported Cloud Run on GKE: supported EnvVarSource represents a source for the value of an EnvVar.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configMapKeyRef":
            suggest = "config_map_key_ref"
        elif key == "secretKeyRef":
            suggest = "secret_key_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvVarSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvVarSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvVarSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config_map_key_ref: 'outputs.ConfigMapKeySelectorResponse',
                 secret_key_ref: 'outputs.SecretKeySelectorResponse'):
        """
        Cloud Run fully managed: not supported Cloud Run on GKE: supported EnvVarSource represents a source for the value of an EnvVar.
        :param 'ConfigMapKeySelectorResponse' config_map_key_ref: Cloud Run fully managed: not supported Cloud Run on GKE: supported Selects a key of a ConfigMap. +optional
        :param 'SecretKeySelectorResponse' secret_key_ref: Cloud Run fully managed: not supported Cloud Run on GKE: supported Selects a key of a secret in the pod's namespace +optional
        """
        pulumi.set(__self__, "config_map_key_ref", config_map_key_ref)
        pulumi.set(__self__, "secret_key_ref", secret_key_ref)

    @property
    @pulumi.getter(name="configMapKeyRef")
    def config_map_key_ref(self) -> 'outputs.ConfigMapKeySelectorResponse':
        """
        Cloud Run fully managed: not supported Cloud Run on GKE: supported Selects a key of a ConfigMap. +optional
        """
        return pulumi.get(self, "config_map_key_ref")

    @property
    @pulumi.getter(name="secretKeyRef")
    def secret_key_ref(self) -> 'outputs.SecretKeySelectorResponse':
        """
        Cloud Run fully managed: not supported Cloud Run on GKE: supported Selects a key of a secret in the pod's namespace +optional
        """
        return pulumi.get(self, "secret_key_ref")


@pulumi.output_type
class ExecActionResponse(dict):
    """
    ExecAction describes a "run in container" action.
    """
    def __init__(__self__, *,
                 command: Sequence[str]):
        """
        ExecAction describes a "run in container" action.
        :param Sequence[str] command: Command is the command line to execute inside the container, the working directory for the command is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy. +optional
        """
        pulumi.set(__self__, "command", command)

    @property
    @pulumi.getter
    def command(self) -> Sequence[str]:
        """
        Command is the command line to execute inside the container, the working directory for the command is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy. +optional
        """
        return pulumi.get(self, "command")


@pulumi.output_type
class HTTPGetActionResponse(dict):
    """
    HTTPGetAction describes an action based on HTTP Get requests.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpHeaders":
            suggest = "http_headers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HTTPGetActionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HTTPGetActionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HTTPGetActionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host: str,
                 http_headers: Sequence['outputs.HTTPHeaderResponse'],
                 path: str,
                 port: 'outputs.IntOrStringResponse',
                 scheme: str):
        """
        HTTPGetAction describes an action based on HTTP Get requests.
        :param str host: Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead. +optional
        :param Sequence['HTTPHeaderResponse'] http_headers: Custom headers to set in the request. HTTP allows repeated headers. +optional
        :param str path: Path to access on the HTTP server. +optional
        :param 'IntOrStringResponse' port: Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
        :param str scheme: Scheme to use for connecting to the host. Defaults to HTTP. +optional
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "http_headers", http_headers)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "scheme", scheme)

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead. +optional
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter(name="httpHeaders")
    def http_headers(self) -> Sequence['outputs.HTTPHeaderResponse']:
        """
        Custom headers to set in the request. HTTP allows repeated headers. +optional
        """
        return pulumi.get(self, "http_headers")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        Path to access on the HTTP server. +optional
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def port(self) -> 'outputs.IntOrStringResponse':
        """
        Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def scheme(self) -> str:
        """
        Scheme to use for connecting to the host. Defaults to HTTP. +optional
        """
        return pulumi.get(self, "scheme")


@pulumi.output_type
class HTTPHeaderResponse(dict):
    """
    HTTPHeader describes a custom header to be used in HTTP probes
    """
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        HTTPHeader describes a custom header to be used in HTTP probes
        :param str name: The header field name
        :param str value: The header field value
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The header field name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The header field value
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class HandlerResponse(dict):
    """
    Handler defines a specific action that should be taken
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exec":
            suggest = "exec_"
        elif key == "httpGet":
            suggest = "http_get"
        elif key == "tcpSocket":
            suggest = "tcp_socket"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HandlerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HandlerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HandlerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exec_: 'outputs.ExecActionResponse',
                 http_get: 'outputs.HTTPGetActionResponse',
                 tcp_socket: 'outputs.TCPSocketActionResponse'):
        """
        Handler defines a specific action that should be taken
        :param 'ExecActionResponse' exec_: One and only one of the following should be specified. Exec specifies the action to take. +optional
        :param 'HTTPGetActionResponse' http_get: HTTPGet specifies the http request to perform. +optional
        :param 'TCPSocketActionResponse' tcp_socket: TCPSocket specifies an action involving a TCP port. TCP hooks not yet supported
        """
        pulumi.set(__self__, "exec_", exec_)
        pulumi.set(__self__, "http_get", http_get)
        pulumi.set(__self__, "tcp_socket", tcp_socket)

    @property
    @pulumi.getter(name="exec")
    def exec_(self) -> 'outputs.ExecActionResponse':
        """
        One and only one of the following should be specified. Exec specifies the action to take. +optional
        """
        return pulumi.get(self, "exec_")

    @property
    @pulumi.getter(name="httpGet")
    def http_get(self) -> 'outputs.HTTPGetActionResponse':
        """
        HTTPGet specifies the http request to perform. +optional
        """
        return pulumi.get(self, "http_get")

    @property
    @pulumi.getter(name="tcpSocket")
    def tcp_socket(self) -> 'outputs.TCPSocketActionResponse':
        """
        TCPSocket specifies an action involving a TCP port. TCP hooks not yet supported
        """
        return pulumi.get(self, "tcp_socket")


@pulumi.output_type
class InstanceSpecResponse(dict):
    """
    InstanceSpec is a description of an instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "activeDeadlineSeconds":
            suggest = "active_deadline_seconds"
        elif key == "restartPolicy":
            suggest = "restart_policy"
        elif key == "serviceAccountName":
            suggest = "service_account_name"
        elif key == "terminationGracePeriodSeconds":
            suggest = "termination_grace_period_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceSpecResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceSpecResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceSpecResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 active_deadline_seconds: str,
                 containers: Sequence['outputs.ContainerResponse'],
                 restart_policy: str,
                 service_account_name: str,
                 termination_grace_period_seconds: str,
                 volumes: Sequence['outputs.VolumeResponse']):
        """
        InstanceSpec is a description of an instance.
        :param str active_deadline_seconds: Optional. Optional duration in seconds the instance may be active relative to StartTime before the system will actively try to mark it failed and kill associated containers. If set to zero, the system will never attempt to kill an instance based on time. Otherwise, value must be a positive integer. +optional
        :param Sequence['ContainerResponse'] containers: Optional. List of containers belonging to the instance. We disallow a number of fields on this Container. Only a single container may be provided.
        :param str restart_policy: Optional. Restart policy for all containers within the instance. Allowed values are: - OnFailure: Instances will always be restarted on failure if the backoffLimit has not been reached. - Never: Instances are never restarted and all failures are permanent. Cannot be used if backoffLimit is set. +optional
        :param str service_account_name: Optional. Email address of the IAM service account associated with the instance of a Job. The service account represents the identity of the running instance, and determines what permissions the instance has. If not provided, the instance will use the project's default service account. +optional
        :param str termination_grace_period_seconds: Optional. Optional duration in seconds the instance needs to terminate gracefully. Value must be non-negative integer. The value zero indicates delete immediately. The grace period is the duration in seconds after the processes running in the instance are sent a termination signal and the time when the processes are forcibly halted with a kill signal. Set this value longer than the expected cleanup time for your process. +optional
        :param Sequence['VolumeResponse'] volumes: Optional. List of volumes that can be mounted by containers belonging to the instance. More info: https://kubernetes.io/docs/concepts/storage/volumes +optional
        """
        pulumi.set(__self__, "active_deadline_seconds", active_deadline_seconds)
        pulumi.set(__self__, "containers", containers)
        pulumi.set(__self__, "restart_policy", restart_policy)
        pulumi.set(__self__, "service_account_name", service_account_name)
        pulumi.set(__self__, "termination_grace_period_seconds", termination_grace_period_seconds)
        pulumi.set(__self__, "volumes", volumes)

    @property
    @pulumi.getter(name="activeDeadlineSeconds")
    def active_deadline_seconds(self) -> str:
        """
        Optional. Optional duration in seconds the instance may be active relative to StartTime before the system will actively try to mark it failed and kill associated containers. If set to zero, the system will never attempt to kill an instance based on time. Otherwise, value must be a positive integer. +optional
        """
        return pulumi.get(self, "active_deadline_seconds")

    @property
    @pulumi.getter
    def containers(self) -> Sequence['outputs.ContainerResponse']:
        """
        Optional. List of containers belonging to the instance. We disallow a number of fields on this Container. Only a single container may be provided.
        """
        return pulumi.get(self, "containers")

    @property
    @pulumi.getter(name="restartPolicy")
    def restart_policy(self) -> str:
        """
        Optional. Restart policy for all containers within the instance. Allowed values are: - OnFailure: Instances will always be restarted on failure if the backoffLimit has not been reached. - Never: Instances are never restarted and all failures are permanent. Cannot be used if backoffLimit is set. +optional
        """
        return pulumi.get(self, "restart_policy")

    @property
    @pulumi.getter(name="serviceAccountName")
    def service_account_name(self) -> str:
        """
        Optional. Email address of the IAM service account associated with the instance of a Job. The service account represents the identity of the running instance, and determines what permissions the instance has. If not provided, the instance will use the project's default service account. +optional
        """
        return pulumi.get(self, "service_account_name")

    @property
    @pulumi.getter(name="terminationGracePeriodSeconds")
    def termination_grace_period_seconds(self) -> str:
        """
        Optional. Optional duration in seconds the instance needs to terminate gracefully. Value must be non-negative integer. The value zero indicates delete immediately. The grace period is the duration in seconds after the processes running in the instance are sent a termination signal and the time when the processes are forcibly halted with a kill signal. Set this value longer than the expected cleanup time for your process. +optional
        """
        return pulumi.get(self, "termination_grace_period_seconds")

    @property
    @pulumi.getter
    def volumes(self) -> Sequence['outputs.VolumeResponse']:
        """
        Optional. List of volumes that can be mounted by containers belonging to the instance. More info: https://kubernetes.io/docs/concepts/storage/volumes +optional
        """
        return pulumi.get(self, "volumes")


@pulumi.output_type
class InstanceStatusResponse(dict):
    """
    Instance represents the status of an instance of a Job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "completionTime":
            suggest = "completion_time"
        elif key == "lastExitCode":
            suggest = "last_exit_code"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 completion_time: str,
                 failed: int,
                 index: int,
                 last_exit_code: int,
                 restarted: int,
                 start_time: str,
                 succeeded: int):
        """
        Instance represents the status of an instance of a Job.
        :param str completion_time: Optional. Represents time when the instance was completed. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC. +optional
        :param int failed: Optional. The number of times this instance exited with code > 0; +optional
        :param int index: Required. Index of the instance, unique per Job, and beginning at 0.
        :param int last_exit_code: Optional. Last exit code seen for this instance. +optional
        :param int restarted: Optional. The number of times this instance was restarted. Instances are restarted according the restartPolicy configured in the Job template. +optional
        :param str start_time: Optional. Represents time when the instance was created by the job controller. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC. +optional
        :param int succeeded: Optional. The number of times this instance exited with code == 0. +optional
        """
        pulumi.set(__self__, "completion_time", completion_time)
        pulumi.set(__self__, "failed", failed)
        pulumi.set(__self__, "index", index)
        pulumi.set(__self__, "last_exit_code", last_exit_code)
        pulumi.set(__self__, "restarted", restarted)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "succeeded", succeeded)

    @property
    @pulumi.getter(name="completionTime")
    def completion_time(self) -> str:
        """
        Optional. Represents time when the instance was completed. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC. +optional
        """
        return pulumi.get(self, "completion_time")

    @property
    @pulumi.getter
    def failed(self) -> int:
        """
        Optional. The number of times this instance exited with code > 0; +optional
        """
        return pulumi.get(self, "failed")

    @property
    @pulumi.getter
    def index(self) -> int:
        """
        Required. Index of the instance, unique per Job, and beginning at 0.
        """
        return pulumi.get(self, "index")

    @property
    @pulumi.getter(name="lastExitCode")
    def last_exit_code(self) -> int:
        """
        Optional. Last exit code seen for this instance. +optional
        """
        return pulumi.get(self, "last_exit_code")

    @property
    @pulumi.getter
    def restarted(self) -> int:
        """
        Optional. The number of times this instance was restarted. Instances are restarted according the restartPolicy configured in the Job template. +optional
        """
        return pulumi.get(self, "restarted")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        Optional. Represents time when the instance was created by the job controller. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC. +optional
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def succeeded(self) -> int:
        """
        Optional. The number of times this instance exited with code == 0. +optional
        """
        return pulumi.get(self, "succeeded")


@pulumi.output_type
class InstanceTemplateSpecResponse(dict):
    """
    InstanceTemplateSpec describes the data an instance should have when created from a template.
    """
    def __init__(__self__, *,
                 spec: 'outputs.InstanceSpecResponse'):
        """
        InstanceTemplateSpec describes the data an instance should have when created from a template.
        :param 'InstanceSpecResponse' spec: Optional. Specification of the desired behavior of the instance. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status +optional
        """
        pulumi.set(__self__, "spec", spec)

    @property
    @pulumi.getter
    def spec(self) -> 'outputs.InstanceSpecResponse':
        """
        Optional. Specification of the desired behavior of the instance. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status +optional
        """
        return pulumi.get(self, "spec")


@pulumi.output_type
class IntOrStringResponse(dict):
    """
    IntOrString is a type that can hold an int32 or a string. When used in JSON or YAML marshalling and unmarshalling, it produces or consumes the inner type. This allows you to have, for example, a JSON field that can accept a name or number.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "intVal":
            suggest = "int_val"
        elif key == "strVal":
            suggest = "str_val"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntOrStringResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntOrStringResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntOrStringResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 int_val: int,
                 str_val: str,
                 type: int):
        """
        IntOrString is a type that can hold an int32 or a string. When used in JSON or YAML marshalling and unmarshalling, it produces or consumes the inner type. This allows you to have, for example, a JSON field that can accept a name or number.
        :param int int_val: The int value.
        :param str str_val: The string value.
        :param int type: The type of the value.
        """
        pulumi.set(__self__, "int_val", int_val)
        pulumi.set(__self__, "str_val", str_val)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="intVal")
    def int_val(self) -> int:
        """
        The int value.
        """
        return pulumi.get(self, "int_val")

    @property
    @pulumi.getter(name="strVal")
    def str_val(self) -> str:
        """
        The string value.
        """
        return pulumi.get(self, "str_val")

    @property
    @pulumi.getter
    def type(self) -> int:
        """
        The type of the value.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class JobConditionResponse(dict):
    """
    JobCondition defines a readiness condition for a Revision.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastTransitionTime":
            suggest = "last_transition_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobConditionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobConditionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobConditionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_transition_time: str,
                 message: str,
                 reason: str,
                 severity: str,
                 status: str,
                 type: str):
        """
        JobCondition defines a readiness condition for a Revision.
        :param str last_transition_time: Optional. Last time the condition transitioned from one status to another.
        :param str message: Optional. Human readable message indicating details about the current status.
        :param str reason: Optional. One-word CamelCase reason for the condition's last transition.
        :param str severity: Optional. How to interpret failures of this condition, one of Error, Warning, Info
        :param str status: Required. Status of the condition, one of True, False, Unknown.
        :param str type: Required. Type is used to communicate the status of the reconciliation process. See also: https://github.com/knative/serving/blob/master/docs/spec/errors.md#error-conditions-and-reporting Types include: * "Completed": True when the Job has successfully completed. * "Started": True when the Job has successfully started running. * "ResourcesAvailable": True when underlying resources have been provisioned.
        """
        pulumi.set(__self__, "last_transition_time", last_transition_time)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "reason", reason)
        pulumi.set(__self__, "severity", severity)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> str:
        """
        Optional. Last time the condition transitioned from one status to another.
        """
        return pulumi.get(self, "last_transition_time")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Optional. Human readable message indicating details about the current status.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def reason(self) -> str:
        """
        Optional. One-word CamelCase reason for the condition's last transition.
        """
        return pulumi.get(self, "reason")

    @property
    @pulumi.getter
    def severity(self) -> str:
        """
        Optional. How to interpret failures of this condition, one of Error, Warning, Info
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Required. Status of the condition, one of True, False, Unknown.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Required. Type is used to communicate the status of the reconciliation process. See also: https://github.com/knative/serving/blob/master/docs/spec/errors.md#error-conditions-and-reporting Types include: * "Completed": True when the Job has successfully completed. * "Started": True when the Job has successfully started running. * "ResourcesAvailable": True when underlying resources have been provisioned.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class JobSpecResponse(dict):
    """
    JobSpec describes how the job execution will look like.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "activeDeadlineSeconds":
            suggest = "active_deadline_seconds"
        elif key == "backoffLimit":
            suggest = "backoff_limit"
        elif key == "ttlSecondsAfterFinished":
            suggest = "ttl_seconds_after_finished"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobSpecResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobSpecResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobSpecResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 active_deadline_seconds: str,
                 backoff_limit: int,
                 completions: int,
                 parallelism: int,
                 template: 'outputs.InstanceTemplateSpecResponse',
                 ttl_seconds_after_finished: int):
        """
        JobSpec describes how the job execution will look like.
        :param str active_deadline_seconds: Optional. Specifies the duration in seconds relative to the startTime that the job may be active before the system tries to terminate it. If set to zero, the system will never attempt to terminate the job based on time. Otherwise, the value must be positive integer. +optional
        :param int backoff_limit: Optional. Specifies the number of retries per instance, before marking this job failed. If set to zero, instances will never retry on failure. +optional
        :param int completions: Optional. Specifies the desired number of successfully finished instances the job should be run with. Setting to 1 means that parallelism is limited to 1 and the success of that instance signals the success of the job. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/ +optional
        :param int parallelism: Optional. Specifies the maximum desired number of instances the job should run at any given time. Must be <= completions. The actual number of instances running in steady state will be less than this number when ((.spec.completions - .status.successful) < .spec.parallelism), i.e. when the work left to do is less than max parallelism. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/ +optional
        :param 'InstanceTemplateSpecResponse' template: Optional. Describes the instance that will be created when executing a job.
        :param int ttl_seconds_after_finished: Optional. ttlSecondsAfterFinished limits the lifetime of a Job that has finished execution (either Complete or Failed). If this field is set, ttlSecondsAfterFinished after the Job finishes, it is eligible to be automatically deleted. When the Job is being deleted, its lifecycle guarantees (e.g. finalizers) will be honored. If this field is set to zero, the Job won't be automatically deleted. +optional
        """
        pulumi.set(__self__, "active_deadline_seconds", active_deadline_seconds)
        pulumi.set(__self__, "backoff_limit", backoff_limit)
        pulumi.set(__self__, "completions", completions)
        pulumi.set(__self__, "parallelism", parallelism)
        pulumi.set(__self__, "template", template)
        pulumi.set(__self__, "ttl_seconds_after_finished", ttl_seconds_after_finished)

    @property
    @pulumi.getter(name="activeDeadlineSeconds")
    def active_deadline_seconds(self) -> str:
        """
        Optional. Specifies the duration in seconds relative to the startTime that the job may be active before the system tries to terminate it. If set to zero, the system will never attempt to terminate the job based on time. Otherwise, the value must be positive integer. +optional
        """
        return pulumi.get(self, "active_deadline_seconds")

    @property
    @pulumi.getter(name="backoffLimit")
    def backoff_limit(self) -> int:
        """
        Optional. Specifies the number of retries per instance, before marking this job failed. If set to zero, instances will never retry on failure. +optional
        """
        return pulumi.get(self, "backoff_limit")

    @property
    @pulumi.getter
    def completions(self) -> int:
        """
        Optional. Specifies the desired number of successfully finished instances the job should be run with. Setting to 1 means that parallelism is limited to 1 and the success of that instance signals the success of the job. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/ +optional
        """
        return pulumi.get(self, "completions")

    @property
    @pulumi.getter
    def parallelism(self) -> int:
        """
        Optional. Specifies the maximum desired number of instances the job should run at any given time. Must be <= completions. The actual number of instances running in steady state will be less than this number when ((.spec.completions - .status.successful) < .spec.parallelism), i.e. when the work left to do is less than max parallelism. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/ +optional
        """
        return pulumi.get(self, "parallelism")

    @property
    @pulumi.getter
    def template(self) -> 'outputs.InstanceTemplateSpecResponse':
        """
        Optional. Describes the instance that will be created when executing a job.
        """
        return pulumi.get(self, "template")

    @property
    @pulumi.getter(name="ttlSecondsAfterFinished")
    def ttl_seconds_after_finished(self) -> int:
        """
        Optional. ttlSecondsAfterFinished limits the lifetime of a Job that has finished execution (either Complete or Failed). If this field is set, ttlSecondsAfterFinished after the Job finishes, it is eligible to be automatically deleted. When the Job is being deleted, its lifecycle guarantees (e.g. finalizers) will be honored. If this field is set to zero, the Job won't be automatically deleted. +optional
        """
        return pulumi.get(self, "ttl_seconds_after_finished")


@pulumi.output_type
class JobStatusResponse(dict):
    """
    JobStatus represents the current state of a Job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "completionTime":
            suggest = "completion_time"
        elif key == "imageDigest":
            suggest = "image_digest"
        elif key == "observedGeneration":
            suggest = "observed_generation"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 active: int,
                 completion_time: str,
                 conditions: Sequence['outputs.JobConditionResponse'],
                 failed: int,
                 image_digest: str,
                 instances: Sequence['outputs.InstanceStatusResponse'],
                 observed_generation: int,
                 start_time: str,
                 succeeded: int):
        """
        JobStatus represents the current state of a Job.
        :param int active: Optional. The number of actively running instances. +optional
        :param str completion_time: Optional. Represents time when the job was completed. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC. +optional
        :param Sequence['JobConditionResponse'] conditions: Optional. The latest available observations of a job's current state. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/ +optional
        :param int failed: Optional. The number of instances which reached phase Failed. +optional
        :param str image_digest: Optional. ImageDigest holds the resolved digest for the image specified within .Spec.Template.Spec.Container.Image. The digest is resolved during the creation of the Job. This field holds the digest value regardless of whether a tag or digest was originally specified in the Container object.
        :param Sequence['InstanceStatusResponse'] instances: Optional. Status of completed, failed, and running instances. +optional
        :param int observed_generation: Optional. The 'generation' of the job that was last processed by the controller.
        :param str start_time: Optional. Represents time when the job was acknowledged by the job controller. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC. +optional
        :param int succeeded: Optional. The number of instances which reached phase Succeeded. +optional
        """
        pulumi.set(__self__, "active", active)
        pulumi.set(__self__, "completion_time", completion_time)
        pulumi.set(__self__, "conditions", conditions)
        pulumi.set(__self__, "failed", failed)
        pulumi.set(__self__, "image_digest", image_digest)
        pulumi.set(__self__, "instances", instances)
        pulumi.set(__self__, "observed_generation", observed_generation)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "succeeded", succeeded)

    @property
    @pulumi.getter
    def active(self) -> int:
        """
        Optional. The number of actively running instances. +optional
        """
        return pulumi.get(self, "active")

    @property
    @pulumi.getter(name="completionTime")
    def completion_time(self) -> str:
        """
        Optional. Represents time when the job was completed. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC. +optional
        """
        return pulumi.get(self, "completion_time")

    @property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.JobConditionResponse']:
        """
        Optional. The latest available observations of a job's current state. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/ +optional
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def failed(self) -> int:
        """
        Optional. The number of instances which reached phase Failed. +optional
        """
        return pulumi.get(self, "failed")

    @property
    @pulumi.getter(name="imageDigest")
    def image_digest(self) -> str:
        """
        Optional. ImageDigest holds the resolved digest for the image specified within .Spec.Template.Spec.Container.Image. The digest is resolved during the creation of the Job. This field holds the digest value regardless of whether a tag or digest was originally specified in the Container object.
        """
        return pulumi.get(self, "image_digest")

    @property
    @pulumi.getter
    def instances(self) -> Sequence['outputs.InstanceStatusResponse']:
        """
        Optional. Status of completed, failed, and running instances. +optional
        """
        return pulumi.get(self, "instances")

    @property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> int:
        """
        Optional. The 'generation' of the job that was last processed by the controller.
        """
        return pulumi.get(self, "observed_generation")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        Optional. Represents time when the job was acknowledged by the job controller. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC. +optional
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def succeeded(self) -> int:
        """
        Optional. The number of instances which reached phase Succeeded. +optional
        """
        return pulumi.get(self, "succeeded")


@pulumi.output_type
class KeyToPathResponse(dict):
    """
    Maps a string key to a path within a volume.
    """
    def __init__(__self__, *,
                 key: str,
                 mode: int,
                 path: str):
        """
        Maps a string key to a path within a volume.
        :param str key: The key to project.
        :param int mode: Mode bits to use on this file, must be a value between 0 and 0777. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set. +optional
        :param str path: The relative path of the file to map the key to. May not be an absolute path. May not contain the path element '..'. May not start with the string '..'.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key to project.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def mode(self) -> int:
        """
        Mode bits to use on this file, must be a value between 0 and 0777. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set. +optional
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The relative path of the file to map the key to. May not be an absolute path. May not contain the path element '..'. May not start with the string '..'.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class LifecycleResponse(dict):
    """
    Lifecycle describes actions that the management system should take in response to container lifecycle events. For the PostStart and PreStop lifecycle handlers, management of the container blocks until the action is complete, unless the container process fails, in which case the handler is aborted.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "postStart":
            suggest = "post_start"
        elif key == "preStop":
            suggest = "pre_stop"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LifecycleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LifecycleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LifecycleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 post_start: 'outputs.HandlerResponse',
                 pre_stop: 'outputs.HandlerResponse'):
        """
        Lifecycle describes actions that the management system should take in response to container lifecycle events. For the PostStart and PreStop lifecycle handlers, management of the container blocks until the action is complete, unless the container process fails, in which case the handler is aborted.
        :param 'HandlerResponse' post_start: PostStart is called immediately after a container is created. If the handler fails, the container is terminated and restarted according to its restart policy. Other management of the container blocks until the hook completes. More info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks +optional
        :param 'HandlerResponse' pre_stop: PreStop is called immediately before a container is terminated. The container is terminated after the handler completes. The reason for termination is passed to the handler. Regardless of the outcome of the handler, the container is eventually terminated. Other management of the container blocks until the hook completes. More info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks +optional
        """
        pulumi.set(__self__, "post_start", post_start)
        pulumi.set(__self__, "pre_stop", pre_stop)

    @property
    @pulumi.getter(name="postStart")
    def post_start(self) -> 'outputs.HandlerResponse':
        """
        PostStart is called immediately after a container is created. If the handler fails, the container is terminated and restarted according to its restart policy. Other management of the container blocks until the hook completes. More info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks +optional
        """
        return pulumi.get(self, "post_start")

    @property
    @pulumi.getter(name="preStop")
    def pre_stop(self) -> 'outputs.HandlerResponse':
        """
        PreStop is called immediately before a container is terminated. The container is terminated after the handler completes. The reason for termination is passed to the handler. Regardless of the outcome of the handler, the container is eventually terminated. Other management of the container blocks until the hook completes. More info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks +optional
        """
        return pulumi.get(self, "pre_stop")


@pulumi.output_type
class LocalObjectReferenceResponse(dict):
    """
    LocalObjectReference contains enough information to let you locate the referenced object inside the same namespace.
    """
    def __init__(__self__, *,
                 name: str):
        """
        LocalObjectReference contains enough information to let you locate the referenced object inside the same namespace.
        :param str name: Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ObjectMetaResponse(dict):
    """
    ObjectMeta is metadata that all persisted resources must have, which includes all objects users must create.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterName":
            suggest = "cluster_name"
        elif key == "creationTimestamp":
            suggest = "creation_timestamp"
        elif key == "deletionGracePeriodSeconds":
            suggest = "deletion_grace_period_seconds"
        elif key == "deletionTimestamp":
            suggest = "deletion_timestamp"
        elif key == "generateName":
            suggest = "generate_name"
        elif key == "ownerReferences":
            suggest = "owner_references"
        elif key == "resourceVersion":
            suggest = "resource_version"
        elif key == "selfLink":
            suggest = "self_link"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObjectMetaResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObjectMetaResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObjectMetaResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 annotations: Mapping[str, str],
                 cluster_name: str,
                 creation_timestamp: str,
                 deletion_grace_period_seconds: int,
                 deletion_timestamp: str,
                 finalizers: Sequence[str],
                 generate_name: str,
                 generation: int,
                 labels: Mapping[str, str],
                 name: str,
                 namespace: str,
                 owner_references: Sequence['outputs.OwnerReferenceResponse'],
                 resource_version: str,
                 self_link: str,
                 uid: str):
        """
        ObjectMeta is metadata that all persisted resources must have, which includes all objects users must create.
        :param Mapping[str, str] annotations: Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: http://kubernetes.io/docs/user-guide/annotations +optional
        :param str cluster_name: Not currently supported by Cloud Run. The name of the cluster which the object belongs to. This is used to distinguish resources with same name and namespace in different clusters. This field is not set anywhere right now and apiserver is going to ignore it if set in create or update request. +optional
        :param str creation_timestamp: CreationTimestamp is a timestamp representing the server time when this object was created. It is not guaranteed to be set in happens-before order across separate operations. Clients may not set this value. It is represented in RFC3339 form and is in UTC. Populated by the system. Read-only. Null for lists. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata +optional
        :param int deletion_grace_period_seconds: Not currently supported by Cloud Run. Number of seconds allowed for this object to gracefully terminate before it will be removed from the system. Only set when deletionTimestamp is also set. May only be shortened. Read-only. +optional
        :param str deletion_timestamp: DeletionTimestamp is RFC 3339 date and time at which this resource will be deleted. This field is set by the server when a graceful deletion is requested by the user, and is not directly settable by a client. The resource is expected to be deleted (no longer visible from resource lists, and not reachable by name) after the time in this field, once the finalizers list is empty. As long as the finalizers list contains items, deletion is blocked. Once the deletionTimestamp is set, this value may not be unset or be set further into the future, although it may be shortened or the resource may be deleted prior to this time. For example, a user may request that a pod is deleted in 30 seconds. The Kubelet will react by sending a graceful termination signal to the containers in the pod. After that 30 seconds, the Kubelet will send a hard termination signal (SIGKILL) to the container and after cleanup, remove the pod from the API. In the presence of network partitions, this object may still exist after this timestamp, until an administrator or automated process can determine the resource is fully terminated. If not set, graceful deletion of the object has not been requested. Populated by the system when a graceful deletion is requested. Read-only. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata +optional
        :param Sequence[str] finalizers: Not currently supported by Cloud Run. Must be empty before the object is deleted from the registry. Each entry is an identifier for the responsible component that will remove the entry from the list. If the deletionTimestamp of the object is non-nil, entries in this list can only be removed. +optional +patchStrategy=merge
        :param str generate_name: Not currently supported by Cloud Run. GenerateName is an optional prefix, used by the server, to generate a unique name ONLY IF the Name field has not been provided. If this field is used, the name returned to the client will be different than the name passed. This value will also be combined with a unique suffix. The provided value has the same validation rules as the Name field, and may be truncated by the length of the suffix required to make the value unique on the server. If this field is specified and the generated name exists, the server will NOT return a 409 - instead, it will either return 201 Created or 500 with Reason ServerTimeout indicating a unique name could not be found in the time allotted, and the client should retry (optionally after the time indicated in the Retry-After header). Applied only if Name is not specified. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#idempotency +optional string generateName = 2;
        :param int generation: A sequence number representing a specific generation of the desired state. Populated by the system. Read-only. +optional
        :param Mapping[str, str] labels: Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and routes. More info: http://kubernetes.io/docs/user-guide/labels +optional
        :param str name: Name must be unique within a namespace, within a Cloud Run region. Is required when creating resources, although some resources may allow a client to request the generation of an appropriate name automatically. Name is primarily intended for creation idempotence and configuration definition. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names +optional
        :param str namespace: Namespace defines the space within each name must be unique, within a Cloud Run region. In Cloud Run the namespace must be equal to either the project ID or project number.
        :param Sequence['OwnerReferenceResponse'] owner_references: List of objects that own this object. If ALL objects in the list have been deleted, this object will be garbage collected. +optional
        :param str resource_version: An opaque value that represents the internal version of this object that can be used by clients to determine when objects have changed. May be used for optimistic concurrency, change detection, and the watch operation on a resource or set of resources. Clients must treat these values as opaque and passed unmodified back to the server. They may only be valid for a particular resource or set of resources. Populated by the system. Read-only. Value must be treated as opaque by clients and . More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#concurrency-control-and-consistency +optional
        :param str self_link: SelfLink is a URL representing this object. Populated by the system. Read-only. +optional string selfLink = 4;
        :param str uid: UID is the unique in time and space value for this object. It is typically generated by the server on successful creation of a resource and is not allowed to change on PUT operations. Populated by the system. Read-only. More info: http://kubernetes.io/docs/user-guide/identifiers#uids +optional
        """
        pulumi.set(__self__, "annotations", annotations)
        pulumi.set(__self__, "cluster_name", cluster_name)
        pulumi.set(__self__, "creation_timestamp", creation_timestamp)
        pulumi.set(__self__, "deletion_grace_period_seconds", deletion_grace_period_seconds)
        pulumi.set(__self__, "deletion_timestamp", deletion_timestamp)
        pulumi.set(__self__, "finalizers", finalizers)
        pulumi.set(__self__, "generate_name", generate_name)
        pulumi.set(__self__, "generation", generation)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "owner_references", owner_references)
        pulumi.set(__self__, "resource_version", resource_version)
        pulumi.set(__self__, "self_link", self_link)
        pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter
    def annotations(self) -> Mapping[str, str]:
        """
        Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: http://kubernetes.io/docs/user-guide/annotations +optional
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> str:
        """
        Not currently supported by Cloud Run. The name of the cluster which the object belongs to. This is used to distinguish resources with same name and namespace in different clusters. This field is not set anywhere right now and apiserver is going to ignore it if set in create or update request. +optional
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> str:
        """
        CreationTimestamp is a timestamp representing the server time when this object was created. It is not guaranteed to be set in happens-before order across separate operations. Clients may not set this value. It is represented in RFC3339 form and is in UTC. Populated by the system. Read-only. Null for lists. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata +optional
        """
        return pulumi.get(self, "creation_timestamp")

    @property
    @pulumi.getter(name="deletionGracePeriodSeconds")
    def deletion_grace_period_seconds(self) -> int:
        """
        Not currently supported by Cloud Run. Number of seconds allowed for this object to gracefully terminate before it will be removed from the system. Only set when deletionTimestamp is also set. May only be shortened. Read-only. +optional
        """
        return pulumi.get(self, "deletion_grace_period_seconds")

    @property
    @pulumi.getter(name="deletionTimestamp")
    def deletion_timestamp(self) -> str:
        """
        DeletionTimestamp is RFC 3339 date and time at which this resource will be deleted. This field is set by the server when a graceful deletion is requested by the user, and is not directly settable by a client. The resource is expected to be deleted (no longer visible from resource lists, and not reachable by name) after the time in this field, once the finalizers list is empty. As long as the finalizers list contains items, deletion is blocked. Once the deletionTimestamp is set, this value may not be unset or be set further into the future, although it may be shortened or the resource may be deleted prior to this time. For example, a user may request that a pod is deleted in 30 seconds. The Kubelet will react by sending a graceful termination signal to the containers in the pod. After that 30 seconds, the Kubelet will send a hard termination signal (SIGKILL) to the container and after cleanup, remove the pod from the API. In the presence of network partitions, this object may still exist after this timestamp, until an administrator or automated process can determine the resource is fully terminated. If not set, graceful deletion of the object has not been requested. Populated by the system when a graceful deletion is requested. Read-only. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata +optional
        """
        return pulumi.get(self, "deletion_timestamp")

    @property
    @pulumi.getter
    def finalizers(self) -> Sequence[str]:
        """
        Not currently supported by Cloud Run. Must be empty before the object is deleted from the registry. Each entry is an identifier for the responsible component that will remove the entry from the list. If the deletionTimestamp of the object is non-nil, entries in this list can only be removed. +optional +patchStrategy=merge
        """
        return pulumi.get(self, "finalizers")

    @property
    @pulumi.getter(name="generateName")
    def generate_name(self) -> str:
        """
        Not currently supported by Cloud Run. GenerateName is an optional prefix, used by the server, to generate a unique name ONLY IF the Name field has not been provided. If this field is used, the name returned to the client will be different than the name passed. This value will also be combined with a unique suffix. The provided value has the same validation rules as the Name field, and may be truncated by the length of the suffix required to make the value unique on the server. If this field is specified and the generated name exists, the server will NOT return a 409 - instead, it will either return 201 Created or 500 with Reason ServerTimeout indicating a unique name could not be found in the time allotted, and the client should retry (optionally after the time indicated in the Retry-After header). Applied only if Name is not specified. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#idempotency +optional string generateName = 2;
        """
        return pulumi.get(self, "generate_name")

    @property
    @pulumi.getter
    def generation(self) -> int:
        """
        A sequence number representing a specific generation of the desired state. Populated by the system. Read-only. +optional
        """
        return pulumi.get(self, "generation")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and routes. More info: http://kubernetes.io/docs/user-guide/labels +optional
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name must be unique within a namespace, within a Cloud Run region. Is required when creating resources, although some resources may allow a client to request the generation of an appropriate name automatically. Name is primarily intended for creation idempotence and configuration definition. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names +optional
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        Namespace defines the space within each name must be unique, within a Cloud Run region. In Cloud Run the namespace must be equal to either the project ID or project number.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="ownerReferences")
    def owner_references(self) -> Sequence['outputs.OwnerReferenceResponse']:
        """
        List of objects that own this object. If ALL objects in the list have been deleted, this object will be garbage collected. +optional
        """
        return pulumi.get(self, "owner_references")

    @property
    @pulumi.getter(name="resourceVersion")
    def resource_version(self) -> str:
        """
        An opaque value that represents the internal version of this object that can be used by clients to determine when objects have changed. May be used for optimistic concurrency, change detection, and the watch operation on a resource or set of resources. Clients must treat these values as opaque and passed unmodified back to the server. They may only be valid for a particular resource or set of resources. Populated by the system. Read-only. Value must be treated as opaque by clients and . More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#concurrency-control-and-consistency +optional
        """
        return pulumi.get(self, "resource_version")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> str:
        """
        SelfLink is a URL representing this object. Populated by the system. Read-only. +optional string selfLink = 4;
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter
    def uid(self) -> str:
        """
        UID is the unique in time and space value for this object. It is typically generated by the server on successful creation of a resource and is not allowed to change on PUT operations. Populated by the system. Read-only. More info: http://kubernetes.io/docs/user-guide/identifiers#uids +optional
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class OwnerReferenceResponse(dict):
    """
    OwnerReference contains enough information to let you identify an owning object. Currently, an owning object must be in the same namespace, so there is no namespace field.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiVersion":
            suggest = "api_version"
        elif key == "blockOwnerDeletion":
            suggest = "block_owner_deletion"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OwnerReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OwnerReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OwnerReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_version: str,
                 block_owner_deletion: bool,
                 controller: bool,
                 kind: str,
                 name: str,
                 uid: str):
        """
        OwnerReference contains enough information to let you identify an owning object. Currently, an owning object must be in the same namespace, so there is no namespace field.
        :param str api_version: API version of the referent.
        :param bool block_owner_deletion: If true, AND if the owner has the "foregroundDeletion" finalizer, then the owner cannot be deleted from the key-value store until this reference is removed. Defaults to false. To set this field, a user needs "delete" permission of the owner, otherwise 422 (Unprocessable Entity) will be returned. +optional
        :param bool controller: If true, this reference points to the managing controller. +optional
        :param str kind: Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param str name: Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
        :param str uid: UID of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#uids
        """
        pulumi.set(__self__, "api_version", api_version)
        pulumi.set(__self__, "block_owner_deletion", block_owner_deletion)
        pulumi.set(__self__, "controller", controller)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> str:
        """
        API version of the referent.
        """
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter(name="blockOwnerDeletion")
    def block_owner_deletion(self) -> bool:
        """
        If true, AND if the owner has the "foregroundDeletion" finalizer, then the owner cannot be deleted from the key-value store until this reference is removed. Defaults to false. To set this field, a user needs "delete" permission of the owner, otherwise 422 (Unprocessable Entity) will be returned. +optional
        """
        return pulumi.get(self, "block_owner_deletion")

    @property
    @pulumi.getter
    def controller(self) -> bool:
        """
        If true, this reference points to the managing controller. +optional
        """
        return pulumi.get(self, "controller")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def uid(self) -> str:
        """
        UID of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#uids
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class ProbeResponse(dict):
    """
    Probe describes a health check to be performed against a container to determine whether it is alive or ready to receive traffic.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failureThreshold":
            suggest = "failure_threshold"
        elif key == "initialDelaySeconds":
            suggest = "initial_delay_seconds"
        elif key == "periodSeconds":
            suggest = "period_seconds"
        elif key == "successThreshold":
            suggest = "success_threshold"
        elif key == "timeoutSeconds":
            suggest = "timeout_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProbeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProbeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProbeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failure_threshold: int,
                 handler: 'outputs.HandlerResponse',
                 initial_delay_seconds: int,
                 period_seconds: int,
                 success_threshold: int,
                 timeout_seconds: int):
        """
        Probe describes a health check to be performed against a container to determine whether it is alive or ready to receive traffic.
        :param int failure_threshold: Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1. +optional
        :param 'HandlerResponse' handler: The action taken to determine the health of a container
        :param int initial_delay_seconds: Number of seconds after the container has started before liveness probes are initiated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes +optional
        :param int period_seconds: How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. +optional
        :param int success_threshold: Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1. Must be 1 for liveness. Minimum value is 1. +optional
        :param int timeout_seconds: Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes +optional
        """
        pulumi.set(__self__, "failure_threshold", failure_threshold)
        pulumi.set(__self__, "handler", handler)
        pulumi.set(__self__, "initial_delay_seconds", initial_delay_seconds)
        pulumi.set(__self__, "period_seconds", period_seconds)
        pulumi.set(__self__, "success_threshold", success_threshold)
        pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> int:
        """
        Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1. +optional
        """
        return pulumi.get(self, "failure_threshold")

    @property
    @pulumi.getter
    def handler(self) -> 'outputs.HandlerResponse':
        """
        The action taken to determine the health of a container
        """
        return pulumi.get(self, "handler")

    @property
    @pulumi.getter(name="initialDelaySeconds")
    def initial_delay_seconds(self) -> int:
        """
        Number of seconds after the container has started before liveness probes are initiated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes +optional
        """
        return pulumi.get(self, "initial_delay_seconds")

    @property
    @pulumi.getter(name="periodSeconds")
    def period_seconds(self) -> int:
        """
        How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. +optional
        """
        return pulumi.get(self, "period_seconds")

    @property
    @pulumi.getter(name="successThreshold")
    def success_threshold(self) -> int:
        """
        Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1. Must be 1 for liveness. Minimum value is 1. +optional
        """
        return pulumi.get(self, "success_threshold")

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> int:
        """
        Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes +optional
        """
        return pulumi.get(self, "timeout_seconds")


@pulumi.output_type
class ResourceRequirementsResponse(dict):
    """
    ResourceRequirements describes the compute resource requirements.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "limitsInMap":
            suggest = "limits_in_map"
        elif key == "requestsInMap":
            suggest = "requests_in_map"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceRequirementsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceRequirementsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceRequirementsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 limits: Mapping[str, str],
                 limits_in_map: Mapping[str, str],
                 requests: Mapping[str, str],
                 requests_in_map: Mapping[str, str]):
        """
        ResourceRequirements describes the compute resource requirements.
        :param Mapping[str, str] limits: Limits describes the maximum amount of compute resources allowed. The values of the map is string form of the 'quantity' k8s type: https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        :param Mapping[str, str] limits_in_map: Limits describes the maximum amount of compute resources allowed. This is a temporary field created to migrate away from the map limits field. This is done to become compliant with k8s style API. This field is deprecated in favor of limits field.
        :param Mapping[str, str] requests: Requests describes the minimum amount of compute resources required. If Requests is omitted for a container, it defaults to Limits if that is explicitly specified, otherwise to an implementation-defined value. The values of the map is string form of the 'quantity' k8s type: https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        :param Mapping[str, str] requests_in_map: Requests describes the minimum amount of compute resources required. If Requests is omitted for a container, it defaults to Limits if that is explicitly specified, otherwise to an implementation-defined value. This is a temporary field created to migrate away from the map requests field. This is done to become compliant with k8s style API. This field is deprecated in favor of requests field.
        """
        pulumi.set(__self__, "limits", limits)
        pulumi.set(__self__, "limits_in_map", limits_in_map)
        pulumi.set(__self__, "requests", requests)
        pulumi.set(__self__, "requests_in_map", requests_in_map)

    @property
    @pulumi.getter
    def limits(self) -> Mapping[str, str]:
        """
        Limits describes the maximum amount of compute resources allowed. The values of the map is string form of the 'quantity' k8s type: https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        """
        return pulumi.get(self, "limits")

    @property
    @pulumi.getter(name="limitsInMap")
    def limits_in_map(self) -> Mapping[str, str]:
        """
        Limits describes the maximum amount of compute resources allowed. This is a temporary field created to migrate away from the map limits field. This is done to become compliant with k8s style API. This field is deprecated in favor of limits field.
        """
        return pulumi.get(self, "limits_in_map")

    @property
    @pulumi.getter
    def requests(self) -> Mapping[str, str]:
        """
        Requests describes the minimum amount of compute resources required. If Requests is omitted for a container, it defaults to Limits if that is explicitly specified, otherwise to an implementation-defined value. The values of the map is string form of the 'quantity' k8s type: https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        """
        return pulumi.get(self, "requests")

    @property
    @pulumi.getter(name="requestsInMap")
    def requests_in_map(self) -> Mapping[str, str]:
        """
        Requests describes the minimum amount of compute resources required. If Requests is omitted for a container, it defaults to Limits if that is explicitly specified, otherwise to an implementation-defined value. This is a temporary field created to migrate away from the map requests field. This is done to become compliant with k8s style API. This field is deprecated in favor of requests field.
        """
        return pulumi.get(self, "requests_in_map")


@pulumi.output_type
class SELinuxOptionsResponse(dict):
    """
    SELinuxOptions are the labels to be applied to the container
    """
    def __init__(__self__, *,
                 level: str,
                 role: str,
                 type: str,
                 user: str):
        """
        SELinuxOptions are the labels to be applied to the container
        :param str level: Level is SELinux level label that applies to the container. +optional
        :param str role: Role is a SELinux role label that applies to the container. +optional
        :param str type: Type is a SELinux type label that applies to the container. +optional
        :param str user: User is a SELinux user label that applies to the container. +optional
        """
        pulumi.set(__self__, "level", level)
        pulumi.set(__self__, "role", role)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def level(self) -> str:
        """
        Level is SELinux level label that applies to the container. +optional
        """
        return pulumi.get(self, "level")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        Role is a SELinux role label that applies to the container. +optional
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type is a SELinux type label that applies to the container. +optional
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def user(self) -> str:
        """
        User is a SELinux user label that applies to the container. +optional
        """
        return pulumi.get(self, "user")


@pulumi.output_type
class SecretEnvSourceResponse(dict):
    """
    SecretEnvSource selects a Secret to populate the environment variables with. The contents of the target Secret's Data field will represent the key-value pairs as environment variables.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "localObjectReference":
            suggest = "local_object_reference"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretEnvSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretEnvSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretEnvSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 local_object_reference: 'outputs.LocalObjectReferenceResponse',
                 name: str,
                 optional: bool):
        """
        SecretEnvSource selects a Secret to populate the environment variables with. The contents of the target Secret's Data field will represent the key-value pairs as environment variables.
        :param 'LocalObjectReferenceResponse' local_object_reference: This field should not be used directly as it is meant to be inlined directly into the message. Use the "name" field instead.
        :param str name: Cloud Run fully managed: not supported Cloud Run for Anthos: supported The Secret to select from.
        :param bool optional: Cloud Run fully managed: not supported Cloud Run for Anthos: supported Specify whether the Secret must be defined +optional
        """
        pulumi.set(__self__, "local_object_reference", local_object_reference)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "optional", optional)

    @property
    @pulumi.getter(name="localObjectReference")
    def local_object_reference(self) -> 'outputs.LocalObjectReferenceResponse':
        """
        This field should not be used directly as it is meant to be inlined directly into the message. Use the "name" field instead.
        """
        return pulumi.get(self, "local_object_reference")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Cloud Run fully managed: not supported Cloud Run for Anthos: supported The Secret to select from.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def optional(self) -> bool:
        """
        Cloud Run fully managed: not supported Cloud Run for Anthos: supported Specify whether the Secret must be defined +optional
        """
        return pulumi.get(self, "optional")


@pulumi.output_type
class SecretKeySelectorResponse(dict):
    """
    Cloud Run fully managed: not supported Cloud Run on GKE: supported SecretKeySelector selects a key of a Secret.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "localObjectReference":
            suggest = "local_object_reference"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretKeySelectorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretKeySelectorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretKeySelectorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key: str,
                 local_object_reference: 'outputs.LocalObjectReferenceResponse',
                 name: str,
                 optional: bool):
        """
        Cloud Run fully managed: not supported Cloud Run on GKE: supported SecretKeySelector selects a key of a Secret.
        :param str key: Cloud Run fully managed: not supported Cloud Run on GKE: supported The key of the secret to select from. Must be a valid secret key.
        :param 'LocalObjectReferenceResponse' local_object_reference: This field should not be used directly as it is meant to be inlined directly into the message. Use the "name" field instead.
        :param str name: Cloud Run fully managed: not supported Cloud Run on GKE: supported The name of the secret in the pod's namespace to select from.
        :param bool optional: Cloud Run fully managed: not supported Cloud Run on GKE: supported Specify whether the Secret or its key must be defined +optional
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "local_object_reference", local_object_reference)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "optional", optional)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Cloud Run fully managed: not supported Cloud Run on GKE: supported The key of the secret to select from. Must be a valid secret key.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="localObjectReference")
    def local_object_reference(self) -> 'outputs.LocalObjectReferenceResponse':
        """
        This field should not be used directly as it is meant to be inlined directly into the message. Use the "name" field instead.
        """
        return pulumi.get(self, "local_object_reference")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Cloud Run fully managed: not supported Cloud Run on GKE: supported The name of the secret in the pod's namespace to select from.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def optional(self) -> bool:
        """
        Cloud Run fully managed: not supported Cloud Run on GKE: supported Specify whether the Secret or its key must be defined +optional
        """
        return pulumi.get(self, "optional")


@pulumi.output_type
class SecretVolumeSourceResponse(dict):
    """
    The contents of the target Secret's Data field will be presented in a volume as files using the keys in the Data field as the file names.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultMode":
            suggest = "default_mode"
        elif key == "secretName":
            suggest = "secret_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretVolumeSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretVolumeSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretVolumeSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_mode: int,
                 items: Sequence['outputs.KeyToPathResponse'],
                 optional: bool,
                 secret_name: str):
        """
        The contents of the target Secret's Data field will be presented in a volume as files using the keys in the Data field as the file names.
        :param int default_mode: Mode bits to use on created files by default. Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        :param Sequence['KeyToPathResponse'] items: If unspecified, each key-value pair in the Data field of the referenced Secret will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the Secret, the volume setup will error unless it is marked optional.
        :param bool optional: Specify whether the Secret or its keys must be defined.
        :param str secret_name: Name of the secret in the container's namespace to use.
        """
        pulumi.set(__self__, "default_mode", default_mode)
        pulumi.set(__self__, "items", items)
        pulumi.set(__self__, "optional", optional)
        pulumi.set(__self__, "secret_name", secret_name)

    @property
    @pulumi.getter(name="defaultMode")
    def default_mode(self) -> int:
        """
        Mode bits to use on created files by default. Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        """
        return pulumi.get(self, "default_mode")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.KeyToPathResponse']:
        """
        If unspecified, each key-value pair in the Data field of the referenced Secret will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the Secret, the volume setup will error unless it is marked optional.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter
    def optional(self) -> bool:
        """
        Specify whether the Secret or its keys must be defined.
        """
        return pulumi.get(self, "optional")

    @property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> str:
        """
        Name of the secret in the container's namespace to use.
        """
        return pulumi.get(self, "secret_name")


@pulumi.output_type
class SecurityContextResponse(dict):
    """
    SecurityContext holds security configuration that will be applied to a container. Some fields are present in both SecurityContext and PodSecurityContext. When both are set, the values in SecurityContext take precedence.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowPrivilegeEscalation":
            suggest = "allow_privilege_escalation"
        elif key == "readOnlyRootFilesystem":
            suggest = "read_only_root_filesystem"
        elif key == "runAsGroup":
            suggest = "run_as_group"
        elif key == "runAsNonRoot":
            suggest = "run_as_non_root"
        elif key == "runAsUser":
            suggest = "run_as_user"
        elif key == "seLinuxOptions":
            suggest = "se_linux_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityContextResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityContextResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityContextResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_privilege_escalation: bool,
                 capabilities: 'outputs.CapabilitiesResponse',
                 privileged: bool,
                 read_only_root_filesystem: bool,
                 run_as_group: int,
                 run_as_non_root: bool,
                 run_as_user: int,
                 se_linux_options: 'outputs.SELinuxOptionsResponse'):
        """
        SecurityContext holds security configuration that will be applied to a container. Some fields are present in both SecurityContext and PodSecurityContext. When both are set, the values in SecurityContext take precedence.
        :param bool allow_privilege_escalation: AllowPrivilegeEscalation controls whether a process can gain more privileges than its parent process. This bool directly controls if the no_new_privs flag will be set on the container process. AllowPrivilegeEscalation is true always when the container is: 1) run as Privileged 2) has CAP_SYS_ADMIN +optional
        :param 'CapabilitiesResponse' capabilities: The capabilities to add/drop when running containers. Defaults to the default set of capabilities granted by the container runtime. +optional
        :param bool privileged: Run container in privileged mode. Processes in privileged containers are essentially equivalent to root on the host. Defaults to false. +optional
        :param bool read_only_root_filesystem: Whether this container has a read-only root filesystem. Default is false. +optional
        :param int run_as_group: The GID to run the entrypoint of the container process. Uses runtime default if unset. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence. +optional
        :param bool run_as_non_root: Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. If unset or false, no such validation will be performed. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence. +optional
        :param int run_as_user: The UID to run the entrypoint of the container process. Defaults to user specified in image metadata if unspecified. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence. +optional
        :param 'SELinuxOptionsResponse' se_linux_options: The SELinux context to be applied to the container. If unspecified, the container runtime will allocate a random SELinux context for each container. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence. +optional
        """
        pulumi.set(__self__, "allow_privilege_escalation", allow_privilege_escalation)
        pulumi.set(__self__, "capabilities", capabilities)
        pulumi.set(__self__, "privileged", privileged)
        pulumi.set(__self__, "read_only_root_filesystem", read_only_root_filesystem)
        pulumi.set(__self__, "run_as_group", run_as_group)
        pulumi.set(__self__, "run_as_non_root", run_as_non_root)
        pulumi.set(__self__, "run_as_user", run_as_user)
        pulumi.set(__self__, "se_linux_options", se_linux_options)

    @property
    @pulumi.getter(name="allowPrivilegeEscalation")
    def allow_privilege_escalation(self) -> bool:
        """
        AllowPrivilegeEscalation controls whether a process can gain more privileges than its parent process. This bool directly controls if the no_new_privs flag will be set on the container process. AllowPrivilegeEscalation is true always when the container is: 1) run as Privileged 2) has CAP_SYS_ADMIN +optional
        """
        return pulumi.get(self, "allow_privilege_escalation")

    @property
    @pulumi.getter
    def capabilities(self) -> 'outputs.CapabilitiesResponse':
        """
        The capabilities to add/drop when running containers. Defaults to the default set of capabilities granted by the container runtime. +optional
        """
        return pulumi.get(self, "capabilities")

    @property
    @pulumi.getter
    def privileged(self) -> bool:
        """
        Run container in privileged mode. Processes in privileged containers are essentially equivalent to root on the host. Defaults to false. +optional
        """
        return pulumi.get(self, "privileged")

    @property
    @pulumi.getter(name="readOnlyRootFilesystem")
    def read_only_root_filesystem(self) -> bool:
        """
        Whether this container has a read-only root filesystem. Default is false. +optional
        """
        return pulumi.get(self, "read_only_root_filesystem")

    @property
    @pulumi.getter(name="runAsGroup")
    def run_as_group(self) -> int:
        """
        The GID to run the entrypoint of the container process. Uses runtime default if unset. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence. +optional
        """
        return pulumi.get(self, "run_as_group")

    @property
    @pulumi.getter(name="runAsNonRoot")
    def run_as_non_root(self) -> bool:
        """
        Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. If unset or false, no such validation will be performed. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence. +optional
        """
        return pulumi.get(self, "run_as_non_root")

    @property
    @pulumi.getter(name="runAsUser")
    def run_as_user(self) -> int:
        """
        The UID to run the entrypoint of the container process. Defaults to user specified in image metadata if unspecified. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence. +optional
        """
        return pulumi.get(self, "run_as_user")

    @property
    @pulumi.getter(name="seLinuxOptions")
    def se_linux_options(self) -> 'outputs.SELinuxOptionsResponse':
        """
        The SELinux context to be applied to the container. If unspecified, the container runtime will allocate a random SELinux context for each container. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence. +optional
        """
        return pulumi.get(self, "se_linux_options")


@pulumi.output_type
class TCPSocketActionResponse(dict):
    """
    TCPSocketAction describes an action based on opening a socket
    """
    def __init__(__self__, *,
                 host: str,
                 port: 'outputs.IntOrStringResponse'):
        """
        TCPSocketAction describes an action based on opening a socket
        :param str host: Optional: Host name to connect to, defaults to the pod IP. +optional
        :param 'IntOrStringResponse' port: Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        Optional: Host name to connect to, defaults to the pod IP. +optional
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def port(self) -> 'outputs.IntOrStringResponse':
        """
        Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class VolumeDeviceResponse(dict):
    """
    volumeDevice describes a mapping of a raw block device within a container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "devicePath":
            suggest = "device_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeDeviceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeDeviceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeDeviceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 device_path: str,
                 name: str):
        """
        volumeDevice describes a mapping of a raw block device within a container.
        :param str device_path: devicePath is the path inside of the container that the device will be mapped to.
        :param str name: name must match the name of a persistentVolumeClaim in the pod
        """
        pulumi.set(__self__, "device_path", device_path)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="devicePath")
    def device_path(self) -> str:
        """
        devicePath is the path inside of the container that the device will be mapped to.
        """
        return pulumi.get(self, "device_path")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        name must match the name of a persistentVolumeClaim in the pod
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class VolumeMountResponse(dict):
    """
    VolumeMount describes a mounting of a Volume within a container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountPath":
            suggest = "mount_path"
        elif key == "mountPropagation":
            suggest = "mount_propagation"
        elif key == "readOnly":
            suggest = "read_only"
        elif key == "subPath":
            suggest = "sub_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeMountResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeMountResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeMountResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mount_path: str,
                 mount_propagation: str,
                 name: str,
                 read_only: bool,
                 sub_path: str):
        """
        VolumeMount describes a mounting of a Volume within a container.
        :param str mount_path: Path within the container at which the volume should be mounted. Must not contain ':'.
        :param str mount_propagation: mountPropagation determines how mounts are propagated from the host to container and the other way around. When not set, MountPropagationHostToContainer is used. This field is beta in 1.10. +optional
        :param str name: This must match the Name of a Volume.
        :param bool read_only: Mounted read-only if true, read-write otherwise (false or unspecified). Defaults to false. +optional
        :param str sub_path: Path within the volume from which the container's volume should be mounted. Defaults to "" (volume's root). +optional
        """
        pulumi.set(__self__, "mount_path", mount_path)
        pulumi.set(__self__, "mount_propagation", mount_propagation)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "read_only", read_only)
        pulumi.set(__self__, "sub_path", sub_path)

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> str:
        """
        Path within the container at which the volume should be mounted. Must not contain ':'.
        """
        return pulumi.get(self, "mount_path")

    @property
    @pulumi.getter(name="mountPropagation")
    def mount_propagation(self) -> str:
        """
        mountPropagation determines how mounts are propagated from the host to container and the other way around. When not set, MountPropagationHostToContainer is used. This field is beta in 1.10. +optional
        """
        return pulumi.get(self, "mount_propagation")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        This must match the Name of a Volume.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> bool:
        """
        Mounted read-only if true, read-write otherwise (false or unspecified). Defaults to false. +optional
        """
        return pulumi.get(self, "read_only")

    @property
    @pulumi.getter(name="subPath")
    def sub_path(self) -> str:
        """
        Path within the volume from which the container's volume should be mounted. Defaults to "" (volume's root). +optional
        """
        return pulumi.get(self, "sub_path")


@pulumi.output_type
class VolumeResponse(dict):
    """
    Volume represents a named volume in a container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configMap":
            suggest = "config_map"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VolumeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VolumeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VolumeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config_map: 'outputs.ConfigMapVolumeSourceResponse',
                 name: str,
                 secret: 'outputs.SecretVolumeSourceResponse'):
        """
        Volume represents a named volume in a container.
        :param str name: Volume's name.
        """
        pulumi.set(__self__, "config_map", config_map)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "secret", secret)

    @property
    @pulumi.getter(name="configMap")
    def config_map(self) -> 'outputs.ConfigMapVolumeSourceResponse':
        return pulumi.get(self, "config_map")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Volume's name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def secret(self) -> 'outputs.SecretVolumeSourceResponse':
        return pulumi.get(self, "secret")


