# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'AptRepositoryResponse',
    'AptSettingsResponse',
    'AssignmentGroupLabelResponse',
    'AssignmentOsTypeResponse',
    'AssignmentResponse',
    'ExecStepConfigResponse',
    'ExecStepResponse',
    'FixedOrPercentResponse',
    'GcsObjectResponse',
    'GooRepositoryResponse',
    'GooSettingsResponse',
    'MonthlyScheduleResponse',
    'OneTimeScheduleResponse',
    'PackageRepositoryResponse',
    'PackageResponse',
    'PatchConfigResponse',
    'PatchInstanceFilterGroupLabelResponse',
    'PatchInstanceFilterResponse',
    'PatchRolloutResponse',
    'RecurringScheduleResponse',
    'SoftwareRecipeArtifactGcsResponse',
    'SoftwareRecipeArtifactRemoteResponse',
    'SoftwareRecipeArtifactResponse',
    'SoftwareRecipeResponse',
    'SoftwareRecipeStepCopyFileResponse',
    'SoftwareRecipeStepExecFileResponse',
    'SoftwareRecipeStepExtractArchiveResponse',
    'SoftwareRecipeStepInstallDpkgResponse',
    'SoftwareRecipeStepInstallMsiResponse',
    'SoftwareRecipeStepInstallRpmResponse',
    'SoftwareRecipeStepResponse',
    'SoftwareRecipeStepRunScriptResponse',
    'TimeOfDayResponse',
    'TimeZoneResponse',
    'WeekDayOfMonthResponse',
    'WeeklyScheduleResponse',
    'WindowsUpdateSettingsResponse',
    'YumRepositoryResponse',
    'YumSettingsResponse',
    'ZypperRepositoryResponse',
    'ZypperSettingsResponse',
]

@pulumi.output_type
class AptRepositoryResponse(dict):
    """
    Represents a single Apt package repository. This repository is added to a repo file that is stored at `/etc/apt/sources.list.d/google_osconfig.list`.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "archiveType":
            suggest = "archive_type"
        elif key == "gpgKey":
            suggest = "gpg_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AptRepositoryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AptRepositoryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AptRepositoryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 archive_type: str,
                 components: Sequence[str],
                 distribution: str,
                 gpg_key: str,
                 uri: str):
        """
        Represents a single Apt package repository. This repository is added to a repo file that is stored at `/etc/apt/sources.list.d/google_osconfig.list`.
        :param str archive_type: Type of archive files in this repository. The default behavior is DEB.
        :param Sequence[str] components: Required. List of components for this repository. Must contain at least one item.
        :param str distribution: Required. Distribution of this repository.
        :param str gpg_key: URI of the key file for this repository. The agent maintains a keyring at `/etc/apt/trusted.gpg.d/osconfig_agent_managed.gpg` containing all the keys in any applied guest policy.
        :param str uri: Required. URI for this repository.
        """
        pulumi.set(__self__, "archive_type", archive_type)
        pulumi.set(__self__, "components", components)
        pulumi.set(__self__, "distribution", distribution)
        pulumi.set(__self__, "gpg_key", gpg_key)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="archiveType")
    def archive_type(self) -> str:
        """
        Type of archive files in this repository. The default behavior is DEB.
        """
        return pulumi.get(self, "archive_type")

    @property
    @pulumi.getter
    def components(self) -> Sequence[str]:
        """
        Required. List of components for this repository. Must contain at least one item.
        """
        return pulumi.get(self, "components")

    @property
    @pulumi.getter
    def distribution(self) -> str:
        """
        Required. Distribution of this repository.
        """
        return pulumi.get(self, "distribution")

    @property
    @pulumi.getter(name="gpgKey")
    def gpg_key(self) -> str:
        """
        URI of the key file for this repository. The agent maintains a keyring at `/etc/apt/trusted.gpg.d/osconfig_agent_managed.gpg` containing all the keys in any applied guest policy.
        """
        return pulumi.get(self, "gpg_key")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        Required. URI for this repository.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class AptSettingsResponse(dict):
    """
    Apt patching is completed by executing `apt-get update && apt-get upgrade`. Additional options can be set to control how this is executed.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exclusivePackages":
            suggest = "exclusive_packages"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AptSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AptSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AptSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 excludes: Sequence[str],
                 exclusive_packages: Sequence[str],
                 type: str):
        """
        Apt patching is completed by executing `apt-get update && apt-get upgrade`. Additional options can be set to control how this is executed.
        :param Sequence[str] excludes: List of packages to exclude from update. These packages will be excluded
        :param Sequence[str] exclusive_packages: An exclusive list of packages to be updated. These are the only packages that will be updated. If these packages are not installed, they will be ignored. This field cannot be specified with any other patch configuration fields.
        :param str type: By changing the type to DIST, the patching is performed using `apt-get dist-upgrade` instead.
        """
        pulumi.set(__self__, "excludes", excludes)
        pulumi.set(__self__, "exclusive_packages", exclusive_packages)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def excludes(self) -> Sequence[str]:
        """
        List of packages to exclude from update. These packages will be excluded
        """
        return pulumi.get(self, "excludes")

    @property
    @pulumi.getter(name="exclusivePackages")
    def exclusive_packages(self) -> Sequence[str]:
        """
        An exclusive list of packages to be updated. These are the only packages that will be updated. If these packages are not installed, they will be ignored. This field cannot be specified with any other patch configuration fields.
        """
        return pulumi.get(self, "exclusive_packages")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        By changing the type to DIST, the patching is performed using `apt-get dist-upgrade` instead.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class AssignmentGroupLabelResponse(dict):
    """
    Represents a group of VM intances that can be identified as having all these labels, for example "env=prod and app=web".
    """
    def __init__(__self__, *,
                 labels: Mapping[str, str]):
        """
        Represents a group of VM intances that can be identified as having all these labels, for example "env=prod and app=web".
        :param Mapping[str, str] labels: Google Compute Engine instance labels that must be present for an instance to be included in this assignment group.
        """
        pulumi.set(__self__, "labels", labels)

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Google Compute Engine instance labels that must be present for an instance to be included in this assignment group.
        """
        return pulumi.get(self, "labels")


@pulumi.output_type
class AssignmentOsTypeResponse(dict):
    """
    Defines the criteria for selecting VM Instances by OS type.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "osArchitecture":
            suggest = "os_architecture"
        elif key == "osShortName":
            suggest = "os_short_name"
        elif key == "osVersion":
            suggest = "os_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AssignmentOsTypeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AssignmentOsTypeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AssignmentOsTypeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 os_architecture: str,
                 os_short_name: str,
                 os_version: str):
        """
        Defines the criteria for selecting VM Instances by OS type.
        :param str os_architecture: Targets VM instances with OS Inventory enabled and having the following OS architecture.
        :param str os_short_name: Targets VM instances with OS Inventory enabled and having the following OS short name, for example "debian" or "windows".
        :param str os_version: Targets VM instances with OS Inventory enabled and having the following following OS version.
        """
        pulumi.set(__self__, "os_architecture", os_architecture)
        pulumi.set(__self__, "os_short_name", os_short_name)
        pulumi.set(__self__, "os_version", os_version)

    @property
    @pulumi.getter(name="osArchitecture")
    def os_architecture(self) -> str:
        """
        Targets VM instances with OS Inventory enabled and having the following OS architecture.
        """
        return pulumi.get(self, "os_architecture")

    @property
    @pulumi.getter(name="osShortName")
    def os_short_name(self) -> str:
        """
        Targets VM instances with OS Inventory enabled and having the following OS short name, for example "debian" or "windows".
        """
        return pulumi.get(self, "os_short_name")

    @property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> str:
        """
        Targets VM instances with OS Inventory enabled and having the following following OS version.
        """
        return pulumi.get(self, "os_version")


@pulumi.output_type
class AssignmentResponse(dict):
    """
    An assignment represents the group or groups of VM instances that the policy applies to. If an assignment is empty, it applies to all VM instances. Otherwise, the targeted VM instances must meet all the criteria specified. So if both labels and zones are specified, the policy applies to VM instances with those labels and in those zones.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupLabels":
            suggest = "group_labels"
        elif key == "instanceNamePrefixes":
            suggest = "instance_name_prefixes"
        elif key == "osTypes":
            suggest = "os_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AssignmentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AssignmentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AssignmentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 group_labels: Sequence['outputs.AssignmentGroupLabelResponse'],
                 instance_name_prefixes: Sequence[str],
                 instances: Sequence[str],
                 os_types: Sequence['outputs.AssignmentOsTypeResponse'],
                 zones: Sequence[str]):
        """
        An assignment represents the group or groups of VM instances that the policy applies to. If an assignment is empty, it applies to all VM instances. Otherwise, the targeted VM instances must meet all the criteria specified. So if both labels and zones are specified, the policy applies to VM instances with those labels and in those zones.
        :param Sequence['AssignmentGroupLabelResponse'] group_labels: Targets instances matching at least one of these label sets. This allows an assignment to target disparate groups, for example "env=prod or env=staging".
        :param Sequence[str] instance_name_prefixes: Targets VM instances whose name starts with one of these prefixes. Like labels, this is another way to group VM instances when targeting configs, for example prefix="prod-". Only supported for project-level policies.
        :param Sequence[str] instances: Targets any of the instances specified. Instances are specified by their URI in the form `zones/[ZONE]/instances/[INSTANCE_NAME]`. Instance targeting is uncommon and is supported to facilitate the management of changes by the instance or to target specific VM instances for development and testing. Only supported for project-level policies and must reference instances within this project.
        :param Sequence['AssignmentOsTypeResponse'] os_types: Targets VM instances matching at least one of the following OS types. VM instances must match all supplied criteria for a given OsType to be included.
        :param Sequence[str] zones: Targets instances in any of these zones. Leave empty to target instances in any zone. Zonal targeting is uncommon and is supported to facilitate the management of changes by zone.
        """
        pulumi.set(__self__, "group_labels", group_labels)
        pulumi.set(__self__, "instance_name_prefixes", instance_name_prefixes)
        pulumi.set(__self__, "instances", instances)
        pulumi.set(__self__, "os_types", os_types)
        pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter(name="groupLabels")
    def group_labels(self) -> Sequence['outputs.AssignmentGroupLabelResponse']:
        """
        Targets instances matching at least one of these label sets. This allows an assignment to target disparate groups, for example "env=prod or env=staging".
        """
        return pulumi.get(self, "group_labels")

    @property
    @pulumi.getter(name="instanceNamePrefixes")
    def instance_name_prefixes(self) -> Sequence[str]:
        """
        Targets VM instances whose name starts with one of these prefixes. Like labels, this is another way to group VM instances when targeting configs, for example prefix="prod-". Only supported for project-level policies.
        """
        return pulumi.get(self, "instance_name_prefixes")

    @property
    @pulumi.getter
    def instances(self) -> Sequence[str]:
        """
        Targets any of the instances specified. Instances are specified by their URI in the form `zones/[ZONE]/instances/[INSTANCE_NAME]`. Instance targeting is uncommon and is supported to facilitate the management of changes by the instance or to target specific VM instances for development and testing. Only supported for project-level policies and must reference instances within this project.
        """
        return pulumi.get(self, "instances")

    @property
    @pulumi.getter(name="osTypes")
    def os_types(self) -> Sequence['outputs.AssignmentOsTypeResponse']:
        """
        Targets VM instances matching at least one of the following OS types. VM instances must match all supplied criteria for a given OsType to be included.
        """
        return pulumi.get(self, "os_types")

    @property
    @pulumi.getter
    def zones(self) -> Sequence[str]:
        """
        Targets instances in any of these zones. Leave empty to target instances in any zone. Zonal targeting is uncommon and is supported to facilitate the management of changes by zone.
        """
        return pulumi.get(self, "zones")


@pulumi.output_type
class ExecStepConfigResponse(dict):
    """
    Common configurations for an ExecStep.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedSuccessCodes":
            suggest = "allowed_success_codes"
        elif key == "gcsObject":
            suggest = "gcs_object"
        elif key == "localPath":
            suggest = "local_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExecStepConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExecStepConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExecStepConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_success_codes: Sequence[int],
                 gcs_object: 'outputs.GcsObjectResponse',
                 interpreter: str,
                 local_path: str):
        """
        Common configurations for an ExecStep.
        :param Sequence[int] allowed_success_codes: Defaults to [0]. A list of possible return values that the execution can return to indicate a success.
        :param 'GcsObjectResponse' gcs_object: A Google Cloud Storage object containing the executable.
        :param str interpreter: The script interpreter to use to run the script. If no interpreter is specified the script will be executed directly, which will likely only succeed for scripts with [shebang lines] (https://en.wikipedia.org/wiki/Shebang_\(Unix\)).
        :param str local_path: An absolute path to the executable on the VM.
        """
        pulumi.set(__self__, "allowed_success_codes", allowed_success_codes)
        pulumi.set(__self__, "gcs_object", gcs_object)
        pulumi.set(__self__, "interpreter", interpreter)
        pulumi.set(__self__, "local_path", local_path)

    @property
    @pulumi.getter(name="allowedSuccessCodes")
    def allowed_success_codes(self) -> Sequence[int]:
        """
        Defaults to [0]. A list of possible return values that the execution can return to indicate a success.
        """
        return pulumi.get(self, "allowed_success_codes")

    @property
    @pulumi.getter(name="gcsObject")
    def gcs_object(self) -> 'outputs.GcsObjectResponse':
        """
        A Google Cloud Storage object containing the executable.
        """
        return pulumi.get(self, "gcs_object")

    @property
    @pulumi.getter
    def interpreter(self) -> str:
        """
        The script interpreter to use to run the script. If no interpreter is specified the script will be executed directly, which will likely only succeed for scripts with [shebang lines] (https://en.wikipedia.org/wiki/Shebang_\(Unix\)).
        """
        return pulumi.get(self, "interpreter")

    @property
    @pulumi.getter(name="localPath")
    def local_path(self) -> str:
        """
        An absolute path to the executable on the VM.
        """
        return pulumi.get(self, "local_path")


@pulumi.output_type
class ExecStepResponse(dict):
    """
    A step that runs an executable for a PatchJob.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "linuxExecStepConfig":
            suggest = "linux_exec_step_config"
        elif key == "windowsExecStepConfig":
            suggest = "windows_exec_step_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExecStepResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExecStepResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExecStepResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 linux_exec_step_config: 'outputs.ExecStepConfigResponse',
                 windows_exec_step_config: 'outputs.ExecStepConfigResponse'):
        """
        A step that runs an executable for a PatchJob.
        :param 'ExecStepConfigResponse' linux_exec_step_config: The ExecStepConfig for all Linux VMs targeted by the PatchJob.
        :param 'ExecStepConfigResponse' windows_exec_step_config: The ExecStepConfig for all Windows VMs targeted by the PatchJob.
        """
        pulumi.set(__self__, "linux_exec_step_config", linux_exec_step_config)
        pulumi.set(__self__, "windows_exec_step_config", windows_exec_step_config)

    @property
    @pulumi.getter(name="linuxExecStepConfig")
    def linux_exec_step_config(self) -> 'outputs.ExecStepConfigResponse':
        """
        The ExecStepConfig for all Linux VMs targeted by the PatchJob.
        """
        return pulumi.get(self, "linux_exec_step_config")

    @property
    @pulumi.getter(name="windowsExecStepConfig")
    def windows_exec_step_config(self) -> 'outputs.ExecStepConfigResponse':
        """
        The ExecStepConfig for all Windows VMs targeted by the PatchJob.
        """
        return pulumi.get(self, "windows_exec_step_config")


@pulumi.output_type
class FixedOrPercentResponse(dict):
    """
    Message encapsulating a value that can be either absolute ("fixed") or relative ("percent") to a value.
    """
    def __init__(__self__, *,
                 fixed: int,
                 percent: int):
        """
        Message encapsulating a value that can be either absolute ("fixed") or relative ("percent") to a value.
        :param int fixed: Specifies a fixed value.
        :param int percent: Specifies the relative value defined as a percentage, which will be multiplied by a reference value.
        """
        pulumi.set(__self__, "fixed", fixed)
        pulumi.set(__self__, "percent", percent)

    @property
    @pulumi.getter
    def fixed(self) -> int:
        """
        Specifies a fixed value.
        """
        return pulumi.get(self, "fixed")

    @property
    @pulumi.getter
    def percent(self) -> int:
        """
        Specifies the relative value defined as a percentage, which will be multiplied by a reference value.
        """
        return pulumi.get(self, "percent")


@pulumi.output_type
class GcsObjectResponse(dict):
    """
    Google Cloud Storage object representation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "generationNumber":
            suggest = "generation_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GcsObjectResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GcsObjectResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GcsObjectResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: str,
                 generation_number: str,
                 object: str):
        """
        Google Cloud Storage object representation.
        :param str bucket: Required. Bucket of the Google Cloud Storage object.
        :param str generation_number: Required. Generation number of the Google Cloud Storage object. This is used to ensure that the ExecStep specified by this PatchJob does not change.
        :param str object: Required. Name of the Google Cloud Storage object.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "generation_number", generation_number)
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Required. Bucket of the Google Cloud Storage object.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="generationNumber")
    def generation_number(self) -> str:
        """
        Required. Generation number of the Google Cloud Storage object. This is used to ensure that the ExecStep specified by this PatchJob does not change.
        """
        return pulumi.get(self, "generation_number")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        Required. Name of the Google Cloud Storage object.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class GooRepositoryResponse(dict):
    """
    Represents a Goo package repository. These is added to a repo file that is stored at C:/ProgramData/GooGet/repos/google_osconfig.repo.
    """
    def __init__(__self__, *,
                 name: str,
                 url: str):
        """
        Represents a Goo package repository. These is added to a repo file that is stored at C:/ProgramData/GooGet/repos/google_osconfig.repo.
        :param str name: Required. The name of the repository.
        :param str url: Required. The url of the repository.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Required. The name of the repository.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        Required. The url of the repository.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class GooSettingsResponse(dict):
    """
    Googet patching is performed by running `googet update`.
    """
    def __init__(__self__):
        """
        Googet patching is performed by running `googet update`.
        """
        pass


@pulumi.output_type
class MonthlyScheduleResponse(dict):
    """
    Represents a monthly schedule. An example of a valid monthly schedule is "on the third Tuesday of the month" or "on the 15th of the month".
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "monthDay":
            suggest = "month_day"
        elif key == "weekDayOfMonth":
            suggest = "week_day_of_month"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonthlyScheduleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonthlyScheduleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonthlyScheduleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 month_day: int,
                 week_day_of_month: 'outputs.WeekDayOfMonthResponse'):
        """
        Represents a monthly schedule. An example of a valid monthly schedule is "on the third Tuesday of the month" or "on the 15th of the month".
        :param int month_day: Required. One day of the month. 1-31 indicates the 1st to the 31st day. -1 indicates the last day of the month. Months without the target day will be skipped. For example, a schedule to run "every month on the 31st" will not run in February, April, June, etc.
        :param 'WeekDayOfMonthResponse' week_day_of_month: Required. Week day in a month.
        """
        pulumi.set(__self__, "month_day", month_day)
        pulumi.set(__self__, "week_day_of_month", week_day_of_month)

    @property
    @pulumi.getter(name="monthDay")
    def month_day(self) -> int:
        """
        Required. One day of the month. 1-31 indicates the 1st to the 31st day. -1 indicates the last day of the month. Months without the target day will be skipped. For example, a schedule to run "every month on the 31st" will not run in February, April, June, etc.
        """
        return pulumi.get(self, "month_day")

    @property
    @pulumi.getter(name="weekDayOfMonth")
    def week_day_of_month(self) -> 'outputs.WeekDayOfMonthResponse':
        """
        Required. Week day in a month.
        """
        return pulumi.get(self, "week_day_of_month")


@pulumi.output_type
class OneTimeScheduleResponse(dict):
    """
    Sets the time for a one time patch deployment. Timestamp is in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "executeTime":
            suggest = "execute_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OneTimeScheduleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OneTimeScheduleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OneTimeScheduleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 execute_time: str):
        """
        Sets the time for a one time patch deployment. Timestamp is in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
        :param str execute_time: Required. The desired patch job execution time.
        """
        pulumi.set(__self__, "execute_time", execute_time)

    @property
    @pulumi.getter(name="executeTime")
    def execute_time(self) -> str:
        """
        Required. The desired patch job execution time.
        """
        return pulumi.get(self, "execute_time")


@pulumi.output_type
class PackageRepositoryResponse(dict):
    """
    A package repository.
    """
    def __init__(__self__, *,
                 apt: 'outputs.AptRepositoryResponse',
                 goo: 'outputs.GooRepositoryResponse',
                 yum: 'outputs.YumRepositoryResponse',
                 zypper: 'outputs.ZypperRepositoryResponse'):
        """
        A package repository.
        :param 'AptRepositoryResponse' apt: An Apt Repository.
        :param 'GooRepositoryResponse' goo: A Goo Repository.
        :param 'YumRepositoryResponse' yum: A Yum Repository.
        :param 'ZypperRepositoryResponse' zypper: A Zypper Repository.
        """
        pulumi.set(__self__, "apt", apt)
        pulumi.set(__self__, "goo", goo)
        pulumi.set(__self__, "yum", yum)
        pulumi.set(__self__, "zypper", zypper)

    @property
    @pulumi.getter
    def apt(self) -> 'outputs.AptRepositoryResponse':
        """
        An Apt Repository.
        """
        return pulumi.get(self, "apt")

    @property
    @pulumi.getter
    def goo(self) -> 'outputs.GooRepositoryResponse':
        """
        A Goo Repository.
        """
        return pulumi.get(self, "goo")

    @property
    @pulumi.getter
    def yum(self) -> 'outputs.YumRepositoryResponse':
        """
        A Yum Repository.
        """
        return pulumi.get(self, "yum")

    @property
    @pulumi.getter
    def zypper(self) -> 'outputs.ZypperRepositoryResponse':
        """
        A Zypper Repository.
        """
        return pulumi.get(self, "zypper")


@pulumi.output_type
class PackageResponse(dict):
    """
    Package is a reference to the software package to be installed or removed. The agent on the VM instance uses the system package manager to apply the config. These are the commands that the agent uses to install or remove packages. Apt install: `apt-get update && apt-get -y install package1 package2 package3` remove: `apt-get -y remove package1 package2 package3` Yum install: `yum -y install package1 package2 package3` remove: `yum -y remove package1 package2 package3` Zypper install: `zypper install package1 package2 package3` remove: `zypper rm package1 package2` Googet install: `googet -noconfirm install package1 package2 package3` remove: `googet -noconfirm remove package1 package2 package3`
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "desiredState":
            suggest = "desired_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PackageResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PackageResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PackageResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 desired_state: str,
                 manager: str,
                 name: str):
        """
        Package is a reference to the software package to be installed or removed. The agent on the VM instance uses the system package manager to apply the config. These are the commands that the agent uses to install or remove packages. Apt install: `apt-get update && apt-get -y install package1 package2 package3` remove: `apt-get -y remove package1 package2 package3` Yum install: `yum -y install package1 package2 package3` remove: `yum -y remove package1 package2 package3` Zypper install: `zypper install package1 package2 package3` remove: `zypper rm package1 package2` Googet install: `googet -noconfirm install package1 package2 package3` remove: `googet -noconfirm remove package1 package2 package3`
        :param str desired_state: The desired_state the agent should maintain for this package. The default is to ensure the package is installed.
        :param str manager: Type of package manager that can be used to install this package. If a system does not have the package manager, the package is not installed or removed no error message is returned. By default, or if you specify `ANY`, the agent attempts to install and remove this package using the default package manager. This is useful when creating a policy that applies to different types of systems. The default behavior is ANY.
        :param str name: Required. The name of the package. A package is uniquely identified for conflict validation by checking the package name and the manager(s) that the package targets.
        """
        pulumi.set(__self__, "desired_state", desired_state)
        pulumi.set(__self__, "manager", manager)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="desiredState")
    def desired_state(self) -> str:
        """
        The desired_state the agent should maintain for this package. The default is to ensure the package is installed.
        """
        return pulumi.get(self, "desired_state")

    @property
    @pulumi.getter
    def manager(self) -> str:
        """
        Type of package manager that can be used to install this package. If a system does not have the package manager, the package is not installed or removed no error message is returned. By default, or if you specify `ANY`, the agent attempts to install and remove this package using the default package manager. This is useful when creating a policy that applies to different types of systems. The default behavior is ANY.
        """
        return pulumi.get(self, "manager")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Required. The name of the package. A package is uniquely identified for conflict validation by checking the package name and the manager(s) that the package targets.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class PatchConfigResponse(dict):
    """
    Patch configuration specifications. Contains details on how to apply the patch(es) to a VM instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "postStep":
            suggest = "post_step"
        elif key == "preStep":
            suggest = "pre_step"
        elif key == "rebootConfig":
            suggest = "reboot_config"
        elif key == "windowsUpdate":
            suggest = "windows_update"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PatchConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PatchConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PatchConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 apt: 'outputs.AptSettingsResponse',
                 goo: 'outputs.GooSettingsResponse',
                 post_step: 'outputs.ExecStepResponse',
                 pre_step: 'outputs.ExecStepResponse',
                 reboot_config: str,
                 windows_update: 'outputs.WindowsUpdateSettingsResponse',
                 yum: 'outputs.YumSettingsResponse',
                 zypper: 'outputs.ZypperSettingsResponse'):
        """
        Patch configuration specifications. Contains details on how to apply the patch(es) to a VM instance.
        :param 'AptSettingsResponse' apt: Apt update settings. Use this setting to override the default `apt` patch rules.
        :param 'GooSettingsResponse' goo: Goo update settings. Use this setting to override the default `goo` patch rules.
        :param 'ExecStepResponse' post_step: The `ExecStep` to run after the patch update.
        :param 'ExecStepResponse' pre_step: The `ExecStep` to run before the patch update.
        :param str reboot_config: Post-patch reboot settings.
        :param 'WindowsUpdateSettingsResponse' windows_update: Windows update settings. Use this override the default windows patch rules.
        :param 'YumSettingsResponse' yum: Yum update settings. Use this setting to override the default `yum` patch rules.
        :param 'ZypperSettingsResponse' zypper: Zypper update settings. Use this setting to override the default `zypper` patch rules.
        """
        pulumi.set(__self__, "apt", apt)
        pulumi.set(__self__, "goo", goo)
        pulumi.set(__self__, "post_step", post_step)
        pulumi.set(__self__, "pre_step", pre_step)
        pulumi.set(__self__, "reboot_config", reboot_config)
        pulumi.set(__self__, "windows_update", windows_update)
        pulumi.set(__self__, "yum", yum)
        pulumi.set(__self__, "zypper", zypper)

    @property
    @pulumi.getter
    def apt(self) -> 'outputs.AptSettingsResponse':
        """
        Apt update settings. Use this setting to override the default `apt` patch rules.
        """
        return pulumi.get(self, "apt")

    @property
    @pulumi.getter
    def goo(self) -> 'outputs.GooSettingsResponse':
        """
        Goo update settings. Use this setting to override the default `goo` patch rules.
        """
        return pulumi.get(self, "goo")

    @property
    @pulumi.getter(name="postStep")
    def post_step(self) -> 'outputs.ExecStepResponse':
        """
        The `ExecStep` to run after the patch update.
        """
        return pulumi.get(self, "post_step")

    @property
    @pulumi.getter(name="preStep")
    def pre_step(self) -> 'outputs.ExecStepResponse':
        """
        The `ExecStep` to run before the patch update.
        """
        return pulumi.get(self, "pre_step")

    @property
    @pulumi.getter(name="rebootConfig")
    def reboot_config(self) -> str:
        """
        Post-patch reboot settings.
        """
        return pulumi.get(self, "reboot_config")

    @property
    @pulumi.getter(name="windowsUpdate")
    def windows_update(self) -> 'outputs.WindowsUpdateSettingsResponse':
        """
        Windows update settings. Use this override the default windows patch rules.
        """
        return pulumi.get(self, "windows_update")

    @property
    @pulumi.getter
    def yum(self) -> 'outputs.YumSettingsResponse':
        """
        Yum update settings. Use this setting to override the default `yum` patch rules.
        """
        return pulumi.get(self, "yum")

    @property
    @pulumi.getter
    def zypper(self) -> 'outputs.ZypperSettingsResponse':
        """
        Zypper update settings. Use this setting to override the default `zypper` patch rules.
        """
        return pulumi.get(self, "zypper")


@pulumi.output_type
class PatchInstanceFilterGroupLabelResponse(dict):
    """
    Represents a group of VMs that can be identified as having all these labels, for example "env=prod and app=web".
    """
    def __init__(__self__, *,
                 labels: Mapping[str, str]):
        """
        Represents a group of VMs that can be identified as having all these labels, for example "env=prod and app=web".
        :param Mapping[str, str] labels: Compute Engine instance labels that must be present for a VM instance to be targeted by this filter.
        """
        pulumi.set(__self__, "labels", labels)

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Compute Engine instance labels that must be present for a VM instance to be targeted by this filter.
        """
        return pulumi.get(self, "labels")


@pulumi.output_type
class PatchInstanceFilterResponse(dict):
    """
    A filter to target VM instances for patching. The targeted VMs must meet all criteria specified. So if both labels and zones are specified, the patch job targets only VMs with those labels and in those zones.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupLabels":
            suggest = "group_labels"
        elif key == "instanceNamePrefixes":
            suggest = "instance_name_prefixes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PatchInstanceFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PatchInstanceFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PatchInstanceFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 all: bool,
                 group_labels: Sequence['outputs.PatchInstanceFilterGroupLabelResponse'],
                 instance_name_prefixes: Sequence[str],
                 instances: Sequence[str],
                 zones: Sequence[str]):
        """
        A filter to target VM instances for patching. The targeted VMs must meet all criteria specified. So if both labels and zones are specified, the patch job targets only VMs with those labels and in those zones.
        :param bool all: Target all VM instances in the project. If true, no other criteria is permitted.
        :param Sequence['PatchInstanceFilterGroupLabelResponse'] group_labels: Targets VM instances matching at least one of these label sets. This allows targeting of disparate groups, for example "env=prod or env=staging".
        :param Sequence[str] instance_name_prefixes: Targets VMs whose name starts with one of these prefixes. Similar to labels, this is another way to group VMs when targeting configs, for example prefix="prod-".
        :param Sequence[str] instances: Targets any of the VM instances specified. Instances are specified by their URI in the form `zones/[ZONE]/instances/[INSTANCE_NAME]`, `projects/[PROJECT_ID]/zones/[ZONE]/instances/[INSTANCE_NAME]`, or `https://www.googleapis.com/compute/v1/projects/[PROJECT_ID]/zones/[ZONE]/instances/[INSTANCE_NAME]`
        :param Sequence[str] zones: Targets VM instances in ANY of these zones. Leave empty to target VM instances in any zone.
        """
        pulumi.set(__self__, "all", all)
        pulumi.set(__self__, "group_labels", group_labels)
        pulumi.set(__self__, "instance_name_prefixes", instance_name_prefixes)
        pulumi.set(__self__, "instances", instances)
        pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter
    def all(self) -> bool:
        """
        Target all VM instances in the project. If true, no other criteria is permitted.
        """
        return pulumi.get(self, "all")

    @property
    @pulumi.getter(name="groupLabels")
    def group_labels(self) -> Sequence['outputs.PatchInstanceFilterGroupLabelResponse']:
        """
        Targets VM instances matching at least one of these label sets. This allows targeting of disparate groups, for example "env=prod or env=staging".
        """
        return pulumi.get(self, "group_labels")

    @property
    @pulumi.getter(name="instanceNamePrefixes")
    def instance_name_prefixes(self) -> Sequence[str]:
        """
        Targets VMs whose name starts with one of these prefixes. Similar to labels, this is another way to group VMs when targeting configs, for example prefix="prod-".
        """
        return pulumi.get(self, "instance_name_prefixes")

    @property
    @pulumi.getter
    def instances(self) -> Sequence[str]:
        """
        Targets any of the VM instances specified. Instances are specified by their URI in the form `zones/[ZONE]/instances/[INSTANCE_NAME]`, `projects/[PROJECT_ID]/zones/[ZONE]/instances/[INSTANCE_NAME]`, or `https://www.googleapis.com/compute/v1/projects/[PROJECT_ID]/zones/[ZONE]/instances/[INSTANCE_NAME]`
        """
        return pulumi.get(self, "instances")

    @property
    @pulumi.getter
    def zones(self) -> Sequence[str]:
        """
        Targets VM instances in ANY of these zones. Leave empty to target VM instances in any zone.
        """
        return pulumi.get(self, "zones")


@pulumi.output_type
class PatchRolloutResponse(dict):
    """
    Patch rollout configuration specifications. Contains details on the concurrency control when applying patch(es) to all targeted VMs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disruptionBudget":
            suggest = "disruption_budget"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PatchRolloutResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PatchRolloutResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PatchRolloutResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disruption_budget: 'outputs.FixedOrPercentResponse',
                 mode: str):
        """
        Patch rollout configuration specifications. Contains details on the concurrency control when applying patch(es) to all targeted VMs.
        :param 'FixedOrPercentResponse' disruption_budget: The maximum number (or percentage) of VMs per zone to disrupt at any given moment. The number of VMs calculated from multiplying the percentage by the total number of VMs in a zone is rounded up. During patching, a VM is considered disrupted from the time the agent is notified to begin until patching has completed. This disruption time includes the time to complete reboot and any post-patch steps. A VM contributes to the disruption budget if its patching operation fails either when applying the patches, running pre or post patch steps, or if it fails to respond with a success notification before timing out. VMs that are not running or do not have an active agent do not count toward this disruption budget. For zone-by-zone rollouts, if the disruption budget in a zone is exceeded, the patch job stops, because continuing to the next zone requires completion of the patch process in the previous zone. For example, if the disruption budget has a fixed value of `10`, and 8 VMs fail to patch in the current zone, the patch job continues to patch 2 VMs at a time until the zone is completed. When that zone is completed successfully, patching begins with 10 VMs at a time in the next zone. If 10 VMs in the next zone fail to patch, the patch job stops.
        :param str mode: Mode of the patch rollout.
        """
        pulumi.set(__self__, "disruption_budget", disruption_budget)
        pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter(name="disruptionBudget")
    def disruption_budget(self) -> 'outputs.FixedOrPercentResponse':
        """
        The maximum number (or percentage) of VMs per zone to disrupt at any given moment. The number of VMs calculated from multiplying the percentage by the total number of VMs in a zone is rounded up. During patching, a VM is considered disrupted from the time the agent is notified to begin until patching has completed. This disruption time includes the time to complete reboot and any post-patch steps. A VM contributes to the disruption budget if its patching operation fails either when applying the patches, running pre or post patch steps, or if it fails to respond with a success notification before timing out. VMs that are not running or do not have an active agent do not count toward this disruption budget. For zone-by-zone rollouts, if the disruption budget in a zone is exceeded, the patch job stops, because continuing to the next zone requires completion of the patch process in the previous zone. For example, if the disruption budget has a fixed value of `10`, and 8 VMs fail to patch in the current zone, the patch job continues to patch 2 VMs at a time until the zone is completed. When that zone is completed successfully, patching begins with 10 VMs at a time in the next zone. If 10 VMs in the next zone fail to patch, the patch job stops.
        """
        return pulumi.get(self, "disruption_budget")

    @property
    @pulumi.getter
    def mode(self) -> str:
        """
        Mode of the patch rollout.
        """
        return pulumi.get(self, "mode")


@pulumi.output_type
class RecurringScheduleResponse(dict):
    """
    Sets the time for recurring patch deployments.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTime":
            suggest = "end_time"
        elif key == "lastExecuteTime":
            suggest = "last_execute_time"
        elif key == "nextExecuteTime":
            suggest = "next_execute_time"
        elif key == "startTime":
            suggest = "start_time"
        elif key == "timeOfDay":
            suggest = "time_of_day"
        elif key == "timeZone":
            suggest = "time_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RecurringScheduleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RecurringScheduleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RecurringScheduleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_time: str,
                 frequency: str,
                 last_execute_time: str,
                 monthly: 'outputs.MonthlyScheduleResponse',
                 next_execute_time: str,
                 start_time: str,
                 time_of_day: 'outputs.TimeOfDayResponse',
                 time_zone: 'outputs.TimeZoneResponse',
                 weekly: 'outputs.WeeklyScheduleResponse'):
        """
        Sets the time for recurring patch deployments.
        :param str end_time: Optional. The end time at which a recurring patch deployment schedule is no longer active.
        :param str frequency: Required. The frequency unit of this recurring schedule.
        :param str last_execute_time: The time the last patch job ran successfully.
        :param 'MonthlyScheduleResponse' monthly: Required. Schedule with monthly executions.
        :param str next_execute_time: The time the next patch job is scheduled to run.
        :param str start_time: Optional. The time that the recurring schedule becomes effective. Defaults to `create_time` of the patch deployment.
        :param 'TimeOfDayResponse' time_of_day: Required. Time of the day to run a recurring deployment.
        :param 'TimeZoneResponse' time_zone: Required. Defines the time zone that `time_of_day` is relative to. The rules for daylight saving time are determined by the chosen time zone.
        :param 'WeeklyScheduleResponse' weekly: Required. Schedule with weekly executions.
        """
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "frequency", frequency)
        pulumi.set(__self__, "last_execute_time", last_execute_time)
        pulumi.set(__self__, "monthly", monthly)
        pulumi.set(__self__, "next_execute_time", next_execute_time)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "time_of_day", time_of_day)
        pulumi.set(__self__, "time_zone", time_zone)
        pulumi.set(__self__, "weekly", weekly)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        """
        Optional. The end time at which a recurring patch deployment schedule is no longer active.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter
    def frequency(self) -> str:
        """
        Required. The frequency unit of this recurring schedule.
        """
        return pulumi.get(self, "frequency")

    @property
    @pulumi.getter(name="lastExecuteTime")
    def last_execute_time(self) -> str:
        """
        The time the last patch job ran successfully.
        """
        return pulumi.get(self, "last_execute_time")

    @property
    @pulumi.getter
    def monthly(self) -> 'outputs.MonthlyScheduleResponse':
        """
        Required. Schedule with monthly executions.
        """
        return pulumi.get(self, "monthly")

    @property
    @pulumi.getter(name="nextExecuteTime")
    def next_execute_time(self) -> str:
        """
        The time the next patch job is scheduled to run.
        """
        return pulumi.get(self, "next_execute_time")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        Optional. The time that the recurring schedule becomes effective. Defaults to `create_time` of the patch deployment.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="timeOfDay")
    def time_of_day(self) -> 'outputs.TimeOfDayResponse':
        """
        Required. Time of the day to run a recurring deployment.
        """
        return pulumi.get(self, "time_of_day")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> 'outputs.TimeZoneResponse':
        """
        Required. Defines the time zone that `time_of_day` is relative to. The rules for daylight saving time are determined by the chosen time zone.
        """
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter
    def weekly(self) -> 'outputs.WeeklyScheduleResponse':
        """
        Required. Schedule with weekly executions.
        """
        return pulumi.get(self, "weekly")


@pulumi.output_type
class SoftwareRecipeArtifactGcsResponse(dict):
    """
    Specifies an artifact available as a Google Cloud Storage object.
    """
    def __init__(__self__, *,
                 bucket: str,
                 generation: str,
                 object: str):
        """
        Specifies an artifact available as a Google Cloud Storage object.
        :param str bucket: Bucket of the Google Cloud Storage object. Given an example URL: `https://storage.googleapis.com/my-bucket/foo/bar#1234567` this value would be `my-bucket`.
        :param str generation: Must be provided if allow_insecure is false. Generation number of the Google Cloud Storage object. `https://storage.googleapis.com/my-bucket/foo/bar#1234567` this value would be `1234567`.
        :param str object: Name of the Google Cloud Storage object. As specified [here] (https://cloud.google.com/storage/docs/naming#objectnames) Given an example URL: `https://storage.googleapis.com/my-bucket/foo/bar#1234567` this value would be `foo/bar`.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "generation", generation)
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Bucket of the Google Cloud Storage object. Given an example URL: `https://storage.googleapis.com/my-bucket/foo/bar#1234567` this value would be `my-bucket`.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def generation(self) -> str:
        """
        Must be provided if allow_insecure is false. Generation number of the Google Cloud Storage object. `https://storage.googleapis.com/my-bucket/foo/bar#1234567` this value would be `1234567`.
        """
        return pulumi.get(self, "generation")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        Name of the Google Cloud Storage object. As specified [here] (https://cloud.google.com/storage/docs/naming#objectnames) Given an example URL: `https://storage.googleapis.com/my-bucket/foo/bar#1234567` this value would be `foo/bar`.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class SoftwareRecipeArtifactRemoteResponse(dict):
    """
    Specifies an artifact available via some URI.
    """
    def __init__(__self__, *,
                 checksum: str,
                 uri: str):
        """
        Specifies an artifact available via some URI.
        :param str checksum: Must be provided if `allow_insecure` is `false`. SHA256 checksum in hex format, to compare to the checksum of the artifact. If the checksum is not empty and it doesn't match the artifact then the recipe installation fails before running any of the steps.
        :param str uri: URI from which to fetch the object. It should contain both the protocol and path following the format {protocol}://{location}.
        """
        pulumi.set(__self__, "checksum", checksum)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def checksum(self) -> str:
        """
        Must be provided if `allow_insecure` is `false`. SHA256 checksum in hex format, to compare to the checksum of the artifact. If the checksum is not empty and it doesn't match the artifact then the recipe installation fails before running any of the steps.
        """
        return pulumi.get(self, "checksum")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        URI from which to fetch the object. It should contain both the protocol and path following the format {protocol}://{location}.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class SoftwareRecipeArtifactResponse(dict):
    """
    Specifies a resource to be used in the recipe.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowInsecure":
            suggest = "allow_insecure"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SoftwareRecipeArtifactResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SoftwareRecipeArtifactResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SoftwareRecipeArtifactResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_insecure: bool,
                 gcs: 'outputs.SoftwareRecipeArtifactGcsResponse',
                 remote: 'outputs.SoftwareRecipeArtifactRemoteResponse'):
        """
        Specifies a resource to be used in the recipe.
        :param bool allow_insecure: Defaults to false. When false, recipes are subject to validations based on the artifact type: Remote: A checksum must be specified, and only protocols with transport-layer security are permitted. GCS: An object generation number must be specified.
        :param 'SoftwareRecipeArtifactGcsResponse' gcs: A Google Cloud Storage artifact.
        :param 'SoftwareRecipeArtifactRemoteResponse' remote: A generic remote artifact.
        """
        pulumi.set(__self__, "allow_insecure", allow_insecure)
        pulumi.set(__self__, "gcs", gcs)
        pulumi.set(__self__, "remote", remote)

    @property
    @pulumi.getter(name="allowInsecure")
    def allow_insecure(self) -> bool:
        """
        Defaults to false. When false, recipes are subject to validations based on the artifact type: Remote: A checksum must be specified, and only protocols with transport-layer security are permitted. GCS: An object generation number must be specified.
        """
        return pulumi.get(self, "allow_insecure")

    @property
    @pulumi.getter
    def gcs(self) -> 'outputs.SoftwareRecipeArtifactGcsResponse':
        """
        A Google Cloud Storage artifact.
        """
        return pulumi.get(self, "gcs")

    @property
    @pulumi.getter
    def remote(self) -> 'outputs.SoftwareRecipeArtifactRemoteResponse':
        """
        A generic remote artifact.
        """
        return pulumi.get(self, "remote")


@pulumi.output_type
class SoftwareRecipeResponse(dict):
    """
    A software recipe is a set of instructions for installing and configuring a piece of software. It consists of a set of artifacts that are downloaded, and a set of steps that install, configure, and/or update the software. Recipes support installing and updating software from artifacts in the following formats: Zip archive, Tar archive, Windows MSI, Debian package, and RPM package. Additionally, recipes support executing a script (either defined in a file or directly in this api) in bash, sh, cmd, and powershell. Updating a software recipe If a recipe is assigned to an instance and there is a recipe with the same name but a lower version already installed and the assigned state of the recipe is `UPDATED`, then the recipe is updated to the new version. Script Working Directories Each script or execution step is run in its own temporary directory which is deleted after completing the step.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "desiredState":
            suggest = "desired_state"
        elif key == "installSteps":
            suggest = "install_steps"
        elif key == "updateSteps":
            suggest = "update_steps"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SoftwareRecipeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SoftwareRecipeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SoftwareRecipeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 artifacts: Sequence['outputs.SoftwareRecipeArtifactResponse'],
                 desired_state: str,
                 install_steps: Sequence['outputs.SoftwareRecipeStepResponse'],
                 name: str,
                 update_steps: Sequence['outputs.SoftwareRecipeStepResponse'],
                 version: str):
        """
        A software recipe is a set of instructions for installing and configuring a piece of software. It consists of a set of artifacts that are downloaded, and a set of steps that install, configure, and/or update the software. Recipes support installing and updating software from artifacts in the following formats: Zip archive, Tar archive, Windows MSI, Debian package, and RPM package. Additionally, recipes support executing a script (either defined in a file or directly in this api) in bash, sh, cmd, and powershell. Updating a software recipe If a recipe is assigned to an instance and there is a recipe with the same name but a lower version already installed and the assigned state of the recipe is `UPDATED`, then the recipe is updated to the new version. Script Working Directories Each script or execution step is run in its own temporary directory which is deleted after completing the step.
        :param Sequence['SoftwareRecipeArtifactResponse'] artifacts: Resources available to be used in the steps in the recipe.
        :param str desired_state: Default is INSTALLED. The desired state the agent should maintain for this recipe. INSTALLED: The software recipe is installed on the instance but won't be updated to new versions. UPDATED: The software recipe is installed on the instance. The recipe is updated to a higher version, if a higher version of the recipe is assigned to this instance. REMOVE: Remove is unsupported for software recipes and attempts to create or update a recipe to the REMOVE state is rejected.
        :param Sequence['SoftwareRecipeStepResponse'] install_steps: Actions to be taken for installing this recipe. On failure it stops executing steps and does not attempt another installation. Any steps taken (including partially completed steps) are not rolled back.
        :param str name: Required. Unique identifier for the recipe. Only one recipe with a given name is installed on an instance. Names are also used to identify resources which helps to determine whether guest policies have conflicts. This means that requests to create multiple recipes with the same name and version are rejected since they could potentially have conflicting assignments.
        :param Sequence['SoftwareRecipeStepResponse'] update_steps: Actions to be taken for updating this recipe. On failure it stops executing steps and does not attempt another update for this recipe. Any steps taken (including partially completed steps) are not rolled back.
        :param str version: The version of this software recipe. Version can be up to 4 period separated numbers (e.g. 12.34.56.78).
        """
        pulumi.set(__self__, "artifacts", artifacts)
        pulumi.set(__self__, "desired_state", desired_state)
        pulumi.set(__self__, "install_steps", install_steps)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "update_steps", update_steps)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def artifacts(self) -> Sequence['outputs.SoftwareRecipeArtifactResponse']:
        """
        Resources available to be used in the steps in the recipe.
        """
        return pulumi.get(self, "artifacts")

    @property
    @pulumi.getter(name="desiredState")
    def desired_state(self) -> str:
        """
        Default is INSTALLED. The desired state the agent should maintain for this recipe. INSTALLED: The software recipe is installed on the instance but won't be updated to new versions. UPDATED: The software recipe is installed on the instance. The recipe is updated to a higher version, if a higher version of the recipe is assigned to this instance. REMOVE: Remove is unsupported for software recipes and attempts to create or update a recipe to the REMOVE state is rejected.
        """
        return pulumi.get(self, "desired_state")

    @property
    @pulumi.getter(name="installSteps")
    def install_steps(self) -> Sequence['outputs.SoftwareRecipeStepResponse']:
        """
        Actions to be taken for installing this recipe. On failure it stops executing steps and does not attempt another installation. Any steps taken (including partially completed steps) are not rolled back.
        """
        return pulumi.get(self, "install_steps")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Required. Unique identifier for the recipe. Only one recipe with a given name is installed on an instance. Names are also used to identify resources which helps to determine whether guest policies have conflicts. This means that requests to create multiple recipes with the same name and version are rejected since they could potentially have conflicting assignments.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="updateSteps")
    def update_steps(self) -> Sequence['outputs.SoftwareRecipeStepResponse']:
        """
        Actions to be taken for updating this recipe. On failure it stops executing steps and does not attempt another update for this recipe. Any steps taken (including partially completed steps) are not rolled back.
        """
        return pulumi.get(self, "update_steps")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The version of this software recipe. Version can be up to 4 period separated numbers (e.g. 12.34.56.78).
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class SoftwareRecipeStepCopyFileResponse(dict):
    """
    Copies the artifact to the specified path on the instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "artifactId":
            suggest = "artifact_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SoftwareRecipeStepCopyFileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SoftwareRecipeStepCopyFileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SoftwareRecipeStepCopyFileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 artifact_id: str,
                 destination: str,
                 overwrite: bool,
                 permissions: str):
        """
        Copies the artifact to the specified path on the instance.
        :param str artifact_id: Required. The id of the relevant artifact in the recipe.
        :param str destination: Required. The absolute path on the instance to put the file.
        :param bool overwrite: Whether to allow this step to overwrite existing files. If this is false and the file already exists the file is not overwritten and the step is considered a success. Defaults to false.
        :param str permissions: Consists of three octal digits which represent, in order, the permissions of the owner, group, and other users for the file (similarly to the numeric mode used in the linux chmod utility). Each digit represents a three bit number with the 4 bit corresponding to the read permissions, the 2 bit corresponds to the write bit, and the one bit corresponds to the execute permission. Default behavior is 755. Below are some examples of permissions and their associated values: read, write, and execute: 7 read and execute: 5 read and write: 6 read only: 4
        """
        pulumi.set(__self__, "artifact_id", artifact_id)
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "overwrite", overwrite)
        pulumi.set(__self__, "permissions", permissions)

    @property
    @pulumi.getter(name="artifactId")
    def artifact_id(self) -> str:
        """
        Required. The id of the relevant artifact in the recipe.
        """
        return pulumi.get(self, "artifact_id")

    @property
    @pulumi.getter
    def destination(self) -> str:
        """
        Required. The absolute path on the instance to put the file.
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter
    def overwrite(self) -> bool:
        """
        Whether to allow this step to overwrite existing files. If this is false and the file already exists the file is not overwritten and the step is considered a success. Defaults to false.
        """
        return pulumi.get(self, "overwrite")

    @property
    @pulumi.getter
    def permissions(self) -> str:
        """
        Consists of three octal digits which represent, in order, the permissions of the owner, group, and other users for the file (similarly to the numeric mode used in the linux chmod utility). Each digit represents a three bit number with the 4 bit corresponding to the read permissions, the 2 bit corresponds to the write bit, and the one bit corresponds to the execute permission. Default behavior is 755. Below are some examples of permissions and their associated values: read, write, and execute: 7 read and execute: 5 read and write: 6 read only: 4
        """
        return pulumi.get(self, "permissions")


@pulumi.output_type
class SoftwareRecipeStepExecFileResponse(dict):
    """
    Executes an artifact or local file.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedExitCodes":
            suggest = "allowed_exit_codes"
        elif key == "artifactId":
            suggest = "artifact_id"
        elif key == "localPath":
            suggest = "local_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SoftwareRecipeStepExecFileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SoftwareRecipeStepExecFileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SoftwareRecipeStepExecFileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_exit_codes: Sequence[int],
                 args: Sequence[str],
                 artifact_id: str,
                 local_path: str):
        """
        Executes an artifact or local file.
        :param Sequence[int] allowed_exit_codes: Defaults to [0]. A list of possible return values that the program can return to indicate a success.
        :param Sequence[str] args: Arguments to be passed to the provided executable.
        :param str artifact_id: The id of the relevant artifact in the recipe.
        :param str local_path: The absolute path of the file on the local filesystem.
        """
        pulumi.set(__self__, "allowed_exit_codes", allowed_exit_codes)
        pulumi.set(__self__, "args", args)
        pulumi.set(__self__, "artifact_id", artifact_id)
        pulumi.set(__self__, "local_path", local_path)

    @property
    @pulumi.getter(name="allowedExitCodes")
    def allowed_exit_codes(self) -> Sequence[int]:
        """
        Defaults to [0]. A list of possible return values that the program can return to indicate a success.
        """
        return pulumi.get(self, "allowed_exit_codes")

    @property
    @pulumi.getter
    def args(self) -> Sequence[str]:
        """
        Arguments to be passed to the provided executable.
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter(name="artifactId")
    def artifact_id(self) -> str:
        """
        The id of the relevant artifact in the recipe.
        """
        return pulumi.get(self, "artifact_id")

    @property
    @pulumi.getter(name="localPath")
    def local_path(self) -> str:
        """
        The absolute path of the file on the local filesystem.
        """
        return pulumi.get(self, "local_path")


@pulumi.output_type
class SoftwareRecipeStepExtractArchiveResponse(dict):
    """
    Extracts an archive of the type specified in the specified directory.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "artifactId":
            suggest = "artifact_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SoftwareRecipeStepExtractArchiveResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SoftwareRecipeStepExtractArchiveResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SoftwareRecipeStepExtractArchiveResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 artifact_id: str,
                 destination: str,
                 type: str):
        """
        Extracts an archive of the type specified in the specified directory.
        :param str artifact_id: Required. The id of the relevant artifact in the recipe.
        :param str destination: Directory to extract archive to. Defaults to `/` on Linux or `C:\` on Windows.
        :param str type: Required. The type of the archive to extract.
        """
        pulumi.set(__self__, "artifact_id", artifact_id)
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="artifactId")
    def artifact_id(self) -> str:
        """
        Required. The id of the relevant artifact in the recipe.
        """
        return pulumi.get(self, "artifact_id")

    @property
    @pulumi.getter
    def destination(self) -> str:
        """
        Directory to extract archive to. Defaults to `/` on Linux or `C:\` on Windows.
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Required. The type of the archive to extract.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class SoftwareRecipeStepInstallDpkgResponse(dict):
    """
    Installs a deb via dpkg.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "artifactId":
            suggest = "artifact_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SoftwareRecipeStepInstallDpkgResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SoftwareRecipeStepInstallDpkgResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SoftwareRecipeStepInstallDpkgResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 artifact_id: str):
        """
        Installs a deb via dpkg.
        :param str artifact_id: Required. The id of the relevant artifact in the recipe.
        """
        pulumi.set(__self__, "artifact_id", artifact_id)

    @property
    @pulumi.getter(name="artifactId")
    def artifact_id(self) -> str:
        """
        Required. The id of the relevant artifact in the recipe.
        """
        return pulumi.get(self, "artifact_id")


@pulumi.output_type
class SoftwareRecipeStepInstallMsiResponse(dict):
    """
    Installs an MSI file.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedExitCodes":
            suggest = "allowed_exit_codes"
        elif key == "artifactId":
            suggest = "artifact_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SoftwareRecipeStepInstallMsiResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SoftwareRecipeStepInstallMsiResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SoftwareRecipeStepInstallMsiResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_exit_codes: Sequence[int],
                 artifact_id: str,
                 flags: Sequence[str]):
        """
        Installs an MSI file.
        :param Sequence[int] allowed_exit_codes: Return codes that indicate that the software installed or updated successfully. Behaviour defaults to [0]
        :param str artifact_id: Required. The id of the relevant artifact in the recipe.
        :param Sequence[str] flags: The flags to use when installing the MSI defaults to ["/i"] (i.e. the install flag).
        """
        pulumi.set(__self__, "allowed_exit_codes", allowed_exit_codes)
        pulumi.set(__self__, "artifact_id", artifact_id)
        pulumi.set(__self__, "flags", flags)

    @property
    @pulumi.getter(name="allowedExitCodes")
    def allowed_exit_codes(self) -> Sequence[int]:
        """
        Return codes that indicate that the software installed or updated successfully. Behaviour defaults to [0]
        """
        return pulumi.get(self, "allowed_exit_codes")

    @property
    @pulumi.getter(name="artifactId")
    def artifact_id(self) -> str:
        """
        Required. The id of the relevant artifact in the recipe.
        """
        return pulumi.get(self, "artifact_id")

    @property
    @pulumi.getter
    def flags(self) -> Sequence[str]:
        """
        The flags to use when installing the MSI defaults to ["/i"] (i.e. the install flag).
        """
        return pulumi.get(self, "flags")


@pulumi.output_type
class SoftwareRecipeStepInstallRpmResponse(dict):
    """
    Installs an rpm file via the rpm utility.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "artifactId":
            suggest = "artifact_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SoftwareRecipeStepInstallRpmResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SoftwareRecipeStepInstallRpmResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SoftwareRecipeStepInstallRpmResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 artifact_id: str):
        """
        Installs an rpm file via the rpm utility.
        :param str artifact_id: Required. The id of the relevant artifact in the recipe.
        """
        pulumi.set(__self__, "artifact_id", artifact_id)

    @property
    @pulumi.getter(name="artifactId")
    def artifact_id(self) -> str:
        """
        Required. The id of the relevant artifact in the recipe.
        """
        return pulumi.get(self, "artifact_id")


@pulumi.output_type
class SoftwareRecipeStepResponse(dict):
    """
    An action that can be taken as part of installing or updating a recipe.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "archiveExtraction":
            suggest = "archive_extraction"
        elif key == "dpkgInstallation":
            suggest = "dpkg_installation"
        elif key == "fileCopy":
            suggest = "file_copy"
        elif key == "fileExec":
            suggest = "file_exec"
        elif key == "msiInstallation":
            suggest = "msi_installation"
        elif key == "rpmInstallation":
            suggest = "rpm_installation"
        elif key == "scriptRun":
            suggest = "script_run"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SoftwareRecipeStepResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SoftwareRecipeStepResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SoftwareRecipeStepResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 archive_extraction: 'outputs.SoftwareRecipeStepExtractArchiveResponse',
                 dpkg_installation: 'outputs.SoftwareRecipeStepInstallDpkgResponse',
                 file_copy: 'outputs.SoftwareRecipeStepCopyFileResponse',
                 file_exec: 'outputs.SoftwareRecipeStepExecFileResponse',
                 msi_installation: 'outputs.SoftwareRecipeStepInstallMsiResponse',
                 rpm_installation: 'outputs.SoftwareRecipeStepInstallRpmResponse',
                 script_run: 'outputs.SoftwareRecipeStepRunScriptResponse'):
        """
        An action that can be taken as part of installing or updating a recipe.
        :param 'SoftwareRecipeStepExtractArchiveResponse' archive_extraction: Extracts an archive into the specified directory.
        :param 'SoftwareRecipeStepInstallDpkgResponse' dpkg_installation: Installs a deb file via dpkg.
        :param 'SoftwareRecipeStepCopyFileResponse' file_copy: Copies a file onto the instance.
        :param 'SoftwareRecipeStepExecFileResponse' file_exec: Executes an artifact or local file.
        :param 'SoftwareRecipeStepInstallMsiResponse' msi_installation: Installs an MSI file.
        :param 'SoftwareRecipeStepInstallRpmResponse' rpm_installation: Installs an rpm file via the rpm utility.
        :param 'SoftwareRecipeStepRunScriptResponse' script_run: Runs commands in a shell.
        """
        pulumi.set(__self__, "archive_extraction", archive_extraction)
        pulumi.set(__self__, "dpkg_installation", dpkg_installation)
        pulumi.set(__self__, "file_copy", file_copy)
        pulumi.set(__self__, "file_exec", file_exec)
        pulumi.set(__self__, "msi_installation", msi_installation)
        pulumi.set(__self__, "rpm_installation", rpm_installation)
        pulumi.set(__self__, "script_run", script_run)

    @property
    @pulumi.getter(name="archiveExtraction")
    def archive_extraction(self) -> 'outputs.SoftwareRecipeStepExtractArchiveResponse':
        """
        Extracts an archive into the specified directory.
        """
        return pulumi.get(self, "archive_extraction")

    @property
    @pulumi.getter(name="dpkgInstallation")
    def dpkg_installation(self) -> 'outputs.SoftwareRecipeStepInstallDpkgResponse':
        """
        Installs a deb file via dpkg.
        """
        return pulumi.get(self, "dpkg_installation")

    @property
    @pulumi.getter(name="fileCopy")
    def file_copy(self) -> 'outputs.SoftwareRecipeStepCopyFileResponse':
        """
        Copies a file onto the instance.
        """
        return pulumi.get(self, "file_copy")

    @property
    @pulumi.getter(name="fileExec")
    def file_exec(self) -> 'outputs.SoftwareRecipeStepExecFileResponse':
        """
        Executes an artifact or local file.
        """
        return pulumi.get(self, "file_exec")

    @property
    @pulumi.getter(name="msiInstallation")
    def msi_installation(self) -> 'outputs.SoftwareRecipeStepInstallMsiResponse':
        """
        Installs an MSI file.
        """
        return pulumi.get(self, "msi_installation")

    @property
    @pulumi.getter(name="rpmInstallation")
    def rpm_installation(self) -> 'outputs.SoftwareRecipeStepInstallRpmResponse':
        """
        Installs an rpm file via the rpm utility.
        """
        return pulumi.get(self, "rpm_installation")

    @property
    @pulumi.getter(name="scriptRun")
    def script_run(self) -> 'outputs.SoftwareRecipeStepRunScriptResponse':
        """
        Runs commands in a shell.
        """
        return pulumi.get(self, "script_run")


@pulumi.output_type
class SoftwareRecipeStepRunScriptResponse(dict):
    """
    Runs a script through an interpreter.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedExitCodes":
            suggest = "allowed_exit_codes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SoftwareRecipeStepRunScriptResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SoftwareRecipeStepRunScriptResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SoftwareRecipeStepRunScriptResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_exit_codes: Sequence[int],
                 interpreter: str,
                 script: str):
        """
        Runs a script through an interpreter.
        :param Sequence[int] allowed_exit_codes: Return codes that indicate that the software installed or updated successfully. Behaviour defaults to [0]
        :param str interpreter: The script interpreter to use to run the script. If no interpreter is specified the script is executed directly, which likely only succeed for scripts with [shebang lines](https://en.wikipedia.org/wiki/Shebang_\(Unix\)).
        :param str script: Required. The shell script to be executed.
        """
        pulumi.set(__self__, "allowed_exit_codes", allowed_exit_codes)
        pulumi.set(__self__, "interpreter", interpreter)
        pulumi.set(__self__, "script", script)

    @property
    @pulumi.getter(name="allowedExitCodes")
    def allowed_exit_codes(self) -> Sequence[int]:
        """
        Return codes that indicate that the software installed or updated successfully. Behaviour defaults to [0]
        """
        return pulumi.get(self, "allowed_exit_codes")

    @property
    @pulumi.getter
    def interpreter(self) -> str:
        """
        The script interpreter to use to run the script. If no interpreter is specified the script is executed directly, which likely only succeed for scripts with [shebang lines](https://en.wikipedia.org/wiki/Shebang_\(Unix\)).
        """
        return pulumi.get(self, "interpreter")

    @property
    @pulumi.getter
    def script(self) -> str:
        """
        Required. The shell script to be executed.
        """
        return pulumi.get(self, "script")


@pulumi.output_type
class TimeOfDayResponse(dict):
    """
    Represents a time of day. The date and time zone are either not significant or are specified elsewhere. An API may choose to allow leap seconds. Related types are google.type.Date and `google.protobuf.Timestamp`.
    """
    def __init__(__self__, *,
                 hours: int,
                 minutes: int,
                 nanos: int,
                 seconds: int):
        """
        Represents a time of day. The date and time zone are either not significant or are specified elsewhere. An API may choose to allow leap seconds. Related types are google.type.Date and `google.protobuf.Timestamp`.
        :param int hours: Hours of day in 24 hour format. Should be from 0 to 23. An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        :param int minutes: Minutes of hour of day. Must be from 0 to 59.
        :param int nanos: Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        :param int seconds: Seconds of minutes of the time. Must normally be from 0 to 59. An API may allow the value 60 if it allows leap-seconds.
        """
        pulumi.set(__self__, "hours", hours)
        pulumi.set(__self__, "minutes", minutes)
        pulumi.set(__self__, "nanos", nanos)
        pulumi.set(__self__, "seconds", seconds)

    @property
    @pulumi.getter
    def hours(self) -> int:
        """
        Hours of day in 24 hour format. Should be from 0 to 23. An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        """
        return pulumi.get(self, "hours")

    @property
    @pulumi.getter
    def minutes(self) -> int:
        """
        Minutes of hour of day. Must be from 0 to 59.
        """
        return pulumi.get(self, "minutes")

    @property
    @pulumi.getter
    def nanos(self) -> int:
        """
        Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        """
        return pulumi.get(self, "nanos")

    @property
    @pulumi.getter
    def seconds(self) -> int:
        """
        Seconds of minutes of the time. Must normally be from 0 to 59. An API may allow the value 60 if it allows leap-seconds.
        """
        return pulumi.get(self, "seconds")


@pulumi.output_type
class TimeZoneResponse(dict):
    """
    Represents a time zone from the [IANA Time Zone Database](https://www.iana.org/time-zones).
    """
    def __init__(__self__, *,
                 version: str):
        """
        Represents a time zone from the [IANA Time Zone Database](https://www.iana.org/time-zones).
        :param str version: Optional. IANA Time Zone Database version number, e.g. "2019a".
        """
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Optional. IANA Time Zone Database version number, e.g. "2019a".
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class WeekDayOfMonthResponse(dict):
    """
    Represents one week day in a month. An example is "the 4th Sunday".
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dayOfWeek":
            suggest = "day_of_week"
        elif key == "weekOrdinal":
            suggest = "week_ordinal"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WeekDayOfMonthResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WeekDayOfMonthResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WeekDayOfMonthResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 day_of_week: str,
                 week_ordinal: int):
        """
        Represents one week day in a month. An example is "the 4th Sunday".
        :param str day_of_week: Required. A day of the week.
        :param int week_ordinal: Required. Week number in a month. 1-4 indicates the 1st to 4th week of the month. -1 indicates the last week of the month.
        """
        pulumi.set(__self__, "day_of_week", day_of_week)
        pulumi.set(__self__, "week_ordinal", week_ordinal)

    @property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> str:
        """
        Required. A day of the week.
        """
        return pulumi.get(self, "day_of_week")

    @property
    @pulumi.getter(name="weekOrdinal")
    def week_ordinal(self) -> int:
        """
        Required. Week number in a month. 1-4 indicates the 1st to 4th week of the month. -1 indicates the last week of the month.
        """
        return pulumi.get(self, "week_ordinal")


@pulumi.output_type
class WeeklyScheduleResponse(dict):
    """
    Represents a weekly schedule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dayOfWeek":
            suggest = "day_of_week"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WeeklyScheduleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WeeklyScheduleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WeeklyScheduleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 day_of_week: str):
        """
        Represents a weekly schedule.
        :param str day_of_week: Required. Day of the week.
        """
        pulumi.set(__self__, "day_of_week", day_of_week)

    @property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> str:
        """
        Required. Day of the week.
        """
        return pulumi.get(self, "day_of_week")


@pulumi.output_type
class WindowsUpdateSettingsResponse(dict):
    """
    Windows patching is performed using the Windows Update Agent.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exclusivePatches":
            suggest = "exclusive_patches"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WindowsUpdateSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WindowsUpdateSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WindowsUpdateSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 classifications: Sequence[str],
                 excludes: Sequence[str],
                 exclusive_patches: Sequence[str]):
        """
        Windows patching is performed using the Windows Update Agent.
        :param Sequence[str] classifications: Only apply updates of these windows update classifications. If empty, all updates are applied.
        :param Sequence[str] excludes: List of KBs to exclude from update.
        :param Sequence[str] exclusive_patches: An exclusive list of kbs to be updated. These are the only patches that will be updated. This field must not be used with other patch configurations.
        """
        pulumi.set(__self__, "classifications", classifications)
        pulumi.set(__self__, "excludes", excludes)
        pulumi.set(__self__, "exclusive_patches", exclusive_patches)

    @property
    @pulumi.getter
    def classifications(self) -> Sequence[str]:
        """
        Only apply updates of these windows update classifications. If empty, all updates are applied.
        """
        return pulumi.get(self, "classifications")

    @property
    @pulumi.getter
    def excludes(self) -> Sequence[str]:
        """
        List of KBs to exclude from update.
        """
        return pulumi.get(self, "excludes")

    @property
    @pulumi.getter(name="exclusivePatches")
    def exclusive_patches(self) -> Sequence[str]:
        """
        An exclusive list of kbs to be updated. These are the only patches that will be updated. This field must not be used with other patch configurations.
        """
        return pulumi.get(self, "exclusive_patches")


@pulumi.output_type
class YumRepositoryResponse(dict):
    """
    Represents a single Yum package repository. This repository is added to a repo file that is stored at `/etc/yum.repos.d/google_osconfig.repo`.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseUrl":
            suggest = "base_url"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "gpgKeys":
            suggest = "gpg_keys"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in YumRepositoryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        YumRepositoryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        YumRepositoryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base_url: str,
                 display_name: str,
                 gpg_keys: Sequence[str]):
        """
        Represents a single Yum package repository. This repository is added to a repo file that is stored at `/etc/yum.repos.d/google_osconfig.repo`.
        :param str base_url: Required. The location of the repository directory.
        :param str display_name: The display name of the repository.
        :param Sequence[str] gpg_keys: URIs of GPG keys.
        """
        pulumi.set(__self__, "base_url", base_url)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "gpg_keys", gpg_keys)

    @property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> str:
        """
        Required. The location of the repository directory.
        """
        return pulumi.get(self, "base_url")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The display name of the repository.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="gpgKeys")
    def gpg_keys(self) -> Sequence[str]:
        """
        URIs of GPG keys.
        """
        return pulumi.get(self, "gpg_keys")


@pulumi.output_type
class YumSettingsResponse(dict):
    """
    Yum patching is performed by executing `yum update`. Additional options can be set to control how this is executed. Note that not all settings are supported on all platforms.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exclusivePackages":
            suggest = "exclusive_packages"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in YumSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        YumSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        YumSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 excludes: Sequence[str],
                 exclusive_packages: Sequence[str],
                 minimal: bool,
                 security: bool):
        """
        Yum patching is performed by executing `yum update`. Additional options can be set to control how this is executed. Note that not all settings are supported on all platforms.
        :param Sequence[str] excludes: List of packages to exclude from update. These packages are excluded by using the yum `--exclude` flag.
        :param Sequence[str] exclusive_packages: An exclusive list of packages to be updated. These are the only packages that will be updated. If these packages are not installed, they will be ignored. This field must not be specified with any other patch configuration fields.
        :param bool minimal: Will cause patch to run `yum update-minimal` instead.
        :param bool security: Adds the `--security` flag to `yum update`. Not supported on all platforms.
        """
        pulumi.set(__self__, "excludes", excludes)
        pulumi.set(__self__, "exclusive_packages", exclusive_packages)
        pulumi.set(__self__, "minimal", minimal)
        pulumi.set(__self__, "security", security)

    @property
    @pulumi.getter
    def excludes(self) -> Sequence[str]:
        """
        List of packages to exclude from update. These packages are excluded by using the yum `--exclude` flag.
        """
        return pulumi.get(self, "excludes")

    @property
    @pulumi.getter(name="exclusivePackages")
    def exclusive_packages(self) -> Sequence[str]:
        """
        An exclusive list of packages to be updated. These are the only packages that will be updated. If these packages are not installed, they will be ignored. This field must not be specified with any other patch configuration fields.
        """
        return pulumi.get(self, "exclusive_packages")

    @property
    @pulumi.getter
    def minimal(self) -> bool:
        """
        Will cause patch to run `yum update-minimal` instead.
        """
        return pulumi.get(self, "minimal")

    @property
    @pulumi.getter
    def security(self) -> bool:
        """
        Adds the `--security` flag to `yum update`. Not supported on all platforms.
        """
        return pulumi.get(self, "security")


@pulumi.output_type
class ZypperRepositoryResponse(dict):
    """
    Represents a single Zypper package repository. This repository is added to a repo file that is stored at `/etc/zypp/repos.d/google_osconfig.repo`.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseUrl":
            suggest = "base_url"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "gpgKeys":
            suggest = "gpg_keys"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ZypperRepositoryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ZypperRepositoryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ZypperRepositoryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base_url: str,
                 display_name: str,
                 gpg_keys: Sequence[str]):
        """
        Represents a single Zypper package repository. This repository is added to a repo file that is stored at `/etc/zypp/repos.d/google_osconfig.repo`.
        :param str base_url: Required. The location of the repository directory.
        :param str display_name: The display name of the repository.
        :param Sequence[str] gpg_keys: URIs of GPG keys.
        """
        pulumi.set(__self__, "base_url", base_url)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "gpg_keys", gpg_keys)

    @property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> str:
        """
        Required. The location of the repository directory.
        """
        return pulumi.get(self, "base_url")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The display name of the repository.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="gpgKeys")
    def gpg_keys(self) -> Sequence[str]:
        """
        URIs of GPG keys.
        """
        return pulumi.get(self, "gpg_keys")


@pulumi.output_type
class ZypperSettingsResponse(dict):
    """
    Zypper patching is performed by running `zypper patch`. See also https://en.opensuse.org/SDB:Zypper_manual.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exclusivePatches":
            suggest = "exclusive_patches"
        elif key == "withOptional":
            suggest = "with_optional"
        elif key == "withUpdate":
            suggest = "with_update"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ZypperSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ZypperSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ZypperSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 categories: Sequence[str],
                 excludes: Sequence[str],
                 exclusive_patches: Sequence[str],
                 severities: Sequence[str],
                 with_optional: bool,
                 with_update: bool):
        """
        Zypper patching is performed by running `zypper patch`. See also https://en.opensuse.org/SDB:Zypper_manual.
        :param Sequence[str] categories: Install only patches with these categories. Common categories include security, recommended, and feature.
        :param Sequence[str] excludes: List of patches to exclude from update.
        :param Sequence[str] exclusive_patches: An exclusive list of patches to be updated. These are the only patches that will be installed using 'zypper patch patch:' command. This field must not be used with any other patch configuration fields.
        :param Sequence[str] severities: Install only patches with these severities. Common severities include critical, important, moderate, and low.
        :param bool with_optional: Adds the `--with-optional` flag to `zypper patch`.
        :param bool with_update: Adds the `--with-update` flag, to `zypper patch`.
        """
        pulumi.set(__self__, "categories", categories)
        pulumi.set(__self__, "excludes", excludes)
        pulumi.set(__self__, "exclusive_patches", exclusive_patches)
        pulumi.set(__self__, "severities", severities)
        pulumi.set(__self__, "with_optional", with_optional)
        pulumi.set(__self__, "with_update", with_update)

    @property
    @pulumi.getter
    def categories(self) -> Sequence[str]:
        """
        Install only patches with these categories. Common categories include security, recommended, and feature.
        """
        return pulumi.get(self, "categories")

    @property
    @pulumi.getter
    def excludes(self) -> Sequence[str]:
        """
        List of patches to exclude from update.
        """
        return pulumi.get(self, "excludes")

    @property
    @pulumi.getter(name="exclusivePatches")
    def exclusive_patches(self) -> Sequence[str]:
        """
        An exclusive list of patches to be updated. These are the only patches that will be installed using 'zypper patch patch:' command. This field must not be used with any other patch configuration fields.
        """
        return pulumi.get(self, "exclusive_patches")

    @property
    @pulumi.getter
    def severities(self) -> Sequence[str]:
        """
        Install only patches with these severities. Common severities include critical, important, moderate, and low.
        """
        return pulumi.get(self, "severities")

    @property
    @pulumi.getter(name="withOptional")
    def with_optional(self) -> bool:
        """
        Adds the `--with-optional` flag to `zypper patch`.
        """
        return pulumi.get(self, "with_optional")

    @property
    @pulumi.getter(name="withUpdate")
    def with_update(self) -> bool:
        """
        Adds the `--with-update` flag, to `zypper patch`.
        """
        return pulumi.get(self, "with_update")


