# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = [
    'AuditConfigArgs',
    'AuditLogConfigArgs',
    'AuthorizationLoggingOptionsArgs',
    'BindingArgs',
    'CloudAuditOptionsArgs',
    'ConditionArgs',
    'CounterOptionsArgs',
    'CustomFieldArgs',
    'DataAccessOptionsArgs',
    'ExprArgs',
    'FleetConfigArgs',
    'GameServerClusterConnectionInfoArgs',
    'GkeClusterReferenceArgs',
    'LabelSelectorArgs',
    'LogConfigArgs',
    'RuleArgs',
    'ScalingConfigArgs',
    'ScheduleArgs',
]

@pulumi.input_type
class AuditConfigArgs:
    def __init__(__self__, *,
                 audit_log_configs: Optional[pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]]] = None,
                 exempted_members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 service: Optional[pulumi.Input[str]] = None):
        """
        Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts jose@example.com from DATA_READ logging, and aliya@example.com from DATA_WRITE logging.
        :param pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]] audit_log_configs: The configuration for logging of each type of permission.
        :param pulumi.Input[str] service: Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        if audit_log_configs is not None:
            pulumi.set(__self__, "audit_log_configs", audit_log_configs)
        if exempted_members is not None:
            pulumi.set(__self__, "exempted_members", exempted_members)
        if service is not None:
            pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter(name="auditLogConfigs")
    def audit_log_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]]]:
        """
        The configuration for logging of each type of permission.
        """
        return pulumi.get(self, "audit_log_configs")

    @audit_log_configs.setter
    def audit_log_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]]]):
        pulumi.set(self, "audit_log_configs", value)

    @property
    @pulumi.getter(name="exemptedMembers")
    def exempted_members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "exempted_members")

    @exempted_members.setter
    def exempted_members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "exempted_members", value)

    @property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service", value)


@pulumi.input_type
class AuditLogConfigArgs:
    def __init__(__self__, *,
                 exempted_members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ignore_child_exemptions: Optional[pulumi.Input[bool]] = None,
                 log_type: Optional[pulumi.Input[str]] = None):
        """
        Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] exempted_members: Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        :param pulumi.Input[str] log_type: The log type that this config enables.
        """
        if exempted_members is not None:
            pulumi.set(__self__, "exempted_members", exempted_members)
        if ignore_child_exemptions is not None:
            pulumi.set(__self__, "ignore_child_exemptions", ignore_child_exemptions)
        if log_type is not None:
            pulumi.set(__self__, "log_type", log_type)

    @property
    @pulumi.getter(name="exemptedMembers")
    def exempted_members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        """
        return pulumi.get(self, "exempted_members")

    @exempted_members.setter
    def exempted_members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "exempted_members", value)

    @property
    @pulumi.getter(name="ignoreChildExemptions")
    def ignore_child_exemptions(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "ignore_child_exemptions")

    @ignore_child_exemptions.setter
    def ignore_child_exemptions(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ignore_child_exemptions", value)

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> Optional[pulumi.Input[str]]:
        """
        The log type that this config enables.
        """
        return pulumi.get(self, "log_type")

    @log_type.setter
    def log_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_type", value)


@pulumi.input_type
class AuthorizationLoggingOptionsArgs:
    def __init__(__self__, *,
                 permission_type: Optional[pulumi.Input[str]] = None):
        """
        Authorization-related information used by Cloud Audit Logging.
        :param pulumi.Input[str] permission_type: The type of the permission that was checked.
        """
        if permission_type is not None:
            pulumi.set(__self__, "permission_type", permission_type)

    @property
    @pulumi.getter(name="permissionType")
    def permission_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the permission that was checked.
        """
        return pulumi.get(self, "permission_type")

    @permission_type.setter
    def permission_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "permission_type", value)


@pulumi.input_type
class BindingArgs:
    def __init__(__self__, *,
                 binding_id: Optional[pulumi.Input[str]] = None,
                 condition: Optional[pulumi.Input['ExprArgs']] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 role: Optional[pulumi.Input[str]] = None):
        """
        Associates `members` with a `role`.
        :param pulumi.Input['ExprArgs'] condition: The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the members in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] members: Specifies the identities requesting access for a Cloud Platform resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        :param pulumi.Input[str] role: Role that is assigned to `members`. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        if binding_id is not None:
            pulumi.set(__self__, "binding_id", binding_id)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter(name="bindingId")
    def binding_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "binding_id")

    @binding_id.setter
    def binding_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "binding_id", value)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input['ExprArgs']]:
        """
        The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the members in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input['ExprArgs']]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the identities requesting access for a Cloud Platform resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "members", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        Role that is assigned to `members`. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)


@pulumi.input_type
class CloudAuditOptionsArgs:
    def __init__(__self__, *,
                 authorization_logging_options: Optional[pulumi.Input['AuthorizationLoggingOptionsArgs']] = None,
                 log_name: Optional[pulumi.Input[str]] = None):
        """
        Write a Cloud Audit log
        :param pulumi.Input['AuthorizationLoggingOptionsArgs'] authorization_logging_options: Information used by the Cloud Audit Logging pipeline.
        :param pulumi.Input[str] log_name: The log_name to populate in the Cloud Audit Record.
        """
        if authorization_logging_options is not None:
            pulumi.set(__self__, "authorization_logging_options", authorization_logging_options)
        if log_name is not None:
            pulumi.set(__self__, "log_name", log_name)

    @property
    @pulumi.getter(name="authorizationLoggingOptions")
    def authorization_logging_options(self) -> Optional[pulumi.Input['AuthorizationLoggingOptionsArgs']]:
        """
        Information used by the Cloud Audit Logging pipeline.
        """
        return pulumi.get(self, "authorization_logging_options")

    @authorization_logging_options.setter
    def authorization_logging_options(self, value: Optional[pulumi.Input['AuthorizationLoggingOptionsArgs']]):
        pulumi.set(self, "authorization_logging_options", value)

    @property
    @pulumi.getter(name="logName")
    def log_name(self) -> Optional[pulumi.Input[str]]:
        """
        The log_name to populate in the Cloud Audit Record.
        """
        return pulumi.get(self, "log_name")

    @log_name.setter
    def log_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_name", value)


@pulumi.input_type
class ConditionArgs:
    def __init__(__self__, *,
                 iam: Optional[pulumi.Input[str]] = None,
                 op: Optional[pulumi.Input[str]] = None,
                 svc: Optional[pulumi.Input[str]] = None,
                 sys: Optional[pulumi.Input[str]] = None,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        A condition to be met.
        :param pulumi.Input[str] iam: Trusted attributes supplied by the IAM system.
        :param pulumi.Input[str] op: An operator to apply the subject with.
        :param pulumi.Input[str] svc: Trusted attributes discharged by the service.
        :param pulumi.Input[str] sys: Trusted attributes supplied by any service that owns resources and uses the IAM system for access control.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] values: The objects of the condition.
        """
        if iam is not None:
            pulumi.set(__self__, "iam", iam)
        if op is not None:
            pulumi.set(__self__, "op", op)
        if svc is not None:
            pulumi.set(__self__, "svc", svc)
        if sys is not None:
            pulumi.set(__self__, "sys", sys)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def iam(self) -> Optional[pulumi.Input[str]]:
        """
        Trusted attributes supplied by the IAM system.
        """
        return pulumi.get(self, "iam")

    @iam.setter
    def iam(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "iam", value)

    @property
    @pulumi.getter
    def op(self) -> Optional[pulumi.Input[str]]:
        """
        An operator to apply the subject with.
        """
        return pulumi.get(self, "op")

    @op.setter
    def op(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "op", value)

    @property
    @pulumi.getter
    def svc(self) -> Optional[pulumi.Input[str]]:
        """
        Trusted attributes discharged by the service.
        """
        return pulumi.get(self, "svc")

    @svc.setter
    def svc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "svc", value)

    @property
    @pulumi.getter
    def sys(self) -> Optional[pulumi.Input[str]]:
        """
        Trusted attributes supplied by any service that owns resources and uses the IAM system for access control.
        """
        return pulumi.get(self, "sys")

    @sys.setter
    def sys(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sys", value)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The objects of the condition.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class CounterOptionsArgs:
    def __init__(__self__, *,
                 custom_fields: Optional[pulumi.Input[Sequence[pulumi.Input['CustomFieldArgs']]]] = None,
                 field: Optional[pulumi.Input[str]] = None,
                 metric: Optional[pulumi.Input[str]] = None):
        """
        Increment a streamz counter with the specified metric and field names. Metric names should start with a '/', generally be lowercase-only, and end in "_count". Field names should not contain an initial slash. The actual exported metric names will have "/iam/policy" prepended. Field names correspond to IAM request parameters and field values are their respective values. Supported field names: - "authority", which is "[token]" if IAMContext.token is present, otherwise the value of IAMContext.authority_selector if present, and otherwise a representation of IAMContext.principal; or - "iam_principal", a representation of IAMContext.principal even if a token or authority selector is present; or - "" (empty string), resulting in a counter with no fields. Examples: counter { metric: "/debug_access_count" field: "iam_principal" } ==> increment counter /iam/policy/debug_access_count {iam_principal=[value of IAMContext.principal]}
        :param pulumi.Input[Sequence[pulumi.Input['CustomFieldArgs']]] custom_fields: Custom fields.
        :param pulumi.Input[str] field: The field value to attribute.
        :param pulumi.Input[str] metric: The metric to update.
        """
        if custom_fields is not None:
            pulumi.set(__self__, "custom_fields", custom_fields)
        if field is not None:
            pulumi.set(__self__, "field", field)
        if metric is not None:
            pulumi.set(__self__, "metric", metric)

    @property
    @pulumi.getter(name="customFields")
    def custom_fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CustomFieldArgs']]]]:
        """
        Custom fields.
        """
        return pulumi.get(self, "custom_fields")

    @custom_fields.setter
    def custom_fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CustomFieldArgs']]]]):
        pulumi.set(self, "custom_fields", value)

    @property
    @pulumi.getter
    def field(self) -> Optional[pulumi.Input[str]]:
        """
        The field value to attribute.
        """
        return pulumi.get(self, "field")

    @field.setter
    def field(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "field", value)

    @property
    @pulumi.getter
    def metric(self) -> Optional[pulumi.Input[str]]:
        """
        The metric to update.
        """
        return pulumi.get(self, "metric")

    @metric.setter
    def metric(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metric", value)


@pulumi.input_type
class CustomFieldArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        Custom fields. These can be used to create a counter with arbitrary field/value pairs. See: go/rpcsp-custom-fields.
        :param pulumi.Input[str] name: Name is the field name.
        :param pulumi.Input[str] value: Value is the field value. It is important that in contrast to the CounterOptions.field, the value here is a constant that is not derived from the IAMContext.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name is the field name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Value is the field value. It is important that in contrast to the CounterOptions.field, the value here is a constant that is not derived from the IAMContext.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class DataAccessOptionsArgs:
    def __init__(__self__, *,
                 log_mode: Optional[pulumi.Input[str]] = None):
        """
        Write a Data Access (Gin) log
        """
        if log_mode is not None:
            pulumi.set(__self__, "log_mode", log_mode)

    @property
    @pulumi.getter(name="logMode")
    def log_mode(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "log_mode")

    @log_mode.setter
    def log_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_mode", value)


@pulumi.input_type
class ExprArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 expression: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param pulumi.Input[str] description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param pulumi.Input[str] expression: Textual representation of an expression in Common Expression Language syntax.
        :param pulumi.Input[str] location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param pulumi.Input[str] title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def expression(self) -> Optional[pulumi.Input[str]]:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class FleetConfigArgs:
    def __init__(__self__, *,
                 fleet_spec: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Fleet configs for Agones.
        :param pulumi.Input[str] fleet_spec: Agones fleet spec. Example spec: `https://agones.dev/site/docs/reference/fleet/`.
        :param pulumi.Input[str] name: The name of the FleetConfig.
        """
        if fleet_spec is not None:
            pulumi.set(__self__, "fleet_spec", fleet_spec)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="fleetSpec")
    def fleet_spec(self) -> Optional[pulumi.Input[str]]:
        """
        Agones fleet spec. Example spec: `https://agones.dev/site/docs/reference/fleet/`.
        """
        return pulumi.get(self, "fleet_spec")

    @fleet_spec.setter
    def fleet_spec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fleet_spec", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the FleetConfig.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class GameServerClusterConnectionInfoArgs:
    def __init__(__self__, *,
                 gke_cluster_reference: Optional[pulumi.Input['GkeClusterReferenceArgs']] = None,
                 namespace: Optional[pulumi.Input[str]] = None):
        """
        The game server cluster connection information.
        :param pulumi.Input['GkeClusterReferenceArgs'] gke_cluster_reference: Reference to the GKE cluster where the game servers are installed.
        :param pulumi.Input[str] namespace: Namespace designated on the game server cluster where the Agones game server instances will be created. Existence of the namespace will be validated during creation.
        """
        if gke_cluster_reference is not None:
            pulumi.set(__self__, "gke_cluster_reference", gke_cluster_reference)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter(name="gkeClusterReference")
    def gke_cluster_reference(self) -> Optional[pulumi.Input['GkeClusterReferenceArgs']]:
        """
        Reference to the GKE cluster where the game servers are installed.
        """
        return pulumi.get(self, "gke_cluster_reference")

    @gke_cluster_reference.setter
    def gke_cluster_reference(self, value: Optional[pulumi.Input['GkeClusterReferenceArgs']]):
        pulumi.set(self, "gke_cluster_reference", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        Namespace designated on the game server cluster where the Agones game server instances will be created. Existence of the namespace will be validated during creation.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)


@pulumi.input_type
class GkeClusterReferenceArgs:
    def __init__(__self__, *,
                 cluster: Optional[pulumi.Input[str]] = None):
        """
        A reference to a GKE cluster.
        :param pulumi.Input[str] cluster: The full or partial name of a GKE cluster, using one of the following forms: * `projects/{project}/locations/{location}/clusters/{cluster}` * `locations/{location}/clusters/{cluster}` * `{cluster}` If project and location are not specified, the project and location of the GameServerCluster resource are used to generate the full name of the GKE cluster.
        """
        if cluster is not None:
            pulumi.set(__self__, "cluster", cluster)

    @property
    @pulumi.getter
    def cluster(self) -> Optional[pulumi.Input[str]]:
        """
        The full or partial name of a GKE cluster, using one of the following forms: * `projects/{project}/locations/{location}/clusters/{cluster}` * `locations/{location}/clusters/{cluster}` * `{cluster}` If project and location are not specified, the project and location of the GameServerCluster resource are used to generate the full name of the GKE cluster.
        """
        return pulumi.get(self, "cluster")

    @cluster.setter
    def cluster(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster", value)


@pulumi.input_type
class LabelSelectorArgs:
    def __init__(__self__, *,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The label selector, used to group labels on the resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Resource labels for this selector.
        """
        if labels is not None:
            pulumi.set(__self__, "labels", labels)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Resource labels for this selector.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)


@pulumi.input_type
class LogConfigArgs:
    def __init__(__self__, *,
                 cloud_audit: Optional[pulumi.Input['CloudAuditOptionsArgs']] = None,
                 counter: Optional[pulumi.Input['CounterOptionsArgs']] = None,
                 data_access: Optional[pulumi.Input['DataAccessOptionsArgs']] = None):
        """
        Specifies what kind of log the caller must write
        :param pulumi.Input['CloudAuditOptionsArgs'] cloud_audit: Cloud audit options.
        :param pulumi.Input['CounterOptionsArgs'] counter: Counter options.
        :param pulumi.Input['DataAccessOptionsArgs'] data_access: Data access options.
        """
        if cloud_audit is not None:
            pulumi.set(__self__, "cloud_audit", cloud_audit)
        if counter is not None:
            pulumi.set(__self__, "counter", counter)
        if data_access is not None:
            pulumi.set(__self__, "data_access", data_access)

    @property
    @pulumi.getter(name="cloudAudit")
    def cloud_audit(self) -> Optional[pulumi.Input['CloudAuditOptionsArgs']]:
        """
        Cloud audit options.
        """
        return pulumi.get(self, "cloud_audit")

    @cloud_audit.setter
    def cloud_audit(self, value: Optional[pulumi.Input['CloudAuditOptionsArgs']]):
        pulumi.set(self, "cloud_audit", value)

    @property
    @pulumi.getter
    def counter(self) -> Optional[pulumi.Input['CounterOptionsArgs']]:
        """
        Counter options.
        """
        return pulumi.get(self, "counter")

    @counter.setter
    def counter(self, value: Optional[pulumi.Input['CounterOptionsArgs']]):
        pulumi.set(self, "counter", value)

    @property
    @pulumi.getter(name="dataAccess")
    def data_access(self) -> Optional[pulumi.Input['DataAccessOptionsArgs']]:
        """
        Data access options.
        """
        return pulumi.get(self, "data_access")

    @data_access.setter
    def data_access(self, value: Optional[pulumi.Input['DataAccessOptionsArgs']]):
        pulumi.set(self, "data_access", value)


@pulumi.input_type
class RuleArgs:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[str]] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['ConditionArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 in_: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 log_config: Optional[pulumi.Input[Sequence[pulumi.Input['LogConfigArgs']]]] = None,
                 not_in: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        A rule to be applied in a Policy.
        :param pulumi.Input[str] action: Required
        :param pulumi.Input[Sequence[pulumi.Input['ConditionArgs']]] conditions: Additional restrictions that must be met. All conditions must pass for the rule to match.
        :param pulumi.Input[str] description: Human-readable description of the rule.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] in_: If one or more 'in' clauses are specified, the rule matches if the PRINCIPAL/AUTHORITY_SELECTOR is in at least one of these entries.
        :param pulumi.Input[Sequence[pulumi.Input['LogConfigArgs']]] log_config: The config returned to callers of tech.iam.IAM.CheckPolicy for any entries that match the LOG action.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] not_in: If one or more 'not_in' clauses are specified, the rule matches if the PRINCIPAL/AUTHORITY_SELECTOR is in none of the entries. The format for in and not_in entries can be found at in the Local IAM documentation (see go/local-iam#features).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] permissions: A permission is a string of form '..' (e.g., 'storage.buckets.list'). A value of '*' matches all permissions, and a verb part of '*' (e.g., 'storage.buckets.*') matches all verbs.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if in_ is not None:
            pulumi.set(__self__, "in_", in_)
        if log_config is not None:
            pulumi.set(__self__, "log_config", log_config)
        if not_in is not None:
            pulumi.set(__self__, "not_in", not_in)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[str]]:
        """
        Required
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConditionArgs']]]]:
        """
        Additional restrictions that must be met. All conditions must pass for the rule to match.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Human-readable description of the rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="in")
    def in_(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        If one or more 'in' clauses are specified, the rule matches if the PRINCIPAL/AUTHORITY_SELECTOR is in at least one of these entries.
        """
        return pulumi.get(self, "in_")

    @in_.setter
    def in_(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "in_", value)

    @property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LogConfigArgs']]]]:
        """
        The config returned to callers of tech.iam.IAM.CheckPolicy for any entries that match the LOG action.
        """
        return pulumi.get(self, "log_config")

    @log_config.setter
    def log_config(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LogConfigArgs']]]]):
        pulumi.set(self, "log_config", value)

    @property
    @pulumi.getter(name="notIn")
    def not_in(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        If one or more 'not_in' clauses are specified, the rule matches if the PRINCIPAL/AUTHORITY_SELECTOR is in none of the entries. The format for in and not_in entries can be found at in the Local IAM documentation (see go/local-iam#features).
        """
        return pulumi.get(self, "not_in")

    @not_in.setter
    def not_in(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "not_in", value)

    @property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A permission is a string of form '..' (e.g., 'storage.buckets.list'). A value of '*' matches all permissions, and a verb part of '*' (e.g., 'storage.buckets.*') matches all verbs.
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "permissions", value)


@pulumi.input_type
class ScalingConfigArgs:
    def __init__(__self__, *,
                 fleet_autoscaler_spec: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 schedules: Optional[pulumi.Input[Sequence[pulumi.Input['ScheduleArgs']]]] = None,
                 selectors: Optional[pulumi.Input[Sequence[pulumi.Input['LabelSelectorArgs']]]] = None):
        """
        Autoscaling config for an Agones fleet.
        :param pulumi.Input[str] fleet_autoscaler_spec: Required. Agones fleet autoscaler spec. Example spec: https://agones.dev/site/docs/reference/fleetautoscaler/
        :param pulumi.Input[str] name: Required. The name of the Scaling Config
        :param pulumi.Input[Sequence[pulumi.Input['ScheduleArgs']]] schedules: The schedules to which this Scaling Config applies.
        :param pulumi.Input[Sequence[pulumi.Input['LabelSelectorArgs']]] selectors: Labels used to identify the game server clusters to which this Agones scaling config applies. A game server cluster is subject to this Agones scaling config if its labels match any of the selector entries.
        """
        if fleet_autoscaler_spec is not None:
            pulumi.set(__self__, "fleet_autoscaler_spec", fleet_autoscaler_spec)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if schedules is not None:
            pulumi.set(__self__, "schedules", schedules)
        if selectors is not None:
            pulumi.set(__self__, "selectors", selectors)

    @property
    @pulumi.getter(name="fleetAutoscalerSpec")
    def fleet_autoscaler_spec(self) -> Optional[pulumi.Input[str]]:
        """
        Required. Agones fleet autoscaler spec. Example spec: https://agones.dev/site/docs/reference/fleetautoscaler/
        """
        return pulumi.get(self, "fleet_autoscaler_spec")

    @fleet_autoscaler_spec.setter
    def fleet_autoscaler_spec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fleet_autoscaler_spec", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The name of the Scaling Config
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def schedules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScheduleArgs']]]]:
        """
        The schedules to which this Scaling Config applies.
        """
        return pulumi.get(self, "schedules")

    @schedules.setter
    def schedules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScheduleArgs']]]]):
        pulumi.set(self, "schedules", value)

    @property
    @pulumi.getter
    def selectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LabelSelectorArgs']]]]:
        """
        Labels used to identify the game server clusters to which this Agones scaling config applies. A game server cluster is subject to this Agones scaling config if its labels match any of the selector entries.
        """
        return pulumi.get(self, "selectors")

    @selectors.setter
    def selectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LabelSelectorArgs']]]]):
        pulumi.set(self, "selectors", value)


@pulumi.input_type
class ScheduleArgs:
    def __init__(__self__, *,
                 cron_job_duration: Optional[pulumi.Input[str]] = None,
                 cron_spec: Optional[pulumi.Input[str]] = None,
                 end_time: Optional[pulumi.Input[str]] = None,
                 start_time: Optional[pulumi.Input[str]] = None):
        """
        The schedule of a recurring or one time event. The event's time span is specified by start_time and end_time. If the scheduled event's timespan is larger than the cron_spec + cron_job_duration, the event will be recurring. If only cron_spec + cron_job_duration are specified, the event is effective starting at the local time specified by cron_spec, and is recurring. start_time|-------[cron job]-------[cron job]-------[cron job]---|end_time cron job: cron spec start time + duration
        :param pulumi.Input[str] cron_job_duration: The duration for the cron job event. The duration of the event is effective after the cron job's start time.
        :param pulumi.Input[str] cron_spec: The cron definition of the scheduled event. See https://en.wikipedia.org/wiki/Cron. Cron spec specifies the local time as defined by the realm.
        :param pulumi.Input[str] end_time: The end time of the event.
        :param pulumi.Input[str] start_time: The start time of the event.
        """
        if cron_job_duration is not None:
            pulumi.set(__self__, "cron_job_duration", cron_job_duration)
        if cron_spec is not None:
            pulumi.set(__self__, "cron_spec", cron_spec)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="cronJobDuration")
    def cron_job_duration(self) -> Optional[pulumi.Input[str]]:
        """
        The duration for the cron job event. The duration of the event is effective after the cron job's start time.
        """
        return pulumi.get(self, "cron_job_duration")

    @cron_job_duration.setter
    def cron_job_duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cron_job_duration", value)

    @property
    @pulumi.getter(name="cronSpec")
    def cron_spec(self) -> Optional[pulumi.Input[str]]:
        """
        The cron definition of the scheduled event. See https://en.wikipedia.org/wiki/Cron. Cron spec specifies the local time as defined by the realm.
        """
        return pulumi.get(self, "cron_spec")

    @cron_spec.setter
    def cron_spec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cron_spec", value)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[str]]:
        """
        The end time of the event.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        The start time of the event.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)


