# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GoogleCloudDialogflowCxV3beta1AudioInputResponse',
    'GoogleCloudDialogflowCxV3beta1ConversationTurnResponse',
    'GoogleCloudDialogflowCxV3beta1ConversationTurnUserInputResponse',
    'GoogleCloudDialogflowCxV3beta1ConversationTurnVirtualAgentOutputResponse',
    'GoogleCloudDialogflowCxV3beta1DtmfInputResponse',
    'GoogleCloudDialogflowCxV3beta1EntityTypeEntityResponse',
    'GoogleCloudDialogflowCxV3beta1EntityTypeExcludedPhraseResponse',
    'GoogleCloudDialogflowCxV3beta1EnvironmentVersionConfigResponse',
    'GoogleCloudDialogflowCxV3beta1EventHandlerResponse',
    'GoogleCloudDialogflowCxV3beta1EventInputResponse',
    'GoogleCloudDialogflowCxV3beta1ExperimentDefinitionResponse',
    'GoogleCloudDialogflowCxV3beta1ExperimentResultConfidenceIntervalResponse',
    'GoogleCloudDialogflowCxV3beta1ExperimentResultMetricResponse',
    'GoogleCloudDialogflowCxV3beta1ExperimentResultResponse',
    'GoogleCloudDialogflowCxV3beta1ExperimentResultVersionMetricsResponse',
    'GoogleCloudDialogflowCxV3beta1FormParameterFillBehaviorResponse',
    'GoogleCloudDialogflowCxV3beta1FormParameterResponse',
    'GoogleCloudDialogflowCxV3beta1FormResponse',
    'GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCaseCaseContentResponse',
    'GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCaseResponse',
    'GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesResponse',
    'GoogleCloudDialogflowCxV3beta1FulfillmentResponse',
    'GoogleCloudDialogflowCxV3beta1FulfillmentSetParameterActionResponse',
    'GoogleCloudDialogflowCxV3beta1InputAudioConfigResponse',
    'GoogleCloudDialogflowCxV3beta1IntentInputResponse',
    'GoogleCloudDialogflowCxV3beta1IntentParameterResponse',
    'GoogleCloudDialogflowCxV3beta1IntentResponse',
    'GoogleCloudDialogflowCxV3beta1IntentTrainingPhrasePartResponse',
    'GoogleCloudDialogflowCxV3beta1IntentTrainingPhraseResponse',
    'GoogleCloudDialogflowCxV3beta1NluSettingsResponse',
    'GoogleCloudDialogflowCxV3beta1PageResponse',
    'GoogleCloudDialogflowCxV3beta1QueryInputResponse',
    'GoogleCloudDialogflowCxV3beta1ResponseMessageConversationSuccessResponse',
    'GoogleCloudDialogflowCxV3beta1ResponseMessageEndInteractionResponse',
    'GoogleCloudDialogflowCxV3beta1ResponseMessageLiveAgentHandoffResponse',
    'GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudioResponse',
    'GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudioSegmentResponse',
    'GoogleCloudDialogflowCxV3beta1ResponseMessageOutputAudioTextResponse',
    'GoogleCloudDialogflowCxV3beta1ResponseMessagePlayAudioResponse',
    'GoogleCloudDialogflowCxV3beta1ResponseMessageResponse',
    'GoogleCloudDialogflowCxV3beta1ResponseMessageTextResponse',
    'GoogleCloudDialogflowCxV3beta1SpeechToTextSettingsResponse',
    'GoogleCloudDialogflowCxV3beta1TestCaseResultResponse',
    'GoogleCloudDialogflowCxV3beta1TestConfigResponse',
    'GoogleCloudDialogflowCxV3beta1TestRunDifferenceResponse',
    'GoogleCloudDialogflowCxV3beta1TextInputResponse',
    'GoogleCloudDialogflowCxV3beta1TransitionRouteResponse',
    'GoogleCloudDialogflowCxV3beta1VariantsHistoryResponse',
    'GoogleCloudDialogflowCxV3beta1VersionVariantsResponse',
    'GoogleCloudDialogflowCxV3beta1VersionVariantsVariantResponse',
    'GoogleCloudDialogflowCxV3beta1WebhookGenericWebServiceResponse',
    'GoogleRpcStatusResponse',
]

@pulumi.output_type
class GoogleCloudDialogflowCxV3beta1AudioInputResponse(dict):
    """
    Represents the natural speech audio to be processed.
    """
    def __init__(__self__, *,
                 audio: str,
                 config: 'outputs.GoogleCloudDialogflowCxV3beta1InputAudioConfigResponse'):
        """
        Represents the natural speech audio to be processed.
        :param str audio: The natural language speech audio to be processed. A single request can contain up to 1 minute of speech audio data. The transcribed text cannot contain more than 256 bytes. For non-streaming audio detect intent, both `config` and `audio` must be provided. For streaming audio detect intent, `config` must be provided in the first request and `audio` must be provided in all following requests.
        :param 'GoogleCloudDialogflowCxV3beta1InputAudioConfigResponse' config: Required. Instructs the speech recognizer how to process the speech audio.
        """
        pulumi.set(__self__, "audio", audio)
        pulumi.set(__self__, "config", config)

    @property
    @pulumi.getter
    def audio(self) -> str:
        """
        The natural language speech audio to be processed. A single request can contain up to 1 minute of speech audio data. The transcribed text cannot contain more than 256 bytes. For non-streaming audio detect intent, both `config` and `audio` must be provided. For streaming audio detect intent, `config` must be provided in the first request and `audio` must be provided in all following requests.
        """
        return pulumi.get(self, "audio")

    @property
    @pulumi.getter
    def config(self) -> 'outputs.GoogleCloudDialogflowCxV3beta1InputAudioConfigResponse':
        """
        Required. Instructs the speech recognizer how to process the speech audio.
        """
        return pulumi.get(self, "config")


@pulumi.output_type
class GoogleCloudDialogflowCxV3beta1ConversationTurnResponse(dict):
    """
    One interaction between a human and virtual agent. The human provides some input and the virtual agent provides a response.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userInput":
            suggest = "user_input"
        elif key == "virtualAgentOutput":
            suggest = "virtual_agent_output"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowCxV3beta1ConversationTurnResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowCxV3beta1ConversationTurnResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowCxV3beta1ConversationTurnResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 user_input: 'outputs.GoogleCloudDialogflowCxV3beta1ConversationTurnUserInputResponse',
                 virtual_agent_output: 'outputs.GoogleCloudDialogflowCxV3beta1ConversationTurnVirtualAgentOutputResponse'):
        """
        One interaction between a human and virtual agent. The human provides some input and the virtual agent provides a response.
        :param 'GoogleCloudDialogflowCxV3beta1ConversationTurnUserInputResponse' user_input: The user input.
        :param 'GoogleCloudDialogflowCxV3beta1ConversationTurnVirtualAgentOutputResponse' virtual_agent_output: The virtual agent output.
        """
        pulumi.set(__self__, "user_input", user_input)
        pulumi.set(__self__, "virtual_agent_output", virtual_agent_output)

    @property
    @pulumi.getter(name="userInput")
    def user_input(self) -> 'outputs.GoogleCloudDialogflowCxV3beta1ConversationTurnUserInputResponse':
        """
        The user input.
        """
        return pulumi.get(self, "user_input")

    @property
    @pulumi.getter(name="virtualAgentOutput")
    def virtual_agent_output(self) -> 'outputs.GoogleCloudDialogflowCxV3beta1ConversationTurnVirtualAgentOutputResponse':
        """
        The virtual agent output.
        """
        return pulumi.get(self, "virtual_agent_output")


@pulumi.output_type
class GoogleCloudDialogflowCxV3beta1ConversationTurnUserInputResponse(dict):
    """
    The input from the human user.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "injectedParameters":
            suggest = "injected_parameters"
        elif key == "isWebhookEnabled":
            suggest = "is_webhook_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowCxV3beta1ConversationTurnUserInputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowCxV3beta1ConversationTurnUserInputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowCxV3beta1ConversationTurnUserInputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 injected_parameters: Mapping[str, str],
                 input: 'outputs.GoogleCloudDialogflowCxV3beta1QueryInputResponse',
                 is_webhook_enabled: bool):
        """
        The input from the human user.
        :param Mapping[str, str] injected_parameters: Parameters that need to be injected into the conversation during intent detection.
        :param 'GoogleCloudDialogflowCxV3beta1QueryInputResponse' input: Supports text input, event input, dtmf input in the test case.
        :param bool is_webhook_enabled: If webhooks should be allowed to trigger in response to the user utterance. Often if parameters are injected, webhooks should not be enabled.
        """
        pulumi.set(__self__, "injected_parameters", injected_parameters)
        pulumi.set(__self__, "input", input)
        pulumi.set(__self__, "is_webhook_enabled", is_webhook_enabled)

    @property
    @pulumi.getter(name="injectedParameters")
    def injected_parameters(self) -> Mapping[str, str]:
        """
        Parameters that need to be injected into the conversation during intent detection.
        """
        return pulumi.get(self, "injected_parameters")

    @property
    @pulumi.getter
    def input(self) -> 'outputs.GoogleCloudDialogflowCxV3beta1QueryInputResponse':
        """
        Supports text input, event input, dtmf input in the test case.
        """
        return pulumi.get(self, "input")

    @property
    @pulumi.getter(name="isWebhookEnabled")
    def is_webhook_enabled(self) -> bool:
        """
        If webhooks should be allowed to trigger in response to the user utterance. Often if parameters are injected, webhooks should not be enabled.
        """
        return pulumi.get(self, "is_webhook_enabled")


@pulumi.output_type
class GoogleCloudDialogflowCxV3beta1ConversationTurnVirtualAgentOutputResponse(dict):
    """
    The output from the virtual agent.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "currentPage":
            suggest = "current_page"
        elif key == "diagnosticInfo":
            suggest = "diagnostic_info"
        elif key == "sessionParameters":
            suggest = "session_parameters"
        elif key == "textResponses":
            suggest = "text_responses"
        elif key == "triggeredIntent":
            suggest = "triggered_intent"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowCxV3beta1ConversationTurnVirtualAgentOutputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowCxV3beta1ConversationTurnVirtualAgentOutputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowCxV3beta1ConversationTurnVirtualAgentOutputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 current_page: 'outputs.GoogleCloudDialogflowCxV3beta1PageResponse',
                 diagnostic_info: Mapping[str, str],
                 differences: Sequence['outputs.GoogleCloudDialogflowCxV3beta1TestRunDifferenceResponse'],
                 session_parameters: Mapping[str, str],
                 status: 'outputs.GoogleRpcStatusResponse',
                 text_responses: Sequence['outputs.GoogleCloudDialogflowCxV3beta1ResponseMessageTextResponse'],
                 triggered_intent: 'outputs.GoogleCloudDialogflowCxV3beta1IntentResponse'):
        """
        The output from the virtual agent.
        :param 'GoogleCloudDialogflowCxV3beta1PageResponse' current_page: The Page on which the utterance was spoken. Only name and displayName will be set.
        :param Mapping[str, str] diagnostic_info: Required. Input only. The diagnostic info output for the turn.
        :param Sequence['GoogleCloudDialogflowCxV3beta1TestRunDifferenceResponse'] differences: If this is part of a result conversation turn, the list of differences between the original run and the replay for this output, if any.
        :param Mapping[str, str] session_parameters: The session parameters available to the bot at this point.
        :param 'GoogleRpcStatusResponse' status: Response error from the agent in the test result. If set, other output is empty.
        :param Sequence['GoogleCloudDialogflowCxV3beta1ResponseMessageTextResponse'] text_responses: The text responses from the agent for the turn.
        :param 'GoogleCloudDialogflowCxV3beta1IntentResponse' triggered_intent: The Intent that triggered the response. Only name and displayName will be set.
        """
        pulumi.set(__self__, "current_page", current_page)
        pulumi.set(__self__, "diagnostic_info", diagnostic_info)
        pulumi.set(__self__, "differences", differences)
        pulumi.set(__self__, "session_parameters", session_parameters)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "text_responses", text_responses)
        pulumi.set(__self__, "triggered_intent", triggered_intent)

    @property
    @pulumi.getter(name="currentPage")
    def current_page(self) -> 'outputs.GoogleCloudDialogflowCxV3beta1PageResponse':
        """
        The Page on which the utterance was spoken. Only name and displayName will be set.
        """
        return pulumi.get(self, "current_page")

    @property
    @pulumi.getter(name="diagnosticInfo")
    def diagnostic_info(self) -> Mapping[str, str]:
        """
        Required. Input only. The diagnostic info output for the turn.
        """
        return pulumi.get(self, "diagnostic_info")

    @property
    @pulumi.getter
    def differences(self) -> Sequence['outputs.GoogleCloudDialogflowCxV3beta1TestRunDifferenceResponse']:
        """
        If this is part of a result conversation turn, the list of differences between the original run and the replay for this output, if any.
        """
        return pulumi.get(self, "differences")

    @property
    @pulumi.getter(name="sessionParameters")
    def session_parameters(self) -> Mapping[str, str]:
        """
        The session parameters available to the bot at this point.
        """
        return pulumi.get(self, "session_parameters")

    @property
    @pulumi.getter
    def status(self) -> 'outputs.GoogleRpcStatusResponse':
        """
        Response error from the agent in the test result. If set, other output is empty.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="textResponses")
    def text_responses(self) -> Sequence['outputs.GoogleCloudDialogflowCxV3beta1ResponseMessageTextResponse']:
        """
        The text responses from the agent for the turn.
        """
        return pulumi.get(self, "text_responses")

    @property
    @pulumi.getter(name="triggeredIntent")
    def triggered_intent(self) -> 'outputs.GoogleCloudDialogflowCxV3beta1IntentResponse':
        """
        The Intent that triggered the response. Only name and displayName will be set.
        """
        return pulumi.get(self, "triggered_intent")


@pulumi.output_type
class GoogleCloudDialogflowCxV3beta1DtmfInputResponse(dict):
    """
    Represents the input for dtmf event.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "finishDigit":
            suggest = "finish_digit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowCxV3beta1DtmfInputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowCxV3beta1DtmfInputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowCxV3beta1DtmfInputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 digits: str,
                 finish_digit: str):
        """
        Represents the input for dtmf event.
        :param str digits: The dtmf digits.
        :param str finish_digit: The finish digit (if any).
        """
        pulumi.set(__self__, "digits", digits)
        pulumi.set(__self__, "finish_digit", finish_digit)

    @property
    @pulumi.getter
    def digits(self) -> str:
        """
        The dtmf digits.
        """
        return pulumi.get(self, "digits")

    @property
    @pulumi.getter(name="finishDigit")
    def finish_digit(self) -> str:
        """
        The finish digit (if any).
        """
        return pulumi.get(self, "finish_digit")


@pulumi.output_type
class GoogleCloudDialogflowCxV3beta1EntityTypeEntityResponse(dict):
    """
    An **entity entry** for an associated entity type.
    """
    def __init__(__self__, *,
                 synonyms: Sequence[str],
                 value: str):
        """
        An **entity entry** for an associated entity type.
        :param Sequence[str] synonyms: Required. A collection of value synonyms. For example, if the entity type is *vegetable*, and `value` is *scallions*, a synonym could be *green onions*. For `KIND_LIST` entity types: * This collection must contain exactly one synonym equal to `value`.
        :param str value: Required. The primary value associated with this entity entry. For example, if the entity type is *vegetable*, the value could be *scallions*. For `KIND_MAP` entity types: * A canonical value to be used in place of synonyms. For `KIND_LIST` entity types: * A string that can contain references to other entity types (with or without aliases).
        """
        pulumi.set(__self__, "synonyms", synonyms)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def synonyms(self) -> Sequence[str]:
        """
        Required. A collection of value synonyms. For example, if the entity type is *vegetable*, and `value` is *scallions*, a synonym could be *green onions*. For `KIND_LIST` entity types: * This collection must contain exactly one synonym equal to `value`.
        """
        return pulumi.get(self, "synonyms")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Required. The primary value associated with this entity entry. For example, if the entity type is *vegetable*, the value could be *scallions*. For `KIND_MAP` entity types: * A canonical value to be used in place of synonyms. For `KIND_LIST` entity types: * A string that can contain references to other entity types (with or without aliases).
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GoogleCloudDialogflowCxV3beta1EntityTypeExcludedPhraseResponse(dict):
    """
    An excluded entity phrase that should not be matched.
    """
    def __init__(__self__, *,
                 value: str):
        """
        An excluded entity phrase that should not be matched.
        :param str value: Required. The word or phrase to be excluded.
        """
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Required. The word or phrase to be excluded.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GoogleCloudDialogflowCxV3beta1EnvironmentVersionConfigResponse(dict):
    """
    Configuration for the version.
    """
    def __init__(__self__, *,
                 version: str):
        """
        Configuration for the version.
        :param str version: Required. Format: projects//locations//agents//flows//versions/.
        """
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Required. Format: projects//locations//agents//flows//versions/.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GoogleCloudDialogflowCxV3beta1EventHandlerResponse(dict):
    """
    An event handler specifies an event that can be handled during a session. When the specified event happens, the following actions are taken in order: * If there is a `trigger_fulfillment` associated with the event, it will be called. * If there is a `target_page` associated with the event, the session will transition into the specified page. * If there is a `target_flow` associated with the event, the session will transition into the specified flow.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetFlow":
            suggest = "target_flow"
        elif key == "targetPage":
            suggest = "target_page"
        elif key == "triggerFulfillment":
            suggest = "trigger_fulfillment"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowCxV3beta1EventHandlerResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowCxV3beta1EventHandlerResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowCxV3beta1EventHandlerResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 event: str,
                 name: str,
                 target_flow: str,
                 target_page: str,
                 trigger_fulfillment: 'outputs.GoogleCloudDialogflowCxV3beta1FulfillmentResponse'):
        """
        An event handler specifies an event that can be handled during a session. When the specified event happens, the following actions are taken in order: * If there is a `trigger_fulfillment` associated with the event, it will be called. * If there is a `target_page` associated with the event, the session will transition into the specified page. * If there is a `target_flow` associated with the event, the session will transition into the specified flow.
        :param str event: Required. The name of the event to handle.
        :param str name: The unique identifier of this event handler.
        :param str target_flow: The target flow to transition to. Format: `projects//locations//agents//flows/`.
        :param str target_page: The target page to transition to. Format: `projects//locations//agents//flows//pages/`.
        :param 'GoogleCloudDialogflowCxV3beta1FulfillmentResponse' trigger_fulfillment: The fulfillment to call when the event occurs. Handling webhook errors with a fulfillment enabled with webhook could cause infinite loop. It is invalid to specify such fulfillment for a handler handling webhooks.
        """
        pulumi.set(__self__, "event", event)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "target_flow", target_flow)
        pulumi.set(__self__, "target_page", target_page)
        pulumi.set(__self__, "trigger_fulfillment", trigger_fulfillment)

    @property
    @pulumi.getter
    def event(self) -> str:
        """
        Required. The name of the event to handle.
        """
        return pulumi.get(self, "event")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique identifier of this event handler.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="targetFlow")
    def target_flow(self) -> str:
        """
        The target flow to transition to. Format: `projects//locations//agents//flows/`.
        """
        return pulumi.get(self, "target_flow")

    @property
    @pulumi.getter(name="targetPage")
    def target_page(self) -> str:
        """
        The target page to transition to. Format: `projects//locations//agents//flows//pages/`.
        """
        return pulumi.get(self, "target_page")

    @property
    @pulumi.getter(name="triggerFulfillment")
    def trigger_fulfillment(self) -> 'outputs.GoogleCloudDialogflowCxV3beta1FulfillmentResponse':
        """
        The fulfillment to call when the event occurs. Handling webhook errors with a fulfillment enabled with webhook could cause infinite loop. It is invalid to specify such fulfillment for a handler handling webhooks.
        """
        return pulumi.get(self, "trigger_fulfillment")


@pulumi.output_type
class GoogleCloudDialogflowCxV3beta1EventInputResponse(dict):
    """
    Represents the event to trigger.
    """
    def __init__(__self__, *,
                 event: str):
        """
        Represents the event to trigger.
        :param str event: Name of the event.
        """
        pulumi.set(__self__, "event", event)

    @property
    @pulumi.getter
    def event(self) -> str:
        """
        Name of the event.
        """
        return pulumi.get(self, "event")


@pulumi.output_type
class GoogleCloudDialogflowCxV3beta1ExperimentDefinitionResponse(dict):
    """
    Definition of the experiment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "versionVariants":
            suggest = "version_variants"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowCxV3beta1ExperimentDefinitionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowCxV3beta1ExperimentDefinitionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowCxV3beta1ExperimentDefinitionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 condition: str,
                 version_variants: 'outputs.GoogleCloudDialogflowCxV3beta1VersionVariantsResponse'):
        """
        Definition of the experiment.
        :param str condition: The condition defines which subset of sessions are selected for this experiment. If not specified, all sessions are eligible. E.g. "query_input.language_code=en" See the [conditions reference](https://cloud.google.com/dialogflow/cx/docs/reference/condition).
        :param 'GoogleCloudDialogflowCxV3beta1VersionVariantsResponse' version_variants: The flow versions as the variants of this experiment.
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "version_variants", version_variants)

    @property
    @pulumi.getter
    def condition(self) -> str:
        """
        The condition defines which subset of sessions are selected for this experiment. If not specified, all sessions are eligible. E.g. "query_input.language_code=en" See the [conditions reference](https://cloud.google.com/dialogflow/cx/docs/reference/condition).
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter(name="versionVariants")
    def version_variants(self) -> 'outputs.GoogleCloudDialogflowCxV3beta1VersionVariantsResponse':
        """
        The flow versions as the variants of this experiment.
        """
        return pulumi.get(self, "version_variants")


@pulumi.output_type
class GoogleCloudDialogflowCxV3beta1ExperimentResultConfidenceIntervalResponse(dict):
    """
    A confidence interval is a range of possible values for the experiment objective you are trying to measure.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "confidenceLevel":
            suggest = "confidence_level"
        elif key == "lowerBound":
            suggest = "lower_bound"
        elif key == "upperBound":
            suggest = "upper_bound"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowCxV3beta1ExperimentResultConfidenceIntervalResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowCxV3beta1ExperimentResultConfidenceIntervalResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowCxV3beta1ExperimentResultConfidenceIntervalResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 confidence_level: float,
                 lower_bound: float,
                 ratio: float,
                 upper_bound: float):
        """
        A confidence interval is a range of possible values for the experiment objective you are trying to measure.
        :param float confidence_level: The confidence level used to construct the interval, i.e. there is X% chance that the true value is within this interval.
        :param float lower_bound: Lower bound of the interval.
        :param float ratio: The percent change between an experiment metric's value and the value for its control.
        :param float upper_bound: Upper bound of the interval.
        """
        pulumi.set(__self__, "confidence_level", confidence_level)
        pulumi.set(__self__, "lower_bound", lower_bound)
        pulumi.set(__self__, "ratio", ratio)
        pulumi.set(__self__, "upper_bound", upper_bound)

    @property
    @pulumi.getter(name="confidenceLevel")
    def confidence_level(self) -> float:
        """
        The confidence level used to construct the interval, i.e. there is X% chance that the true value is within this interval.
        """
        return pulumi.get(self, "confidence_level")

    @property
    @pulumi.getter(name="lowerBound")
    def lower_bound(self) -> float:
        """
        Lower bound of the interval.
        """
        return pulumi.get(self, "lower_bound")

    @property
    @pulumi.getter
    def ratio(self) -> float:
        """
        The percent change between an experiment metric's value and the value for its control.
        """
        return pulumi.get(self, "ratio")

    @property
    @pulumi.getter(name="upperBound")
    def upper_bound(self) -> float:
        """
        Upper bound of the interval.
        """
        return pulumi.get(self, "upper_bound")


@pulumi.output_type
class GoogleCloudDialogflowCxV3beta1ExperimentResultMetricResponse(dict):
    """
    Metric and corresponding confidence intervals.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "confidenceInterval":
            suggest = "confidence_interval"
        elif key == "countType":
            suggest = "count_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowCxV3beta1ExperimentResultMetricResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowCxV3beta1ExperimentResultMetricResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowCxV3beta1ExperimentResultMetricResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 confidence_interval: 'outputs.GoogleCloudDialogflowCxV3beta1ExperimentResultConfidenceIntervalResponse',
                 count: float,
                 count_type: str,
                 ratio: float,
                 type: str):
        """
        Metric and corresponding confidence intervals.
        :param 'GoogleCloudDialogflowCxV3beta1ExperimentResultConfidenceIntervalResponse' confidence_interval: The probability that the treatment is better than all other treatments in the experiment
        :param float count: Count value of a metric.
        :param str count_type: Count-based metric type. Only one of type or count_type is specified in each Metric.
        :param float ratio: Ratio value of a metric.
        :param str type: Ratio-based metric type. Only one of type or count_type is specified in each Metric.
        """
        pulumi.set(__self__, "confidence_interval", confidence_interval)
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "count_type", count_type)
        pulumi.set(__self__, "ratio", ratio)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="confidenceInterval")
    def confidence_interval(self) -> 'outputs.GoogleCloudDialogflowCxV3beta1ExperimentResultConfidenceIntervalResponse':
        """
        The probability that the treatment is better than all other treatments in the experiment
        """
        return pulumi.get(self, "confidence_interval")

    @property
    @pulumi.getter
    def count(self) -> float:
        """
        Count value of a metric.
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter(name="countType")
    def count_type(self) -> str:
        """
        Count-based metric type. Only one of type or count_type is specified in each Metric.
        """
        return pulumi.get(self, "count_type")

    @property
    @pulumi.getter
    def ratio(self) -> float:
        """
        Ratio value of a metric.
        """
        return pulumi.get(self, "ratio")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Ratio-based metric type. Only one of type or count_type is specified in each Metric.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GoogleCloudDialogflowCxV3beta1ExperimentResultResponse(dict):
    """
    The inference result which includes an objective metric to optimize and the confidence interval.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastUpdateTime":
            suggest = "last_update_time"
        elif key == "versionMetrics":
            suggest = "version_metrics"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowCxV3beta1ExperimentResultResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowCxV3beta1ExperimentResultResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowCxV3beta1ExperimentResultResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_update_time: str,
                 version_metrics: Sequence['outputs.GoogleCloudDialogflowCxV3beta1ExperimentResultVersionMetricsResponse']):
        """
        The inference result which includes an objective metric to optimize and the confidence interval.
        :param str last_update_time: The last time the experiment's stats data was updated. Will have default value if stats have never been computed for this experiment.
        :param Sequence['GoogleCloudDialogflowCxV3beta1ExperimentResultVersionMetricsResponse'] version_metrics: Version variants and metrics.
        """
        pulumi.set(__self__, "last_update_time", last_update_time)
        pulumi.set(__self__, "version_metrics", version_metrics)

    @property
    @pulumi.getter(name="lastUpdateTime")
    def last_update_time(self) -> str:
        """
        The last time the experiment's stats data was updated. Will have default value if stats have never been computed for this experiment.
        """
        return pulumi.get(self, "last_update_time")

    @property
    @pulumi.getter(name="versionMetrics")
    def version_metrics(self) -> Sequence['outputs.GoogleCloudDialogflowCxV3beta1ExperimentResultVersionMetricsResponse']:
        """
        Version variants and metrics.
        """
        return pulumi.get(self, "version_metrics")


@pulumi.output_type
class GoogleCloudDialogflowCxV3beta1ExperimentResultVersionMetricsResponse(dict):
    """
    Version variant and associated metrics.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sessionCount":
            suggest = "session_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowCxV3beta1ExperimentResultVersionMetricsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowCxV3beta1ExperimentResultVersionMetricsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowCxV3beta1ExperimentResultVersionMetricsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metrics: Sequence['outputs.GoogleCloudDialogflowCxV3beta1ExperimentResultMetricResponse'],
                 session_count: int,
                 version: str):
        """
        Version variant and associated metrics.
        :param Sequence['GoogleCloudDialogflowCxV3beta1ExperimentResultMetricResponse'] metrics: The metrics and corresponding confidence intervals in the inference result.
        :param int session_count: Number of sessions that were allocated to this version.
        :param str version: The name of the flow Version. Format: `projects//locations//agents//flows//versions/`.
        """
        pulumi.set(__self__, "metrics", metrics)
        pulumi.set(__self__, "session_count", session_count)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def metrics(self) -> Sequence['outputs.GoogleCloudDialogflowCxV3beta1ExperimentResultMetricResponse']:
        """
        The metrics and corresponding confidence intervals in the inference result.
        """
        return pulumi.get(self, "metrics")

    @property
    @pulumi.getter(name="sessionCount")
    def session_count(self) -> int:
        """
        Number of sessions that were allocated to this version.
        """
        return pulumi.get(self, "session_count")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The name of the flow Version. Format: `projects//locations//agents//flows//versions/`.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GoogleCloudDialogflowCxV3beta1FormParameterFillBehaviorResponse(dict):
    """
    Configuration for how the filling of a parameter should be handled.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "initialPromptFulfillment":
            suggest = "initial_prompt_fulfillment"
        elif key == "repromptEventHandlers":
            suggest = "reprompt_event_handlers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowCxV3beta1FormParameterFillBehaviorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowCxV3beta1FormParameterFillBehaviorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowCxV3beta1FormParameterFillBehaviorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 initial_prompt_fulfillment: 'outputs.GoogleCloudDialogflowCxV3beta1FulfillmentResponse',
                 reprompt_event_handlers: Sequence['outputs.GoogleCloudDialogflowCxV3beta1EventHandlerResponse']):
        """
        Configuration for how the filling of a parameter should be handled.
        :param 'GoogleCloudDialogflowCxV3beta1FulfillmentResponse' initial_prompt_fulfillment: Required. The fulfillment to provide the initial prompt that the agent can present to the user in order to fill the parameter.
        :param Sequence['GoogleCloudDialogflowCxV3beta1EventHandlerResponse'] reprompt_event_handlers: The handlers for parameter-level events, used to provide reprompt for the parameter or transition to a different page/flow. The supported events are: * `sys.no-match-`, where N can be from 1 to 6 * `sys.no-match-default` * `sys.no-input-`, where N can be from 1 to 6 * `sys.no-input-default` * `sys.invalid-parameter` `initial_prompt_fulfillment` provides the first prompt for the parameter. If the user's response does not fill the parameter, a no-match/no-input event will be triggered, and the fulfillment associated with the `sys.no-match-1`/`sys.no-input-1` handler (if defined) will be called to provide a prompt. The `sys.no-match-2`/`sys.no-input-2` handler (if defined) will respond to the next no-match/no-input event, and so on. A `sys.no-match-default` or `sys.no-input-default` handler will be used to handle all following no-match/no-input events after all numbered no-match/no-input handlers for the parameter are consumed. A `sys.invalid-parameter` handler can be defined to handle the case where the parameter values have been `invalidated` by webhook. For example, if the user's response fill the parameter, however the parameter was invalidated by webhook, the fulfillment associated with the `sys.invalid-parameter` handler (if defined) will be called to provide a prompt. If the event handler for the corresponding event can't be found on the parameter, `initial_prompt_fulfillment` will be re-prompted.
        """
        pulumi.set(__self__, "initial_prompt_fulfillment", initial_prompt_fulfillment)
        pulumi.set(__self__, "reprompt_event_handlers", reprompt_event_handlers)

    @property
    @pulumi.getter(name="initialPromptFulfillment")
    def initial_prompt_fulfillment(self) -> 'outputs.GoogleCloudDialogflowCxV3beta1FulfillmentResponse':
        """
        Required. The fulfillment to provide the initial prompt that the agent can present to the user in order to fill the parameter.
        """
        return pulumi.get(self, "initial_prompt_fulfillment")

    @property
    @pulumi.getter(name="repromptEventHandlers")
    def reprompt_event_handlers(self) -> Sequence['outputs.GoogleCloudDialogflowCxV3beta1EventHandlerResponse']:
        """
        The handlers for parameter-level events, used to provide reprompt for the parameter or transition to a different page/flow. The supported events are: * `sys.no-match-`, where N can be from 1 to 6 * `sys.no-match-default` * `sys.no-input-`, where N can be from 1 to 6 * `sys.no-input-default` * `sys.invalid-parameter` `initial_prompt_fulfillment` provides the first prompt for the parameter. If the user's response does not fill the parameter, a no-match/no-input event will be triggered, and the fulfillment associated with the `sys.no-match-1`/`sys.no-input-1` handler (if defined) will be called to provide a prompt. The `sys.no-match-2`/`sys.no-input-2` handler (if defined) will respond to the next no-match/no-input event, and so on. A `sys.no-match-default` or `sys.no-input-default` handler will be used to handle all following no-match/no-input events after all numbered no-match/no-input handlers for the parameter are consumed. A `sys.invalid-parameter` handler can be defined to handle the case where the parameter values have been `invalidated` by webhook. For example, if the user's response fill the parameter, however the parameter was invalidated by webhook, the fulfillment associated with the `sys.invalid-parameter` handler (if defined) will be called to provide a prompt. If the event handler for the corresponding event can't be found on the parameter, `initial_prompt_fulfillment` will be re-prompted.
        """
        return pulumi.get(self, "reprompt_event_handlers")


@pulumi.output_type
class GoogleCloudDialogflowCxV3beta1FormParameterResponse(dict):
    """
    Represents a form parameter.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultValue":
            suggest = "default_value"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "entityType":
            suggest = "entity_type"
        elif key == "fillBehavior":
            suggest = "fill_behavior"
        elif key == "isList":
            suggest = "is_list"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowCxV3beta1FormParameterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowCxV3beta1FormParameterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowCxV3beta1FormParameterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_value: Any,
                 display_name: str,
                 entity_type: str,
                 fill_behavior: 'outputs.GoogleCloudDialogflowCxV3beta1FormParameterFillBehaviorResponse',
                 is_list: bool,
                 redact: bool,
                 required: bool):
        """
        Represents a form parameter.
        :param Any default_value: The default value of an optional parameter. If the parameter is required, the default value will be ignored.
        :param str display_name: Required. The human-readable name of the parameter, unique within the form.
        :param str entity_type: Required. The entity type of the parameter. Format: `projects/-/locations/-/agents/-/entityTypes/` for system entity types (for example, `projects/-/locations/-/agents/-/entityTypes/sys.date`), or `projects//locations//agents//entityTypes/` for developer entity types.
        :param 'GoogleCloudDialogflowCxV3beta1FormParameterFillBehaviorResponse' fill_behavior: Required. Defines fill behavior for the parameter.
        :param bool is_list: Indicates whether the parameter represents a list of values.
        :param bool redact: Indicates whether the parameter content should be redacted in log. If redaction is enabled, the parameter content will be replaced by parameter name during logging. Note: the parameter content is subject to redaction if either parameter level redaction or entity type level redaction is enabled.
        :param bool required: Indicates whether the parameter is required. Optional parameters will not trigger prompts; however, they are filled if the user specifies them. Required parameters must be filled before form filling concludes.
        """
        pulumi.set(__self__, "default_value", default_value)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "entity_type", entity_type)
        pulumi.set(__self__, "fill_behavior", fill_behavior)
        pulumi.set(__self__, "is_list", is_list)
        pulumi.set(__self__, "redact", redact)
        pulumi.set(__self__, "required", required)

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Any:
        """
        The default value of an optional parameter. If the parameter is required, the default value will be ignored.
        """
        return pulumi.get(self, "default_value")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Required. The human-readable name of the parameter, unique within the form.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> str:
        """
        Required. The entity type of the parameter. Format: `projects/-/locations/-/agents/-/entityTypes/` for system entity types (for example, `projects/-/locations/-/agents/-/entityTypes/sys.date`), or `projects//locations//agents//entityTypes/` for developer entity types.
        """
        return pulumi.get(self, "entity_type")

    @property
    @pulumi.getter(name="fillBehavior")
    def fill_behavior(self) -> 'outputs.GoogleCloudDialogflowCxV3beta1FormParameterFillBehaviorResponse':
        """
        Required. Defines fill behavior for the parameter.
        """
        return pulumi.get(self, "fill_behavior")

    @property
    @pulumi.getter(name="isList")
    def is_list(self) -> bool:
        """
        Indicates whether the parameter represents a list of values.
        """
        return pulumi.get(self, "is_list")

    @property
    @pulumi.getter
    def redact(self) -> bool:
        """
        Indicates whether the parameter content should be redacted in log. If redaction is enabled, the parameter content will be replaced by parameter name during logging. Note: the parameter content is subject to redaction if either parameter level redaction or entity type level redaction is enabled.
        """
        return pulumi.get(self, "redact")

    @property
    @pulumi.getter
    def required(self) -> bool:
        """
        Indicates whether the parameter is required. Optional parameters will not trigger prompts; however, they are filled if the user specifies them. Required parameters must be filled before form filling concludes.
        """
        return pulumi.get(self, "required")


@pulumi.output_type
class GoogleCloudDialogflowCxV3beta1FormResponse(dict):
    """
    A form is a data model that groups related parameters that can be collected from the user. The process in which the agent prompts the user and collects parameter values from the user is called form filling. A form can be added to a page. When form filling is done, the filled parameters will be written to the session.
    """
    def __init__(__self__, *,
                 parameters: Sequence['outputs.GoogleCloudDialogflowCxV3beta1FormParameterResponse']):
        """
        A form is a data model that groups related parameters that can be collected from the user. The process in which the agent prompts the user and collects parameter values from the user is called form filling. A form can be added to a page. When form filling is done, the filled parameters will be written to the session.
        :param Sequence['GoogleCloudDialogflowCxV3beta1FormParameterResponse'] parameters: Parameters to collect from the user.
        """
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def parameters(self) -> Sequence['outputs.GoogleCloudDialogflowCxV3beta1FormParameterResponse']:
        """
        Parameters to collect from the user.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCaseCaseContentResponse(dict):
    """
    The list of messages or conditional cases to activate for this case.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalCases":
            suggest = "additional_cases"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCaseCaseContentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCaseCaseContentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCaseCaseContentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 additional_cases: 'outputs.GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesResponse',
                 message: 'outputs.GoogleCloudDialogflowCxV3beta1ResponseMessageResponse'):
        """
        The list of messages or conditional cases to activate for this case.
        :param 'GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesResponse' additional_cases: Additional cases to be evaluated.
        :param 'GoogleCloudDialogflowCxV3beta1ResponseMessageResponse' message: Returned message.
        """
        pulumi.set(__self__, "additional_cases", additional_cases)
        pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter(name="additionalCases")
    def additional_cases(self) -> 'outputs.GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesResponse':
        """
        Additional cases to be evaluated.
        """
        return pulumi.get(self, "additional_cases")

    @property
    @pulumi.getter
    def message(self) -> 'outputs.GoogleCloudDialogflowCxV3beta1ResponseMessageResponse':
        """
        Returned message.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCaseResponse(dict):
    """
    Each case has a Boolean condition. When it is evaluated to be True, the corresponding messages will be selected and evaluated recursively.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caseContent":
            suggest = "case_content"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCaseResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCaseResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCaseResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 case_content: Sequence['outputs.GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCaseCaseContentResponse'],
                 condition: str):
        """
        Each case has a Boolean condition. When it is evaluated to be True, the corresponding messages will be selected and evaluated recursively.
        :param Sequence['GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCaseCaseContentResponse'] case_content: A list of case content.
        :param str condition: The condition to activate and select this case. Empty means the condition is always true. The condition is evaluated against form parameters or session parameters. See the [conditions reference](https://cloud.google.com/dialogflow/cx/docs/reference/condition).
        """
        pulumi.set(__self__, "case_content", case_content)
        pulumi.set(__self__, "condition", condition)

    @property
    @pulumi.getter(name="caseContent")
    def case_content(self) -> Sequence['outputs.GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCaseCaseContentResponse']:
        """
        A list of case content.
        """
        return pulumi.get(self, "case_content")

    @property
    @pulumi.getter
    def condition(self) -> str:
        """
        The condition to activate and select this case. Empty means the condition is always true. The condition is evaluated against form parameters or session parameters. See the [conditions reference](https://cloud.google.com/dialogflow/cx/docs/reference/condition).
        """
        return pulumi.get(self, "condition")


@pulumi.output_type
class GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesResponse(dict):
    """
    A list of cascading if-else conditions. Cases are mutually exclusive. The first one with a matching condition is selected, all the rest ignored.
    """
    def __init__(__self__, *,
                 cases: Sequence['outputs.GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCaseResponse']):
        """
        A list of cascading if-else conditions. Cases are mutually exclusive. The first one with a matching condition is selected, all the rest ignored.
        :param Sequence['GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCaseResponse'] cases: A list of cascading if-else conditions.
        """
        pulumi.set(__self__, "cases", cases)

    @property
    @pulumi.getter
    def cases(self) -> Sequence['outputs.GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesCaseResponse']:
        """
        A list of cascading if-else conditions.
        """
        return pulumi.get(self, "cases")


@pulumi.output_type
class GoogleCloudDialogflowCxV3beta1FulfillmentResponse(dict):
    """
    A fulfillment can do one or more of the following actions at the same time: * Generate rich message responses. * Set parameter values. * Call the webhook. Fulfillments can be called at various stages in the Page or Form lifecycle. For example, when a DetectIntentRequest drives a session to enter a new page, the page's entry fulfillment can add a static response to the QueryResult in the returning DetectIntentResponse, call the webhook (for example, to load user data from a database), or both.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "conditionalCases":
            suggest = "conditional_cases"
        elif key == "setParameterActions":
            suggest = "set_parameter_actions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowCxV3beta1FulfillmentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowCxV3beta1FulfillmentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowCxV3beta1FulfillmentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 conditional_cases: Sequence['outputs.GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesResponse'],
                 messages: Sequence['outputs.GoogleCloudDialogflowCxV3beta1ResponseMessageResponse'],
                 set_parameter_actions: Sequence['outputs.GoogleCloudDialogflowCxV3beta1FulfillmentSetParameterActionResponse'],
                 tag: str,
                 webhook: str):
        """
        A fulfillment can do one or more of the following actions at the same time: * Generate rich message responses. * Set parameter values. * Call the webhook. Fulfillments can be called at various stages in the Page or Form lifecycle. For example, when a DetectIntentRequest drives a session to enter a new page, the page's entry fulfillment can add a static response to the QueryResult in the returning DetectIntentResponse, call the webhook (for example, to load user data from a database), or both.
        :param Sequence['GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesResponse'] conditional_cases: Conditional cases for this fulfillment.
        :param Sequence['GoogleCloudDialogflowCxV3beta1ResponseMessageResponse'] messages: The list of rich message responses to present to the user.
        :param Sequence['GoogleCloudDialogflowCxV3beta1FulfillmentSetParameterActionResponse'] set_parameter_actions: Set parameter values before executing the webhook.
        :param str tag: The tag used by the webhook to identify which fulfillment is being called. This field is required if `webhook` is specified.
        :param str webhook: The webhook to call. Format: `projects//locations//agents//webhooks/`.
        """
        pulumi.set(__self__, "conditional_cases", conditional_cases)
        pulumi.set(__self__, "messages", messages)
        pulumi.set(__self__, "set_parameter_actions", set_parameter_actions)
        pulumi.set(__self__, "tag", tag)
        pulumi.set(__self__, "webhook", webhook)

    @property
    @pulumi.getter(name="conditionalCases")
    def conditional_cases(self) -> Sequence['outputs.GoogleCloudDialogflowCxV3beta1FulfillmentConditionalCasesResponse']:
        """
        Conditional cases for this fulfillment.
        """
        return pulumi.get(self, "conditional_cases")

    @property
    @pulumi.getter
    def messages(self) -> Sequence['outputs.GoogleCloudDialogflowCxV3beta1ResponseMessageResponse']:
        """
        The list of rich message responses to present to the user.
        """
        return pulumi.get(self, "messages")

    @property
    @pulumi.getter(name="setParameterActions")
    def set_parameter_actions(self) -> Sequence['outputs.GoogleCloudDialogflowCxV3beta1FulfillmentSetParameterActionResponse']:
        """
        Set parameter values before executing the webhook.
        """
        return pulumi.get(self, "set_parameter_actions")

    @property
    @pulumi.getter
    def tag(self) -> str:
        """
        The tag used by the webhook to identify which fulfillment is being called. This field is required if `webhook` is specified.
        """
        return pulumi.get(self, "tag")

    @property
    @pulumi.getter
    def webhook(self) -> str:
        """
        The webhook to call. Format: `projects//locations//agents//webhooks/`.
        """
        return pulumi.get(self, "webhook")


@pulumi.output_type
class GoogleCloudDialogflowCxV3beta1FulfillmentSetParameterActionResponse(dict):
    """
    Setting a parameter value.
    """
    def __init__(__self__, *,
                 parameter: str,
                 value: Any):
        """
        Setting a parameter value.
        :param str parameter: Display name of the parameter.
        :param Any value: The new value of the parameter. A null value clears the parameter.
        """
        pulumi.set(__self__, "parameter", parameter)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def parameter(self) -> str:
        """
        Display name of the parameter.
        """
        return pulumi.get(self, "parameter")

    @property
    @pulumi.getter
    def value(self) -> Any:
        """
        The new value of the parameter. A null value clears the parameter.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GoogleCloudDialogflowCxV3beta1InputAudioConfigResponse(dict):
    """
    Instructs the speech recognizer on how to process the audio content.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "audioEncoding":
            suggest = "audio_encoding"
        elif key == "enableWordInfo":
            suggest = "enable_word_info"
        elif key == "modelVariant":
            suggest = "model_variant"
        elif key == "phraseHints":
            suggest = "phrase_hints"
        elif key == "sampleRateHertz":
            suggest = "sample_rate_hertz"
        elif key == "singleUtterance":
            suggest = "single_utterance"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowCxV3beta1InputAudioConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowCxV3beta1InputAudioConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowCxV3beta1InputAudioConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audio_encoding: str,
                 enable_word_info: bool,
                 model: str,
                 model_variant: str,
                 phrase_hints: Sequence[str],
                 sample_rate_hertz: int,
                 single_utterance: bool):
        """
        Instructs the speech recognizer on how to process the audio content.
        :param str audio_encoding: Required. Audio encoding of the audio content to process.
        :param bool enable_word_info: Optional. If `true`, Dialogflow returns SpeechWordInfo in StreamingRecognitionResult with information about the recognized speech words, e.g. start and end time offsets. If false or unspecified, Speech doesn't return any word-level information.
        :param str model: Optional. Which Speech model to select for the given request. Select the model best suited to your domain to get best results. If a model is not explicitly specified, then we auto-select a model based on the parameters in the InputAudioConfig. If enhanced speech model is enabled for the agent and an enhanced version of the specified model for the language does not exist, then the speech is recognized using the standard version of the specified model. Refer to [Cloud Speech API documentation](https://cloud.google.com/speech-to-text/docs/basics#select-model) for more details.
        :param str model_variant: Optional. Which variant of the Speech model to use.
        :param Sequence[str] phrase_hints: Optional. A list of strings containing words and phrases that the speech recognizer should recognize with higher likelihood. See [the Cloud Speech documentation](https://cloud.google.com/speech-to-text/docs/basics#phrase-hints) for more details.
        :param int sample_rate_hertz: Sample rate (in Hertz) of the audio content sent in the query. Refer to [Cloud Speech API documentation](https://cloud.google.com/speech-to-text/docs/basics) for more details.
        :param bool single_utterance: Optional. If `false` (default), recognition does not cease until the client closes the stream. If `true`, the recognizer will detect a single spoken utterance in input audio. Recognition ceases when it detects the audio's voice has stopped or paused. In this case, once a detected intent is received, the client should close the stream and start a new request with a new stream as needed. Note: This setting is relevant only for streaming methods.
        """
        pulumi.set(__self__, "audio_encoding", audio_encoding)
        pulumi.set(__self__, "enable_word_info", enable_word_info)
        pulumi.set(__self__, "model", model)
        pulumi.set(__self__, "model_variant", model_variant)
        pulumi.set(__self__, "phrase_hints", phrase_hints)
        pulumi.set(__self__, "sample_rate_hertz", sample_rate_hertz)
        pulumi.set(__self__, "single_utterance", single_utterance)

    @property
    @pulumi.getter(name="audioEncoding")
    def audio_encoding(self) -> str:
        """
        Required. Audio encoding of the audio content to process.
        """
        return pulumi.get(self, "audio_encoding")

    @property
    @pulumi.getter(name="enableWordInfo")
    def enable_word_info(self) -> bool:
        """
        Optional. If `true`, Dialogflow returns SpeechWordInfo in StreamingRecognitionResult with information about the recognized speech words, e.g. start and end time offsets. If false or unspecified, Speech doesn't return any word-level information.
        """
        return pulumi.get(self, "enable_word_info")

    @property
    @pulumi.getter
    def model(self) -> str:
        """
        Optional. Which Speech model to select for the given request. Select the model best suited to your domain to get best results. If a model is not explicitly specified, then we auto-select a model based on the parameters in the InputAudioConfig. If enhanced speech model is enabled for the agent and an enhanced version of the specified model for the language does not exist, then the speech is recognized using the standard version of the specified model. Refer to [Cloud Speech API documentation](https://cloud.google.com/speech-to-text/docs/basics#select-model) for more details.
        """
        return pulumi.get(self, "model")

    @property
    @pulumi.getter(name="modelVariant")
    def model_variant(self) -> str:
        """
        Optional. Which variant of the Speech model to use.
        """
        return pulumi.get(self, "model_variant")

    @property
    @pulumi.getter(name="phraseHints")
    def phrase_hints(self) -> Sequence[str]:
        """
        Optional. A list of strings containing words and phrases that the speech recognizer should recognize with higher likelihood. See [the Cloud Speech documentation](https://cloud.google.com/speech-to-text/docs/basics#phrase-hints) for more details.
        """
        return pulumi.get(self, "phrase_hints")

    @property
    @pulumi.getter(name="sampleRateHertz")
    def sample_rate_hertz(self) -> int:
        """
        Sample rate (in Hertz) of the audio content sent in the query. Refer to [Cloud Speech API documentation](https://cloud.google.com/speech-to-text/docs/basics) for more details.
        """
        return pulumi.get(self, "sample_rate_hertz")

    @property
    @pulumi.getter(name="singleUtterance")
    def single_utterance(self) -> bool:
        """
        Optional. If `false` (default), recognition does not cease until the client closes the stream. If `true`, the recognizer will detect a single spoken utterance in input audio. Recognition ceases when it detects the audio's voice has stopped or paused. In this case, once a detected intent is received, the client should close the stream and start a new request with a new stream as needed. Note: This setting is relevant only for streaming methods.
        """
        return pulumi.get(self, "single_utterance")


@pulumi.output_type
class GoogleCloudDialogflowCxV3beta1IntentInputResponse(dict):
    """
    Represents the intent to trigger programmatically rather than as a result of natural language processing.
    """
    def __init__(__self__, *,
                 intent: str):
        """
        Represents the intent to trigger programmatically rather than as a result of natural language processing.
        :param str intent: Required. The unique identifier of the intent. Format: `projects//locations//agents//intents/`.
        """
        pulumi.set(__self__, "intent", intent)

    @property
    @pulumi.getter
    def intent(self) -> str:
        """
        Required. The unique identifier of the intent. Format: `projects//locations//agents//intents/`.
        """
        return pulumi.get(self, "intent")


@pulumi.output_type
class GoogleCloudDialogflowCxV3beta1IntentParameterResponse(dict):
    """
    Represents an intent parameter.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "entityType":
            suggest = "entity_type"
        elif key == "isList":
            suggest = "is_list"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowCxV3beta1IntentParameterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowCxV3beta1IntentParameterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowCxV3beta1IntentParameterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 entity_type: str,
                 is_list: bool,
                 redact: bool):
        """
        Represents an intent parameter.
        :param str entity_type: Required. The entity type of the parameter. Format: `projects/-/locations/-/agents/-/entityTypes/` for system entity types (for example, `projects/-/locations/-/agents/-/entityTypes/sys.date`), or `projects//locations//agents//entityTypes/` for developer entity types.
        :param bool is_list: Indicates whether the parameter represents a list of values.
        :param bool redact: Indicates whether the parameter content should be redacted in log. If redaction is enabled, the parameter content will be replaced by parameter name during logging. Note: the parameter content is subject to redaction if either parameter level redaction or entity type level redaction is enabled.
        """
        pulumi.set(__self__, "entity_type", entity_type)
        pulumi.set(__self__, "is_list", is_list)
        pulumi.set(__self__, "redact", redact)

    @property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> str:
        """
        Required. The entity type of the parameter. Format: `projects/-/locations/-/agents/-/entityTypes/` for system entity types (for example, `projects/-/locations/-/agents/-/entityTypes/sys.date`), or `projects//locations//agents//entityTypes/` for developer entity types.
        """
        return pulumi.get(self, "entity_type")

    @property
    @pulumi.getter(name="isList")
    def is_list(self) -> bool:
        """
        Indicates whether the parameter represents a list of values.
        """
        return pulumi.get(self, "is_list")

    @property
    @pulumi.getter
    def redact(self) -> bool:
        """
        Indicates whether the parameter content should be redacted in log. If redaction is enabled, the parameter content will be replaced by parameter name during logging. Note: the parameter content is subject to redaction if either parameter level redaction or entity type level redaction is enabled.
        """
        return pulumi.get(self, "redact")


@pulumi.output_type
class GoogleCloudDialogflowCxV3beta1IntentResponse(dict):
    """
    An intent represents a user's intent to interact with a conversational agent. You can provide information for the Dialogflow API to use to match user input to an intent by adding training phrases (i.e., examples of user input) to your intent.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"
        elif key == "isFallback":
            suggest = "is_fallback"
        elif key == "trainingPhrases":
            suggest = "training_phrases"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowCxV3beta1IntentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowCxV3beta1IntentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowCxV3beta1IntentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: str,
                 display_name: str,
                 is_fallback: bool,
                 labels: Mapping[str, str],
                 name: str,
                 parameters: Sequence['outputs.GoogleCloudDialogflowCxV3beta1IntentParameterResponse'],
                 priority: int,
                 training_phrases: Sequence['outputs.GoogleCloudDialogflowCxV3beta1IntentTrainingPhraseResponse']):
        """
        An intent represents a user's intent to interact with a conversational agent. You can provide information for the Dialogflow API to use to match user input to an intent by adding training phrases (i.e., examples of user input) to your intent.
        :param str description: Human readable description for better understanding an intent like its scope, content, result etc. Maximum character limit: 140 characters.
        :param str display_name: Required. The human-readable name of the intent, unique within the agent.
        :param bool is_fallback: Indicates whether this is a fallback intent. Currently only default fallback intent is allowed in the agent, which is added upon agent creation. Adding training phrases to fallback intent is useful in the case of requests that are mistakenly matched, since training phrases assigned to fallback intents act as negative examples that triggers no-match event.
        :param Mapping[str, str] labels: The key/value metadata to label an intent. Labels can contain lowercase letters, digits and the symbols '-' and '_'. International characters are allowed, including letters from unicase alphabets. Keys must start with a letter. Keys and values can be no longer than 63 characters and no more than 128 bytes. Prefix "sys-" is reserved for Dialogflow defined labels. Currently allowed Dialogflow defined labels include: * sys-head * sys-contextual The above labels do not require value. "sys-head" means the intent is a head intent. "sys-contextual" means the intent is a contextual intent.
        :param str name: The unique identifier of the intent. Required for the Intents.UpdateIntent method. Intents.CreateIntent populates the name automatically. Format: `projects//locations//agents//intents/`.
        :param Sequence['GoogleCloudDialogflowCxV3beta1IntentParameterResponse'] parameters: The collection of parameters associated with the intent.
        :param int priority: The priority of this intent. Higher numbers represent higher priorities. - If the supplied value is unspecified or 0, the service translates the value to 500,000, which corresponds to the `Normal` priority in the console. - If the supplied value is negative, the intent is ignored in runtime detect intent requests.
        :param Sequence['GoogleCloudDialogflowCxV3beta1IntentTrainingPhraseResponse'] training_phrases: The collection of training phrases the agent is trained on to identify the intent.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "is_fallback", is_fallback)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "parameters", parameters)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "training_phrases", training_phrases)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Human readable description for better understanding an intent like its scope, content, result etc. Maximum character limit: 140 characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Required. The human-readable name of the intent, unique within the agent.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="isFallback")
    def is_fallback(self) -> bool:
        """
        Indicates whether this is a fallback intent. Currently only default fallback intent is allowed in the agent, which is added upon agent creation. Adding training phrases to fallback intent is useful in the case of requests that are mistakenly matched, since training phrases assigned to fallback intents act as negative examples that triggers no-match event.
        """
        return pulumi.get(self, "is_fallback")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        The key/value metadata to label an intent. Labels can contain lowercase letters, digits and the symbols '-' and '_'. International characters are allowed, including letters from unicase alphabets. Keys must start with a letter. Keys and values can be no longer than 63 characters and no more than 128 bytes. Prefix "sys-" is reserved for Dialogflow defined labels. Currently allowed Dialogflow defined labels include: * sys-head * sys-contextual The above labels do not require value. "sys-head" means the intent is a head intent. "sys-contextual" means the intent is a contextual intent.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique identifier of the intent. Required for the Intents.UpdateIntent method. Intents.CreateIntent populates the name automatically. Format: `projects//locations//agents//intents/`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> Sequence['outputs.GoogleCloudDialogflowCxV3beta1IntentParameterResponse']:
        """
        The collection of parameters associated with the intent.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def priority(self) -> int:
        """
        The priority of this intent. Higher numbers represent higher priorities. - If the supplied value is unspecified or 0, the service translates the value to 500,000, which corresponds to the `Normal` priority in the console. - If the supplied value is negative, the intent is ignored in runtime detect intent requests.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="trainingPhrases")
    def training_phrases(self) -> Sequence['outputs.GoogleCloudDialogflowCxV3beta1IntentTrainingPhraseResponse']:
        """
        The collection of training phrases the agent is trained on to identify the intent.
        """
        return pulumi.get(self, "training_phrases")


@pulumi.output_type
class GoogleCloudDialogflowCxV3beta1IntentTrainingPhrasePartResponse(dict):
    """
    Represents a part of a training phrase.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "parameterId":
            suggest = "parameter_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowCxV3beta1IntentTrainingPhrasePartResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowCxV3beta1IntentTrainingPhrasePartResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowCxV3beta1IntentTrainingPhrasePartResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 parameter_id: str,
                 text: str):
        """
        Represents a part of a training phrase.
        :param str parameter_id: The parameter used to annotate this part of the training phrase. This field is required for annotated parts of the training phrase.
        :param str text: Required. The text for this part.
        """
        pulumi.set(__self__, "parameter_id", parameter_id)
        pulumi.set(__self__, "text", text)

    @property
    @pulumi.getter(name="parameterId")
    def parameter_id(self) -> str:
        """
        The parameter used to annotate this part of the training phrase. This field is required for annotated parts of the training phrase.
        """
        return pulumi.get(self, "parameter_id")

    @property
    @pulumi.getter
    def text(self) -> str:
        """
        Required. The text for this part.
        """
        return pulumi.get(self, "text")


@pulumi.output_type
class GoogleCloudDialogflowCxV3beta1IntentTrainingPhraseResponse(dict):
    """
    Represents an example that the agent is trained on to identify the intent.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "repeatCount":
            suggest = "repeat_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowCxV3beta1IntentTrainingPhraseResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowCxV3beta1IntentTrainingPhraseResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowCxV3beta1IntentTrainingPhraseResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 parts: Sequence['outputs.GoogleCloudDialogflowCxV3beta1IntentTrainingPhrasePartResponse'],
                 repeat_count: int):
        """
        Represents an example that the agent is trained on to identify the intent.
        :param Sequence['GoogleCloudDialogflowCxV3beta1IntentTrainingPhrasePartResponse'] parts: Required. The ordered list of training phrase parts. The parts are concatenated in order to form the training phrase. Note: The API does not automatically annotate training phrases like the Dialogflow Console does. Note: Do not forget to include whitespace at part boundaries, so the training phrase is well formatted when the parts are concatenated. If the training phrase does not need to be annotated with parameters, you just need a single part with only the Part.text field set. If you want to annotate the training phrase, you must create multiple parts, where the fields of each part are populated in one of two ways: - `Part.text` is set to a part of the phrase that has no parameters. - `Part.text` is set to a part of the phrase that you want to annotate, and the `parameter_id` field is set.
        :param int repeat_count: Indicates how many times this example was added to the intent.
        """
        pulumi.set(__self__, "parts", parts)
        pulumi.set(__self__, "repeat_count", repeat_count)

    @property
    @pulumi.getter
    def parts(self) -> Sequence['outputs.GoogleCloudDialogflowCxV3beta1IntentTrainingPhrasePartResponse']:
        """
        Required. The ordered list of training phrase parts. The parts are concatenated in order to form the training phrase. Note: The API does not automatically annotate training phrases like the Dialogflow Console does. Note: Do not forget to include whitespace at part boundaries, so the training phrase is well formatted when the parts are concatenated. If the training phrase does not need to be annotated with parameters, you just need a single part with only the Part.text field set. If you want to annotate the training phrase, you must create multiple parts, where the fields of each part are populated in one of two ways: - `Part.text` is set to a part of the phrase that has no parameters. - `Part.text` is set to a part of the phrase that you want to annotate, and the `parameter_id` field is set.
        """
        return pulumi.get(self, "parts")

    @property
    @pulumi.getter(name="repeatCount")
    def repeat_count(self) -> int:
        """
        Indicates how many times this example was added to the intent.
        """
        return pulumi.get(self, "repeat_count")


@pulumi.output_type
class GoogleCloudDialogflowCxV3beta1NluSettingsResponse(dict):
    """
    Settings related to NLU.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "classificationThreshold":
            suggest = "classification_threshold"
        elif key == "modelTrainingMode":
            suggest = "model_training_mode"
        elif key == "modelType":
            suggest = "model_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowCxV3beta1NluSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowCxV3beta1NluSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowCxV3beta1NluSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 classification_threshold: float,
                 model_training_mode: str,
                 model_type: str):
        """
        Settings related to NLU.
        :param float classification_threshold: To filter out false positive results and still get variety in matched natural language inputs for your agent, you can tune the machine learning classification threshold. If the returned score value is less than the threshold value, then a no-match event will be triggered. The score values range from 0.0 (completely uncertain) to 1.0 (completely certain). If set to 0.0, the default of 0.3 is used.
        :param str model_training_mode: Indicates NLU model training mode.
        :param str model_type: Indicates the type of NLU model.
        """
        pulumi.set(__self__, "classification_threshold", classification_threshold)
        pulumi.set(__self__, "model_training_mode", model_training_mode)
        pulumi.set(__self__, "model_type", model_type)

    @property
    @pulumi.getter(name="classificationThreshold")
    def classification_threshold(self) -> float:
        """
        To filter out false positive results and still get variety in matched natural language inputs for your agent, you can tune the machine learning classification threshold. If the returned score value is less than the threshold value, then a no-match event will be triggered. The score values range from 0.0 (completely uncertain) to 1.0 (completely certain). If set to 0.0, the default of 0.3 is used.
        """
        return pulumi.get(self, "classification_threshold")

    @property
    @pulumi.getter(name="modelTrainingMode")
    def model_training_mode(self) -> str:
        """
        Indicates NLU model training mode.
        """
        return pulumi.get(self, "model_training_mode")

    @property
    @pulumi.getter(name="modelType")
    def model_type(self) -> str:
        """
        Indicates the type of NLU model.
        """
        return pulumi.get(self, "model_type")


@pulumi.output_type
class GoogleCloudDialogflowCxV3beta1PageResponse(dict):
    """
    A Dialogflow CX conversation (session) can be described and visualized as a state machine. The states of a CX session are represented by pages. For each flow, you define many pages, where your combined pages can handle a complete conversation on the topics the flow is designed for. At any given moment, exactly one page is the current page, the current page is considered active, and the flow associated with that page is considered active. Every flow has a special start page. When a flow initially becomes active, the start page page becomes the current page. For each conversational turn, the current page will either stay the same or transition to another page. You configure each page to collect information from the end-user that is relevant for the conversational state represented by the page. For more information, see the [Page guide](https://cloud.google.com/dialogflow/cx/docs/concept/page).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"
        elif key == "entryFulfillment":
            suggest = "entry_fulfillment"
        elif key == "eventHandlers":
            suggest = "event_handlers"
        elif key == "transitionRouteGroups":
            suggest = "transition_route_groups"
        elif key == "transitionRoutes":
            suggest = "transition_routes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowCxV3beta1PageResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowCxV3beta1PageResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowCxV3beta1PageResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: str,
                 entry_fulfillment: 'outputs.GoogleCloudDialogflowCxV3beta1FulfillmentResponse',
                 event_handlers: Sequence['outputs.GoogleCloudDialogflowCxV3beta1EventHandlerResponse'],
                 form: 'outputs.GoogleCloudDialogflowCxV3beta1FormResponse',
                 name: str,
                 transition_route_groups: Sequence[str],
                 transition_routes: Sequence['outputs.GoogleCloudDialogflowCxV3beta1TransitionRouteResponse']):
        """
        A Dialogflow CX conversation (session) can be described and visualized as a state machine. The states of a CX session are represented by pages. For each flow, you define many pages, where your combined pages can handle a complete conversation on the topics the flow is designed for. At any given moment, exactly one page is the current page, the current page is considered active, and the flow associated with that page is considered active. Every flow has a special start page. When a flow initially becomes active, the start page page becomes the current page. For each conversational turn, the current page will either stay the same or transition to another page. You configure each page to collect information from the end-user that is relevant for the conversational state represented by the page. For more information, see the [Page guide](https://cloud.google.com/dialogflow/cx/docs/concept/page).
        :param str display_name: Required. The human-readable name of the page, unique within the agent.
        :param 'GoogleCloudDialogflowCxV3beta1FulfillmentResponse' entry_fulfillment: The fulfillment to call when the session is entering the page.
        :param Sequence['GoogleCloudDialogflowCxV3beta1EventHandlerResponse'] event_handlers: Handlers associated with the page to handle events such as webhook errors, no match or no input.
        :param 'GoogleCloudDialogflowCxV3beta1FormResponse' form: The form associated with the page, used for collecting parameters relevant to the page.
        :param str name: The unique identifier of the page. Required for the Pages.UpdatePage method. Pages.CreatePage populates the name automatically. Format: `projects//locations//agents//flows//pages/`.
        :param Sequence[str] transition_route_groups: Ordered list of `TransitionRouteGroups` associated with the page. Transition route groups must be unique within a page. * If multiple transition routes within a page scope refer to the same intent, then the precedence order is: page's transition route -> page's transition route group -> flow's transition routes. * If multiple transition route groups within a page contain the same intent, then the first group in the ordered list takes precedence. Format:`projects//locations//agents//flows//transitionRouteGroups/`.
        :param Sequence['GoogleCloudDialogflowCxV3beta1TransitionRouteResponse'] transition_routes: A list of transitions for the transition rules of this page. They route the conversation to another page in the same flow, or another flow. When we are in a certain page, the TransitionRoutes are evalauted in the following order: * TransitionRoutes defined in the page with intent specified. * TransitionRoutes defined in the transition route groups with intent specified. * TransitionRoutes defined in flow with intent specified. * TransitionRoutes defined in the transition route groups with intent specified. * TransitionRoutes defined in the page with only condition specified. * TransitionRoutes defined in the transition route groups with only condition specified.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "entry_fulfillment", entry_fulfillment)
        pulumi.set(__self__, "event_handlers", event_handlers)
        pulumi.set(__self__, "form", form)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "transition_route_groups", transition_route_groups)
        pulumi.set(__self__, "transition_routes", transition_routes)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Required. The human-readable name of the page, unique within the agent.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="entryFulfillment")
    def entry_fulfillment(self) -> 'outputs.GoogleCloudDialogflowCxV3beta1FulfillmentResponse':
        """
        The fulfillment to call when the session is entering the page.
        """
        return pulumi.get(self, "entry_fulfillment")

    @property
    @pulumi.getter(name="eventHandlers")
    def event_handlers(self) -> Sequence['outputs.GoogleCloudDialogflowCxV3beta1EventHandlerResponse']:
        """
        Handlers associated with the page to handle events such as webhook errors, no match or no input.
        """
        return pulumi.get(self, "event_handlers")

    @property
    @pulumi.getter
    def form(self) -> 'outputs.GoogleCloudDialogflowCxV3beta1FormResponse':
        """
        The form associated with the page, used for collecting parameters relevant to the page.
        """
        return pulumi.get(self, "form")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique identifier of the page. Required for the Pages.UpdatePage method. Pages.CreatePage populates the name automatically. Format: `projects//locations//agents//flows//pages/`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="transitionRouteGroups")
    def transition_route_groups(self) -> Sequence[str]:
        """
        Ordered list of `TransitionRouteGroups` associated with the page. Transition route groups must be unique within a page. * If multiple transition routes within a page scope refer to the same intent, then the precedence order is: page's transition route -> page's transition route group -> flow's transition routes. * If multiple transition route groups within a page contain the same intent, then the first group in the ordered list takes precedence. Format:`projects//locations//agents//flows//transitionRouteGroups/`.
        """
        return pulumi.get(self, "transition_route_groups")

    @property
    @pulumi.getter(name="transitionRoutes")
    def transition_routes(self) -> Sequence['outputs.GoogleCloudDialogflowCxV3beta1TransitionRouteResponse']:
        """
        A list of transitions for the transition rules of this page. They route the conversation to another page in the same flow, or another flow. When we are in a certain page, the TransitionRoutes are evalauted in the following order: * TransitionRoutes defined in the page with intent specified. * TransitionRoutes defined in the transition route groups with intent specified. * TransitionRoutes defined in flow with intent specified. * TransitionRoutes defined in the transition route groups with intent specified. * TransitionRoutes defined in the page with only condition specified. * TransitionRoutes defined in the transition route groups with only condition specified.
        """
        return pulumi.get(self, "transition_routes")


@pulumi.output_type
class GoogleCloudDialogflowCxV3beta1QueryInputResponse(dict):
    """
    Represents the query input. It can contain one of: 1. A conversational query in the form of text. 2. An intent query that specifies which intent to trigger. 3. Natural language speech audio to be processed. 4. An event to be triggered. 
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "languageCode":
            suggest = "language_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowCxV3beta1QueryInputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowCxV3beta1QueryInputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowCxV3beta1QueryInputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audio: 'outputs.GoogleCloudDialogflowCxV3beta1AudioInputResponse',
                 dtmf: 'outputs.GoogleCloudDialogflowCxV3beta1DtmfInputResponse',
                 event: 'outputs.GoogleCloudDialogflowCxV3beta1EventInputResponse',
                 intent: 'outputs.GoogleCloudDialogflowCxV3beta1IntentInputResponse',
                 language_code: str,
                 text: 'outputs.GoogleCloudDialogflowCxV3beta1TextInputResponse'):
        """
        Represents the query input. It can contain one of: 1. A conversational query in the form of text. 2. An intent query that specifies which intent to trigger. 3. Natural language speech audio to be processed. 4. An event to be triggered. 
        :param 'GoogleCloudDialogflowCxV3beta1AudioInputResponse' audio: The natural language speech audio to be processed.
        :param 'GoogleCloudDialogflowCxV3beta1DtmfInputResponse' dtmf: The DTMF event to be handled.
        :param 'GoogleCloudDialogflowCxV3beta1EventInputResponse' event: The event to be triggered.
        :param 'GoogleCloudDialogflowCxV3beta1IntentInputResponse' intent: The intent to be triggered.
        :param str language_code: Required. The language of the input. See [Language Support](https://cloud.google.com/dialogflow/cx/docs/reference/language) for a list of the currently supported language codes. Note that queries in the same session do not necessarily need to specify the same language.
        :param 'GoogleCloudDialogflowCxV3beta1TextInputResponse' text: The natural language text to be processed.
        """
        pulumi.set(__self__, "audio", audio)
        pulumi.set(__self__, "dtmf", dtmf)
        pulumi.set(__self__, "event", event)
        pulumi.set(__self__, "intent", intent)
        pulumi.set(__self__, "language_code", language_code)
        pulumi.set(__self__, "text", text)

    @property
    @pulumi.getter
    def audio(self) -> 'outputs.GoogleCloudDialogflowCxV3beta1AudioInputResponse':
        """
        The natural language speech audio to be processed.
        """
        return pulumi.get(self, "audio")

    @property
    @pulumi.getter
    def dtmf(self) -> 'outputs.GoogleCloudDialogflowCxV3beta1DtmfInputResponse':
        """
        The DTMF event to be handled.
        """
        return pulumi.get(self, "dtmf")

    @property
    @pulumi.getter
    def event(self) -> 'outputs.GoogleCloudDialogflowCxV3beta1EventInputResponse':
        """
        The event to be triggered.
        """
        return pulumi.get(self, "event")

    @property
    @pulumi.getter
    def intent(self) -> 'outputs.GoogleCloudDialogflowCxV3beta1IntentInputResponse':
        """
        The intent to be triggered.
        """
        return pulumi.get(self, "intent")

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> str:
        """
        Required. The language of the input. See [Language Support](https://cloud.google.com/dialogflow/cx/docs/reference/language) for a list of the currently supported language codes. Note that queries in the same session do not necessarily need to specify the same language.
        """
        return pulumi.get(self, "language_code")

    @property
    @pulumi.getter
    def text(self) -> 'outputs.GoogleCloudDialogflowCxV3beta1TextInputResponse':
        """
        The natural language text to be processed.
        """
        return pulumi.get(self, "text")


@pulumi.output_type
class GoogleCloudDialogflowCxV3beta1ResponseMessageConversationSuccessResponse(dict):
    """
    Indicates that the conversation succeeded, i.e., the bot handled the issue that the customer talked to it about. Dialogflow only uses this to determine which conversations should be counted as successful and doesn't process the metadata in this message in any way. Note that Dialogflow also considers conversations that get to the conversation end page as successful even if they don't return ConversationSuccess. You may set this, for example: * In the entry_fulfillment of a Page if entering the page indicates that the conversation succeeded. * In a webhook response when you determine that you handled the customer issue.
    """
    def __init__(__self__, *,
                 metadata: Mapping[str, str]):
        """
        Indicates that the conversation succeeded, i.e., the bot handled the issue that the customer talked to it about. Dialogflow only uses this to determine which conversations should be counted as successful and doesn't process the metadata in this message in any way. Note that Dialogflow also considers conversations that get to the conversation end page as successful even if they don't return ConversationSuccess. You may set this, for example: * In the entry_fulfillment of a Page if entering the page indicates that the conversation succeeded. * In a webhook response when you determine that you handled the customer issue.
        :param Mapping[str, str] metadata: Custom metadata. Dialogflow doesn't impose any structure on this.
        """
        pulumi.set(__self__, "metadata", metadata)

    @property
    @pulumi.getter
    def metadata(self) -> Mapping[str, str]:
        """
        Custom metadata. Dialogflow doesn't impose any structure on this.
        """
        return pulumi.get(self, "metadata")


@pulumi.output_type
class GoogleCloudDialogflowCxV3beta1ResponseMessageEndInteractionResponse(dict):
    """
    Indicates that interaction with the Dialogflow agent has ended. This message is generated by Dialogflow only and not supposed to be defined by the user.
    """
    def __init__(__self__):
        """
        Indicates that interaction with the Dialogflow agent has ended. This message is generated by Dialogflow only and not supposed to be defined by the user.
        """
        pass


@pulumi.output_type
class GoogleCloudDialogflowCxV3beta1ResponseMessageLiveAgentHandoffResponse(dict):
    """
    Indicates that the conversation should be handed off to a live agent. Dialogflow only uses this to determine which conversations were handed off to a human agent for measurement purposes. What else to do with this signal is up to you and your handoff procedures. You may set this, for example: * In the entry_fulfillment of a Page if entering the page indicates something went extremely wrong in the conversation. * In a webhook response when you determine that the customer issue can only be handled by a human.
    """
    def __init__(__self__, *,
                 metadata: Mapping[str, str]):
        """
        Indicates that the conversation should be handed off to a live agent. Dialogflow only uses this to determine which conversations were handed off to a human agent for measurement purposes. What else to do with this signal is up to you and your handoff procedures. You may set this, for example: * In the entry_fulfillment of a Page if entering the page indicates something went extremely wrong in the conversation. * In a webhook response when you determine that the customer issue can only be handled by a human.
        :param Mapping[str, str] metadata: Custom metadata for your handoff procedure. Dialogflow doesn't impose any structure on this.
        """
        pulumi.set(__self__, "metadata", metadata)

    @property
    @pulumi.getter
    def metadata(self) -> Mapping[str, str]:
        """
        Custom metadata for your handoff procedure. Dialogflow doesn't impose any structure on this.
        """
        return pulumi.get(self, "metadata")


@pulumi.output_type
class GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudioResponse(dict):
    """
    Represents an audio message that is composed of both segments synthesized from the Dialogflow agent prompts and ones hosted externally at the specified URIs. The external URIs are specified via play_audio. This message is generated by Dialogflow only and not supposed to be defined by the user.
    """
    def __init__(__self__, *,
                 segments: Sequence['outputs.GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudioSegmentResponse']):
        """
        Represents an audio message that is composed of both segments synthesized from the Dialogflow agent prompts and ones hosted externally at the specified URIs. The external URIs are specified via play_audio. This message is generated by Dialogflow only and not supposed to be defined by the user.
        :param Sequence['GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudioSegmentResponse'] segments: Segments this audio response is composed of.
        """
        pulumi.set(__self__, "segments", segments)

    @property
    @pulumi.getter
    def segments(self) -> Sequence['outputs.GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudioSegmentResponse']:
        """
        Segments this audio response is composed of.
        """
        return pulumi.get(self, "segments")


@pulumi.output_type
class GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudioSegmentResponse(dict):
    """
    Represents one segment of audio.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowPlaybackInterruption":
            suggest = "allow_playback_interruption"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudioSegmentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudioSegmentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudioSegmentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_playback_interruption: bool,
                 audio: str,
                 uri: str):
        """
        Represents one segment of audio.
        :param bool allow_playback_interruption: Whether the playback of this segment can be interrupted by the end user's speech and the client should then start the next Dialogflow request.
        :param str audio: Raw audio synthesized from the Dialogflow agent's response using the output config specified in the request.
        :param str uri: Client-specific URI that points to an audio clip accessible to the client. Dialogflow does not impose any validation on it.
        """
        pulumi.set(__self__, "allow_playback_interruption", allow_playback_interruption)
        pulumi.set(__self__, "audio", audio)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="allowPlaybackInterruption")
    def allow_playback_interruption(self) -> bool:
        """
        Whether the playback of this segment can be interrupted by the end user's speech and the client should then start the next Dialogflow request.
        """
        return pulumi.get(self, "allow_playback_interruption")

    @property
    @pulumi.getter
    def audio(self) -> str:
        """
        Raw audio synthesized from the Dialogflow agent's response using the output config specified in the request.
        """
        return pulumi.get(self, "audio")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        Client-specific URI that points to an audio clip accessible to the client. Dialogflow does not impose any validation on it.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class GoogleCloudDialogflowCxV3beta1ResponseMessageOutputAudioTextResponse(dict):
    """
    A text or ssml response that is preferentially used for TTS output audio synthesis, as described in the comment on the ResponseMessage message.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowPlaybackInterruption":
            suggest = "allow_playback_interruption"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowCxV3beta1ResponseMessageOutputAudioTextResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowCxV3beta1ResponseMessageOutputAudioTextResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowCxV3beta1ResponseMessageOutputAudioTextResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_playback_interruption: bool,
                 ssml: str,
                 text: str):
        """
        A text or ssml response that is preferentially used for TTS output audio synthesis, as described in the comment on the ResponseMessage message.
        :param bool allow_playback_interruption: Whether the playback of this message can be interrupted by the end user's speech and the client can then starts the next Dialogflow request.
        :param str ssml: The SSML text to be synthesized. For more information, see [SSML](/speech/text-to-speech/docs/ssml).
        :param str text: The raw text to be synthesized.
        """
        pulumi.set(__self__, "allow_playback_interruption", allow_playback_interruption)
        pulumi.set(__self__, "ssml", ssml)
        pulumi.set(__self__, "text", text)

    @property
    @pulumi.getter(name="allowPlaybackInterruption")
    def allow_playback_interruption(self) -> bool:
        """
        Whether the playback of this message can be interrupted by the end user's speech and the client can then starts the next Dialogflow request.
        """
        return pulumi.get(self, "allow_playback_interruption")

    @property
    @pulumi.getter
    def ssml(self) -> str:
        """
        The SSML text to be synthesized. For more information, see [SSML](/speech/text-to-speech/docs/ssml).
        """
        return pulumi.get(self, "ssml")

    @property
    @pulumi.getter
    def text(self) -> str:
        """
        The raw text to be synthesized.
        """
        return pulumi.get(self, "text")


@pulumi.output_type
class GoogleCloudDialogflowCxV3beta1ResponseMessagePlayAudioResponse(dict):
    """
    Specifies an audio clip to be played by the client as part of the response.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowPlaybackInterruption":
            suggest = "allow_playback_interruption"
        elif key == "audioUri":
            suggest = "audio_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowCxV3beta1ResponseMessagePlayAudioResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowCxV3beta1ResponseMessagePlayAudioResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowCxV3beta1ResponseMessagePlayAudioResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_playback_interruption: bool,
                 audio_uri: str):
        """
        Specifies an audio clip to be played by the client as part of the response.
        :param bool allow_playback_interruption: Whether the playback of this message can be interrupted by the end user's speech and the client can then starts the next Dialogflow request.
        :param str audio_uri: Required. URI of the audio clip. Dialogflow does not impose any validation on this value. It is specific to the client that reads it.
        """
        pulumi.set(__self__, "allow_playback_interruption", allow_playback_interruption)
        pulumi.set(__self__, "audio_uri", audio_uri)

    @property
    @pulumi.getter(name="allowPlaybackInterruption")
    def allow_playback_interruption(self) -> bool:
        """
        Whether the playback of this message can be interrupted by the end user's speech and the client can then starts the next Dialogflow request.
        """
        return pulumi.get(self, "allow_playback_interruption")

    @property
    @pulumi.getter(name="audioUri")
    def audio_uri(self) -> str:
        """
        Required. URI of the audio clip. Dialogflow does not impose any validation on this value. It is specific to the client that reads it.
        """
        return pulumi.get(self, "audio_uri")


@pulumi.output_type
class GoogleCloudDialogflowCxV3beta1ResponseMessageResponse(dict):
    """
    Represents a response message that can be returned by a conversational agent. Response messages are also used for output audio synthesis. The approach is as follows: * If at least one OutputAudioText response is present, then all OutputAudioText responses are linearly concatenated, and the result is used for output audio synthesis. * If the OutputAudioText responses are a mixture of text and SSML, then the concatenated result is treated as SSML; otherwise, the result is treated as either text or SSML as appropriate. The agent designer should ideally use either text or SSML consistently throughout the bot design. * Otherwise, all Text responses are linearly concatenated, and the result is used for output audio synthesis. This approach allows for more sophisticated user experience scenarios, where the text displayed to the user may differ from what is heard.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "conversationSuccess":
            suggest = "conversation_success"
        elif key == "endInteraction":
            suggest = "end_interaction"
        elif key == "liveAgentHandoff":
            suggest = "live_agent_handoff"
        elif key == "mixedAudio":
            suggest = "mixed_audio"
        elif key == "outputAudioText":
            suggest = "output_audio_text"
        elif key == "playAudio":
            suggest = "play_audio"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowCxV3beta1ResponseMessageResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowCxV3beta1ResponseMessageResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowCxV3beta1ResponseMessageResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 conversation_success: 'outputs.GoogleCloudDialogflowCxV3beta1ResponseMessageConversationSuccessResponse',
                 end_interaction: 'outputs.GoogleCloudDialogflowCxV3beta1ResponseMessageEndInteractionResponse',
                 live_agent_handoff: 'outputs.GoogleCloudDialogflowCxV3beta1ResponseMessageLiveAgentHandoffResponse',
                 mixed_audio: 'outputs.GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudioResponse',
                 output_audio_text: 'outputs.GoogleCloudDialogflowCxV3beta1ResponseMessageOutputAudioTextResponse',
                 payload: Mapping[str, str],
                 play_audio: 'outputs.GoogleCloudDialogflowCxV3beta1ResponseMessagePlayAudioResponse',
                 text: 'outputs.GoogleCloudDialogflowCxV3beta1ResponseMessageTextResponse'):
        """
        Represents a response message that can be returned by a conversational agent. Response messages are also used for output audio synthesis. The approach is as follows: * If at least one OutputAudioText response is present, then all OutputAudioText responses are linearly concatenated, and the result is used for output audio synthesis. * If the OutputAudioText responses are a mixture of text and SSML, then the concatenated result is treated as SSML; otherwise, the result is treated as either text or SSML as appropriate. The agent designer should ideally use either text or SSML consistently throughout the bot design. * Otherwise, all Text responses are linearly concatenated, and the result is used for output audio synthesis. This approach allows for more sophisticated user experience scenarios, where the text displayed to the user may differ from what is heard.
        :param 'GoogleCloudDialogflowCxV3beta1ResponseMessageConversationSuccessResponse' conversation_success: Indicates that the conversation succeeded.
        :param 'GoogleCloudDialogflowCxV3beta1ResponseMessageEndInteractionResponse' end_interaction: A signal that indicates the interaction with the Dialogflow agent has ended. This message is generated by Dialogflow only when the conversation reaches `END_SESSION` page. It is not supposed to be defined by the user. It's guaranteed that there is at most one such message in each response.
        :param 'GoogleCloudDialogflowCxV3beta1ResponseMessageLiveAgentHandoffResponse' live_agent_handoff: Hands off conversation to a human agent.
        :param 'GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudioResponse' mixed_audio: An audio response message composed of both the synthesized Dialogflow agent responses and responses defined via play_audio. This message is generated by Dialogflow only and not supposed to be defined by the user.
        :param 'GoogleCloudDialogflowCxV3beta1ResponseMessageOutputAudioTextResponse' output_audio_text: A text or ssml response that is preferentially used for TTS output audio synthesis, as described in the comment on the ResponseMessage message.
        :param Mapping[str, str] payload: Returns a response containing a custom, platform-specific payload.
        :param 'GoogleCloudDialogflowCxV3beta1ResponseMessagePlayAudioResponse' play_audio: Signal that the client should play an audio clip hosted at a client-specific URI. Dialogflow uses this to construct mixed_audio. However, Dialogflow itself does not try to read or process the URI in any way.
        :param 'GoogleCloudDialogflowCxV3beta1ResponseMessageTextResponse' text: Returns a text response.
        """
        pulumi.set(__self__, "conversation_success", conversation_success)
        pulumi.set(__self__, "end_interaction", end_interaction)
        pulumi.set(__self__, "live_agent_handoff", live_agent_handoff)
        pulumi.set(__self__, "mixed_audio", mixed_audio)
        pulumi.set(__self__, "output_audio_text", output_audio_text)
        pulumi.set(__self__, "payload", payload)
        pulumi.set(__self__, "play_audio", play_audio)
        pulumi.set(__self__, "text", text)

    @property
    @pulumi.getter(name="conversationSuccess")
    def conversation_success(self) -> 'outputs.GoogleCloudDialogflowCxV3beta1ResponseMessageConversationSuccessResponse':
        """
        Indicates that the conversation succeeded.
        """
        return pulumi.get(self, "conversation_success")

    @property
    @pulumi.getter(name="endInteraction")
    def end_interaction(self) -> 'outputs.GoogleCloudDialogflowCxV3beta1ResponseMessageEndInteractionResponse':
        """
        A signal that indicates the interaction with the Dialogflow agent has ended. This message is generated by Dialogflow only when the conversation reaches `END_SESSION` page. It is not supposed to be defined by the user. It's guaranteed that there is at most one such message in each response.
        """
        return pulumi.get(self, "end_interaction")

    @property
    @pulumi.getter(name="liveAgentHandoff")
    def live_agent_handoff(self) -> 'outputs.GoogleCloudDialogflowCxV3beta1ResponseMessageLiveAgentHandoffResponse':
        """
        Hands off conversation to a human agent.
        """
        return pulumi.get(self, "live_agent_handoff")

    @property
    @pulumi.getter(name="mixedAudio")
    def mixed_audio(self) -> 'outputs.GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudioResponse':
        """
        An audio response message composed of both the synthesized Dialogflow agent responses and responses defined via play_audio. This message is generated by Dialogflow only and not supposed to be defined by the user.
        """
        return pulumi.get(self, "mixed_audio")

    @property
    @pulumi.getter(name="outputAudioText")
    def output_audio_text(self) -> 'outputs.GoogleCloudDialogflowCxV3beta1ResponseMessageOutputAudioTextResponse':
        """
        A text or ssml response that is preferentially used for TTS output audio synthesis, as described in the comment on the ResponseMessage message.
        """
        return pulumi.get(self, "output_audio_text")

    @property
    @pulumi.getter
    def payload(self) -> Mapping[str, str]:
        """
        Returns a response containing a custom, platform-specific payload.
        """
        return pulumi.get(self, "payload")

    @property
    @pulumi.getter(name="playAudio")
    def play_audio(self) -> 'outputs.GoogleCloudDialogflowCxV3beta1ResponseMessagePlayAudioResponse':
        """
        Signal that the client should play an audio clip hosted at a client-specific URI. Dialogflow uses this to construct mixed_audio. However, Dialogflow itself does not try to read or process the URI in any way.
        """
        return pulumi.get(self, "play_audio")

    @property
    @pulumi.getter
    def text(self) -> 'outputs.GoogleCloudDialogflowCxV3beta1ResponseMessageTextResponse':
        """
        Returns a text response.
        """
        return pulumi.get(self, "text")


@pulumi.output_type
class GoogleCloudDialogflowCxV3beta1ResponseMessageTextResponse(dict):
    """
    The text response message.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowPlaybackInterruption":
            suggest = "allow_playback_interruption"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowCxV3beta1ResponseMessageTextResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowCxV3beta1ResponseMessageTextResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowCxV3beta1ResponseMessageTextResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_playback_interruption: bool,
                 text: Sequence[str]):
        """
        The text response message.
        :param bool allow_playback_interruption: Whether the playback of this message can be interrupted by the end user's speech and the client can then starts the next Dialogflow request.
        :param Sequence[str] text: Required. A collection of text responses.
        """
        pulumi.set(__self__, "allow_playback_interruption", allow_playback_interruption)
        pulumi.set(__self__, "text", text)

    @property
    @pulumi.getter(name="allowPlaybackInterruption")
    def allow_playback_interruption(self) -> bool:
        """
        Whether the playback of this message can be interrupted by the end user's speech and the client can then starts the next Dialogflow request.
        """
        return pulumi.get(self, "allow_playback_interruption")

    @property
    @pulumi.getter
    def text(self) -> Sequence[str]:
        """
        Required. A collection of text responses.
        """
        return pulumi.get(self, "text")


@pulumi.output_type
class GoogleCloudDialogflowCxV3beta1SpeechToTextSettingsResponse(dict):
    """
    Settings related to speech recognition.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableSpeechAdaptation":
            suggest = "enable_speech_adaptation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowCxV3beta1SpeechToTextSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowCxV3beta1SpeechToTextSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowCxV3beta1SpeechToTextSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_speech_adaptation: bool):
        """
        Settings related to speech recognition.
        :param bool enable_speech_adaptation: Whether to use speech adaptation for speech recognition.
        """
        pulumi.set(__self__, "enable_speech_adaptation", enable_speech_adaptation)

    @property
    @pulumi.getter(name="enableSpeechAdaptation")
    def enable_speech_adaptation(self) -> bool:
        """
        Whether to use speech adaptation for speech recognition.
        """
        return pulumi.get(self, "enable_speech_adaptation")


@pulumi.output_type
class GoogleCloudDialogflowCxV3beta1TestCaseResultResponse(dict):
    """
    Represents a result from running a test case in an agent environment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "conversationTurns":
            suggest = "conversation_turns"
        elif key == "testResult":
            suggest = "test_result"
        elif key == "testTime":
            suggest = "test_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowCxV3beta1TestCaseResultResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowCxV3beta1TestCaseResultResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowCxV3beta1TestCaseResultResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 conversation_turns: Sequence['outputs.GoogleCloudDialogflowCxV3beta1ConversationTurnResponse'],
                 environment: str,
                 name: str,
                 test_result: str,
                 test_time: str):
        """
        Represents a result from running a test case in an agent environment.
        :param Sequence['GoogleCloudDialogflowCxV3beta1ConversationTurnResponse'] conversation_turns: The conversation turns uttered during the test case replay in chronological order.
        :param str environment: Environment where the test was run. If not set, it indicates the draft environment.
        :param str name: The resource name for the test case result. Format: `projects//locations//agents//testCases/ /results/`.
        :param str test_result: Whether the test case passed in the agent environment.
        :param str test_time: The time that the test was run.
        """
        pulumi.set(__self__, "conversation_turns", conversation_turns)
        pulumi.set(__self__, "environment", environment)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "test_result", test_result)
        pulumi.set(__self__, "test_time", test_time)

    @property
    @pulumi.getter(name="conversationTurns")
    def conversation_turns(self) -> Sequence['outputs.GoogleCloudDialogflowCxV3beta1ConversationTurnResponse']:
        """
        The conversation turns uttered during the test case replay in chronological order.
        """
        return pulumi.get(self, "conversation_turns")

    @property
    @pulumi.getter
    def environment(self) -> str:
        """
        Environment where the test was run. If not set, it indicates the draft environment.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The resource name for the test case result. Format: `projects//locations//agents//testCases/ /results/`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="testResult")
    def test_result(self) -> str:
        """
        Whether the test case passed in the agent environment.
        """
        return pulumi.get(self, "test_result")

    @property
    @pulumi.getter(name="testTime")
    def test_time(self) -> str:
        """
        The time that the test was run.
        """
        return pulumi.get(self, "test_time")


@pulumi.output_type
class GoogleCloudDialogflowCxV3beta1TestConfigResponse(dict):
    """
    Represents configurations for a test case.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "trackingParameters":
            suggest = "tracking_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowCxV3beta1TestConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowCxV3beta1TestConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowCxV3beta1TestConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 flow: str,
                 tracking_parameters: Sequence[str]):
        """
        Represents configurations for a test case.
        :param str flow: Flow name. If not set, default start flow is assumed. Format: `projects//locations//agents//flows/`.
        :param Sequence[str] tracking_parameters: Session parameters to be compared when calculating differences.
        """
        pulumi.set(__self__, "flow", flow)
        pulumi.set(__self__, "tracking_parameters", tracking_parameters)

    @property
    @pulumi.getter
    def flow(self) -> str:
        """
        Flow name. If not set, default start flow is assumed. Format: `projects//locations//agents//flows/`.
        """
        return pulumi.get(self, "flow")

    @property
    @pulumi.getter(name="trackingParameters")
    def tracking_parameters(self) -> Sequence[str]:
        """
        Session parameters to be compared when calculating differences.
        """
        return pulumi.get(self, "tracking_parameters")


@pulumi.output_type
class GoogleCloudDialogflowCxV3beta1TestRunDifferenceResponse(dict):
    """
    The description of differences between original and replayed agent output.
    """
    def __init__(__self__, *,
                 description: str,
                 type: str):
        """
        The description of differences between original and replayed agent output.
        :param str description: A description of the diff, showing the actual output vs expected output.
        :param str type: The type of diff.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A description of the diff, showing the actual output vs expected output.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of diff.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GoogleCloudDialogflowCxV3beta1TextInputResponse(dict):
    """
    Represents the natural language text to be processed.
    """
    def __init__(__self__, *,
                 text: str):
        """
        Represents the natural language text to be processed.
        :param str text: Required. The UTF-8 encoded natural language text to be processed. Text length must not exceed 256 characters.
        """
        pulumi.set(__self__, "text", text)

    @property
    @pulumi.getter
    def text(self) -> str:
        """
        Required. The UTF-8 encoded natural language text to be processed. Text length must not exceed 256 characters.
        """
        return pulumi.get(self, "text")


@pulumi.output_type
class GoogleCloudDialogflowCxV3beta1TransitionRouteResponse(dict):
    """
    A transition route specifies a intent that can be matched and/or a data condition that can be evaluated during a session. When a specified transition is matched, the following actions are taken in order: * If there is a `trigger_fulfillment` associated with the transition, it will be called. * If there is a `target_page` associated with the transition, the session will transition into the specified page. * If there is a `target_flow` associated with the transition, the session will transition into the specified flow.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetFlow":
            suggest = "target_flow"
        elif key == "targetPage":
            suggest = "target_page"
        elif key == "triggerFulfillment":
            suggest = "trigger_fulfillment"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowCxV3beta1TransitionRouteResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowCxV3beta1TransitionRouteResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowCxV3beta1TransitionRouteResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 condition: str,
                 intent: str,
                 name: str,
                 target_flow: str,
                 target_page: str,
                 trigger_fulfillment: 'outputs.GoogleCloudDialogflowCxV3beta1FulfillmentResponse'):
        """
        A transition route specifies a intent that can be matched and/or a data condition that can be evaluated during a session. When a specified transition is matched, the following actions are taken in order: * If there is a `trigger_fulfillment` associated with the transition, it will be called. * If there is a `target_page` associated with the transition, the session will transition into the specified page. * If there is a `target_flow` associated with the transition, the session will transition into the specified flow.
        :param str condition: The condition to evaluate against form parameters or session parameters. See the [conditions reference](https://cloud.google.com/dialogflow/cx/docs/reference/condition). At least one of `intent` or `condition` must be specified. When both `intent` and `condition` are specified, the transition can only happen when both are fulfilled.
        :param str intent: The unique identifier of an Intent. Format: `projects//locations//agents//intents/`. Indicates that the transition can only happen when the given intent is matched. At least one of `intent` or `condition` must be specified. When both `intent` and `condition` are specified, the transition can only happen when both are fulfilled.
        :param str name: The unique identifier of this transition route.
        :param str target_flow: The target flow to transition to. Format: `projects//locations//agents//flows/`.
        :param str target_page: The target page to transition to. Format: `projects//locations//agents//flows//pages/`.
        :param 'GoogleCloudDialogflowCxV3beta1FulfillmentResponse' trigger_fulfillment: The fulfillment to call when the condition is satisfied. At least one of `trigger_fulfillment` and `target` must be specified. When both are defined, `trigger_fulfillment` is executed first.
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "intent", intent)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "target_flow", target_flow)
        pulumi.set(__self__, "target_page", target_page)
        pulumi.set(__self__, "trigger_fulfillment", trigger_fulfillment)

    @property
    @pulumi.getter
    def condition(self) -> str:
        """
        The condition to evaluate against form parameters or session parameters. See the [conditions reference](https://cloud.google.com/dialogflow/cx/docs/reference/condition). At least one of `intent` or `condition` must be specified. When both `intent` and `condition` are specified, the transition can only happen when both are fulfilled.
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def intent(self) -> str:
        """
        The unique identifier of an Intent. Format: `projects//locations//agents//intents/`. Indicates that the transition can only happen when the given intent is matched. At least one of `intent` or `condition` must be specified. When both `intent` and `condition` are specified, the transition can only happen when both are fulfilled.
        """
        return pulumi.get(self, "intent")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique identifier of this transition route.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="targetFlow")
    def target_flow(self) -> str:
        """
        The target flow to transition to. Format: `projects//locations//agents//flows/`.
        """
        return pulumi.get(self, "target_flow")

    @property
    @pulumi.getter(name="targetPage")
    def target_page(self) -> str:
        """
        The target page to transition to. Format: `projects//locations//agents//flows//pages/`.
        """
        return pulumi.get(self, "target_page")

    @property
    @pulumi.getter(name="triggerFulfillment")
    def trigger_fulfillment(self) -> 'outputs.GoogleCloudDialogflowCxV3beta1FulfillmentResponse':
        """
        The fulfillment to call when the condition is satisfied. At least one of `trigger_fulfillment` and `target` must be specified. When both are defined, `trigger_fulfillment` is executed first.
        """
        return pulumi.get(self, "trigger_fulfillment")


@pulumi.output_type
class GoogleCloudDialogflowCxV3beta1VariantsHistoryResponse(dict):
    """
    The history of variants update.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "updateTime":
            suggest = "update_time"
        elif key == "versionVariants":
            suggest = "version_variants"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowCxV3beta1VariantsHistoryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowCxV3beta1VariantsHistoryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowCxV3beta1VariantsHistoryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 update_time: str,
                 version_variants: 'outputs.GoogleCloudDialogflowCxV3beta1VersionVariantsResponse'):
        """
        The history of variants update.
        :param str update_time: Update time of the variants.
        :param 'GoogleCloudDialogflowCxV3beta1VersionVariantsResponse' version_variants: The flow versions as the variants.
        """
        pulumi.set(__self__, "update_time", update_time)
        pulumi.set(__self__, "version_variants", version_variants)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        Update time of the variants.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="versionVariants")
    def version_variants(self) -> 'outputs.GoogleCloudDialogflowCxV3beta1VersionVariantsResponse':
        """
        The flow versions as the variants.
        """
        return pulumi.get(self, "version_variants")


@pulumi.output_type
class GoogleCloudDialogflowCxV3beta1VersionVariantsResponse(dict):
    """
    A list of flow version variants.
    """
    def __init__(__self__, *,
                 variants: Sequence['outputs.GoogleCloudDialogflowCxV3beta1VersionVariantsVariantResponse']):
        """
        A list of flow version variants.
        :param Sequence['GoogleCloudDialogflowCxV3beta1VersionVariantsVariantResponse'] variants: A list of flow version variants.
        """
        pulumi.set(__self__, "variants", variants)

    @property
    @pulumi.getter
    def variants(self) -> Sequence['outputs.GoogleCloudDialogflowCxV3beta1VersionVariantsVariantResponse']:
        """
        A list of flow version variants.
        """
        return pulumi.get(self, "variants")


@pulumi.output_type
class GoogleCloudDialogflowCxV3beta1VersionVariantsVariantResponse(dict):
    """
    A single flow version with specified traffic allocation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isControlGroup":
            suggest = "is_control_group"
        elif key == "trafficAllocation":
            suggest = "traffic_allocation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowCxV3beta1VersionVariantsVariantResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowCxV3beta1VersionVariantsVariantResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowCxV3beta1VersionVariantsVariantResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_control_group: bool,
                 traffic_allocation: float,
                 version: str):
        """
        A single flow version with specified traffic allocation.
        :param bool is_control_group: Whether the variant is for the control group.
        :param float traffic_allocation: Percentage of the traffic which should be routed to this version of flow. Traffic allocation for a single flow must sum up to 1.0.
        :param str version: The name of the flow version. Format: `projects//locations//agents//flows//versions/`.
        """
        pulumi.set(__self__, "is_control_group", is_control_group)
        pulumi.set(__self__, "traffic_allocation", traffic_allocation)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="isControlGroup")
    def is_control_group(self) -> bool:
        """
        Whether the variant is for the control group.
        """
        return pulumi.get(self, "is_control_group")

    @property
    @pulumi.getter(name="trafficAllocation")
    def traffic_allocation(self) -> float:
        """
        Percentage of the traffic which should be routed to this version of flow. Traffic allocation for a single flow must sum up to 1.0.
        """
        return pulumi.get(self, "traffic_allocation")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The name of the flow version. Format: `projects//locations//agents//flows//versions/`.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GoogleCloudDialogflowCxV3beta1WebhookGenericWebServiceResponse(dict):
    """
    Represents configuration for a generic web service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "requestHeaders":
            suggest = "request_headers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDialogflowCxV3beta1WebhookGenericWebServiceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDialogflowCxV3beta1WebhookGenericWebServiceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDialogflowCxV3beta1WebhookGenericWebServiceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 password: str,
                 request_headers: Mapping[str, str],
                 uri: str,
                 username: str):
        """
        Represents configuration for a generic web service.
        :param str password: The password for HTTP Basic authentication.
        :param Mapping[str, str] request_headers: The HTTP request headers to send together with webhook requests.
        :param str uri: Required. The webhook URI for receiving POST requests. It must use https protocol.
        :param str username: The user name for HTTP Basic authentication.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "request_headers", request_headers)
        pulumi.set(__self__, "uri", uri)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        The password for HTTP Basic authentication.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="requestHeaders")
    def request_headers(self) -> Mapping[str, str]:
        """
        The HTTP request headers to send together with webhook requests.
        """
        return pulumi.get(self, "request_headers")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        Required. The webhook URI for receiving POST requests. It must use https protocol.
        """
        return pulumi.get(self, "uri")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        The user name for HTTP Basic authentication.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class GoogleRpcStatusResponse(dict):
    """
    The `Status` type defines a logical error model that is suitable for different programming environments, including REST APIs and RPC APIs. It is used by [gRPC](https://github.com/grpc). Each `Status` message contains three pieces of data: error code, error message, and error details. You can find out more about this error model and how to work with it in the [API Design Guide](https://cloud.google.com/apis/design/errors).
    """
    def __init__(__self__, *,
                 code: int,
                 details: Sequence[Mapping[str, str]],
                 message: str):
        """
        The `Status` type defines a logical error model that is suitable for different programming environments, including REST APIs and RPC APIs. It is used by [gRPC](https://github.com/grpc). Each `Status` message contains three pieces of data: error code, error message, and error details. You can find out more about this error model and how to work with it in the [API Design Guide](https://cloud.google.com/apis/design/errors).
        :param int code: The status code, which should be an enum value of google.rpc.Code.
        :param Sequence[Mapping[str, str]] details: A list of messages that carry the error details. There is a common set of message types for APIs to use.
        :param str message: A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> int:
        """
        The status code, which should be an enum value of google.rpc.Code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def details(self) -> Sequence[Mapping[str, str]]:
        """
        A list of messages that carry the error details. There is a common set of message types for APIs to use.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        return pulumi.get(self, "message")


