# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'CompositeFilterResponse',
    'DataSourceRestrictionResponse',
    'DateResponse',
    'FacetOptionsResponse',
    'FilterOptionsResponse',
    'FilterResponse',
    'GSuitePrincipalResponse',
    'ScoringConfigResponse',
    'SortOptionsResponse',
    'SourceConfigResponse',
    'SourceCrowdingConfigResponse',
    'SourceResponse',
    'SourceScoringConfigResponse',
    'ValueFilterResponse',
    'ValueResponse',
]

@pulumi.output_type
class CompositeFilterResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logicOperator":
            suggest = "logic_operator"
        elif key == "subFilters":
            suggest = "sub_filters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CompositeFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CompositeFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CompositeFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 logic_operator: str,
                 sub_filters: Sequence['outputs.FilterResponse']):
        """
        :param str logic_operator: The logic operator of the sub filter.
        :param Sequence['FilterResponse'] sub_filters: Sub filters.
        """
        pulumi.set(__self__, "logic_operator", logic_operator)
        pulumi.set(__self__, "sub_filters", sub_filters)

    @property
    @pulumi.getter(name="logicOperator")
    def logic_operator(self) -> str:
        """
        The logic operator of the sub filter.
        """
        return pulumi.get(self, "logic_operator")

    @property
    @pulumi.getter(name="subFilters")
    def sub_filters(self) -> Sequence['outputs.FilterResponse']:
        """
        Sub filters.
        """
        return pulumi.get(self, "sub_filters")


@pulumi.output_type
class DataSourceRestrictionResponse(dict):
    """
    Restriction on Datasource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filterOptions":
            suggest = "filter_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceRestrictionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceRestrictionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceRestrictionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 filter_options: Sequence['outputs.FilterOptionsResponse'],
                 source: 'outputs.SourceResponse'):
        """
        Restriction on Datasource.
        :param Sequence['FilterOptionsResponse'] filter_options: Filter options restricting the results. If multiple filters are present, they are grouped by object type before joining. Filters with the same object type are joined conjunctively, then the resulting expressions are joined disjunctively. The maximum number of elements is 20. NOTE: Suggest API supports only few filters at the moment: "objecttype", "type" and "mimetype". For now, schema specific filters cannot be used to filter suggestions.
        :param 'SourceResponse' source: The source of restriction.
        """
        pulumi.set(__self__, "filter_options", filter_options)
        pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter(name="filterOptions")
    def filter_options(self) -> Sequence['outputs.FilterOptionsResponse']:
        """
        Filter options restricting the results. If multiple filters are present, they are grouped by object type before joining. Filters with the same object type are joined conjunctively, then the resulting expressions are joined disjunctively. The maximum number of elements is 20. NOTE: Suggest API supports only few filters at the moment: "objecttype", "type" and "mimetype". For now, schema specific filters cannot be used to filter suggestions.
        """
        return pulumi.get(self, "filter_options")

    @property
    @pulumi.getter
    def source(self) -> 'outputs.SourceResponse':
        """
        The source of restriction.
        """
        return pulumi.get(self, "source")


@pulumi.output_type
class DateResponse(dict):
    """
    Represents a whole calendar date, for example a date of birth. The time of day and time zone are either specified elsewhere or are not significant. The date is relative to the [Proleptic Gregorian Calendar](https://en.wikipedia.org/wiki/Proleptic_Gregorian_calendar). The date must be a valid calendar date between the year 1 and 9999.
    """
    def __init__(__self__, *,
                 day: int,
                 month: int,
                 year: int):
        """
        Represents a whole calendar date, for example a date of birth. The time of day and time zone are either specified elsewhere or are not significant. The date is relative to the [Proleptic Gregorian Calendar](https://en.wikipedia.org/wiki/Proleptic_Gregorian_calendar). The date must be a valid calendar date between the year 1 and 9999.
        :param int day: Day of month. Must be from 1 to 31 and valid for the year and month.
        :param int month: Month of date. Must be from 1 to 12.
        :param int year: Year of date. Must be from 1 to 9999.
        """
        pulumi.set(__self__, "day", day)
        pulumi.set(__self__, "month", month)
        pulumi.set(__self__, "year", year)

    @property
    @pulumi.getter
    def day(self) -> int:
        """
        Day of month. Must be from 1 to 31 and valid for the year and month.
        """
        return pulumi.get(self, "day")

    @property
    @pulumi.getter
    def month(self) -> int:
        """
        Month of date. Must be from 1 to 12.
        """
        return pulumi.get(self, "month")

    @property
    @pulumi.getter
    def year(self) -> int:
        """
        Year of date. Must be from 1 to 9999.
        """
        return pulumi.get(self, "year")


@pulumi.output_type
class FacetOptionsResponse(dict):
    """
    Specifies operators to return facet results for. There will be one FacetResult for every source_name/object_type/operator_name combination.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "numFacetBuckets":
            suggest = "num_facet_buckets"
        elif key == "objectType":
            suggest = "object_type"
        elif key == "operatorName":
            suggest = "operator_name"
        elif key == "sourceName":
            suggest = "source_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FacetOptionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FacetOptionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FacetOptionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 num_facet_buckets: int,
                 object_type: str,
                 operator_name: str,
                 source_name: str):
        """
        Specifies operators to return facet results for. There will be one FacetResult for every source_name/object_type/operator_name combination.
        :param int num_facet_buckets: Maximum number of facet buckets that should be returned for this facet. Defaults to 10. Maximum value is 100.
        :param str object_type: If object_type is set, only those objects of that type will be used to compute facets. If empty, then all objects will be used to compute facets.
        :param str operator_name: Name of the operator chosen for faceting. @see cloudsearch.SchemaPropertyOptions
        :param str source_name: Source name to facet on. Format: datasources/{source_id} If empty, all data sources will be used.
        """
        pulumi.set(__self__, "num_facet_buckets", num_facet_buckets)
        pulumi.set(__self__, "object_type", object_type)
        pulumi.set(__self__, "operator_name", operator_name)
        pulumi.set(__self__, "source_name", source_name)

    @property
    @pulumi.getter(name="numFacetBuckets")
    def num_facet_buckets(self) -> int:
        """
        Maximum number of facet buckets that should be returned for this facet. Defaults to 10. Maximum value is 100.
        """
        return pulumi.get(self, "num_facet_buckets")

    @property
    @pulumi.getter(name="objectType")
    def object_type(self) -> str:
        """
        If object_type is set, only those objects of that type will be used to compute facets. If empty, then all objects will be used to compute facets.
        """
        return pulumi.get(self, "object_type")

    @property
    @pulumi.getter(name="operatorName")
    def operator_name(self) -> str:
        """
        Name of the operator chosen for faceting. @see cloudsearch.SchemaPropertyOptions
        """
        return pulumi.get(self, "operator_name")

    @property
    @pulumi.getter(name="sourceName")
    def source_name(self) -> str:
        """
        Source name to facet on. Format: datasources/{source_id} If empty, all data sources will be used.
        """
        return pulumi.get(self, "source_name")


@pulumi.output_type
class FilterOptionsResponse(dict):
    """
    Filter options to be applied on query.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectType":
            suggest = "object_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FilterOptionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FilterOptionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FilterOptionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 filter: 'outputs.FilterResponse',
                 object_type: str):
        """
        Filter options to be applied on query.
        :param 'FilterResponse' filter: Generic filter to restrict the search, such as `lang:en`, `site:xyz`.
        :param str object_type: If object_type is set, only objects of that type are returned. This should correspond to the name of the object that was registered within the definition of schema. The maximum length is 256 characters.
        """
        pulumi.set(__self__, "filter", filter)
        pulumi.set(__self__, "object_type", object_type)

    @property
    @pulumi.getter
    def filter(self) -> 'outputs.FilterResponse':
        """
        Generic filter to restrict the search, such as `lang:en`, `site:xyz`.
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter(name="objectType")
    def object_type(self) -> str:
        """
        If object_type is set, only objects of that type are returned. This should correspond to the name of the object that was registered within the definition of schema. The maximum length is 256 characters.
        """
        return pulumi.get(self, "object_type")


@pulumi.output_type
class FilterResponse(dict):
    """
    A generic way of expressing filters in a query, which supports two approaches: **1. Setting a ValueFilter.** The name must match an operator_name defined in the schema for your data source. **2. Setting a CompositeFilter.** The filters are evaluated using the logical operator. The top-level operators can only be either an AND or a NOT. AND can appear only at the top-most level. OR can appear only under a top-level AND.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "compositeFilter":
            suggest = "composite_filter"
        elif key == "valueFilter":
            suggest = "value_filter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 composite_filter: 'outputs.CompositeFilterResponse',
                 value_filter: 'outputs.ValueFilterResponse'):
        """
        A generic way of expressing filters in a query, which supports two approaches: **1. Setting a ValueFilter.** The name must match an operator_name defined in the schema for your data source. **2. Setting a CompositeFilter.** The filters are evaluated using the logical operator. The top-level operators can only be either an AND or a NOT. AND can appear only at the top-most level. OR can appear only under a top-level AND.
        """
        pulumi.set(__self__, "composite_filter", composite_filter)
        pulumi.set(__self__, "value_filter", value_filter)

    @property
    @pulumi.getter(name="compositeFilter")
    def composite_filter(self) -> 'outputs.CompositeFilterResponse':
        return pulumi.get(self, "composite_filter")

    @property
    @pulumi.getter(name="valueFilter")
    def value_filter(self) -> 'outputs.ValueFilterResponse':
        return pulumi.get(self, "value_filter")


@pulumi.output_type
class GSuitePrincipalResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gsuiteDomain":
            suggest = "gsuite_domain"
        elif key == "gsuiteGroupEmail":
            suggest = "gsuite_group_email"
        elif key == "gsuiteUserEmail":
            suggest = "gsuite_user_email"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GSuitePrincipalResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GSuitePrincipalResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GSuitePrincipalResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gsuite_domain: bool,
                 gsuite_group_email: str,
                 gsuite_user_email: str):
        """
        :param bool gsuite_domain: This principal represents all users of the G Suite domain of the customer.
        :param str gsuite_group_email: This principal references a G Suite group account
        :param str gsuite_user_email: This principal references a G Suite user account
        """
        pulumi.set(__self__, "gsuite_domain", gsuite_domain)
        pulumi.set(__self__, "gsuite_group_email", gsuite_group_email)
        pulumi.set(__self__, "gsuite_user_email", gsuite_user_email)

    @property
    @pulumi.getter(name="gsuiteDomain")
    def gsuite_domain(self) -> bool:
        """
        This principal represents all users of the G Suite domain of the customer.
        """
        return pulumi.get(self, "gsuite_domain")

    @property
    @pulumi.getter(name="gsuiteGroupEmail")
    def gsuite_group_email(self) -> str:
        """
        This principal references a G Suite group account
        """
        return pulumi.get(self, "gsuite_group_email")

    @property
    @pulumi.getter(name="gsuiteUserEmail")
    def gsuite_user_email(self) -> str:
        """
        This principal references a G Suite user account
        """
        return pulumi.get(self, "gsuite_user_email")


@pulumi.output_type
class ScoringConfigResponse(dict):
    """
    Scoring configurations for a source while processing a Search or Suggest request.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disableFreshness":
            suggest = "disable_freshness"
        elif key == "disablePersonalization":
            suggest = "disable_personalization"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScoringConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScoringConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScoringConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disable_freshness: bool,
                 disable_personalization: bool):
        """
        Scoring configurations for a source while processing a Search or Suggest request.
        :param bool disable_freshness: Whether to use freshness as a ranking signal. By default, freshness is used as a ranking signal. Note that this setting is not available in the Admin UI.
        :param bool disable_personalization: Whether to personalize the results. By default, personal signals will be used to boost results.
        """
        pulumi.set(__self__, "disable_freshness", disable_freshness)
        pulumi.set(__self__, "disable_personalization", disable_personalization)

    @property
    @pulumi.getter(name="disableFreshness")
    def disable_freshness(self) -> bool:
        """
        Whether to use freshness as a ranking signal. By default, freshness is used as a ranking signal. Note that this setting is not available in the Admin UI.
        """
        return pulumi.get(self, "disable_freshness")

    @property
    @pulumi.getter(name="disablePersonalization")
    def disable_personalization(self) -> bool:
        """
        Whether to personalize the results. By default, personal signals will be used to boost results.
        """
        return pulumi.get(self, "disable_personalization")


@pulumi.output_type
class SortOptionsResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operatorName":
            suggest = "operator_name"
        elif key == "sortOrder":
            suggest = "sort_order"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SortOptionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SortOptionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SortOptionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operator_name: str,
                 sort_order: str):
        """
        :param str operator_name: Name of the operator corresponding to the field to sort on. The corresponding property must be marked as sortable.
        :param str sort_order: Ascending is the default sort order
        """
        pulumi.set(__self__, "operator_name", operator_name)
        pulumi.set(__self__, "sort_order", sort_order)

    @property
    @pulumi.getter(name="operatorName")
    def operator_name(self) -> str:
        """
        Name of the operator corresponding to the field to sort on. The corresponding property must be marked as sortable.
        """
        return pulumi.get(self, "operator_name")

    @property
    @pulumi.getter(name="sortOrder")
    def sort_order(self) -> str:
        """
        Ascending is the default sort order
        """
        return pulumi.get(self, "sort_order")


@pulumi.output_type
class SourceConfigResponse(dict):
    """
    Configurations for a source while processing a Search or Suggest request.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "crowdingConfig":
            suggest = "crowding_config"
        elif key == "scoringConfig":
            suggest = "scoring_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SourceConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SourceConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SourceConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 crowding_config: 'outputs.SourceCrowdingConfigResponse',
                 scoring_config: 'outputs.SourceScoringConfigResponse',
                 source: 'outputs.SourceResponse'):
        """
        Configurations for a source while processing a Search or Suggest request.
        :param 'SourceCrowdingConfigResponse' crowding_config: The crowding configuration for the source.
        :param 'SourceScoringConfigResponse' scoring_config: The scoring configuration for the source.
        :param 'SourceResponse' source: The source for which this configuration is to be used.
        """
        pulumi.set(__self__, "crowding_config", crowding_config)
        pulumi.set(__self__, "scoring_config", scoring_config)
        pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter(name="crowdingConfig")
    def crowding_config(self) -> 'outputs.SourceCrowdingConfigResponse':
        """
        The crowding configuration for the source.
        """
        return pulumi.get(self, "crowding_config")

    @property
    @pulumi.getter(name="scoringConfig")
    def scoring_config(self) -> 'outputs.SourceScoringConfigResponse':
        """
        The scoring configuration for the source.
        """
        return pulumi.get(self, "scoring_config")

    @property
    @pulumi.getter
    def source(self) -> 'outputs.SourceResponse':
        """
        The source for which this configuration is to be used.
        """
        return pulumi.get(self, "source")


@pulumi.output_type
class SourceCrowdingConfigResponse(dict):
    """
    Set search results crowding limits. Crowding is a situation in which multiple results from the same source or host "crowd out" other results, diminishing the quality of search for users. To foster better search quality and source diversity in search results, you can set a condition to reduce repetitive results by source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "numResults":
            suggest = "num_results"
        elif key == "numSuggestions":
            suggest = "num_suggestions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SourceCrowdingConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SourceCrowdingConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SourceCrowdingConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 num_results: int,
                 num_suggestions: int):
        """
        Set search results crowding limits. Crowding is a situation in which multiple results from the same source or host "crowd out" other results, diminishing the quality of search for users. To foster better search quality and source diversity in search results, you can set a condition to reduce repetitive results by source.
        :param int num_results: Maximum number of results allowed from a source. No limits will be set on results if this value is less than or equal to 0.
        :param int num_suggestions: Maximum number of suggestions allowed from a source. No limits will be set on results if this value is less than or equal to 0.
        """
        pulumi.set(__self__, "num_results", num_results)
        pulumi.set(__self__, "num_suggestions", num_suggestions)

    @property
    @pulumi.getter(name="numResults")
    def num_results(self) -> int:
        """
        Maximum number of results allowed from a source. No limits will be set on results if this value is less than or equal to 0.
        """
        return pulumi.get(self, "num_results")

    @property
    @pulumi.getter(name="numSuggestions")
    def num_suggestions(self) -> int:
        """
        Maximum number of suggestions allowed from a source. No limits will be set on results if this value is less than or equal to 0.
        """
        return pulumi.get(self, "num_suggestions")


@pulumi.output_type
class SourceResponse(dict):
    """
    Defines sources for the suggest/search APIs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "predefinedSource":
            suggest = "predefined_source"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 predefined_source: str):
        """
        Defines sources for the suggest/search APIs.
        :param str name: Source name for content indexed by the Indexing API.
        :param str predefined_source: Predefined content source for Google Apps.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "predefined_source", predefined_source)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Source name for content indexed by the Indexing API.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="predefinedSource")
    def predefined_source(self) -> str:
        """
        Predefined content source for Google Apps.
        """
        return pulumi.get(self, "predefined_source")


@pulumi.output_type
class SourceScoringConfigResponse(dict):
    """
    Set the scoring configuration. This allows modifying the ranking of results for a source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceImportance":
            suggest = "source_importance"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SourceScoringConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SourceScoringConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SourceScoringConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_importance: str):
        """
        Set the scoring configuration. This allows modifying the ranking of results for a source.
        :param str source_importance: Importance of the source.
        """
        pulumi.set(__self__, "source_importance", source_importance)

    @property
    @pulumi.getter(name="sourceImportance")
    def source_importance(self) -> str:
        """
        Importance of the source.
        """
        return pulumi.get(self, "source_importance")


@pulumi.output_type
class ValueFilterResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operatorName":
            suggest = "operator_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ValueFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ValueFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ValueFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operator_name: str,
                 value: 'outputs.ValueResponse'):
        """
        :param str operator_name: The `operator_name` applied to the query, such as *price_greater_than*. The filter can work against both types of filters defined in the schema for your data source: 1. `operator_name`, where the query filters results by the property that matches the value. 2. `greater_than_operator_name` or `less_than_operator_name` in your schema. The query filters the results for the property values that are greater than or less than the supplied value in the query.
        :param 'ValueResponse' value: The value to be compared with.
        """
        pulumi.set(__self__, "operator_name", operator_name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="operatorName")
    def operator_name(self) -> str:
        """
        The `operator_name` applied to the query, such as *price_greater_than*. The filter can work against both types of filters defined in the schema for your data source: 1. `operator_name`, where the query filters results by the property that matches the value. 2. `greater_than_operator_name` or `less_than_operator_name` in your schema. The query filters the results for the property values that are greater than or less than the supplied value in the query.
        """
        return pulumi.get(self, "operator_name")

    @property
    @pulumi.getter
    def value(self) -> 'outputs.ValueResponse':
        """
        The value to be compared with.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ValueResponse(dict):
    """
    Definition of a single value with generic type.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "booleanValue":
            suggest = "boolean_value"
        elif key == "dateValue":
            suggest = "date_value"
        elif key == "doubleValue":
            suggest = "double_value"
        elif key == "integerValue":
            suggest = "integer_value"
        elif key == "stringValue":
            suggest = "string_value"
        elif key == "timestampValue":
            suggest = "timestamp_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ValueResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ValueResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ValueResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 boolean_value: bool,
                 date_value: 'outputs.DateResponse',
                 double_value: float,
                 integer_value: str,
                 string_value: str,
                 timestamp_value: str):
        """
        Definition of a single value with generic type.
        """
        pulumi.set(__self__, "boolean_value", boolean_value)
        pulumi.set(__self__, "date_value", date_value)
        pulumi.set(__self__, "double_value", double_value)
        pulumi.set(__self__, "integer_value", integer_value)
        pulumi.set(__self__, "string_value", string_value)
        pulumi.set(__self__, "timestamp_value", timestamp_value)

    @property
    @pulumi.getter(name="booleanValue")
    def boolean_value(self) -> bool:
        return pulumi.get(self, "boolean_value")

    @property
    @pulumi.getter(name="dateValue")
    def date_value(self) -> 'outputs.DateResponse':
        return pulumi.get(self, "date_value")

    @property
    @pulumi.getter(name="doubleValue")
    def double_value(self) -> float:
        return pulumi.get(self, "double_value")

    @property
    @pulumi.getter(name="integerValue")
    def integer_value(self) -> str:
        return pulumi.get(self, "integer_value")

    @property
    @pulumi.getter(name="stringValue")
    def string_value(self) -> str:
        return pulumi.get(self, "string_value")

    @property
    @pulumi.getter(name="timestampValue")
    def timestamp_value(self) -> str:
        return pulumi.get(self, "timestamp_value")


