# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = ['OrganizationSiteApicategoryArgs', 'OrganizationSiteApicategory']

@pulumi.input_type
class OrganizationSiteApicategoryArgs:
    def __init__(__self__, *,
                 apicategories_id: pulumi.Input[str],
                 organizations_id: pulumi.Input[str],
                 sites_id: pulumi.Input[str],
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 site_id: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a OrganizationSiteApicategory resource.
        :param pulumi.Input[str] id: ID of the category (a UUID).
        :param pulumi.Input[str] name: Name of the category.
        :param pulumi.Input[str] site_id: Name of the portal.
        :param pulumi.Input[str] update_time: Time the category was last modified in milliseconds since epoch.
        """
        pulumi.set(__self__, "apicategories_id", apicategories_id)
        pulumi.set(__self__, "organizations_id", organizations_id)
        pulumi.set(__self__, "sites_id", sites_id)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if site_id is not None:
            pulumi.set(__self__, "site_id", site_id)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="apicategoriesId")
    def apicategories_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "apicategories_id")

    @apicategories_id.setter
    def apicategories_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "apicategories_id", value)

    @property
    @pulumi.getter(name="organizationsId")
    def organizations_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "organizations_id")

    @organizations_id.setter
    def organizations_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "organizations_id", value)

    @property
    @pulumi.getter(name="sitesId")
    def sites_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "sites_id")

    @sites_id.setter
    def sites_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "sites_id", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the category (a UUID).
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the category.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the portal.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "site_id", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        Time the category was last modified in milliseconds since epoch.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)


class OrganizationSiteApicategory(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apicategories_id: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 organizations_id: Optional[pulumi.Input[str]] = None,
                 site_id: Optional[pulumi.Input[str]] = None,
                 sites_id: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates a new category on the portal.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] id: ID of the category (a UUID).
        :param pulumi.Input[str] name: Name of the category.
        :param pulumi.Input[str] site_id: Name of the portal.
        :param pulumi.Input[str] update_time: Time the category was last modified in milliseconds since epoch.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OrganizationSiteApicategoryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a new category on the portal.

        :param str resource_name: The name of the resource.
        :param OrganizationSiteApicategoryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OrganizationSiteApicategoryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apicategories_id: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 organizations_id: Optional[pulumi.Input[str]] = None,
                 site_id: Optional[pulumi.Input[str]] = None,
                 sites_id: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OrganizationSiteApicategoryArgs.__new__(OrganizationSiteApicategoryArgs)

            if apicategories_id is None and not opts.urn:
                raise TypeError("Missing required property 'apicategories_id'")
            __props__.__dict__["apicategories_id"] = apicategories_id
            __props__.__dict__["id"] = id
            __props__.__dict__["name"] = name
            if organizations_id is None and not opts.urn:
                raise TypeError("Missing required property 'organizations_id'")
            __props__.__dict__["organizations_id"] = organizations_id
            __props__.__dict__["site_id"] = site_id
            if sites_id is None and not opts.urn:
                raise TypeError("Missing required property 'sites_id'")
            __props__.__dict__["sites_id"] = sites_id
            __props__.__dict__["update_time"] = update_time
            __props__.__dict__["data"] = None
            __props__.__dict__["error_code"] = None
            __props__.__dict__["message"] = None
            __props__.__dict__["request_id"] = None
            __props__.__dict__["status"] = None
        super(OrganizationSiteApicategory, __self__).__init__(
            'google-native:apigee/v1:OrganizationSiteApicategory',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'OrganizationSiteApicategory':
        """
        Get an existing OrganizationSiteApicategory resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = OrganizationSiteApicategoryArgs.__new__(OrganizationSiteApicategoryArgs)

        __props__.__dict__["data"] = None
        __props__.__dict__["error_code"] = None
        __props__.__dict__["message"] = None
        __props__.__dict__["request_id"] = None
        __props__.__dict__["status"] = None
        return OrganizationSiteApicategory(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def data(self) -> pulumi.Output['outputs.GoogleCloudApigeeV1ApiCategoryDataResponse']:
        """
        Details of category.
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter(name="errorCode")
    def error_code(self) -> pulumi.Output[str]:
        """
        ID that can be used to find errors in the log files.
        """
        return pulumi.get(self, "error_code")

    @property
    @pulumi.getter
    def message(self) -> pulumi.Output[str]:
        """
        Description of the operation.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="requestId")
    def request_id(self) -> pulumi.Output[str]:
        """
        ID that can be used to find request details in the log files.
        """
        return pulumi.get(self, "request_id")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Status of the operation.
        """
        return pulumi.get(self, "status")

