# generated by datamodel-codegen:
#   filename:  schema/entity/events/webhook.json
#   timestamp: 2022-03-24T08:29:52+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import AnyUrl, BaseModel, Extra, Field, constr

from ...type import basic, changeEvent, entityHistory


class Status(Enum):
    disabled = 'disabled'
    failed = 'failed'
    retryLimitReached = 'retryLimitReached'
    awaitingRetry = 'awaitingRetry'
    active = 'active'


class FailureDetails(BaseModel):
    class Config:
        extra = Extra.forbid

    lastSuccessfulAt: Optional[basic.Timestamp] = Field(
        None,
        description='Last non-successful callback time in UNIX UTC epoch time in milliseconds.',
    )
    lastFailedAt: Optional[basic.Timestamp] = Field(
        None,
        description='Last non-successful callback time in UNIX UTC epoch time in milliseconds.',
    )
    lastFailedStatusCode: Optional[int] = Field(
        None,
        description='Last non-successful activity response code received during callback.',
    )
    lastFailedReason: Optional[str] = Field(
        None,
        description='Last non-successful activity response reason received during callback.',
    )
    nextAttempt: Optional[basic.Timestamp] = Field(
        None,
        description='Next retry will be done at this time in Unix epoch time milliseconds. Only valid is `status` is `awaitingRetry`.',
    )


class Webhook(BaseModel):
    class Config:
        extra = Extra.forbid

    id: basic.Uuid = Field(
        ..., description='Unique ID associated with a webhook subscription.'
    )
    name: constr(min_length=1, max_length=128) = Field(
        ..., description='Unique name of the application receiving webhook events.'
    )
    displayName: Optional[str] = Field(
        None, description='Display Name that identifies this webhook.'
    )
    description: Optional[str] = Field(
        None, description='Description of the application.'
    )
    endpoint: AnyUrl = Field(
        ..., description='Endpoint to receive the webhook events over POST requests.'
    )
    eventFilters: List[changeEvent.EventFilter] = Field(
        ..., description='Endpoint to receive the webhook events over POST requests.'
    )
    batchSize: Optional[int] = Field(
        10, description='Maximum number of events sent in a batch (Default 10).'
    )
    timeout: Optional[int] = Field(
        10, description='Connection timeout in seconds. (Default 10s).'
    )
    enabled: Optional[bool] = Field(
        True,
        description='When set to `true`, the webhook event notification is enabled. Set it to `false` to disable the subscription. (Default `true`).',
    )
    secretKey: Optional[str] = Field(
        None,
        description='Secret set by the webhook client used for computing HMAC SHA256 signature of webhook payload and sent in `X-OM-Signature` header in POST requests to publish the events.',
    )
    version: Optional[entityHistory.EntityVersion] = Field(
        None, description='Metadata version of the entity.'
    )
    updatedAt: Optional[basic.Timestamp] = Field(
        None,
        description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
    )
    updatedBy: Optional[str] = Field(None, description='User who made the update.')
    status: Optional[Status] = Field(
        None,
        description='Status is `disabled`, when webhook was created with `enabled` set to false and it never started publishing events. Status is `active` when webhook is normally functioning and 200 OK response was received for callback notification. Status is `failed` on bad callback URL, connection failures, `1xx`, and `3xx` response was received for callback notification. Status is `awaitingRetry` when previous attempt at callback timed out or received `4xx`, `5xx` response. Status is `retryLimitReached` after all retries fail.',
    )
    failureDetails: Optional[FailureDetails] = Field(
        None, description='Failure details are set only when `status` is not `success`.'
    )
    href: Optional[basic.Href] = Field(
        None, description='Link to this webhook resource.'
    )
    changeDescription: Optional[entityHistory.ChangeDescription] = Field(
        None, description='Change that lead to this version of the entity.'
    )
    deleted: Optional[bool] = Field(
        False, description='When `true` indicates the entity has been soft deleted.'
    )
