# generated by datamodel-codegen:
#   filename:  schema/api/services/createPipelineService.json
#   timestamp: 2022-03-24T08:29:52+00:00

from __future__ import annotations

from typing import Optional

from pydantic import AnyUrl, BaseModel, Extra, Field, constr

from ...entity.services import pipelineService
from ...type import entityReference, schedule


class CreatePipelineServiceRequest(BaseModel):
    class Config:
        extra = Extra.forbid

    name: constr(regex=r'^[^.]*$', min_length=1, max_length=128) = Field(
        ..., description='Name that identifies the this entity instance uniquely'
    )
    description: Optional[str] = Field(
        None, description='Description of pipeline service entity.'
    )
    serviceType: pipelineService.PipelineServiceType
    pipelineUrl: AnyUrl = Field(..., description='Pipeline UI URL')
    ingestionSchedule: Optional[schedule.Schedule] = Field(
        None, description='Schedule for running pipeline ingestion jobs'
    )
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this pipeline service.'
    )
