# generated by datamodel-codegen:
#   filename:  schema/api/policies/createPolicy.json
#   timestamp: 2022-03-24T08:29:52+00:00

from __future__ import annotations

from typing import Optional

from pydantic import AnyUrl, BaseModel, Extra, Field

from ...entity.policies import policy
from ...type import basic, entityReference


class CreatePolicyRequest(BaseModel):
    class Config:
        extra = Extra.forbid

    name: policy.PolicyName = Field(
        ..., description='Name that identifies this Policy.'
    )
    displayName: Optional[str] = Field(None, description='Title for this Policy.')
    description: Optional[str] = Field(
        None,
        description='A short description of the Policy, comprehensible to regular users.',
    )
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this Policy.'
    )
    policyUrl: Optional[AnyUrl] = Field(
        None, description='Link to a well documented definition of this Policy.'
    )
    policyType: policy.PolicyType
    rules: Optional[policy.Rules] = None
    enabled: Optional[bool] = Field(True, description='Is the policy enabled.')
    location: Optional[basic.Uuid] = Field(
        None, description='UUID of Location where this policy is applied'
    )
