"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DatabaseSecret = void 0;
const crypto = require("crypto");
const secretsmanager = require("@aws-cdk/aws-secretsmanager");
const core_1 = require("@aws-cdk/core");
const util_1 = require("./private/util");
/**
 * A database secret.
 *
 * @stability stable
 * @resource AWS::SecretsManager::Secret
 */
class DatabaseSecret extends secretsmanager.Secret {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _a, _b;
        const excludeCharacters = (_a = props.excludeCharacters) !== null && _a !== void 0 ? _a : util_1.DEFAULT_PASSWORD_EXCLUDE_CHARS;
        super(scope, id, {
            encryptionKey: props.encryptionKey,
            description: `Generated by the CDK for stack: ${core_1.Aws.STACK_NAME}`,
            generateSecretString: {
                passwordLength: 30,
                secretStringTemplate: JSON.stringify({
                    username: props.username,
                    masterarn: (_b = props.masterSecret) === null || _b === void 0 ? void 0 : _b.secretArn,
                }),
                generateStringKey: 'password',
                excludeCharacters,
            },
        });
        if (props.replaceOnPasswordCriteriaChanges) {
            const hash = crypto.createHash('md5');
            hash.update(JSON.stringify({
                // Use here the options that influence the password generation.
                // If at some point we add other password customization options
                // they sould be added here below (e.g. `passwordLength`).
                excludeCharacters,
            }));
            const logicalId = `${core_1.Names.uniqueId(this)}${hash.digest('hex')}`;
            const secret = this.node.defaultChild;
            secret.overrideLogicalId(logicalId.slice(-255)); // Take last 255 chars
        }
    }
}
exports.DatabaseSecret = DatabaseSecret;
//# sourceMappingURL=data:application/json;base64,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