# Python API Notebooks

This directory contains iPython notebooks that use the Python API to
perform various statistical analyses on interesting datasets. You can click on
each link to see a live colab version.

Notebook | Description
-------- | -----------
[`analyzing_census_data.ipynb`](https://colab.research.google.com/drive/1wYohDirOgVxvmL0d-oJRWdD6AXfAX_w1)           | A notebook that analyzes the relationship between population size and median age for each State, County, and City in the United States.
[`COVID_19_Feature_Exploration_Analysis_with_Data_Commons.ipynb`](https://colab.research.google.com/drive/1LLteGjXifwSsD-YsGwBnI-i96G777Q7j)   | A notebook that explores how COVID-19 cases trends differ across different counties, and examines hundreds of variables across dozens of sources to see which variables are potentially correlated with COVID-19 mortality rate.
[`analyzing_income_distribution.ipynb`](https://colab.research.google.com/drive/1lyxb5gdD_YHKxNXLmD0poBU3G8bokWZ7)   | A notebook that plots the distribution of income using statistics provided by the 2017 [American Community Survey](https://www.census.gov/programs-surveys/acs). The final result is a histogram charting the number of individuals in income brackets ranging from "0 to 10,000USD" up to "Above 200,000USD".
[`analyzing_obesity_prevalence.ipynb`](https://colab.research.google.com/drive/1_oZYWrrwO80DBaW0rIirTYHlfHCibXxY)    | A notebook that analyzes the relationship between prevalence of obesity in 500 US Cities (as provided by the [CDC Wonder](https://wonder.cdc.gov/) dataset) to health and socio-economic indicators such as prevalence of high blood pressure and poverty rate.
[`Place Similarity with Data Commons.ipynb`](https://colab.research.google.com/drive/1t7dFDSpCT16QDkNuD933QgLUL9BOdCAS) | A notebook that identifies similar places given a place and one or more statistical variables from Data Commons.
[`Missing Data Imputation Tutorial.ipynb`](https://colab.research.google.com/drive/1S_rMCyRsgygd8sV-r8aLRPcKwZPFcEGb) | A notebook that analyzes the different types of time series holes and different methods of imputing those holes.
[`analyzing_genomic_data.ipynb`](https://colab.research.google.com/drive/1Io7EDr4LjfPLl_l2JYY8__WbfitfNlOf) | A notebook that analyzes genetic variants within RUNX1 (provided by multiple datasets from UCSC Genome Browser, NCBI/gene, and ClinVar).
[`Drug_Discovery_With_Data_Commons.ipynb`](https://colab.research.google.com/drive/1dSKYiRMn3mbDsInorQzYM0yk7sqv6fIV) | A notebook performing drug discovery by identifying novel applications of previously approved drugs using Biomedical Data Commons.
[`protein-charts.ipynb`](https://colab.research.google.com/drive/1Kh-ufqobdChZ2qQgEY0rdPA2_DBmOiSG) | A notebook summarizing various protein properties and interactions using graphical visualizations.
[`Superfund sites (basic)`](Accessing_Superfund_data_from_Data_Commons.ipynb) | A notebook that illustrates basic access to [Superfund sites](https://en.wikipedia.org/wiki/List_of_Superfund_sites) data in Data Commons.
[`Superfund sites (extended)`](Analyzing_SuperfundSites_with_Data_Commons.ipynb) | A notebook that includes extended analysis using [Superfund sites](https://en.wikipedia.org/wiki/List_of_Superfund_sites) data in Data Commons.

## Maintenance

To maintain up to date versions of these notebooks, developers can save a copy
of the above notebooks to a GitHub repository and PR this repository. Navigate
to `File > Save a copy in GitHub...`

![How to save to a GitHub repository.](https://user-images.githubusercontent.com/4650701/62900477-10787680-bd0f-11e9-84d0-ee69f8c17df9.png)
