# Data Commons Python API

This is a Python library for accessing data in the Data Commons Graph.

> See also: [Data Commons Pandas API](../datacommons_pandas/README.md).

To get started, install this package from pip.

```bash
pip install datacommons
```

Once the package is installed, import `datacommons`.

```python
import datacommons as dc
```

For more detail on getting started with the API, please visit our
[API Overview](https://docs.datacommons.org/api/).

When you are ready to use the API, you can refer to `examples` for
examples on how to use this package to perform various tasks. More tutorials and
documentation can be found on our [tutorials page](https://docs.datacommons.org/tutorials/)!

## About Data Commons

[Data Commons](https://datacommons.org/) is an open knowledge repository that
provides a unified view across multiple public data sets and statistics. You can
view what [datasets](https://datacommons.org/datasets) are currently ingested
and browse the graph using our [browser](https://datacommons.org/browser).

## License

Apache 2.0

## Support

For general questions or issues about the API, please open an issue on our
[issues](https://github.com/google/datacommons/issues) page. For all other
questions, please send an email to `support@datacommons.org`.
