import * as iam from '@aws-cdk/aws-iam';
import * as s3 from '@aws-cdk/aws-s3';
import { CfnResource, RemovalPolicy } from '@aws-cdk/core';
import { IEngine } from '../engine';
import { Credentials } from '../props';
import { Construct } from '@aws-cdk/core';
/**
 * The default set of characters we exclude from generated passwords for database users.
 * It's a combination of characters that have a tendency to cause problems in shell scripts,
 * some engine-specific characters (for example, Oracle doesn't like '@' in its passwords),
 * and some that trip up other services, like DMS.
 *
 * This constant is private to the RDS module.
 */
export declare const DEFAULT_PASSWORD_EXCLUDE_CHARS = " %+~`#$&*()|[]{}:;<>?!'/@\"\\";
/** Common base of `DatabaseInstanceProps` and `DatabaseClusterBaseProps` that has only the S3 props */
export interface DatabaseS3ImportExportProps {
    readonly s3ImportRole?: iam.IRole;
    readonly s3ImportBuckets?: s3.IBucket[];
    readonly s3ExportRole?: iam.IRole;
    readonly s3ExportBuckets?: s3.IBucket[];
}
/**
 * Validates the S3 import/export props and returns the import/export roles, if any.
 * If `combineRoles` is true, will reuse the import role for export (or vice versa) if possible.
 *
 * Notably, `combineRoles` is (by default) set to true for instances, but false for clusters.
 * This is because the `combineRoles` functionality is most applicable to instances and didn't exist
 * for the initial clusters implementation. To maintain backwards compatibility, it is set to false for clusters.
 */
export declare function setupS3ImportExport(scope: Construct, props: DatabaseS3ImportExportProps, combineRoles?: boolean): {
    s3ImportRole?: iam.IRole;
    s3ExportRole?: iam.IRole;
};
export declare function engineDescription(engine: IEngine): string;
export declare function applyRemovalPolicy(cfnDatabase: CfnResource, removalPolicy?: RemovalPolicy): void;
/**
 * By default, deletion protection is disabled.
 * Enable if explicitly provided or if the RemovalPolicy has been set to RETAIN
 */
export declare function defaultDeletionProtection(deletionProtection?: boolean, removalPolicy?: RemovalPolicy): boolean | undefined;
/**
 * Renders the credentials for an instance or cluster
 */
export declare function renderCredentials(scope: Construct, engine: IEngine, credentials?: Credentials): Credentials;
