# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AccountArgs',
    'AndroidDeviceListArgs',
    'AndroidDeviceArgs',
    'AndroidInstrumentationTestArgs',
    'AndroidMatrixArgs',
    'AndroidRoboTestArgs',
    'AndroidTestLoopArgs',
    'ApkArgs',
    'AppBundleArgs',
    'ClientInfoDetailArgs',
    'ClientInfoArgs',
    'DeviceFileArgs',
    'EnvironmentMatrixArgs',
    'EnvironmentVariableArgs',
    'FileReferenceArgs',
    'GoogleAutoArgs',
    'GoogleCloudStorageArgs',
    'IosDeviceFileArgs',
    'IosDeviceListArgs',
    'IosDeviceArgs',
    'IosTestLoopArgs',
    'IosTestSetupArgs',
    'IosXcTestArgs',
    'LauncherActivityIntentArgs',
    'ManualShardingArgs',
    'ObbFileArgs',
    'RegularFileArgs',
    'ResultStorageArgs',
    'RoboDirectiveArgs',
    'RoboStartingIntentArgs',
    'ShardingOptionArgs',
    'StartActivityIntentArgs',
    'SystraceSetupArgs',
    'TestSetupArgs',
    'TestSpecificationArgs',
    'TestTargetsForShardArgs',
    'ToolResultsHistoryArgs',
    'UniformShardingArgs',
]

@pulumi.input_type
class AccountArgs:
    def __init__(__self__, *,
                 google_auto: Optional[pulumi.Input['GoogleAutoArgs']] = None):
        """
        Identifies an account and how to log into it.
        :param pulumi.Input['GoogleAutoArgs'] google_auto: An automatic google login account.
        """
        if google_auto is not None:
            pulumi.set(__self__, "google_auto", google_auto)

    @property
    @pulumi.getter(name="googleAuto")
    def google_auto(self) -> Optional[pulumi.Input['GoogleAutoArgs']]:
        """
        An automatic google login account.
        """
        return pulumi.get(self, "google_auto")

    @google_auto.setter
    def google_auto(self, value: Optional[pulumi.Input['GoogleAutoArgs']]):
        pulumi.set(self, "google_auto", value)


@pulumi.input_type
class AndroidDeviceListArgs:
    def __init__(__self__, *,
                 android_devices: pulumi.Input[Sequence[pulumi.Input['AndroidDeviceArgs']]]):
        """
        A list of Android device configurations in which the test is to be executed.
        :param pulumi.Input[Sequence[pulumi.Input['AndroidDeviceArgs']]] android_devices: A list of Android devices.
        """
        pulumi.set(__self__, "android_devices", android_devices)

    @property
    @pulumi.getter(name="androidDevices")
    def android_devices(self) -> pulumi.Input[Sequence[pulumi.Input['AndroidDeviceArgs']]]:
        """
        A list of Android devices.
        """
        return pulumi.get(self, "android_devices")

    @android_devices.setter
    def android_devices(self, value: pulumi.Input[Sequence[pulumi.Input['AndroidDeviceArgs']]]):
        pulumi.set(self, "android_devices", value)


@pulumi.input_type
class AndroidDeviceArgs:
    def __init__(__self__, *,
                 android_model_id: pulumi.Input[str],
                 android_version_id: pulumi.Input[str],
                 locale: pulumi.Input[str],
                 orientation: pulumi.Input[str]):
        """
        A single Android device.
        :param pulumi.Input[str] android_model_id: The id of the Android device to be used. Use the TestEnvironmentDiscoveryService to get supported options.
        :param pulumi.Input[str] android_version_id: The id of the Android OS version to be used. Use the TestEnvironmentDiscoveryService to get supported options.
        :param pulumi.Input[str] locale: The locale the test device used for testing. Use the TestEnvironmentDiscoveryService to get supported options.
        :param pulumi.Input[str] orientation: How the device is oriented during the test. Use the TestEnvironmentDiscoveryService to get supported options.
        """
        pulumi.set(__self__, "android_model_id", android_model_id)
        pulumi.set(__self__, "android_version_id", android_version_id)
        pulumi.set(__self__, "locale", locale)
        pulumi.set(__self__, "orientation", orientation)

    @property
    @pulumi.getter(name="androidModelId")
    def android_model_id(self) -> pulumi.Input[str]:
        """
        The id of the Android device to be used. Use the TestEnvironmentDiscoveryService to get supported options.
        """
        return pulumi.get(self, "android_model_id")

    @android_model_id.setter
    def android_model_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "android_model_id", value)

    @property
    @pulumi.getter(name="androidVersionId")
    def android_version_id(self) -> pulumi.Input[str]:
        """
        The id of the Android OS version to be used. Use the TestEnvironmentDiscoveryService to get supported options.
        """
        return pulumi.get(self, "android_version_id")

    @android_version_id.setter
    def android_version_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "android_version_id", value)

    @property
    @pulumi.getter
    def locale(self) -> pulumi.Input[str]:
        """
        The locale the test device used for testing. Use the TestEnvironmentDiscoveryService to get supported options.
        """
        return pulumi.get(self, "locale")

    @locale.setter
    def locale(self, value: pulumi.Input[str]):
        pulumi.set(self, "locale", value)

    @property
    @pulumi.getter
    def orientation(self) -> pulumi.Input[str]:
        """
        How the device is oriented during the test. Use the TestEnvironmentDiscoveryService to get supported options.
        """
        return pulumi.get(self, "orientation")

    @orientation.setter
    def orientation(self, value: pulumi.Input[str]):
        pulumi.set(self, "orientation", value)


@pulumi.input_type
class AndroidInstrumentationTestArgs:
    def __init__(__self__, *,
                 test_apk: pulumi.Input['FileReferenceArgs'],
                 app_apk: Optional[pulumi.Input['FileReferenceArgs']] = None,
                 app_bundle: Optional[pulumi.Input['AppBundleArgs']] = None,
                 app_package_id: Optional[pulumi.Input[str]] = None,
                 orchestrator_option: Optional[pulumi.Input['AndroidInstrumentationTestOrchestratorOption']] = None,
                 sharding_option: Optional[pulumi.Input['ShardingOptionArgs']] = None,
                 test_package_id: Optional[pulumi.Input[str]] = None,
                 test_runner_class: Optional[pulumi.Input[str]] = None,
                 test_targets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        A test of an Android application that can control an Android component independently of its normal lifecycle. Android instrumentation tests run an application APK and test APK inside the same process on a virtual or physical AndroidDevice. They also specify a test runner class, such as com.google.GoogleTestRunner, which can vary on the specific instrumentation framework chosen. See for more information on types of Android tests.
        :param pulumi.Input['FileReferenceArgs'] test_apk: The APK containing the test code to be executed.
        :param pulumi.Input['FileReferenceArgs'] app_apk: The APK for the application under test.
        :param pulumi.Input['AppBundleArgs'] app_bundle: A multi-apk app bundle for the application under test.
        :param pulumi.Input[str] app_package_id: The java package for the application under test. The default value is determined by examining the application's manifest.
        :param pulumi.Input['AndroidInstrumentationTestOrchestratorOption'] orchestrator_option: The option of whether running each test within its own invocation of instrumentation with Android Test Orchestrator or not. ** Orchestrator is only compatible with AndroidJUnitRunner version 1.1 or higher! ** Orchestrator offers the following benefits: - No shared state - Crashes are isolated - Logs are scoped per test See for more information about Android Test Orchestrator. If not set, the test will be run without the orchestrator.
        :param pulumi.Input['ShardingOptionArgs'] sharding_option: The option to run tests in multiple shards in parallel.
        :param pulumi.Input[str] test_package_id: The java package for the test to be executed. The default value is determined by examining the application's manifest.
        :param pulumi.Input[str] test_runner_class: The InstrumentationTestRunner class. The default value is determined by examining the application's manifest.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] test_targets: Each target must be fully qualified with the package name or class name, in one of these formats: - "package package_name" - "class package_name.class_name" - "class package_name.class_name#method_name" If empty, all targets in the module will be run.
        """
        pulumi.set(__self__, "test_apk", test_apk)
        if app_apk is not None:
            pulumi.set(__self__, "app_apk", app_apk)
        if app_bundle is not None:
            pulumi.set(__self__, "app_bundle", app_bundle)
        if app_package_id is not None:
            pulumi.set(__self__, "app_package_id", app_package_id)
        if orchestrator_option is not None:
            pulumi.set(__self__, "orchestrator_option", orchestrator_option)
        if sharding_option is not None:
            pulumi.set(__self__, "sharding_option", sharding_option)
        if test_package_id is not None:
            pulumi.set(__self__, "test_package_id", test_package_id)
        if test_runner_class is not None:
            pulumi.set(__self__, "test_runner_class", test_runner_class)
        if test_targets is not None:
            pulumi.set(__self__, "test_targets", test_targets)

    @property
    @pulumi.getter(name="testApk")
    def test_apk(self) -> pulumi.Input['FileReferenceArgs']:
        """
        The APK containing the test code to be executed.
        """
        return pulumi.get(self, "test_apk")

    @test_apk.setter
    def test_apk(self, value: pulumi.Input['FileReferenceArgs']):
        pulumi.set(self, "test_apk", value)

    @property
    @pulumi.getter(name="appApk")
    def app_apk(self) -> Optional[pulumi.Input['FileReferenceArgs']]:
        """
        The APK for the application under test.
        """
        return pulumi.get(self, "app_apk")

    @app_apk.setter
    def app_apk(self, value: Optional[pulumi.Input['FileReferenceArgs']]):
        pulumi.set(self, "app_apk", value)

    @property
    @pulumi.getter(name="appBundle")
    def app_bundle(self) -> Optional[pulumi.Input['AppBundleArgs']]:
        """
        A multi-apk app bundle for the application under test.
        """
        return pulumi.get(self, "app_bundle")

    @app_bundle.setter
    def app_bundle(self, value: Optional[pulumi.Input['AppBundleArgs']]):
        pulumi.set(self, "app_bundle", value)

    @property
    @pulumi.getter(name="appPackageId")
    def app_package_id(self) -> Optional[pulumi.Input[str]]:
        """
        The java package for the application under test. The default value is determined by examining the application's manifest.
        """
        return pulumi.get(self, "app_package_id")

    @app_package_id.setter
    def app_package_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_package_id", value)

    @property
    @pulumi.getter(name="orchestratorOption")
    def orchestrator_option(self) -> Optional[pulumi.Input['AndroidInstrumentationTestOrchestratorOption']]:
        """
        The option of whether running each test within its own invocation of instrumentation with Android Test Orchestrator or not. ** Orchestrator is only compatible with AndroidJUnitRunner version 1.1 or higher! ** Orchestrator offers the following benefits: - No shared state - Crashes are isolated - Logs are scoped per test See for more information about Android Test Orchestrator. If not set, the test will be run without the orchestrator.
        """
        return pulumi.get(self, "orchestrator_option")

    @orchestrator_option.setter
    def orchestrator_option(self, value: Optional[pulumi.Input['AndroidInstrumentationTestOrchestratorOption']]):
        pulumi.set(self, "orchestrator_option", value)

    @property
    @pulumi.getter(name="shardingOption")
    def sharding_option(self) -> Optional[pulumi.Input['ShardingOptionArgs']]:
        """
        The option to run tests in multiple shards in parallel.
        """
        return pulumi.get(self, "sharding_option")

    @sharding_option.setter
    def sharding_option(self, value: Optional[pulumi.Input['ShardingOptionArgs']]):
        pulumi.set(self, "sharding_option", value)

    @property
    @pulumi.getter(name="testPackageId")
    def test_package_id(self) -> Optional[pulumi.Input[str]]:
        """
        The java package for the test to be executed. The default value is determined by examining the application's manifest.
        """
        return pulumi.get(self, "test_package_id")

    @test_package_id.setter
    def test_package_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "test_package_id", value)

    @property
    @pulumi.getter(name="testRunnerClass")
    def test_runner_class(self) -> Optional[pulumi.Input[str]]:
        """
        The InstrumentationTestRunner class. The default value is determined by examining the application's manifest.
        """
        return pulumi.get(self, "test_runner_class")

    @test_runner_class.setter
    def test_runner_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "test_runner_class", value)

    @property
    @pulumi.getter(name="testTargets")
    def test_targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Each target must be fully qualified with the package name or class name, in one of these formats: - "package package_name" - "class package_name.class_name" - "class package_name.class_name#method_name" If empty, all targets in the module will be run.
        """
        return pulumi.get(self, "test_targets")

    @test_targets.setter
    def test_targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "test_targets", value)


@pulumi.input_type
class AndroidMatrixArgs:
    def __init__(__self__, *,
                 android_model_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 android_version_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 locales: pulumi.Input[Sequence[pulumi.Input[str]]],
                 orientations: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        A set of Android device configuration permutations is defined by the the cross-product of the given axes. Internally, the given AndroidMatrix will be expanded into a set of AndroidDevices. Only supported permutations will be instantiated. Invalid permutations (e.g., incompatible models/versions) are ignored.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] android_model_ids: The ids of the set of Android device to be used. Use the TestEnvironmentDiscoveryService to get supported options.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] android_version_ids: The ids of the set of Android OS version to be used. Use the TestEnvironmentDiscoveryService to get supported options.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] locales: The set of locales the test device will enable for testing. Use the TestEnvironmentDiscoveryService to get supported options.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] orientations: The set of orientations to test with. Use the TestEnvironmentDiscoveryService to get supported options.
        """
        pulumi.set(__self__, "android_model_ids", android_model_ids)
        pulumi.set(__self__, "android_version_ids", android_version_ids)
        pulumi.set(__self__, "locales", locales)
        pulumi.set(__self__, "orientations", orientations)

    @property
    @pulumi.getter(name="androidModelIds")
    def android_model_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The ids of the set of Android device to be used. Use the TestEnvironmentDiscoveryService to get supported options.
        """
        return pulumi.get(self, "android_model_ids")

    @android_model_ids.setter
    def android_model_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "android_model_ids", value)

    @property
    @pulumi.getter(name="androidVersionIds")
    def android_version_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The ids of the set of Android OS version to be used. Use the TestEnvironmentDiscoveryService to get supported options.
        """
        return pulumi.get(self, "android_version_ids")

    @android_version_ids.setter
    def android_version_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "android_version_ids", value)

    @property
    @pulumi.getter
    def locales(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The set of locales the test device will enable for testing. Use the TestEnvironmentDiscoveryService to get supported options.
        """
        return pulumi.get(self, "locales")

    @locales.setter
    def locales(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "locales", value)

    @property
    @pulumi.getter
    def orientations(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The set of orientations to test with. Use the TestEnvironmentDiscoveryService to get supported options.
        """
        return pulumi.get(self, "orientations")

    @orientations.setter
    def orientations(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "orientations", value)


@pulumi.input_type
class AndroidRoboTestArgs:
    def __init__(__self__, *,
                 app_apk: Optional[pulumi.Input['FileReferenceArgs']] = None,
                 app_bundle: Optional[pulumi.Input['AppBundleArgs']] = None,
                 app_initial_activity: Optional[pulumi.Input[str]] = None,
                 app_package_id: Optional[pulumi.Input[str]] = None,
                 robo_directives: Optional[pulumi.Input[Sequence[pulumi.Input['RoboDirectiveArgs']]]] = None,
                 robo_mode: Optional[pulumi.Input['AndroidRoboTestRoboMode']] = None,
                 robo_script: Optional[pulumi.Input['FileReferenceArgs']] = None,
                 starting_intents: Optional[pulumi.Input[Sequence[pulumi.Input['RoboStartingIntentArgs']]]] = None):
        """
        A test of an android application that explores the application on a virtual or physical Android Device, finding culprits and crashes as it goes.
        :param pulumi.Input['FileReferenceArgs'] app_apk: The APK for the application under test.
        :param pulumi.Input['AppBundleArgs'] app_bundle: A multi-apk app bundle for the application under test.
        :param pulumi.Input[str] app_initial_activity: The initial activity that should be used to start the app.
        :param pulumi.Input[str] app_package_id: The java package for the application under test. The default value is determined by examining the application's manifest.
        :param pulumi.Input[Sequence[pulumi.Input['RoboDirectiveArgs']]] robo_directives: A set of directives Robo should apply during the crawl. This allows users to customize the crawl. For example, the username and password for a test account can be provided.
        :param pulumi.Input['AndroidRoboTestRoboMode'] robo_mode: The mode in which Robo should run. Most clients should allow the server to populate this field automatically.
        :param pulumi.Input['FileReferenceArgs'] robo_script: A JSON file with a sequence of actions Robo should perform as a prologue for the crawl.
        :param pulumi.Input[Sequence[pulumi.Input['RoboStartingIntentArgs']]] starting_intents: The intents used to launch the app for the crawl. If none are provided, then the main launcher activity is launched. If some are provided, then only those provided are launched (the main launcher activity must be provided explicitly).
        """
        if app_apk is not None:
            pulumi.set(__self__, "app_apk", app_apk)
        if app_bundle is not None:
            pulumi.set(__self__, "app_bundle", app_bundle)
        if app_initial_activity is not None:
            pulumi.set(__self__, "app_initial_activity", app_initial_activity)
        if app_package_id is not None:
            pulumi.set(__self__, "app_package_id", app_package_id)
        if robo_directives is not None:
            pulumi.set(__self__, "robo_directives", robo_directives)
        if robo_mode is not None:
            pulumi.set(__self__, "robo_mode", robo_mode)
        if robo_script is not None:
            pulumi.set(__self__, "robo_script", robo_script)
        if starting_intents is not None:
            pulumi.set(__self__, "starting_intents", starting_intents)

    @property
    @pulumi.getter(name="appApk")
    def app_apk(self) -> Optional[pulumi.Input['FileReferenceArgs']]:
        """
        The APK for the application under test.
        """
        return pulumi.get(self, "app_apk")

    @app_apk.setter
    def app_apk(self, value: Optional[pulumi.Input['FileReferenceArgs']]):
        pulumi.set(self, "app_apk", value)

    @property
    @pulumi.getter(name="appBundle")
    def app_bundle(self) -> Optional[pulumi.Input['AppBundleArgs']]:
        """
        A multi-apk app bundle for the application under test.
        """
        return pulumi.get(self, "app_bundle")

    @app_bundle.setter
    def app_bundle(self, value: Optional[pulumi.Input['AppBundleArgs']]):
        pulumi.set(self, "app_bundle", value)

    @property
    @pulumi.getter(name="appInitialActivity")
    def app_initial_activity(self) -> Optional[pulumi.Input[str]]:
        """
        The initial activity that should be used to start the app.
        """
        return pulumi.get(self, "app_initial_activity")

    @app_initial_activity.setter
    def app_initial_activity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_initial_activity", value)

    @property
    @pulumi.getter(name="appPackageId")
    def app_package_id(self) -> Optional[pulumi.Input[str]]:
        """
        The java package for the application under test. The default value is determined by examining the application's manifest.
        """
        return pulumi.get(self, "app_package_id")

    @app_package_id.setter
    def app_package_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_package_id", value)

    @property
    @pulumi.getter(name="roboDirectives")
    def robo_directives(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RoboDirectiveArgs']]]]:
        """
        A set of directives Robo should apply during the crawl. This allows users to customize the crawl. For example, the username and password for a test account can be provided.
        """
        return pulumi.get(self, "robo_directives")

    @robo_directives.setter
    def robo_directives(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RoboDirectiveArgs']]]]):
        pulumi.set(self, "robo_directives", value)

    @property
    @pulumi.getter(name="roboMode")
    def robo_mode(self) -> Optional[pulumi.Input['AndroidRoboTestRoboMode']]:
        """
        The mode in which Robo should run. Most clients should allow the server to populate this field automatically.
        """
        return pulumi.get(self, "robo_mode")

    @robo_mode.setter
    def robo_mode(self, value: Optional[pulumi.Input['AndroidRoboTestRoboMode']]):
        pulumi.set(self, "robo_mode", value)

    @property
    @pulumi.getter(name="roboScript")
    def robo_script(self) -> Optional[pulumi.Input['FileReferenceArgs']]:
        """
        A JSON file with a sequence of actions Robo should perform as a prologue for the crawl.
        """
        return pulumi.get(self, "robo_script")

    @robo_script.setter
    def robo_script(self, value: Optional[pulumi.Input['FileReferenceArgs']]):
        pulumi.set(self, "robo_script", value)

    @property
    @pulumi.getter(name="startingIntents")
    def starting_intents(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RoboStartingIntentArgs']]]]:
        """
        The intents used to launch the app for the crawl. If none are provided, then the main launcher activity is launched. If some are provided, then only those provided are launched (the main launcher activity must be provided explicitly).
        """
        return pulumi.get(self, "starting_intents")

    @starting_intents.setter
    def starting_intents(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RoboStartingIntentArgs']]]]):
        pulumi.set(self, "starting_intents", value)


@pulumi.input_type
class AndroidTestLoopArgs:
    def __init__(__self__, *,
                 app_apk: Optional[pulumi.Input['FileReferenceArgs']] = None,
                 app_bundle: Optional[pulumi.Input['AppBundleArgs']] = None,
                 app_package_id: Optional[pulumi.Input[str]] = None,
                 scenario_labels: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 scenarios: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None):
        """
        A test of an Android Application with a Test Loop. The intent \ will be implicitly added, since Games is the only user of this api, for the time being.
        :param pulumi.Input['FileReferenceArgs'] app_apk: The APK for the application under test.
        :param pulumi.Input['AppBundleArgs'] app_bundle: A multi-apk app bundle for the application under test.
        :param pulumi.Input[str] app_package_id: The java package for the application under test. The default is determined by examining the application's manifest.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] scenario_labels: The list of scenario labels that should be run during the test. The scenario labels should map to labels defined in the application's manifest. For example, player_experience and com.google.test.loops.player_experience add all of the loops labeled in the manifest with the com.google.test.loops.player_experience name to the execution. Scenarios can also be specified in the scenarios field.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] scenarios: The list of scenarios that should be run during the test. The default is all test loops, derived from the application's manifest.
        """
        if app_apk is not None:
            pulumi.set(__self__, "app_apk", app_apk)
        if app_bundle is not None:
            pulumi.set(__self__, "app_bundle", app_bundle)
        if app_package_id is not None:
            pulumi.set(__self__, "app_package_id", app_package_id)
        if scenario_labels is not None:
            pulumi.set(__self__, "scenario_labels", scenario_labels)
        if scenarios is not None:
            pulumi.set(__self__, "scenarios", scenarios)

    @property
    @pulumi.getter(name="appApk")
    def app_apk(self) -> Optional[pulumi.Input['FileReferenceArgs']]:
        """
        The APK for the application under test.
        """
        return pulumi.get(self, "app_apk")

    @app_apk.setter
    def app_apk(self, value: Optional[pulumi.Input['FileReferenceArgs']]):
        pulumi.set(self, "app_apk", value)

    @property
    @pulumi.getter(name="appBundle")
    def app_bundle(self) -> Optional[pulumi.Input['AppBundleArgs']]:
        """
        A multi-apk app bundle for the application under test.
        """
        return pulumi.get(self, "app_bundle")

    @app_bundle.setter
    def app_bundle(self, value: Optional[pulumi.Input['AppBundleArgs']]):
        pulumi.set(self, "app_bundle", value)

    @property
    @pulumi.getter(name="appPackageId")
    def app_package_id(self) -> Optional[pulumi.Input[str]]:
        """
        The java package for the application under test. The default is determined by examining the application's manifest.
        """
        return pulumi.get(self, "app_package_id")

    @app_package_id.setter
    def app_package_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_package_id", value)

    @property
    @pulumi.getter(name="scenarioLabels")
    def scenario_labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of scenario labels that should be run during the test. The scenario labels should map to labels defined in the application's manifest. For example, player_experience and com.google.test.loops.player_experience add all of the loops labeled in the manifest with the com.google.test.loops.player_experience name to the execution. Scenarios can also be specified in the scenarios field.
        """
        return pulumi.get(self, "scenario_labels")

    @scenario_labels.setter
    def scenario_labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "scenario_labels", value)

    @property
    @pulumi.getter
    def scenarios(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        The list of scenarios that should be run during the test. The default is all test loops, derived from the application's manifest.
        """
        return pulumi.get(self, "scenarios")

    @scenarios.setter
    def scenarios(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "scenarios", value)


@pulumi.input_type
class ApkArgs:
    def __init__(__self__, *,
                 location: Optional[pulumi.Input['FileReferenceArgs']] = None,
                 package_name: Optional[pulumi.Input[str]] = None):
        """
        An Android package file to install.
        :param pulumi.Input['FileReferenceArgs'] location: The path to an APK to be installed on the device before the test begins.
        :param pulumi.Input[str] package_name: The java package for the APK to be installed. Value is determined by examining the application's manifest.
        """
        if location is not None:
            pulumi.set(__self__, "location", location)
        if package_name is not None:
            pulumi.set(__self__, "package_name", package_name)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input['FileReferenceArgs']]:
        """
        The path to an APK to be installed on the device before the test begins.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input['FileReferenceArgs']]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="packageName")
    def package_name(self) -> Optional[pulumi.Input[str]]:
        """
        The java package for the APK to be installed. Value is determined by examining the application's manifest.
        """
        return pulumi.get(self, "package_name")

    @package_name.setter
    def package_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "package_name", value)


@pulumi.input_type
class AppBundleArgs:
    def __init__(__self__, *,
                 bundle_location: Optional[pulumi.Input['FileReferenceArgs']] = None):
        """
        An Android App Bundle file format, containing a BundleConfig.pb file, a base module directory, zero or more dynamic feature module directories. See https://developer.android.com/guide/app-bundle/build for guidance on building App Bundles.
        :param pulumi.Input['FileReferenceArgs'] bundle_location: .aab file representing the app bundle under test.
        """
        if bundle_location is not None:
            pulumi.set(__self__, "bundle_location", bundle_location)

    @property
    @pulumi.getter(name="bundleLocation")
    def bundle_location(self) -> Optional[pulumi.Input['FileReferenceArgs']]:
        """
        .aab file representing the app bundle under test.
        """
        return pulumi.get(self, "bundle_location")

    @bundle_location.setter
    def bundle_location(self, value: Optional[pulumi.Input['FileReferenceArgs']]):
        pulumi.set(self, "bundle_location", value)


@pulumi.input_type
class ClientInfoDetailArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        Key-value pair of detailed information about the client which invoked the test. Examples: {'Version', '1.0'}, {'Release Track', 'BETA'}.
        :param pulumi.Input[str] key: The key of detailed client information.
        :param pulumi.Input[str] value: The value of detailed client information.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The key of detailed client information.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The value of detailed client information.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ClientInfoArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 client_info_details: Optional[pulumi.Input[Sequence[pulumi.Input['ClientInfoDetailArgs']]]] = None):
        """
        Information about the client which invoked the test.
        :param pulumi.Input[str] name: Client name, such as gcloud.
        :param pulumi.Input[Sequence[pulumi.Input['ClientInfoDetailArgs']]] client_info_details: The list of detailed information about client.
        """
        pulumi.set(__self__, "name", name)
        if client_info_details is not None:
            pulumi.set(__self__, "client_info_details", client_info_details)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Client name, such as gcloud.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="clientInfoDetails")
    def client_info_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClientInfoDetailArgs']]]]:
        """
        The list of detailed information about client.
        """
        return pulumi.get(self, "client_info_details")

    @client_info_details.setter
    def client_info_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClientInfoDetailArgs']]]]):
        pulumi.set(self, "client_info_details", value)


@pulumi.input_type
class DeviceFileArgs:
    def __init__(__self__, *,
                 obb_file: Optional[pulumi.Input['ObbFileArgs']] = None,
                 regular_file: Optional[pulumi.Input['RegularFileArgs']] = None):
        """
        A single device file description.
        :param pulumi.Input['ObbFileArgs'] obb_file: A reference to an opaque binary blob file.
        :param pulumi.Input['RegularFileArgs'] regular_file: A reference to a regular file.
        """
        if obb_file is not None:
            pulumi.set(__self__, "obb_file", obb_file)
        if regular_file is not None:
            pulumi.set(__self__, "regular_file", regular_file)

    @property
    @pulumi.getter(name="obbFile")
    def obb_file(self) -> Optional[pulumi.Input['ObbFileArgs']]:
        """
        A reference to an opaque binary blob file.
        """
        return pulumi.get(self, "obb_file")

    @obb_file.setter
    def obb_file(self, value: Optional[pulumi.Input['ObbFileArgs']]):
        pulumi.set(self, "obb_file", value)

    @property
    @pulumi.getter(name="regularFile")
    def regular_file(self) -> Optional[pulumi.Input['RegularFileArgs']]:
        """
        A reference to a regular file.
        """
        return pulumi.get(self, "regular_file")

    @regular_file.setter
    def regular_file(self, value: Optional[pulumi.Input['RegularFileArgs']]):
        pulumi.set(self, "regular_file", value)


@pulumi.input_type
class EnvironmentMatrixArgs:
    def __init__(__self__, *,
                 android_device_list: Optional[pulumi.Input['AndroidDeviceListArgs']] = None,
                 android_matrix: Optional[pulumi.Input['AndroidMatrixArgs']] = None,
                 ios_device_list: Optional[pulumi.Input['IosDeviceListArgs']] = None):
        """
        The matrix of environments in which the test is to be executed.
        :param pulumi.Input['AndroidDeviceListArgs'] android_device_list: A list of Android devices; the test will be run only on the specified devices.
        :param pulumi.Input['AndroidMatrixArgs'] android_matrix: A matrix of Android devices.
        :param pulumi.Input['IosDeviceListArgs'] ios_device_list: A list of iOS devices.
        """
        if android_device_list is not None:
            pulumi.set(__self__, "android_device_list", android_device_list)
        if android_matrix is not None:
            pulumi.set(__self__, "android_matrix", android_matrix)
        if ios_device_list is not None:
            pulumi.set(__self__, "ios_device_list", ios_device_list)

    @property
    @pulumi.getter(name="androidDeviceList")
    def android_device_list(self) -> Optional[pulumi.Input['AndroidDeviceListArgs']]:
        """
        A list of Android devices; the test will be run only on the specified devices.
        """
        return pulumi.get(self, "android_device_list")

    @android_device_list.setter
    def android_device_list(self, value: Optional[pulumi.Input['AndroidDeviceListArgs']]):
        pulumi.set(self, "android_device_list", value)

    @property
    @pulumi.getter(name="androidMatrix")
    def android_matrix(self) -> Optional[pulumi.Input['AndroidMatrixArgs']]:
        """
        A matrix of Android devices.
        """
        return pulumi.get(self, "android_matrix")

    @android_matrix.setter
    def android_matrix(self, value: Optional[pulumi.Input['AndroidMatrixArgs']]):
        pulumi.set(self, "android_matrix", value)

    @property
    @pulumi.getter(name="iosDeviceList")
    def ios_device_list(self) -> Optional[pulumi.Input['IosDeviceListArgs']]:
        """
        A list of iOS devices.
        """
        return pulumi.get(self, "ios_device_list")

    @ios_device_list.setter
    def ios_device_list(self, value: Optional[pulumi.Input['IosDeviceListArgs']]):
        pulumi.set(self, "ios_device_list", value)


@pulumi.input_type
class EnvironmentVariableArgs:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        A key-value pair passed as an environment variable to the test.
        :param pulumi.Input[str] key: Key for the environment variable.
        :param pulumi.Input[str] value: Value for the environment variable.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        Key for the environment variable.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Value for the environment variable.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class FileReferenceArgs:
    def __init__(__self__, *,
                 gcs_path: Optional[pulumi.Input[str]] = None):
        """
        A reference to a file, used for user inputs.
        :param pulumi.Input[str] gcs_path: A path to a file in Google Cloud Storage. Example: gs://build-app-1414623860166/app%40debug-unaligned.apk These paths are expected to be url encoded (percent encoding)
        """
        if gcs_path is not None:
            pulumi.set(__self__, "gcs_path", gcs_path)

    @property
    @pulumi.getter(name="gcsPath")
    def gcs_path(self) -> Optional[pulumi.Input[str]]:
        """
        A path to a file in Google Cloud Storage. Example: gs://build-app-1414623860166/app%40debug-unaligned.apk These paths are expected to be url encoded (percent encoding)
        """
        return pulumi.get(self, "gcs_path")

    @gcs_path.setter
    def gcs_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gcs_path", value)


@pulumi.input_type
class GoogleAutoArgs:
    def __init__(__self__):
        """
        Enables automatic Google account login. If set, the service automatically generates a Google test account and adds it to the device, before executing the test. Note that test accounts might be reused. Many applications show their full set of functionalities when an account is present on the device. Logging into the device with these generated accounts allows testing more functionalities.
        """
        pass


@pulumi.input_type
class GoogleCloudStorageArgs:
    def __init__(__self__, *,
                 gcs_path: pulumi.Input[str]):
        """
        A storage location within Google cloud storage (GCS).
        :param pulumi.Input[str] gcs_path: The path to a directory in GCS that will eventually contain the results for this test. The requesting user must have write access on the bucket in the supplied path.
        """
        pulumi.set(__self__, "gcs_path", gcs_path)

    @property
    @pulumi.getter(name="gcsPath")
    def gcs_path(self) -> pulumi.Input[str]:
        """
        The path to a directory in GCS that will eventually contain the results for this test. The requesting user must have write access on the bucket in the supplied path.
        """
        return pulumi.get(self, "gcs_path")

    @gcs_path.setter
    def gcs_path(self, value: pulumi.Input[str]):
        pulumi.set(self, "gcs_path", value)


@pulumi.input_type
class IosDeviceFileArgs:
    def __init__(__self__, *,
                 bundle_id: Optional[pulumi.Input[str]] = None,
                 content: Optional[pulumi.Input['FileReferenceArgs']] = None,
                 device_path: Optional[pulumi.Input[str]] = None):
        """
        A file or directory to install on the device before the test starts.
        :param pulumi.Input[str] bundle_id: The bundle id of the app where this file lives. iOS apps sandbox their own filesystem, so app files must specify which app installed on the device.
        :param pulumi.Input['FileReferenceArgs'] content: The source file
        :param pulumi.Input[str] device_path: Location of the file on the device, inside the app's sandboxed filesystem
        """
        if bundle_id is not None:
            pulumi.set(__self__, "bundle_id", bundle_id)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if device_path is not None:
            pulumi.set(__self__, "device_path", device_path)

    @property
    @pulumi.getter(name="bundleId")
    def bundle_id(self) -> Optional[pulumi.Input[str]]:
        """
        The bundle id of the app where this file lives. iOS apps sandbox their own filesystem, so app files must specify which app installed on the device.
        """
        return pulumi.get(self, "bundle_id")

    @bundle_id.setter
    def bundle_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bundle_id", value)

    @property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input['FileReferenceArgs']]:
        """
        The source file
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input['FileReferenceArgs']]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter(name="devicePath")
    def device_path(self) -> Optional[pulumi.Input[str]]:
        """
        Location of the file on the device, inside the app's sandboxed filesystem
        """
        return pulumi.get(self, "device_path")

    @device_path.setter
    def device_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device_path", value)


@pulumi.input_type
class IosDeviceListArgs:
    def __init__(__self__, *,
                 ios_devices: pulumi.Input[Sequence[pulumi.Input['IosDeviceArgs']]]):
        """
        A list of iOS device configurations in which the test is to be executed.
        :param pulumi.Input[Sequence[pulumi.Input['IosDeviceArgs']]] ios_devices: A list of iOS devices.
        """
        pulumi.set(__self__, "ios_devices", ios_devices)

    @property
    @pulumi.getter(name="iosDevices")
    def ios_devices(self) -> pulumi.Input[Sequence[pulumi.Input['IosDeviceArgs']]]:
        """
        A list of iOS devices.
        """
        return pulumi.get(self, "ios_devices")

    @ios_devices.setter
    def ios_devices(self, value: pulumi.Input[Sequence[pulumi.Input['IosDeviceArgs']]]):
        pulumi.set(self, "ios_devices", value)


@pulumi.input_type
class IosDeviceArgs:
    def __init__(__self__, *,
                 ios_model_id: pulumi.Input[str],
                 ios_version_id: pulumi.Input[str],
                 locale: pulumi.Input[str],
                 orientation: pulumi.Input[str]):
        """
        A single iOS device.
        :param pulumi.Input[str] ios_model_id: The id of the iOS device to be used. Use the TestEnvironmentDiscoveryService to get supported options.
        :param pulumi.Input[str] ios_version_id: The id of the iOS major software version to be used. Use the TestEnvironmentDiscoveryService to get supported options.
        :param pulumi.Input[str] locale: The locale the test device used for testing. Use the TestEnvironmentDiscoveryService to get supported options.
        :param pulumi.Input[str] orientation: How the device is oriented during the test. Use the TestEnvironmentDiscoveryService to get supported options.
        """
        pulumi.set(__self__, "ios_model_id", ios_model_id)
        pulumi.set(__self__, "ios_version_id", ios_version_id)
        pulumi.set(__self__, "locale", locale)
        pulumi.set(__self__, "orientation", orientation)

    @property
    @pulumi.getter(name="iosModelId")
    def ios_model_id(self) -> pulumi.Input[str]:
        """
        The id of the iOS device to be used. Use the TestEnvironmentDiscoveryService to get supported options.
        """
        return pulumi.get(self, "ios_model_id")

    @ios_model_id.setter
    def ios_model_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "ios_model_id", value)

    @property
    @pulumi.getter(name="iosVersionId")
    def ios_version_id(self) -> pulumi.Input[str]:
        """
        The id of the iOS major software version to be used. Use the TestEnvironmentDiscoveryService to get supported options.
        """
        return pulumi.get(self, "ios_version_id")

    @ios_version_id.setter
    def ios_version_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "ios_version_id", value)

    @property
    @pulumi.getter
    def locale(self) -> pulumi.Input[str]:
        """
        The locale the test device used for testing. Use the TestEnvironmentDiscoveryService to get supported options.
        """
        return pulumi.get(self, "locale")

    @locale.setter
    def locale(self, value: pulumi.Input[str]):
        pulumi.set(self, "locale", value)

    @property
    @pulumi.getter
    def orientation(self) -> pulumi.Input[str]:
        """
        How the device is oriented during the test. Use the TestEnvironmentDiscoveryService to get supported options.
        """
        return pulumi.get(self, "orientation")

    @orientation.setter
    def orientation(self, value: pulumi.Input[str]):
        pulumi.set(self, "orientation", value)


@pulumi.input_type
class IosTestLoopArgs:
    def __init__(__self__, *,
                 app_ipa: pulumi.Input['FileReferenceArgs'],
                 scenarios: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None):
        """
        A test of an iOS application that implements one or more game loop scenarios. This test type accepts an archived application (.ipa file) and a list of integer scenarios that will be executed on the app sequentially.
        :param pulumi.Input['FileReferenceArgs'] app_ipa: The .ipa of the application to test.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] scenarios: The list of scenarios that should be run during the test. Defaults to the single scenario 0 if unspecified.
        """
        pulumi.set(__self__, "app_ipa", app_ipa)
        if scenarios is not None:
            pulumi.set(__self__, "scenarios", scenarios)

    @property
    @pulumi.getter(name="appIpa")
    def app_ipa(self) -> pulumi.Input['FileReferenceArgs']:
        """
        The .ipa of the application to test.
        """
        return pulumi.get(self, "app_ipa")

    @app_ipa.setter
    def app_ipa(self, value: pulumi.Input['FileReferenceArgs']):
        pulumi.set(self, "app_ipa", value)

    @property
    @pulumi.getter
    def scenarios(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        The list of scenarios that should be run during the test. Defaults to the single scenario 0 if unspecified.
        """
        return pulumi.get(self, "scenarios")

    @scenarios.setter
    def scenarios(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "scenarios", value)


@pulumi.input_type
class IosTestSetupArgs:
    def __init__(__self__, *,
                 additional_ipas: Optional[pulumi.Input[Sequence[pulumi.Input['FileReferenceArgs']]]] = None,
                 network_profile: Optional[pulumi.Input[str]] = None,
                 pull_directories: Optional[pulumi.Input[Sequence[pulumi.Input['IosDeviceFileArgs']]]] = None,
                 push_files: Optional[pulumi.Input[Sequence[pulumi.Input['IosDeviceFileArgs']]]] = None):
        """
        A description of how to set up an iOS device prior to running the test.
        :param pulumi.Input[Sequence[pulumi.Input['FileReferenceArgs']]] additional_ipas: iOS apps to install in addition to those being directly tested.
        :param pulumi.Input[str] network_profile: The network traffic profile used for running the test. Available network profiles can be queried by using the NETWORK_CONFIGURATION environment type when calling TestEnvironmentDiscoveryService.GetTestEnvironmentCatalog.
        :param pulumi.Input[Sequence[pulumi.Input['IosDeviceFileArgs']]] pull_directories: List of directories on the device to upload to Cloud Storage at the end of the test. Directories should either be in a shared directory (such as /private/var/mobile/Media) or within an accessible directory inside the app's filesystem (such as /Documents) by specifying the bundle ID.
        :param pulumi.Input[Sequence[pulumi.Input['IosDeviceFileArgs']]] push_files: List of files to push to the device before starting the test.
        """
        if additional_ipas is not None:
            pulumi.set(__self__, "additional_ipas", additional_ipas)
        if network_profile is not None:
            pulumi.set(__self__, "network_profile", network_profile)
        if pull_directories is not None:
            pulumi.set(__self__, "pull_directories", pull_directories)
        if push_files is not None:
            pulumi.set(__self__, "push_files", push_files)

    @property
    @pulumi.getter(name="additionalIpas")
    def additional_ipas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FileReferenceArgs']]]]:
        """
        iOS apps to install in addition to those being directly tested.
        """
        return pulumi.get(self, "additional_ipas")

    @additional_ipas.setter
    def additional_ipas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FileReferenceArgs']]]]):
        pulumi.set(self, "additional_ipas", value)

    @property
    @pulumi.getter(name="networkProfile")
    def network_profile(self) -> Optional[pulumi.Input[str]]:
        """
        The network traffic profile used for running the test. Available network profiles can be queried by using the NETWORK_CONFIGURATION environment type when calling TestEnvironmentDiscoveryService.GetTestEnvironmentCatalog.
        """
        return pulumi.get(self, "network_profile")

    @network_profile.setter
    def network_profile(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_profile", value)

    @property
    @pulumi.getter(name="pullDirectories")
    def pull_directories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IosDeviceFileArgs']]]]:
        """
        List of directories on the device to upload to Cloud Storage at the end of the test. Directories should either be in a shared directory (such as /private/var/mobile/Media) or within an accessible directory inside the app's filesystem (such as /Documents) by specifying the bundle ID.
        """
        return pulumi.get(self, "pull_directories")

    @pull_directories.setter
    def pull_directories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IosDeviceFileArgs']]]]):
        pulumi.set(self, "pull_directories", value)

    @property
    @pulumi.getter(name="pushFiles")
    def push_files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IosDeviceFileArgs']]]]:
        """
        List of files to push to the device before starting the test.
        """
        return pulumi.get(self, "push_files")

    @push_files.setter
    def push_files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IosDeviceFileArgs']]]]):
        pulumi.set(self, "push_files", value)


@pulumi.input_type
class IosXcTestArgs:
    def __init__(__self__, *,
                 tests_zip: pulumi.Input['FileReferenceArgs'],
                 test_special_entitlements: Optional[pulumi.Input[bool]] = None,
                 xcode_version: Optional[pulumi.Input[str]] = None,
                 xctestrun: Optional[pulumi.Input['FileReferenceArgs']] = None):
        """
        A test of an iOS application that uses the XCTest framework. Xcode supports the option to "build for testing", which generates an .xctestrun file that contains a test specification (arguments, test methods, etc). This test type accepts a zip file containing the .xctestrun file and the corresponding contents of the Build/Products directory that contains all the binaries needed to run the tests.
        :param pulumi.Input['FileReferenceArgs'] tests_zip: The .zip containing the .xctestrun file and the contents of the DerivedData/Build/Products directory. The .xctestrun file in this zip is ignored if the xctestrun field is specified.
        :param pulumi.Input[bool] test_special_entitlements: The option to test special app entitlements. Setting this would re-sign the app having special entitlements with an explicit application-identifier. Currently supports testing aps-environment entitlement.
        :param pulumi.Input[str] xcode_version: The Xcode version that should be used for the test. Use the TestEnvironmentDiscoveryService to get supported options. Defaults to the latest Xcode version Firebase Test Lab supports.
        :param pulumi.Input['FileReferenceArgs'] xctestrun: An .xctestrun file that will override the .xctestrun file in the tests zip. Because the .xctestrun file contains environment variables along with test methods to run and/or ignore, this can be useful for sharding tests. Default is taken from the tests zip.
        """
        pulumi.set(__self__, "tests_zip", tests_zip)
        if test_special_entitlements is not None:
            pulumi.set(__self__, "test_special_entitlements", test_special_entitlements)
        if xcode_version is not None:
            pulumi.set(__self__, "xcode_version", xcode_version)
        if xctestrun is not None:
            pulumi.set(__self__, "xctestrun", xctestrun)

    @property
    @pulumi.getter(name="testsZip")
    def tests_zip(self) -> pulumi.Input['FileReferenceArgs']:
        """
        The .zip containing the .xctestrun file and the contents of the DerivedData/Build/Products directory. The .xctestrun file in this zip is ignored if the xctestrun field is specified.
        """
        return pulumi.get(self, "tests_zip")

    @tests_zip.setter
    def tests_zip(self, value: pulumi.Input['FileReferenceArgs']):
        pulumi.set(self, "tests_zip", value)

    @property
    @pulumi.getter(name="testSpecialEntitlements")
    def test_special_entitlements(self) -> Optional[pulumi.Input[bool]]:
        """
        The option to test special app entitlements. Setting this would re-sign the app having special entitlements with an explicit application-identifier. Currently supports testing aps-environment entitlement.
        """
        return pulumi.get(self, "test_special_entitlements")

    @test_special_entitlements.setter
    def test_special_entitlements(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "test_special_entitlements", value)

    @property
    @pulumi.getter(name="xcodeVersion")
    def xcode_version(self) -> Optional[pulumi.Input[str]]:
        """
        The Xcode version that should be used for the test. Use the TestEnvironmentDiscoveryService to get supported options. Defaults to the latest Xcode version Firebase Test Lab supports.
        """
        return pulumi.get(self, "xcode_version")

    @xcode_version.setter
    def xcode_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "xcode_version", value)

    @property
    @pulumi.getter
    def xctestrun(self) -> Optional[pulumi.Input['FileReferenceArgs']]:
        """
        An .xctestrun file that will override the .xctestrun file in the tests zip. Because the .xctestrun file contains environment variables along with test methods to run and/or ignore, this can be useful for sharding tests. Default is taken from the tests zip.
        """
        return pulumi.get(self, "xctestrun")

    @xctestrun.setter
    def xctestrun(self, value: Optional[pulumi.Input['FileReferenceArgs']]):
        pulumi.set(self, "xctestrun", value)


@pulumi.input_type
class LauncherActivityIntentArgs:
    def __init__(__self__):
        """
        Specifies an intent that starts the main launcher activity.
        """
        pass


@pulumi.input_type
class ManualShardingArgs:
    def __init__(__self__, *,
                 test_targets_for_shard: pulumi.Input[Sequence[pulumi.Input['TestTargetsForShardArgs']]]):
        """
        Shards test cases into the specified groups of packages, classes, and/or methods. With manual sharding enabled, specifying test targets via environment_variables or in InstrumentationTest is invalid.
        :param pulumi.Input[Sequence[pulumi.Input['TestTargetsForShardArgs']]] test_targets_for_shard: Group of packages, classes, and/or test methods to be run for each shard. When any physical devices are selected, the number of test_targets_for_shard must be >= 1 and <= 50. When no physical devices are selected, the number must be >= 1 and <= 500.
        """
        pulumi.set(__self__, "test_targets_for_shard", test_targets_for_shard)

    @property
    @pulumi.getter(name="testTargetsForShard")
    def test_targets_for_shard(self) -> pulumi.Input[Sequence[pulumi.Input['TestTargetsForShardArgs']]]:
        """
        Group of packages, classes, and/or test methods to be run for each shard. When any physical devices are selected, the number of test_targets_for_shard must be >= 1 and <= 50. When no physical devices are selected, the number must be >= 1 and <= 500.
        """
        return pulumi.get(self, "test_targets_for_shard")

    @test_targets_for_shard.setter
    def test_targets_for_shard(self, value: pulumi.Input[Sequence[pulumi.Input['TestTargetsForShardArgs']]]):
        pulumi.set(self, "test_targets_for_shard", value)


@pulumi.input_type
class ObbFileArgs:
    def __init__(__self__, *,
                 obb: pulumi.Input['FileReferenceArgs'],
                 obb_file_name: pulumi.Input[str]):
        """
        An opaque binary blob file to install on the device before the test starts.
        :param pulumi.Input['FileReferenceArgs'] obb: Opaque Binary Blob (OBB) file(s) to install on the device.
        :param pulumi.Input[str] obb_file_name: OBB file name which must conform to the format as specified by Android e.g. [main|patch].0300110.com.example.android.obb which will be installed into \/Android/obb/\/ on the device.
        """
        pulumi.set(__self__, "obb", obb)
        pulumi.set(__self__, "obb_file_name", obb_file_name)

    @property
    @pulumi.getter
    def obb(self) -> pulumi.Input['FileReferenceArgs']:
        """
        Opaque Binary Blob (OBB) file(s) to install on the device.
        """
        return pulumi.get(self, "obb")

    @obb.setter
    def obb(self, value: pulumi.Input['FileReferenceArgs']):
        pulumi.set(self, "obb", value)

    @property
    @pulumi.getter(name="obbFileName")
    def obb_file_name(self) -> pulumi.Input[str]:
        """
        OBB file name which must conform to the format as specified by Android e.g. [main|patch].0300110.com.example.android.obb which will be installed into \/Android/obb/\/ on the device.
        """
        return pulumi.get(self, "obb_file_name")

    @obb_file_name.setter
    def obb_file_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "obb_file_name", value)


@pulumi.input_type
class RegularFileArgs:
    def __init__(__self__, *,
                 content: pulumi.Input['FileReferenceArgs'],
                 device_path: pulumi.Input[str]):
        """
        A file or directory to install on the device before the test starts.
        :param pulumi.Input['FileReferenceArgs'] content: The source file.
        :param pulumi.Input[str] device_path: Where to put the content on the device. Must be an absolute, allowlisted path. If the file exists, it will be replaced. The following device-side directories and any of their subdirectories are allowlisted: ${EXTERNAL_STORAGE}, /sdcard, or /storage ${ANDROID_DATA}/local/tmp, or /data/local/tmp Specifying a path outside of these directory trees is invalid. The paths /sdcard and /data will be made available and treated as implicit path substitutions. E.g. if /sdcard on a particular device does not map to external storage, the system will replace it with the external storage path prefix for that device and copy the file there. It is strongly advised to use the Environment API in app and test code to access files on the device in a portable way.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "device_path", device_path)

    @property
    @pulumi.getter
    def content(self) -> pulumi.Input['FileReferenceArgs']:
        """
        The source file.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: pulumi.Input['FileReferenceArgs']):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter(name="devicePath")
    def device_path(self) -> pulumi.Input[str]:
        """
        Where to put the content on the device. Must be an absolute, allowlisted path. If the file exists, it will be replaced. The following device-side directories and any of their subdirectories are allowlisted: ${EXTERNAL_STORAGE}, /sdcard, or /storage ${ANDROID_DATA}/local/tmp, or /data/local/tmp Specifying a path outside of these directory trees is invalid. The paths /sdcard and /data will be made available and treated as implicit path substitutions. E.g. if /sdcard on a particular device does not map to external storage, the system will replace it with the external storage path prefix for that device and copy the file there. It is strongly advised to use the Environment API in app and test code to access files on the device in a portable way.
        """
        return pulumi.get(self, "device_path")

    @device_path.setter
    def device_path(self, value: pulumi.Input[str]):
        pulumi.set(self, "device_path", value)


@pulumi.input_type
class ResultStorageArgs:
    def __init__(__self__, *,
                 google_cloud_storage: pulumi.Input['GoogleCloudStorageArgs'],
                 tool_results_history: Optional[pulumi.Input['ToolResultsHistoryArgs']] = None):
        """
        Locations where the results of running the test are stored.
        :param pulumi.Input['GoogleCloudStorageArgs'] google_cloud_storage: Required.
        :param pulumi.Input['ToolResultsHistoryArgs'] tool_results_history: The tool results history that contains the tool results execution that results are written to. If not provided, the service will choose an appropriate value.
        """
        pulumi.set(__self__, "google_cloud_storage", google_cloud_storage)
        if tool_results_history is not None:
            pulumi.set(__self__, "tool_results_history", tool_results_history)

    @property
    @pulumi.getter(name="googleCloudStorage")
    def google_cloud_storage(self) -> pulumi.Input['GoogleCloudStorageArgs']:
        """
        Required.
        """
        return pulumi.get(self, "google_cloud_storage")

    @google_cloud_storage.setter
    def google_cloud_storage(self, value: pulumi.Input['GoogleCloudStorageArgs']):
        pulumi.set(self, "google_cloud_storage", value)

    @property
    @pulumi.getter(name="toolResultsHistory")
    def tool_results_history(self) -> Optional[pulumi.Input['ToolResultsHistoryArgs']]:
        """
        The tool results history that contains the tool results execution that results are written to. If not provided, the service will choose an appropriate value.
        """
        return pulumi.get(self, "tool_results_history")

    @tool_results_history.setter
    def tool_results_history(self, value: Optional[pulumi.Input['ToolResultsHistoryArgs']]):
        pulumi.set(self, "tool_results_history", value)


@pulumi.input_type
class RoboDirectiveArgs:
    def __init__(__self__, *,
                 action_type: pulumi.Input['RoboDirectiveActionType'],
                 resource_name: pulumi.Input[str],
                 input_text: Optional[pulumi.Input[str]] = None):
        """
        Directs Robo to interact with a specific UI element if it is encountered during the crawl. Currently, Robo can perform text entry or element click.
        :param pulumi.Input['RoboDirectiveActionType'] action_type: The type of action that Robo should perform on the specified element.
        :param pulumi.Input[str] resource_name: The android resource name of the target UI element. For example, in Java: R.string.foo in xml: @string/foo Only the "foo" part is needed. Reference doc: https://developer.android.com/guide/topics/resources/accessing-resources.html
        :param pulumi.Input[str] input_text: The text that Robo is directed to set. If left empty, the directive will be treated as a CLICK on the element matching the resource_name.
        """
        pulumi.set(__self__, "action_type", action_type)
        pulumi.set(__self__, "resource_name", resource_name)
        if input_text is not None:
            pulumi.set(__self__, "input_text", input_text)

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> pulumi.Input['RoboDirectiveActionType']:
        """
        The type of action that Robo should perform on the specified element.
        """
        return pulumi.get(self, "action_type")

    @action_type.setter
    def action_type(self, value: pulumi.Input['RoboDirectiveActionType']):
        pulumi.set(self, "action_type", value)

    @property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> pulumi.Input[str]:
        """
        The android resource name of the target UI element. For example, in Java: R.string.foo in xml: @string/foo Only the "foo" part is needed. Reference doc: https://developer.android.com/guide/topics/resources/accessing-resources.html
        """
        return pulumi.get(self, "resource_name")

    @resource_name.setter
    def resource_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_name", value)

    @property
    @pulumi.getter(name="inputText")
    def input_text(self) -> Optional[pulumi.Input[str]]:
        """
        The text that Robo is directed to set. If left empty, the directive will be treated as a CLICK on the element matching the resource_name.
        """
        return pulumi.get(self, "input_text")

    @input_text.setter
    def input_text(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "input_text", value)


@pulumi.input_type
class RoboStartingIntentArgs:
    def __init__(__self__, *,
                 launcher_activity: Optional[pulumi.Input['LauncherActivityIntentArgs']] = None,
                 start_activity: Optional[pulumi.Input['StartActivityIntentArgs']] = None,
                 timeout: Optional[pulumi.Input[str]] = None):
        """
        Message for specifying the start activities to crawl.
        :param pulumi.Input['LauncherActivityIntentArgs'] launcher_activity: An intent that starts the main launcher activity.
        :param pulumi.Input['StartActivityIntentArgs'] start_activity: An intent that starts an activity with specific details.
        :param pulumi.Input[str] timeout: Timeout in seconds for each intent.
        """
        if launcher_activity is not None:
            pulumi.set(__self__, "launcher_activity", launcher_activity)
        if start_activity is not None:
            pulumi.set(__self__, "start_activity", start_activity)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter(name="launcherActivity")
    def launcher_activity(self) -> Optional[pulumi.Input['LauncherActivityIntentArgs']]:
        """
        An intent that starts the main launcher activity.
        """
        return pulumi.get(self, "launcher_activity")

    @launcher_activity.setter
    def launcher_activity(self, value: Optional[pulumi.Input['LauncherActivityIntentArgs']]):
        pulumi.set(self, "launcher_activity", value)

    @property
    @pulumi.getter(name="startActivity")
    def start_activity(self) -> Optional[pulumi.Input['StartActivityIntentArgs']]:
        """
        An intent that starts an activity with specific details.
        """
        return pulumi.get(self, "start_activity")

    @start_activity.setter
    def start_activity(self, value: Optional[pulumi.Input['StartActivityIntentArgs']]):
        pulumi.set(self, "start_activity", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[str]]:
        """
        Timeout in seconds for each intent.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timeout", value)


@pulumi.input_type
class ShardingOptionArgs:
    def __init__(__self__, *,
                 manual_sharding: Optional[pulumi.Input['ManualShardingArgs']] = None,
                 uniform_sharding: Optional[pulumi.Input['UniformShardingArgs']] = None):
        """
        Options for enabling sharding.
        :param pulumi.Input['ManualShardingArgs'] manual_sharding: Shards test cases into the specified groups of packages, classes, and/or methods.
        :param pulumi.Input['UniformShardingArgs'] uniform_sharding: Uniformly shards test cases given a total number of shards.
        """
        if manual_sharding is not None:
            pulumi.set(__self__, "manual_sharding", manual_sharding)
        if uniform_sharding is not None:
            pulumi.set(__self__, "uniform_sharding", uniform_sharding)

    @property
    @pulumi.getter(name="manualSharding")
    def manual_sharding(self) -> Optional[pulumi.Input['ManualShardingArgs']]:
        """
        Shards test cases into the specified groups of packages, classes, and/or methods.
        """
        return pulumi.get(self, "manual_sharding")

    @manual_sharding.setter
    def manual_sharding(self, value: Optional[pulumi.Input['ManualShardingArgs']]):
        pulumi.set(self, "manual_sharding", value)

    @property
    @pulumi.getter(name="uniformSharding")
    def uniform_sharding(self) -> Optional[pulumi.Input['UniformShardingArgs']]:
        """
        Uniformly shards test cases given a total number of shards.
        """
        return pulumi.get(self, "uniform_sharding")

    @uniform_sharding.setter
    def uniform_sharding(self, value: Optional[pulumi.Input['UniformShardingArgs']]):
        pulumi.set(self, "uniform_sharding", value)


@pulumi.input_type
class StartActivityIntentArgs:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[str]] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 uri: Optional[pulumi.Input[str]] = None):
        """
        A starting intent specified by an action, uri, and categories.
        :param pulumi.Input[str] action: Action name. Required for START_ACTIVITY.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] categories: Intent categories to set on the intent.
        :param pulumi.Input[str] uri: URI for the action.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[str]]:
        """
        Action name. Required for START_ACTIVITY.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Intent categories to set on the intent.
        """
        return pulumi.get(self, "categories")

    @categories.setter
    def categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "categories", value)

    @property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[str]]:
        """
        URI for the action.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uri", value)


@pulumi.input_type
class SystraceSetupArgs:
    def __init__(__self__, *,
                 duration_seconds: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] duration_seconds: Systrace duration in seconds. Should be between 1 and 30 seconds. 0 disables systrace.
        """
        if duration_seconds is not None:
            pulumi.set(__self__, "duration_seconds", duration_seconds)

    @property
    @pulumi.getter(name="durationSeconds")
    def duration_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Systrace duration in seconds. Should be between 1 and 30 seconds. 0 disables systrace.
        """
        return pulumi.get(self, "duration_seconds")

    @duration_seconds.setter
    def duration_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "duration_seconds", value)


@pulumi.input_type
class TestSetupArgs:
    def __init__(__self__, *,
                 account: Optional[pulumi.Input['AccountArgs']] = None,
                 additional_apks: Optional[pulumi.Input[Sequence[pulumi.Input['ApkArgs']]]] = None,
                 directories_to_pull: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 dont_autogrant_permissions: Optional[pulumi.Input[bool]] = None,
                 environment_variables: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentVariableArgs']]]] = None,
                 files_to_push: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceFileArgs']]]] = None,
                 network_profile: Optional[pulumi.Input[str]] = None,
                 systrace: Optional[pulumi.Input['SystraceSetupArgs']] = None):
        """
        A description of how to set up the Android device prior to running the test.
        :param pulumi.Input['AccountArgs'] account: The device will be logged in on this account for the duration of the test.
        :param pulumi.Input[Sequence[pulumi.Input['ApkArgs']]] additional_apks: APKs to install in addition to those being directly tested. Currently capped at 100.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] directories_to_pull: List of directories on the device to upload to GCS at the end of the test; they must be absolute paths under /sdcard, /storage or /data/local/tmp. Path names are restricted to characters a-z A-Z 0-9 _ - . + and / Note: The paths /sdcard and /data will be made available and treated as implicit path substitutions. E.g. if /sdcard on a particular device does not map to external storage, the system will replace it with the external storage path prefix for that device.
        :param pulumi.Input[bool] dont_autogrant_permissions: Whether to prevent all runtime permissions to be granted at app install
        :param pulumi.Input[Sequence[pulumi.Input['EnvironmentVariableArgs']]] environment_variables: Environment variables to set for the test (only applicable for instrumentation tests).
        :param pulumi.Input[Sequence[pulumi.Input['DeviceFileArgs']]] files_to_push: List of files to push to the device before starting the test.
        :param pulumi.Input[str] network_profile: The network traffic profile used for running the test. Available network profiles can be queried by using the NETWORK_CONFIGURATION environment type when calling TestEnvironmentDiscoveryService.GetTestEnvironmentCatalog.
        :param pulumi.Input['SystraceSetupArgs'] systrace: Deprecated: Systrace uses Python 2 which has been sunset 2020-01-01. Support of Systrace may stop at any time, at which point no Systrace file will be provided in the results. Systrace configuration for the run. If set a systrace will be taken, starting on test start and lasting for the configured duration. The systrace file thus obtained is put in the results bucket together with the other artifacts from the run.
        """
        if account is not None:
            pulumi.set(__self__, "account", account)
        if additional_apks is not None:
            pulumi.set(__self__, "additional_apks", additional_apks)
        if directories_to_pull is not None:
            pulumi.set(__self__, "directories_to_pull", directories_to_pull)
        if dont_autogrant_permissions is not None:
            pulumi.set(__self__, "dont_autogrant_permissions", dont_autogrant_permissions)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if files_to_push is not None:
            pulumi.set(__self__, "files_to_push", files_to_push)
        if network_profile is not None:
            pulumi.set(__self__, "network_profile", network_profile)
        if systrace is not None:
            warnings.warn("""Deprecated: Systrace uses Python 2 which has been sunset 2020-01-01. Support of Systrace may stop at any time, at which point no Systrace file will be provided in the results. Systrace configuration for the run. If set a systrace will be taken, starting on test start and lasting for the configured duration. The systrace file thus obtained is put in the results bucket together with the other artifacts from the run.""", DeprecationWarning)
            pulumi.log.warn("""systrace is deprecated: Deprecated: Systrace uses Python 2 which has been sunset 2020-01-01. Support of Systrace may stop at any time, at which point no Systrace file will be provided in the results. Systrace configuration for the run. If set a systrace will be taken, starting on test start and lasting for the configured duration. The systrace file thus obtained is put in the results bucket together with the other artifacts from the run.""")
        if systrace is not None:
            pulumi.set(__self__, "systrace", systrace)

    @property
    @pulumi.getter
    def account(self) -> Optional[pulumi.Input['AccountArgs']]:
        """
        The device will be logged in on this account for the duration of the test.
        """
        return pulumi.get(self, "account")

    @account.setter
    def account(self, value: Optional[pulumi.Input['AccountArgs']]):
        pulumi.set(self, "account", value)

    @property
    @pulumi.getter(name="additionalApks")
    def additional_apks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApkArgs']]]]:
        """
        APKs to install in addition to those being directly tested. Currently capped at 100.
        """
        return pulumi.get(self, "additional_apks")

    @additional_apks.setter
    def additional_apks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApkArgs']]]]):
        pulumi.set(self, "additional_apks", value)

    @property
    @pulumi.getter(name="directoriesToPull")
    def directories_to_pull(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of directories on the device to upload to GCS at the end of the test; they must be absolute paths under /sdcard, /storage or /data/local/tmp. Path names are restricted to characters a-z A-Z 0-9 _ - . + and / Note: The paths /sdcard and /data will be made available and treated as implicit path substitutions. E.g. if /sdcard on a particular device does not map to external storage, the system will replace it with the external storage path prefix for that device.
        """
        return pulumi.get(self, "directories_to_pull")

    @directories_to_pull.setter
    def directories_to_pull(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "directories_to_pull", value)

    @property
    @pulumi.getter(name="dontAutograntPermissions")
    def dont_autogrant_permissions(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to prevent all runtime permissions to be granted at app install
        """
        return pulumi.get(self, "dont_autogrant_permissions")

    @dont_autogrant_permissions.setter
    def dont_autogrant_permissions(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dont_autogrant_permissions", value)

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentVariableArgs']]]]:
        """
        Environment variables to set for the test (only applicable for instrumentation tests).
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentVariableArgs']]]]):
        pulumi.set(self, "environment_variables", value)

    @property
    @pulumi.getter(name="filesToPush")
    def files_to_push(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DeviceFileArgs']]]]:
        """
        List of files to push to the device before starting the test.
        """
        return pulumi.get(self, "files_to_push")

    @files_to_push.setter
    def files_to_push(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DeviceFileArgs']]]]):
        pulumi.set(self, "files_to_push", value)

    @property
    @pulumi.getter(name="networkProfile")
    def network_profile(self) -> Optional[pulumi.Input[str]]:
        """
        The network traffic profile used for running the test. Available network profiles can be queried by using the NETWORK_CONFIGURATION environment type when calling TestEnvironmentDiscoveryService.GetTestEnvironmentCatalog.
        """
        return pulumi.get(self, "network_profile")

    @network_profile.setter
    def network_profile(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_profile", value)

    @property
    @pulumi.getter
    def systrace(self) -> Optional[pulumi.Input['SystraceSetupArgs']]:
        """
        Deprecated: Systrace uses Python 2 which has been sunset 2020-01-01. Support of Systrace may stop at any time, at which point no Systrace file will be provided in the results. Systrace configuration for the run. If set a systrace will be taken, starting on test start and lasting for the configured duration. The systrace file thus obtained is put in the results bucket together with the other artifacts from the run.
        """
        return pulumi.get(self, "systrace")

    @systrace.setter
    def systrace(self, value: Optional[pulumi.Input['SystraceSetupArgs']]):
        pulumi.set(self, "systrace", value)


@pulumi.input_type
class TestSpecificationArgs:
    def __init__(__self__, *,
                 android_instrumentation_test: Optional[pulumi.Input['AndroidInstrumentationTestArgs']] = None,
                 android_robo_test: Optional[pulumi.Input['AndroidRoboTestArgs']] = None,
                 android_test_loop: Optional[pulumi.Input['AndroidTestLoopArgs']] = None,
                 disable_performance_metrics: Optional[pulumi.Input[bool]] = None,
                 disable_video_recording: Optional[pulumi.Input[bool]] = None,
                 ios_test_loop: Optional[pulumi.Input['IosTestLoopArgs']] = None,
                 ios_test_setup: Optional[pulumi.Input['IosTestSetupArgs']] = None,
                 ios_xc_test: Optional[pulumi.Input['IosXcTestArgs']] = None,
                 test_setup: Optional[pulumi.Input['TestSetupArgs']] = None,
                 test_timeout: Optional[pulumi.Input[str]] = None):
        """
        A description of how to run the test.
        :param pulumi.Input['AndroidInstrumentationTestArgs'] android_instrumentation_test: An Android instrumentation test.
        :param pulumi.Input['AndroidRoboTestArgs'] android_robo_test: An Android robo test.
        :param pulumi.Input['AndroidTestLoopArgs'] android_test_loop: An Android Application with a Test Loop.
        :param pulumi.Input[bool] disable_performance_metrics: Disables performance metrics recording. May reduce test latency.
        :param pulumi.Input[bool] disable_video_recording: Disables video recording. May reduce test latency.
        :param pulumi.Input['IosTestLoopArgs'] ios_test_loop: An iOS application with a test loop.
        :param pulumi.Input['IosTestSetupArgs'] ios_test_setup: Test setup requirements for iOS.
        :param pulumi.Input['IosXcTestArgs'] ios_xc_test: An iOS XCTest, via an .xctestrun file.
        :param pulumi.Input['TestSetupArgs'] test_setup: Test setup requirements for Android e.g. files to install, bootstrap scripts.
        :param pulumi.Input[str] test_timeout: Max time a test execution is allowed to run before it is automatically cancelled. The default value is 5 min.
        """
        if android_instrumentation_test is not None:
            pulumi.set(__self__, "android_instrumentation_test", android_instrumentation_test)
        if android_robo_test is not None:
            pulumi.set(__self__, "android_robo_test", android_robo_test)
        if android_test_loop is not None:
            pulumi.set(__self__, "android_test_loop", android_test_loop)
        if disable_performance_metrics is not None:
            pulumi.set(__self__, "disable_performance_metrics", disable_performance_metrics)
        if disable_video_recording is not None:
            pulumi.set(__self__, "disable_video_recording", disable_video_recording)
        if ios_test_loop is not None:
            pulumi.set(__self__, "ios_test_loop", ios_test_loop)
        if ios_test_setup is not None:
            pulumi.set(__self__, "ios_test_setup", ios_test_setup)
        if ios_xc_test is not None:
            pulumi.set(__self__, "ios_xc_test", ios_xc_test)
        if test_setup is not None:
            pulumi.set(__self__, "test_setup", test_setup)
        if test_timeout is not None:
            pulumi.set(__self__, "test_timeout", test_timeout)

    @property
    @pulumi.getter(name="androidInstrumentationTest")
    def android_instrumentation_test(self) -> Optional[pulumi.Input['AndroidInstrumentationTestArgs']]:
        """
        An Android instrumentation test.
        """
        return pulumi.get(self, "android_instrumentation_test")

    @android_instrumentation_test.setter
    def android_instrumentation_test(self, value: Optional[pulumi.Input['AndroidInstrumentationTestArgs']]):
        pulumi.set(self, "android_instrumentation_test", value)

    @property
    @pulumi.getter(name="androidRoboTest")
    def android_robo_test(self) -> Optional[pulumi.Input['AndroidRoboTestArgs']]:
        """
        An Android robo test.
        """
        return pulumi.get(self, "android_robo_test")

    @android_robo_test.setter
    def android_robo_test(self, value: Optional[pulumi.Input['AndroidRoboTestArgs']]):
        pulumi.set(self, "android_robo_test", value)

    @property
    @pulumi.getter(name="androidTestLoop")
    def android_test_loop(self) -> Optional[pulumi.Input['AndroidTestLoopArgs']]:
        """
        An Android Application with a Test Loop.
        """
        return pulumi.get(self, "android_test_loop")

    @android_test_loop.setter
    def android_test_loop(self, value: Optional[pulumi.Input['AndroidTestLoopArgs']]):
        pulumi.set(self, "android_test_loop", value)

    @property
    @pulumi.getter(name="disablePerformanceMetrics")
    def disable_performance_metrics(self) -> Optional[pulumi.Input[bool]]:
        """
        Disables performance metrics recording. May reduce test latency.
        """
        return pulumi.get(self, "disable_performance_metrics")

    @disable_performance_metrics.setter
    def disable_performance_metrics(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_performance_metrics", value)

    @property
    @pulumi.getter(name="disableVideoRecording")
    def disable_video_recording(self) -> Optional[pulumi.Input[bool]]:
        """
        Disables video recording. May reduce test latency.
        """
        return pulumi.get(self, "disable_video_recording")

    @disable_video_recording.setter
    def disable_video_recording(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_video_recording", value)

    @property
    @pulumi.getter(name="iosTestLoop")
    def ios_test_loop(self) -> Optional[pulumi.Input['IosTestLoopArgs']]:
        """
        An iOS application with a test loop.
        """
        return pulumi.get(self, "ios_test_loop")

    @ios_test_loop.setter
    def ios_test_loop(self, value: Optional[pulumi.Input['IosTestLoopArgs']]):
        pulumi.set(self, "ios_test_loop", value)

    @property
    @pulumi.getter(name="iosTestSetup")
    def ios_test_setup(self) -> Optional[pulumi.Input['IosTestSetupArgs']]:
        """
        Test setup requirements for iOS.
        """
        return pulumi.get(self, "ios_test_setup")

    @ios_test_setup.setter
    def ios_test_setup(self, value: Optional[pulumi.Input['IosTestSetupArgs']]):
        pulumi.set(self, "ios_test_setup", value)

    @property
    @pulumi.getter(name="iosXcTest")
    def ios_xc_test(self) -> Optional[pulumi.Input['IosXcTestArgs']]:
        """
        An iOS XCTest, via an .xctestrun file.
        """
        return pulumi.get(self, "ios_xc_test")

    @ios_xc_test.setter
    def ios_xc_test(self, value: Optional[pulumi.Input['IosXcTestArgs']]):
        pulumi.set(self, "ios_xc_test", value)

    @property
    @pulumi.getter(name="testSetup")
    def test_setup(self) -> Optional[pulumi.Input['TestSetupArgs']]:
        """
        Test setup requirements for Android e.g. files to install, bootstrap scripts.
        """
        return pulumi.get(self, "test_setup")

    @test_setup.setter
    def test_setup(self, value: Optional[pulumi.Input['TestSetupArgs']]):
        pulumi.set(self, "test_setup", value)

    @property
    @pulumi.getter(name="testTimeout")
    def test_timeout(self) -> Optional[pulumi.Input[str]]:
        """
        Max time a test execution is allowed to run before it is automatically cancelled. The default value is 5 min.
        """
        return pulumi.get(self, "test_timeout")

    @test_timeout.setter
    def test_timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "test_timeout", value)


@pulumi.input_type
class TestTargetsForShardArgs:
    def __init__(__self__, *,
                 test_targets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Test targets for a shard.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] test_targets: Group of packages, classes, and/or test methods to be run for each shard. The targets need to be specified in AndroidJUnitRunner argument format. For example, "package com.my.packages" "class com.my.package.MyClass". The number of shard_test_targets must be greater than 0.
        """
        if test_targets is not None:
            pulumi.set(__self__, "test_targets", test_targets)

    @property
    @pulumi.getter(name="testTargets")
    def test_targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Group of packages, classes, and/or test methods to be run for each shard. The targets need to be specified in AndroidJUnitRunner argument format. For example, "package com.my.packages" "class com.my.package.MyClass". The number of shard_test_targets must be greater than 0.
        """
        return pulumi.get(self, "test_targets")

    @test_targets.setter
    def test_targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "test_targets", value)


@pulumi.input_type
class ToolResultsHistoryArgs:
    def __init__(__self__, *,
                 history_id: pulumi.Input[str],
                 project: pulumi.Input[str]):
        """
        Represents a tool results history resource.
        :param pulumi.Input[str] history_id: A tool results history ID.
        :param pulumi.Input[str] project: The cloud project that owns the tool results history.
        """
        pulumi.set(__self__, "history_id", history_id)
        pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="historyId")
    def history_id(self) -> pulumi.Input[str]:
        """
        A tool results history ID.
        """
        return pulumi.get(self, "history_id")

    @history_id.setter
    def history_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "history_id", value)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Input[str]:
        """
        The cloud project that owns the tool results history.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[str]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class UniformShardingArgs:
    def __init__(__self__, *,
                 num_shards: pulumi.Input[int]):
        """
        Uniformly shards test cases given a total number of shards. For Instrumentation test, it will be translated to "-e numShard" "-e shardIndex" AndroidJUnitRunner arguments. Based on the sharding mechanism AndroidJUnitRunner uses, there is no guarantee that test cases will be distributed uniformly across all shards. With uniform sharding enabled, specifying these sharding arguments via environment_variables is invalid.
        :param pulumi.Input[int] num_shards: Total number of shards. When any physical devices are selected, the number must be >= 1 and <= 50. When no physical devices are selected, the number must be >= 1 and <= 500.
        """
        pulumi.set(__self__, "num_shards", num_shards)

    @property
    @pulumi.getter(name="numShards")
    def num_shards(self) -> pulumi.Input[int]:
        """
        Total number of shards. When any physical devices are selected, the number must be >= 1 and <= 50. When no physical devices are selected, the number must be >= 1 and <= 500.
        """
        return pulumi.get(self, "num_shards")

    @num_shards.setter
    def num_shards(self, value: pulumi.Input[int]):
        pulumi.set(self, "num_shards", value)


