# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = [
    'GetOrganizationBigQueryExportResult',
    'AwaitableGetOrganizationBigQueryExportResult',
    'get_organization_big_query_export',
    'get_organization_big_query_export_output',
]

@pulumi.output_type
class GetOrganizationBigQueryExportResult:
    def __init__(__self__, create_time=None, dataset=None, description=None, filter=None, most_recent_editor=None, name=None, principal=None, update_time=None):
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if dataset and not isinstance(dataset, str):
            raise TypeError("Expected argument 'dataset' to be a str")
        pulumi.set(__self__, "dataset", dataset)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if filter and not isinstance(filter, str):
            raise TypeError("Expected argument 'filter' to be a str")
        pulumi.set(__self__, "filter", filter)
        if most_recent_editor and not isinstance(most_recent_editor, str):
            raise TypeError("Expected argument 'most_recent_editor' to be a str")
        pulumi.set(__self__, "most_recent_editor", most_recent_editor)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if principal and not isinstance(principal, str):
            raise TypeError("Expected argument 'principal' to be a str")
        pulumi.set(__self__, "principal", principal)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The time at which the big query export was created. This field is set by the server and will be ignored if provided on export on creation.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def dataset(self) -> str:
        """
        The dataset to write findings' updates to. Its format is "projects/[project_id]/datasets/[bigquery_dataset_id]". BigQuery Dataset unique ID must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_).
        """
        return pulumi.get(self, "dataset")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the export (max of 1024 characters).
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def filter(self) -> str:
        """
        Expression that defines the filter to apply across create/update events of findings. The expression is a list of zero or more restrictions combined via logical operators `AND` and `OR`. Parentheses are supported, and `OR` has higher precedence than `AND`. Restrictions have the form ` ` and may have a `-` character in front of them to indicate negation. The fields map to those defined in the corresponding resource. The supported operators are: * `=` for all value types. * `>`, `<`, `>=`, `<=` for integer values. * `:`, meaning substring matching, for strings. The supported value types are: * string literals in quotes. * integer literals without quotes. * boolean literals `true` and `false` without quotes. Please see the proto documentation in the finding (https://source.corp.google.com/piper///depot/google3/google/cloud/securitycenter/v1/finding.proto) and in the ListFindingsRequest for valid filter syntax. (https://source.corp.google.com/piper///depot/google3/google/cloud/securitycenter/v1/securitycenter_service.proto).
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter(name="mostRecentEditor")
    def most_recent_editor(self) -> str:
        """
        Email address of the user who last edited the big query export. This field is set by the server and will be ignored if provided on export creation or update.
        """
        return pulumi.get(self, "most_recent_editor")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The relative resource name of this export. See: https://cloud.google.com/apis/design/resource_names#relative_resource_name. Example format: "organizations/{organization_id}/bigQueryExports/{export_id}" Example format: "folders/{folder_id}/bigQueryExports/{export_id}" Example format: "projects/{project_id}/bigQueryExports/{export_id}" This field is provided in responses, and is ignored when provided in create requests.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def principal(self) -> str:
        """
        The service account that needs permission to create table, upload data to the big query dataset.
        """
        return pulumi.get(self, "principal")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        The most recent time at which the big export was updated. This field is set by the server and will be ignored if provided on export creation or update.
        """
        return pulumi.get(self, "update_time")


class AwaitableGetOrganizationBigQueryExportResult(GetOrganizationBigQueryExportResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOrganizationBigQueryExportResult(
            create_time=self.create_time,
            dataset=self.dataset,
            description=self.description,
            filter=self.filter,
            most_recent_editor=self.most_recent_editor,
            name=self.name,
            principal=self.principal,
            update_time=self.update_time)


def get_organization_big_query_export(big_query_export_id: Optional[str] = None,
                                      organization_id: Optional[str] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOrganizationBigQueryExportResult:
    """
    Gets a big query export.
    """
    __args__ = dict()
    __args__['bigQueryExportId'] = big_query_export_id
    __args__['organizationId'] = organization_id
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:securitycenter/v1:getOrganizationBigQueryExport', __args__, opts=opts, typ=GetOrganizationBigQueryExportResult).value

    return AwaitableGetOrganizationBigQueryExportResult(
        create_time=__ret__.create_time,
        dataset=__ret__.dataset,
        description=__ret__.description,
        filter=__ret__.filter,
        most_recent_editor=__ret__.most_recent_editor,
        name=__ret__.name,
        principal=__ret__.principal,
        update_time=__ret__.update_time)


@_utilities.lift_output_func(get_organization_big_query_export)
def get_organization_big_query_export_output(big_query_export_id: Optional[pulumi.Input[str]] = None,
                                             organization_id: Optional[pulumi.Input[str]] = None,
                                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetOrganizationBigQueryExportResult]:
    """
    Gets a big query export.
    """
    ...
