# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetDicomStoreResult',
    'AwaitableGetDicomStoreResult',
    'get_dicom_store',
    'get_dicom_store_output',
]

@pulumi.output_type
class GetDicomStoreResult:
    def __init__(__self__, labels=None, name=None, notification_config=None, stream_configs=None):
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if notification_config and not isinstance(notification_config, dict):
            raise TypeError("Expected argument 'notification_config' to be a dict")
        pulumi.set(__self__, "notification_config", notification_config)
        if stream_configs and not isinstance(stream_configs, list):
            raise TypeError("Expected argument 'stream_configs' to be a list")
        pulumi.set(__self__, "stream_configs", stream_configs)

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        User-supplied key-value pairs used to organize DICOM stores. Label keys must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes, and must conform to the following PCRE regular expression: \p{Ll}\p{Lo}{0,62} Label values are optional, must be between 1 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes, and must conform to the following PCRE regular expression: [\p{Ll}\p{Lo}\p{N}_-]{0,63} No more than 64 labels can be associated with a given store.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name of the DICOM store, of the form `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/{dicom_store_id}`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="notificationConfig")
    def notification_config(self) -> 'outputs.NotificationConfigResponse':
        """
        Notification destination for new DICOM instances. Supplied by the client.
        """
        return pulumi.get(self, "notification_config")

    @property
    @pulumi.getter(name="streamConfigs")
    def stream_configs(self) -> Sequence['outputs.GoogleCloudHealthcareV1beta1DicomStreamConfigResponse']:
        """
        A list of streaming configs used to configure the destination of streaming exports for every DICOM instance insertion in this DICOM store. After a new config is added to `stream_configs`, DICOM instance insertions are streamed to the new destination. When a config is removed from `stream_configs`, the server stops streaming to that destination. Each config must contain a unique destination.
        """
        return pulumi.get(self, "stream_configs")


class AwaitableGetDicomStoreResult(GetDicomStoreResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDicomStoreResult(
            labels=self.labels,
            name=self.name,
            notification_config=self.notification_config,
            stream_configs=self.stream_configs)


def get_dicom_store(dataset_id: Optional[str] = None,
                    dicom_store_id: Optional[str] = None,
                    location: Optional[str] = None,
                    project: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDicomStoreResult:
    """
    Gets the specified DICOM store.
    """
    __args__ = dict()
    __args__['datasetId'] = dataset_id
    __args__['dicomStoreId'] = dicom_store_id
    __args__['location'] = location
    __args__['project'] = project
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:healthcare/v1beta1:getDicomStore', __args__, opts=opts, typ=GetDicomStoreResult).value

    return AwaitableGetDicomStoreResult(
        labels=__ret__.labels,
        name=__ret__.name,
        notification_config=__ret__.notification_config,
        stream_configs=__ret__.stream_configs)


@_utilities.lift_output_func(get_dicom_store)
def get_dicom_store_output(dataset_id: Optional[pulumi.Input[str]] = None,
                           dicom_store_id: Optional[pulumi.Input[str]] = None,
                           location: Optional[pulumi.Input[str]] = None,
                           project: Optional[pulumi.Input[Optional[str]]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDicomStoreResult]:
    """
    Gets the specified DICOM store.
    """
    ...
