# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetFeatureConfigResult',
    'AwaitableGetFeatureConfigResult',
    'get_feature_config',
    'get_feature_config_output',
]

@pulumi.output_type
class GetFeatureConfigResult:
    def __init__(__self__, create_time=None, delete_time=None, labels=None, name=None, spec=None, state=None, unique_id=None, update_time=None):
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if delete_time and not isinstance(delete_time, str):
            raise TypeError("Expected argument 'delete_time' to be a str")
        pulumi.set(__self__, "delete_time", delete_time)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if spec and not isinstance(spec, dict):
            raise TypeError("Expected argument 'spec' to be a dict")
        pulumi.set(__self__, "spec", spec)
        if state and not isinstance(state, dict):
            raise TypeError("Expected argument 'state' to be a dict")
        pulumi.set(__self__, "state", state)
        if unique_id and not isinstance(unique_id, str):
            raise TypeError("Expected argument 'unique_id' to be a str")
        pulumi.set(__self__, "unique_id", unique_id)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        When the FeatureConfig resource was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="deleteTime")
    def delete_time(self) -> str:
        """
        When the FeatureConfig resource was deleted.
        """
        return pulumi.get(self, "delete_time")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        GCP labels for this FeatureConfig.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name of this FeatureConfig, in the format: `projects/{project}/locations/global/FeatureConfigs/{feature_type}/{feature_config}`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def spec(self) -> 'outputs.FeatureSpecResponse':
        """
        Input only. Immutable. User input of feature spec. Note that this field is immutable. Must create a new FeatureConfig if a new feature spec is needed.
        """
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter
    def state(self) -> 'outputs.FeatureConfigStateResponse':
        """
        Lifecycle information of the FeatureConfig.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="uniqueId")
    def unique_id(self) -> str:
        """
        Google-generated UUID for this resource. This is unique across all FeatureConfig resources. If a Membership resource is deleted and another resource with the same name is created, it gets a different unique_id.
        """
        return pulumi.get(self, "unique_id")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        When the FeatureConfig resource was last updated.
        """
        return pulumi.get(self, "update_time")


class AwaitableGetFeatureConfigResult(GetFeatureConfigResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFeatureConfigResult(
            create_time=self.create_time,
            delete_time=self.delete_time,
            labels=self.labels,
            name=self.name,
            spec=self.spec,
            state=self.state,
            unique_id=self.unique_id,
            update_time=self.update_time)


def get_feature_config(feature_config_id: Optional[str] = None,
                       location: Optional[str] = None,
                       project: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFeatureConfigResult:
    """
    ========= FeatureConfig Services ========= Gets details of a featureConfig.
    """
    __args__ = dict()
    __args__['featureConfigId'] = feature_config_id
    __args__['location'] = location
    __args__['project'] = project
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:gkehub/v2alpha:getFeatureConfig', __args__, opts=opts, typ=GetFeatureConfigResult).value

    return AwaitableGetFeatureConfigResult(
        create_time=__ret__.create_time,
        delete_time=__ret__.delete_time,
        labels=__ret__.labels,
        name=__ret__.name,
        spec=__ret__.spec,
        state=__ret__.state,
        unique_id=__ret__.unique_id,
        update_time=__ret__.update_time)


@_utilities.lift_output_func(get_feature_config)
def get_feature_config_output(feature_config_id: Optional[pulumi.Input[str]] = None,
                              location: Optional[pulumi.Input[str]] = None,
                              project: Optional[pulumi.Input[Optional[str]]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetFeatureConfigResult]:
    """
    ========= FeatureConfig Services ========= Gets details of a featureConfig.
    """
    ...
