# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = [
    'GetParticipantResult',
    'AwaitableGetParticipantResult',
    'get_participant',
    'get_participant_output',
]

@pulumi.output_type
class GetParticipantResult:
    def __init__(__self__, documents_metadata_filters=None, name=None, role=None, sip_recording_media_label=None):
        if documents_metadata_filters and not isinstance(documents_metadata_filters, dict):
            raise TypeError("Expected argument 'documents_metadata_filters' to be a dict")
        pulumi.set(__self__, "documents_metadata_filters", documents_metadata_filters)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if role and not isinstance(role, str):
            raise TypeError("Expected argument 'role' to be a str")
        pulumi.set(__self__, "role", role)
        if sip_recording_media_label and not isinstance(sip_recording_media_label, str):
            raise TypeError("Expected argument 'sip_recording_media_label' to be a str")
        pulumi.set(__self__, "sip_recording_media_label", sip_recording_media_label)

    @property
    @pulumi.getter(name="documentsMetadataFilters")
    def documents_metadata_filters(self) -> Mapping[str, str]:
        """
        Optional. Key-value filters on the metadata of documents returned by article suggestion. If specified, article suggestion only returns suggested documents that match all filters in their Document.metadata. Multiple values for a metadata key should be concatenated by comma. For example, filters to match all documents that have 'US' or 'CA' in their market metadata values and 'agent' in their user metadata values will be ``` documents_metadata_filters { key: "market" value: "US,CA" } documents_metadata_filters { key: "user" value: "agent" } ```
        """
        return pulumi.get(self, "documents_metadata_filters")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Optional. The unique identifier of this participant. Format: `projects//locations//conversations//participants/`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        Immutable. The role this participant plays in the conversation. This field must be set during participant creation and is then immutable.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter(name="sipRecordingMediaLabel")
    def sip_recording_media_label(self) -> str:
        """
        Optional. Label applied to streams representing this participant in SIPREC XML metadata and SDP. This is used to assign transcriptions from that media stream to this participant. This field can be updated.
        """
        return pulumi.get(self, "sip_recording_media_label")


class AwaitableGetParticipantResult(GetParticipantResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetParticipantResult(
            documents_metadata_filters=self.documents_metadata_filters,
            name=self.name,
            role=self.role,
            sip_recording_media_label=self.sip_recording_media_label)


def get_participant(conversation_id: Optional[str] = None,
                    location: Optional[str] = None,
                    participant_id: Optional[str] = None,
                    project: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetParticipantResult:
    """
    Retrieves a conversation participant.
    """
    __args__ = dict()
    __args__['conversationId'] = conversation_id
    __args__['location'] = location
    __args__['participantId'] = participant_id
    __args__['project'] = project
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:dialogflow/v2:getParticipant', __args__, opts=opts, typ=GetParticipantResult).value

    return AwaitableGetParticipantResult(
        documents_metadata_filters=__ret__.documents_metadata_filters,
        name=__ret__.name,
        role=__ret__.role,
        sip_recording_media_label=__ret__.sip_recording_media_label)


@_utilities.lift_output_func(get_participant)
def get_participant_output(conversation_id: Optional[pulumi.Input[str]] = None,
                           location: Optional[pulumi.Input[str]] = None,
                           participant_id: Optional[pulumi.Input[str]] = None,
                           project: Optional[pulumi.Input[Optional[str]]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetParticipantResult]:
    """
    Retrieves a conversation participant.
    """
    ...
