# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['JobArgs', 'Job']

@pulumi.input_type
class JobArgs:
    def __init__(__self__, *,
                 client_request_id: Optional[pulumi.Input[str]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 created_from_snapshot_id: Optional[pulumi.Input[str]] = None,
                 current_state: Optional[pulumi.Input['JobCurrentState']] = None,
                 current_state_time: Optional[pulumi.Input[str]] = None,
                 environment: Optional[pulumi.Input['EnvironmentArgs']] = None,
                 execution_info: Optional[pulumi.Input['JobExecutionInfoArgs']] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 job_metadata: Optional[pulumi.Input['JobMetadataArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 pipeline_description: Optional[pulumi.Input['PipelineDescriptionArgs']] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 replace_job_id: Optional[pulumi.Input[str]] = None,
                 replaced_by_job_id: Optional[pulumi.Input[str]] = None,
                 requested_state: Optional[pulumi.Input['JobRequestedState']] = None,
                 satisfies_pzs: Optional[pulumi.Input[bool]] = None,
                 stage_states: Optional[pulumi.Input[Sequence[pulumi.Input['ExecutionStageStateArgs']]]] = None,
                 start_time: Optional[pulumi.Input[str]] = None,
                 steps: Optional[pulumi.Input[Sequence[pulumi.Input['StepArgs']]]] = None,
                 steps_location: Optional[pulumi.Input[str]] = None,
                 temp_files: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 transform_name_mapping: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input['JobType']] = None,
                 view: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Job resource.
        :param pulumi.Input[str] client_request_id: The client's unique identifier of the job, re-used across retried attempts. If this field is set, the service will ensure its uniqueness. The request to create a job will fail if the service has knowledge of a previously submitted job with the same client's ID and job name. The caller may use this field to ensure idempotence of job creation across retried attempts to create a job. By default, the field is empty and, in that case, the service ignores it.
        :param pulumi.Input[str] create_time: The timestamp when the job was initially created. Immutable and set by the Cloud Dataflow service.
        :param pulumi.Input[str] created_from_snapshot_id: If this is specified, the job's initial state is populated from the given snapshot.
        :param pulumi.Input['JobCurrentState'] current_state: The current state of the job. Jobs are created in the `JOB_STATE_STOPPED` state unless otherwise specified. A job in the `JOB_STATE_RUNNING` state may asynchronously enter a terminal state. After a job has reached a terminal state, no further state updates may be made. This field may be mutated by the Cloud Dataflow service; callers cannot mutate it.
        :param pulumi.Input[str] current_state_time: The timestamp associated with the current state.
        :param pulumi.Input['EnvironmentArgs'] environment: The environment for the job.
        :param pulumi.Input['JobExecutionInfoArgs'] execution_info: Deprecated.
        :param pulumi.Input[str] id: The unique ID of this job. This field is set by the Cloud Dataflow service when the Job is created, and is immutable for the life of the job.
        :param pulumi.Input['JobMetadataArgs'] job_metadata: This field is populated by the Dataflow service to support filtering jobs by the metadata values provided here. Populated for ListJobs and all GetJob views SUMMARY and higher.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: User-defined labels for this job. The labels map can contain no more than 64 entries. Entries of the labels map are UTF8 strings that comply with the following restrictions: * Keys must conform to regexp: \p{Ll}\p{Lo}{0,62} * Values must conform to regexp: [\p{Ll}\p{Lo}\p{N}_-]{0,63} * Both keys and values are additionally constrained to be <= 128 bytes in size.
        :param pulumi.Input[str] location: The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that contains this job.
        :param pulumi.Input[str] name: The user-specified Cloud Dataflow job name. Only one Job with a given name may exist in a project at any given time. If a caller attempts to create a Job with the same name as an already-existing Job, the attempt returns the existing Job. The name must match the regular expression `[a-z]([-a-z0-9]{0,38}[a-z0-9])?`
        :param pulumi.Input['PipelineDescriptionArgs'] pipeline_description: Preliminary field: The format of this data may change at any time. A description of the user pipeline and stages through which it is executed. Created by Cloud Dataflow service. Only retrieved with JOB_VIEW_DESCRIPTION or JOB_VIEW_ALL.
        :param pulumi.Input[str] project: The ID of the Cloud Platform project that the job belongs to.
        :param pulumi.Input[str] replace_job_id: If this job is an update of an existing job, this field is the job ID of the job it replaced. When sending a `CreateJobRequest`, you can update a job by specifying it here. The job named here is stopped, and its intermediate state is transferred to this job.
        :param pulumi.Input[str] replaced_by_job_id: If another job is an update of this job (and thus, this job is in `JOB_STATE_UPDATED`), this field contains the ID of that job.
        :param pulumi.Input['JobRequestedState'] requested_state: The job's requested state. `UpdateJob` may be used to switch between the `JOB_STATE_STOPPED` and `JOB_STATE_RUNNING` states, by setting requested_state. `UpdateJob` may also be used to directly set a job's requested state to `JOB_STATE_CANCELLED` or `JOB_STATE_DONE`, irrevocably terminating the job if it has not already reached a terminal state.
        :param pulumi.Input[bool] satisfies_pzs: Reserved for future use. This field is set only in responses from the server; it is ignored if it is set in any requests.
        :param pulumi.Input[Sequence[pulumi.Input['ExecutionStageStateArgs']]] stage_states: This field may be mutated by the Cloud Dataflow service; callers cannot mutate it.
        :param pulumi.Input[str] start_time: The timestamp when the job was started (transitioned to JOB_STATE_PENDING). Flexible resource scheduling jobs are started with some delay after job creation, so start_time is unset before start and is updated when the job is started by the Cloud Dataflow service. For other jobs, start_time always equals to create_time and is immutable and set by the Cloud Dataflow service.
        :param pulumi.Input[Sequence[pulumi.Input['StepArgs']]] steps: Exactly one of step or steps_location should be specified. The top-level steps that constitute the entire job. Only retrieved with JOB_VIEW_ALL.
        :param pulumi.Input[str] steps_location: The Cloud Storage location where the steps are stored.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] temp_files: A set of files the system should be aware of that are used for temporary storage. These temporary files will be removed on job completion. No duplicates are allowed. No file patterns are supported. The supported files are: Google Cloud Storage: storage.googleapis.com/{bucket}/{object} bucket.storage.googleapis.com/{object}
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] transform_name_mapping: The map of transform name prefixes of the job to be replaced to the corresponding name prefixes of the new job.
        :param pulumi.Input['JobType'] type: The type of Cloud Dataflow job.
        :param pulumi.Input[str] view: The level of information requested in response.
        """
        if client_request_id is not None:
            pulumi.set(__self__, "client_request_id", client_request_id)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if created_from_snapshot_id is not None:
            pulumi.set(__self__, "created_from_snapshot_id", created_from_snapshot_id)
        if current_state is not None:
            pulumi.set(__self__, "current_state", current_state)
        if current_state_time is not None:
            pulumi.set(__self__, "current_state_time", current_state_time)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if execution_info is not None:
            warnings.warn("""Deprecated.""", DeprecationWarning)
            pulumi.log.warn("""execution_info is deprecated: Deprecated.""")
        if execution_info is not None:
            pulumi.set(__self__, "execution_info", execution_info)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if job_metadata is not None:
            pulumi.set(__self__, "job_metadata", job_metadata)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pipeline_description is not None:
            pulumi.set(__self__, "pipeline_description", pipeline_description)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if replace_job_id is not None:
            pulumi.set(__self__, "replace_job_id", replace_job_id)
        if replaced_by_job_id is not None:
            pulumi.set(__self__, "replaced_by_job_id", replaced_by_job_id)
        if requested_state is not None:
            pulumi.set(__self__, "requested_state", requested_state)
        if satisfies_pzs is not None:
            pulumi.set(__self__, "satisfies_pzs", satisfies_pzs)
        if stage_states is not None:
            pulumi.set(__self__, "stage_states", stage_states)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if steps is not None:
            pulumi.set(__self__, "steps", steps)
        if steps_location is not None:
            pulumi.set(__self__, "steps_location", steps_location)
        if temp_files is not None:
            pulumi.set(__self__, "temp_files", temp_files)
        if transform_name_mapping is not None:
            pulumi.set(__self__, "transform_name_mapping", transform_name_mapping)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if view is not None:
            pulumi.set(__self__, "view", view)

    @property
    @pulumi.getter(name="clientRequestId")
    def client_request_id(self) -> Optional[pulumi.Input[str]]:
        """
        The client's unique identifier of the job, re-used across retried attempts. If this field is set, the service will ensure its uniqueness. The request to create a job will fail if the service has knowledge of a previously submitted job with the same client's ID and job name. The caller may use this field to ensure idempotence of job creation across retried attempts to create a job. By default, the field is empty and, in that case, the service ignores it.
        """
        return pulumi.get(self, "client_request_id")

    @client_request_id.setter
    def client_request_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_request_id", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        The timestamp when the job was initially created. Immutable and set by the Cloud Dataflow service.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="createdFromSnapshotId")
    def created_from_snapshot_id(self) -> Optional[pulumi.Input[str]]:
        """
        If this is specified, the job's initial state is populated from the given snapshot.
        """
        return pulumi.get(self, "created_from_snapshot_id")

    @created_from_snapshot_id.setter
    def created_from_snapshot_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_from_snapshot_id", value)

    @property
    @pulumi.getter(name="currentState")
    def current_state(self) -> Optional[pulumi.Input['JobCurrentState']]:
        """
        The current state of the job. Jobs are created in the `JOB_STATE_STOPPED` state unless otherwise specified. A job in the `JOB_STATE_RUNNING` state may asynchronously enter a terminal state. After a job has reached a terminal state, no further state updates may be made. This field may be mutated by the Cloud Dataflow service; callers cannot mutate it.
        """
        return pulumi.get(self, "current_state")

    @current_state.setter
    def current_state(self, value: Optional[pulumi.Input['JobCurrentState']]):
        pulumi.set(self, "current_state", value)

    @property
    @pulumi.getter(name="currentStateTime")
    def current_state_time(self) -> Optional[pulumi.Input[str]]:
        """
        The timestamp associated with the current state.
        """
        return pulumi.get(self, "current_state_time")

    @current_state_time.setter
    def current_state_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "current_state_time", value)

    @property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input['EnvironmentArgs']]:
        """
        The environment for the job.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input['EnvironmentArgs']]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter(name="executionInfo")
    def execution_info(self) -> Optional[pulumi.Input['JobExecutionInfoArgs']]:
        """
        Deprecated.
        """
        return pulumi.get(self, "execution_info")

    @execution_info.setter
    def execution_info(self, value: Optional[pulumi.Input['JobExecutionInfoArgs']]):
        pulumi.set(self, "execution_info", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique ID of this job. This field is set by the Cloud Dataflow service when the Job is created, and is immutable for the life of the job.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="jobMetadata")
    def job_metadata(self) -> Optional[pulumi.Input['JobMetadataArgs']]:
        """
        This field is populated by the Dataflow service to support filtering jobs by the metadata values provided here. Populated for ListJobs and all GetJob views SUMMARY and higher.
        """
        return pulumi.get(self, "job_metadata")

    @job_metadata.setter
    def job_metadata(self, value: Optional[pulumi.Input['JobMetadataArgs']]):
        pulumi.set(self, "job_metadata", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        User-defined labels for this job. The labels map can contain no more than 64 entries. Entries of the labels map are UTF8 strings that comply with the following restrictions: * Keys must conform to regexp: \p{Ll}\p{Lo}{0,62} * Values must conform to regexp: [\p{Ll}\p{Lo}\p{N}_-]{0,63} * Both keys and values are additionally constrained to be <= 128 bytes in size.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that contains this job.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The user-specified Cloud Dataflow job name. Only one Job with a given name may exist in a project at any given time. If a caller attempts to create a Job with the same name as an already-existing Job, the attempt returns the existing Job. The name must match the regular expression `[a-z]([-a-z0-9]{0,38}[a-z0-9])?`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="pipelineDescription")
    def pipeline_description(self) -> Optional[pulumi.Input['PipelineDescriptionArgs']]:
        """
        Preliminary field: The format of this data may change at any time. A description of the user pipeline and stages through which it is executed. Created by Cloud Dataflow service. Only retrieved with JOB_VIEW_DESCRIPTION or JOB_VIEW_ALL.
        """
        return pulumi.get(self, "pipeline_description")

    @pipeline_description.setter
    def pipeline_description(self, value: Optional[pulumi.Input['PipelineDescriptionArgs']]):
        pulumi.set(self, "pipeline_description", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Cloud Platform project that the job belongs to.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="replaceJobId")
    def replace_job_id(self) -> Optional[pulumi.Input[str]]:
        """
        If this job is an update of an existing job, this field is the job ID of the job it replaced. When sending a `CreateJobRequest`, you can update a job by specifying it here. The job named here is stopped, and its intermediate state is transferred to this job.
        """
        return pulumi.get(self, "replace_job_id")

    @replace_job_id.setter
    def replace_job_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "replace_job_id", value)

    @property
    @pulumi.getter(name="replacedByJobId")
    def replaced_by_job_id(self) -> Optional[pulumi.Input[str]]:
        """
        If another job is an update of this job (and thus, this job is in `JOB_STATE_UPDATED`), this field contains the ID of that job.
        """
        return pulumi.get(self, "replaced_by_job_id")

    @replaced_by_job_id.setter
    def replaced_by_job_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "replaced_by_job_id", value)

    @property
    @pulumi.getter(name="requestedState")
    def requested_state(self) -> Optional[pulumi.Input['JobRequestedState']]:
        """
        The job's requested state. `UpdateJob` may be used to switch between the `JOB_STATE_STOPPED` and `JOB_STATE_RUNNING` states, by setting requested_state. `UpdateJob` may also be used to directly set a job's requested state to `JOB_STATE_CANCELLED` or `JOB_STATE_DONE`, irrevocably terminating the job if it has not already reached a terminal state.
        """
        return pulumi.get(self, "requested_state")

    @requested_state.setter
    def requested_state(self, value: Optional[pulumi.Input['JobRequestedState']]):
        pulumi.set(self, "requested_state", value)

    @property
    @pulumi.getter(name="satisfiesPzs")
    def satisfies_pzs(self) -> Optional[pulumi.Input[bool]]:
        """
        Reserved for future use. This field is set only in responses from the server; it is ignored if it is set in any requests.
        """
        return pulumi.get(self, "satisfies_pzs")

    @satisfies_pzs.setter
    def satisfies_pzs(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "satisfies_pzs", value)

    @property
    @pulumi.getter(name="stageStates")
    def stage_states(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExecutionStageStateArgs']]]]:
        """
        This field may be mutated by the Cloud Dataflow service; callers cannot mutate it.
        """
        return pulumi.get(self, "stage_states")

    @stage_states.setter
    def stage_states(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExecutionStageStateArgs']]]]):
        pulumi.set(self, "stage_states", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        The timestamp when the job was started (transitioned to JOB_STATE_PENDING). Flexible resource scheduling jobs are started with some delay after job creation, so start_time is unset before start and is updated when the job is started by the Cloud Dataflow service. For other jobs, start_time always equals to create_time and is immutable and set by the Cloud Dataflow service.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter
    def steps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StepArgs']]]]:
        """
        Exactly one of step or steps_location should be specified. The top-level steps that constitute the entire job. Only retrieved with JOB_VIEW_ALL.
        """
        return pulumi.get(self, "steps")

    @steps.setter
    def steps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StepArgs']]]]):
        pulumi.set(self, "steps", value)

    @property
    @pulumi.getter(name="stepsLocation")
    def steps_location(self) -> Optional[pulumi.Input[str]]:
        """
        The Cloud Storage location where the steps are stored.
        """
        return pulumi.get(self, "steps_location")

    @steps_location.setter
    def steps_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "steps_location", value)

    @property
    @pulumi.getter(name="tempFiles")
    def temp_files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A set of files the system should be aware of that are used for temporary storage. These temporary files will be removed on job completion. No duplicates are allowed. No file patterns are supported. The supported files are: Google Cloud Storage: storage.googleapis.com/{bucket}/{object} bucket.storage.googleapis.com/{object}
        """
        return pulumi.get(self, "temp_files")

    @temp_files.setter
    def temp_files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "temp_files", value)

    @property
    @pulumi.getter(name="transformNameMapping")
    def transform_name_mapping(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The map of transform name prefixes of the job to be replaced to the corresponding name prefixes of the new job.
        """
        return pulumi.get(self, "transform_name_mapping")

    @transform_name_mapping.setter
    def transform_name_mapping(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "transform_name_mapping", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['JobType']]:
        """
        The type of Cloud Dataflow job.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['JobType']]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def view(self) -> Optional[pulumi.Input[str]]:
        """
        The level of information requested in response.
        """
        return pulumi.get(self, "view")

    @view.setter
    def view(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "view", value)


class Job(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 client_request_id: Optional[pulumi.Input[str]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 created_from_snapshot_id: Optional[pulumi.Input[str]] = None,
                 current_state: Optional[pulumi.Input['JobCurrentState']] = None,
                 current_state_time: Optional[pulumi.Input[str]] = None,
                 environment: Optional[pulumi.Input[pulumi.InputType['EnvironmentArgs']]] = None,
                 execution_info: Optional[pulumi.Input[pulumi.InputType['JobExecutionInfoArgs']]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 job_metadata: Optional[pulumi.Input[pulumi.InputType['JobMetadataArgs']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 pipeline_description: Optional[pulumi.Input[pulumi.InputType['PipelineDescriptionArgs']]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 replace_job_id: Optional[pulumi.Input[str]] = None,
                 replaced_by_job_id: Optional[pulumi.Input[str]] = None,
                 requested_state: Optional[pulumi.Input['JobRequestedState']] = None,
                 satisfies_pzs: Optional[pulumi.Input[bool]] = None,
                 stage_states: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ExecutionStageStateArgs']]]]] = None,
                 start_time: Optional[pulumi.Input[str]] = None,
                 steps: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['StepArgs']]]]] = None,
                 steps_location: Optional[pulumi.Input[str]] = None,
                 temp_files: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 transform_name_mapping: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input['JobType']] = None,
                 view: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates a Cloud Dataflow job. To create a job, we recommend using `projects.locations.jobs.create` with a [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using `projects.jobs.create` is not recommended, as your job will always start in `us-central1`.
        Note - this resource's API doesn't support deletion. When deleted, the resource will persist
        on Google Cloud even though it will be deleted from Pulumi state.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] client_request_id: The client's unique identifier of the job, re-used across retried attempts. If this field is set, the service will ensure its uniqueness. The request to create a job will fail if the service has knowledge of a previously submitted job with the same client's ID and job name. The caller may use this field to ensure idempotence of job creation across retried attempts to create a job. By default, the field is empty and, in that case, the service ignores it.
        :param pulumi.Input[str] create_time: The timestamp when the job was initially created. Immutable and set by the Cloud Dataflow service.
        :param pulumi.Input[str] created_from_snapshot_id: If this is specified, the job's initial state is populated from the given snapshot.
        :param pulumi.Input['JobCurrentState'] current_state: The current state of the job. Jobs are created in the `JOB_STATE_STOPPED` state unless otherwise specified. A job in the `JOB_STATE_RUNNING` state may asynchronously enter a terminal state. After a job has reached a terminal state, no further state updates may be made. This field may be mutated by the Cloud Dataflow service; callers cannot mutate it.
        :param pulumi.Input[str] current_state_time: The timestamp associated with the current state.
        :param pulumi.Input[pulumi.InputType['EnvironmentArgs']] environment: The environment for the job.
        :param pulumi.Input[pulumi.InputType['JobExecutionInfoArgs']] execution_info: Deprecated.
        :param pulumi.Input[str] id: The unique ID of this job. This field is set by the Cloud Dataflow service when the Job is created, and is immutable for the life of the job.
        :param pulumi.Input[pulumi.InputType['JobMetadataArgs']] job_metadata: This field is populated by the Dataflow service to support filtering jobs by the metadata values provided here. Populated for ListJobs and all GetJob views SUMMARY and higher.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: User-defined labels for this job. The labels map can contain no more than 64 entries. Entries of the labels map are UTF8 strings that comply with the following restrictions: * Keys must conform to regexp: \p{Ll}\p{Lo}{0,62} * Values must conform to regexp: [\p{Ll}\p{Lo}\p{N}_-]{0,63} * Both keys and values are additionally constrained to be <= 128 bytes in size.
        :param pulumi.Input[str] location: The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that contains this job.
        :param pulumi.Input[str] name: The user-specified Cloud Dataflow job name. Only one Job with a given name may exist in a project at any given time. If a caller attempts to create a Job with the same name as an already-existing Job, the attempt returns the existing Job. The name must match the regular expression `[a-z]([-a-z0-9]{0,38}[a-z0-9])?`
        :param pulumi.Input[pulumi.InputType['PipelineDescriptionArgs']] pipeline_description: Preliminary field: The format of this data may change at any time. A description of the user pipeline and stages through which it is executed. Created by Cloud Dataflow service. Only retrieved with JOB_VIEW_DESCRIPTION or JOB_VIEW_ALL.
        :param pulumi.Input[str] project: The ID of the Cloud Platform project that the job belongs to.
        :param pulumi.Input[str] replace_job_id: If this job is an update of an existing job, this field is the job ID of the job it replaced. When sending a `CreateJobRequest`, you can update a job by specifying it here. The job named here is stopped, and its intermediate state is transferred to this job.
        :param pulumi.Input[str] replaced_by_job_id: If another job is an update of this job (and thus, this job is in `JOB_STATE_UPDATED`), this field contains the ID of that job.
        :param pulumi.Input['JobRequestedState'] requested_state: The job's requested state. `UpdateJob` may be used to switch between the `JOB_STATE_STOPPED` and `JOB_STATE_RUNNING` states, by setting requested_state. `UpdateJob` may also be used to directly set a job's requested state to `JOB_STATE_CANCELLED` or `JOB_STATE_DONE`, irrevocably terminating the job if it has not already reached a terminal state.
        :param pulumi.Input[bool] satisfies_pzs: Reserved for future use. This field is set only in responses from the server; it is ignored if it is set in any requests.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ExecutionStageStateArgs']]]] stage_states: This field may be mutated by the Cloud Dataflow service; callers cannot mutate it.
        :param pulumi.Input[str] start_time: The timestamp when the job was started (transitioned to JOB_STATE_PENDING). Flexible resource scheduling jobs are started with some delay after job creation, so start_time is unset before start and is updated when the job is started by the Cloud Dataflow service. For other jobs, start_time always equals to create_time and is immutable and set by the Cloud Dataflow service.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['StepArgs']]]] steps: Exactly one of step or steps_location should be specified. The top-level steps that constitute the entire job. Only retrieved with JOB_VIEW_ALL.
        :param pulumi.Input[str] steps_location: The Cloud Storage location where the steps are stored.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] temp_files: A set of files the system should be aware of that are used for temporary storage. These temporary files will be removed on job completion. No duplicates are allowed. No file patterns are supported. The supported files are: Google Cloud Storage: storage.googleapis.com/{bucket}/{object} bucket.storage.googleapis.com/{object}
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] transform_name_mapping: The map of transform name prefixes of the job to be replaced to the corresponding name prefixes of the new job.
        :param pulumi.Input['JobType'] type: The type of Cloud Dataflow job.
        :param pulumi.Input[str] view: The level of information requested in response.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[JobArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a Cloud Dataflow job. To create a job, we recommend using `projects.locations.jobs.create` with a [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using `projects.jobs.create` is not recommended, as your job will always start in `us-central1`.
        Note - this resource's API doesn't support deletion. When deleted, the resource will persist
        on Google Cloud even though it will be deleted from Pulumi state.

        :param str resource_name: The name of the resource.
        :param JobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(JobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 client_request_id: Optional[pulumi.Input[str]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 created_from_snapshot_id: Optional[pulumi.Input[str]] = None,
                 current_state: Optional[pulumi.Input['JobCurrentState']] = None,
                 current_state_time: Optional[pulumi.Input[str]] = None,
                 environment: Optional[pulumi.Input[pulumi.InputType['EnvironmentArgs']]] = None,
                 execution_info: Optional[pulumi.Input[pulumi.InputType['JobExecutionInfoArgs']]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 job_metadata: Optional[pulumi.Input[pulumi.InputType['JobMetadataArgs']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 pipeline_description: Optional[pulumi.Input[pulumi.InputType['PipelineDescriptionArgs']]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 replace_job_id: Optional[pulumi.Input[str]] = None,
                 replaced_by_job_id: Optional[pulumi.Input[str]] = None,
                 requested_state: Optional[pulumi.Input['JobRequestedState']] = None,
                 satisfies_pzs: Optional[pulumi.Input[bool]] = None,
                 stage_states: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ExecutionStageStateArgs']]]]] = None,
                 start_time: Optional[pulumi.Input[str]] = None,
                 steps: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['StepArgs']]]]] = None,
                 steps_location: Optional[pulumi.Input[str]] = None,
                 temp_files: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 transform_name_mapping: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input['JobType']] = None,
                 view: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = JobArgs.__new__(JobArgs)

            __props__.__dict__["client_request_id"] = client_request_id
            __props__.__dict__["create_time"] = create_time
            __props__.__dict__["created_from_snapshot_id"] = created_from_snapshot_id
            __props__.__dict__["current_state"] = current_state
            __props__.__dict__["current_state_time"] = current_state_time
            __props__.__dict__["environment"] = environment
            if execution_info is not None and not opts.urn:
                warnings.warn("""Deprecated.""", DeprecationWarning)
                pulumi.log.warn("""execution_info is deprecated: Deprecated.""")
            __props__.__dict__["execution_info"] = execution_info
            __props__.__dict__["id"] = id
            __props__.__dict__["job_metadata"] = job_metadata
            __props__.__dict__["labels"] = labels
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["pipeline_description"] = pipeline_description
            __props__.__dict__["project"] = project
            __props__.__dict__["replace_job_id"] = replace_job_id
            __props__.__dict__["replaced_by_job_id"] = replaced_by_job_id
            __props__.__dict__["requested_state"] = requested_state
            __props__.__dict__["satisfies_pzs"] = satisfies_pzs
            __props__.__dict__["stage_states"] = stage_states
            __props__.__dict__["start_time"] = start_time
            __props__.__dict__["steps"] = steps
            __props__.__dict__["steps_location"] = steps_location
            __props__.__dict__["temp_files"] = temp_files
            __props__.__dict__["transform_name_mapping"] = transform_name_mapping
            __props__.__dict__["type"] = type
            __props__.__dict__["view"] = view
        super(Job, __self__).__init__(
            'google-native:dataflow/v1b3:Job',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Job':
        """
        Get an existing Job resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = JobArgs.__new__(JobArgs)

        __props__.__dict__["client_request_id"] = None
        __props__.__dict__["create_time"] = None
        __props__.__dict__["created_from_snapshot_id"] = None
        __props__.__dict__["current_state"] = None
        __props__.__dict__["current_state_time"] = None
        __props__.__dict__["environment"] = None
        __props__.__dict__["execution_info"] = None
        __props__.__dict__["job_metadata"] = None
        __props__.__dict__["labels"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["pipeline_description"] = None
        __props__.__dict__["project"] = None
        __props__.__dict__["replace_job_id"] = None
        __props__.__dict__["replaced_by_job_id"] = None
        __props__.__dict__["requested_state"] = None
        __props__.__dict__["satisfies_pzs"] = None
        __props__.__dict__["stage_states"] = None
        __props__.__dict__["start_time"] = None
        __props__.__dict__["steps"] = None
        __props__.__dict__["steps_location"] = None
        __props__.__dict__["temp_files"] = None
        __props__.__dict__["transform_name_mapping"] = None
        __props__.__dict__["type"] = None
        return Job(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="clientRequestId")
    def client_request_id(self) -> pulumi.Output[str]:
        """
        The client's unique identifier of the job, re-used across retried attempts. If this field is set, the service will ensure its uniqueness. The request to create a job will fail if the service has knowledge of a previously submitted job with the same client's ID and job name. The caller may use this field to ensure idempotence of job creation across retried attempts to create a job. By default, the field is empty and, in that case, the service ignores it.
        """
        return pulumi.get(self, "client_request_id")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The timestamp when the job was initially created. Immutable and set by the Cloud Dataflow service.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="createdFromSnapshotId")
    def created_from_snapshot_id(self) -> pulumi.Output[str]:
        """
        If this is specified, the job's initial state is populated from the given snapshot.
        """
        return pulumi.get(self, "created_from_snapshot_id")

    @property
    @pulumi.getter(name="currentState")
    def current_state(self) -> pulumi.Output[str]:
        """
        The current state of the job. Jobs are created in the `JOB_STATE_STOPPED` state unless otherwise specified. A job in the `JOB_STATE_RUNNING` state may asynchronously enter a terminal state. After a job has reached a terminal state, no further state updates may be made. This field may be mutated by the Cloud Dataflow service; callers cannot mutate it.
        """
        return pulumi.get(self, "current_state")

    @property
    @pulumi.getter(name="currentStateTime")
    def current_state_time(self) -> pulumi.Output[str]:
        """
        The timestamp associated with the current state.
        """
        return pulumi.get(self, "current_state_time")

    @property
    @pulumi.getter
    def environment(self) -> pulumi.Output['outputs.EnvironmentResponse']:
        """
        The environment for the job.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter(name="executionInfo")
    def execution_info(self) -> pulumi.Output['outputs.JobExecutionInfoResponse']:
        """
        Deprecated.
        """
        return pulumi.get(self, "execution_info")

    @property
    @pulumi.getter(name="jobMetadata")
    def job_metadata(self) -> pulumi.Output['outputs.JobMetadataResponse']:
        """
        This field is populated by the Dataflow service to support filtering jobs by the metadata values provided here. Populated for ListJobs and all GetJob views SUMMARY and higher.
        """
        return pulumi.get(self, "job_metadata")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        User-defined labels for this job. The labels map can contain no more than 64 entries. Entries of the labels map are UTF8 strings that comply with the following restrictions: * Keys must conform to regexp: \p{Ll}\p{Lo}{0,62} * Values must conform to regexp: [\p{Ll}\p{Lo}\p{N}_-]{0,63} * Both keys and values are additionally constrained to be <= 128 bytes in size.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that contains this job.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The user-specified Cloud Dataflow job name. Only one Job with a given name may exist in a project at any given time. If a caller attempts to create a Job with the same name as an already-existing Job, the attempt returns the existing Job. The name must match the regular expression `[a-z]([-a-z0-9]{0,38}[a-z0-9])?`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pipelineDescription")
    def pipeline_description(self) -> pulumi.Output['outputs.PipelineDescriptionResponse']:
        """
        Preliminary field: The format of this data may change at any time. A description of the user pipeline and stages through which it is executed. Created by Cloud Dataflow service. Only retrieved with JOB_VIEW_DESCRIPTION or JOB_VIEW_ALL.
        """
        return pulumi.get(self, "pipeline_description")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the Cloud Platform project that the job belongs to.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="replaceJobId")
    def replace_job_id(self) -> pulumi.Output[str]:
        """
        If this job is an update of an existing job, this field is the job ID of the job it replaced. When sending a `CreateJobRequest`, you can update a job by specifying it here. The job named here is stopped, and its intermediate state is transferred to this job.
        """
        return pulumi.get(self, "replace_job_id")

    @property
    @pulumi.getter(name="replacedByJobId")
    def replaced_by_job_id(self) -> pulumi.Output[str]:
        """
        If another job is an update of this job (and thus, this job is in `JOB_STATE_UPDATED`), this field contains the ID of that job.
        """
        return pulumi.get(self, "replaced_by_job_id")

    @property
    @pulumi.getter(name="requestedState")
    def requested_state(self) -> pulumi.Output[str]:
        """
        The job's requested state. `UpdateJob` may be used to switch between the `JOB_STATE_STOPPED` and `JOB_STATE_RUNNING` states, by setting requested_state. `UpdateJob` may also be used to directly set a job's requested state to `JOB_STATE_CANCELLED` or `JOB_STATE_DONE`, irrevocably terminating the job if it has not already reached a terminal state.
        """
        return pulumi.get(self, "requested_state")

    @property
    @pulumi.getter(name="satisfiesPzs")
    def satisfies_pzs(self) -> pulumi.Output[bool]:
        """
        Reserved for future use. This field is set only in responses from the server; it is ignored if it is set in any requests.
        """
        return pulumi.get(self, "satisfies_pzs")

    @property
    @pulumi.getter(name="stageStates")
    def stage_states(self) -> pulumi.Output[Sequence['outputs.ExecutionStageStateResponse']]:
        """
        This field may be mutated by the Cloud Dataflow service; callers cannot mutate it.
        """
        return pulumi.get(self, "stage_states")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Output[str]:
        """
        The timestamp when the job was started (transitioned to JOB_STATE_PENDING). Flexible resource scheduling jobs are started with some delay after job creation, so start_time is unset before start and is updated when the job is started by the Cloud Dataflow service. For other jobs, start_time always equals to create_time and is immutable and set by the Cloud Dataflow service.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def steps(self) -> pulumi.Output[Sequence['outputs.StepResponse']]:
        """
        Exactly one of step or steps_location should be specified. The top-level steps that constitute the entire job. Only retrieved with JOB_VIEW_ALL.
        """
        return pulumi.get(self, "steps")

    @property
    @pulumi.getter(name="stepsLocation")
    def steps_location(self) -> pulumi.Output[str]:
        """
        The Cloud Storage location where the steps are stored.
        """
        return pulumi.get(self, "steps_location")

    @property
    @pulumi.getter(name="tempFiles")
    def temp_files(self) -> pulumi.Output[Sequence[str]]:
        """
        A set of files the system should be aware of that are used for temporary storage. These temporary files will be removed on job completion. No duplicates are allowed. No file patterns are supported. The supported files are: Google Cloud Storage: storage.googleapis.com/{bucket}/{object} bucket.storage.googleapis.com/{object}
        """
        return pulumi.get(self, "temp_files")

    @property
    @pulumi.getter(name="transformNameMapping")
    def transform_name_mapping(self) -> pulumi.Output[Mapping[str, str]]:
        """
        The map of transform name prefixes of the job to be replaced to the corresponding name prefixes of the new job.
        """
        return pulumi.get(self, "transform_name_mapping")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of Cloud Dataflow job.
        """
        return pulumi.get(self, "type")

