# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GithubEnterpriseConfigArgs', 'GithubEnterpriseConfig']

@pulumi.input_type
class GithubEnterpriseConfigArgs:
    def __init__(__self__, *,
                 app_id: pulumi.Input[str],
                 display_name: Optional[pulumi.Input[str]] = None,
                 ghe_config_id: Optional[pulumi.Input[str]] = None,
                 host_url: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 peered_network: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 secrets: Optional[pulumi.Input['GitHubEnterpriseSecretsArgs']] = None,
                 ssl_ca: Optional[pulumi.Input[str]] = None,
                 webhook_key: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a GithubEnterpriseConfig resource.
        :param pulumi.Input[str] app_id: The GitHub app id of the Cloud Build app on the GitHub Enterprise server.
        :param pulumi.Input[str] display_name: Name to display for this config.
        :param pulumi.Input[str] ghe_config_id: Optional. The ID to use for the GithubEnterpriseConfig, which will become the final component of the GithubEnterpriseConfig’s resource name. ghe_config_id must meet the following requirements: + They must contain only alphanumeric characters and dashes. + They can be 1-64 characters long. + They must begin and end with an alphanumeric character
        :param pulumi.Input[str] host_url: The URL of the github enterprise host the configuration is for.
        :param pulumi.Input[str] name: Optional. The full resource name for the GitHubEnterpriseConfig For example: "projects/{$project_id}/githubEnterpriseConfigs/{$config_id}"
        :param pulumi.Input[str] peered_network: Optional. The network to be used when reaching out to the GitHub Enterprise server. The VPC network must be enabled for private service connection. This should be set if the GitHub Enterprise server is hosted on-premises and not reachable by public internet. If this field is left empty, no network peering will occur and calls to the GitHub Enterprise server will be made over the public internet. Must be in the format `projects/{project}/global/networks/{network}`, where {project} is a project number or id and {network} is the name of a VPC network in the project.
        :param pulumi.Input[str] project_id: ID of the project.
        :param pulumi.Input['GitHubEnterpriseSecretsArgs'] secrets: Names of secrets in Secret Manager.
        :param pulumi.Input[str] ssl_ca: Optional. SSL certificate to use for requests to GitHub Enterprise.
        :param pulumi.Input[str] webhook_key: The key that should be attached to webhook calls to the ReceiveWebhook endpoint.
        """
        pulumi.set(__self__, "app_id", app_id)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if ghe_config_id is not None:
            pulumi.set(__self__, "ghe_config_id", ghe_config_id)
        if host_url is not None:
            pulumi.set(__self__, "host_url", host_url)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if peered_network is not None:
            pulumi.set(__self__, "peered_network", peered_network)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)
        if ssl_ca is not None:
            pulumi.set(__self__, "ssl_ca", ssl_ca)
        if webhook_key is not None:
            pulumi.set(__self__, "webhook_key", webhook_key)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> pulumi.Input[str]:
        """
        The GitHub app id of the Cloud Build app on the GitHub Enterprise server.
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "app_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name to display for this config.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="gheConfigId")
    def ghe_config_id(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The ID to use for the GithubEnterpriseConfig, which will become the final component of the GithubEnterpriseConfig’s resource name. ghe_config_id must meet the following requirements: + They must contain only alphanumeric characters and dashes. + They can be 1-64 characters long. + They must begin and end with an alphanumeric character
        """
        return pulumi.get(self, "ghe_config_id")

    @ghe_config_id.setter
    def ghe_config_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ghe_config_id", value)

    @property
    @pulumi.getter(name="hostUrl")
    def host_url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL of the github enterprise host the configuration is for.
        """
        return pulumi.get(self, "host_url")

    @host_url.setter
    def host_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_url", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The full resource name for the GitHubEnterpriseConfig For example: "projects/{$project_id}/githubEnterpriseConfigs/{$config_id}"
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="peeredNetwork")
    def peered_network(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The network to be used when reaching out to the GitHub Enterprise server. The VPC network must be enabled for private service connection. This should be set if the GitHub Enterprise server is hosted on-premises and not reachable by public internet. If this field is left empty, no network peering will occur and calls to the GitHub Enterprise server will be made over the public internet. Must be in the format `projects/{project}/global/networks/{network}`, where {project} is a project number or id and {network} is the name of a VPC network in the project.
        """
        return pulumi.get(self, "peered_network")

    @peered_network.setter
    def peered_network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peered_network", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def secrets(self) -> Optional[pulumi.Input['GitHubEnterpriseSecretsArgs']]:
        """
        Names of secrets in Secret Manager.
        """
        return pulumi.get(self, "secrets")

    @secrets.setter
    def secrets(self, value: Optional[pulumi.Input['GitHubEnterpriseSecretsArgs']]):
        pulumi.set(self, "secrets", value)

    @property
    @pulumi.getter(name="sslCa")
    def ssl_ca(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. SSL certificate to use for requests to GitHub Enterprise.
        """
        return pulumi.get(self, "ssl_ca")

    @ssl_ca.setter
    def ssl_ca(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_ca", value)

    @property
    @pulumi.getter(name="webhookKey")
    def webhook_key(self) -> Optional[pulumi.Input[str]]:
        """
        The key that should be attached to webhook calls to the ReceiveWebhook endpoint.
        """
        return pulumi.get(self, "webhook_key")

    @webhook_key.setter
    def webhook_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "webhook_key", value)


class GithubEnterpriseConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_id: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 ghe_config_id: Optional[pulumi.Input[str]] = None,
                 host_url: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 peered_network: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 secrets: Optional[pulumi.Input[pulumi.InputType['GitHubEnterpriseSecretsArgs']]] = None,
                 ssl_ca: Optional[pulumi.Input[str]] = None,
                 webhook_key: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create an association between a GCP project and a GitHub Enterprise server.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] app_id: The GitHub app id of the Cloud Build app on the GitHub Enterprise server.
        :param pulumi.Input[str] display_name: Name to display for this config.
        :param pulumi.Input[str] ghe_config_id: Optional. The ID to use for the GithubEnterpriseConfig, which will become the final component of the GithubEnterpriseConfig’s resource name. ghe_config_id must meet the following requirements: + They must contain only alphanumeric characters and dashes. + They can be 1-64 characters long. + They must begin and end with an alphanumeric character
        :param pulumi.Input[str] host_url: The URL of the github enterprise host the configuration is for.
        :param pulumi.Input[str] name: Optional. The full resource name for the GitHubEnterpriseConfig For example: "projects/{$project_id}/githubEnterpriseConfigs/{$config_id}"
        :param pulumi.Input[str] peered_network: Optional. The network to be used when reaching out to the GitHub Enterprise server. The VPC network must be enabled for private service connection. This should be set if the GitHub Enterprise server is hosted on-premises and not reachable by public internet. If this field is left empty, no network peering will occur and calls to the GitHub Enterprise server will be made over the public internet. Must be in the format `projects/{project}/global/networks/{network}`, where {project} is a project number or id and {network} is the name of a VPC network in the project.
        :param pulumi.Input[str] project_id: ID of the project.
        :param pulumi.Input[pulumi.InputType['GitHubEnterpriseSecretsArgs']] secrets: Names of secrets in Secret Manager.
        :param pulumi.Input[str] ssl_ca: Optional. SSL certificate to use for requests to GitHub Enterprise.
        :param pulumi.Input[str] webhook_key: The key that should be attached to webhook calls to the ReceiveWebhook endpoint.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GithubEnterpriseConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create an association between a GCP project and a GitHub Enterprise server.

        :param str resource_name: The name of the resource.
        :param GithubEnterpriseConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GithubEnterpriseConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_id: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 ghe_config_id: Optional[pulumi.Input[str]] = None,
                 host_url: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 peered_network: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 secrets: Optional[pulumi.Input[pulumi.InputType['GitHubEnterpriseSecretsArgs']]] = None,
                 ssl_ca: Optional[pulumi.Input[str]] = None,
                 webhook_key: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GithubEnterpriseConfigArgs.__new__(GithubEnterpriseConfigArgs)

            if app_id is None and not opts.urn:
                raise TypeError("Missing required property 'app_id'")
            __props__.__dict__["app_id"] = app_id
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["ghe_config_id"] = ghe_config_id
            __props__.__dict__["host_url"] = host_url
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["peered_network"] = peered_network
            __props__.__dict__["project"] = project
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["secrets"] = secrets
            __props__.__dict__["ssl_ca"] = ssl_ca
            __props__.__dict__["webhook_key"] = webhook_key
            __props__.__dict__["create_time"] = None
        super(GithubEnterpriseConfig, __self__).__init__(
            'google-native:cloudbuild/v1:GithubEnterpriseConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'GithubEnterpriseConfig':
        """
        Get an existing GithubEnterpriseConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = GithubEnterpriseConfigArgs.__new__(GithubEnterpriseConfigArgs)

        __props__.__dict__["app_id"] = None
        __props__.__dict__["create_time"] = None
        __props__.__dict__["display_name"] = None
        __props__.__dict__["host_url"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["peered_network"] = None
        __props__.__dict__["secrets"] = None
        __props__.__dict__["ssl_ca"] = None
        __props__.__dict__["webhook_key"] = None
        return GithubEnterpriseConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> pulumi.Output[str]:
        """
        The GitHub app id of the Cloud Build app on the GitHub Enterprise server.
        """
        return pulumi.get(self, "app_id")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Time when the installation was associated with the project.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        Name to display for this config.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="hostUrl")
    def host_url(self) -> pulumi.Output[str]:
        """
        The URL of the github enterprise host the configuration is for.
        """
        return pulumi.get(self, "host_url")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Optional. The full resource name for the GitHubEnterpriseConfig For example: "projects/{$project_id}/githubEnterpriseConfigs/{$config_id}"
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="peeredNetwork")
    def peered_network(self) -> pulumi.Output[str]:
        """
        Optional. The network to be used when reaching out to the GitHub Enterprise server. The VPC network must be enabled for private service connection. This should be set if the GitHub Enterprise server is hosted on-premises and not reachable by public internet. If this field is left empty, no network peering will occur and calls to the GitHub Enterprise server will be made over the public internet. Must be in the format `projects/{project}/global/networks/{network}`, where {project} is a project number or id and {network} is the name of a VPC network in the project.
        """
        return pulumi.get(self, "peered_network")

    @property
    @pulumi.getter
    def secrets(self) -> pulumi.Output['outputs.GitHubEnterpriseSecretsResponse']:
        """
        Names of secrets in Secret Manager.
        """
        return pulumi.get(self, "secrets")

    @property
    @pulumi.getter(name="sslCa")
    def ssl_ca(self) -> pulumi.Output[str]:
        """
        Optional. SSL certificate to use for requests to GitHub Enterprise.
        """
        return pulumi.get(self, "ssl_ca")

    @property
    @pulumi.getter(name="webhookKey")
    def webhook_key(self) -> pulumi.Output[str]:
        """
        The key that should be attached to webhook calls to the ReceiveWebhook endpoint.
        """
        return pulumi.get(self, "webhook_key")

