# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['SnapshotSchedulePolicyArgs', 'SnapshotSchedulePolicy']

@pulumi.input_type
class SnapshotSchedulePolicyArgs:
    def __init__(__self__, *,
                 snapshot_schedule_policy_id: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 schedules: Optional[pulumi.Input[Sequence[pulumi.Input['ScheduleArgs']]]] = None,
                 state: Optional[pulumi.Input['SnapshotSchedulePolicyState']] = None):
        """
        The set of arguments for constructing a SnapshotSchedulePolicy resource.
        :param pulumi.Input[str] snapshot_schedule_policy_id: Required. Snapshot policy ID
        :param pulumi.Input[str] description: The description of the snapshot schedule policy.
        :param pulumi.Input[str] id: An identifier for the snapshot schedule policy, generated by the backend.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels as key value pairs.
        :param pulumi.Input[Sequence[pulumi.Input['ScheduleArgs']]] schedules: The snapshot schedules contained in this policy. You can specify a maximum of 5 schedules.
        :param pulumi.Input['SnapshotSchedulePolicyState'] state: The state of the snapshot schedule policy.
        """
        pulumi.set(__self__, "snapshot_schedule_policy_id", snapshot_schedule_policy_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if schedules is not None:
            pulumi.set(__self__, "schedules", schedules)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="snapshotSchedulePolicyId")
    def snapshot_schedule_policy_id(self) -> pulumi.Input[str]:
        """
        Required. Snapshot policy ID
        """
        return pulumi.get(self, "snapshot_schedule_policy_id")

    @snapshot_schedule_policy_id.setter
    def snapshot_schedule_policy_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "snapshot_schedule_policy_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the snapshot schedule policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        An identifier for the snapshot schedule policy, generated by the backend.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Labels as key value pairs.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def schedules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScheduleArgs']]]]:
        """
        The snapshot schedules contained in this policy. You can specify a maximum of 5 schedules.
        """
        return pulumi.get(self, "schedules")

    @schedules.setter
    def schedules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScheduleArgs']]]]):
        pulumi.set(self, "schedules", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input['SnapshotSchedulePolicyState']]:
        """
        The state of the snapshot schedule policy.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input['SnapshotSchedulePolicyState']]):
        pulumi.set(self, "state", value)


class SnapshotSchedulePolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 schedules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ScheduleArgs']]]]] = None,
                 snapshot_schedule_policy_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input['SnapshotSchedulePolicyState']] = None,
                 __props__=None):
        """
        Create a snapshot schedule policy in the specified project.
        Auto-naming is currently not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the snapshot schedule policy.
        :param pulumi.Input[str] id: An identifier for the snapshot schedule policy, generated by the backend.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels as key value pairs.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ScheduleArgs']]]] schedules: The snapshot schedules contained in this policy. You can specify a maximum of 5 schedules.
        :param pulumi.Input[str] snapshot_schedule_policy_id: Required. Snapshot policy ID
        :param pulumi.Input['SnapshotSchedulePolicyState'] state: The state of the snapshot schedule policy.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SnapshotSchedulePolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a snapshot schedule policy in the specified project.
        Auto-naming is currently not supported for this resource.

        :param str resource_name: The name of the resource.
        :param SnapshotSchedulePolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SnapshotSchedulePolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 schedules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ScheduleArgs']]]]] = None,
                 snapshot_schedule_policy_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input['SnapshotSchedulePolicyState']] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SnapshotSchedulePolicyArgs.__new__(SnapshotSchedulePolicyArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["id"] = id
            __props__.__dict__["labels"] = labels
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            __props__.__dict__["schedules"] = schedules
            if snapshot_schedule_policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'snapshot_schedule_policy_id'")
            __props__.__dict__["snapshot_schedule_policy_id"] = snapshot_schedule_policy_id
            __props__.__dict__["state"] = state
            __props__.__dict__["name"] = None
        super(SnapshotSchedulePolicy, __self__).__init__(
            'google-native:baremetalsolution/v2:SnapshotSchedulePolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'SnapshotSchedulePolicy':
        """
        Get an existing SnapshotSchedulePolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = SnapshotSchedulePolicyArgs.__new__(SnapshotSchedulePolicyArgs)

        __props__.__dict__["description"] = None
        __props__.__dict__["labels"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["schedules"] = None
        __props__.__dict__["state"] = None
        return SnapshotSchedulePolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description of the snapshot schedule policy.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Labels as key value pairs.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the snapshot schedule policy.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def schedules(self) -> pulumi.Output[Sequence['outputs.ScheduleResponse']]:
        """
        The snapshot schedules contained in this policy. You can specify a maximum of 5 schedules.
        """
        return pulumi.get(self, "schedules")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The state of the snapshot schedule policy.
        """
        return pulumi.get(self, "state")

