# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetSnapshotSchedulePolicyResult',
    'AwaitableGetSnapshotSchedulePolicyResult',
    'get_snapshot_schedule_policy',
    'get_snapshot_schedule_policy_output',
]

@pulumi.output_type
class GetSnapshotSchedulePolicyResult:
    def __init__(__self__, description=None, labels=None, name=None, schedules=None, state=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if schedules and not isinstance(schedules, list):
            raise TypeError("Expected argument 'schedules' to be a list")
        pulumi.set(__self__, "schedules", schedules)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the snapshot schedule policy.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Labels as key value pairs.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the snapshot schedule policy.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def schedules(self) -> Sequence['outputs.ScheduleResponse']:
        """
        The snapshot schedules contained in this policy. You can specify a maximum of 5 schedules.
        """
        return pulumi.get(self, "schedules")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of the snapshot schedule policy.
        """
        return pulumi.get(self, "state")


class AwaitableGetSnapshotSchedulePolicyResult(GetSnapshotSchedulePolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSnapshotSchedulePolicyResult(
            description=self.description,
            labels=self.labels,
            name=self.name,
            schedules=self.schedules,
            state=self.state)


def get_snapshot_schedule_policy(location: Optional[str] = None,
                                 project: Optional[str] = None,
                                 snapshot_schedule_policy_id: Optional[str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSnapshotSchedulePolicyResult:
    """
    Get details of a single snapshot schedule policy.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['project'] = project
    __args__['snapshotSchedulePolicyId'] = snapshot_schedule_policy_id
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:baremetalsolution/v2:getSnapshotSchedulePolicy', __args__, opts=opts, typ=GetSnapshotSchedulePolicyResult).value

    return AwaitableGetSnapshotSchedulePolicyResult(
        description=__ret__.description,
        labels=__ret__.labels,
        name=__ret__.name,
        schedules=__ret__.schedules,
        state=__ret__.state)


@_utilities.lift_output_func(get_snapshot_schedule_policy)
def get_snapshot_schedule_policy_output(location: Optional[pulumi.Input[str]] = None,
                                        project: Optional[pulumi.Input[Optional[str]]] = None,
                                        snapshot_schedule_policy_id: Optional[pulumi.Input[str]] = None,
                                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSnapshotSchedulePolicyResult]:
    """
    Get details of a single snapshot schedule policy.
    """
    ...
