# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetCanaryEvaluationResult',
    'AwaitableGetCanaryEvaluationResult',
    'get_canary_evaluation',
    'get_canary_evaluation_output',
]

@pulumi.output_type
class GetCanaryEvaluationResult:
    def __init__(__self__, control=None, create_time=None, end_time=None, metric_labels=None, name=None, start_time=None, state=None, treatment=None, verdict=None):
        if control and not isinstance(control, str):
            raise TypeError("Expected argument 'control' to be a str")
        pulumi.set(__self__, "control", control)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if end_time and not isinstance(end_time, str):
            raise TypeError("Expected argument 'end_time' to be a str")
        pulumi.set(__self__, "end_time", end_time)
        if metric_labels and not isinstance(metric_labels, dict):
            raise TypeError("Expected argument 'metric_labels' to be a dict")
        pulumi.set(__self__, "metric_labels", metric_labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if start_time and not isinstance(start_time, str):
            raise TypeError("Expected argument 'start_time' to be a str")
        pulumi.set(__self__, "start_time", start_time)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if treatment and not isinstance(treatment, str):
            raise TypeError("Expected argument 'treatment' to be a str")
        pulumi.set(__self__, "treatment", treatment)
        if verdict and not isinstance(verdict, str):
            raise TypeError("Expected argument 'verdict' to be a str")
        pulumi.set(__self__, "verdict", verdict)

    @property
    @pulumi.getter
    def control(self) -> str:
        """
        The stable version that is serving requests.
        """
        return pulumi.get(self, "control")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        Create time of the canary evaluation.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        """
        End time for the evaluation's analysis.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="metricLabels")
    def metric_labels(self) -> 'outputs.GoogleCloudApigeeV1CanaryEvaluationMetricLabelsResponse':
        """
        Labels used to filter the metrics used for a canary evaluation.
        """
        return pulumi.get(self, "metric_labels")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the canary evalution.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        Start time for the canary evaluation's analysis.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the canary evaluation.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def treatment(self) -> str:
        """
        The newer version that is serving requests.
        """
        return pulumi.get(self, "treatment")

    @property
    @pulumi.getter
    def verdict(self) -> str:
        """
        The resulting verdict of the canary evaluations: NONE, PASS, or FAIL.
        """
        return pulumi.get(self, "verdict")


class AwaitableGetCanaryEvaluationResult(GetCanaryEvaluationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCanaryEvaluationResult(
            control=self.control,
            create_time=self.create_time,
            end_time=self.end_time,
            metric_labels=self.metric_labels,
            name=self.name,
            start_time=self.start_time,
            state=self.state,
            treatment=self.treatment,
            verdict=self.verdict)


def get_canary_evaluation(canaryevaluation_id: Optional[str] = None,
                          instance_id: Optional[str] = None,
                          organization_id: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCanaryEvaluationResult:
    """
    Gets a CanaryEvaluation for an organization.
    """
    __args__ = dict()
    __args__['canaryevaluationId'] = canaryevaluation_id
    __args__['instanceId'] = instance_id
    __args__['organizationId'] = organization_id
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:apigee/v1:getCanaryEvaluation', __args__, opts=opts, typ=GetCanaryEvaluationResult).value

    return AwaitableGetCanaryEvaluationResult(
        control=__ret__.control,
        create_time=__ret__.create_time,
        end_time=__ret__.end_time,
        metric_labels=__ret__.metric_labels,
        name=__ret__.name,
        start_time=__ret__.start_time,
        state=__ret__.state,
        treatment=__ret__.treatment,
        verdict=__ret__.verdict)


@_utilities.lift_output_func(get_canary_evaluation)
def get_canary_evaluation_output(canaryevaluation_id: Optional[pulumi.Input[str]] = None,
                                 instance_id: Optional[pulumi.Input[str]] = None,
                                 organization_id: Optional[pulumi.Input[str]] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCanaryEvaluationResult]:
    """
    Gets a CanaryEvaluation for an organization.
    """
    ...
