# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['tests', 'xefab', 'xefab.hosts', 'xefab.hosts.uchicago', 'xefab.tasks']

package_data = \
{'': ['*']}

install_requires = \
['appdirs>=1.4.4,<2.0.0',
 'decopatch>=1.4.10,<2.0.0',
 'fabric>=3.0.0,<4.0.0',
 'fsspec>=2023.1.0,<2024.0.0',
 'gnupg>=2.3.1,<3.0.0',
 'makefun>=1.15.0,<2.0.0',
 'pandas',
 'pydantic>=1.10.4,<2.0.0',
 'pymongo',
 'rich>=13.3.1,<14.0.0',
 'toml>=0.10.2,<0.11.0']

entry_points = \
{'console_scripts': ['xefab = xefab.main:program.run',
                     'xf = xefab.main:program.run'],
 'xefab.tasks': ['dali = xefab.hosts.uchicago.dali',
                 'midway = xefab.hosts.uchicago.midway',
                 'osg = xefab.hosts.osg']}

setup_kwargs = {
    'name': 'xefab',
    'version': '0.1.5',
    'description': 'Top-level package for xefab.',
    'long_description': "=====\nxefab\n=====\n\n.. image:: https://img.shields.io/badge/code%20style-black-000000.svg\n    :target: https://github.com/psf/black\n\nFabric based task execution for the XENON dark matter experiment\n\n\nInstallation\n------------\n\nTo install xefab, its recomended to use pipx_:\n\n.. code-block:: console\n\n    $ pipx install xefab\n\nAlternatively you can install it using pip:\n\n.. code-block:: console\n\n    $ pip install xefab\n\nUsage\n-----\n\nYou can list the available tasks and options by running xf/xefab without any options.\n\n.. code-block:: console\n\n    $ xf\n    Usage: xf [--core-opts] [<host>] [<subcommand>] task1 [--task1-opts] ... taskN [--taskN-opts]\n\n    Core options:\n\n    --complete                      Print tab-completion candidates for given parse remainder.                                       \n    --hide=STRING                   Set default value of run()'s 'hide' kwarg.                                                       \n    --print-completion-script=STRINGPrint the tab-completion script for your preferred shell (bash|zsh|fish).                        \n    --prompt-for-login-password     Request an upfront SSH-auth password prompt.                                                     \n    --prompt-for-passphrase         Request an upfront SSH key passphrase prompt.                                                    \n    --prompt-for-sudo-password      Prompt user at start of session for the sudo.password config value.                              \n    --write-pyc                     Enable creation of .pyc files.                                                                   \n    -d, --debug                     Enable debug output.                                                                             \n    -D INT, --list-depth=INT        When listing tasks, only show the first INT levels.                                              \n    -e, --echo                      Echo executed commands before running.                                                           \n    -f STRING, --config=STRING      Runtime configuration file to use.                                                               \n    -F STRING, --list-format=STRING Change the display format used when listing tasks. Should be one of: flat (default), nested,     \n                                    json.                                                                                            \n    -h [STRING], --help[=STRING]    Show core or per-task help and exit.                                                             \n    -H STRING, --hosts=STRING       Comma-separated host name(s) to execute tasks against.                                           \n    -i, --identity                  Path to runtime SSH identity (key) file. May be given multiple times.                            \n    -l [STRING], --list[=STRING]    List available tasks, optionally limited to a namespace.                                         \n    -p, --pty                       Use a pty when executing shell commands.                                                         \n    -R, --dry                       Echo commands instead of running.                                                                \n    -S STRING, --ssh-config=STRING  Path to runtime SSH config file.                                                                 \n    -t INT, --connect-timeout=INT   Specifies default connection timeout, in seconds.                                                \n    -T INT, --command-timeout=INT   Specify a global command execution timeout, in seconds.                                          \n    -V, --version                   Show version and exit.                                                                           \n    -w, --warn-only                 Warn, instead of failing, when shell commands fail.                                              \n\n\n    Subcommands:\n\n    show-context                      Show the context being used for tasks.                                                         \n    admin.user-db                                                                                                                    \n    dali.download-file                Download a file from a remote server.                                                          \n    dali.sbatch                       Create and submit a job to SLURM job queue on the remote host.                                 \n    dali.show-context                 Show the context being used for tasks.                                                         \n    dali.squeue (dali.job-queue)      Get the job-queue status.                                                                      \n    dali.start-jupyter                Start a jupyter analysis notebook on the remote host and forward to local port via ssh-tunnel. \n    dali.upload-file                  Upload a file to a remote server.                                                              \n    github.clone                                                                                                                     \n    github.is-private                                                                                                                \n    github.is-public                                                                                                                 \n    github.token                                                                                                                     \n    github.xenon1t-members                                                                                                           \n    github.xenonnt-keys                                                                                                              \n    github.xenonnt-members                                                                                                           \n    install.chezmoi                                                                                                                  \n    install.get-system                                                                                                               \n    install.github-cli (install.gh)                                                                                                  \n    install.gnupg (install.gpg)                                                                                                      \n    install.go                                                                                                                       \n    install.gopass                                                                                                                   \n    install.miniconda (install.conda)                                                                                                \n    install.which                                                                                                                    \n    midway.download-file              Download a file from a remote server.                                                          \n    midway.sbatch                     Create and submit a job to SLURM job queue on the remote host.                                 \n    midway.show-context               Show the context being used for tasks.                                                         \n    midway.squeue (midway.job-queue)  Get the job-queue status.                                                                      \n    midway.start-jupyter              Start a jupyter analysis notebook on the remote host and forward to local port via ssh-tunnel. \n    midway.upload-file                Upload a file to a remote server.                                                              \n    osg.condorq (osg.job-queue)                                                                                                      \n    osg.mc-chain                      Run a full chain MC simulation                                                                 \n    secrets.setup                                                                                                                    \n    secrets.setup-utilix-config                                                                                                      \n    sh.exists                                                                                                                        \n    sh.get-system                                                                                                                    \n    sh.is-dir                                                                                                                        \n    sh.is-file                                                                                                                       \n    sh.path                                                                                                                          \n    sh.shell (sh)                     Open interactive shell on remote host.                                                         \n    sh.which                                                                   \n\nYou can get help for a specific task by running e.g.\n\n.. code-block:: console\n\n    $ xf --help midway.start-jupyter\n    ╭─ start-jupyter ───────────────────────────────────────────────────────────────────────────────────────────────────────────────╮\n    │ xf [--core-opts] start-jupyter [--options][other tasks here ...]                                                              │\n    │                                                                                                                               │\n    │ Start a jupyter analysis notebook on the remote host and forward to local port via ssh-tunnel.                                │\n    │                                                                                                                               │\n    │ Options:                                                                                                                      │\n    │ --image-dir=STRING                              Directory to look for singularity images                                      │\n    │ --remote-port=STRING                            Port to use for jupyter server to on the worker node                          │\n    │ --=INT, --local-port=INT                        Local port to attempt to forward to (if free)                                 │\n    │ -a INT, --max-hours=INT                         Maximum number of hours to run for                                            │\n    │ -b, --bypass-reservation                        Dont attempt to use the xenon notebook reservation                            │\n    │ -c INT, --cpu=INT                               Number of CPUs to request                                                     │\n    │ -d, --detached                                  Run the job and exit, dont perform cleanup tasks.                             │\n    │ -e STRING, --env=STRING                         Environment to run on                                                         │\n    │ -f, --force-new                                 Force a new job to be started                                                 │\n    │ -g, --gpu                                       Use a GPU                                                                     │\n    │ -i STRING, --binds=STRING                       Directories to bind to the container                                          │\n    │ -j STRING, --jupyter=STRING                     Type of jupyter server to start (lab or notebook)                             │\n    │ -l, --local-cutax                               Use user installed cutax (from ~/.local)                                      │\n    │ -m INT, --timeout=INT                           Timeout for the job to start                                                  │\n    │ -n STRING, --node=STRING                        Node to run on                                                                │\n    │ -o STRING, --notebook-dir=STRING                Directory to start the notebook in                                            │\n    │ -p STRING, --partition=STRING                   Partition to run on (xenon1t or dali)                                         │\n    │ -r INT, --ram=INT                               Amount of RAM to allocate (in MB)                                             │\n    │ -t STRING, --tag=STRING                         Tag of the container to use                                                   │\n    │ -u, --debug                                     Print debug information                                                       │\n    │ -w, --no-browser                                Dont open the browser automatically when done                                 │\n    ╰───────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╯\n\nSome tasks are registered to run on a specific host. When you run them, the --hosts option will be ignored.\n\ne.g. if you run\n\n.. code-block:: console\n\n    $ xf midway start-jupyter\n\nThe task will be run on the midway host, not the host you specified with --hosts.\n\n\nFeatures\n--------\n\n* TODO\n\nCredits\n-------\n\nThis package was created with Cookiecutter_ and the `briggySmalls/cookiecutter-pypackage`_ project template.\n\n.. _Cookiecutter: https://github.com/audreyr/cookiecutter\n.. _`briggySmalls/cookiecutter-pypackage`: https://github.com/briggySmalls/cookiecutter-pypackage\n.. _pipx: https://github.com/pypa/pipx\n",
    'author': 'Yossi Mosbacher',
    'author_email': 'joe.mosbacher@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/jmosbacher/xefab',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8',
}


setup(**setup_kwargs)
