# coding: utf-8

"""
    CLOUD API

    An enterprise-grade Infrastructure is provided as a Service (IaaS) solution that can be managed through a browser-based \"Data Center Designer\" (DCD) tool or via an easy to use API.   The API allows you to perform a variety of management tasks such as spinning up additional servers, adding volumes, adjusting networking, and so forth. It is designed to allow users to leverage the same power and flexibility found within the DCD visual tool. Both tools are consistent with their concepts and lend well to making the experience smooth and intuitive.  # noqa: E501

    The version of the OpenAPI document: 6.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ionoscloud.configuration import Configuration


class NetworkLoadBalancerForwardingRuleProperties(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'name': 'str',
        'algorithm': 'str',
        'protocol': 'str',
        'listener_ip': 'str',
        'listener_port': 'int',
        'health_check': 'NetworkLoadBalancerForwardingRuleHealthCheck',
        'targets': 'list[NetworkLoadBalancerForwardingRuleTarget]',
    }

    attribute_map = {
        'name': 'name',
        'algorithm': 'algorithm',
        'protocol': 'protocol',
        'listener_ip': 'listenerIp',
        'listener_port': 'listenerPort',
        'health_check': 'healthCheck',
        'targets': 'targets',
    }

    def __init__(self, name=None, algorithm=None, protocol=None, listener_ip=None, listener_port=None, health_check=None, targets=None, local_vars_configuration=None):  # noqa: E501
        """NetworkLoadBalancerForwardingRuleProperties - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._algorithm = None
        self._protocol = None
        self._listener_ip = None
        self._listener_port = None
        self._health_check = None
        self._targets = None
        self.discriminator = None

        self.name = name
        self.algorithm = algorithm
        self.protocol = protocol
        self.listener_ip = listener_ip
        self.listener_port = listener_port
        if health_check is not None:
            self.health_check = health_check
        self.targets = targets

    @property
    def name(self):
        """Gets the name of this NetworkLoadBalancerForwardingRuleProperties.  # noqa: E501

        A name of that Network Load Balancer forwarding rule  # noqa: E501

        :return: The name of this NetworkLoadBalancerForwardingRuleProperties.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this NetworkLoadBalancerForwardingRuleProperties.

        A name of that Network Load Balancer forwarding rule  # noqa: E501

        :param name: The name of this NetworkLoadBalancerForwardingRuleProperties.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def algorithm(self):
        """Gets the algorithm of this NetworkLoadBalancerForwardingRuleProperties.  # noqa: E501

        Algorithm for the balancing.  # noqa: E501

        :return: The algorithm of this NetworkLoadBalancerForwardingRuleProperties.  # noqa: E501
        :rtype: str
        """
        return self._algorithm

    @algorithm.setter
    def algorithm(self, algorithm):
        """Sets the algorithm of this NetworkLoadBalancerForwardingRuleProperties.

        Algorithm for the balancing.  # noqa: E501

        :param algorithm: The algorithm of this NetworkLoadBalancerForwardingRuleProperties.  # noqa: E501
        :type algorithm: str
        """
        if self.local_vars_configuration.client_side_validation and algorithm is None:  # noqa: E501
            raise ValueError("Invalid value for `algorithm`, must not be `None`")  # noqa: E501
        allowed_values = ["ROUND_ROBIN", "LEAST_CONNECTION", "RANDOM", "SOURCE_IP"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and algorithm not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `algorithm` ({0}), must be one of {1}"  # noqa: E501
                .format(algorithm, allowed_values)
            )

        self._algorithm = algorithm

    @property
    def protocol(self):
        """Gets the protocol of this NetworkLoadBalancerForwardingRuleProperties.  # noqa: E501

        Protocol of the balancing.  # noqa: E501

        :return: The protocol of this NetworkLoadBalancerForwardingRuleProperties.  # noqa: E501
        :rtype: str
        """
        return self._protocol

    @protocol.setter
    def protocol(self, protocol):
        """Sets the protocol of this NetworkLoadBalancerForwardingRuleProperties.

        Protocol of the balancing.  # noqa: E501

        :param protocol: The protocol of this NetworkLoadBalancerForwardingRuleProperties.  # noqa: E501
        :type protocol: str
        """
        if self.local_vars_configuration.client_side_validation and protocol is None:  # noqa: E501
            raise ValueError("Invalid value for `protocol`, must not be `None`")  # noqa: E501
        allowed_values = ["TCP"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and protocol not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `protocol` ({0}), must be one of {1}"  # noqa: E501
                .format(protocol, allowed_values)
            )

        self._protocol = protocol

    @property
    def listener_ip(self):
        """Gets the listener_ip of this NetworkLoadBalancerForwardingRuleProperties.  # noqa: E501

        Listening IP. (inbound)  # noqa: E501

        :return: The listener_ip of this NetworkLoadBalancerForwardingRuleProperties.  # noqa: E501
        :rtype: str
        """
        return self._listener_ip

    @listener_ip.setter
    def listener_ip(self, listener_ip):
        """Sets the listener_ip of this NetworkLoadBalancerForwardingRuleProperties.

        Listening IP. (inbound)  # noqa: E501

        :param listener_ip: The listener_ip of this NetworkLoadBalancerForwardingRuleProperties.  # noqa: E501
        :type listener_ip: str
        """
        if self.local_vars_configuration.client_side_validation and listener_ip is None:  # noqa: E501
            raise ValueError("Invalid value for `listener_ip`, must not be `None`")  # noqa: E501

        self._listener_ip = listener_ip

    @property
    def listener_port(self):
        """Gets the listener_port of this NetworkLoadBalancerForwardingRuleProperties.  # noqa: E501

        Listening port number. (inbound) (range: 1 to 65535)  # noqa: E501

        :return: The listener_port of this NetworkLoadBalancerForwardingRuleProperties.  # noqa: E501
        :rtype: int
        """
        return self._listener_port

    @listener_port.setter
    def listener_port(self, listener_port):
        """Sets the listener_port of this NetworkLoadBalancerForwardingRuleProperties.

        Listening port number. (inbound) (range: 1 to 65535)  # noqa: E501

        :param listener_port: The listener_port of this NetworkLoadBalancerForwardingRuleProperties.  # noqa: E501
        :type listener_port: int
        """
        if self.local_vars_configuration.client_side_validation and listener_port is None:  # noqa: E501
            raise ValueError("Invalid value for `listener_port`, must not be `None`")  # noqa: E501

        self._listener_port = listener_port

    @property
    def health_check(self):
        """Gets the health_check of this NetworkLoadBalancerForwardingRuleProperties.  # noqa: E501


        :return: The health_check of this NetworkLoadBalancerForwardingRuleProperties.  # noqa: E501
        :rtype: NetworkLoadBalancerForwardingRuleHealthCheck
        """
        return self._health_check

    @health_check.setter
    def health_check(self, health_check):
        """Sets the health_check of this NetworkLoadBalancerForwardingRuleProperties.


        :param health_check: The health_check of this NetworkLoadBalancerForwardingRuleProperties.  # noqa: E501
        :type health_check: NetworkLoadBalancerForwardingRuleHealthCheck
        """

        self._health_check = health_check

    @property
    def targets(self):
        """Gets the targets of this NetworkLoadBalancerForwardingRuleProperties.  # noqa: E501

        Array of items in that collection  # noqa: E501

        :return: The targets of this NetworkLoadBalancerForwardingRuleProperties.  # noqa: E501
        :rtype: list[NetworkLoadBalancerForwardingRuleTarget]
        """
        return self._targets

    @targets.setter
    def targets(self, targets):
        """Sets the targets of this NetworkLoadBalancerForwardingRuleProperties.

        Array of items in that collection  # noqa: E501

        :param targets: The targets of this NetworkLoadBalancerForwardingRuleProperties.  # noqa: E501
        :type targets: list[NetworkLoadBalancerForwardingRuleTarget]
        """
        if self.local_vars_configuration.client_side_validation and targets is None:  # noqa: E501
            raise ValueError("Invalid value for `targets`, must not be `None`")  # noqa: E501

        self._targets = targets

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NetworkLoadBalancerForwardingRuleProperties):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, NetworkLoadBalancerForwardingRuleProperties):
            return True

        return self.to_dict() != other.to_dict()
