# coding: utf-8

"""
    CLOUD API

    An enterprise-grade Infrastructure is provided as a Service (IaaS) solution that can be managed through a browser-based \"Data Center Designer\" (DCD) tool or via an easy to use API.   The API allows you to perform a variety of management tasks such as spinning up additional servers, adding volumes, adjusting networking, and so forth. It is designed to allow users to leverage the same power and flexibility found within the DCD visual tool. Both tools are consistent with their concepts and lend well to making the experience smooth and intuitive.  # noqa: E501

    The version of the OpenAPI document: 6.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ionoscloud.configuration import Configuration


class NatGatewayRuleProperties(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'name': 'str',
        'type': 'NatGatewayRuleType',
        'protocol': 'NatGatewayRuleProtocol',
        'source_subnet': 'str',
        'public_ip': 'str',
        'target_subnet': 'str',
        'target_port_range': 'TargetPortRange',
    }

    attribute_map = {
        'name': 'name',
        'type': 'type',
        'protocol': 'protocol',
        'source_subnet': 'sourceSubnet',
        'public_ip': 'publicIp',
        'target_subnet': 'targetSubnet',
        'target_port_range': 'targetPortRange',
    }

    def __init__(self, name=None, type=None, protocol=None, source_subnet=None, public_ip=None, target_subnet=None, target_port_range=None, local_vars_configuration=None):  # noqa: E501
        """NatGatewayRuleProperties - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._type = None
        self._protocol = None
        self._source_subnet = None
        self._public_ip = None
        self._target_subnet = None
        self._target_port_range = None
        self.discriminator = None

        self.name = name
        if type is not None:
            self.type = type
        if protocol is not None:
            self.protocol = protocol
        self.source_subnet = source_subnet
        self.public_ip = public_ip
        if target_subnet is not None:
            self.target_subnet = target_subnet
        if target_port_range is not None:
            self.target_port_range = target_port_range

    @property
    def name(self):
        """Gets the name of this NatGatewayRuleProperties.  # noqa: E501

        Name of the NAT gateway rule  # noqa: E501

        :return: The name of this NatGatewayRuleProperties.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this NatGatewayRuleProperties.

        Name of the NAT gateway rule  # noqa: E501

        :param name: The name of this NatGatewayRuleProperties.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def type(self):
        """Gets the type of this NatGatewayRuleProperties.  # noqa: E501

        Type of the NAT gateway rule.  # noqa: E501

        :return: The type of this NatGatewayRuleProperties.  # noqa: E501
        :rtype: NatGatewayRuleType
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this NatGatewayRuleProperties.

        Type of the NAT gateway rule.  # noqa: E501

        :param type: The type of this NatGatewayRuleProperties.  # noqa: E501
        :type type: NatGatewayRuleType
        """

        self._type = type

    @property
    def protocol(self):
        """Gets the protocol of this NatGatewayRuleProperties.  # noqa: E501

        Protocol of the NAT gateway rule. Defaults to ALL. If protocol is 'ICMP' then targetPortRange start and end cannot be set.  # noqa: E501

        :return: The protocol of this NatGatewayRuleProperties.  # noqa: E501
        :rtype: NatGatewayRuleProtocol
        """
        return self._protocol

    @protocol.setter
    def protocol(self, protocol):
        """Sets the protocol of this NatGatewayRuleProperties.

        Protocol of the NAT gateway rule. Defaults to ALL. If protocol is 'ICMP' then targetPortRange start and end cannot be set.  # noqa: E501

        :param protocol: The protocol of this NatGatewayRuleProperties.  # noqa: E501
        :type protocol: NatGatewayRuleProtocol
        """

        self._protocol = protocol

    @property
    def source_subnet(self):
        """Gets the source_subnet of this NatGatewayRuleProperties.  # noqa: E501

        Source subnet of the NAT gateway rule. For SNAT rules it specifies which packets this translation rule applies to based on the packets source IP address.  # noqa: E501

        :return: The source_subnet of this NatGatewayRuleProperties.  # noqa: E501
        :rtype: str
        """
        return self._source_subnet

    @source_subnet.setter
    def source_subnet(self, source_subnet):
        """Sets the source_subnet of this NatGatewayRuleProperties.

        Source subnet of the NAT gateway rule. For SNAT rules it specifies which packets this translation rule applies to based on the packets source IP address.  # noqa: E501

        :param source_subnet: The source_subnet of this NatGatewayRuleProperties.  # noqa: E501
        :type source_subnet: str
        """
        if self.local_vars_configuration.client_side_validation and source_subnet is None:  # noqa: E501
            raise ValueError("Invalid value for `source_subnet`, must not be `None`")  # noqa: E501

        self._source_subnet = source_subnet

    @property
    def public_ip(self):
        """Gets the public_ip of this NatGatewayRuleProperties.  # noqa: E501

        Public IP address of the NAT gateway rule. Specifies the address used for masking outgoing packets source address field. Should be one of the customer reserved IP address already configured on the NAT gateway resource  # noqa: E501

        :return: The public_ip of this NatGatewayRuleProperties.  # noqa: E501
        :rtype: str
        """
        return self._public_ip

    @public_ip.setter
    def public_ip(self, public_ip):
        """Sets the public_ip of this NatGatewayRuleProperties.

        Public IP address of the NAT gateway rule. Specifies the address used for masking outgoing packets source address field. Should be one of the customer reserved IP address already configured on the NAT gateway resource  # noqa: E501

        :param public_ip: The public_ip of this NatGatewayRuleProperties.  # noqa: E501
        :type public_ip: str
        """
        if self.local_vars_configuration.client_side_validation and public_ip is None:  # noqa: E501
            raise ValueError("Invalid value for `public_ip`, must not be `None`")  # noqa: E501

        self._public_ip = public_ip

    @property
    def target_subnet(self):
        """Gets the target_subnet of this NatGatewayRuleProperties.  # noqa: E501

        Target or destination subnet of the NAT gateway rule. For SNAT rules it specifies which packets this translation rule applies to based on the packets destination IP address. If none is provided, rule will match any address.  # noqa: E501

        :return: The target_subnet of this NatGatewayRuleProperties.  # noqa: E501
        :rtype: str
        """
        return self._target_subnet

    @target_subnet.setter
    def target_subnet(self, target_subnet):
        """Sets the target_subnet of this NatGatewayRuleProperties.

        Target or destination subnet of the NAT gateway rule. For SNAT rules it specifies which packets this translation rule applies to based on the packets destination IP address. If none is provided, rule will match any address.  # noqa: E501

        :param target_subnet: The target_subnet of this NatGatewayRuleProperties.  # noqa: E501
        :type target_subnet: str
        """

        self._target_subnet = target_subnet

    @property
    def target_port_range(self):
        """Gets the target_port_range of this NatGatewayRuleProperties.  # noqa: E501


        :return: The target_port_range of this NatGatewayRuleProperties.  # noqa: E501
        :rtype: TargetPortRange
        """
        return self._target_port_range

    @target_port_range.setter
    def target_port_range(self, target_port_range):
        """Sets the target_port_range of this NatGatewayRuleProperties.


        :param target_port_range: The target_port_range of this NatGatewayRuleProperties.  # noqa: E501
        :type target_port_range: TargetPortRange
        """

        self._target_port_range = target_port_range

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NatGatewayRuleProperties):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, NatGatewayRuleProperties):
            return True

        return self.to_dict() != other.to_dict()
