# coding: utf-8

"""
    CLOUD API

    An enterprise-grade Infrastructure is provided as a Service (IaaS) solution that can be managed through a browser-based \"Data Center Designer\" (DCD) tool or via an easy to use API.   The API allows you to perform a variety of management tasks such as spinning up additional servers, adding volumes, adjusting networking, and so forth. It is designed to allow users to leverage the same power and flexibility found within the DCD visual tool. Both tools are consistent with their concepts and lend well to making the experience smooth and intuitive.  # noqa: E501

    The version of the OpenAPI document: 6.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ionoscloud.configuration import Configuration


class FirewallruleProperties(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'name': 'str',
        'protocol': 'str',
        'source_mac': 'str',
        'source_ip': 'str',
        'target_ip': 'str',
        'icmp_code': 'int',
        'icmp_type': 'int',
        'port_range_start': 'int',
        'port_range_end': 'int',
        'type': 'str',
    }

    attribute_map = {
        'name': 'name',
        'protocol': 'protocol',
        'source_mac': 'sourceMac',
        'source_ip': 'sourceIp',
        'target_ip': 'targetIp',
        'icmp_code': 'icmpCode',
        'icmp_type': 'icmpType',
        'port_range_start': 'portRangeStart',
        'port_range_end': 'portRangeEnd',
        'type': 'type',
    }

    def __init__(self, name=None, protocol=None, source_mac=None, source_ip=None, target_ip=None, icmp_code=None, icmp_type=None, port_range_start=None, port_range_end=None, type=None, local_vars_configuration=None):  # noqa: E501
        """FirewallruleProperties - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._protocol = None
        self._source_mac = None
        self._source_ip = None
        self._target_ip = None
        self._icmp_code = None
        self._icmp_type = None
        self._port_range_start = None
        self._port_range_end = None
        self._type = None
        self.discriminator = None

        if name is not None:
            self.name = name
        self.protocol = protocol
        if source_mac is not None:
            self.source_mac = source_mac
        if source_ip is not None:
            self.source_ip = source_ip
        if target_ip is not None:
            self.target_ip = target_ip
        if icmp_code is not None:
            self.icmp_code = icmp_code
        if icmp_type is not None:
            self.icmp_type = icmp_type
        if port_range_start is not None:
            self.port_range_start = port_range_start
        if port_range_end is not None:
            self.port_range_end = port_range_end
        if type is not None:
            self.type = type

    @property
    def name(self):
        """Gets the name of this FirewallruleProperties.  # noqa: E501

        A name of that resource  # noqa: E501

        :return: The name of this FirewallruleProperties.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this FirewallruleProperties.

        A name of that resource  # noqa: E501

        :param name: The name of this FirewallruleProperties.  # noqa: E501
        :type name: str
        """

        self._name = name

    @property
    def protocol(self):
        """Gets the protocol of this FirewallruleProperties.  # noqa: E501

        The protocol for the rule. Property cannot be modified after creation (disallowed in update requests)  # noqa: E501

        :return: The protocol of this FirewallruleProperties.  # noqa: E501
        :rtype: str
        """
        return self._protocol

    @protocol.setter
    def protocol(self, protocol):
        """Sets the protocol of this FirewallruleProperties.

        The protocol for the rule. Property cannot be modified after creation (disallowed in update requests)  # noqa: E501

        :param protocol: The protocol of this FirewallruleProperties.  # noqa: E501
        :type protocol: str
        """
        if self.local_vars_configuration.client_side_validation and protocol is None:  # noqa: E501
            raise ValueError("Invalid value for `protocol`, must not be `None`")  # noqa: E501
        allowed_values = ["TCP", "UDP", "ICMP", "ANY"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and protocol not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `protocol` ({0}), must be one of {1}"  # noqa: E501
                .format(protocol, allowed_values)
            )

        self._protocol = protocol

    @property
    def source_mac(self):
        """Gets the source_mac of this FirewallruleProperties.  # noqa: E501

        Only traffic originating from the respective MAC address is allowed. Valid format: aa:bb:cc:dd:ee:ff. Value null allows all source MAC address  # noqa: E501

        :return: The source_mac of this FirewallruleProperties.  # noqa: E501
        :rtype: str
        """
        return self._source_mac

    @source_mac.setter
    def source_mac(self, source_mac):
        """Sets the source_mac of this FirewallruleProperties.

        Only traffic originating from the respective MAC address is allowed. Valid format: aa:bb:cc:dd:ee:ff. Value null allows all source MAC address  # noqa: E501

        :param source_mac: The source_mac of this FirewallruleProperties.  # noqa: E501
        :type source_mac: str
        """
        allowed_values = ["@Valid MAC address@", "null"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and source_mac not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `source_mac` ({0}), must be one of {1}"  # noqa: E501
                .format(source_mac, allowed_values)
            )

        self._source_mac = source_mac

    @property
    def source_ip(self):
        """Gets the source_ip of this FirewallruleProperties.  # noqa: E501

        Only traffic originating from the respective IPv4 address is allowed. Value null allows all source IPs  # noqa: E501

        :return: The source_ip of this FirewallruleProperties.  # noqa: E501
        :rtype: str
        """
        return self._source_ip

    @source_ip.setter
    def source_ip(self, source_ip):
        """Sets the source_ip of this FirewallruleProperties.

        Only traffic originating from the respective IPv4 address is allowed. Value null allows all source IPs  # noqa: E501

        :param source_ip: The source_ip of this FirewallruleProperties.  # noqa: E501
        :type source_ip: str
        """
        allowed_values = ["@Valid IP address@", "null"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and source_ip not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `source_ip` ({0}), must be one of {1}"  # noqa: E501
                .format(source_ip, allowed_values)
            )

        self._source_ip = source_ip

    @property
    def target_ip(self):
        """Gets the target_ip of this FirewallruleProperties.  # noqa: E501

        In case the target NIC has multiple IP addresses, only traffic directed to the respective IP address of the NIC is allowed. Value null allows all target IPs  # noqa: E501

        :return: The target_ip of this FirewallruleProperties.  # noqa: E501
        :rtype: str
        """
        return self._target_ip

    @target_ip.setter
    def target_ip(self, target_ip):
        """Sets the target_ip of this FirewallruleProperties.

        In case the target NIC has multiple IP addresses, only traffic directed to the respective IP address of the NIC is allowed. Value null allows all target IPs  # noqa: E501

        :param target_ip: The target_ip of this FirewallruleProperties.  # noqa: E501
        :type target_ip: str
        """
        allowed_values = ["@Valid IP address@", "null"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and target_ip not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `target_ip` ({0}), must be one of {1}"  # noqa: E501
                .format(target_ip, allowed_values)
            )

        self._target_ip = target_ip

    @property
    def icmp_code(self):
        """Gets the icmp_code of this FirewallruleProperties.  # noqa: E501

        Defines the allowed code (from 0 to 254) if protocol ICMP is chosen. Value null allows all codes  # noqa: E501

        :return: The icmp_code of this FirewallruleProperties.  # noqa: E501
        :rtype: int
        """
        return self._icmp_code

    @icmp_code.setter
    def icmp_code(self, icmp_code):
        """Sets the icmp_code of this FirewallruleProperties.

        Defines the allowed code (from 0 to 254) if protocol ICMP is chosen. Value null allows all codes  # noqa: E501

        :param icmp_code: The icmp_code of this FirewallruleProperties.  # noqa: E501
        :type icmp_code: int
        """
        if (self.local_vars_configuration.client_side_validation and
                icmp_code is not None and icmp_code > 254):  # noqa: E501
            raise ValueError("Invalid value for `icmp_code`, must be a value less than or equal to `254`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                icmp_code is not None and icmp_code < 0):  # noqa: E501
            raise ValueError("Invalid value for `icmp_code`, must be a value greater than or equal to `0`")  # noqa: E501

        self._icmp_code = icmp_code

    @property
    def icmp_type(self):
        """Gets the icmp_type of this FirewallruleProperties.  # noqa: E501

        Defines the allowed type (from 0 to 254) if the protocol ICMP is chosen. Value null allows all types  # noqa: E501

        :return: The icmp_type of this FirewallruleProperties.  # noqa: E501
        :rtype: int
        """
        return self._icmp_type

    @icmp_type.setter
    def icmp_type(self, icmp_type):
        """Sets the icmp_type of this FirewallruleProperties.

        Defines the allowed type (from 0 to 254) if the protocol ICMP is chosen. Value null allows all types  # noqa: E501

        :param icmp_type: The icmp_type of this FirewallruleProperties.  # noqa: E501
        :type icmp_type: int
        """
        if (self.local_vars_configuration.client_side_validation and
                icmp_type is not None and icmp_type > 254):  # noqa: E501
            raise ValueError("Invalid value for `icmp_type`, must be a value less than or equal to `254`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                icmp_type is not None and icmp_type < 0):  # noqa: E501
            raise ValueError("Invalid value for `icmp_type`, must be a value greater than or equal to `0`")  # noqa: E501

        self._icmp_type = icmp_type

    @property
    def port_range_start(self):
        """Gets the port_range_start of this FirewallruleProperties.  # noqa: E501

        Defines the start range of the allowed port (from 1 to 65534) if protocol TCP or UDP is chosen. Leave portRangeStart and portRangeEnd value null to allow all ports  # noqa: E501

        :return: The port_range_start of this FirewallruleProperties.  # noqa: E501
        :rtype: int
        """
        return self._port_range_start

    @port_range_start.setter
    def port_range_start(self, port_range_start):
        """Sets the port_range_start of this FirewallruleProperties.

        Defines the start range of the allowed port (from 1 to 65534) if protocol TCP or UDP is chosen. Leave portRangeStart and portRangeEnd value null to allow all ports  # noqa: E501

        :param port_range_start: The port_range_start of this FirewallruleProperties.  # noqa: E501
        :type port_range_start: int
        """
        if (self.local_vars_configuration.client_side_validation and
                port_range_start is not None and port_range_start > 65534):  # noqa: E501
            raise ValueError("Invalid value for `port_range_start`, must be a value less than or equal to `65534`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                port_range_start is not None and port_range_start < 1):  # noqa: E501
            raise ValueError("Invalid value for `port_range_start`, must be a value greater than or equal to `1`")  # noqa: E501

        self._port_range_start = port_range_start

    @property
    def port_range_end(self):
        """Gets the port_range_end of this FirewallruleProperties.  # noqa: E501

        Defines the end range of the allowed port (from 1 to 65534) if the protocol TCP or UDP is chosen. Leave portRangeStart and portRangeEnd null to allow all ports  # noqa: E501

        :return: The port_range_end of this FirewallruleProperties.  # noqa: E501
        :rtype: int
        """
        return self._port_range_end

    @port_range_end.setter
    def port_range_end(self, port_range_end):
        """Sets the port_range_end of this FirewallruleProperties.

        Defines the end range of the allowed port (from 1 to 65534) if the protocol TCP or UDP is chosen. Leave portRangeStart and portRangeEnd null to allow all ports  # noqa: E501

        :param port_range_end: The port_range_end of this FirewallruleProperties.  # noqa: E501
        :type port_range_end: int
        """
        if (self.local_vars_configuration.client_side_validation and
                port_range_end is not None and port_range_end > 65534):  # noqa: E501
            raise ValueError("Invalid value for `port_range_end`, must be a value less than or equal to `65534`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                port_range_end is not None and port_range_end < 1):  # noqa: E501
            raise ValueError("Invalid value for `port_range_end`, must be a value greater than or equal to `1`")  # noqa: E501

        self._port_range_end = port_range_end

    @property
    def type(self):
        """Gets the type of this FirewallruleProperties.  # noqa: E501

        The type of firewall rule. If is not specified, it will take the default value INGRESS  # noqa: E501

        :return: The type of this FirewallruleProperties.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this FirewallruleProperties.

        The type of firewall rule. If is not specified, it will take the default value INGRESS  # noqa: E501

        :param type: The type of this FirewallruleProperties.  # noqa: E501
        :type type: str
        """
        allowed_values = ["INGRESS", "EGRESS"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"  # noqa: E501
                .format(type, allowed_values)
            )

        self._type = type

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, FirewallruleProperties):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, FirewallruleProperties):
            return True

        return self.to_dict() != other.to_dict()
