# coding: utf-8

"""
    CLOUD API

    An enterprise-grade Infrastructure is provided as a Service (IaaS) solution that can be managed through a browser-based \"Data Center Designer\" (DCD) tool or via an easy to use API.   The API allows you to perform a variety of management tasks such as spinning up additional servers, adding volumes, adjusting networking, and so forth. It is designed to allow users to leverage the same power and flexibility found within the DCD visual tool. Both tools are consistent with their concepts and lend well to making the experience smooth and intuitive.  # noqa: E501

    The version of the OpenAPI document: 6.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ionoscloud.configuration import Configuration


class BackupUnitProperties(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'name': 'str',
        'password': 'str',
        'email': 'str',
    }

    attribute_map = {
        'name': 'name',
        'password': 'password',
        'email': 'email',
    }

    def __init__(self, name=None, password=None, email=None, local_vars_configuration=None):  # noqa: E501
        """BackupUnitProperties - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._password = None
        self._email = None
        self.discriminator = None

        self.name = name
        if password is not None:
            self.password = password
        if email is not None:
            self.email = email

    @property
    def name(self):
        """Gets the name of this BackupUnitProperties.  # noqa: E501

        A name of that resource (only alphanumeric characters are acceptable)  # noqa: E501

        :return: The name of this BackupUnitProperties.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this BackupUnitProperties.

        A name of that resource (only alphanumeric characters are acceptable)  # noqa: E501

        :param name: The name of this BackupUnitProperties.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def password(self):
        """Gets the password of this BackupUnitProperties.  # noqa: E501

        the password associated to that resource  # noqa: E501

        :return: The password of this BackupUnitProperties.  # noqa: E501
        :rtype: str
        """
        return self._password

    @password.setter
    def password(self, password):
        """Sets the password of this BackupUnitProperties.

        the password associated to that resource  # noqa: E501

        :param password: The password of this BackupUnitProperties.  # noqa: E501
        :type password: str
        """

        self._password = password

    @property
    def email(self):
        """Gets the email of this BackupUnitProperties.  # noqa: E501

        The email associated with the backup unit. Bear in mind that this email does not be the same email as of the user.  # noqa: E501

        :return: The email of this BackupUnitProperties.  # noqa: E501
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this BackupUnitProperties.

        The email associated with the backup unit. Bear in mind that this email does not be the same email as of the user.  # noqa: E501

        :param email: The email of this BackupUnitProperties.  # noqa: E501
        :type email: str
        """

        self._email = email

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BackupUnitProperties):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, BackupUnitProperties):
            return True

        return self.to_dict() != other.to_dict()
