import socket
import urllib.request
import ipaddress

def get_local_ip():
    s = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
    try:
        # doesn't even have to be reachable
        s.connect(('10.255.255.255', 1))
        IP = s.getsockname()[0]
    except Exception:
        IP = '127.0.0.1'
    finally:
        s.close()
    return IP

def get_external_ip():
    return urllib.request.urlopen('https://ident.me').read().decode('utf8')

def check_type_ip(ip_str):
    ip = ipaddress.ip_address(ip_str)
    return ip.version