"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DatabaseSecret = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const crypto = require("crypto");
const secretsmanager = require("@aws-cdk/aws-secretsmanager");
const core_1 = require("@aws-cdk/core");
const util_1 = require("./private/util");
/**
 * A database secret.
 *
 * @stability stable
 * @resource AWS::SecretsManager::Secret
 */
class DatabaseSecret extends secretsmanager.Secret {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b, _c;
        const excludeCharacters = (_b = props.excludeCharacters) !== null && _b !== void 0 ? _b : util_1.DEFAULT_PASSWORD_EXCLUDE_CHARS;
        super(scope, id, {
            encryptionKey: props.encryptionKey,
            description: `Generated by the CDK for stack: ${core_1.Aws.STACK_NAME}`,
            generateSecretString: {
                passwordLength: 30,
                secretStringTemplate: JSON.stringify({
                    username: props.username,
                    masterarn: (_c = props.masterSecret) === null || _c === void 0 ? void 0 : _c.secretArn,
                }),
                generateStringKey: 'password',
                excludeCharacters,
            },
        });
        if (props.replaceOnPasswordCriteriaChanges) {
            const hash = crypto.createHash('md5');
            hash.update(JSON.stringify({
                // Use here the options that influence the password generation.
                // If at some point we add other password customization options
                // they sould be added here below (e.g. `passwordLength`).
                excludeCharacters,
            }));
            const logicalId = `${core_1.Names.uniqueId(this)}${hash.digest('hex')}`;
            const secret = this.node.defaultChild;
            secret.overrideLogicalId(logicalId.slice(-255)); // Take last 255 chars
        }
    }
}
exports.DatabaseSecret = DatabaseSecret;
_a = JSII_RTTI_SYMBOL_1;
DatabaseSecret[_a] = { fqn: "@aws-cdk/aws-rds.DatabaseSecret", version: "1.94.1" };
//# sourceMappingURL=data:application/json;base64,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