# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['flake8_annotations']

package_data = \
{'': ['*']}

install_requires = \
['flake8>=3.7,<3.9']

extras_require = \
{':python_version < "3.8"': ['typed-ast>=1.4,<2.0']}

entry_points = \
{'flake8.extension': ['ANN = flake8_annotations.checker:TypeHintChecker']}

setup_kwargs = {
    'name': 'flake8-annotations',
    'version': '2.5.0',
    'description': 'Flake8 Type Annotation Checks',
    'long_description': "# flake8-annotations\n[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/flake8-annotations)](https://pypi.org/project/flake8-annotations/)\n[![PyPI](https://img.shields.io/pypi/v/flake8-annotations)](https://pypi.org/project/flake8-annotations/)\n\n`flake8-annotations` is a plugin for [Flake8](http://flake8.pycqa.org/en/latest/) that detects the absence of [PEP 3107-style](https://www.python.org/dev/peps/pep-3107/) function annotations and [PEP 484-style](https://www.python.org/dev/peps/pep-0484/#type-comments) type comments  (see: [Caveats](#Caveats-for-PEP-484-style-Type-Comments)).\n\nWhat this won't do: Check variable annotations (see: [PEP 526](https://www.python.org/dev/peps/pep-0526/)), respect stub files, or replace [mypy](http://mypy-lang.org/).\n\n## Installation\nInstall from PyPi with your favorite `pip` invocation:\n\n```bash\n$ pip install flake8-annotations\n```\n\nIt will then be run automatically as part of flake8.\n\nYou can verify it's being picked up by invoking the following in your shell:\n\n```bash\n$ flake8 --version\n3.8.4 (flake8-annotations: 2.5.0, mccabe: 0.6.1, pycodestyle: 2.6.0, pyflakes: 2.2.0) CPython 3.9.0 on Darwin\n```\n\n## Table of Warnings\nAll warnings are enabled by default.\n\n### Function Annotations\n| ID       | Description                                   |\n|----------|-----------------------------------------------|\n| `ANN001` | Missing type annotation for function argument |\n| `ANN002` | Missing type annotation for `*args`           |\n| `ANN003` | Missing type annotation for `**kwargs`        |\n\n### Method Annotations\n| ID       | Description                                                  |\n|----------|--------------------------------------------------------------|\n| `ANN101` | Missing type annotation for `self` in method<sup>1</sup>     |\n| `ANN102` | Missing type annotation for `cls` in classmethod<sup>1</sup> |\n\n### Return Annotations\n| ID       | Description                                           |\n|----------|-------------------------------------------------------|\n| `ANN201` | Missing return type annotation for public function    |\n| `ANN202` | Missing return type annotation for protected function |\n| `ANN203` | Missing return type annotation for secret function    |\n| `ANN204` | Missing return type annotation for special method     |\n| `ANN205` | Missing return type annotation for staticmethod       |\n| `ANN206` | Missing return type annotation for classmethod        |\n\n### Type Comments\n| ID       | Description                                               |\n|----------|-----------------------------------------------------------|\n| `ANN301` | PEP 484 disallows both type annotations and type comments |\n\n**Notes:**\n1. See: [PEP 484](https://www.python.org/dev/peps/pep-0484/#annotating-instance-and-class-methods) and [PEP 563](https://www.python.org/dev/peps/pep-0563/) for suggestions on annotating `self` and `cls` arguments.\n\n## Configuration Options\nSome opinionated flags are provided to tailor the linting errors emitted.\n\n### `--suppress-none-returning`: `bool`\nSuppress `ANN200`-level errors for functions that meet one of the following criteria:\n  * Contain no `return` statement, or\n  * Explicit `return` statement(s) all return `None` (explicitly or implicitly).\n\nDefault: `False`\n\n### `--suppress-dummy-args`: `bool`\nSuppress `ANN000`-level errors for dummy arguments, defined as `_`.\n\nDefault: `False`\n\n### `--allow-untyped-defs`: `bool`\nSuppress all errors for dynamically typed functions. A function is considered dynamically typed if it does not contain any type hints.\n\nDefault: `False`\n\n### `--allow-untyped-nested`: `bool`\nSuppress all errors for dynamically typed nested functions. A function is considered dynamically typed if it does not contain any type hints.\n\nDefault: `False`\n\n### `--mypy-init-return`: `bool`\nAllow omission of a return type hint for `__init__` if at least one argument is annotated. See [mypy's documentation](https://mypy.readthedocs.io/en/stable/class_basics.html?#annotating-init-methods) for additional details.\n\nDefault: `False`\n\n## The `typing.overload` Decorator\nPer the [`typing`](https://docs.python.org/3/library/typing.html#typing.overload) documentation:\n\n> The `@overload` decorator allows describing functions and methods that support multiple different combinations of argument types. A series of `@overload`-decorated definitions must be followed by exactly one non-`@overload`-decorated definition (for the same function/method).\n\nIn the spirit of the purpose of this decorator, errors for missing annotations for non-`@overload`-decorated functions are ignored if they meet this criteria.\n\nFor example, this code:\n\n```py\nimport typing\n\n\n@typing.overload\ndef foo(a: int) -> int:\n    ...\n\ndef foo(a):\n    ...\n```\n\nWill not raise linting errors for missing annotations for the arguments & return of the non-decorated `foo` definition.\n\n**NOTE:** If importing directly, the `typing.overload` decorator will not be recognized if it is imported with an alias (e.g. `from typing import overload as please_dont_do_this`). Aliasing of the `typing` module is supported (e.g. `import typing as t; @t.overload`).\n\n## Caveats for PEP 484-style Type Comments\n\n### Mixing argument-level and function-level type comments\nSupport is provided for mixing argument-level and function-level type comments.\n\n```py\ndef foo(\n    arg1,  # type: bool\n    arg2,  # type: bool\n):  # type: (...) -> bool\n    pass\n```\n\n**Note:** If present, function-level type comments will override any argument-level type comments.\n\n### Partial type comments\nPartially type hinted functions are supported for non-static class methods.\n\nFor example:\n\n```py\nclass Foo:\n    def __init__(self):\n        # type: () -> None\n        ...\n\n    def bar(self, a):\n        # type: (int) -> int\n        ...\n```\nWill consider `bar`'s `self` argument as unannotated and use the `int` type hint for `a`.\n\nPartial type comments utilizing ellipses as placeholders is also supported:\n\n```py\ndef foo(arg1, arg2):\n    # type: (bool) -> bool\n    pass\n```\nWill show `arg2` as missing a type hint.\n\n```py\ndef foo(arg1, arg2):\n    # type: (..., bool) -> bool\n    pass\n```\nWill show `arg1` as missing a type hint.\n\n**Deprecation notice**: Explicit support for utilization of ellipses as placeholders will be removed in version `3.0`. See [this issue](https://github.com/sco1/flake8-annotations/issues/95) for more information.\n\n## Contributing\n\n### Development Environment\nThis project uses [Poetry](https://python-poetry.org/) to manage dependencies. With your fork cloned to your local machine, you can install the project and its dependencies to create a development environment using:\n\n```bash\n$ poetry install\n```\n\nNote: An editable installation of `flake8-annotations` in the developer environment is required in order for the plugin to be registered for Flake8. By default, Poetry includes an editable install of the project itself when `poetry install` is invoked.\n\nA [pre-commit](https://pre-commit.com) configuration is also provided to create a pre-commit hook so linting errors aren't committed:\n\n```bash\n$ pre-commit install\n```\n\n### Testing & Coverage\nA [pytest](https://docs.pytest.org/en/latest/) suite is provided, with coverage reporting from [pytest-cov](https://github.com/pytest-dev/pytest-cov). A [tox](https://github.com/tox-dev/tox/) configuration is provided to test across all supported versions of Python. Testing will be skipped for Python versions that cannot be found.\n\n```bash\n$ tox\n```\n\nDetails on missing coverage, including in the test suite, is provided in the report to allow the user to generate additional tests for full coverage.\n",
    'author': 'S Co1',
    'author_email': 'sco1.git@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/sco1/flake8-annotations',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.6.1,<4.0.0',
}


setup(**setup_kwargs)
