import numpy as np
from ml4h.TensorMap import TensorMap, Interpretation
from ml4h.normalizer import Standardize

continuous_164_completeness_80 = TensorMap(
    'continuous_164_completeness_80',
    Interpretation.CONTINUOUS, shape=(164,), loss='logcosh', path_prefix='continuous', metrics=[],
    normalization=Standardize(
        mean=np.array(
            [
                1951.7776, 56.2884, 1.692, 3.4093, 5.2619, 17.2463, -1.3055, 2.3056, 1.8614, 1.3389, 3.1002, 0.0501,
                1.8858,
                1.5841, 2.4567, -2.377, 4.1507, 2.4473, 1.7519, 1.8337, 0.0838, 2.4623, 103.5745, 90.5281, 168.6796,
                31.9094,
                78.4859, 29.8452, 27.5191, 558.1594, 301.7575, 119.6093, 4.1194, 0.5543, 5.8235, 2.9178, 3.0, 2.0, 4.0,
                3.0,
                -1.1599, 0.2036, 3.1097, -0.0705, 0.8829, 12.0117, 1.0792, 1.1556, 137.1578, 89.2245, 4.2419, 31.8277,
                8.5426,
                9.0297, 4.308, 31.8998, 330.6027, 324.3219, 246.8452, 245.7107, 597.4324, 6654.3484, 27.4988, 39.1852,
                53.5447,
                31.3617, 78.4241, 8.9198, 30.3947, 2.7295, 2.914, 1.2511, 29.5279, 8.4419, 31.1418, 2.7594, 2.9464,
                24.9224,
                13.7932, 1.3295, 597.1168, 28.5235, 29.7468, 526.783, 577.5376, 528.137, 9006.8912, 2643.1121, 2272.909,
                77.9839, 63.1097, 835.7309, 3210.3311, 468.8091, 1395.0797, 3185.5297, 833.6706, 829.1609, 54.0376,
                16.4868,
                9.2995, 0.2315, 252.6155, 13.4993, 34.4711, 31.4535, 91.2451, 41.1669, 14.1867, 4.5197, 6.9049, 0.5567,
                2.6196,
                61.0242, 7.029, 28.7688, 0.0042, 0.0331, 0.1792, 4.2595, 0.4754, 1.9537, 0.0351, 309.7881, 1.7553,
                5.4224,
                5.7005, 139.4391, 82.24, 21.3485, 2.6707, 69.6116, 1.0355, 9.1345, 0.0184, 0.407, 0.2914, 82.9397,
                106.0502,
                0.0625, 1.3841, 0.3475, 0.4683, 135.5279, 82.1382, 68.973, 391.7, 2.8232, 3.7222, 371.9605, 2.7452,
                3.6186,
                403195.4756, 354856.32, 49.3923, 30.6302, 2.38, 1.4456, 72.6764, 5.1458, 1.1608, 1.5382, 6.6499,
                61.7466,
            ],
        ),
        std=np.array(
            [
                8.1087, 8.077, 2.1066, 2.5482, 2.1467, 12.3899, 3.0925, 3.0109, 3.9892, 3.7321,
                3.5182, 3.3574, 2.6427, 3.2843, 2.7197, 5.3386, 3.8747, 2.7351, 1.6003, 1.8946,
                0.2949, 1.5131, 9.3581, 13.5615, 9.3108, 11.2478, 15.8735, 11.3271, 4.8147, 117.1678,
                173.1958, 121.9444, 3.2782, 1.3032, 1.0024, 0.4824, 0.001, 0.001, 0.001, 0.001,
                4.7395, 4.6709, 3.6179, 4.4538, 2.8219, 8.8037, 1.2514, 1.3384, 7.1577, 4.9111,
                1.8534, 10.6086, 1.9142, 2.0096, 1.8848, 10.6585, 55.5267, 54.8685, 34.6291, 34.3594,
                86.8084, 1359.3275, 4.7697, 8.3766, 11.4568, 8.5926, 15.812, 1.9998, 10.3286, 0.7788,
                0.8174, 0.6494, 10.2445, 1.9052, 8.0512, 0.7945, 0.8328, 9.5929, 5.2078, 0.712,
                157.7349, 5.7889, 5.9656, 128.0124, 141.194, 144.1898, 5868.4405, 551.4911, 577.6671,
                44.8952, 34.2114, 106.0323, 487.9158, 420.1071, 77.9439, 518.4521, 111.2771,
                121.6212, 76.694, 0.512, 1.0836, 0.0488, 58.9639, 0.9929, 1.0059, 1.8539, 4.6858,
                3.5557, 1.2431, 0.4132, 1.8464, 0.4674, 1.8109, 8.4511, 2.2699, 7.5849, 0.1088,
                0.0428, 0.1384, 1.45, 0.1766, 0.7098, 0.3739, 78.3406, 0.9845, 1.4512, 1.1607,
                19.1216, 10.4818, 5.5738, 4.3769, 11.8632, 0.2406, 4.4921, 0.0138, 0.2893, 0.0627,
                5.3663, 7.9964, 0.0674, 1.5293, 1.9732, 4.6832, 17.9559, 9.814, 11.3225, 137.435,
                0.812, 1.0301, 140.9553, 0.8177, 1.0396, 93446.122, 167941.3646, 21.5753, 17.5446,
                0.094, 0.3929, 4.1237, 1.2776, 0.1573, 0.2831, 6.0493, 79.2416,
            ],
        ),
    ),
    channel_map={
        '34_Year-of-birth_0_0': 0, '21003_Age-when-attended-assessment-centre_0_0': 1,
        '904_Number-of-daysweek-of-vigorous-physical-activity-10-minutes_0_0': 2,
        '884_Number-of-daysweek-of-moderate-physical-activity-10-minutes_0_0': 3,
        '864_Number-of-daysweek-walked-10-minutes_0_0': 4, '699_Length-of-time-at-current-address_0_0': 5,
        '189_Townsend-deprivation-index-at-recruitment_0_0': 6, '1070_Time-spent-watching-television-TV_0_0': 7,
        '1528_Water-intake_0_0': 8, '1498_Coffee-intake_0_0': 9, '1488_Tea-intake_0_0': 10,
        '1319_Dried-fruit-intake_0_0': 11, '1309_Fresh-fruit-intake_0_0': 12, '1299_Salad-raw-vegetable-intake_0_0': 13,
        '1289_Cooked-vegetable-intake_0_0': 14, '1090_Time-spent-driving_0_0': 15, '1458_Cereal-intake_0_0': 16,
        '137_Number-of-treatmentsmedications-taken_0_0': 17, '136_Number-of-operations-selfreported_0_0': 18,
        '135_Number-of-selfreported-noncancer-illnesses_0_0': 19, '134_Number-of-selfreported-cancers_0_0': 20,
        '709_Number-in-household_0_0': 21, '49_Hip-circumference_0_0': 22, '48_Waist-circumference_0_0': 23,
        '50_Standing-height_0_0': 24, '47_Hand-grip-strength-right_0_0': 25, '21002_Weight_0_0': 26,
        '46_Hand-grip-strength-left_0_0': 27, '21001_Body-mass-index-BMI_0_0': 28,
        '20023_Mean-time-to-correctly-identify-matches_0_0': 29, '400_Time-to-complete-round_0_2': 30,
        '400_Time-to-complete-round_0_1': 31, '399_Number-of-incorrect-matches-in-round_0_2': 32,
        '399_Number-of-incorrect-matches-in-round_0_1': 33, '398_Number-of-correct-matches-in-round_0_2': 34,
        '398_Number-of-correct-matches-in-round_0_1': 35, '397_Number-of-rows-displayed-in-round_0_2': 36,
        '397_Number-of-rows-displayed-in-round_0_1': 37, '396_Number-of-columns-displayed-in-round_0_2': 38,
        '396_Number-of-columns-displayed-in-round_0_1': 39, '1080_Time-spent-using-computer_0_0': 40,
        '1060_Time-spent-outdoors-in-winter_0_0': 41, '1050_Time-spend-outdoors-in-summer_0_0': 42,
        '2277_Frequency-of-solariumsunlamp-use_0_0': 43, '1737_Childhood-sunburn-occasions_0_0': 44,
        '1438_Bread-intake_0_0': 45, '1883_Number-of-full-sisters_0_0': 46, '1873_Number-of-full-brothers_0_0': 47,
        '51_Seated-height_0_0': 48, '20015_Sitting-height_0_0': 49, '23116_Leg-fat-mass-left_0_0': 50,
        '23115_Leg-fat-percentage-left_0_0': 51, '23114_Leg-predicted-mass-right_0_0': 52,
        '23113_Leg-fatfree-mass-right_0_0': 53, '23112_Leg-fat-mass-right_0_0': 54,
        '23111_Leg-fat-percentage-right_0_0': 55, '23110_Impedance-of-arm-left_0_0': 56,
        '23109_Impedance-of-arm-right_0_0': 57, '23108_Impedance-of-leg-left_0_0': 58,
        '23107_Impedance-of-leg-right_0_0': 59, '23106_Impedance-of-whole-body_0_0': 60,
        '23105_Basal-metabolic-rate_0_0': 61, '23104_Body-mass-index-BMI_0_0': 62,
        '23102_Whole-body-water-mass_0_0': 63, '23101_Whole-body-fatfree-mass_0_0': 64,
        '23099_Body-fat-percentage_0_0': 65, '23098_Weight_0_0': 66, '23117_Leg-fatfree-mass-left_0_0': 67,
        '23123_Arm-fat-percentage-left_0_0': 68, '23122_Arm-predicted-mass-right_0_0': 69,
        '23121_Arm-fatfree-mass-right_0_0': 70, '23120_Arm-fat-mass-right_0_0': 71,
        '23119_Arm-fat-percentage-right_0_0': 72, '23118_Leg-predicted-mass-left_0_0': 73,
        '23127_Trunk-fat-percentage_0_0': 74, '23126_Arm-predicted-mass-left_0_0': 75,
        '23125_Arm-fatfree-mass-left_0_0': 76, '23100_Whole-body-fat-mass_0_0': 77, '23128_Trunk-fat-mass_0_0': 78,
        '23124_Arm-fat-mass-left_0_0': 79, '404_Duration-to-first-press-of-snapbutton-in-each-round_0_7': 80,
        '23130_Trunk-predicted-mass_0_0': 81, '23129_Trunk-fatfree-mass_0_0': 82,
        '404_Duration-to-first-press-of-snapbutton-in-each-round_0_5': 83,
        '404_Duration-to-first-press-of-snapbutton-in-each-round_0_11': 84,
        '404_Duration-to-first-press-of-snapbutton-in-each-round_0_10': 85,
        '30510_Creatinine-enzymatic-in-urine_0_0': 86, '30374_Volume-of-LiHep-plasma-held-by-UKB_0_0': 87,
        '30384_Volume-of-serum-held-by-UKB_0_0': 88, '30530_Sodium-in-urine_0_0': 89,
        '30520_Potassium-in-urine_0_0': 90, '30324_Volume-of-EDTA1-red-cells-held-by-UKB_0_0': 91,
        '30314_Volume-of-EDTA1-plasma-held-by-UKB_0_0': 92, '30334_Volume-of-EDTA1-buffy-held-by-UKB_0_0': 93,
        '30404_Volume-of-ACD-held-by-UKB_0_0': 94, '30344_Volume-of-EDTA2-plasma-held-by-UKB_0_0': 95,
        '30364_Volume-of-EDTA2-red-cells-held-by-UKB_0_0': 96, '30354_Volume-of-EDTA2-buffy-held-by-UKB_0_0': 97,
        '874_Duration-of-walks_0_0': 98, '30110_Platelet-distribution-width_0_0': 99,
        '30100_Mean-platelet-thrombocyte-volume_0_0': 100, '30090_Platelet-crit_0_0': 101,
        '30080_Platelet-count_0_0': 102, '30070_Red-blood-cell-erythrocyte-distribution-width_0_0': 103,
        '30060_Mean-corpuscular-haemoglobin-concentration_0_0': 104, '30050_Mean-corpuscular-haemoglobin_0_0': 105,
        '30040_Mean-corpuscular-volume_0_0': 106, '30030_Haematocrit-percentage_0_0': 107,
        '30020_Haemoglobin-concentration_0_0': 108, '30010_Red-blood-cell-erythrocyte-count_0_0': 109,
        '30000_White-blood-cell-leukocyte-count_0_0': 110, '30220_Basophill-percentage_0_0': 111,
        '30210_Eosinophill-percentage_0_0': 112, '30200_Neutrophill-percentage_0_0': 113,
        '30190_Monocyte-percentage_0_0': 114, '30180_Lymphocyte-percentage_0_0': 115,
        '30170_Nucleated-red-blood-cell-count_0_0': 116, '30160_Basophill-count_0_0': 117,
        '30150_Eosinophill-count_0_0': 118, '30140_Neutrophill-count_0_0': 119, '30130_Monocyte-count_0_0': 120,
        '30120_Lymphocyte-count_0_0': 121, '30230_Nucleated-red-blood-cell-percentage_0_0': 122, '30880_Urate_0_0': 123,
        '30870_Triglycerides_0_0': 124, '30670_Urea_0_0': 125, '30690_Cholesterol_0_0': 126,
        '4080_Systolic-blood-pressure-automated-reading_0_0': 127,
        '4079_Diastolic-blood-pressure-automated-reading_0_0': 128, '30770_IGF1_0_0': 129,
        '30710_Creactive-protein_0_0': 130, '102_Pulse-rate-automated-reading_0_0': 131,
        '30640_Apolipoprotein-B_0_0': 132, '30840_Total-bilirubin_0_0': 133,
        '30300_High-light-scatter-reticulocyte-count_0_0': 134,
        '30290_High-light-scatter-reticulocyte-percentage_0_0': 135, '30280_Immature-reticulocyte-fraction_0_0': 136,
        '30270_Mean-sphered-cell-volume_0_0': 137, '30260_Mean-reticulocyte-volume_0_0': 138,
        '30250_Reticulocyte-count_0_0': 139, '30240_Reticulocyte-percentage_0_0': 140,
        '1279_Exposure-to-tobacco-smoke-outside-home_0_0': 141, '1269_Exposure-to-tobacco-smoke-at-home_0_0': 142,
        '4080_Systolic-blood-pressure-automated-reading_0_1': 143,
        '4079_Diastolic-blood-pressure-automated-reading_0_1': 144, '102_Pulse-rate-automated-reading_0_1': 145,
        '3064_Peak-expiratory-flow-PEF_0_0': 146, '3063_Forced-expiratory-volume-in-1second-FEV1_0_0': 147,
        '3062_Forced-vital-capacity-FVC_0_0': 148, '3064_Peak-expiratory-flow-PEF_0_1': 149,
        '3063_Forced-expiratory-volume-in-1second-FEV1_0_1': 150, '3062_Forced-vital-capacity-FVC_0_1': 151,
        '130_Place-of-birth-in-UK-east-coordinate_0_0': 152, '129_Place-of-birth-in-UK-north-coordinate_0_0': 153,
        '30890_Vitamin-D_0_0': 154, '2217_Age-started-wearing-glasses-or-contact-lenses_0_0': 155,
        '30680_Calcium_0_0': 156, '30760_HDL-cholesterol_0_0': 157, '30860_Total-protein_0_0': 158,
        '30740_Glucose_0_0': 159, '30810_Phosphate_0_0': 160, '30630_Apolipoprotein-A_0_0': 161,
        '30850_Testosterone_0_0': 162, '894_Duration-of-moderate-activity_0_0': 163,
    },
)

continuous_1519_completeness_7 = TensorMap(
    'continuous_1519_completeness_7', Interpretation.CONTINUOUS,
    shape=(1519,), loss='logcosh', path_prefix='continuous', metrics=[],
    normalization=Standardize(
        mean=np.array(
            [
                1951.7776, 56.2884, 1.692, 3.4093, 5.2619, 17.2463, -1.3055, 2.3056, 1.8614, 1.3389, 3.1002, 0.0501,
                1.8858, 1.5841, 2.4567, -2.377, 4.1507, 2.4473, 1.7519, 1.8337, 0.0838, 2.4623, 103.5745, 90.5281,
                168.6796, 31.9094, 78.4859, 29.8452, 27.5191, 558.1594, 301.7575, 119.6093, 4.1194, 0.5543, 5.8235, 2.9178,
                3.0, 2.0, 4.0, 3.0, -1.1599, 0.2036, 3.1097, -0.0705, 0.8829, 12.0117, 1.0792, 1.1556, 137.1578, 89.2245,
                4.2419, 31.8277, 8.5426, 9.0297, 4.308, 31.8998, 330.6027, 324.3219, 246.8452, 245.7107, 597.4324,
                6654.3484, 27.4988, 39.1852, 53.5447, 31.3617, 78.4241, 8.9198, 30.3947, 2.7295, 2.914, 1.2511, 29.5279,
                8.4419, 31.1418, 2.7594, 2.9464, 24.9224, 13.7932, 1.3295, 597.1168, 28.5235, 29.7468, 526.783, 577.5376,
                528.137, 9006.8912, 2643.1121, 2272.909, 77.9839, 63.1097, 835.7309, 3210.3311, 468.8091, 1395.0797,
                3185.5297, 833.6706, 829.1609, 54.0376, 16.4868, 9.2995, 0.2315, 252.6155, 13.4993, 34.4711, 31.4535,
                91.2451, 41.1669, 14.1867, 4.5197, 6.9049, 0.5567, 2.6196, 61.0242, 7.029, 28.7688, 0.0042, 0.0331, 0.1792,
                4.2595, 0.4754, 1.9537, 0.0351, 309.7881, 1.7553, 5.4224, 5.7005, 139.4391, 82.24, 21.3485, 2.6707,
                69.6116, 1.0355, 9.1345, 0.0184, 0.407, 0.2914, 82.9397, 106.0502, 0.0625, 1.3841, 0.3475, 0.4683,
                135.5279, 82.1382, 68.973, 391.7, 2.8232, 3.7222, 371.9605, 2.7452, 3.6186, 403195.4756, 354856.32,
                49.3923, 30.6302, 2.38, 1.4456, 72.6764, 5.1458, 1.1608, 1.5382, 6.6499, 61.7466, 1.8325, 1179.8889,
                33.8008, 67.7256, 45.6443, 721.1949, 42.3674, 2.8691, 0.2464, 1.8242, 3.0368, 2.6847, 4.0109, 328.8316,
                2.6152, 3.4481, 16.3164, 71.5367, 42.7844, 0.542, 97.7881, 1553.3255, 77.8652, 44.0054, 3.3211, 1.7993,
                12.4784, 2.114, 1249.4229, 35.7321, 1076.6364, 41.2282, 1.7561, 20.5588, 27.4669, 6.8007, -1.125, 548.8973,
                77.2771, 567.0924, 710.0862, 542.6599, 605.6402, 30.2784, 25.2394, 1.4374, 140.1349, 457.1519, 21.0073,
                43.663, 22.2088, 67.5433, 69.2503, 202.3684, 46.3943, 9.259, 1705.0938, 14.7346, 1742.1283, 14.8593,
                7.7406, 5.9148, -0.304, 98.5714, 1555.1203, 77.981, 44.0543, -6.6293, 0.5477, -6.6386, -0.1901, 0.5597,
                100.5905, 1557.9269, 80.0984, 44.0023, 30.7607, -0.2517, 2.8913, 1.1004, 0.5563, 23.8361, 1264.8432,
                42.2276, 1391.4977, 35.6699, 45.0141, 6.4854, 76.4024, 19.9024, 21.3159, 1952.2414, 1831.5907, 1971.7945,
                89.4343, 19.8772, 4.0, 2.7396, 4.9861, 0.0311, 0.1311, 4.3819, 4.9688, 4.0, 2.8557, 4.9757, 0.0391, 0.1391,
                4.4504, 4.9652, 211.2932, 135.0349, 0.0285, 0.0217, 0.0247, 0.9929, 12.0, 93.0053, 0.9283, -0.8702,
                96.7554, 0.9174, -0.8477, 96.5975, 0.9208, -0.8429, 1.4508, 3.3614, 2760.2151, 1.0342, 12.0, 92.0971,
                0.8741, -0.8529, 91.4224, 0.8741, -0.8361, 91.0615, 0.8698, -0.829, 39.6123, 17.1486, 10.9033, 10.7893,
                16.0418, 16.0877, 2.4549, 10.6975, 10.6303, 15.9268, 16.3046, 1.7207, 43.953, -0.8775, 83.2924, 93.5158,
                83.2924, 43.0755, 1.6112, 43.9374, -0.8917, 89.7121, 88.871, 43.0457, 88.7917, 18.7391, 43.9505, -0.8741,
                93.5, 81.2273, 43.0764, 81.308, 2.0716, 9.3309, 170.7639, 43.9523, -0.8962, 89.185, 89.7052, 43.0561,
                37.9056, 42.4586, 89.832, 54.6596, 28.0996, 2.0887, 8.6518, 173.6484, 2.0884, 9.3273, 170.0747, 2.1149,
                8.678, 175.0536, 0.0423, 3.5913, 4.9821, 43.9266, -0.8696, 95.0726, 80.9194, 43.057, 0.0438, 3.4597,
                4.9859, 81.002, 2.1619, 8.6694, 167.6875, 43.8881, -0.8953, 88.5577, 88.1731, 42.9928, 88.3233, 1.5702,
                43.3584, -0.8402, 100.3844, 85.8056, 100.3844, 42.5183, 1.4642, 43.3817, -0.8779, 94.6811, 80.039, 42.5038,
                2.0683, 9.3678, 170.2152, 79.9957, 1001.9148, 1991.3013, 1.3237, 57.9857, 43.3399, -0.8305, 101.241,
                85.0248, 101.241, 42.5093, 1805.6569, 1978.9819, 43.3928, -0.8699, 81.0847, 92.3082, 81.0847, 42.5229,
                0.481, 0.9479, 0.0711, 493.2897, 312.5718, 389.6827, 60.1142, 110.1777, 73.7589, 43.3425, -0.8297,
                100.9488, 85.9872, 100.9488, 42.5128, 1260.7385, 41.4028, 432.7824, 1600.7602, 1985.3012, 43.3272, -0.8873,
                91.8393, 81.125, 42.4399, 81.3582, 0.0021, 2.7576, 4.9909, 1405.3708, 37.8736, 20.1211, 14.4689, -0.3645,
                0.0078, 2.8041, 4.9932, 26.3841, 2.7441, 14.5283, 156.4449, 2.7168, 14.7041, 156.1978, 42.4397, 2.6764,
                2.6832, 15.2036, 14.672, 135.856, 137.496, 2.7373, 14.4086, 155.3525, 63.624, 1.975, 3.825, 5.7583,
                21.3958, -0.1042, 1.3417, 1.2208, 3.1833, 4.0208, 10.1292, -0.0083, 2.125, 1.7208, 2.7833, -3.2125,
                -0.3292, 2.3625, 0.4208, 3.5917, 2.2385, 1648.9791, 14.523, 57.021, 0.9958, 1.0, 1581.4979, 14.5316,
                0.0847, 0.3347, 1329.1191, 8.0255, 6.4681, 2.0, 1.0, 0.0, 5632.1574, 4582.9574, 5285.434, 131.0829,
                169.2376, 100.6368, 87.7799, 76.306, 89.288, 3.0, 6482.9872, 31.3605, 28.8927, 26.5667, -5.3293, 4.0,
                7922.7991, -5.2083, 1679.5154, 1988.4361, 28.2942, 29.4996, 13.2982, 30.5622, 2.7276, 2.9098, 1.1938,
                28.5431, 2.6711, 2.8498, 1.1342, 27.9596, 8.0507, 8.5044, 4.0809, 32.1182, 8.1262, 8.5827, 4.1449, 32.3116,
                328.5511, 324.08, 257.04, 256.96, 607.6, 6474.4889, 26.4956, 38.3076, 52.3276, 23.8311, 31.0022, 76.1493,
                32.8667, 1.2545, 92.3482, 1427.6964, 306.4018, 98.2455, 3.9375, 0.3616, 5.8482, 2.9241, 3.0, 2.0, 4.0, 3.0,
                634.81, 562.8371, 608.0679, 591.905, 1947.8507, 7.9864, 6.35, 559.1096, 5.0, 8652.2778, 0.9302, 1.9628,
                2.0047, 2.9349, 0.1814, 1013.3443, 1995.1934, 62.8152, 2.6862, 15.4562, 143.4857, 353.7943, 367.7368,
                2.6903, 2.7321, 3.7251, 3.6467, 69.8261, 1253.598, 41.0775, 286.3333, 22.0887, 44.2463, 23.1724, 74.8325,
                70.0788, 202.8465, 0.105, 0.15, 0.525, 0.92, 1.19, 1.125, 9.3525, 1794.1206, 51.6734, 1.9697, 69.4848,
                138.2828, 6.0, 9737.25, 141.6205, 79.3897, 68.5436, 21.0103, 12.9795, 62.3744, 17.1134, 96.6392, -0.9046,
                114.1598, 14.1031, 65.3918, 135.067, 69.1443, 69.6753, 138.8196, 70.7784, 82.7526, 137.5464, 137.0104,
                78.8698, 68.7188, 19.7812, 12.7031, 63.224, 1553.1089, 76.2826, 0.5398, 97.48, 96.2128, -1.8376, 113.6011,
                13.1649, 65.0691, 134.7234, 69.3245, 69.6543, 138.9787, 117.1444, 7.1957, 459.2262, 235.1292, 504.4072,
                2098.7046, 426.6647, 1870.2707, 2694.4195, 446.3746, 2643.3697, 3887.9167, 916.2669, 3789.3748, 4191.0426,
                142.3224, 3878.3206, 7948.6042, 404.5837, 8079.0912, 11504.638, 2.0172, 10678.9378, 6764.1163, 1554.0886,
                6835.6562, 2614.9247, 2624.0153, 2126.6284, 1880.1209, 4966.2258, 586.858, 561.1458, 2121.8943, 1841.331,
                4400.6646, 4236.5739, 54.9186, 37.0354, 2156.6175, 1737.6762, 3243.8267, 3027.0797, 2817.1449, 2683.1211,
                8143.1682, 8522.6794, 727.8306, 503.4838, 1616.158, 2067.0437, 1051.051, 1223.0345, 1509.5867, 1428.5313,
                2048.7352, 2085.1786, 3795.5189, 3891.361, 1361.7268, 1535.2607, 3738.4856, 3966.0441, 3366.2454,
                2644.5533, 3260.8147, 3957.157, 1373.6839, 1522.9676, 7078.6619, 6572.2444, 1383.2283, 1697.1908,
                3000.8617, 2962.1017, 6032.2269, 6629.6638, 2338.7332, 1988.4409, 10644.3674, 10198.1645, 5433.3069,
                5218.1783, 5720.7598, 5224.1906, 5762.8538, 5789.8561, 2765.4935, 2997.1737, 2795.4177, 2899.7966,
                1881.2169, 1883.3042, 2743.6612, 2616.0304, 7711.9915, 7279.9648, 15951.6984, 16430.4118, 5545.2869,
                4133.952, 5422.5094, 4709.384, 3145.786, 3185.4068, 4704.2266, 5191.9637, 10541.5549, 11328.8151,
                3818.8309, 2987.0395, 4275.3567, 4134.1484, 1501.4314, 1445.0609, 4709.4478, 3525.5199, 5642.5217,
                5305.8112, 1624.6621, 1841.6891, 3168.3937, 2626.9194, 1465.9672, 1517.9484, 9337.6987, 9441.4288,
                13755.883, 14132.2515, 2523.9786, 2690.3095, 2305.7214, 2414.7293, 9766.4654, 10364.1132, 9778.9942,
                11354.6702, 6377.296, 6394.1303, 26689.2457, 23311.7457, 0.0365, 0.0156, 0.494, 0.6611, 23076.129,
                396.7742, 501.629, 1232.1613, 1273.6398, 3988.5914, 3848.5215, 1811.172, 1761.3763, 4884.371, 4813.1183,
                3578.0108, 3388.9516, 7660.4839, 7857.3978, 1174930.9785, 1502701.6667, 552977.9892, 706226.9355,
                621952.9462, 796474.9409, 35245.5188, 44679.8392, 485798.9194, 621905.4892, 1.2892, 0.7068, 15.3661,
                5070.7845, 0.7407, 0.5832, 0.3586, 117.116, 7.2613, 3.9832, 0.7038, 893.0904, 0.0359, 0.0345, 0.0816,
                0.0805, 0.0833, 0.0769, 0.0875, 0.0797, 0.1552, 0.156, 0.1282, 0.0726, 0.0632, 0.0678, 0.0596, 0.0899,
                0.1466, 0.1205, 0.1201, 0.0927, 0.0788, 0.0455, 0.0573, 0.0605, 0.0655, 0.0744, 0.0681, 0.2283, 0.2356,
                0.2471, 0.2474, 0.2314, 0.2211, 0.1869, 0.1852, 0.1857, 0.1854, 0.234, 0.1874, 0.1823, 0.1703, 0.1646,
                0.1941, 0.1283, 0.1591, 0.1584, 0.2946, 0.2935, 0.1437, 0.129, 0.241, 0.2365, 0.2522, 0.2418, 0.4756,
                0.4732, 0.6101, 0.6075, 0.6168, 0.6237, 0.5248, 0.5196, 0.6044, 0.6068, 0.7409, 0.5214, 0.523, 0.529,
                0.5301, 0.5443, 0.6059, 0.6818, 0.6889, 0.4545, 0.4547, 0.5468, 0.5728, 0.5387, 0.5429, 0.5507, 0.5506,
                0.0005, 0.0005, 0.0005, 0.0005, 0.0005, 0.0004, 0.0005, 0.0005, 0.0006, 0.0006, 0.0004, 0.0005, 0.0005,
                0.0005, 0.0005, 0.0005, 0.0005, 0.0004, 0.0004, 0.0007, 0.0007, 0.0004, 0.0004, 0.0005, 0.0005, 0.0005,
                0.0005, 0.0007, 0.0007, 0.0007, 0.0007, 0.0007, 0.0007, 0.0007, 0.0007, 0.0007, 0.0007, 0.0006, 0.0007,
                0.0007, 0.0007, 0.0007, 0.0007, 0.0006, 0.0006, 0.0006, 0.0008, 0.0008, 0.0006, 0.0006, 0.0007, 0.0007,
                0.0007, 0.0007, 0.0012, 0.0012, 0.0011, 0.0011, 0.0011, 0.0011, 0.0013, 0.0013, 0.0014, 0.0014, 0.0012,
                0.0013, 0.0013, 0.0013, 0.0013, 0.0013, 0.0016, 0.0013, 0.0013, 0.0012, 0.0012, 0.0012, 0.0013, 0.0011,
                0.0011, 0.0012, 0.0012, 0.5067, 0.4764, 0.4158, 0.3914, 0.312, 0.2945, 0.4822, 0.485, 0.6655, 0.6679,
                0.4933, 0.4821, 0.5048, 0.5358, 0.5466, 0.4956, 0.7269, 0.6273, 0.6202, 0.4307, 0.4187, 0.5704, 0.6446,
                0.4143, 0.4078, 0.3414, 0.3688, 0.0008, 0.0008, 0.0008, 0.0008, 0.0008, 0.0007, 0.0008, 0.0008, 0.0009,
                0.0009, 0.0007, 0.0008, 0.0008, 0.0008, 0.0008, 0.0008, 0.0009, 0.0008, 0.0008, 0.0009, 0.0009, 0.0008,
                0.0008, 0.0008, 0.0008, 0.0008, 0.0008, 0.3871, 0.3865, 0.4213, 0.4252, 0.4266, 0.4452, 0.4561, 0.4619,
                0.4238, 0.4239, 0.483, 0.4513, 0.4649, 0.4653, 0.4805, 0.4646, 0.5851, 0.5355, 0.5449, 0.3043, 0.3109,
                0.4966, 0.5359, 0.3919, 0.3994, 0.4123, 0.4254, 0.1599, 0.1852, 0.0204, 0.0201, 0.0782, 0.075, 0.074,
                0.0828, 0.1132, 0.1307, 0.0331, 0.0311, 0.0694, 0.0598, 0.0306, 0.0339, 0.0533, 0.0671, 0.0792, 0.0898,
                0.0817, 0.0867, 0.0811, 0.0858, 0.0558, 0.0548, 0.073, 0.0771, 0.0816, 0.0838, 0.0711, 0.0763, 0.1011,
                0.1024, 0.1231, 0.1301, 0.0911, 0.0856, 0.0778, 0.0721, 0.1465, 0.1554, 0.5256, 0.0807, 0.1066, 0.0713,
                0.1551, 0.1046, 0.0671, 0.0713, 0.1434, 0.1181, 0.1818, 0.1796, 0.1423, 0.1386, 0.1371, 0.1342, 0.1746,
                0.1738, 0.0759, 0.0894, 0.1699, 0.1717, 0.1006, 0.0992, 0.0751, 0.0807, 0.1513, 0.1378, 0.1826, 0.1885,
                0.1811, 0.1751, 0.0956, 0.1047, 0.1022, 0.0978, 0.1071, 0.0995, 0.1072, 0.1029, 0.0799, 0.0816, 0.159,
                0.1587, 0.1077, 0.1046, 0.1487, 0.1585, 0.1564, 0.0531, 0.0606, 0.0608, 0.2184, 0.1981, 0.5263, 0.4848,
                0.5102, 0.5108, 0.6186, 0.6173, 0.6577, 0.6464, 0.582, 0.5781, 0.5032, 0.5014, 0.6165, 0.5917, 0.5187,
                0.5157, 0.5434, 0.5374, 0.5391, 0.549, 0.5592, 0.546, 0.6474, 0.6573, 0.5576, 0.5655, 0.6146, 0.6034,
                0.7356, 0.7192, 0.6558, 0.6614, 0.7534, 0.7411, 0.6996, 0.6973, 0.6704, 0.6729, 0.624, 0.6191, 0.7083,
                0.7121, 0.5646, 0.7069, 0.6624, 0.6231, 0.6929, 0.7541, 0.0005, 0.0006, 0.0004, 0.0004, 0.0005, 0.0005,
                0.0004, 0.0004, 0.0004, 0.0005, 0.0005, 0.0005, 0.0003, 0.0004, 0.0004, 0.0004, 0.0004, 0.0004, 0.0004,
                0.0004, 0.0005, 0.0005, 0.0004, 0.0004, 0.0005, 0.0005, 0.0003, 0.0004, 0.0003, 0.0003, 0.0004, 0.0003,
                0.0003, 0.0003, 0.0003, 0.0003, 0.0004, 0.0004, 0.0004, 0.0004, 0.0004, 0.0004, 0.0011, 0.0002, 0.0003,
                0.0003, 0.0005, 0.0004, 0.0007, 0.0008, 0.0006, 0.0006, 0.0006, 0.0006, 0.0006, 0.0006, 0.0007, 0.0007,
                0.0006, 0.0006, 0.0005, 0.0006, 0.0006, 0.0007, 0.0006, 0.0006, 0.0006, 0.0006, 0.0007, 0.0007, 0.0006,
                0.0006, 0.0007, 0.0006, 0.0006, 0.0006, 0.0005, 0.0005, 0.0005, 0.0005, 0.0005, 0.0005, 0.0005, 0.0005,
                0.0006, 0.0006, 0.0005, 0.0005, 0.0007, 0.0007, 0.0013, 0.0004, 0.0004, 0.0004, 0.0007, 0.0006, 0.0017,
                0.0017, 0.0012, 0.0012, 0.0012, 0.0012, 0.0012, 0.0012, 0.0014, 0.0014, 0.0012, 0.0012, 0.0014, 0.0013,
                0.0012, 0.0012, 0.0014, 0.0014, 0.0015, 0.0015, 0.0013, 0.0013, 0.0012, 0.0012, 0.0012, 0.0012, 0.0014,
                0.0014, 0.0014, 0.0014, 0.0013, 0.0013, 0.0014, 0.0014, 0.0016, 0.0016, 0.0012, 0.0012, 0.0013, 0.0013,
                0.0013, 0.0013, 0.0023, 0.0016, 0.0016, 0.0016, 0.0011, 0.0012, 0.8355, 0.8473, 0.7165, 0.7561, 0.7412,
                0.7738, 0.4923, 0.5108, 0.5442, 0.5881, 0.6372, 0.629, 0.7464, 0.6904, 0.4945, 0.4642, 0.6182, 0.6216,
                0.7763, 0.7672, 0.5368, 0.5268, 0.5462, 0.5765, 0.5713, 0.6486, 0.7501, 0.6753, 0.8122, 0.8378, 0.7947,
                0.8064, 0.8229, 0.8424, 0.8602, 0.8539, 0.6076, 0.5991, 0.7821, 0.7717, 0.521, 0.4533, 0.8117, 0.9074,
                0.9009, 0.905, 0.2272, 0.5566, 0.001, 0.001, 0.0007, 0.0007, 0.0008, 0.0007, 0.0007, 0.0007, 0.0008,
                0.0009, 0.0008, 0.0008, 0.0008, 0.0008, 0.0008, 0.0008, 0.0008, 0.0008, 0.0008, 0.0008, 0.0008, 0.0008,
                0.0007, 0.0007, 0.0008, 0.0008, 0.0008, 0.0008, 0.0007, 0.0007, 0.0007, 0.0007, 0.0007, 0.0007, 0.0008,
                0.0008, 0.0007, 0.0007, 0.0008, 0.0008, 0.0008, 0.0008, 0.0016, 0.0007, 0.0008, 0.0008, 0.0008, 0.0007,
                0.5735, 0.546, 0.513, 0.5269, 0.4684, 0.4663, 0.5307, 0.5241, 0.5295, 0.5264, 0.4653, 0.4597, 0.6261,
                0.5807, 0.47, 0.4608, 0.5743, 0.5632, 0.6084, 0.5984, 0.4843, 0.4927, 0.4936, 0.4853, 0.4558, 0.465,
                0.6189, 0.5955, 0.6895, 0.681, 0.5929, 0.6029, 0.7137, 0.7097, 0.7104, 0.6983, 0.5476, 0.549, 0.5905,
                0.5961, 0.5386, 0.5169, 0.4395, 0.7909, 0.7173, 0.7261, 0.409, 0.546, 43.4232, 77.8295, 28.9261,
            ],
        ),
        std=np.array(
            [
                8.1087, 8.077, 2.1066, 2.5482, 2.1467, 12.3899, 3.0925, 3.0109, 3.9892, 3.7321, 3.5182, 3.3574, 2.6427,
                3.2843, 2.7197, 5.3386, 3.8747, 2.7351, 1.6003, 1.8946, 0.2949, 1.5131, 9.3581, 13.5615, 9.3108, 11.2478,
                15.8735, 11.3271, 4.8147, 117.1678, 173.1958, 121.9444, 3.2782, 1.3032, 1.0024, 0.4824, 0.001, 0.001,
                0.001, 0.001, 4.7395, 4.6709, 3.6179, 4.4538, 2.8219, 8.8037, 1.2514, 1.3384, 7.1577, 4.9111, 1.8534,
                10.6086, 1.9142, 2.0096, 1.8848, 10.6585, 55.5267, 54.8685, 34.6291, 34.3594, 86.8084, 1359.3275, 4.7697,
                8.3766, 11.4568, 8.5926, 15.812, 1.9998, 10.3286, 0.7788, 0.8174, 0.6494, 10.2445, 1.9052, 8.0512, 0.7945,
                0.8328, 9.5929, 5.2078, 0.712, 157.7349, 5.7889, 5.9656, 128.0124, 141.194, 144.1898, 5868.4405, 551.4911,
                577.6671, 44.8952, 34.2114, 106.0323, 487.9158, 420.1071, 77.9439, 518.4521, 111.2771, 121.6212, 76.694,
                0.512, 1.0836, 0.0488, 58.9639, 0.9929, 1.0059, 1.8539, 4.6858, 3.5557, 1.2431, 0.4132, 1.8464, 0.4674,
                1.8109, 8.4511, 2.2699, 7.5849, 0.1088, 0.0428, 0.1384, 1.45, 0.1766, 0.7098, 0.3739, 78.3406, 0.9845,
                1.4512, 1.1607, 19.1216, 10.4818, 5.5738, 4.3769, 11.8632, 0.2406, 4.4921, 0.0138, 0.2893, 0.0627, 5.3663,
                7.9964, 0.0674, 1.5293, 1.9732, 4.6832, 17.9559, 9.814, 11.3225, 137.435, 0.812, 1.0301, 140.9553, 0.8177,
                1.0396, 93446.122, 167941.3646, 21.5753, 17.5446, 0.094, 0.3929, 4.1237, 1.2776, 0.1573, 0.2831, 6.0493,
                79.2416, 0.8165, 965.6057, 17.8721, 18.2441, 49.1292, 932.9309, 18.2249, 0.8047, 1.1764, 4.8921, 5.6526,
                4.7422, 5.6399, 155.9022, 0.8936, 1.1408, 3.3041, 18.1291, 48.9092, 0.1339, 21.0229, 34.3569, 18.7037,
                4.4916, 0.6669, 1.2609, 3.1662, 6.9099, 951.4459, 17.49, 979.9718, 19.1655, 1.3216, 6.3078, 13.5213,
                1.7532, 5.633, 147.0699, 10.7111, 192.8238, 290.9537, 161.828, 207.8869, 5.1262, 4.7898, 1.108, 230.8905,
                122.4383, 5.6893, 6.5142, 5.4309, 26.6104, 11.8698, 69.6437, 13.1089, 3.1112, 588.4742, 1.8529, 589.3486,
                1.2981, 1.9882, 2.0971, 1.4447, 25.5726, 41.0581, 22.5565, 4.7881, 1.9185, 0.1615, 1.9612, 1.5038, 0.1693,
                26.6208, 42.7378, 23.396, 4.652, 111.0961, 7.5178, 0.5953, 1.3396, 0.4195, 19.653, 949.3169, 18.706,
                905.8478, 17.585, 18.4969, 2.0727, 13.2747, 5.2253, 16.8466, 7.5335, 568.555, 8.603, 41.8091, 18.3162,
                0.001, 1.2391, 0.1671, 0.2466, 0.2466, 1.0148, 0.2627, 0.001, 1.3018, 0.2569, 0.2476, 0.2476, 1.016,
                0.3167, 88.2066, 54.866, 0.2178, 0.2085, 0.2657, 0.8175, 0.001, 57.1736, 0.7711, 2.8703, 57.315, 0.7706,
                2.8823, 57.5895, 0.7692, 2.8983, 1.3104, 2.2411, 2541.3215, 0.8828, 0.001, 55.1441, 0.6914, 2.7906,
                55.7707, 0.6762, 2.7919, 56.0553, 0.6468, 2.7789, 11.9129, 4.0963, 3.8545, 3.7162, 4.1892, 3.7091, 6.1748,
                3.3852, 3.5521, 4.0003, 5.5925, 0.6527, 1.629, 0.6326, 67.583, 38.2045, 67.583, 1.5299, 0.6049, 1.6407,
                0.68, 37.5037, 68.3371, 1.5186, 68.337, 11.004, 1.6295, 0.6345, 38.634, 67.109, 1.5344, 67.2219, 1.6176,
                7.7286, 124.2482, 1.6296, 0.692, 37.4882, 68.2988, 1.506, 27.0453, 15.0176, 68.3036, 21.9348, 8.9372,
                1.411, 6.5055, 87.5154, 1.6601, 7.956, 123.3909, 1.3955, 6.524, 86.319, 0.2352, 1.6865, 0.2139, 1.6399,
                0.6377, 38.5086, 66.8275, 1.5409, 0.2429, 1.638, 0.1743, 66.8696, 1.4702, 6.6434, 86.5635, 1.6112, 0.7053,
                37.7048, 68.5739, 1.4836, 68.5703, 0.6339, 1.5672, 0.6217, 61.7349, 46.2674, 61.7349, 1.5707, 0.7084,
                1.6131, 0.7172, 45.9963, 61.5849, 1.5487, 1.5598, 8.2239, 123.6315, 61.6448, 1137.342, 16.2358, 0.6385,
                11.2211, 1.567, 0.6142, 61.3191, 46.1621, 61.3191, 1.5719, 620.6831, 11.3031, 1.5877, 0.6977, 62.319,
                45.6888, 62.319, 1.5062, 0.8058, 1.0346, 0.4306, 162.4122, 116.0766, 107.5879, 25.9592, 20.6813, 36.1314,
                1.5664, 0.5976, 61.6478, 46.4301, 61.6478, 1.5582, 952.4943, 19.3796, 337.7562, 864.9392, 12.4069, 1.6108,
                0.7289, 44.3356, 63.2451, 1.5282, 63.195, 0.2312, 1.9694, 0.1238, 897.7984, 17.6667, 20.9066, 25.8222,
                6.0326, 0.2333, 1.9658, 0.1171, 20.7808, 1.8021, 8.7629, 65.6396, 1.7579, 8.6691, 67.2598, 11.4289, 1.5332,
                1.5003, 10.797, 10.6851, 130.5286, 129.419, 1.7898, 8.7029, 67.112, 7.893, 2.0092, 2.4254, 1.7306, 14.8288,
                1.7359, 4.271, 3.6326, 3.4203, 4.4371, 7.9275, 3.4567, 2.3393, 3.4327, 2.1484, 5.5139, 4.632, 2.7285,
                4.1855, 2.9492, 1.0348, 520.0694, 2.4706, 67.4957, 1.0759, 1.1237, 496.3264, 2.4617, 0.6529, 4.5653,
                387.6671, 1.6943, 1.8944, 0.001, 0.001, 0.001, 4528.0061, 2823.0501, 5648.1436, 7.1047, 9.5226, 8.585,
                13.2577, 15.6599, 5.0689, 0.001, 5518.762, 11.3002, 11.1512, 4.4591, 1.8228, 0.001, 6560.1056, 1.7303,
                792.5056, 11.6193, 5.7762, 5.9563, 5.0091, 7.6773, 0.7702, 0.8058, 0.6047, 9.7212, 0.7293, 0.7685, 0.547,
                9.3504, 1.8256, 1.9165, 1.6835, 10.5136, 1.8465, 1.9371, 1.699, 10.4843, 53.4126, 51.1933, 39.4777,
                40.7726, 89.263, 1324.8868, 4.3573, 8.2331, 11.2421, 8.8133, 8.1475, 15.381, 18.0439, 0.8368, 121.9117,
                686.8824, 143.1279, 84.2161, 3.2006, 1.0224, 0.924, 0.4625, 0.001, 0.001, 0.001, 0.001, 125.5111, 110.8527,
                143.9564, 97.5493, 229.2409, 2.0625, 2.0791, 101.7813, 0.001, 6150.0108, 1.0749, 2.1831, 1.8824, 3.5742,
                0.421, 1139.2341, 14.5782, 67.7617, 1.6456, 11.8015, 131.0935, 143.234, 137.2017, 0.8212, 0.7621, 2.0358,
                0.9468, 17.3532, 955.2747, 20.05, 68.8728, 4.9532, 6.7883, 4.6285, 71.5987, 11.0759, 93.5386, 0.4526,
                0.5645, 1.3461, 2.0094, 2.0317, 2.0937, 2.8129, 600.9217, 10.5283, 0.301, 12.4089, 24.2911, 0.001,
                10816.1546, 20.8796, 10.6093, 12.099, 8.4633, 2.7818, 11.4103, 5.2561, 14.0717, 30.7269, 19.53, 7.7203,
                20.3201, 21.9318, 20.8059, 11.7107, 22.3954, 12.6561, 10.8358, 18.2264, 17.97, 10.0973, 11.4153, 11.2909,
                2.9165, 13.1245, 31.5415, 19.2998, 0.1271, 19.9313, 14.1174, 22.9181, 19.4431, 8.5356, 20.3994, 22.1595,
                21.0593, 11.804, 22.6979, 40.673, 2.7212, 87.7732, 45.9778, 87.8995, 394.6026, 88.5057, 382.1491, 509.2031,
                82.8328, 508.232, 701.9742, 166.1731, 651.4039, 629.0041, 29.1297, 615.1568, 990.1914, 80.5636, 1103.9295,
                1614.3233, 1.5464, 1529.6324, 1024.972, 249.7351, 1045.7184, 364.0448, 400.4719, 296.8141, 288.5233,
                790.4349, 117.9104, 111.9176, 307.7165, 245.3115, 406.9834, 388.0587, 33.5347, 29.465, 484.1735, 407.969,
                729.1896, 679.2097, 268.8922, 266.4453, 1274.6458, 1383.7358, 153.7635, 106.4929, 326.5944, 511.179,
                201.6776, 268.6615, 221.4344, 222.2292, 421.1233, 472.1613, 637.2277, 631.322, 254.4704, 274.7066,
                605.3689, 614.7154, 570.4109, 448.9165, 463.1432, 583.2148, 241.2352, 266.8212, 869.0902, 871.5526,
                171.2662, 211.9845, 469.9236, 441.4545, 748.8589, 929.776, 467.3665, 396.648, 1342.6558, 1302.4665,
                663.0176, 693.1961, 1242.5381, 1158.0959, 877.7434, 904.0802, 363.6619, 411.6836, 594.6241, 588.9357,
                320.5224, 315.4139, 568.4182, 626.5982, 1310.899, 1243.4389, 2438.7755, 2264.7768, 1000.9711, 797.8121,
                1030.9441, 870.7896, 658.5941, 626.3905, 901.0404, 951.2645, 1363.6756, 1489.9331, 828.4878, 599.1269,
                809.2853, 833.8098, 301.4229, 328.0439, 979.0718, 763.8373, 900.9324, 817.9549, 355.1208, 372.676,
                549.5694, 485.0994, 290.2667, 307.4731, 1244.6961, 1187.0528, 1765.2789, 1806.0826, 604.0097, 590.9329,
                496.3198, 572.3823, 1774.398, 1898.7809, 1538.1685, 1932.255, 623.2331, 663.1157, 3134.0469, 2717.3462,
                0.0048, 0.0027, 0.0318, 0.0377, 2857.7794, 112.2299, 118.3312, 287.2718, 239.1608, 490.0461, 464.2455,
                245.1708, 239.43, 567.0873, 587.3876, 446.4645, 436.1482, 750.2718, 773.2353, 113511.1257, 69861.9097,
                64296.0175, 40630.8951, 56016.8458, 47736.1409, 16066.4005, 18943.6644, 46902.2418, 40188.848, 0.1218,
                0.0867, 8.3324, 7654.0787, 0.073, 0.0733, 0.0553, 43.5187, 2.9446, 1.713, 0.1066, 973.2796, 0.0126, 0.0106,
                0.0141, 0.014, 0.0147, 0.0148, 0.0202, 0.0213, 0.03, 0.0294, 0.0332, 0.0131, 0.0135, 0.0129, 0.0124,
                0.0155, 0.0301, 0.0156, 0.014, 0.0505, 0.039, 0.0147, 0.0185, 0.0163, 0.0159, 0.0201, 0.0206, 0.0163,
                0.019, 0.0168, 0.0156, 0.0125, 0.0125, 0.0111, 0.0108, 0.0171, 0.0154, 0.023, 0.0093, 0.01, 0.0113, 0.0113,
                0.0112, 0.0135, 0.0161, 0.0156, 0.0302, 0.0273, 0.0194, 0.018, 0.0128, 0.0119, 0.0171, 0.0193, 0.0286,
                0.0288, 0.0273, 0.0271, 0.0376, 0.0396, 0.0328, 0.0321, 0.0217, 0.0208, 0.028, 0.0333, 0.0333, 0.0354,
                0.0344, 0.0416, 0.0327, 0.0243, 0.023, 0.0273, 0.0269, 0.0378, 0.0378, 0.0325, 0.0323, 0.0299, 0.0287,
                0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001,
                0.001, 0.0011, 0.001, 0.001, 0.0011, 0.0011, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001,
                0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.0011, 0.001,
                0.001, 0.0011, 0.0011, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001,
                0.001, 0.001, 0.0011, 0.0011, 0.0011, 0.001, 0.001, 0.001, 0.001, 0.001, 0.0011, 0.001, 0.001, 0.0011,
                0.0011, 0.001, 0.0011, 0.001, 0.001, 0.001, 0.001, 0.0456, 0.0493, 0.0567, 0.0553, 0.0476, 0.0477, 0.0429,
                0.0467, 0.0504, 0.047, 0.0718, 0.0306, 0.0332, 0.0335, 0.0356, 0.0387, 0.0406, 0.0506, 0.0498, 0.0622,
                0.0678, 0.0628, 0.0583, 0.0428, 0.0433, 0.0605, 0.0651, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001,
                0.001, 0.001, 0.001, 0.0011, 0.001, 0.001, 0.001, 0.001, 0.001, 0.0011, 0.001, 0.001, 0.0011, 0.0011,
                0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.0227, 0.0259, 0.0213, 0.0194, 0.0229, 0.0242, 0.0209, 0.0211,
                0.0277, 0.0255, 0.027, 0.0207, 0.0213, 0.0227, 0.023, 0.0236, 0.031, 0.0285, 0.0264, 0.0357, 0.0313,
                0.0342, 0.034, 0.0202, 0.0204, 0.0233, 0.0253, 0.0839, 0.0758, 0.0157, 0.0141, 0.0346, 0.0354, 0.0149,
                0.0153, 0.039, 0.0426, 0.0153, 0.0134, 0.0187, 0.0166, 0.0145, 0.0158, 0.0156, 0.0167, 0.0164, 0.0172,
                0.019, 0.0239, 0.0166, 0.0157, 0.0149, 0.0149, 0.0182, 0.0231, 0.0177, 0.0188, 0.0195, 0.0224, 0.0202,
                0.0218, 0.0201, 0.0255, 0.0205, 0.0183, 0.0316, 0.0303, 0.0502, 0.0552, 0.1384, 0.0169, 0.0204, 0.0217,
                0.0545, 0.0178, 0.0229, 0.0199, 0.0238, 0.025, 0.03, 0.0296, 0.0168, 0.0168, 0.0233, 0.0222, 0.0305,
                0.0288, 0.0103, 0.0142, 0.0154, 0.0151, 0.0148, 0.0141, 0.0126, 0.0117, 0.016, 0.0178, 0.0205, 0.0214,
                0.0191, 0.0198, 0.0123, 0.0149, 0.0128, 0.0127, 0.0113, 0.0112, 0.0113, 0.0121, 0.0089, 0.01, 0.0275,
                0.0277, 0.0191, 0.02, 0.0288, 0.0313, 0.1491, 0.008, 0.0087, 0.0071, 0.0352, 0.0168, 0.0665, 0.0667,
                0.0292, 0.0304, 0.0605, 0.0559, 0.043, 0.0403, 0.0343, 0.0333, 0.0339, 0.0331, 0.0388, 0.0398, 0.0292,
                0.0289, 0.0389, 0.0439, 0.0442, 0.0439, 0.0454, 0.0491, 0.037, 0.0354, 0.0459, 0.0473, 0.0329, 0.0355,
                0.0252, 0.0239, 0.032, 0.0333, 0.0314, 0.0325, 0.0226, 0.025, 0.027, 0.0273, 0.0292, 0.0304, 0.0474, 0.05,
                0.066, 0.0315, 0.0351, 0.0474, 0.039, 0.0244, 0.0011, 0.0011, 0.001, 0.001, 0.0011, 0.0011, 0.001, 0.001,
                0.0011, 0.0011, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.0011, 0.0011, 0.0011, 0.0011,
                0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001,
                0.001, 0.001, 0.001, 0.0011, 0.0011, 0.0013, 0.001, 0.001, 0.0011, 0.0011, 0.001, 0.0011, 0.0011, 0.001,
                0.001, 0.0011, 0.0011, 0.001, 0.001, 0.0011, 0.0011, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001,
                0.001, 0.0011, 0.0011, 0.001, 0.0011, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001,
                0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.0011, 0.0011, 0.0014, 0.001, 0.001, 0.0011,
                0.0011, 0.001, 0.0012, 0.0012, 0.0011, 0.0011, 0.0011, 0.0011, 0.001, 0.001, 0.0011, 0.0011, 0.0011,
                0.0011, 0.0011, 0.0011, 0.001, 0.001, 0.0011, 0.0011, 0.0011, 0.0011, 0.0011, 0.0011, 0.0011, 0.001, 0.001,
                0.001, 0.001, 0.0011, 0.001, 0.001, 0.001, 0.001, 0.0011, 0.0011, 0.0011, 0.0011, 0.0011, 0.0011, 0.0011,
                0.0011, 0.0011, 0.0011, 0.0012, 0.0011, 0.001, 0.0011, 0.0011, 0.001, 0.1226, 0.1093, 0.095, 0.0818,
                0.1341, 0.1286, 0.0871, 0.0867, 0.102, 0.0896, 0.096, 0.0873, 0.0432, 0.062, 0.0672, 0.0649, 0.0674,
                0.0706, 0.068, 0.064, 0.0903, 0.1066, 0.105, 0.1037, 0.0822, 0.0785, 0.0537, 0.0673, 0.0561, 0.0439,
                0.0512, 0.053, 0.0317, 0.0282, 0.0284, 0.029, 0.0916, 0.0909, 0.0549, 0.0593, 0.136, 0.1435, 0.1034,
                0.0296, 0.036, 0.0264, 0.1792, 0.0513, 0.0011, 0.0011, 0.001, 0.001, 0.0011, 0.0011, 0.001, 0.001, 0.001,
                0.0011, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.0011, 0.0011, 0.001, 0.001,
                0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001, 0.001,
                0.001, 0.0011, 0.0011, 0.0013, 0.001, 0.001, 0.001, 0.0011, 0.001, 0.0621, 0.0645, 0.0397, 0.0371, 0.0452,
                0.046, 0.0308, 0.0289, 0.0375, 0.0361, 0.037, 0.034, 0.0298, 0.0322, 0.0255, 0.0245, 0.0314, 0.03, 0.0356,
                0.034, 0.0284, 0.0309, 0.0272, 0.0279, 0.0337, 0.0345, 0.0286, 0.0301, 0.0254, 0.0273, 0.0273, 0.0287,
                0.0261, 0.0266, 0.0235, 0.0262, 0.0336, 0.0335, 0.0297, 0.0312, 0.0351, 0.04, 0.0893, 0.0229, 0.0313,
                0.0352, 0.0328, 0.0233, 21.576, 12.8703, 6.8492,
            ],
        ),
    ),
    channel_map={
        '34_Year-of-birth_0_0': 0, '21003_Age-when-attended-assessment-centre_0_0': 1,
        '904_Number-of-daysweek-of-vigorous-physical-activity-10-minutes_0_0': 2,
        '884_Number-of-daysweek-of-moderate-physical-activity-10-minutes_0_0': 3,
        '864_Number-of-daysweek-walked-10-minutes_0_0': 4, '699_Length-of-time-at-current-address_0_0': 5,
        '189_Townsend-deprivation-index-at-recruitment_0_0': 6,
        '1070_Time-spent-watching-television-TV_0_0': 7, '1528_Water-intake_0_0': 8,
        '1498_Coffee-intake_0_0': 9, '1488_Tea-intake_0_0': 10, '1319_Dried-fruit-intake_0_0': 11,
        '1309_Fresh-fruit-intake_0_0': 12, '1299_Salad-raw-vegetable-intake_0_0': 13,
        '1289_Cooked-vegetable-intake_0_0': 14, '1090_Time-spent-driving_0_0': 15,
        '1458_Cereal-intake_0_0': 16, '137_Number-of-treatmentsmedications-taken_0_0': 17,
        '136_Number-of-operations-selfreported_0_0': 18,
        '135_Number-of-selfreported-noncancer-illnesses_0_0': 19, '134_Number-of-selfreported-cancers_0_0': 20,
        '709_Number-in-household_0_0': 21, '49_Hip-circumference_0_0': 22, '48_Waist-circumference_0_0': 23,
        '50_Standing-height_0_0': 24, '47_Hand-grip-strength-right_0_0': 25, '21002_Weight_0_0': 26,
        '46_Hand-grip-strength-left_0_0': 27, '21001_Body-mass-index-BMI_0_0': 28,
        '20023_Mean-time-to-correctly-identify-matches_0_0': 29, '400_Time-to-complete-round_0_2': 30,
        '400_Time-to-complete-round_0_1': 31, '399_Number-of-incorrect-matches-in-round_0_2': 32,
        '399_Number-of-incorrect-matches-in-round_0_1': 33, '398_Number-of-correct-matches-in-round_0_2': 34,
        '398_Number-of-correct-matches-in-round_0_1': 35, '397_Number-of-rows-displayed-in-round_0_2': 36,
        '397_Number-of-rows-displayed-in-round_0_1': 37, '396_Number-of-columns-displayed-in-round_0_2': 38,
        '396_Number-of-columns-displayed-in-round_0_1': 39, '1080_Time-spent-using-computer_0_0': 40,
        '1060_Time-spent-outdoors-in-winter_0_0': 41, '1050_Time-spend-outdoors-in-summer_0_0': 42,
        '2277_Frequency-of-solariumsunlamp-use_0_0': 43, '1737_Childhood-sunburn-occasions_0_0': 44,
        '1438_Bread-intake_0_0': 45, '1883_Number-of-full-sisters_0_0': 46,
        '1873_Number-of-full-brothers_0_0': 47, '51_Seated-height_0_0': 48, '20015_Sitting-height_0_0': 49,
        '23116_Leg-fat-mass-left_0_0': 50, '23115_Leg-fat-percentage-left_0_0': 51,
        '23114_Leg-predicted-mass-right_0_0': 52, '23113_Leg-fatfree-mass-right_0_0': 53,
        '23112_Leg-fat-mass-right_0_0': 54, '23111_Leg-fat-percentage-right_0_0': 55,
        '23110_Impedance-of-arm-left_0_0': 56, '23109_Impedance-of-arm-right_0_0': 57,
        '23108_Impedance-of-leg-left_0_0': 58, '23107_Impedance-of-leg-right_0_0': 59,
        '23106_Impedance-of-whole-body_0_0': 60, '23105_Basal-metabolic-rate_0_0': 61,
        '23104_Body-mass-index-BMI_0_0': 62, '23102_Whole-body-water-mass_0_0': 63,
        '23101_Whole-body-fatfree-mass_0_0': 64, '23099_Body-fat-percentage_0_0': 65, '23098_Weight_0_0': 66,
        '23117_Leg-fatfree-mass-left_0_0': 67, '23123_Arm-fat-percentage-left_0_0': 68,
        '23122_Arm-predicted-mass-right_0_0': 69, '23121_Arm-fatfree-mass-right_0_0': 70,
        '23120_Arm-fat-mass-right_0_0': 71, '23119_Arm-fat-percentage-right_0_0': 72,
        '23118_Leg-predicted-mass-left_0_0': 73, '23127_Trunk-fat-percentage_0_0': 74,
        '23126_Arm-predicted-mass-left_0_0': 75, '23125_Arm-fatfree-mass-left_0_0': 76,
        '23100_Whole-body-fat-mass_0_0': 77, '23128_Trunk-fat-mass_0_0': 78, '23124_Arm-fat-mass-left_0_0': 79,
        '404_Duration-to-first-press-of-snapbutton-in-each-round_0_7': 80,
        '23130_Trunk-predicted-mass_0_0': 81, '23129_Trunk-fatfree-mass_0_0': 82,
        '404_Duration-to-first-press-of-snapbutton-in-each-round_0_5': 83,
        '404_Duration-to-first-press-of-snapbutton-in-each-round_0_11': 84,
        '404_Duration-to-first-press-of-snapbutton-in-each-round_0_10': 85,
        '30510_Creatinine-enzymatic-in-urine_0_0': 86, '30374_Volume-of-LiHep-plasma-held-by-UKB_0_0': 87,
        '30384_Volume-of-serum-held-by-UKB_0_0': 88, '30530_Sodium-in-urine_0_0': 89,
        '30520_Potassium-in-urine_0_0': 90, '30324_Volume-of-EDTA1-red-cells-held-by-UKB_0_0': 91,
        '30314_Volume-of-EDTA1-plasma-held-by-UKB_0_0': 92, '30334_Volume-of-EDTA1-buffy-held-by-UKB_0_0': 93,
        '30404_Volume-of-ACD-held-by-UKB_0_0': 94, '30344_Volume-of-EDTA2-plasma-held-by-UKB_0_0': 95,
        '30364_Volume-of-EDTA2-red-cells-held-by-UKB_0_0': 96,
        '30354_Volume-of-EDTA2-buffy-held-by-UKB_0_0': 97, '874_Duration-of-walks_0_0': 98,
        '30110_Platelet-distribution-width_0_0': 99, '30100_Mean-platelet-thrombocyte-volume_0_0': 100,
        '30090_Platelet-crit_0_0': 101, '30080_Platelet-count_0_0': 102,
        '30070_Red-blood-cell-erythrocyte-distribution-width_0_0': 103,
        '30060_Mean-corpuscular-haemoglobin-concentration_0_0': 104,
        '30050_Mean-corpuscular-haemoglobin_0_0': 105, '30040_Mean-corpuscular-volume_0_0': 106,
        '30030_Haematocrit-percentage_0_0': 107, '30020_Haemoglobin-concentration_0_0': 108,
        '30010_Red-blood-cell-erythrocyte-count_0_0': 109, '30000_White-blood-cell-leukocyte-count_0_0': 110,
        '30220_Basophill-percentage_0_0': 111, '30210_Eosinophill-percentage_0_0': 112,
        '30200_Neutrophill-percentage_0_0': 113, '30190_Monocyte-percentage_0_0': 114,
        '30180_Lymphocyte-percentage_0_0': 115, '30170_Nucleated-red-blood-cell-count_0_0': 116,
        '30160_Basophill-count_0_0': 117, '30150_Eosinophill-count_0_0': 118,
        '30140_Neutrophill-count_0_0': 119, '30130_Monocyte-count_0_0': 120, '30120_Lymphocyte-count_0_0': 121,
        '30230_Nucleated-red-blood-cell-percentage_0_0': 122, '30880_Urate_0_0': 123,
        '30870_Triglycerides_0_0': 124, '30670_Urea_0_0': 125, '30690_Cholesterol_0_0': 126,
        '4080_Systolic-blood-pressure-automated-reading_0_0': 127,
        '4079_Diastolic-blood-pressure-automated-reading_0_0': 128, '30770_IGF1_0_0': 129,
        '30710_Creactive-protein_0_0': 130, '102_Pulse-rate-automated-reading_0_0': 131,
        '30640_Apolipoprotein-B_0_0': 132, '30840_Total-bilirubin_0_0': 133,
        '30300_High-light-scatter-reticulocyte-count_0_0': 134,
        '30290_High-light-scatter-reticulocyte-percentage_0_0': 135,
        '30280_Immature-reticulocyte-fraction_0_0': 136, '30270_Mean-sphered-cell-volume_0_0': 137,
        '30260_Mean-reticulocyte-volume_0_0': 138, '30250_Reticulocyte-count_0_0': 139,
        '30240_Reticulocyte-percentage_0_0': 140, '1279_Exposure-to-tobacco-smoke-outside-home_0_0': 141,
        '1269_Exposure-to-tobacco-smoke-at-home_0_0': 142,
        '4080_Systolic-blood-pressure-automated-reading_0_1': 143,
        '4079_Diastolic-blood-pressure-automated-reading_0_1': 144,
        '102_Pulse-rate-automated-reading_0_1': 145, '3064_Peak-expiratory-flow-PEF_0_0': 146,
        '3063_Forced-expiratory-volume-in-1second-FEV1_0_0': 147, '3062_Forced-vital-capacity-FVC_0_0': 148,
        '3064_Peak-expiratory-flow-PEF_0_1': 149, '3063_Forced-expiratory-volume-in-1second-FEV1_0_1': 150,
        '3062_Forced-vital-capacity-FVC_0_1': 151, '130_Place-of-birth-in-UK-east-coordinate_0_0': 152,
        '129_Place-of-birth-in-UK-north-coordinate_0_0': 153, '30890_Vitamin-D_0_0': 154,
        '2217_Age-started-wearing-glasses-or-contact-lenses_0_0': 155, '30680_Calcium_0_0': 156,
        '30760_HDL-cholesterol_0_0': 157, '30860_Total-protein_0_0': 158, '30740_Glucose_0_0': 159,
        '30810_Phosphate_0_0': 160, '30630_Apolipoprotein-A_0_0': 161, '30850_Testosterone_0_0': 162,
        '894_Duration-of-moderate-activity_0_0': 163, '30660_Direct-bilirubin_0_0': 164,
        '92_Operation-yearage-first-occurred_0_0': 165,
        '20011_Interpolated-Age-of-participant-when-operation-took-place_0_0': 166,
        '1807_Fathers-age-at-death_0_0': 167, '30790_Lipoprotein-A_0_0': 168,
        '87_Noncancer-illness-yearage-first-occurred_0_0': 169,
        '20009_Interpolated-Age-of-participant-when-noncancer-illness-first-diagnosed_0_0': 170,
        '20150_Forced-expiratory-volume-in-1second-FEV1-Best-measure_0_0': 171,
        '1608_Average-weekly-fortified-wine-intake_0_0': 172, '1598_Average-weekly-spirits-intake_0_0': 173,
        '1588_Average-weekly-beer-plus-cider-intake_0_0': 174,
        '1578_Average-weekly-champagne-plus-white-wine-intake_0_0': 175,
        '1568_Average-weekly-red-wine-intake_0_0': 176, '3064_Peak-expiratory-flow-PEF_0_2': 177,
        '3063_Forced-expiratory-volume-in-1second-FEV1_0_2': 178, '3062_Forced-vital-capacity-FVC_0_2': 179,
        '845_Age-completed-full-time-education_0_0': 180, '3526_Mothers-age-at-death_0_0': 181,
        '914_Duration-of-vigorous-activity_0_0': 182, '3148_Heel-bone-mineral-density-BMD_0_0': 183,
        '3147_Heel-quantitative-ultrasound-index-QUI-direct-entry_0_0': 184,
        '3146_Speed-of-sound-through-heel_0_0': 185,
        '3144_Heel-Broadband-ultrasound-attenuation-direct-entry_0_0': 186,
        '3143_Ankle-spacing-width_0_0': 187, '20022_Birth-weight_0_0': 188,
        '2734_Number-of-live-births_0_0': 189, '2714_Age-when-periods-started-menarche_0_0': 190,
        '2704_Years-since-last-cervical-smear-test_0_0': 191, '92_Operation-yearage-first-occurred_0_1': 192,
        '20011_Interpolated-Age-of-participant-when-operation-took-place_0_1': 193,
        '87_Noncancer-illness-yearage-first-occurred_0_1': 194,
        '20009_Interpolated-Age-of-participant-when-noncancer-illness-first-diagnosed_0_1': 195,
        '2405_Number-of-children-fathered_0_0': 196, '2794_Age-started-oral-contraceptive-pill_0_0': 197,
        '2804_Age-when-last-used-oral-contraceptive-pill_0_0': 198,
        '2744_Birth-weight-of-first-child_0_0': 199,
        '2684_Years-since-last-breast-cancer-screening-mammogram_0_0': 200,
        '404_Duration-to-first-press-of-snapbutton-in-each-round_0_4': 201, '1845_Mothers-age_0_0': 202,
        '404_Duration-to-first-press-of-snapbutton-in-each-round_0_2': 203,
        '404_Duration-to-first-press-of-snapbutton-in-each-round_0_0': 204,
        '404_Duration-to-first-press-of-snapbutton-in-each-round_0_3': 205,
        '404_Duration-to-first-press-of-snapbutton-in-each-round_0_1': 206,
        '2764_Age-at-last-live-birth_0_0': 207, '2754_Age-at-first-live-birth_0_0': 208,
        '4291_Number-of-attempts_0_0': 209, '4290_Duration-screen-displayed_0_0': 210,
        '4288_Time-to-answer_0_0': 211, '4200_Position-of-the-shoulder-on-the-pulse-waveform_0_0': 212,
        '4199_Position-of-pulse-wave-notch_0_0': 213, '4198_Position-of-the-pulse-wave-peak_0_0': 214,
        '4195_Pulse-wave-reflection-index_0_0': 215, '4194_Pulse-rate_0_0': 216,
        '4196_Pulse-wave-peak-to-peak-time_0_0': 217, '3581_Age-at-menopause-last-menstrual-period_0_0': 218,
        '21021_Pulse-wave-Arterial-Stiffness-index_0_0': 219, '4279_Duration-of-hearing-test-right_0_0': 220,
        '4276_Number-of-triplets-attempted-right_0_0': 221, '4272_Duration-of-hearing-test-left_0_0': 222,
        '4269_Number-of-triplets-attempted-left_0_0': 223,
        '20128_Number-of-fluid-intelligence-questions-attempted-within-time-limit_0_0': 224,
        '20016_Fluid-intelligence-score_0_0': 225,
        '4106_Heel-bone-mineral-density-BMD-Tscore-automated-left_0_0': 226,
        '4104_Heel-quantitative-ultrasound-index-QUI-direct-entry-left_0_0': 227,
        '4103_Speed-of-sound-through-heel-left_0_0': 228,
        '4101_Heel-broadband-ultrasound-attenuation-left_0_0': 229, '4100_Ankle-spacing-width-left_0_0': 230,
        '20021_Speechreceptionthreshold-SRT-estimate-right_0_0': 231,
        '4105_Heel-bone-mineral-density-BMD-left_0_0': 232,
        '20019_Speechreceptionthreshold-SRT-estimate-left_0_0': 233,
        '4125_Heel-bone-mineral-density-BMD-Tscore-automated-right_0_0': 234,
        '4124_Heel-bone-mineral-density-BMD-right_0_0': 235,
        '4123_Heel-quantitative-ultrasound-index-QUI-direct-entry-right_0_0': 236,
        '4122_Speed-of-sound-through-heel-right_0_0': 237,
        '4120_Heel-broadband-ultrasound-attenuation-right_0_0': 238, '4119_Ankle-spacing-width-right_0_0': 239,
        '30500_Microalbumin-in-urine_0_0': 240, '2355_Most-recent-bowel-cancer-screening_0_0': 241,
        '20153_Forced-expiratory-volume-in-1second-FEV1-predicted_0_0': 242,
        '5057_Number-of-older-siblings_0_0': 243,
        '20162_Pack-years-adult-smoking-as-proportion-of-life-span-exposed-to-smoking_0_0': 244,
        '20161_Pack-years-of-smoking_0_0': 245, '87_Noncancer-illness-yearage-first-occurred_0_2': 246,
        '20009_Interpolated-Age-of-participant-when-noncancer-illness-first-diagnosed_0_2': 247,
        '92_Operation-yearage-first-occurred_0_2': 248,
        '20011_Interpolated-Age-of-participant-when-operation-took-place_0_2': 249,
        '2966_Age-high-blood-pressure-diagnosed_0_0': 250, '20191_Fluid-intelligence-score_0_0': 251,
        '2946_Fathers-age_0_0': 252, '20159_Number-of-symbol-digit-matches-made-correctly_0_0': 253,
        '3761_Age-hay-fever-rhinitis-or-eczema-diagnosed_0_0': 254, '22200_Year-of-birth_0_0': 255,
        '22603_Year-job-ended_0_0': 256, '22602_Year-job-started_0_0': 257,
        '5188_Duration-visualacuity-screen-displayed-left_0_0': 258,
        '5186_Duration-visualacuity-screen-displayed-right_0_0': 259,
        '5204_Distance-of-viewer-to-screen-right_0_0': 260, '5202_Number-of-rounds-to-result-right_0_0': 261,
        '5200_Final-number-of-letters-displayed-right_0_0': 262, '5199_logMAR-initial-right_0_0': 263,
        '5079_logMAR-in-round-right_0_0': 264, '5076_Number-of-letters-correct-in-round-right_0_0': 265,
        '5075_Number-of-letters-shown-in-round-right_0_0': 266,
        '5211_Distance-of-viewer-to-screen-left_0_0': 267, '5209_Number-of-rounds-to-result-left_0_0': 268,
        '5207_Final-number-of-letters-displayed-left_0_0': 269, '5206_logMAR-initial-left_0_0': 270,
        '5078_logMAR-in-round-left_0_0': 271, '5077_Number-of-letters-correct-in-round-left_0_0': 272,
        '5074_Number-of-letters-shown-in-round-left_0_0': 273,
        '5193_Duration-at-which-refractometer-first-shown-left_0_0': 274,
        '5190_Duration-at-which-refractometer-first-shown-right_0_0': 275, '5201_logMAR-final-right_0_0': 276,
        '5208_logMAR-final-left_0_0': 277, '5364_Average-weekly-intake-of-other-alcoholic-drinks_0_0': 278,
        '5221_Index-of-best-refractometry-result-right_0_0': 279, '5215_Vertex-distance-right_0_0': 280,
        '5088_Astigmatism-angle-right_0_0': 281, '5087_Cylindrical-power-right_0_0': 282,
        '5084_Spherical-power-right_0_0': 283, '5088_Astigmatism-angle-right_0_1': 284,
        '5087_Cylindrical-power-right_0_1': 285, '5084_Spherical-power-right_0_1': 286,
        '5088_Astigmatism-angle-right_0_2': 287, '5087_Cylindrical-power-right_0_2': 288,
        '5084_Spherical-power-right_0_2': 289, '22661_Number-of-gap-periods_0_0': 290,
        '22599_Number-of-jobs-held_0_0': 291, '30414_Volume-of-RNA-held-by-UKB_0_0': 292,
        '5276_Index-of-best-refractometry-result-left_0_0': 293, '5274_Vertex-distance-left_0_0': 294,
        '5089_Astigmatism-angle-left_0_0': 295, '5086_Cylindrical-power-left_0_0': 296,
        '5085_Spherical-power-left_0_0': 297, '5089_Astigmatism-angle-left_0_1': 298,
        '5086_Cylindrical-power-left_0_1': 299, '5085_Spherical-power-left_0_1': 300,
        '5089_Astigmatism-angle-left_0_2': 301, '5086_Cylindrical-power-left_0_2': 302,
        '5085_Spherical-power-left_0_2': 303, '2897_Age-stopped-smoking_0_0': 304,
        '2867_Age-started-smoking-in-former-smokers_0_0': 305, '5257_Corneal-resistance-factor-right_0_0': 306,
        '5256_Corneal-hysteresis-right_0_0': 307,
        '5255_Intraocular-pressure-Goldmanncorrelated-right_0_0': 308,
        '5254_Intraocular-pressure-cornealcompensated-right_0_0': 309,
        '2926_Number-of-unsuccessful-stopsmoking-attempts_0_0': 310,
        '5265_Corneal-resistance-factor-left_0_0': 311, '5264_Corneal-hysteresis-left_0_0': 312,
        '5263_Intraocular-pressure-Goldmanncorrelated-left_0_0': 313,
        '5262_Intraocular-pressure-cornealcompensated-left_0_0': 314,
        '5292_3mm-index-of-best-keratometry-results-left_0_0': 315, '5135_3mm-strong-meridian-left_0_0': 316,
        '5119_3mm-cylindrical-power-left_0_0': 317, '5112_3mm-cylindrical-power-angle-left_0_0': 318,
        '5104_3mm-strong-meridian-angle-left_0_0': 319, '5103_3mm-weak-meridian-angle-left_0_0': 320,
        '5096_3mm-weak-meridian-left_0_0': 321, '5237_3mm-index-of-best-keratometry-results-right_0_0': 322,
        '5132_3mm-strong-meridian-right_0_0': 323, '5116_3mm-cylindrical-power-right_0_0': 324,
        '5107_3mm-strong-meridian-angle-right_0_0': 325, '5100_3mm-weak-meridian-angle-right_0_0': 326,
        '5099_3mm-weak-meridian-right_0_0': 327, '5115_3mm-cylindrical-power-angle-right_0_0': 328,
        '2887_Number-of-cigarettes-previously-smoked-daily_0_0': 329, '5135_3mm-strong-meridian-left_0_1': 330,
        '5119_3mm-cylindrical-power-left_0_1': 331, '5104_3mm-strong-meridian-angle-left_0_1': 332,
        '5103_3mm-weak-meridian-angle-left_0_1': 333, '5096_3mm-weak-meridian-left_0_1': 334,
        '5112_3mm-cylindrical-power-angle-left_0_1': 335, '5160_3mm-regularity-index-right_0_0': 336,
        '5159_3mm-asymmetry-index-right_0_0': 337, '5108_3mm-asymmetry-angle-right_0_0': 338,
        '5132_3mm-strong-meridian-right_0_1': 339, '5116_3mm-cylindrical-power-right_0_1': 340,
        '5107_3mm-strong-meridian-angle-right_0_1': 341, '5100_3mm-weak-meridian-angle-right_0_1': 342,
        '5099_3mm-weak-meridian-right_0_1': 343, '3546_Age-last-used-hormonereplacement-therapy-HRT_0_0': 344,
        '3536_Age-started-hormonereplacement-therapy-HRT_0_0': 345,
        '5115_3mm-cylindrical-power-angle-right_0_1': 346, '90013_Standard-deviation-of-acceleration_0_0': 347,
        '90012_Overall-acceleration-average_0_0': 348, '5163_3mm-regularity-index-left_0_0': 349,
        '5156_3mm-asymmetry-index-left_0_0': 350, '5111_3mm-asymmetry-angle-left_0_0': 351,
        '5160_3mm-regularity-index-right_0_1': 352, '5159_3mm-asymmetry-index-right_0_1': 353,
        '5108_3mm-asymmetry-angle-right_0_1': 354, '5163_3mm-regularity-index-left_0_1': 355,
        '5156_3mm-asymmetry-index-left_0_1': 356, '5111_3mm-asymmetry-angle-left_0_1': 357,
        '5078_logMAR-in-round-left_0_1': 358, '5077_Number-of-letters-correct-in-round-left_0_1': 359,
        '5074_Number-of-letters-shown-in-round-left_0_1': 360, '5135_3mm-strong-meridian-left_0_2': 361,
        '5119_3mm-cylindrical-power-left_0_2': 362, '5104_3mm-strong-meridian-angle-left_0_2': 363,
        '5103_3mm-weak-meridian-angle-left_0_2': 364, '5096_3mm-weak-meridian-left_0_2': 365,
        '5079_logMAR-in-round-right_0_1': 366, '5076_Number-of-letters-correct-in-round-right_0_1': 367,
        '5075_Number-of-letters-shown-in-round-right_0_1': 368,
        '5112_3mm-cylindrical-power-angle-left_0_2': 369, '5163_3mm-regularity-index-left_0_2': 370,
        '5156_3mm-asymmetry-index-left_0_2': 371, '5111_3mm-asymmetry-angle-left_0_2': 372,
        '5132_3mm-strong-meridian-right_0_2': 373, '5116_3mm-cylindrical-power-right_0_2': 374,
        '5107_3mm-strong-meridian-angle-right_0_2': 375, '5100_3mm-weak-meridian-angle-right_0_2': 376,
        '5099_3mm-weak-meridian-right_0_2': 377, '5115_3mm-cylindrical-power-angle-right_0_2': 378,
        '5306_6mm-index-of-best-keratometry-results-left_0_0': 379, '5134_6mm-strong-meridian-left_0_0': 380,
        '5118_6mm-cylindrical-power-left_0_0': 381, '5113_6mm-cylindrical-power-angle-left_0_0': 382,
        '5105_6mm-strong-meridian-angle-left_0_0': 383, '5102_6mm-weak-meridian-angle-left_0_0': 384,
        '5097_6mm-weak-meridian-left_0_0': 385, '5251_6mm-index-of-best-keratometry-results-right_0_0': 386,
        '5133_6mm-strong-meridian-right_0_0': 387, '5117_6mm-cylindrical-power-right_0_0': 388,
        '5106_6mm-strong-meridian-angle-right_0_0': 389, '5101_6mm-weak-meridian-angle-right_0_0': 390,
        '5098_6mm-weak-meridian-right_0_0': 391, '5160_3mm-regularity-index-right_0_2': 392,
        '5159_3mm-asymmetry-index-right_0_2': 393, '5108_3mm-asymmetry-angle-right_0_2': 394,
        '5114_6mm-cylindrical-power-angle-right_0_0': 395, '22664_Year-gap-ended_0_0': 396,
        '22663_Year-gap-started_0_0': 397, '40009_Reported-occurrences-of-cancer_0_0': 398,
        '40008_Age-at-cancer-diagnosis_0_0': 399, '5134_6mm-strong-meridian-left_0_1': 400,
        '5118_6mm-cylindrical-power-left_0_1': 401, '5113_6mm-cylindrical-power-angle-left_0_1': 402,
        '5105_6mm-strong-meridian-angle-left_0_1': 403, '5102_6mm-weak-meridian-angle-left_0_1': 404,
        '5097_6mm-weak-meridian-left_0_1': 405, '22603_Year-job-ended_0_1': 406,
        '22602_Year-job-started_0_1': 407, '5133_6mm-strong-meridian-right_0_1': 408,
        '5117_6mm-cylindrical-power-right_0_1': 409, '5114_6mm-cylindrical-power-angle-right_0_1': 410,
        '5106_6mm-strong-meridian-angle-right_0_1': 411, '5101_6mm-weak-meridian-angle-right_0_1': 412,
        '5098_6mm-weak-meridian-right_0_1': 413, '3849_Number-of-pregnancy-terminations_0_0': 414,
        '3839_Number-of-spontaneous-miscarriages_0_0': 415, '3829_Number-of-stillbirths_0_0': 416,
        '6073_Duration-at-which-OCT-screen-shown-left_0_0': 417,
        '6071_Duration-at-which-OCT-screen-shown-right_0_0': 418, '6039_Duration-of-fitness-test_0_0': 419,
        '6038_Number-of-trend-entries_0_0': 420, '6033_Maximum-heart-rate-during-fitness-test_0_0': 421,
        '6032_Maximum-workload-during-fitness-test_0_0': 422, '5134_6mm-strong-meridian-left_0_2': 423,
        '5118_6mm-cylindrical-power-left_0_2': 424, '5113_6mm-cylindrical-power-angle-left_0_2': 425,
        '5105_6mm-strong-meridian-angle-left_0_2': 426, '5102_6mm-weak-meridian-angle-left_0_2': 427,
        '5097_6mm-weak-meridian-left_0_2': 428, '87_Noncancer-illness-yearage-first-occurred_0_3': 429,
        '20009_Interpolated-Age-of-participant-when-noncancer-illness-first-diagnosed_0_3': 430,
        '30800_Oestradiol_0_0': 431, '22603_Year-job-ended_0_2': 432, '22602_Year-job-started_0_2': 433,
        '5133_6mm-strong-meridian-right_0_2': 434, '5117_6mm-cylindrical-power-right_0_2': 435,
        '5106_6mm-strong-meridian-angle-right_0_2': 436, '5101_6mm-weak-meridian-angle-right_0_2': 437,
        '5098_6mm-weak-meridian-right_0_2': 438, '5114_6mm-cylindrical-power-angle-right_0_2': 439,
        '5078_logMAR-in-round-left_0_2': 440, '5077_Number-of-letters-correct-in-round-left_0_2': 441,
        '5074_Number-of-letters-shown-in-round-left_0_2': 442, '92_Operation-yearage-first-occurred_0_3': 443,
        '20011_Interpolated-Age-of-participant-when-operation-took-place_0_3': 444,
        '3710_Length-of-menstrual-cycle_0_0': 445, '3700_Time-since-last-menstrual-period_0_0': 446,
        '3809_Time-since-last-prostate-specific-antigen-PSA-test_0_0': 447,
        '5079_logMAR-in-round-right_0_2': 448, '5076_Number-of-letters-correct-in-round-right_0_2': 449,
        '5075_Number-of-letters-shown-in-round-right_0_2': 450, '3786_Age-asthma-diagnosed_0_0': 451,
        '5162_6mm-regularity-index-left_0_0': 452, '5157_6mm-asymmetry-index-left_0_0': 453,
        '5110_6mm-asymmetry-angle-left_0_0': 454, '5162_6mm-regularity-index-left_0_1': 455,
        '5157_6mm-asymmetry-index-left_0_1': 456, '5110_6mm-asymmetry-angle-left_0_1': 457,
        '2824_Age-at-hysterectomy_0_0': 458, '5161_6mm-regularity-index-right_0_1': 459,
        '5161_6mm-regularity-index-right_0_0': 460, '5158_6mm-asymmetry-index-right_0_1': 461,
        '5158_6mm-asymmetry-index-right_0_0': 462, '5109_6mm-asymmetry-angle-right_0_1': 463,
        '5109_6mm-asymmetry-angle-right_0_0': 464, '5162_6mm-regularity-index-left_0_2': 465,
        '5157_6mm-asymmetry-index-left_0_2': 466, '5110_6mm-asymmetry-angle-left_0_2': 467,
        '21003_Age-when-attended-assessment-centre_2_0': 468,
        '904_Number-of-daysweek-of-vigorous-physical-activity-10-minutes_2_0': 469,
        '884_Number-of-daysweek-of-moderate-physical-activity-10-minutes_2_0': 470,
        '864_Number-of-daysweek-walked-10-minutes_2_0': 471, '699_Length-of-time-at-current-address_2_0': 472,
        '2277_Frequency-of-solariumsunlamp-use_2_0': 473, '1528_Water-intake_2_0': 474,
        '1498_Coffee-intake_2_0': 475, '1488_Tea-intake_2_0': 476, '1458_Cereal-intake_2_0': 477,
        '1438_Bread-intake_2_0': 478, '1319_Dried-fruit-intake_2_0': 479, '1309_Fresh-fruit-intake_2_0': 480,
        '1299_Salad-raw-vegetable-intake_2_0': 481, '1289_Cooked-vegetable-intake_2_0': 482,
        '1090_Time-spent-driving_2_0': 483, '1080_Time-spent-using-computer_2_0': 484,
        '1070_Time-spent-watching-television-TV_2_0': 485, '1060_Time-spent-outdoors-in-winter_2_0': 486,
        '1050_Time-spend-outdoors-in-summer_2_0': 487, '709_Number-in-household_2_0': 488,
        '4272_Duration-of-hearing-test-left_2_0': 489, '4269_Number-of-triplets-attempted-left_2_0': 490,
        '874_Duration-of-walks_2_0': 491, '1883_Number-of-full-sisters_2_0': 492,
        '1873_Number-of-full-brothers_2_0': 493, '4279_Duration-of-hearing-test-right_2_0': 494,
        '4276_Number-of-triplets-attempted-right_2_0': 495,
        '1279_Exposure-to-tobacco-smoke-outside-home_2_0': 496,
        '1269_Exposure-to-tobacco-smoke-at-home_2_0': 497, '4285_Time-to-complete-test_0_0': 498,
        '4283_Number-of-rounds-of-numeric-memory-test-performed_0_0': 499,
        '4282_Maximum-digits-remembered-correctly_0_0': 500, '4260_Round-of-numeric-memory-test_0_2': 501,
        '4260_Round-of-numeric-memory-test_0_1': 502, '4260_Round-of-numeric-memory-test_0_0': 503,
        '4256_Time-elapsed_0_2': 504, '4256_Time-elapsed_0_1': 505, '4256_Time-elapsed_0_0': 506,
        '51_Seated-height_2_0': 507, '50_Standing-height_2_0': 508, '49_Hip-circumference_2_0': 509,
        '48_Waist-circumference_2_0': 510, '21002_Weight_2_0': 511, '20015_Sitting-height_2_0': 512,
        '4260_Round-of-numeric-memory-test_0_3': 513, '4256_Time-elapsed_0_3': 514,
        '47_Hand-grip-strength-right_2_0': 515, '46_Hand-grip-strength-left_2_0': 516,
        '21001_Body-mass-index-BMI_2_0': 517, '20019_Speechreceptionthreshold-SRT-estimate-left_2_0': 518,
        '4260_Round-of-numeric-memory-test_0_4': 519, '4256_Time-elapsed_0_4': 520,
        '20021_Speechreceptionthreshold-SRT-estimate-right_2_0': 521, '22603_Year-job-ended_0_3': 522,
        '22602_Year-job-started_0_3': 523, '23130_Trunk-predicted-mass_2_0': 524,
        '23129_Trunk-fatfree-mass_2_0': 525, '23128_Trunk-fat-mass_2_0': 526,
        '23127_Trunk-fat-percentage_2_0': 527, '23126_Arm-predicted-mass-left_2_0': 528,
        '23125_Arm-fatfree-mass-left_2_0': 529, '23124_Arm-fat-mass-left_2_0': 530,
        '23123_Arm-fat-percentage-left_2_0': 531, '23122_Arm-predicted-mass-right_2_0': 532,
        '23121_Arm-fatfree-mass-right_2_0': 533, '23120_Arm-fat-mass-right_2_0': 534,
        '23119_Arm-fat-percentage-right_2_0': 535, '23118_Leg-predicted-mass-left_2_0': 536,
        '23117_Leg-fatfree-mass-left_2_0': 537, '23116_Leg-fat-mass-left_2_0': 538,
        '23115_Leg-fat-percentage-left_2_0': 539, '23114_Leg-predicted-mass-right_2_0': 540,
        '23113_Leg-fatfree-mass-right_2_0': 541, '23112_Leg-fat-mass-right_2_0': 542,
        '23111_Leg-fat-percentage-right_2_0': 543, '23110_Impedance-of-arm-left_2_0': 544,
        '23109_Impedance-of-arm-right_2_0': 545, '23108_Impedance-of-leg-left_2_0': 546,
        '23107_Impedance-of-leg-right_2_0': 547, '23106_Impedance-of-whole-body_2_0': 548,
        '23105_Basal-metabolic-rate_2_0': 549, '23104_Body-mass-index-BMI_2_0': 550,
        '23102_Whole-body-water-mass_2_0': 551, '23101_Whole-body-fatfree-mass_2_0': 552,
        '23100_Whole-body-fat-mass_2_0': 553, '23099_Body-fat-percentage_2_0': 554, '23098_Weight_2_0': 555,
        '2217_Age-started-wearing-glasses-or-contact-lenses_2_0': 556, '4291_Number-of-attempts_2_0': 557,
        '4290_Duration-screen-displayed_2_0': 558, '4288_Time-to-answer_2_0': 559,
        '400_Time-to-complete-round_2_2': 560, '400_Time-to-complete-round_2_1': 561,
        '399_Number-of-incorrect-matches-in-round_2_2': 562,
        '399_Number-of-incorrect-matches-in-round_2_1': 563, '398_Number-of-correct-matches-in-round_2_2': 564,
        '398_Number-of-correct-matches-in-round_2_1': 565, '397_Number-of-rows-displayed-in-round_2_2': 566,
        '397_Number-of-rows-displayed-in-round_2_1': 567, '396_Number-of-columns-displayed-in-round_2_2': 568,
        '396_Number-of-columns-displayed-in-round_2_1': 569,
        '404_Duration-to-first-press-of-snapbutton-in-each-round_2_7': 570,
        '404_Duration-to-first-press-of-snapbutton-in-each-round_2_5': 571,
        '404_Duration-to-first-press-of-snapbutton-in-each-round_2_11': 572,
        '20023_Mean-time-to-correctly-identify-matches_2_0': 573,
        '3659_Year-immigrated-to-UK-United-Kingdom_0_0': 574,
        '20128_Number-of-fluid-intelligence-questions-attempted-within-time-limit_2_0': 575,
        '20016_Fluid-intelligence-score_2_0': 576,
        '404_Duration-to-first-press-of-snapbutton-in-each-round_2_10': 577,
        '4260_Round-of-numeric-memory-test_0_5': 578, '4256_Time-elapsed_0_5': 579,
        '5057_Number-of-older-siblings_2_0': 580, '137_Number-of-treatmentsmedications-taken_2_0': 581,
        '136_Number-of-operations-selfreported_2_0': 582,
        '135_Number-of-selfreported-noncancer-illnesses_2_0': 583,
        '134_Number-of-selfreported-cancers_2_0': 584, '22664_Year-gap-ended_0_1': 585,
        '22663_Year-gap-started_0_1': 586, '894_Duration-of-moderate-activity_2_0': 587,
        '5161_6mm-regularity-index-right_0_2': 588, '5158_6mm-asymmetry-index-right_0_2': 589,
        '5109_6mm-asymmetry-angle-right_0_2': 590, '3064_Peak-expiratory-flow-PEF_2_1': 591,
        '3064_Peak-expiratory-flow-PEF_2_0': 592, '3063_Forced-expiratory-volume-in-1second-FEV1_2_1': 593,
        '3063_Forced-expiratory-volume-in-1second-FEV1_2_0': 594, '3062_Forced-vital-capacity-FVC_2_1': 595,
        '3062_Forced-vital-capacity-FVC_2_0': 596, '1807_Fathers-age-at-death_2_0': 597,
        '87_Noncancer-illness-yearage-first-occurred_0_4': 598,
        '20009_Interpolated-Age-of-participant-when-noncancer-illness-first-diagnosed_0_4': 599,
        '12651_Duration-of-eprime-test_2_0': 600,
        '4200_Position-of-the-shoulder-on-the-pulse-waveform_2_0': 601,
        '4199_Position-of-pulse-wave-notch_2_0': 602, '4198_Position-of-the-pulse-wave-peak_2_0': 603,
        '4195_Pulse-wave-reflection-index_2_0': 604, '4194_Pulse-rate_2_0': 605,
        '4196_Pulse-wave-peak-to-peak-time_2_0': 606,
        '4462_Average-monthly-intake-of-other-alcoholic-drinks_0_0': 607,
        '4451_Average-monthly-fortified-wine-intake_0_0': 608, '4440_Average-monthly-spirits-intake_0_0': 609,
        '4429_Average-monthly-beer-plus-cider-intake_0_0': 610,
        '4418_Average-monthly-champagne-plus-white-wine-intake_0_0': 611,
        '4407_Average-monthly-red-wine-intake_0_0': 612, '21021_Pulse-wave-Arterial-Stiffness-index_2_0': 613,
        '84_Cancer-yearage-first-occurred_0_0': 614,
        '20007_Interpolated-Age-of-participant-when-cancer-first-diagnosed_0_0': 615,
        '12699_Number-of-PWA-tests-performed_2_0': 616, '12698_Diastolic-brachial-blood-pressure_2_0': 617,
        '12697_Systolic-brachial-blood-pressure_2_0': 618, '4260_Round-of-numeric-memory-test_0_6': 619,
        '4256_Time-elapsed_0_6': 620, '4080_Systolic-blood-pressure-automated-reading_2_0': 621,
        '4079_Diastolic-blood-pressure-automated-reading_2_0': 622,
        '102_Pulse-rate-automated-reading_2_0': 623, '12681_Augmentation-index-for-PWA_2_0': 624,
        '12679_Number-of-beats-in-waveform-average-for-PWA_2_0': 625, '12673_Heart-rate-during-PWA_2_0': 626,
        '3436_Age-started-smoking-in-current-smokers_0_0': 627,
        '12687_Mean-arterial-pressure-during-PWA_2_0': 628,
        '12685_Total-peripheral-resistance-during-PWA_2_0': 629,
        '12683_End-systolic-pressure-during-PWA_2_0': 630,
        '12680_Central-augmentation-pressure-during-PWA_2_0': 631,
        '12678_Central-pulse-pressure-during-PWA_2_0': 632,
        '12677_Central-systolic-blood-pressure-during-PWA_2_0': 633,
        '12676_Peripheral-pulse-pressure-during-PWA_2_0': 634,
        '12675_Diastolic-brachial-blood-pressure-during-PWA_2_0': 635,
        '12674_Systolic-brachial-blood-pressure-during-PWA_2_0': 636,
        '95_Pulse-rate-during-bloodpressure-measurement_0_1': 637,
        '94_Diastolic-blood-pressure-manual-reading_0_1': 638,
        '93_Systolic-blood-pressure-manual-reading_0_1': 639,
        '4080_Systolic-blood-pressure-automated-reading_2_1': 640,
        '4079_Diastolic-blood-pressure-automated-reading_2_1': 641,
        '102_Pulse-rate-automated-reading_2_1': 642, '12681_Augmentation-index-for-PWA_2_1': 643,
        '12679_Number-of-beats-in-waveform-average-for-PWA_2_1': 644, '12673_Heart-rate-during-PWA_2_1': 645,
        '3086_Speed-of-sound-through-heel-manual-entry_0_0': 646,
        '3085_Heel-Broadband-ultrasound-attenuation-BUA-manual-entry_0_0': 647,
        '3084_Heel-bone-mineral-density-BMD-manual-entry_0_0': 648,
        '3083_Heel-quantitative-ultrasound-index-QUI-manual-entry_0_0': 649,
        '12687_Mean-arterial-pressure-during-PWA_2_1': 650,
        '12685_Total-peripheral-resistance-during-PWA_2_1': 651,
        '12683_End-systolic-pressure-during-PWA_2_1': 652,
        '12680_Central-augmentation-pressure-during-PWA_2_1': 653,
        '12678_Central-pulse-pressure-during-PWA_2_1': 654,
        '12677_Central-systolic-blood-pressure-during-PWA_2_1': 655,
        '12676_Peripheral-pulse-pressure-during-PWA_2_1': 656,
        '12675_Diastolic-brachial-blood-pressure-during-PWA_2_1': 657,
        '12674_Systolic-brachial-blood-pressure-during-PWA_2_1': 658,
        '12686_Stroke-volume-during-PWA_2_0': 659, '12682_Cardiac-output-during-PWA_2_0': 660,
        '25920_Volume-of-grey-matter-in-X-Cerebellum-right_2_0': 661,
        '25919_Volume-of-grey-matter-in-X-Cerebellum-vermis_2_0': 662,
        '25918_Volume-of-grey-matter-in-X-Cerebellum-left_2_0': 663,
        '25917_Volume-of-grey-matter-in-IX-Cerebellum-right_2_0': 664,
        '25916_Volume-of-grey-matter-in-IX-Cerebellum-vermis_2_0': 665,
        '25915_Volume-of-grey-matter-in-IX-Cerebellum-left_2_0': 666,
        '25914_Volume-of-grey-matter-in-VIIIb-Cerebellum-right_2_0': 667,
        '25913_Volume-of-grey-matter-in-VIIIb-Cerebellum-vermis_2_0': 668,
        '25912_Volume-of-grey-matter-in-VIIIb-Cerebellum-left_2_0': 669,
        '25911_Volume-of-grey-matter-in-VIIIa-Cerebellum-right_2_0': 670,
        '25910_Volume-of-grey-matter-in-VIIIa-Cerebellum-vermis_2_0': 671,
        '25909_Volume-of-grey-matter-in-VIIIa-Cerebellum-left_2_0': 672,
        '25908_Volume-of-grey-matter-in-VIIb-Cerebellum-right_2_0': 673,
        '25907_Volume-of-grey-matter-in-VIIb-Cerebellum-vermis_2_0': 674,
        '25906_Volume-of-grey-matter-in-VIIb-Cerebellum-left_2_0': 675,
        '25905_Volume-of-grey-matter-in-Crus-II-Cerebellum-right_2_0': 676,
        '25904_Volume-of-grey-matter-in-Crus-II-Cerebellum-vermis_2_0': 677,
        '25903_Volume-of-grey-matter-in-Crus-II-Cerebellum-left_2_0': 678,
        '25902_Volume-of-grey-matter-in-Crus-I-Cerebellum-right_2_0': 679,
        '25901_Volume-of-grey-matter-in-Crus-I-Cerebellum-vermis_2_0': 680,
        '25900_Volume-of-grey-matter-in-Crus-I-Cerebellum-left_2_0': 681,
        '25899_Volume-of-grey-matter-in-VI-Cerebellum-right_2_0': 682,
        '25898_Volume-of-grey-matter-in-VI-Cerebellum-vermis_2_0': 683,
        '25897_Volume-of-grey-matter-in-VI-Cerebellum-left_2_0': 684,
        '25896_Volume-of-grey-matter-in-V-Cerebellum-right_2_0': 685,
        '25895_Volume-of-grey-matter-in-V-Cerebellum-left_2_0': 686,
        '25894_Volume-of-grey-matter-in-IIV-Cerebellum-right_2_0': 687,
        '25893_Volume-of-grey-matter-in-IIV-Cerebellum-left_2_0': 688,
        '25892_Volume-of-grey-matter-in-BrainStem_2_0': 689,
        '25891_Volume-of-grey-matter-in-Ventral-Striatum-right_2_0': 690,
        '25890_Volume-of-grey-matter-in-Ventral-Striatum-left_2_0': 691,
        '25889_Volume-of-grey-matter-in-Amygdala-right_2_0': 692,
        '25888_Volume-of-grey-matter-in-Amygdala-left_2_0': 693,
        '25887_Volume-of-grey-matter-in-Hippocampus-right_2_0': 694,
        '25886_Volume-of-grey-matter-in-Hippocampus-left_2_0': 695,
        '25885_Volume-of-grey-matter-in-Pallidum-right_2_0': 696,
        '25884_Volume-of-grey-matter-in-Pallidum-left_2_0': 697,
        '25883_Volume-of-grey-matter-in-Putamen-right_2_0': 698,
        '25882_Volume-of-grey-matter-in-Putamen-left_2_0': 699,
        '25881_Volume-of-grey-matter-in-Caudate-right_2_0': 700,
        '25880_Volume-of-grey-matter-in-Caudate-left_2_0': 701,
        '25879_Volume-of-grey-matter-in-Thalamus-right_2_0': 702,
        '25878_Volume-of-grey-matter-in-Thalamus-left_2_0': 703,
        '25877_Volume-of-grey-matter-in-Occipital-Pole-right_2_0': 704,
        '25876_Volume-of-grey-matter-in-Occipital-Pole-left_2_0': 705,
        '25875_Volume-of-grey-matter-in-Supracalcarine-Cortex-right_2_0': 706,
        '25874_Volume-of-grey-matter-in-Supracalcarine-Cortex-left_2_0': 707,
        '25873_Volume-of-grey-matter-in-Planum-Temporale-right_2_0': 708,
        '25872_Volume-of-grey-matter-in-Planum-Temporale-left_2_0': 709,
        '25871_Volume-of-grey-matter-in-Heschls-Gyrus-includes-H1-and-H2-right_2_0': 710,
        '25870_Volume-of-grey-matter-in-Heschls-Gyrus-includes-H1-and-H2-left_2_0': 711,
        '25869_Volume-of-grey-matter-in-Planum-Polare-right_2_0': 712,
        '25868_Volume-of-grey-matter-in-Planum-Polare-left_2_0': 713,
        '25867_Volume-of-grey-matter-in-Parietal-Operculum-Cortex-right_2_0': 714,
        '25866_Volume-of-grey-matter-in-Parietal-Operculum-Cortex-left_2_0': 715,
        '25865_Volume-of-grey-matter-in-Central-Opercular-Cortex-right_2_0': 716,
        '25864_Volume-of-grey-matter-in-Central-Opercular-Cortex-left_2_0': 717,
        '25863_Volume-of-grey-matter-in-Frontal-Operculum-Cortex-right_2_0': 718,
        '25862_Volume-of-grey-matter-in-Frontal-Operculum-Cortex-left_2_0': 719,
        '25861_Volume-of-grey-matter-in-Occipital-Fusiform-Gyrus-right_2_0': 720,
        '25860_Volume-of-grey-matter-in-Occipital-Fusiform-Gyrus-left_2_0': 721,
        '25859_Volume-of-grey-matter-in-Temporal-Occipital-Fusiform-Cortex-right_2_0': 722,
        '25858_Volume-of-grey-matter-in-Temporal-Occipital-Fusiform-Cortex-left_2_0': 723,
        '25857_Volume-of-grey-matter-in-Temporal-Fusiform-Cortex-posterior-division-right_2_0': 724,
        '25856_Volume-of-grey-matter-in-Temporal-Fusiform-Cortex-posterior-division-left_2_0': 725,
        '25855_Volume-of-grey-matter-in-Temporal-Fusiform-Cortex-anterior-division-right_2_0': 726,
        '25854_Volume-of-grey-matter-in-Temporal-Fusiform-Cortex-anterior-division-left_2_0': 727,
        '25853_Volume-of-grey-matter-in-Lingual-Gyrus-right_2_0': 728,
        '25852_Volume-of-grey-matter-in-Lingual-Gyrus-left_2_0': 729,
        '25851_Volume-of-grey-matter-in-Parahippocampal-Gyrus-posterior-division-right_2_0': 730,
        '25850_Volume-of-grey-matter-in-Parahippocampal-Gyrus-posterior-division-left_2_0': 731,
        '25849_Volume-of-grey-matter-in-Parahippocampal-Gyrus-anterior-division-right_2_0': 732,
        '25848_Volume-of-grey-matter-in-Parahippocampal-Gyrus-anterior-division-left_2_0': 733,
        '25847_Volume-of-grey-matter-in-Frontal-Orbital-Cortex-right_2_0': 734,
        '25846_Volume-of-grey-matter-in-Frontal-Orbital-Cortex-left_2_0': 735,
        '25845_Volume-of-grey-matter-in-Cuneal-Cortex-right_2_0': 736,
        '25844_Volume-of-grey-matter-in-Cuneal-Cortex-left_2_0': 737,
        '25843_Volume-of-grey-matter-in-Precuneous-Cortex-right_2_0': 738,
        '25842_Volume-of-grey-matter-in-Precuneous-Cortex-left_2_0': 739,
        '25841_Volume-of-grey-matter-in-Cingulate-Gyrus-posterior-division-right_2_0': 740,
        '25840_Volume-of-grey-matter-in-Cingulate-Gyrus-posterior-division-left_2_0': 741,
        '25839_Volume-of-grey-matter-in-Cingulate-Gyrus-anterior-division-right_2_0': 742,
        '25838_Volume-of-grey-matter-in-Cingulate-Gyrus-anterior-division-left_2_0': 743,
        '25837_Volume-of-grey-matter-in-Paracingulate-Gyrus-right_2_0': 744,
        '25836_Volume-of-grey-matter-in-Paracingulate-Gyrus-left_2_0': 745,
        '25835_Volume-of-grey-matter-in-Subcallosal-Cortex-right_2_0': 746,
        '25834_Volume-of-grey-matter-in-Subcallosal-Cortex-left_2_0': 747,
        '25833_Volume-of-grey-matter-in-Juxtapositional-Lobule-Cortex-formerly-Supplementary-Motor-Cortex-right_2_0': 748,
        '25832_Volume-of-grey-matter-in-Juxtapositional-Lobule-Cortex-formerly-Supplementary-Motor-Cortex-left_2_0': 749,
        '25831_Volume-of-grey-matter-in-Frontal-Medial-Cortex-right_2_0': 750,
        '25830_Volume-of-grey-matter-in-Frontal-Medial-Cortex-left_2_0': 751,
        '25829_Volume-of-grey-matter-in-Intracalcarine-Cortex-right_2_0': 752,
        '25828_Volume-of-grey-matter-in-Intracalcarine-Cortex-left_2_0': 753,
        '25827_Volume-of-grey-matter-in-Lateral-Occipital-Cortex-inferior-division-right_2_0': 754,
        '25826_Volume-of-grey-matter-in-Lateral-Occipital-Cortex-inferior-division-left_2_0': 755,
        '25825_Volume-of-grey-matter-in-Lateral-Occipital-Cortex-superior-division-right_2_0': 756,
        '25824_Volume-of-grey-matter-in-Lateral-Occipital-Cortex-superior-division-left_2_0': 757,
        '25823_Volume-of-grey-matter-in-Angular-Gyrus-right_2_0': 758,
        '25822_Volume-of-grey-matter-in-Angular-Gyrus-left_2_0': 759,
        '25821_Volume-of-grey-matter-in-Supramarginal-Gyrus-posterior-division-right_2_0': 760,
        '25820_Volume-of-grey-matter-in-Supramarginal-Gyrus-posterior-division-left_2_0': 761,
        '25819_Volume-of-grey-matter-in-Supramarginal-Gyrus-anterior-division-right_2_0': 762,
        '25818_Volume-of-grey-matter-in-Supramarginal-Gyrus-anterior-division-left_2_0': 763,
        '25817_Volume-of-grey-matter-in-Superior-Parietal-Lobule-right_2_0': 764,
        '25816_Volume-of-grey-matter-in-Superior-Parietal-Lobule-left_2_0': 765,
        '25815_Volume-of-grey-matter-in-Postcentral-Gyrus-right_2_0': 766,
        '25814_Volume-of-grey-matter-in-Postcentral-Gyrus-left_2_0': 767,
        '25813_Volume-of-grey-matter-in-Inferior-Temporal-Gyrus-temporooccipital-part-right_2_0': 768,
        '25812_Volume-of-grey-matter-in-Inferior-Temporal-Gyrus-temporooccipital-part-left_2_0': 769,
        '25811_Volume-of-grey-matter-in-Inferior-Temporal-Gyrus-posterior-division-right_2_0': 770,
        '25810_Volume-of-grey-matter-in-Inferior-Temporal-Gyrus-posterior-division-left_2_0': 771,
        '25809_Volume-of-grey-matter-in-Inferior-Temporal-Gyrus-anterior-division-right_2_0': 772,
        '25808_Volume-of-grey-matter-in-Inferior-Temporal-Gyrus-anterior-division-left_2_0': 773,
        '25807_Volume-of-grey-matter-in-Middle-Temporal-Gyrus-temporooccipital-part-right_2_0': 774,
        '25806_Volume-of-grey-matter-in-Middle-Temporal-Gyrus-temporooccipital-part-left_2_0': 775,
        '25805_Volume-of-grey-matter-in-Middle-Temporal-Gyrus-posterior-division-right_2_0': 776,
        '25804_Volume-of-grey-matter-in-Middle-Temporal-Gyrus-posterior-division-left_2_0': 777,
        '25803_Volume-of-grey-matter-in-Middle-Temporal-Gyrus-anterior-division-right_2_0': 778,
        '25802_Volume-of-grey-matter-in-Middle-Temporal-Gyrus-anterior-division-left_2_0': 779,
        '25801_Volume-of-grey-matter-in-Superior-Temporal-Gyrus-posterior-division-right_2_0': 780,
        '25800_Volume-of-grey-matter-in-Superior-Temporal-Gyrus-posterior-division-left_2_0': 781,
        '25799_Volume-of-grey-matter-in-Superior-Temporal-Gyrus-anterior-division-right_2_0': 782,
        '25798_Volume-of-grey-matter-in-Superior-Temporal-Gyrus-anterior-division-left_2_0': 783,
        '25797_Volume-of-grey-matter-in-Temporal-Pole-right_2_0': 784,
        '25796_Volume-of-grey-matter-in-Temporal-Pole-left_2_0': 785,
        '25795_Volume-of-grey-matter-in-Precentral-Gyrus-right_2_0': 786,
        '25794_Volume-of-grey-matter-in-Precentral-Gyrus-left_2_0': 787,
        '25793_Volume-of-grey-matter-in-Inferior-Frontal-Gyrus-pars-opercularis-right_2_0': 788,
        '25792_Volume-of-grey-matter-in-Inferior-Frontal-Gyrus-pars-opercularis-left_2_0': 789,
        '25791_Volume-of-grey-matter-in-Inferior-Frontal-Gyrus-pars-triangularis-right_2_0': 790,
        '25790_Volume-of-grey-matter-in-Inferior-Frontal-Gyrus-pars-triangularis-left_2_0': 791,
        '25789_Volume-of-grey-matter-in-Middle-Frontal-Gyrus-right_2_0': 792,
        '25788_Volume-of-grey-matter-in-Middle-Frontal-Gyrus-left_2_0': 793,
        '25787_Volume-of-grey-matter-in-Superior-Frontal-Gyrus-right_2_0': 794,
        '25786_Volume-of-grey-matter-in-Superior-Frontal-Gyrus-left_2_0': 795,
        '25785_Volume-of-grey-matter-in-Insular-Cortex-right_2_0': 796,
        '25784_Volume-of-grey-matter-in-Insular-Cortex-left_2_0': 797,
        '25783_Volume-of-grey-matter-in-Frontal-Pole-right_2_0': 798,
        '25782_Volume-of-grey-matter-in-Frontal-Pole-left_2_0': 799,
        '25735_Inverted-contrasttonoise-ratio-in-T1_2_0': 800,
        '25734_Inverted-signaltonoise-ratio-in-T1_2_0': 801,
        '25732_Discrepancy-between-T1-brain-image-and-standardspace-brain-template-nonlinearlyaligned_2_0': 802,
        '25731_Discrepancy-between-T1-brain-image-and-standardspace-brain-template-linearlyaligned_2_0': 803,
        '25025_Volume-of-brain-stem-4th-ventricle_2_0': 804, '25024_Volume-of-accumbens-right_2_0': 805,
        '25023_Volume-of-accumbens-left_2_0': 806, '25022_Volume-of-amygdala-right_2_0': 807,
        '25021_Volume-of-amygdala-left_2_0': 808, '25020_Volume-of-hippocampus-right_2_0': 809,
        '25019_Volume-of-hippocampus-left_2_0': 810, '25018_Volume-of-pallidum-right_2_0': 811,
        '25017_Volume-of-pallidum-left_2_0': 812, '25016_Volume-of-putamen-right_2_0': 813,
        '25015_Volume-of-putamen-left_2_0': 814, '25014_Volume-of-caudate-right_2_0': 815,
        '25013_Volume-of-caudate-left_2_0': 816, '25012_Volume-of-thalamus-right_2_0': 817,
        '25011_Volume-of-thalamus-left_2_0': 818, '25010_Volume-of-brain-greywhite-matter_2_0': 819,
        '25009_Volume-of-brain-greywhite-matter-normalised-for-head-size_2_0': 820,
        '25008_Volume-of-white-matter_2_0': 821,
        '25007_Volume-of-white-matter-normalised-for-head-size_2_0': 822,
        '25006_Volume-of-grey-matter_2_0': 823,
        '25005_Volume-of-grey-matter-normalised-for-head-size_2_0': 824,
        '25004_Volume-of-ventricular-cerebrospinal-fluid_2_0': 825,
        '25003_Volume-of-ventricular-cerebrospinal-fluid-normalised-for-head-size_2_0': 826,
        '25002_Volume-of-peripheral-cortical-grey-matter_2_0': 827,
        '25001_Volume-of-peripheral-cortical-grey-matter-normalised-for-head-size_2_0': 828,
        '25000_Volumetric-scaling-from-T1-head-image-to-standard-space_2_0': 829,
        '12684_End-systolic-pressure-index-during-PWA_2_0': 830,
        '3456_Number-of-cigarettes-currently-smoked-daily-current-cigarette-smokers_0_0': 831,
        '25781_Total-volume-of-white-matter-hyperintensities-from-T1-and-T2FLAIR-images_2_0': 832,
        '25739_Discrepancy-between-rfMRI-brain-image-and-T1-brain-image_2_0': 833,
        '25737_Discrepancy-between-dMRI-brain-image-and-T1-brain-image_2_0': 834,
        '25736_Discrepancy-between-T2-FLAIR-brain-image-and-T1-brain-image_2_0': 835,
        '12686_Stroke-volume-during-PWA_2_1': 836, '12682_Cardiac-output-during-PWA_2_1': 837,
        '12702_Cardiac-index-during-PWA_2_0': 838, '12684_End-systolic-pressure-index-during-PWA_2_1': 839,
        '87_Noncancer-illness-yearage-first-occurred_2_0': 840,
        '25730_Weightedmean-ISOVF-in-tract-uncinate-fasciculus-right_2_0': 841,
        '25729_Weightedmean-ISOVF-in-tract-uncinate-fasciculus-left_2_0': 842,
        '25728_Weightedmean-ISOVF-in-tract-superior-thalamic-radiation-right_2_0': 843,
        '25727_Weightedmean-ISOVF-in-tract-superior-thalamic-radiation-left_2_0': 844,
        '25726_Weightedmean-ISOVF-in-tract-superior-longitudinal-fasciculus-right_2_0': 845,
        '25725_Weightedmean-ISOVF-in-tract-superior-longitudinal-fasciculus-left_2_0': 846,
        '25724_Weightedmean-ISOVF-in-tract-posterior-thalamic-radiation-right_2_0': 847,
        '25723_Weightedmean-ISOVF-in-tract-posterior-thalamic-radiation-left_2_0': 848,
        '25722_Weightedmean-ISOVF-in-tract-medial-lemniscus-right_2_0': 849,
        '25721_Weightedmean-ISOVF-in-tract-medial-lemniscus-left_2_0': 850,
        '25720_Weightedmean-ISOVF-in-tract-middle-cerebellar-peduncle_2_0': 851,
        '25719_Weightedmean-ISOVF-in-tract-inferior-longitudinal-fasciculus-right_2_0': 852,
        '25718_Weightedmean-ISOVF-in-tract-inferior-longitudinal-fasciculus-left_2_0': 853,
        '25717_Weightedmean-ISOVF-in-tract-inferior-frontooccipital-fasciculus-right_2_0': 854,
        '25716_Weightedmean-ISOVF-in-tract-inferior-frontooccipital-fasciculus-left_2_0': 855,
        '25715_Weightedmean-ISOVF-in-tract-forceps-minor_2_0': 856,
        '25714_Weightedmean-ISOVF-in-tract-forceps-major_2_0': 857,
        '25713_Weightedmean-ISOVF-in-tract-corticospinal-tract-right_2_0': 858,
        '25712_Weightedmean-ISOVF-in-tract-corticospinal-tract-left_2_0': 859,
        '25711_Weightedmean-ISOVF-in-tract-parahippocampal-part-of-cingulum-right_2_0': 860,
        '25710_Weightedmean-ISOVF-in-tract-parahippocampal-part-of-cingulum-left_2_0': 861,
        '25709_Weightedmean-ISOVF-in-tract-cingulate-gyrus-part-of-cingulum-right_2_0': 862,
        '25708_Weightedmean-ISOVF-in-tract-cingulate-gyrus-part-of-cingulum-left_2_0': 863,
        '25707_Weightedmean-ISOVF-in-tract-anterior-thalamic-radiation-right_2_0': 864,
        '25706_Weightedmean-ISOVF-in-tract-anterior-thalamic-radiation-left_2_0': 865,
        '25705_Weightedmean-ISOVF-in-tract-acoustic-radiation-right_2_0': 866,
        '25704_Weightedmean-ISOVF-in-tract-acoustic-radiation-left_2_0': 867,
        '25703_Weightedmean-OD-in-tract-uncinate-fasciculus-right_2_0': 868,
        '25702_Weightedmean-OD-in-tract-uncinate-fasciculus-left_2_0': 869,
        '25701_Weightedmean-OD-in-tract-superior-thalamic-radiation-right_2_0': 870,
        '25700_Weightedmean-OD-in-tract-superior-thalamic-radiation-left_2_0': 871,
        '25699_Weightedmean-OD-in-tract-superior-longitudinal-fasciculus-right_2_0': 872,
        '25698_Weightedmean-OD-in-tract-superior-longitudinal-fasciculus-left_2_0': 873,
        '25697_Weightedmean-OD-in-tract-posterior-thalamic-radiation-right_2_0': 874,
        '25696_Weightedmean-OD-in-tract-posterior-thalamic-radiation-left_2_0': 875,
        '25695_Weightedmean-OD-in-tract-medial-lemniscus-right_2_0': 876,
        '25694_Weightedmean-OD-in-tract-medial-lemniscus-left_2_0': 877,
        '25693_Weightedmean-OD-in-tract-middle-cerebellar-peduncle_2_0': 878,
        '25692_Weightedmean-OD-in-tract-inferior-longitudinal-fasciculus-right_2_0': 879,
        '25691_Weightedmean-OD-in-tract-inferior-longitudinal-fasciculus-left_2_0': 880,
        '25690_Weightedmean-OD-in-tract-inferior-frontooccipital-fasciculus-right_2_0': 881,
        '25689_Weightedmean-OD-in-tract-inferior-frontooccipital-fasciculus-left_2_0': 882,
        '25688_Weightedmean-OD-in-tract-forceps-minor_2_0': 883,
        '25687_Weightedmean-OD-in-tract-forceps-major_2_0': 884,
        '25686_Weightedmean-OD-in-tract-corticospinal-tract-right_2_0': 885,
        '25685_Weightedmean-OD-in-tract-corticospinal-tract-left_2_0': 886,
        '25684_Weightedmean-OD-in-tract-parahippocampal-part-of-cingulum-right_2_0': 887,
        '25683_Weightedmean-OD-in-tract-parahippocampal-part-of-cingulum-left_2_0': 888,
        '25682_Weightedmean-OD-in-tract-cingulate-gyrus-part-of-cingulum-right_2_0': 889,
        '25681_Weightedmean-OD-in-tract-cingulate-gyrus-part-of-cingulum-left_2_0': 890,
        '25680_Weightedmean-OD-in-tract-anterior-thalamic-radiation-right_2_0': 891,
        '25679_Weightedmean-OD-in-tract-anterior-thalamic-radiation-left_2_0': 892,
        '25678_Weightedmean-OD-in-tract-acoustic-radiation-right_2_0': 893,
        '25677_Weightedmean-OD-in-tract-acoustic-radiation-left_2_0': 894,
        '25676_Weightedmean-ICVF-in-tract-uncinate-fasciculus-right_2_0': 895,
        '25675_Weightedmean-ICVF-in-tract-uncinate-fasciculus-left_2_0': 896,
        '25674_Weightedmean-ICVF-in-tract-superior-thalamic-radiation-right_2_0': 897,
        '25673_Weightedmean-ICVF-in-tract-superior-thalamic-radiation-left_2_0': 898,
        '25672_Weightedmean-ICVF-in-tract-superior-longitudinal-fasciculus-right_2_0': 899,
        '25671_Weightedmean-ICVF-in-tract-superior-longitudinal-fasciculus-left_2_0': 900,
        '25670_Weightedmean-ICVF-in-tract-posterior-thalamic-radiation-right_2_0': 901,
        '25669_Weightedmean-ICVF-in-tract-posterior-thalamic-radiation-left_2_0': 902,
        '25668_Weightedmean-ICVF-in-tract-medial-lemniscus-right_2_0': 903,
        '25667_Weightedmean-ICVF-in-tract-medial-lemniscus-left_2_0': 904,
        '25666_Weightedmean-ICVF-in-tract-middle-cerebellar-peduncle_2_0': 905,
        '25665_Weightedmean-ICVF-in-tract-inferior-longitudinal-fasciculus-right_2_0': 906,
        '25664_Weightedmean-ICVF-in-tract-inferior-longitudinal-fasciculus-left_2_0': 907,
        '25663_Weightedmean-ICVF-in-tract-inferior-frontooccipital-fasciculus-right_2_0': 908,
        '25662_Weightedmean-ICVF-in-tract-inferior-frontooccipital-fasciculus-left_2_0': 909,
        '25661_Weightedmean-ICVF-in-tract-forceps-minor_2_0': 910,
        '25660_Weightedmean-ICVF-in-tract-forceps-major_2_0': 911,
        '25659_Weightedmean-ICVF-in-tract-corticospinal-tract-right_2_0': 912,
        '25658_Weightedmean-ICVF-in-tract-corticospinal-tract-left_2_0': 913,
        '25657_Weightedmean-ICVF-in-tract-parahippocampal-part-of-cingulum-right_2_0': 914,
        '25656_Weightedmean-ICVF-in-tract-parahippocampal-part-of-cingulum-left_2_0': 915,
        '25655_Weightedmean-ICVF-in-tract-cingulate-gyrus-part-of-cingulum-right_2_0': 916,
        '25654_Weightedmean-ICVF-in-tract-cingulate-gyrus-part-of-cingulum-left_2_0': 917,
        '25653_Weightedmean-ICVF-in-tract-anterior-thalamic-radiation-right_2_0': 918,
        '25652_Weightedmean-ICVF-in-tract-anterior-thalamic-radiation-left_2_0': 919,
        '25651_Weightedmean-ICVF-in-tract-acoustic-radiation-right_2_0': 920,
        '25650_Weightedmean-ICVF-in-tract-acoustic-radiation-left_2_0': 921,
        '25649_Weightedmean-L3-in-tract-uncinate-fasciculus-right_2_0': 922,
        '25648_Weightedmean-L3-in-tract-uncinate-fasciculus-left_2_0': 923,
        '25647_Weightedmean-L3-in-tract-superior-thalamic-radiation-right_2_0': 924,
        '25646_Weightedmean-L3-in-tract-superior-thalamic-radiation-left_2_0': 925,
        '25645_Weightedmean-L3-in-tract-superior-longitudinal-fasciculus-right_2_0': 926,
        '25644_Weightedmean-L3-in-tract-superior-longitudinal-fasciculus-left_2_0': 927,
        '25643_Weightedmean-L3-in-tract-posterior-thalamic-radiation-right_2_0': 928,
        '25642_Weightedmean-L3-in-tract-posterior-thalamic-radiation-left_2_0': 929,
        '25641_Weightedmean-L3-in-tract-medial-lemniscus-right_2_0': 930,
        '25640_Weightedmean-L3-in-tract-medial-lemniscus-left_2_0': 931,
        '25639_Weightedmean-L3-in-tract-middle-cerebellar-peduncle_2_0': 932,
        '25638_Weightedmean-L3-in-tract-inferior-longitudinal-fasciculus-right_2_0': 933,
        '25637_Weightedmean-L3-in-tract-inferior-longitudinal-fasciculus-left_2_0': 934,
        '25636_Weightedmean-L3-in-tract-inferior-frontooccipital-fasciculus-right_2_0': 935,
        '25635_Weightedmean-L3-in-tract-inferior-frontooccipital-fasciculus-left_2_0': 936,
        '25634_Weightedmean-L3-in-tract-forceps-minor_2_0': 937,
        '25633_Weightedmean-L3-in-tract-forceps-major_2_0': 938,
        '25632_Weightedmean-L3-in-tract-corticospinal-tract-right_2_0': 939,
        '25631_Weightedmean-L3-in-tract-corticospinal-tract-left_2_0': 940,
        '25630_Weightedmean-L3-in-tract-parahippocampal-part-of-cingulum-right_2_0': 941,
        '25629_Weightedmean-L3-in-tract-parahippocampal-part-of-cingulum-left_2_0': 942,
        '25628_Weightedmean-L3-in-tract-cingulate-gyrus-part-of-cingulum-right_2_0': 943,
        '25627_Weightedmean-L3-in-tract-cingulate-gyrus-part-of-cingulum-left_2_0': 944,
        '25626_Weightedmean-L3-in-tract-anterior-thalamic-radiation-right_2_0': 945,
        '25625_Weightedmean-L3-in-tract-anterior-thalamic-radiation-left_2_0': 946,
        '25624_Weightedmean-L3-in-tract-acoustic-radiation-right_2_0': 947,
        '25623_Weightedmean-L3-in-tract-acoustic-radiation-left_2_0': 948,
        '25622_Weightedmean-L2-in-tract-uncinate-fasciculus-right_2_0': 949,
        '25621_Weightedmean-L2-in-tract-uncinate-fasciculus-left_2_0': 950,
        '25620_Weightedmean-L2-in-tract-superior-thalamic-radiation-right_2_0': 951,
        '25619_Weightedmean-L2-in-tract-superior-thalamic-radiation-left_2_0': 952,
        '25618_Weightedmean-L2-in-tract-superior-longitudinal-fasciculus-right_2_0': 953,
        '25617_Weightedmean-L2-in-tract-superior-longitudinal-fasciculus-left_2_0': 954,
        '25616_Weightedmean-L2-in-tract-posterior-thalamic-radiation-right_2_0': 955,
        '25615_Weightedmean-L2-in-tract-posterior-thalamic-radiation-left_2_0': 956,
        '25614_Weightedmean-L2-in-tract-medial-lemniscus-right_2_0': 957,
        '25613_Weightedmean-L2-in-tract-medial-lemniscus-left_2_0': 958,
        '25612_Weightedmean-L2-in-tract-middle-cerebellar-peduncle_2_0': 959,
        '25611_Weightedmean-L2-in-tract-inferior-longitudinal-fasciculus-right_2_0': 960,
        '25610_Weightedmean-L2-in-tract-inferior-longitudinal-fasciculus-left_2_0': 961,
        '25609_Weightedmean-L2-in-tract-inferior-frontooccipital-fasciculus-right_2_0': 962,
        '25608_Weightedmean-L2-in-tract-inferior-frontooccipital-fasciculus-left_2_0': 963,
        '25607_Weightedmean-L2-in-tract-forceps-minor_2_0': 964,
        '25606_Weightedmean-L2-in-tract-forceps-major_2_0': 965,
        '25605_Weightedmean-L2-in-tract-corticospinal-tract-right_2_0': 966,
        '25604_Weightedmean-L2-in-tract-corticospinal-tract-left_2_0': 967,
        '25603_Weightedmean-L2-in-tract-parahippocampal-part-of-cingulum-right_2_0': 968,
        '25602_Weightedmean-L2-in-tract-parahippocampal-part-of-cingulum-left_2_0': 969,
        '25601_Weightedmean-L2-in-tract-cingulate-gyrus-part-of-cingulum-right_2_0': 970,
        '25600_Weightedmean-L2-in-tract-cingulate-gyrus-part-of-cingulum-left_2_0': 971,
        '25599_Weightedmean-L2-in-tract-anterior-thalamic-radiation-right_2_0': 972,
        '25598_Weightedmean-L2-in-tract-anterior-thalamic-radiation-left_2_0': 973,
        '25597_Weightedmean-L2-in-tract-acoustic-radiation-right_2_0': 974,
        '25596_Weightedmean-L2-in-tract-acoustic-radiation-left_2_0': 975,
        '25595_Weightedmean-L1-in-tract-uncinate-fasciculus-right_2_0': 976,
        '25594_Weightedmean-L1-in-tract-uncinate-fasciculus-left_2_0': 977,
        '25593_Weightedmean-L1-in-tract-superior-thalamic-radiation-right_2_0': 978,
        '25592_Weightedmean-L1-in-tract-superior-thalamic-radiation-left_2_0': 979,
        '25591_Weightedmean-L1-in-tract-superior-longitudinal-fasciculus-right_2_0': 980,
        '25590_Weightedmean-L1-in-tract-superior-longitudinal-fasciculus-left_2_0': 981,
        '25589_Weightedmean-L1-in-tract-posterior-thalamic-radiation-right_2_0': 982,
        '25588_Weightedmean-L1-in-tract-posterior-thalamic-radiation-left_2_0': 983,
        '25587_Weightedmean-L1-in-tract-medial-lemniscus-right_2_0': 984,
        '25586_Weightedmean-L1-in-tract-medial-lemniscus-left_2_0': 985,
        '25585_Weightedmean-L1-in-tract-middle-cerebellar-peduncle_2_0': 986,
        '25584_Weightedmean-L1-in-tract-inferior-longitudinal-fasciculus-right_2_0': 987,
        '25583_Weightedmean-L1-in-tract-inferior-longitudinal-fasciculus-left_2_0': 988,
        '25582_Weightedmean-L1-in-tract-inferior-frontooccipital-fasciculus-right_2_0': 989,
        '25581_Weightedmean-L1-in-tract-inferior-frontooccipital-fasciculus-left_2_0': 990,
        '25580_Weightedmean-L1-in-tract-forceps-minor_2_0': 991,
        '25579_Weightedmean-L1-in-tract-forceps-major_2_0': 992,
        '25578_Weightedmean-L1-in-tract-corticospinal-tract-right_2_0': 993,
        '25577_Weightedmean-L1-in-tract-corticospinal-tract-left_2_0': 994,
        '25576_Weightedmean-L1-in-tract-parahippocampal-part-of-cingulum-right_2_0': 995,
        '25575_Weightedmean-L1-in-tract-parahippocampal-part-of-cingulum-left_2_0': 996,
        '25574_Weightedmean-L1-in-tract-cingulate-gyrus-part-of-cingulum-right_2_0': 997,
        '25573_Weightedmean-L1-in-tract-cingulate-gyrus-part-of-cingulum-left_2_0': 998,
        '25572_Weightedmean-L1-in-tract-anterior-thalamic-radiation-right_2_0': 999,
        '25571_Weightedmean-L1-in-tract-anterior-thalamic-radiation-left_2_0': 1000,
        '25570_Weightedmean-L1-in-tract-acoustic-radiation-right_2_0': 1001,
        '25569_Weightedmean-L1-in-tract-acoustic-radiation-left_2_0': 1002,
        '25568_Weightedmean-MO-in-tract-uncinate-fasciculus-right_2_0': 1003,
        '25567_Weightedmean-MO-in-tract-uncinate-fasciculus-left_2_0': 1004,
        '25566_Weightedmean-MO-in-tract-superior-thalamic-radiation-right_2_0': 1005,
        '25565_Weightedmean-MO-in-tract-superior-thalamic-radiation-left_2_0': 1006,
        '25564_Weightedmean-MO-in-tract-superior-longitudinal-fasciculus-right_2_0': 1007,
        '25563_Weightedmean-MO-in-tract-superior-longitudinal-fasciculus-left_2_0': 1008,
        '25562_Weightedmean-MO-in-tract-posterior-thalamic-radiation-right_2_0': 1009,
        '25561_Weightedmean-MO-in-tract-posterior-thalamic-radiation-left_2_0': 1010,
        '25560_Weightedmean-MO-in-tract-medial-lemniscus-right_2_0': 1011,
        '25559_Weightedmean-MO-in-tract-medial-lemniscus-left_2_0': 1012,
        '25558_Weightedmean-MO-in-tract-middle-cerebellar-peduncle_2_0': 1013,
        '25557_Weightedmean-MO-in-tract-inferior-longitudinal-fasciculus-right_2_0': 1014,
        '25556_Weightedmean-MO-in-tract-inferior-longitudinal-fasciculus-left_2_0': 1015,
        '25555_Weightedmean-MO-in-tract-inferior-frontooccipital-fasciculus-right_2_0': 1016,
        '25554_Weightedmean-MO-in-tract-inferior-frontooccipital-fasciculus-left_2_0': 1017,
        '25553_Weightedmean-MO-in-tract-forceps-minor_2_0': 1018,
        '25552_Weightedmean-MO-in-tract-forceps-major_2_0': 1019,
        '25551_Weightedmean-MO-in-tract-corticospinal-tract-right_2_0': 1020,
        '25550_Weightedmean-MO-in-tract-corticospinal-tract-left_2_0': 1021,
        '25549_Weightedmean-MO-in-tract-parahippocampal-part-of-cingulum-right_2_0': 1022,
        '25548_Weightedmean-MO-in-tract-parahippocampal-part-of-cingulum-left_2_0': 1023,
        '25547_Weightedmean-MO-in-tract-cingulate-gyrus-part-of-cingulum-right_2_0': 1024,
        '25546_Weightedmean-MO-in-tract-cingulate-gyrus-part-of-cingulum-left_2_0': 1025,
        '25545_Weightedmean-MO-in-tract-anterior-thalamic-radiation-right_2_0': 1026,
        '25544_Weightedmean-MO-in-tract-anterior-thalamic-radiation-left_2_0': 1027,
        '25543_Weightedmean-MO-in-tract-acoustic-radiation-right_2_0': 1028,
        '25542_Weightedmean-MO-in-tract-acoustic-radiation-left_2_0': 1029,
        '25541_Weightedmean-MD-in-tract-uncinate-fasciculus-right_2_0': 1030,
        '25540_Weightedmean-MD-in-tract-uncinate-fasciculus-left_2_0': 1031,
        '25539_Weightedmean-MD-in-tract-superior-thalamic-radiation-right_2_0': 1032,
        '25538_Weightedmean-MD-in-tract-superior-thalamic-radiation-left_2_0': 1033,
        '25537_Weightedmean-MD-in-tract-superior-longitudinal-fasciculus-right_2_0': 1034,
        '25536_Weightedmean-MD-in-tract-superior-longitudinal-fasciculus-left_2_0': 1035,
        '25535_Weightedmean-MD-in-tract-posterior-thalamic-radiation-right_2_0': 1036,
        '25534_Weightedmean-MD-in-tract-posterior-thalamic-radiation-left_2_0': 1037,
        '25533_Weightedmean-MD-in-tract-medial-lemniscus-right_2_0': 1038,
        '25532_Weightedmean-MD-in-tract-medial-lemniscus-left_2_0': 1039,
        '25531_Weightedmean-MD-in-tract-middle-cerebellar-peduncle_2_0': 1040,
        '25530_Weightedmean-MD-in-tract-inferior-longitudinal-fasciculus-right_2_0': 1041,
        '25529_Weightedmean-MD-in-tract-inferior-longitudinal-fasciculus-left_2_0': 1042,
        '25528_Weightedmean-MD-in-tract-inferior-frontooccipital-fasciculus-right_2_0': 1043,
        '25527_Weightedmean-MD-in-tract-inferior-frontooccipital-fasciculus-left_2_0': 1044,
        '25526_Weightedmean-MD-in-tract-forceps-minor_2_0': 1045,
        '25525_Weightedmean-MD-in-tract-forceps-major_2_0': 1046,
        '25524_Weightedmean-MD-in-tract-corticospinal-tract-right_2_0': 1047,
        '25523_Weightedmean-MD-in-tract-corticospinal-tract-left_2_0': 1048,
        '25522_Weightedmean-MD-in-tract-parahippocampal-part-of-cingulum-right_2_0': 1049,
        '25521_Weightedmean-MD-in-tract-parahippocampal-part-of-cingulum-left_2_0': 1050,
        '25520_Weightedmean-MD-in-tract-cingulate-gyrus-part-of-cingulum-right_2_0': 1051,
        '25519_Weightedmean-MD-in-tract-cingulate-gyrus-part-of-cingulum-left_2_0': 1052,
        '25518_Weightedmean-MD-in-tract-anterior-thalamic-radiation-right_2_0': 1053,
        '25517_Weightedmean-MD-in-tract-anterior-thalamic-radiation-left_2_0': 1054,
        '25516_Weightedmean-MD-in-tract-acoustic-radiation-right_2_0': 1055,
        '25515_Weightedmean-MD-in-tract-acoustic-radiation-left_2_0': 1056,
        '25514_Weightedmean-FA-in-tract-uncinate-fasciculus-right_2_0': 1057,
        '25513_Weightedmean-FA-in-tract-uncinate-fasciculus-left_2_0': 1058,
        '25512_Weightedmean-FA-in-tract-superior-thalamic-radiation-right_2_0': 1059,
        '25511_Weightedmean-FA-in-tract-superior-thalamic-radiation-left_2_0': 1060,
        '25510_Weightedmean-FA-in-tract-superior-longitudinal-fasciculus-right_2_0': 1061,
        '25509_Weightedmean-FA-in-tract-superior-longitudinal-fasciculus-left_2_0': 1062,
        '25508_Weightedmean-FA-in-tract-posterior-thalamic-radiation-right_2_0': 1063,
        '25507_Weightedmean-FA-in-tract-posterior-thalamic-radiation-left_2_0': 1064,
        '25506_Weightedmean-FA-in-tract-medial-lemniscus-right_2_0': 1065,
        '25505_Weightedmean-FA-in-tract-medial-lemniscus-left_2_0': 1066,
        '25504_Weightedmean-FA-in-tract-middle-cerebellar-peduncle_2_0': 1067,
        '25503_Weightedmean-FA-in-tract-inferior-longitudinal-fasciculus-right_2_0': 1068,
        '25502_Weightedmean-FA-in-tract-inferior-longitudinal-fasciculus-left_2_0': 1069,
        '25501_Weightedmean-FA-in-tract-inferior-frontooccipital-fasciculus-right_2_0': 1070,
        '25500_Weightedmean-FA-in-tract-inferior-frontooccipital-fasciculus-left_2_0': 1071,
        '25499_Weightedmean-FA-in-tract-forceps-minor_2_0': 1072,
        '25498_Weightedmean-FA-in-tract-forceps-major_2_0': 1073,
        '25497_Weightedmean-FA-in-tract-corticospinal-tract-right_2_0': 1074,
        '25496_Weightedmean-FA-in-tract-corticospinal-tract-left_2_0': 1075,
        '25495_Weightedmean-FA-in-tract-parahippocampal-part-of-cingulum-right_2_0': 1076,
        '25494_Weightedmean-FA-in-tract-parahippocampal-part-of-cingulum-left_2_0': 1077,
        '25493_Weightedmean-FA-in-tract-cingulate-gyrus-part-of-cingulum-right_2_0': 1078,
        '25492_Weightedmean-FA-in-tract-cingulate-gyrus-part-of-cingulum-left_2_0': 1079,
        '25491_Weightedmean-FA-in-tract-anterior-thalamic-radiation-right_2_0': 1080,
        '25490_Weightedmean-FA-in-tract-anterior-thalamic-radiation-left_2_0': 1081,
        '25489_Weightedmean-FA-in-tract-acoustic-radiation-right_2_0': 1082,
        '25488_Weightedmean-FA-in-tract-acoustic-radiation-left_2_0': 1083,
        '25487_Mean-ISOVF-in-tapetum-on-FA-skeleton-left_2_0': 1084,
        '25486_Mean-ISOVF-in-tapetum-on-FA-skeleton-right_2_0': 1085,
        '25485_Mean-ISOVF-in-uncinate-fasciculus-on-FA-skeleton-left_2_0': 1086,
        '25484_Mean-ISOVF-in-uncinate-fasciculus-on-FA-skeleton-right_2_0': 1087,
        '25483_Mean-ISOVF-in-superior-frontooccipital-fasciculus-on-FA-skeleton-left_2_0': 1088,
        '25482_Mean-ISOVF-in-superior-frontooccipital-fasciculus-on-FA-skeleton-right_2_0': 1089,
        '25481_Mean-ISOVF-in-superior-longitudinal-fasciculus-on-FA-skeleton-left_2_0': 1090,
        '25480_Mean-ISOVF-in-superior-longitudinal-fasciculus-on-FA-skeleton-right_2_0': 1091,
        '25479_Mean-ISOVF-in-fornix-cresstria-terminalis-on-FA-skeleton-left_2_0': 1092,
        '25478_Mean-ISOVF-in-fornix-cresstria-terminalis-on-FA-skeleton-right_2_0': 1093,
        '25477_Mean-ISOVF-in-cingulum-hippocampus-on-FA-skeleton-left_2_0': 1094,
        '25476_Mean-ISOVF-in-cingulum-hippocampus-on-FA-skeleton-right_2_0': 1095,
        '25475_Mean-ISOVF-in-cingulum-cingulate-gyrus-on-FA-skeleton-left_2_0': 1096,
        '25474_Mean-ISOVF-in-cingulum-cingulate-gyrus-on-FA-skeleton-right_2_0': 1097,
        '25473_Mean-ISOVF-in-external-capsule-on-FA-skeleton-left_2_0': 1098,
        '25472_Mean-ISOVF-in-external-capsule-on-FA-skeleton-right_2_0': 1099,
        '25471_Mean-ISOVF-in-sagittal-stratum-on-FA-skeleton-left_2_0': 1100,
        '25470_Mean-ISOVF-in-sagittal-stratum-on-FA-skeleton-right_2_0': 1101,
        '25469_Mean-ISOVF-in-posterior-thalamic-radiation-on-FA-skeleton-left_2_0': 1102,
        '25468_Mean-ISOVF-in-posterior-thalamic-radiation-on-FA-skeleton-right_2_0': 1103,
        '25467_Mean-ISOVF-in-posterior-corona-radiata-on-FA-skeleton-left_2_0': 1104,
        '25466_Mean-ISOVF-in-posterior-corona-radiata-on-FA-skeleton-right_2_0': 1105,
        '25465_Mean-ISOVF-in-superior-corona-radiata-on-FA-skeleton-left_2_0': 1106,
        '25464_Mean-ISOVF-in-superior-corona-radiata-on-FA-skeleton-right_2_0': 1107,
        '25463_Mean-ISOVF-in-anterior-corona-radiata-on-FA-skeleton-left_2_0': 1108,
        '25462_Mean-ISOVF-in-anterior-corona-radiata-on-FA-skeleton-right_2_0': 1109,
        '25461_Mean-ISOVF-in-retrolenticular-part-of-internal-capsule-on-FA-skeleton-left_2_0': 1110,
        '25460_Mean-ISOVF-in-retrolenticular-part-of-internal-capsule-on-FA-skeleton-right_2_0': 1111,
        '25459_Mean-ISOVF-in-posterior-limb-of-internal-capsule-on-FA-skeleton-left_2_0': 1112,
        '25458_Mean-ISOVF-in-posterior-limb-of-internal-capsule-on-FA-skeleton-right_2_0': 1113,
        '25457_Mean-ISOVF-in-anterior-limb-of-internal-capsule-on-FA-skeleton-left_2_0': 1114,
        '25456_Mean-ISOVF-in-anterior-limb-of-internal-capsule-on-FA-skeleton-right_2_0': 1115,
        '25455_Mean-ISOVF-in-cerebral-peduncle-on-FA-skeleton-left_2_0': 1116,
        '25454_Mean-ISOVF-in-cerebral-peduncle-on-FA-skeleton-right_2_0': 1117,
        '25453_Mean-ISOVF-in-superior-cerebellar-peduncle-on-FA-skeleton-left_2_0': 1118,
        '25452_Mean-ISOVF-in-superior-cerebellar-peduncle-on-FA-skeleton-right_2_0': 1119,
        '25451_Mean-ISOVF-in-inferior-cerebellar-peduncle-on-FA-skeleton-left_2_0': 1120,
        '25450_Mean-ISOVF-in-inferior-cerebellar-peduncle-on-FA-skeleton-right_2_0': 1121,
        '25449_Mean-ISOVF-in-medial-lemniscus-on-FA-skeleton-left_2_0': 1122,
        '25448_Mean-ISOVF-in-medial-lemniscus-on-FA-skeleton-right_2_0': 1123,
        '25447_Mean-ISOVF-in-corticospinal-tract-on-FA-skeleton-left_2_0': 1124,
        '25446_Mean-ISOVF-in-corticospinal-tract-on-FA-skeleton-right_2_0': 1125,
        '25445_Mean-ISOVF-in-fornix-on-FA-skeleton_2_0': 1126,
        '25444_Mean-ISOVF-in-splenium-of-corpus-callosum-on-FA-skeleton_2_0': 1127,
        '25443_Mean-ISOVF-in-body-of-corpus-callosum-on-FA-skeleton_2_0': 1128,
        '25442_Mean-ISOVF-in-genu-of-corpus-callosum-on-FA-skeleton_2_0': 1129,
        '25441_Mean-ISOVF-in-pontine-crossing-tract-on-FA-skeleton_2_0': 1130,
        '25440_Mean-ISOVF-in-middle-cerebellar-peduncle-on-FA-skeleton_2_0': 1131,
        '25439_Mean-OD-in-tapetum-on-FA-skeleton-left_2_0': 1132,
        '25438_Mean-OD-in-tapetum-on-FA-skeleton-right_2_0': 1133,
        '25437_Mean-OD-in-uncinate-fasciculus-on-FA-skeleton-left_2_0': 1134,
        '25436_Mean-OD-in-uncinate-fasciculus-on-FA-skeleton-right_2_0': 1135,
        '25435_Mean-OD-in-superior-frontooccipital-fasciculus-on-FA-skeleton-left_2_0': 1136,
        '25434_Mean-OD-in-superior-frontooccipital-fasciculus-on-FA-skeleton-right_2_0': 1137,
        '25433_Mean-OD-in-superior-longitudinal-fasciculus-on-FA-skeleton-left_2_0': 1138,
        '25432_Mean-OD-in-superior-longitudinal-fasciculus-on-FA-skeleton-right_2_0': 1139,
        '25431_Mean-OD-in-fornix-cresstria-terminalis-on-FA-skeleton-left_2_0': 1140,
        '25430_Mean-OD-in-fornix-cresstria-terminalis-on-FA-skeleton-right_2_0': 1141,
        '25429_Mean-OD-in-cingulum-hippocampus-on-FA-skeleton-left_2_0': 1142,
        '25428_Mean-OD-in-cingulum-hippocampus-on-FA-skeleton-right_2_0': 1143,
        '25427_Mean-OD-in-cingulum-cingulate-gyrus-on-FA-skeleton-left_2_0': 1144,
        '25426_Mean-OD-in-cingulum-cingulate-gyrus-on-FA-skeleton-right_2_0': 1145,
        '25425_Mean-OD-in-external-capsule-on-FA-skeleton-left_2_0': 1146,
        '25424_Mean-OD-in-external-capsule-on-FA-skeleton-right_2_0': 1147,
        '25423_Mean-OD-in-sagittal-stratum-on-FA-skeleton-left_2_0': 1148,
        '25422_Mean-OD-in-sagittal-stratum-on-FA-skeleton-right_2_0': 1149,
        '25421_Mean-OD-in-posterior-thalamic-radiation-on-FA-skeleton-left_2_0': 1150,
        '25420_Mean-OD-in-posterior-thalamic-radiation-on-FA-skeleton-right_2_0': 1151,
        '25419_Mean-OD-in-posterior-corona-radiata-on-FA-skeleton-left_2_0': 1152,
        '25418_Mean-OD-in-posterior-corona-radiata-on-FA-skeleton-right_2_0': 1153,
        '25417_Mean-OD-in-superior-corona-radiata-on-FA-skeleton-left_2_0': 1154,
        '25416_Mean-OD-in-superior-corona-radiata-on-FA-skeleton-right_2_0': 1155,
        '25415_Mean-OD-in-anterior-corona-radiata-on-FA-skeleton-left_2_0': 1156,
        '25414_Mean-OD-in-anterior-corona-radiata-on-FA-skeleton-right_2_0': 1157,
        '25413_Mean-OD-in-retrolenticular-part-of-internal-capsule-on-FA-skeleton-left_2_0': 1158,
        '25412_Mean-OD-in-retrolenticular-part-of-internal-capsule-on-FA-skeleton-right_2_0': 1159,
        '25411_Mean-OD-in-posterior-limb-of-internal-capsule-on-FA-skeleton-left_2_0': 1160,
        '25410_Mean-OD-in-posterior-limb-of-internal-capsule-on-FA-skeleton-right_2_0': 1161,
        '25409_Mean-OD-in-anterior-limb-of-internal-capsule-on-FA-skeleton-left_2_0': 1162,
        '25408_Mean-OD-in-anterior-limb-of-internal-capsule-on-FA-skeleton-right_2_0': 1163,
        '25407_Mean-OD-in-cerebral-peduncle-on-FA-skeleton-left_2_0': 1164,
        '25406_Mean-OD-in-cerebral-peduncle-on-FA-skeleton-right_2_0': 1165,
        '25405_Mean-OD-in-superior-cerebellar-peduncle-on-FA-skeleton-left_2_0': 1166,
        '25404_Mean-OD-in-superior-cerebellar-peduncle-on-FA-skeleton-right_2_0': 1167,
        '25403_Mean-OD-in-inferior-cerebellar-peduncle-on-FA-skeleton-left_2_0': 1168,
        '25402_Mean-OD-in-inferior-cerebellar-peduncle-on-FA-skeleton-right_2_0': 1169,
        '25401_Mean-OD-in-medial-lemniscus-on-FA-skeleton-left_2_0': 1170,
        '25400_Mean-OD-in-medial-lemniscus-on-FA-skeleton-right_2_0': 1171,
        '25399_Mean-OD-in-corticospinal-tract-on-FA-skeleton-left_2_0': 1172,
        '25398_Mean-OD-in-corticospinal-tract-on-FA-skeleton-right_2_0': 1173,
        '25397_Mean-OD-in-fornix-on-FA-skeleton_2_0': 1174,
        '25396_Mean-OD-in-splenium-of-corpus-callosum-on-FA-skeleton_2_0': 1175,
        '25395_Mean-OD-in-body-of-corpus-callosum-on-FA-skeleton_2_0': 1176,
        '25394_Mean-OD-in-genu-of-corpus-callosum-on-FA-skeleton_2_0': 1177,
        '25393_Mean-OD-in-pontine-crossing-tract-on-FA-skeleton_2_0': 1178,
        '25392_Mean-OD-in-middle-cerebellar-peduncle-on-FA-skeleton_2_0': 1179,
        '25391_Mean-ICVF-in-tapetum-on-FA-skeleton-left_2_0': 1180,
        '25390_Mean-ICVF-in-tapetum-on-FA-skeleton-right_2_0': 1181,
        '25389_Mean-ICVF-in-uncinate-fasciculus-on-FA-skeleton-left_2_0': 1182,
        '25388_Mean-ICVF-in-uncinate-fasciculus-on-FA-skeleton-right_2_0': 1183,
        '25387_Mean-ICVF-in-superior-frontooccipital-fasciculus-on-FA-skeleton-left_2_0': 1184,
        '25386_Mean-ICVF-in-superior-frontooccipital-fasciculus-on-FA-skeleton-right_2_0': 1185,
        '25385_Mean-ICVF-in-superior-longitudinal-fasciculus-on-FA-skeleton-left_2_0': 1186,
        '25384_Mean-ICVF-in-superior-longitudinal-fasciculus-on-FA-skeleton-right_2_0': 1187,
        '25383_Mean-ICVF-in-fornix-cresstria-terminalis-on-FA-skeleton-left_2_0': 1188,
        '25382_Mean-ICVF-in-fornix-cresstria-terminalis-on-FA-skeleton-right_2_0': 1189,
        '25381_Mean-ICVF-in-cingulum-hippocampus-on-FA-skeleton-left_2_0': 1190,
        '25380_Mean-ICVF-in-cingulum-hippocampus-on-FA-skeleton-right_2_0': 1191,
        '25379_Mean-ICVF-in-cingulum-cingulate-gyrus-on-FA-skeleton-left_2_0': 1192,
        '25378_Mean-ICVF-in-cingulum-cingulate-gyrus-on-FA-skeleton-right_2_0': 1193,
        '25377_Mean-ICVF-in-external-capsule-on-FA-skeleton-left_2_0': 1194,
        '25376_Mean-ICVF-in-external-capsule-on-FA-skeleton-right_2_0': 1195,
        '25375_Mean-ICVF-in-sagittal-stratum-on-FA-skeleton-left_2_0': 1196,
        '25374_Mean-ICVF-in-sagittal-stratum-on-FA-skeleton-right_2_0': 1197,
        '25373_Mean-ICVF-in-posterior-thalamic-radiation-on-FA-skeleton-left_2_0': 1198,
        '25372_Mean-ICVF-in-posterior-thalamic-radiation-on-FA-skeleton-right_2_0': 1199,
        '25371_Mean-ICVF-in-posterior-corona-radiata-on-FA-skeleton-left_2_0': 1200,
        '25370_Mean-ICVF-in-posterior-corona-radiata-on-FA-skeleton-right_2_0': 1201,
        '25369_Mean-ICVF-in-superior-corona-radiata-on-FA-skeleton-left_2_0': 1202,
        '25368_Mean-ICVF-in-superior-corona-radiata-on-FA-skeleton-right_2_0': 1203,
        '25367_Mean-ICVF-in-anterior-corona-radiata-on-FA-skeleton-left_2_0': 1204,
        '25366_Mean-ICVF-in-anterior-corona-radiata-on-FA-skeleton-right_2_0': 1205,
        '25365_Mean-ICVF-in-retrolenticular-part-of-internal-capsule-on-FA-skeleton-left_2_0': 1206,
        '25364_Mean-ICVF-in-retrolenticular-part-of-internal-capsule-on-FA-skeleton-right_2_0': 1207,
        '25363_Mean-ICVF-in-posterior-limb-of-internal-capsule-on-FA-skeleton-left_2_0': 1208,
        '25362_Mean-ICVF-in-posterior-limb-of-internal-capsule-on-FA-skeleton-right_2_0': 1209,
        '25361_Mean-ICVF-in-anterior-limb-of-internal-capsule-on-FA-skeleton-left_2_0': 1210,
        '25360_Mean-ICVF-in-anterior-limb-of-internal-capsule-on-FA-skeleton-right_2_0': 1211,
        '25359_Mean-ICVF-in-cerebral-peduncle-on-FA-skeleton-left_2_0': 1212,
        '25358_Mean-ICVF-in-cerebral-peduncle-on-FA-skeleton-right_2_0': 1213,
        '25357_Mean-ICVF-in-superior-cerebellar-peduncle-on-FA-skeleton-left_2_0': 1214,
        '25356_Mean-ICVF-in-superior-cerebellar-peduncle-on-FA-skeleton-right_2_0': 1215,
        '25355_Mean-ICVF-in-inferior-cerebellar-peduncle-on-FA-skeleton-left_2_0': 1216,
        '25354_Mean-ICVF-in-inferior-cerebellar-peduncle-on-FA-skeleton-right_2_0': 1217,
        '25353_Mean-ICVF-in-medial-lemniscus-on-FA-skeleton-left_2_0': 1218,
        '25352_Mean-ICVF-in-medial-lemniscus-on-FA-skeleton-right_2_0': 1219,
        '25351_Mean-ICVF-in-corticospinal-tract-on-FA-skeleton-left_2_0': 1220,
        '25350_Mean-ICVF-in-corticospinal-tract-on-FA-skeleton-right_2_0': 1221,
        '25349_Mean-ICVF-in-fornix-on-FA-skeleton_2_0': 1222,
        '25348_Mean-ICVF-in-splenium-of-corpus-callosum-on-FA-skeleton_2_0': 1223,
        '25347_Mean-ICVF-in-body-of-corpus-callosum-on-FA-skeleton_2_0': 1224,
        '25346_Mean-ICVF-in-genu-of-corpus-callosum-on-FA-skeleton_2_0': 1225,
        '25345_Mean-ICVF-in-pontine-crossing-tract-on-FA-skeleton_2_0': 1226,
        '25344_Mean-ICVF-in-middle-cerebellar-peduncle-on-FA-skeleton_2_0': 1227,
        '25343_Mean-L3-in-tapetum-on-FA-skeleton-left_2_0': 1228,
        '25342_Mean-L3-in-tapetum-on-FA-skeleton-right_2_0': 1229,
        '25341_Mean-L3-in-uncinate-fasciculus-on-FA-skeleton-left_2_0': 1230,
        '25340_Mean-L3-in-uncinate-fasciculus-on-FA-skeleton-right_2_0': 1231,
        '25339_Mean-L3-in-superior-frontooccipital-fasciculus-on-FA-skeleton-left_2_0': 1232,
        '25338_Mean-L3-in-superior-frontooccipital-fasciculus-on-FA-skeleton-right_2_0': 1233,
        '25337_Mean-L3-in-superior-longitudinal-fasciculus-on-FA-skeleton-left_2_0': 1234,
        '25336_Mean-L3-in-superior-longitudinal-fasciculus-on-FA-skeleton-right_2_0': 1235,
        '25335_Mean-L3-in-fornix-cresstria-terminalis-on-FA-skeleton-left_2_0': 1236,
        '25334_Mean-L3-in-fornix-cresstria-terminalis-on-FA-skeleton-right_2_0': 1237,
        '25333_Mean-L3-in-cingulum-hippocampus-on-FA-skeleton-left_2_0': 1238,
        '25332_Mean-L3-in-cingulum-hippocampus-on-FA-skeleton-right_2_0': 1239,
        '25331_Mean-L3-in-cingulum-cingulate-gyrus-on-FA-skeleton-left_2_0': 1240,
        '25330_Mean-L3-in-cingulum-cingulate-gyrus-on-FA-skeleton-right_2_0': 1241,
        '25329_Mean-L3-in-external-capsule-on-FA-skeleton-left_2_0': 1242,
        '25328_Mean-L3-in-external-capsule-on-FA-skeleton-right_2_0': 1243,
        '25327_Mean-L3-in-sagittal-stratum-on-FA-skeleton-left_2_0': 1244,
        '25326_Mean-L3-in-sagittal-stratum-on-FA-skeleton-right_2_0': 1245,
        '25325_Mean-L3-in-posterior-thalamic-radiation-on-FA-skeleton-left_2_0': 1246,
        '25324_Mean-L3-in-posterior-thalamic-radiation-on-FA-skeleton-right_2_0': 1247,
        '25323_Mean-L3-in-posterior-corona-radiata-on-FA-skeleton-left_2_0': 1248,
        '25322_Mean-L3-in-posterior-corona-radiata-on-FA-skeleton-right_2_0': 1249,
        '25321_Mean-L3-in-superior-corona-radiata-on-FA-skeleton-left_2_0': 1250,
        '25320_Mean-L3-in-superior-corona-radiata-on-FA-skeleton-right_2_0': 1251,
        '25319_Mean-L3-in-anterior-corona-radiata-on-FA-skeleton-left_2_0': 1252,
        '25318_Mean-L3-in-anterior-corona-radiata-on-FA-skeleton-right_2_0': 1253,
        '25317_Mean-L3-in-retrolenticular-part-of-internal-capsule-on-FA-skeleton-left_2_0': 1254,
        '25316_Mean-L3-in-retrolenticular-part-of-internal-capsule-on-FA-skeleton-right_2_0': 1255,
        '25315_Mean-L3-in-posterior-limb-of-internal-capsule-on-FA-skeleton-left_2_0': 1256,
        '25314_Mean-L3-in-posterior-limb-of-internal-capsule-on-FA-skeleton-right_2_0': 1257,
        '25313_Mean-L3-in-anterior-limb-of-internal-capsule-on-FA-skeleton-left_2_0': 1258,
        '25312_Mean-L3-in-anterior-limb-of-internal-capsule-on-FA-skeleton-right_2_0': 1259,
        '25311_Mean-L3-in-cerebral-peduncle-on-FA-skeleton-left_2_0': 1260,
        '25310_Mean-L3-in-cerebral-peduncle-on-FA-skeleton-right_2_0': 1261,
        '25309_Mean-L3-in-superior-cerebellar-peduncle-on-FA-skeleton-left_2_0': 1262,
        '25308_Mean-L3-in-superior-cerebellar-peduncle-on-FA-skeleton-right_2_0': 1263,
        '25307_Mean-L3-in-inferior-cerebellar-peduncle-on-FA-skeleton-left_2_0': 1264,
        '25306_Mean-L3-in-inferior-cerebellar-peduncle-on-FA-skeleton-right_2_0': 1265,
        '25305_Mean-L3-in-medial-lemniscus-on-FA-skeleton-left_2_0': 1266,
        '25304_Mean-L3-in-medial-lemniscus-on-FA-skeleton-right_2_0': 1267,
        '25303_Mean-L3-in-corticospinal-tract-on-FA-skeleton-left_2_0': 1268,
        '25302_Mean-L3-in-corticospinal-tract-on-FA-skeleton-right_2_0': 1269,
        '25301_Mean-L3-in-fornix-on-FA-skeleton_2_0': 1270,
        '25300_Mean-L3-in-splenium-of-corpus-callosum-on-FA-skeleton_2_0': 1271,
        '25299_Mean-L3-in-body-of-corpus-callosum-on-FA-skeleton_2_0': 1272,
        '25298_Mean-L3-in-genu-of-corpus-callosum-on-FA-skeleton_2_0': 1273,
        '25297_Mean-L3-in-pontine-crossing-tract-on-FA-skeleton_2_0': 1274,
        '25296_Mean-L3-in-middle-cerebellar-peduncle-on-FA-skeleton_2_0': 1275,
        '25295_Mean-L2-in-tapetum-on-FA-skeleton-left_2_0': 1276,
        '25294_Mean-L2-in-tapetum-on-FA-skeleton-right_2_0': 1277,
        '25293_Mean-L2-in-uncinate-fasciculus-on-FA-skeleton-left_2_0': 1278,
        '25292_Mean-L2-in-uncinate-fasciculus-on-FA-skeleton-right_2_0': 1279,
        '25291_Mean-L2-in-superior-frontooccipital-fasciculus-on-FA-skeleton-left_2_0': 1280,
        '25290_Mean-L2-in-superior-frontooccipital-fasciculus-on-FA-skeleton-right_2_0': 1281,
        '25289_Mean-L2-in-superior-longitudinal-fasciculus-on-FA-skeleton-left_2_0': 1282,
        '25288_Mean-L2-in-superior-longitudinal-fasciculus-on-FA-skeleton-right_2_0': 1283,
        '25287_Mean-L2-in-fornix-cresstria-terminalis-on-FA-skeleton-left_2_0': 1284,
        '25286_Mean-L2-in-fornix-cresstria-terminalis-on-FA-skeleton-right_2_0': 1285,
        '25285_Mean-L2-in-cingulum-hippocampus-on-FA-skeleton-left_2_0': 1286,
        '25284_Mean-L2-in-cingulum-hippocampus-on-FA-skeleton-right_2_0': 1287,
        '25283_Mean-L2-in-cingulum-cingulate-gyrus-on-FA-skeleton-left_2_0': 1288,
        '25282_Mean-L2-in-cingulum-cingulate-gyrus-on-FA-skeleton-right_2_0': 1289,
        '25281_Mean-L2-in-external-capsule-on-FA-skeleton-left_2_0': 1290,
        '25280_Mean-L2-in-external-capsule-on-FA-skeleton-right_2_0': 1291,
        '25279_Mean-L2-in-sagittal-stratum-on-FA-skeleton-left_2_0': 1292,
        '25278_Mean-L2-in-sagittal-stratum-on-FA-skeleton-right_2_0': 1293,
        '25277_Mean-L2-in-posterior-thalamic-radiation-on-FA-skeleton-left_2_0': 1294,
        '25276_Mean-L2-in-posterior-thalamic-radiation-on-FA-skeleton-right_2_0': 1295,
        '25275_Mean-L2-in-posterior-corona-radiata-on-FA-skeleton-left_2_0': 1296,
        '25274_Mean-L2-in-posterior-corona-radiata-on-FA-skeleton-right_2_0': 1297,
        '25273_Mean-L2-in-superior-corona-radiata-on-FA-skeleton-left_2_0': 1298,
        '25272_Mean-L2-in-superior-corona-radiata-on-FA-skeleton-right_2_0': 1299,
        '25271_Mean-L2-in-anterior-corona-radiata-on-FA-skeleton-left_2_0': 1300,
        '25270_Mean-L2-in-anterior-corona-radiata-on-FA-skeleton-right_2_0': 1301,
        '25269_Mean-L2-in-retrolenticular-part-of-internal-capsule-on-FA-skeleton-left_2_0': 1302,
        '25268_Mean-L2-in-retrolenticular-part-of-internal-capsule-on-FA-skeleton-right_2_0': 1303,
        '25267_Mean-L2-in-posterior-limb-of-internal-capsule-on-FA-skeleton-left_2_0': 1304,
        '25266_Mean-L2-in-posterior-limb-of-internal-capsule-on-FA-skeleton-right_2_0': 1305,
        '25265_Mean-L2-in-anterior-limb-of-internal-capsule-on-FA-skeleton-left_2_0': 1306,
        '25264_Mean-L2-in-anterior-limb-of-internal-capsule-on-FA-skeleton-right_2_0': 1307,
        '25263_Mean-L2-in-cerebral-peduncle-on-FA-skeleton-left_2_0': 1308,
        '25262_Mean-L2-in-cerebral-peduncle-on-FA-skeleton-right_2_0': 1309,
        '25261_Mean-L2-in-superior-cerebellar-peduncle-on-FA-skeleton-left_2_0': 1310,
        '25260_Mean-L2-in-superior-cerebellar-peduncle-on-FA-skeleton-right_2_0': 1311,
        '25259_Mean-L2-in-inferior-cerebellar-peduncle-on-FA-skeleton-left_2_0': 1312,
        '25258_Mean-L2-in-inferior-cerebellar-peduncle-on-FA-skeleton-right_2_0': 1313,
        '25257_Mean-L2-in-medial-lemniscus-on-FA-skeleton-left_2_0': 1314,
        '25256_Mean-L2-in-medial-lemniscus-on-FA-skeleton-right_2_0': 1315,
        '25255_Mean-L2-in-corticospinal-tract-on-FA-skeleton-left_2_0': 1316,
        '25254_Mean-L2-in-corticospinal-tract-on-FA-skeleton-right_2_0': 1317,
        '25253_Mean-L2-in-fornix-on-FA-skeleton_2_0': 1318,
        '25252_Mean-L2-in-splenium-of-corpus-callosum-on-FA-skeleton_2_0': 1319,
        '25251_Mean-L2-in-body-of-corpus-callosum-on-FA-skeleton_2_0': 1320,
        '25250_Mean-L2-in-genu-of-corpus-callosum-on-FA-skeleton_2_0': 1321,
        '25249_Mean-L2-in-pontine-crossing-tract-on-FA-skeleton_2_0': 1322,
        '25248_Mean-L2-in-middle-cerebellar-peduncle-on-FA-skeleton_2_0': 1323,
        '25247_Mean-L1-in-tapetum-on-FA-skeleton-left_2_0': 1324,
        '25246_Mean-L1-in-tapetum-on-FA-skeleton-right_2_0': 1325,
        '25245_Mean-L1-in-uncinate-fasciculus-on-FA-skeleton-left_2_0': 1326,
        '25244_Mean-L1-in-uncinate-fasciculus-on-FA-skeleton-right_2_0': 1327,
        '25243_Mean-L1-in-superior-frontooccipital-fasciculus-on-FA-skeleton-left_2_0': 1328,
        '25242_Mean-L1-in-superior-frontooccipital-fasciculus-on-FA-skeleton-right_2_0': 1329,
        '25241_Mean-L1-in-superior-longitudinal-fasciculus-on-FA-skeleton-left_2_0': 1330,
        '25240_Mean-L1-in-superior-longitudinal-fasciculus-on-FA-skeleton-right_2_0': 1331,
        '25239_Mean-L1-in-fornix-cresstria-terminalis-on-FA-skeleton-left_2_0': 1332,
        '25238_Mean-L1-in-fornix-cresstria-terminalis-on-FA-skeleton-right_2_0': 1333,
        '25237_Mean-L1-in-cingulum-hippocampus-on-FA-skeleton-left_2_0': 1334,
        '25236_Mean-L1-in-cingulum-hippocampus-on-FA-skeleton-right_2_0': 1335,
        '25235_Mean-L1-in-cingulum-cingulate-gyrus-on-FA-skeleton-left_2_0': 1336,
        '25234_Mean-L1-in-cingulum-cingulate-gyrus-on-FA-skeleton-right_2_0': 1337,
        '25233_Mean-L1-in-external-capsule-on-FA-skeleton-left_2_0': 1338,
        '25232_Mean-L1-in-external-capsule-on-FA-skeleton-right_2_0': 1339,
        '25231_Mean-L1-in-sagittal-stratum-on-FA-skeleton-left_2_0': 1340,
        '25230_Mean-L1-in-sagittal-stratum-on-FA-skeleton-right_2_0': 1341,
        '25229_Mean-L1-in-posterior-thalamic-radiation-on-FA-skeleton-left_2_0': 1342,
        '25228_Mean-L1-in-posterior-thalamic-radiation-on-FA-skeleton-right_2_0': 1343,
        '25227_Mean-L1-in-posterior-corona-radiata-on-FA-skeleton-left_2_0': 1344,
        '25226_Mean-L1-in-posterior-corona-radiata-on-FA-skeleton-right_2_0': 1345,
        '25225_Mean-L1-in-superior-corona-radiata-on-FA-skeleton-left_2_0': 1346,
        '25224_Mean-L1-in-superior-corona-radiata-on-FA-skeleton-right_2_0': 1347,
        '25223_Mean-L1-in-anterior-corona-radiata-on-FA-skeleton-left_2_0': 1348,
        '25222_Mean-L1-in-anterior-corona-radiata-on-FA-skeleton-right_2_0': 1349,
        '25221_Mean-L1-in-retrolenticular-part-of-internal-capsule-on-FA-skeleton-left_2_0': 1350,
        '25220_Mean-L1-in-retrolenticular-part-of-internal-capsule-on-FA-skeleton-right_2_0': 1351,
        '25219_Mean-L1-in-posterior-limb-of-internal-capsule-on-FA-skeleton-left_2_0': 1352,
        '25218_Mean-L1-in-posterior-limb-of-internal-capsule-on-FA-skeleton-right_2_0': 1353,
        '25217_Mean-L1-in-anterior-limb-of-internal-capsule-on-FA-skeleton-left_2_0': 1354,
        '25216_Mean-L1-in-anterior-limb-of-internal-capsule-on-FA-skeleton-right_2_0': 1355,
        '25215_Mean-L1-in-cerebral-peduncle-on-FA-skeleton-left_2_0': 1356,
        '25214_Mean-L1-in-cerebral-peduncle-on-FA-skeleton-right_2_0': 1357,
        '25213_Mean-L1-in-superior-cerebellar-peduncle-on-FA-skeleton-left_2_0': 1358,
        '25212_Mean-L1-in-superior-cerebellar-peduncle-on-FA-skeleton-right_2_0': 1359,
        '25211_Mean-L1-in-inferior-cerebellar-peduncle-on-FA-skeleton-left_2_0': 1360,
        '25210_Mean-L1-in-inferior-cerebellar-peduncle-on-FA-skeleton-right_2_0': 1361,
        '25209_Mean-L1-in-medial-lemniscus-on-FA-skeleton-left_2_0': 1362,
        '25208_Mean-L1-in-medial-lemniscus-on-FA-skeleton-right_2_0': 1363,
        '25207_Mean-L1-in-corticospinal-tract-on-FA-skeleton-left_2_0': 1364,
        '25206_Mean-L1-in-corticospinal-tract-on-FA-skeleton-right_2_0': 1365,
        '25205_Mean-L1-in-fornix-on-FA-skeleton_2_0': 1366,
        '25204_Mean-L1-in-splenium-of-corpus-callosum-on-FA-skeleton_2_0': 1367,
        '25203_Mean-L1-in-body-of-corpus-callosum-on-FA-skeleton_2_0': 1368,
        '25202_Mean-L1-in-genu-of-corpus-callosum-on-FA-skeleton_2_0': 1369,
        '25201_Mean-L1-in-pontine-crossing-tract-on-FA-skeleton_2_0': 1370,
        '25200_Mean-L1-in-middle-cerebellar-peduncle-on-FA-skeleton_2_0': 1371,
        '25199_Mean-MO-in-tapetum-on-FA-skeleton-left_2_0': 1372,
        '25198_Mean-MO-in-tapetum-on-FA-skeleton-right_2_0': 1373,
        '25197_Mean-MO-in-uncinate-fasciculus-on-FA-skeleton-left_2_0': 1374,
        '25196_Mean-MO-in-uncinate-fasciculus-on-FA-skeleton-right_2_0': 1375,
        '25195_Mean-MO-in-superior-frontooccipital-fasciculus-on-FA-skeleton-left_2_0': 1376,
        '25194_Mean-MO-in-superior-frontooccipital-fasciculus-on-FA-skeleton-right_2_0': 1377,
        '25193_Mean-MO-in-superior-longitudinal-fasciculus-on-FA-skeleton-left_2_0': 1378,
        '25192_Mean-MO-in-superior-longitudinal-fasciculus-on-FA-skeleton-right_2_0': 1379,
        '25191_Mean-MO-in-fornix-cresstria-terminalis-on-FA-skeleton-left_2_0': 1380,
        '25190_Mean-MO-in-fornix-cresstria-terminalis-on-FA-skeleton-right_2_0': 1381,
        '25189_Mean-MO-in-cingulum-hippocampus-on-FA-skeleton-left_2_0': 1382,
        '25188_Mean-MO-in-cingulum-hippocampus-on-FA-skeleton-right_2_0': 1383,
        '25187_Mean-MO-in-cingulum-cingulate-gyrus-on-FA-skeleton-left_2_0': 1384,
        '25186_Mean-MO-in-cingulum-cingulate-gyrus-on-FA-skeleton-right_2_0': 1385,
        '25185_Mean-MO-in-external-capsule-on-FA-skeleton-left_2_0': 1386,
        '25184_Mean-MO-in-external-capsule-on-FA-skeleton-right_2_0': 1387,
        '25183_Mean-MO-in-sagittal-stratum-on-FA-skeleton-left_2_0': 1388,
        '25182_Mean-MO-in-sagittal-stratum-on-FA-skeleton-right_2_0': 1389,
        '25181_Mean-MO-in-posterior-thalamic-radiation-on-FA-skeleton-left_2_0': 1390,
        '25180_Mean-MO-in-posterior-thalamic-radiation-on-FA-skeleton-right_2_0': 1391,
        '25179_Mean-MO-in-posterior-corona-radiata-on-FA-skeleton-left_2_0': 1392,
        '25178_Mean-MO-in-posterior-corona-radiata-on-FA-skeleton-right_2_0': 1393,
        '25177_Mean-MO-in-superior-corona-radiata-on-FA-skeleton-left_2_0': 1394,
        '25176_Mean-MO-in-superior-corona-radiata-on-FA-skeleton-right_2_0': 1395,
        '25175_Mean-MO-in-anterior-corona-radiata-on-FA-skeleton-left_2_0': 1396,
        '25174_Mean-MO-in-anterior-corona-radiata-on-FA-skeleton-right_2_0': 1397,
        '25173_Mean-MO-in-retrolenticular-part-of-internal-capsule-on-FA-skeleton-left_2_0': 1398,
        '25172_Mean-MO-in-retrolenticular-part-of-internal-capsule-on-FA-skeleton-right_2_0': 1399,
        '25171_Mean-MO-in-posterior-limb-of-internal-capsule-on-FA-skeleton-left_2_0': 1400,
        '25170_Mean-MO-in-posterior-limb-of-internal-capsule-on-FA-skeleton-right_2_0': 1401,
        '25169_Mean-MO-in-anterior-limb-of-internal-capsule-on-FA-skeleton-left_2_0': 1402,
        '25168_Mean-MO-in-anterior-limb-of-internal-capsule-on-FA-skeleton-right_2_0': 1403,
        '25167_Mean-MO-in-cerebral-peduncle-on-FA-skeleton-left_2_0': 1404,
        '25166_Mean-MO-in-cerebral-peduncle-on-FA-skeleton-right_2_0': 1405,
        '25165_Mean-MO-in-superior-cerebellar-peduncle-on-FA-skeleton-left_2_0': 1406,
        '25164_Mean-MO-in-superior-cerebellar-peduncle-on-FA-skeleton-right_2_0': 1407,
        '25163_Mean-MO-in-inferior-cerebellar-peduncle-on-FA-skeleton-left_2_0': 1408,
        '25162_Mean-MO-in-inferior-cerebellar-peduncle-on-FA-skeleton-right_2_0': 1409,
        '25161_Mean-MO-in-medial-lemniscus-on-FA-skeleton-left_2_0': 1410,
        '25160_Mean-MO-in-medial-lemniscus-on-FA-skeleton-right_2_0': 1411,
        '25159_Mean-MO-in-corticospinal-tract-on-FA-skeleton-left_2_0': 1412,
        '25158_Mean-MO-in-corticospinal-tract-on-FA-skeleton-right_2_0': 1413,
        '25157_Mean-MO-in-fornix-on-FA-skeleton_2_0': 1414,
        '25156_Mean-MO-in-splenium-of-corpus-callosum-on-FA-skeleton_2_0': 1415,
        '25155_Mean-MO-in-body-of-corpus-callosum-on-FA-skeleton_2_0': 1416,
        '25154_Mean-MO-in-genu-of-corpus-callosum-on-FA-skeleton_2_0': 1417,
        '25153_Mean-MO-in-pontine-crossing-tract-on-FA-skeleton_2_0': 1418,
        '25152_Mean-MO-in-middle-cerebellar-peduncle-on-FA-skeleton_2_0': 1419,
        '25151_Mean-MD-in-tapetum-on-FA-skeleton-left_2_0': 1420,
        '25150_Mean-MD-in-tapetum-on-FA-skeleton-right_2_0': 1421,
        '25149_Mean-MD-in-uncinate-fasciculus-on-FA-skeleton-left_2_0': 1422,
        '25148_Mean-MD-in-uncinate-fasciculus-on-FA-skeleton-right_2_0': 1423,
        '25147_Mean-MD-in-superior-frontooccipital-fasciculus-on-FA-skeleton-left_2_0': 1424,
        '25146_Mean-MD-in-superior-frontooccipital-fasciculus-on-FA-skeleton-right_2_0': 1425,
        '25145_Mean-MD-in-superior-longitudinal-fasciculus-on-FA-skeleton-left_2_0': 1426,
        '25144_Mean-MD-in-superior-longitudinal-fasciculus-on-FA-skeleton-right_2_0': 1427,
        '25143_Mean-MD-in-fornix-cresstria-terminalis-on-FA-skeleton-left_2_0': 1428,
        '25142_Mean-MD-in-fornix-cresstria-terminalis-on-FA-skeleton-right_2_0': 1429,
        '25141_Mean-MD-in-cingulum-hippocampus-on-FA-skeleton-left_2_0': 1430,
        '25140_Mean-MD-in-cingulum-hippocampus-on-FA-skeleton-right_2_0': 1431,
        '25139_Mean-MD-in-cingulum-cingulate-gyrus-on-FA-skeleton-left_2_0': 1432,
        '25138_Mean-MD-in-cingulum-cingulate-gyrus-on-FA-skeleton-right_2_0': 1433,
        '25137_Mean-MD-in-external-capsule-on-FA-skeleton-left_2_0': 1434,
        '25136_Mean-MD-in-external-capsule-on-FA-skeleton-right_2_0': 1435,
        '25135_Mean-MD-in-sagittal-stratum-on-FA-skeleton-left_2_0': 1436,
        '25134_Mean-MD-in-sagittal-stratum-on-FA-skeleton-right_2_0': 1437,
        '25133_Mean-MD-in-posterior-thalamic-radiation-on-FA-skeleton-left_2_0': 1438,
        '25132_Mean-MD-in-posterior-thalamic-radiation-on-FA-skeleton-right_2_0': 1439,
        '25131_Mean-MD-in-posterior-corona-radiata-on-FA-skeleton-left_2_0': 1440,
        '25130_Mean-MD-in-posterior-corona-radiata-on-FA-skeleton-right_2_0': 1441,
        '25129_Mean-MD-in-superior-corona-radiata-on-FA-skeleton-left_2_0': 1442,
        '25128_Mean-MD-in-superior-corona-radiata-on-FA-skeleton-right_2_0': 1443,
        '25127_Mean-MD-in-anterior-corona-radiata-on-FA-skeleton-left_2_0': 1444,
        '25126_Mean-MD-in-anterior-corona-radiata-on-FA-skeleton-right_2_0': 1445,
        '25125_Mean-MD-in-retrolenticular-part-of-internal-capsule-on-FA-skeleton-left_2_0': 1446,
        '25124_Mean-MD-in-retrolenticular-part-of-internal-capsule-on-FA-skeleton-right_2_0': 1447,
        '25123_Mean-MD-in-posterior-limb-of-internal-capsule-on-FA-skeleton-left_2_0': 1448,
        '25122_Mean-MD-in-posterior-limb-of-internal-capsule-on-FA-skeleton-right_2_0': 1449,
        '25121_Mean-MD-in-anterior-limb-of-internal-capsule-on-FA-skeleton-left_2_0': 1450,
        '25120_Mean-MD-in-anterior-limb-of-internal-capsule-on-FA-skeleton-right_2_0': 1451,
        '25119_Mean-MD-in-cerebral-peduncle-on-FA-skeleton-left_2_0': 1452,
        '25118_Mean-MD-in-cerebral-peduncle-on-FA-skeleton-right_2_0': 1453,
        '25117_Mean-MD-in-superior-cerebellar-peduncle-on-FA-skeleton-left_2_0': 1454,
        '25116_Mean-MD-in-superior-cerebellar-peduncle-on-FA-skeleton-right_2_0': 1455,
        '25115_Mean-MD-in-inferior-cerebellar-peduncle-on-FA-skeleton-left_2_0': 1456,
        '25114_Mean-MD-in-inferior-cerebellar-peduncle-on-FA-skeleton-right_2_0': 1457,
        '25113_Mean-MD-in-medial-lemniscus-on-FA-skeleton-left_2_0': 1458,
        '25112_Mean-MD-in-medial-lemniscus-on-FA-skeleton-right_2_0': 1459,
        '25111_Mean-MD-in-corticospinal-tract-on-FA-skeleton-left_2_0': 1460,
        '25110_Mean-MD-in-corticospinal-tract-on-FA-skeleton-right_2_0': 1461,
        '25109_Mean-MD-in-fornix-on-FA-skeleton_2_0': 1462,
        '25108_Mean-MD-in-splenium-of-corpus-callosum-on-FA-skeleton_2_0': 1463,
        '25107_Mean-MD-in-body-of-corpus-callosum-on-FA-skeleton_2_0': 1464,
        '25106_Mean-MD-in-genu-of-corpus-callosum-on-FA-skeleton_2_0': 1465,
        '25105_Mean-MD-in-pontine-crossing-tract-on-FA-skeleton_2_0': 1466,
        '25104_Mean-MD-in-middle-cerebellar-peduncle-on-FA-skeleton_2_0': 1467,
        '25103_Mean-FA-in-tapetum-on-FA-skeleton-left_2_0': 1468,
        '25102_Mean-FA-in-tapetum-on-FA-skeleton-right_2_0': 1469,
        '25101_Mean-FA-in-uncinate-fasciculus-on-FA-skeleton-left_2_0': 1470,
        '25100_Mean-FA-in-uncinate-fasciculus-on-FA-skeleton-right_2_0': 1471,
        '25099_Mean-FA-in-superior-frontooccipital-fasciculus-on-FA-skeleton-left_2_0': 1472,
        '25098_Mean-FA-in-superior-frontooccipital-fasciculus-on-FA-skeleton-right_2_0': 1473,
        '25097_Mean-FA-in-superior-longitudinal-fasciculus-on-FA-skeleton-left_2_0': 1474,
        '25096_Mean-FA-in-superior-longitudinal-fasciculus-on-FA-skeleton-right_2_0': 1475,
        '25095_Mean-FA-in-fornix-cresstria-terminalis-on-FA-skeleton-left_2_0': 1476,
        '25094_Mean-FA-in-fornix-cresstria-terminalis-on-FA-skeleton-right_2_0': 1477,
        '25093_Mean-FA-in-cingulum-hippocampus-on-FA-skeleton-left_2_0': 1478,
        '25092_Mean-FA-in-cingulum-hippocampus-on-FA-skeleton-right_2_0': 1479,
        '25091_Mean-FA-in-cingulum-cingulate-gyrus-on-FA-skeleton-left_2_0': 1480,
        '25090_Mean-FA-in-cingulum-cingulate-gyrus-on-FA-skeleton-right_2_0': 1481,
        '25089_Mean-FA-in-external-capsule-on-FA-skeleton-left_2_0': 1482,
        '25088_Mean-FA-in-external-capsule-on-FA-skeleton-right_2_0': 1483,
        '25087_Mean-FA-in-sagittal-stratum-on-FA-skeleton-left_2_0': 1484,
        '25086_Mean-FA-in-sagittal-stratum-on-FA-skeleton-right_2_0': 1485,
        '25085_Mean-FA-in-posterior-thalamic-radiation-on-FA-skeleton-left_2_0': 1486,
        '25084_Mean-FA-in-posterior-thalamic-radiation-on-FA-skeleton-right_2_0': 1487,
        '25083_Mean-FA-in-posterior-corona-radiata-on-FA-skeleton-left_2_0': 1488,
        '25082_Mean-FA-in-posterior-corona-radiata-on-FA-skeleton-right_2_0': 1489,
        '25081_Mean-FA-in-superior-corona-radiata-on-FA-skeleton-left_2_0': 1490,
        '25080_Mean-FA-in-superior-corona-radiata-on-FA-skeleton-right_2_0': 1491,
        '25079_Mean-FA-in-anterior-corona-radiata-on-FA-skeleton-left_2_0': 1492,
        '25078_Mean-FA-in-anterior-corona-radiata-on-FA-skeleton-right_2_0': 1493,
        '25077_Mean-FA-in-retrolenticular-part-of-internal-capsule-on-FA-skeleton-left_2_0': 1494,
        '25076_Mean-FA-in-retrolenticular-part-of-internal-capsule-on-FA-skeleton-right_2_0': 1495,
        '25075_Mean-FA-in-posterior-limb-of-internal-capsule-on-FA-skeleton-left_2_0': 1496,
        '25074_Mean-FA-in-posterior-limb-of-internal-capsule-on-FA-skeleton-right_2_0': 1497,
        '25073_Mean-FA-in-anterior-limb-of-internal-capsule-on-FA-skeleton-left_2_0': 1498,
        '25072_Mean-FA-in-anterior-limb-of-internal-capsule-on-FA-skeleton-right_2_0': 1499,
        '25071_Mean-FA-in-cerebral-peduncle-on-FA-skeleton-left_2_0': 1500,
        '25070_Mean-FA-in-cerebral-peduncle-on-FA-skeleton-right_2_0': 1501,
        '25069_Mean-FA-in-superior-cerebellar-peduncle-on-FA-skeleton-left_2_0': 1502,
        '25068_Mean-FA-in-superior-cerebellar-peduncle-on-FA-skeleton-right_2_0': 1503,
        '25067_Mean-FA-in-inferior-cerebellar-peduncle-on-FA-skeleton-left_2_0': 1504,
        '25066_Mean-FA-in-inferior-cerebellar-peduncle-on-FA-skeleton-right_2_0': 1505,
        '25065_Mean-FA-in-medial-lemniscus-on-FA-skeleton-left_2_0': 1506,
        '25064_Mean-FA-in-medial-lemniscus-on-FA-skeleton-right_2_0': 1507,
        '25063_Mean-FA-in-corticospinal-tract-on-FA-skeleton-left_2_0': 1508,
        '25062_Mean-FA-in-corticospinal-tract-on-FA-skeleton-right_2_0': 1509,
        '25061_Mean-FA-in-fornix-on-FA-skeleton_2_0': 1510,
        '25060_Mean-FA-in-splenium-of-corpus-callosum-on-FA-skeleton_2_0': 1511,
        '25059_Mean-FA-in-body-of-corpus-callosum-on-FA-skeleton_2_0': 1512,
        '25058_Mean-FA-in-genu-of-corpus-callosum-on-FA-skeleton_2_0': 1513,
        '25057_Mean-FA-in-pontine-crossing-tract-on-FA-skeleton_2_0': 1514,
        '25056_Mean-FA-in-middle-cerebellar-peduncle-on-FA-skeleton_2_0': 1515,
        '20009_Interpolated-Age-of-participant-when-noncancer-illness-first-diagnosed_2_0': 1516,
        '3526_Mothers-age-at-death_2_0': 1517, '3872_Age-of-primiparous-women-at-birth-of-child_0_0': 1518,
    },
)

field_id_34_year_of_birth_0_0 = TensorMap(
    '34_Year-of-birth_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'34_Year-of-birth_0_0': 0},
)
field_id_21003_age_when_attended_assessment_centre_0_0 = TensorMap(
    '21003_Age-when-attended-assessment-centre_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '21003_Age-when-attended-assessment-centre_0_0': 0,
    },
)
field_id_904_number_of_daysweek_of_vigorous_physical_activity_10_minutes_0_0 = TensorMap(
    '904_Number-of-daysweek-of-vigorous-physical-activity-10-minutes_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'904_Number-of-daysweek-of-vigorous-physical-activity-10-minutes_0_0': 0},
)
field_id_884_number_of_daysweek_of_moderate_physical_activity_10_minutes_0_0 = TensorMap(
    '884_Number-of-daysweek-of-moderate-physical-activity-10-minutes_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'884_Number-of-daysweek-of-moderate-physical-activity-10-minutes_0_0': 0},
)
field_id_864_number_of_daysweek_walked_10_minutes_0_0 = TensorMap(
    '864_Number-of-daysweek-walked-10-minutes_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '864_Number-of-daysweek-walked-10-minutes_0_0': 0,
    },
)
field_id_699_length_of_time_at_current_address_0_0 = TensorMap(
    '699_Length-of-time-at-current-address_0_0',
    path_prefix='continuous', loss='logcosh', channel_map={
        '699_Length-of-time-at-current-address_0_0': 0,
    },
)
field_id_189_townsend_deprivation_index_at_recruitment_0_0 = TensorMap(
    '189_Townsend-deprivation-index-at-recruitment_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'189_Townsend-deprivation-index-at-recruitment_0_0': 0},
)
field_id_1070_time_spent_watching_television_tv_0_0 = TensorMap(
    '1070_Time-spent-watching-television-TV_0_0',
    path_prefix='continuous', loss='logcosh', channel_map={
        '1070_Time-spent-watching-television-TV_0_0': 0,
    },
)
field_id_1528_water_intake_0_0 = TensorMap(
    '1528_Water-intake_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'1528_Water-intake_0_0': 0},
)
field_id_1498_coffee_intake_0_0 = TensorMap(
    '1498_Coffee-intake_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'1498_Coffee-intake_0_0': 0},
)
field_id_1488_tea_intake_0_0 = TensorMap(
    '1488_Tea-intake_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'1488_Tea-intake_0_0': 0},
)
field_id_1319_dried_fruit_intake_0_0 = TensorMap(
    '1319_Dried-fruit-intake_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'1319_Dried-fruit-intake_0_0': 0},
)
field_id_1309_fresh_fruit_intake_0_0 = TensorMap(
    '1309_Fresh-fruit-intake_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'1309_Fresh-fruit-intake_0_0': 0},
)
field_id_1299_salad_raw_vegetable_intake_0_0 = TensorMap(
    '1299_Salad-raw-vegetable-intake_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'1299_Salad-raw-vegetable-intake_0_0': 0},
)
field_id_1289_cooked_vegetable_intake_0_0 = TensorMap(
    '1289_Cooked-vegetable-intake_0_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'1289_Cooked-vegetable-intake_0_0': 0},
)
field_id_1090_time_spent_driving_0_0 = TensorMap(
    '1090_Time-spent-driving_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'1090_Time-spent-driving_0_0': 0},
)
field_id_1458_cereal_intake_0_0 = TensorMap(
    '1458_Cereal-intake_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'1458_Cereal-intake_0_0': 0},
)
field_id_137_number_of_treatmentsmedications_taken_0_0 = TensorMap(
    '137_Number-of-treatmentsmedications-taken_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '137_Number-of-treatmentsmedications-taken_0_0': 0,
    },
)
field_id_136_number_of_operations_selfreported_0_0 = TensorMap(
    '136_Number-of-operations-selfreported_0_0',
    path_prefix='continuous', loss='logcosh', channel_map={
        '136_Number-of-operations-selfreported_0_0': 0,
    },
)
field_id_135_number_of_selfreported_noncancer_illnesses_0_0 = TensorMap(
    '135_Number-of-selfreported-noncancer-illnesses_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'135_Number-of-selfreported-noncancer-illnesses_0_0': 0},
)
field_id_134_number_of_selfreported_cancers_0_0 = TensorMap(
    '134_Number-of-selfreported-cancers_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'134_Number-of-selfreported-cancers_0_0': 0},
)
field_id_709_number_in_household_0_0 = TensorMap(
    '709_Number-in-household_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'709_Number-in-household_0_0': 0},
)
field_id_49_hip_circumference_0_0 = TensorMap(
    '49_Hip-circumference_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'49_Hip-circumference_0_0': 0},
)
field_id_48_waist_circumference_0_0 = TensorMap(
    '48_Waist-circumference_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'48_Waist-circumference_0_0': 0},
)
field_id_50_standing_height_0_0 = TensorMap(
    '50_Standing-height_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'50_Standing-height_0_0': 0},
)
field_id_47_hand_grip_strength_right_0_0 = TensorMap(
    '47_Hand-grip-strength-right_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'47_Hand-grip-strength-right_0_0': 0},
)
field_id_21002_weight_0_0 = TensorMap(
    '21002_Weight_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'21002_Weight_0_0': 0},
)
field_id_46_hand_grip_strength_left_0_0 = TensorMap(
    '46_Hand-grip-strength-left_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'46_Hand-grip-strength-left_0_0': 0},
)
field_id_21001_body_mass_index_bmi_0_0 = TensorMap(
    '21001_Body-mass-index-BMI_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'21001_Body-mass-index-BMI_0_0': 0},
)
field_id_20023_mean_time_to_correctly_identify_matches_0_0 = TensorMap(
    '20023_Mean-time-to-correctly-identify-matches_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'20023_Mean-time-to-correctly-identify-matches_0_0': 0},
)
field_id_400_time_to_complete_round_0_2 = TensorMap(
    '400_Time-to-complete-round_0_2', path_prefix='continuous',
    loss='logcosh', channel_map={'400_Time-to-complete-round_0_2': 0},
)
field_id_400_time_to_complete_round_0_1 = TensorMap(
    '400_Time-to-complete-round_0_1', path_prefix='continuous',
    loss='logcosh', channel_map={'400_Time-to-complete-round_0_1': 0},
)
field_id_399_number_of_incorrect_matches_in_round_0_2 = TensorMap(
    '399_Number-of-incorrect-matches-in-round_0_2',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '399_Number-of-incorrect-matches-in-round_0_2': 0,
    },
)
field_id_399_number_of_incorrect_matches_in_round_0_1 = TensorMap(
    '399_Number-of-incorrect-matches-in-round_0_1',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '399_Number-of-incorrect-matches-in-round_0_1': 0,
    },
)
field_id_398_number_of_correct_matches_in_round_0_2 = TensorMap(
    '398_Number-of-correct-matches-in-round_0_2',
    path_prefix='continuous', loss='logcosh', channel_map={
        '398_Number-of-correct-matches-in-round_0_2': 0,
    },
)
field_id_398_number_of_correct_matches_in_round_0_1 = TensorMap(
    '398_Number-of-correct-matches-in-round_0_1',
    path_prefix='continuous', loss='logcosh', channel_map={
        '398_Number-of-correct-matches-in-round_0_1': 0,
    },
)
field_id_397_number_of_rows_displayed_in_round_0_2 = TensorMap(
    '397_Number-of-rows-displayed-in-round_0_2',
    path_prefix='continuous', loss='logcosh', channel_map={
        '397_Number-of-rows-displayed-in-round_0_2': 0,
    },
)
field_id_397_number_of_rows_displayed_in_round_0_1 = TensorMap(
    '397_Number-of-rows-displayed-in-round_0_1',
    path_prefix='continuous', loss='logcosh', channel_map={
        '397_Number-of-rows-displayed-in-round_0_1': 0,
    },
)
field_id_396_number_of_columns_displayed_in_round_0_2 = TensorMap(
    '396_Number-of-columns-displayed-in-round_0_2',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '396_Number-of-columns-displayed-in-round_0_2': 0,
    },
)
field_id_396_number_of_columns_displayed_in_round_0_1 = TensorMap(
    '396_Number-of-columns-displayed-in-round_0_1',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '396_Number-of-columns-displayed-in-round_0_1': 0,
    },
)
field_id_1080_time_spent_using_computer_0_0 = TensorMap(
    '1080_Time-spent-using-computer_0_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'1080_Time-spent-using-computer_0_0': 0},
)
field_id_1060_time_spent_outdoors_in_winter_0_0 = TensorMap(
    '1060_Time-spent-outdoors-in-winter_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'1060_Time-spent-outdoors-in-winter_0_0': 0},
)
field_id_1050_time_spend_outdoors_in_summer_0_0 = TensorMap(
    '1050_Time-spend-outdoors-in-summer_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'1050_Time-spend-outdoors-in-summer_0_0': 0},
)
field_id_2277_frequency_of_solariumsunlamp_use_0_0 = TensorMap(
    '2277_Frequency-of-solariumsunlamp-use_0_0',
    path_prefix='continuous', loss='logcosh', channel_map={
        '2277_Frequency-of-solariumsunlamp-use_0_0': 0,
    },
)
field_id_1737_childhood_sunburn_occasions_0_0 = TensorMap(
    '1737_Childhood-sunburn-occasions_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'1737_Childhood-sunburn-occasions_0_0': 0},
)
field_id_1438_bread_intake_0_0 = TensorMap(
    '1438_Bread-intake_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'1438_Bread-intake_0_0': 0},
)
field_id_1883_number_of_full_sisters_0_0 = TensorMap(
    '1883_Number-of-full-sisters_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'1883_Number-of-full-sisters_0_0': 0},
)
field_id_1873_number_of_full_brothers_0_0 = TensorMap(
    '1873_Number-of-full-brothers_0_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'1873_Number-of-full-brothers_0_0': 0},
)
field_id_51_seated_height_0_0 = TensorMap(
    '51_Seated-height_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'51_Seated-height_0_0': 0},
)
field_id_20015_sitting_height_0_0 = TensorMap(
    '20015_Sitting-height_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'20015_Sitting-height_0_0': 0},
)
field_id_23116_leg_fat_mass_left_0_0 = TensorMap(
    '23116_Leg-fat-mass-left_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'23116_Leg-fat-mass-left_0_0': 0},
)
field_id_23115_leg_fat_percentage_left_0_0 = TensorMap(
    '23115_Leg-fat-percentage-left_0_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'23115_Leg-fat-percentage-left_0_0': 0},
)
field_id_23114_leg_predicted_mass_right_0_0 = TensorMap(
    '23114_Leg-predicted-mass-right_0_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'23114_Leg-predicted-mass-right_0_0': 0},
)
field_id_23113_leg_fatfree_mass_right_0_0 = TensorMap(
    '23113_Leg-fatfree-mass-right_0_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'23113_Leg-fatfree-mass-right_0_0': 0},
)
field_id_23112_leg_fat_mass_right_0_0 = TensorMap(
    '23112_Leg-fat-mass-right_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'23112_Leg-fat-mass-right_0_0': 0},
)
field_id_23111_leg_fat_percentage_right_0_0 = TensorMap(
    '23111_Leg-fat-percentage-right_0_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'23111_Leg-fat-percentage-right_0_0': 0},
)
field_id_23110_impedance_of_arm_left_0_0 = TensorMap(
    '23110_Impedance-of-arm-left_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'23110_Impedance-of-arm-left_0_0': 0},
)
field_id_23109_impedance_of_arm_right_0_0 = TensorMap(
    '23109_Impedance-of-arm-right_0_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'23109_Impedance-of-arm-right_0_0': 0},
)
field_id_23108_impedance_of_leg_left_0_0 = TensorMap(
    '23108_Impedance-of-leg-left_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'23108_Impedance-of-leg-left_0_0': 0},
)
field_id_23107_impedance_of_leg_right_0_0 = TensorMap(
    '23107_Impedance-of-leg-right_0_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'23107_Impedance-of-leg-right_0_0': 0},
)
field_id_23106_impedance_of_whole_body_0_0 = TensorMap(
    '23106_Impedance-of-whole-body_0_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'23106_Impedance-of-whole-body_0_0': 0},
)
field_id_23105_basal_metabolic_rate_0_0 = TensorMap(
    '23105_Basal-metabolic-rate_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'23105_Basal-metabolic-rate_0_0': 0},
)
field_id_23104_body_mass_index_bmi_0_0 = TensorMap(
    '23104_Body-mass-index-BMI_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'23104_Body-mass-index-BMI_0_0': 0},
)
field_id_23102_whole_body_water_mass_0_0 = TensorMap(
    '23102_Whole-body-water-mass_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'23102_Whole-body-water-mass_0_0': 0},
)
field_id_23101_whole_body_fatfree_mass_0_0 = TensorMap(
    '23101_Whole-body-fatfree-mass_0_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'23101_Whole-body-fatfree-mass_0_0': 0},
)
field_id_23099_body_fat_percentage_0_0 = TensorMap(
    '23099_Body-fat-percentage_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'23099_Body-fat-percentage_0_0': 0},
)
field_id_23098_weight_0_0 = TensorMap(
    '23098_Weight_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'23098_Weight_0_0': 0},
)
field_id_23117_leg_fatfree_mass_left_0_0 = TensorMap(
    '23117_Leg-fatfree-mass-left_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'23117_Leg-fatfree-mass-left_0_0': 0},
)
field_id_23123_arm_fat_percentage_left_0_0 = TensorMap(
    '23123_Arm-fat-percentage-left_0_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'23123_Arm-fat-percentage-left_0_0': 0},
)
field_id_23122_arm_predicted_mass_right_0_0 = TensorMap(
    '23122_Arm-predicted-mass-right_0_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'23122_Arm-predicted-mass-right_0_0': 0},
)
field_id_23121_arm_fatfree_mass_right_0_0 = TensorMap(
    '23121_Arm-fatfree-mass-right_0_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'23121_Arm-fatfree-mass-right_0_0': 0},
)
field_id_23120_arm_fat_mass_right_0_0 = TensorMap(
    '23120_Arm-fat-mass-right_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'23120_Arm-fat-mass-right_0_0': 0},
)
field_id_23119_arm_fat_percentage_right_0_0 = TensorMap(
    '23119_Arm-fat-percentage-right_0_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'23119_Arm-fat-percentage-right_0_0': 0},
)
field_id_23118_leg_predicted_mass_left_0_0 = TensorMap(
    '23118_Leg-predicted-mass-left_0_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'23118_Leg-predicted-mass-left_0_0': 0},
)
field_id_23127_trunk_fat_percentage_0_0 = TensorMap(
    '23127_Trunk-fat-percentage_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'23127_Trunk-fat-percentage_0_0': 0},
)
field_id_23126_arm_predicted_mass_left_0_0 = TensorMap(
    '23126_Arm-predicted-mass-left_0_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'23126_Arm-predicted-mass-left_0_0': 0},
)
field_id_23125_arm_fatfree_mass_left_0_0 = TensorMap(
    '23125_Arm-fatfree-mass-left_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'23125_Arm-fatfree-mass-left_0_0': 0},
)
field_id_23100_whole_body_fat_mass_0_0 = TensorMap(
    '23100_Whole-body-fat-mass_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'23100_Whole-body-fat-mass_0_0': 0},
)
field_id_23128_trunk_fat_mass_0_0 = TensorMap(
    '23128_Trunk-fat-mass_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'23128_Trunk-fat-mass_0_0': 0},
)
field_id_23124_arm_fat_mass_left_0_0 = TensorMap(
    '23124_Arm-fat-mass-left_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'23124_Arm-fat-mass-left_0_0': 0},
)
field_id_404_duration_to_first_press_of_snapbutton_in_each_round_0_7 = TensorMap(
    '404_Duration-to-first-press-of-snapbutton-in-each-round_0_7', path_prefix='continuous', loss='logcosh',
    channel_map={'404_Duration-to-first-press-of-snapbutton-in-each-round_0_7': 0},
)
field_id_23130_trunk_predicted_mass_0_0 = TensorMap(
    '23130_Trunk-predicted-mass_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'23130_Trunk-predicted-mass_0_0': 0},
)
field_id_23129_trunk_fatfree_mass_0_0 = TensorMap(
    '23129_Trunk-fatfree-mass_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'23129_Trunk-fatfree-mass_0_0': 0},
)
field_id_404_duration_to_first_press_of_snapbutton_in_each_round_0_5 = TensorMap(
    '404_Duration-to-first-press-of-snapbutton-in-each-round_0_5', path_prefix='continuous', loss='logcosh',
    channel_map={'404_Duration-to-first-press-of-snapbutton-in-each-round_0_5': 0},
)
field_id_404_duration_to_first_press_of_snapbutton_in_each_round_0_11 = TensorMap(
    '404_Duration-to-first-press-of-snapbutton-in-each-round_0_11', path_prefix='continuous', loss='logcosh',
    channel_map={'404_Duration-to-first-press-of-snapbutton-in-each-round_0_11': 0},
)
field_id_404_duration_to_first_press_of_snapbutton_in_each_round_0_10 = TensorMap(
    '404_Duration-to-first-press-of-snapbutton-in-each-round_0_10', path_prefix='continuous', loss='logcosh',
    channel_map={'404_Duration-to-first-press-of-snapbutton-in-each-round_0_10': 0},
)
field_id_30510_creatinine_enzymatic_in_urine_0_0 = TensorMap(
    '30510_Creatinine-enzymatic-in-urine_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'30510_Creatinine-enzymatic-in-urine_0_0': 0},
)
field_id_30374_volume_of_lihep_plasma_held_by_ukb_0_0 = TensorMap(
    '30374_Volume-of-LiHep-plasma-held-by-UKB_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '30374_Volume-of-LiHep-plasma-held-by-UKB_0_0': 0,
    },
)
field_id_30384_volume_of_serum_held_by_ukb_0_0 = TensorMap(
    '30384_Volume-of-serum-held-by-UKB_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'30384_Volume-of-serum-held-by-UKB_0_0': 0},
)
field_id_30530_sodium_in_urine_0_0 = TensorMap(
    '30530_Sodium-in-urine_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'30530_Sodium-in-urine_0_0': 0},
)
field_id_30520_potassium_in_urine_0_0 = TensorMap(
    '30520_Potassium-in-urine_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'30520_Potassium-in-urine_0_0': 0},
)
field_id_30324_volume_of_edta1_red_cells_held_by_ukb_0_0 = TensorMap(
    '30324_Volume-of-EDTA1-red-cells-held-by-UKB_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '30324_Volume-of-EDTA1-red-cells-held-by-UKB_0_0': 0,
    },
)
field_id_30314_volume_of_edta1_plasma_held_by_ukb_0_0 = TensorMap(
    '30314_Volume-of-EDTA1-plasma-held-by-UKB_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '30314_Volume-of-EDTA1-plasma-held-by-UKB_0_0': 0,
    },
)
field_id_30334_volume_of_edta1_buffy_held_by_ukb_0_0 = TensorMap(
    '30334_Volume-of-EDTA1-buffy-held-by-UKB_0_0',
    path_prefix='continuous', loss='logcosh', channel_map={
        '30334_Volume-of-EDTA1-buffy-held-by-UKB_0_0': 0,
    },
)
field_id_30404_volume_of_acd_held_by_ukb_0_0 = TensorMap(
    '30404_Volume-of-ACD-held-by-UKB_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'30404_Volume-of-ACD-held-by-UKB_0_0': 0},
)
field_id_30344_volume_of_edta2_plasma_held_by_ukb_0_0 = TensorMap(
    '30344_Volume-of-EDTA2-plasma-held-by-UKB_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '30344_Volume-of-EDTA2-plasma-held-by-UKB_0_0': 0,
    },
)
field_id_30364_volume_of_edta2_red_cells_held_by_ukb_0_0 = TensorMap(
    '30364_Volume-of-EDTA2-red-cells-held-by-UKB_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '30364_Volume-of-EDTA2-red-cells-held-by-UKB_0_0': 0,
    },
)
field_id_30354_volume_of_edta2_buffy_held_by_ukb_0_0 = TensorMap(
    '30354_Volume-of-EDTA2-buffy-held-by-UKB_0_0',
    path_prefix='continuous', loss='logcosh', channel_map={
        '30354_Volume-of-EDTA2-buffy-held-by-UKB_0_0': 0,
    },
)
field_id_874_duration_of_walks_0_0 = TensorMap(
    '874_Duration-of-walks_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'874_Duration-of-walks_0_0': 0},
)
field_id_30110_platelet_distribution_width_0_0 = TensorMap(
    '30110_Platelet-distribution-width_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'30110_Platelet-distribution-width_0_0': 0},
)
field_id_30100_mean_platelet_thrombocyte_volume_0_0 = TensorMap(
    '30100_Mean-platelet-thrombocyte-volume_0_0',
    path_prefix='continuous', loss='logcosh', channel_map={
        '30100_Mean-platelet-thrombocyte-volume_0_0': 0,
    },
)
field_id_30090_platelet_crit_0_0 = TensorMap(
    '30090_Platelet-crit_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'30090_Platelet-crit_0_0': 0},
)
field_id_30080_platelet_count_0_0 = TensorMap(
    '30080_Platelet-count_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'30080_Platelet-count_0_0': 0},
)
field_id_30070_red_blood_cell_erythrocyte_distribution_width_0_0 = TensorMap(
    '30070_Red-blood-cell-erythrocyte-distribution-width_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'30070_Red-blood-cell-erythrocyte-distribution-width_0_0': 0},
)
field_id_30060_mean_corpuscular_haemoglobin_concentration_0_0 = TensorMap(
    '30060_Mean-corpuscular-haemoglobin-concentration_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'30060_Mean-corpuscular-haemoglobin-concentration_0_0': 0},
)
field_id_30050_mean_corpuscular_haemoglobin_0_0 = TensorMap(
    '30050_Mean-corpuscular-haemoglobin_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'30050_Mean-corpuscular-haemoglobin_0_0': 0},
)
field_id_30040_mean_corpuscular_volume_0_0 = TensorMap(
    '30040_Mean-corpuscular-volume_0_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'30040_Mean-corpuscular-volume_0_0': 0},
)
field_id_30030_haematocrit_percentage_0_0 = TensorMap(
    '30030_Haematocrit-percentage_0_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'30030_Haematocrit-percentage_0_0': 0},
)
field_id_30020_haemoglobin_concentration_0_0 = TensorMap(
    '30020_Haemoglobin-concentration_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'30020_Haemoglobin-concentration_0_0': 0},
)
field_id_30010_red_blood_cell_erythrocyte_count_0_0 = TensorMap(
    '30010_Red-blood-cell-erythrocyte-count_0_0',
    path_prefix='continuous', loss='logcosh', channel_map={
        '30010_Red-blood-cell-erythrocyte-count_0_0': 0,
    },
)
field_id_30000_white_blood_cell_leukocyte_count_0_0 = TensorMap(
    '30000_White-blood-cell-leukocyte-count_0_0',
    path_prefix='continuous', loss='logcosh', channel_map={
        '30000_White-blood-cell-leukocyte-count_0_0': 0,
    },
)
field_id_30220_basophill_percentage_0_0 = TensorMap(
    '30220_Basophill-percentage_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'30220_Basophill-percentage_0_0': 0},
)
field_id_30210_eosinophill_percentage_0_0 = TensorMap(
    '30210_Eosinophill-percentage_0_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'30210_Eosinophill-percentage_0_0': 0},
)
field_id_30200_neutrophill_percentage_0_0 = TensorMap(
    '30200_Neutrophill-percentage_0_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'30200_Neutrophill-percentage_0_0': 0},
)
field_id_30190_monocyte_percentage_0_0 = TensorMap(
    '30190_Monocyte-percentage_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'30190_Monocyte-percentage_0_0': 0},
)
field_id_30180_lymphocyte_percentage_0_0 = TensorMap(
    '30180_Lymphocyte-percentage_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'30180_Lymphocyte-percentage_0_0': 0},
)
field_id_30170_nucleated_red_blood_cell_count_0_0 = TensorMap(
    '30170_Nucleated-red-blood-cell-count_0_0',
    path_prefix='continuous', loss='logcosh', channel_map={
        '30170_Nucleated-red-blood-cell-count_0_0': 0,
    },
)
field_id_30160_basophill_count_0_0 = TensorMap(
    '30160_Basophill-count_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'30160_Basophill-count_0_0': 0},
)
field_id_30150_eosinophill_count_0_0 = TensorMap(
    '30150_Eosinophill-count_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'30150_Eosinophill-count_0_0': 0},
)
field_id_30140_neutrophill_count_0_0 = TensorMap(
    '30140_Neutrophill-count_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'30140_Neutrophill-count_0_0': 0},
)
field_id_30130_monocyte_count_0_0 = TensorMap(
    '30130_Monocyte-count_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'30130_Monocyte-count_0_0': 0},
)
field_id_30120_lymphocyte_count_0_0 = TensorMap(
    '30120_Lymphocyte-count_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'30120_Lymphocyte-count_0_0': 0},
)
field_id_30230_nucleated_red_blood_cell_percentage_0_0 = TensorMap(
    '30230_Nucleated-red-blood-cell-percentage_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '30230_Nucleated-red-blood-cell-percentage_0_0': 0,
    },
)
field_id_30880_urate_0_0 = TensorMap(
    '30880_Urate_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'30880_Urate_0_0': 0},
)
field_id_30870_triglycerides_0_0 = TensorMap(
    '30870_Triglycerides_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'30870_Triglycerides_0_0': 0},
)
field_id_30670_urea_0_0 = TensorMap(
    '30670_Urea_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'30670_Urea_0_0': 0},
)
field_id_30690_cholesterol_0_0 = TensorMap(
    '30690_Cholesterol_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'30690_Cholesterol_0_0': 0},
)
field_id_4080_systolic_blood_pressure_automated_reading_0_0 = TensorMap(
    '4080_Systolic-blood-pressure-automated-reading_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'4080_Systolic-blood-pressure-automated-reading_0_0': 0},
)
field_id_4079_diastolic_blood_pressure_automated_reading_0_0 = TensorMap(
    '4079_Diastolic-blood-pressure-automated-reading_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'4079_Diastolic-blood-pressure-automated-reading_0_0': 0},
)
field_id_30770_igf1_0_0 = TensorMap(
    '30770_IGF1_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'30770_IGF1_0_0': 0},
)
field_id_30710_creactive_protein_0_0 = TensorMap(
    '30710_Creactive-protein_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'30710_Creactive-protein_0_0': 0},
)
field_id_102_pulse_rate_automated_reading_0_0 = TensorMap(
    '102_Pulse-rate-automated-reading_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'102_Pulse-rate-automated-reading_0_0': 0},
)
field_id_30640_apolipoprotein_b_0_0 = TensorMap(
    '30640_Apolipoprotein-B_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'30640_Apolipoprotein-B_0_0': 0},
)
field_id_30840_total_bilirubin_0_0 = TensorMap(
    '30840_Total-bilirubin_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'30840_Total-bilirubin_0_0': 0},
)
field_id_30300_high_light_scatter_reticulocyte_count_0_0 = TensorMap(
    '30300_High-light-scatter-reticulocyte-count_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '30300_High-light-scatter-reticulocyte-count_0_0': 0,
    },
)
field_id_30290_high_light_scatter_reticulocyte_percentage_0_0 = TensorMap(
    '30290_High-light-scatter-reticulocyte-percentage_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'30290_High-light-scatter-reticulocyte-percentage_0_0': 0},
)
field_id_30280_immature_reticulocyte_fraction_0_0 = TensorMap(
    '30280_Immature-reticulocyte-fraction_0_0',
    path_prefix='continuous', loss='logcosh', channel_map={
        '30280_Immature-reticulocyte-fraction_0_0': 0,
    },
)
field_id_30270_mean_sphered_cell_volume_0_0 = TensorMap(
    '30270_Mean-sphered-cell-volume_0_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'30270_Mean-sphered-cell-volume_0_0': 0},
)
field_id_30260_mean_reticulocyte_volume_0_0 = TensorMap(
    '30260_Mean-reticulocyte-volume_0_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'30260_Mean-reticulocyte-volume_0_0': 0},
)
field_id_30250_reticulocyte_count_0_0 = TensorMap(
    '30250_Reticulocyte-count_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'30250_Reticulocyte-count_0_0': 0},
)
field_id_30240_reticulocyte_percentage_0_0 = TensorMap(
    '30240_Reticulocyte-percentage_0_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'30240_Reticulocyte-percentage_0_0': 0},
)
field_id_1279_exposure_to_tobacco_smoke_outside_home_0_0 = TensorMap(
    '1279_Exposure-to-tobacco-smoke-outside-home_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '1279_Exposure-to-tobacco-smoke-outside-home_0_0': 0,
    },
)
field_id_1269_exposure_to_tobacco_smoke_at_home_0_0 = TensorMap(
    '1269_Exposure-to-tobacco-smoke-at-home_0_0',
    path_prefix='continuous', loss='logcosh', channel_map={
        '1269_Exposure-to-tobacco-smoke-at-home_0_0': 0,
    },
)
field_id_4080_systolic_blood_pressure_automated_reading_0_1 = TensorMap(
    '4080_Systolic-blood-pressure-automated-reading_0_1', path_prefix='continuous', loss='logcosh',
    channel_map={'4080_Systolic-blood-pressure-automated-reading_0_1': 0},
)
field_id_4079_diastolic_blood_pressure_automated_reading_0_1 = TensorMap(
    '4079_Diastolic-blood-pressure-automated-reading_0_1', path_prefix='continuous', loss='logcosh',
    channel_map={'4079_Diastolic-blood-pressure-automated-reading_0_1': 0},
)
field_id_102_pulse_rate_automated_reading_0_1 = TensorMap(
    '102_Pulse-rate-automated-reading_0_1',
    path_prefix='continuous', loss='logcosh',
    channel_map={'102_Pulse-rate-automated-reading_0_1': 0},
)
field_id_3064_peak_expiratory_flow_pef_0_0 = TensorMap(
    '3064_Peak-expiratory-flow-PEF_0_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'3064_Peak-expiratory-flow-PEF_0_0': 0},
)
field_id_3063_forced_expiratory_volume_in_1second_fev1_0_0 = TensorMap(
    '3063_Forced-expiratory-volume-in-1second-FEV1_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'3063_Forced-expiratory-volume-in-1second-FEV1_0_0': 0},
)
field_id_3062_forced_vital_capacity_fvc_0_0 = TensorMap(
    '3062_Forced-vital-capacity-FVC_0_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'3062_Forced-vital-capacity-FVC_0_0': 0},
)
field_id_3064_peak_expiratory_flow_pef_0_1 = TensorMap(
    '3064_Peak-expiratory-flow-PEF_0_1', path_prefix='continuous',
    loss='logcosh',
    channel_map={'3064_Peak-expiratory-flow-PEF_0_1': 0},
)
field_id_3063_forced_expiratory_volume_in_1second_fev1_0_1 = TensorMap(
    '3063_Forced-expiratory-volume-in-1second-FEV1_0_1', path_prefix='continuous', loss='logcosh',
    channel_map={'3063_Forced-expiratory-volume-in-1second-FEV1_0_1': 0},
)
field_id_3062_forced_vital_capacity_fvc_0_1 = TensorMap(
    '3062_Forced-vital-capacity-FVC_0_1', path_prefix='continuous',
    loss='logcosh',
    channel_map={'3062_Forced-vital-capacity-FVC_0_1': 0},
)
field_id_130_place_of_birth_in_uk_east_coordinate_0_0 = TensorMap(
    '130_Place-of-birth-in-UK-east-coordinate_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '130_Place-of-birth-in-UK-east-coordinate_0_0': 0,
    },
)
field_id_129_place_of_birth_in_uk_north_coordinate_0_0 = TensorMap(
    '129_Place-of-birth-in-UK-north-coordinate_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '129_Place-of-birth-in-UK-north-coordinate_0_0': 0,
    },
)
field_id_30890_vitamin_d_0_0 = TensorMap(
    '30890_Vitamin-D_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'30890_Vitamin-D_0_0': 0},
)
field_id_2217_age_started_wearing_glasses_or_contact_lenses_0_0 = TensorMap(
    '2217_Age-started-wearing-glasses-or-contact-lenses_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'2217_Age-started-wearing-glasses-or-contact-lenses_0_0': 0},
)
field_id_30680_calcium_0_0 = TensorMap(
    '30680_Calcium_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'30680_Calcium_0_0': 0},
)
field_id_30760_hdl_cholesterol_0_0 = TensorMap(
    '30760_HDL-cholesterol_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'30760_HDL-cholesterol_0_0': 0},
)
field_id_30860_total_protein_0_0 = TensorMap(
    '30860_Total-protein_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'30860_Total-protein_0_0': 0},
)
field_id_30740_glucose_0_0 = TensorMap(
    '30740_Glucose_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'30740_Glucose_0_0': 0},
)
field_id_30810_phosphate_0_0 = TensorMap(
    '30810_Phosphate_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'30810_Phosphate_0_0': 0},
)
field_id_30630_apolipoprotein_a_0_0 = TensorMap(
    '30630_Apolipoprotein-A_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'30630_Apolipoprotein-A_0_0': 0},
)
field_id_30850_testosterone_0_0 = TensorMap(
    '30850_Testosterone_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'30850_Testosterone_0_0': 0},
)
field_id_894_duration_of_moderate_activity_0_0 = TensorMap(
    '894_Duration-of-moderate-activity_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'894_Duration-of-moderate-activity_0_0': 0},
)
field_id_30660_direct_bilirubin_0_0 = TensorMap(
    '30660_Direct-bilirubin_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'30660_Direct-bilirubin_0_0': 0},
)
field_id_92_operation_yearage_first_occurred_0_0 = TensorMap(
    '92_Operation-yearage-first-occurred_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'92_Operation-yearage-first-occurred_0_0': 0},
)
field_id_20011_interpolated_age_of_participant_when_operation_took_place_0_0 = TensorMap(
    '20011_Interpolated-Age-of-participant-when-operation-took-place_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'20011_Interpolated-Age-of-participant-when-operation-took-place_0_0': 0},
)
field_id_1807_fathers_age_at_death_0_0 = TensorMap(
    '1807_Fathers-age-at-death_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'1807_Fathers-age-at-death_0_0': 0},
)
field_id_30790_lipoprotein_a_0_0 = TensorMap(
    '30790_Lipoprotein-A_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'30790_Lipoprotein-A_0_0': 0},
)
field_id_87_noncancer_illness_yearage_first_occurred_0_0 = TensorMap(
    '87_Noncancer-illness-yearage-first-occurred_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '87_Noncancer-illness-yearage-first-occurred_0_0': 0,
    },
)
field_id_20009_interpolated_age_of_participant_when_noncancer_illness_first_diagnosed_0_0 = TensorMap(
    '20009_Interpolated-Age-of-participant-when-noncancer-illness-first-diagnosed_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'20009_Interpolated-Age-of-participant-when-noncancer-illness-first-diagnosed_0_0': 0},
)
field_id_20150_forced_expiratory_volume_in_1second_fev1_best_measure_0_0 = TensorMap(
    '20150_Forced-expiratory-volume-in-1second-FEV1-Best-measure_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'20150_Forced-expiratory-volume-in-1second-FEV1-Best-measure_0_0': 0},
)
field_id_1608_average_weekly_fortified_wine_intake_0_0 = TensorMap(
    '1608_Average-weekly-fortified-wine-intake_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '1608_Average-weekly-fortified-wine-intake_0_0': 0,
    },
)
field_id_1598_average_weekly_spirits_intake_0_0 = TensorMap(
    '1598_Average-weekly-spirits-intake_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'1598_Average-weekly-spirits-intake_0_0': 0},
)
field_id_1588_average_weekly_beer_plus_cider_intake_0_0 = TensorMap(
    '1588_Average-weekly-beer-plus-cider-intake_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '1588_Average-weekly-beer-plus-cider-intake_0_0': 0,
    },
)
field_id_1578_average_weekly_champagne_plus_white_wine_intake_0_0 = TensorMap(
    '1578_Average-weekly-champagne-plus-white-wine-intake_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'1578_Average-weekly-champagne-plus-white-wine-intake_0_0': 0},
)
field_id_1568_average_weekly_red_wine_intake_0_0 = TensorMap(
    '1568_Average-weekly-red-wine-intake_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'1568_Average-weekly-red-wine-intake_0_0': 0},
)
field_id_3064_peak_expiratory_flow_pef_0_2 = TensorMap(
    '3064_Peak-expiratory-flow-PEF_0_2', path_prefix='continuous',
    loss='logcosh',
    channel_map={'3064_Peak-expiratory-flow-PEF_0_2': 0},
)
field_id_3063_forced_expiratory_volume_in_1second_fev1_0_2 = TensorMap(
    '3063_Forced-expiratory-volume-in-1second-FEV1_0_2', path_prefix='continuous', loss='logcosh',
    channel_map={'3063_Forced-expiratory-volume-in-1second-FEV1_0_2': 0},
)
field_id_3062_forced_vital_capacity_fvc_0_2 = TensorMap(
    '3062_Forced-vital-capacity-FVC_0_2', path_prefix='continuous',
    loss='logcosh',
    channel_map={'3062_Forced-vital-capacity-FVC_0_2': 0},
)
field_id_845_age_completed_full_time_education_0_0 = TensorMap(
    '845_Age-completed-full-time-education_0_0',
    path_prefix='continuous', loss='logcosh', channel_map={
        '845_Age-completed-full-time-education_0_0': 0,
    },
)
field_id_3526_mothers_age_at_death_0_0 = TensorMap(
    '3526_Mothers-age-at-death_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'3526_Mothers-age-at-death_0_0': 0},
)
field_id_914_duration_of_vigorous_activity_0_0 = TensorMap(
    '914_Duration-of-vigorous-activity_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'914_Duration-of-vigorous-activity_0_0': 0},
)
field_id_3148_heel_bone_mineral_density_bmd_0_0 = TensorMap(
    '3148_Heel-bone-mineral-density-BMD_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'3148_Heel-bone-mineral-density-BMD_0_0': 0},
)
field_id_3147_heel_quantitative_ultrasound_index_qui_direct_entry_0_0 = TensorMap(
    '3147_Heel-quantitative-ultrasound-index-QUI-direct-entry_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'3147_Heel-quantitative-ultrasound-index-QUI-direct-entry_0_0': 0},
)
field_id_3146_speed_of_sound_through_heel_0_0 = TensorMap(
    '3146_Speed-of-sound-through-heel_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'3146_Speed-of-sound-through-heel_0_0': 0},
)
field_id_3144_heel_broadband_ultrasound_attenuation_direct_entry_0_0 = TensorMap(
    '3144_Heel-Broadband-ultrasound-attenuation-direct-entry_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'3144_Heel-Broadband-ultrasound-attenuation-direct-entry_0_0': 0},
)
field_id_3143_ankle_spacing_width_0_0 = TensorMap(
    '3143_Ankle-spacing-width_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'3143_Ankle-spacing-width_0_0': 0},
)
field_id_20022_birth_weight_0_0 = TensorMap(
    '20022_Birth-weight_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'20022_Birth-weight_0_0': 0},
)
field_id_2734_number_of_live_births_0_0 = TensorMap(
    '2734_Number-of-live-births_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'2734_Number-of-live-births_0_0': 0},
)
field_id_2714_age_when_periods_started_menarche_0_0 = TensorMap(
    '2714_Age-when-periods-started-menarche_0_0',
    path_prefix='continuous', loss='logcosh', channel_map={
        '2714_Age-when-periods-started-menarche_0_0': 0,
    },
)
field_id_2704_years_since_last_cervical_smear_test_0_0 = TensorMap(
    '2704_Years-since-last-cervical-smear-test_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '2704_Years-since-last-cervical-smear-test_0_0': 0,
    },
)
field_id_92_operation_yearage_first_occurred_0_1 = TensorMap(
    '92_Operation-yearage-first-occurred_0_1',
    path_prefix='continuous', loss='logcosh',
    channel_map={'92_Operation-yearage-first-occurred_0_1': 0},
)
field_id_20011_interpolated_age_of_participant_when_operation_took_place_0_1 = TensorMap(
    '20011_Interpolated-Age-of-participant-when-operation-took-place_0_1', path_prefix='continuous', loss='logcosh',
    channel_map={'20011_Interpolated-Age-of-participant-when-operation-took-place_0_1': 0},
)
field_id_87_noncancer_illness_yearage_first_occurred_0_1 = TensorMap(
    '87_Noncancer-illness-yearage-first-occurred_0_1',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '87_Noncancer-illness-yearage-first-occurred_0_1': 0,
    },
)
field_id_20009_interpolated_age_of_participant_when_noncancer_illness_first_diagnosed_0_1 = TensorMap(
    '20009_Interpolated-Age-of-participant-when-noncancer-illness-first-diagnosed_0_1', path_prefix='continuous',
    loss='logcosh', channel_map={'20009_Interpolated-Age-of-participant-when-noncancer-illness-first-diagnosed_0_1': 0},
)
field_id_2405_number_of_children_fathered_0_0 = TensorMap(
    '2405_Number-of-children-fathered_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'2405_Number-of-children-fathered_0_0': 0},
)
field_id_2794_age_started_oral_contraceptive_pill_0_0 = TensorMap(
    '2794_Age-started-oral-contraceptive-pill_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '2794_Age-started-oral-contraceptive-pill_0_0': 0,
    },
)
field_id_2804_age_when_last_used_oral_contraceptive_pill_0_0 = TensorMap(
    '2804_Age-when-last-used-oral-contraceptive-pill_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'2804_Age-when-last-used-oral-contraceptive-pill_0_0': 0},
)
field_id_2744_birth_weight_of_first_child_0_0 = TensorMap(
    '2744_Birth-weight-of-first-child_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'2744_Birth-weight-of-first-child_0_0': 0},
)
field_id_2684_years_since_last_breast_cancer_screening_mammogram_0_0 = TensorMap(
    '2684_Years-since-last-breast-cancer-screening-mammogram_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'2684_Years-since-last-breast-cancer-screening-mammogram_0_0': 0},
)
field_id_404_duration_to_first_press_of_snapbutton_in_each_round_0_4 = TensorMap(
    '404_Duration-to-first-press-of-snapbutton-in-each-round_0_4', path_prefix='continuous', loss='logcosh',
    channel_map={'404_Duration-to-first-press-of-snapbutton-in-each-round_0_4': 0},
)
field_id_1845_mothers_age_0_0 = TensorMap(
    '1845_Mothers-age_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'1845_Mothers-age_0_0': 0},
)
field_id_404_duration_to_first_press_of_snapbutton_in_each_round_0_2 = TensorMap(
    '404_Duration-to-first-press-of-snapbutton-in-each-round_0_2', path_prefix='continuous', loss='logcosh',
    channel_map={'404_Duration-to-first-press-of-snapbutton-in-each-round_0_2': 0},
)
field_id_404_duration_to_first_press_of_snapbutton_in_each_round_0_0 = TensorMap(
    '404_Duration-to-first-press-of-snapbutton-in-each-round_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'404_Duration-to-first-press-of-snapbutton-in-each-round_0_0': 0},
)
field_id_404_duration_to_first_press_of_snapbutton_in_each_round_0_3 = TensorMap(
    '404_Duration-to-first-press-of-snapbutton-in-each-round_0_3', path_prefix='continuous', loss='logcosh',
    channel_map={'404_Duration-to-first-press-of-snapbutton-in-each-round_0_3': 0},
)
field_id_404_duration_to_first_press_of_snapbutton_in_each_round_0_1 = TensorMap(
    '404_Duration-to-first-press-of-snapbutton-in-each-round_0_1', path_prefix='continuous', loss='logcosh',
    channel_map={'404_Duration-to-first-press-of-snapbutton-in-each-round_0_1': 0},
)
field_id_2764_age_at_last_live_birth_0_0 = TensorMap(
    '2764_Age-at-last-live-birth_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'2764_Age-at-last-live-birth_0_0': 0},
)
field_id_2754_age_at_first_live_birth_0_0 = TensorMap(
    '2754_Age-at-first-live-birth_0_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'2754_Age-at-first-live-birth_0_0': 0},
)
field_id_4291_number_of_attempts_0_0 = TensorMap(
    '4291_Number-of-attempts_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'4291_Number-of-attempts_0_0': 0},
)
field_id_4290_duration_screen_displayed_0_0 = TensorMap(
    '4290_Duration-screen-displayed_0_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'4290_Duration-screen-displayed_0_0': 0},
)
field_id_4288_time_to_answer_0_0 = TensorMap(
    '4288_Time-to-answer_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'4288_Time-to-answer_0_0': 0},
)
field_id_4200_position_of_the_shoulder_on_the_pulse_waveform_0_0 = TensorMap(
    '4200_Position-of-the-shoulder-on-the-pulse-waveform_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'4200_Position-of-the-shoulder-on-the-pulse-waveform_0_0': 0},
)
field_id_4199_position_of_pulse_wave_notch_0_0 = TensorMap(
    '4199_Position-of-pulse-wave-notch_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'4199_Position-of-pulse-wave-notch_0_0': 0},
)
field_id_4198_position_of_the_pulse_wave_peak_0_0 = TensorMap(
    '4198_Position-of-the-pulse-wave-peak_0_0',
    path_prefix='continuous', loss='logcosh', channel_map={
        '4198_Position-of-the-pulse-wave-peak_0_0': 0,
    },
)
field_id_4195_pulse_wave_reflection_index_0_0 = TensorMap(
    '4195_Pulse-wave-reflection-index_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'4195_Pulse-wave-reflection-index_0_0': 0},
)
field_id_4194_pulse_rate_0_0 = TensorMap(
    '4194_Pulse-rate_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'4194_Pulse-rate_0_0': 0},
)
field_id_4196_pulse_wave_peak_to_peak_time_0_0 = TensorMap(
    '4196_Pulse-wave-peak-to-peak-time_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'4196_Pulse-wave-peak-to-peak-time_0_0': 0},
)
field_id_3581_age_at_menopause_last_menstrual_period_0_0 = TensorMap(
    '3581_Age-at-menopause-last-menstrual-period_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '3581_Age-at-menopause-last-menstrual-period_0_0': 0,
    },
)
field_id_21021_pulse_wave_arterial_stiffness_index_0_0 = TensorMap(
    '21021_Pulse-wave-Arterial-Stiffness-index_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '21021_Pulse-wave-Arterial-Stiffness-index_0_0': 0,
    },
)
field_id_4279_duration_of_hearing_test_right_0_0 = TensorMap(
    '4279_Duration-of-hearing-test-right_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'4279_Duration-of-hearing-test-right_0_0': 0},
)
field_id_4276_number_of_triplets_attempted_right_0_0 = TensorMap(
    '4276_Number-of-triplets-attempted-right_0_0',
    path_prefix='continuous', loss='logcosh', channel_map={
        '4276_Number-of-triplets-attempted-right_0_0': 0,
    },
)
field_id_4272_duration_of_hearing_test_left_0_0 = TensorMap(
    '4272_Duration-of-hearing-test-left_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'4272_Duration-of-hearing-test-left_0_0': 0},
)
field_id_4269_number_of_triplets_attempted_left_0_0 = TensorMap(
    '4269_Number-of-triplets-attempted-left_0_0',
    path_prefix='continuous', loss='logcosh', channel_map={
        '4269_Number-of-triplets-attempted-left_0_0': 0,
    },
)
field_id_20128_number_of_fluid_intelligence_questions_attempted_within_time_limit_0_0 = TensorMap(
    '20128_Number-of-fluid-intelligence-questions-attempted-within-time-limit_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'20128_Number-of-fluid-intelligence-questions-attempted-within-time-limit_0_0': 0},
)
field_id_20016_fluid_intelligence_score_0_0 = TensorMap(
    '20016_Fluid-intelligence-score_0_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'20016_Fluid-intelligence-score_0_0': 0},
)
field_id_4106_heel_bone_mineral_density_bmd_tscore_automated_left_0_0 = TensorMap(
    '4106_Heel-bone-mineral-density-BMD-Tscore-automated-left_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'4106_Heel-bone-mineral-density-BMD-Tscore-automated-left_0_0': 0},
)
field_id_4104_heel_quantitative_ultrasound_index_qui_direct_entry_left_0_0 = TensorMap(
    '4104_Heel-quantitative-ultrasound-index-QUI-direct-entry-left_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'4104_Heel-quantitative-ultrasound-index-QUI-direct-entry-left_0_0': 0},
)
field_id_4103_speed_of_sound_through_heel_left_0_0 = TensorMap(
    '4103_Speed-of-sound-through-heel-left_0_0',
    path_prefix='continuous', loss='logcosh', channel_map={
        '4103_Speed-of-sound-through-heel-left_0_0': 0,
    },
)
field_id_4101_heel_broadband_ultrasound_attenuation_left_0_0 = TensorMap(
    '4101_Heel-broadband-ultrasound-attenuation-left_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'4101_Heel-broadband-ultrasound-attenuation-left_0_0': 0},
)
field_id_4100_ankle_spacing_width_left_0_0 = TensorMap(
    '4100_Ankle-spacing-width-left_0_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'4100_Ankle-spacing-width-left_0_0': 0},
)
field_id_20021_speechreceptionthreshold_srt_estimate_right_0_0 = TensorMap(
    '20021_Speechreceptionthreshold-SRT-estimate-right_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'20021_Speechreceptionthreshold-SRT-estimate-right_0_0': 0},
)
field_id_4105_heel_bone_mineral_density_bmd_left_0_0 = TensorMap(
    '4105_Heel-bone-mineral-density-BMD-left_0_0',
    path_prefix='continuous', loss='logcosh', channel_map={
        '4105_Heel-bone-mineral-density-BMD-left_0_0': 0,
    },
)
field_id_20019_speechreceptionthreshold_srt_estimate_left_0_0 = TensorMap(
    '20019_Speechreceptionthreshold-SRT-estimate-left_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'20019_Speechreceptionthreshold-SRT-estimate-left_0_0': 0},
)
field_id_4125_heel_bone_mineral_density_bmd_tscore_automated_right_0_0 = TensorMap(
    '4125_Heel-bone-mineral-density-BMD-Tscore-automated-right_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'4125_Heel-bone-mineral-density-BMD-Tscore-automated-right_0_0': 0},
)
field_id_4124_heel_bone_mineral_density_bmd_right_0_0 = TensorMap(
    '4124_Heel-bone-mineral-density-BMD-right_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '4124_Heel-bone-mineral-density-BMD-right_0_0': 0,
    },
)
field_id_4123_heel_quantitative_ultrasound_index_qui_direct_entry_right_0_0 = TensorMap(
    '4123_Heel-quantitative-ultrasound-index-QUI-direct-entry-right_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'4123_Heel-quantitative-ultrasound-index-QUI-direct-entry-right_0_0': 0},
)
field_id_4122_speed_of_sound_through_heel_right_0_0 = TensorMap(
    '4122_Speed-of-sound-through-heel-right_0_0',
    path_prefix='continuous', loss='logcosh', channel_map={
        '4122_Speed-of-sound-through-heel-right_0_0': 0,
    },
)
field_id_4120_heel_broadband_ultrasound_attenuation_right_0_0 = TensorMap(
    '4120_Heel-broadband-ultrasound-attenuation-right_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'4120_Heel-broadband-ultrasound-attenuation-right_0_0': 0},
)
field_id_4119_ankle_spacing_width_right_0_0 = TensorMap(
    '4119_Ankle-spacing-width-right_0_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'4119_Ankle-spacing-width-right_0_0': 0},
)
field_id_30500_microalbumin_in_urine_0_0 = TensorMap(
    '30500_Microalbumin-in-urine_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'30500_Microalbumin-in-urine_0_0': 0},
)
field_id_2355_most_recent_bowel_cancer_screening_0_0 = TensorMap(
    '2355_Most-recent-bowel-cancer-screening_0_0',
    path_prefix='continuous', loss='logcosh', channel_map={
        '2355_Most-recent-bowel-cancer-screening_0_0': 0,
    },
)
field_id_20153_forced_expiratory_volume_in_1second_fev1_predicted_0_0 = TensorMap(
    '20153_Forced-expiratory-volume-in-1second-FEV1-predicted_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'20153_Forced-expiratory-volume-in-1second-FEV1-predicted_0_0': 0},
)
field_id_5057_number_of_older_siblings_0_0 = TensorMap(
    '5057_Number-of-older-siblings_0_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'5057_Number-of-older-siblings_0_0': 0},
)
field_id_20162_pack_years_adult_smoking_as_proportion_of_life_span_exposed_to_smoking_0_0 = TensorMap(
    '20162_Pack-years-adult-smoking-as-proportion-of-life-span-exposed-to-smoking_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'20162_Pack-years-adult-smoking-as-proportion-of-life-span-exposed-to-smoking_0_0': 0},
)
field_id_20161_pack_years_of_smoking_0_0 = TensorMap(
    '20161_Pack-years-of-smoking_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'20161_Pack-years-of-smoking_0_0': 0},
)
field_id_87_noncancer_illness_yearage_first_occurred_0_2 = TensorMap(
    '87_Noncancer-illness-yearage-first-occurred_0_2',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '87_Noncancer-illness-yearage-first-occurred_0_2': 0,
    },
)
field_id_20009_interpolated_age_of_participant_when_noncancer_illness_first_diagnosed_0_2 = TensorMap(
    '20009_Interpolated-Age-of-participant-when-noncancer-illness-first-diagnosed_0_2', path_prefix='continuous',
    loss='logcosh', channel_map={'20009_Interpolated-Age-of-participant-when-noncancer-illness-first-diagnosed_0_2': 0},
)
field_id_92_operation_yearage_first_occurred_0_2 = TensorMap(
    '92_Operation-yearage-first-occurred_0_2',
    path_prefix='continuous', loss='logcosh',
    channel_map={'92_Operation-yearage-first-occurred_0_2': 0},
)
field_id_20011_interpolated_age_of_participant_when_operation_took_place_0_2 = TensorMap(
    '20011_Interpolated-Age-of-participant-when-operation-took-place_0_2', path_prefix='continuous', loss='logcosh',
    channel_map={'20011_Interpolated-Age-of-participant-when-operation-took-place_0_2': 0},
)
field_id_2966_age_high_blood_pressure_diagnosed_0_0 = TensorMap(
    '2966_Age-high-blood-pressure-diagnosed_0_0',
    path_prefix='continuous', loss='logcosh', channel_map={
        '2966_Age-high-blood-pressure-diagnosed_0_0': 0,
    },
)
field_id_20191_fluid_intelligence_score_0_0 = TensorMap(
    '20191_Fluid-intelligence-score_0_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'20191_Fluid-intelligence-score_0_0': 0},
)
field_id_2946_fathers_age_0_0 = TensorMap(
    '2946_Fathers-age_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'2946_Fathers-age_0_0': 0},
)
field_id_20159_number_of_symbol_digit_matches_made_correctly_0_0 = TensorMap(
    '20159_Number-of-symbol-digit-matches-made-correctly_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'20159_Number-of-symbol-digit-matches-made-correctly_0_0': 0},
)
field_id_3761_age_hay_fever_rhinitis_or_eczema_diagnosed_0_0 = TensorMap(
    '3761_Age-hay-fever-rhinitis-or-eczema-diagnosed_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'3761_Age-hay-fever-rhinitis-or-eczema-diagnosed_0_0': 0},
)
field_id_22200_year_of_birth_0_0 = TensorMap(
    '22200_Year-of-birth_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'22200_Year-of-birth_0_0': 0},
)
field_id_22603_year_job_ended_0_0 = TensorMap(
    '22603_Year-job-ended_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'22603_Year-job-ended_0_0': 0},
)
field_id_22602_year_job_started_0_0 = TensorMap(
    '22602_Year-job-started_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'22602_Year-job-started_0_0': 0},
)
field_id_5188_duration_visualacuity_screen_displayed_left_0_0 = TensorMap(
    '5188_Duration-visualacuity-screen-displayed-left_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'5188_Duration-visualacuity-screen-displayed-left_0_0': 0},
)
field_id_5186_duration_visualacuity_screen_displayed_right_0_0 = TensorMap(
    '5186_Duration-visualacuity-screen-displayed-right_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'5186_Duration-visualacuity-screen-displayed-right_0_0': 0},
)
field_id_5204_distance_of_viewer_to_screen_right_0_0 = TensorMap(
    '5204_Distance-of-viewer-to-screen-right_0_0',
    path_prefix='continuous', loss='logcosh', channel_map={
        '5204_Distance-of-viewer-to-screen-right_0_0': 0,
    },
)
field_id_5202_number_of_rounds_to_result_right_0_0 = TensorMap(
    '5202_Number-of-rounds-to-result-right_0_0',
    path_prefix='continuous', loss='logcosh', channel_map={
        '5202_Number-of-rounds-to-result-right_0_0': 0,
    },
)
field_id_5200_final_number_of_letters_displayed_right_0_0 = TensorMap(
    '5200_Final-number-of-letters-displayed-right_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'5200_Final-number-of-letters-displayed-right_0_0': 0},
)
field_id_5199_logmar_initial_right_0_0 = TensorMap(
    '5199_logMAR-initial-right_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'5199_logMAR-initial-right_0_0': 0},
)
field_id_5079_logmar_in_round_right_0_0 = TensorMap(
    '5079_logMAR-in-round-right_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'5079_logMAR-in-round-right_0_0': 0},
)
field_id_5076_number_of_letters_correct_in_round_right_0_0 = TensorMap(
    '5076_Number-of-letters-correct-in-round-right_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'5076_Number-of-letters-correct-in-round-right_0_0': 0},
)
field_id_5075_number_of_letters_shown_in_round_right_0_0 = TensorMap(
    '5075_Number-of-letters-shown-in-round-right_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '5075_Number-of-letters-shown-in-round-right_0_0': 0,
    },
)
field_id_5211_distance_of_viewer_to_screen_left_0_0 = TensorMap(
    '5211_Distance-of-viewer-to-screen-left_0_0',
    path_prefix='continuous', loss='logcosh', channel_map={
        '5211_Distance-of-viewer-to-screen-left_0_0': 0,
    },
)
field_id_5209_number_of_rounds_to_result_left_0_0 = TensorMap(
    '5209_Number-of-rounds-to-result-left_0_0',
    path_prefix='continuous', loss='logcosh', channel_map={
        '5209_Number-of-rounds-to-result-left_0_0': 0,
    },
)
field_id_5207_final_number_of_letters_displayed_left_0_0 = TensorMap(
    '5207_Final-number-of-letters-displayed-left_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '5207_Final-number-of-letters-displayed-left_0_0': 0,
    },
)
field_id_5206_logmar_initial_left_0_0 = TensorMap(
    '5206_logMAR-initial-left_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'5206_logMAR-initial-left_0_0': 0},
)
field_id_5078_logmar_in_round_left_0_0 = TensorMap(
    '5078_logMAR-in-round-left_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'5078_logMAR-in-round-left_0_0': 0},
)
field_id_5077_number_of_letters_correct_in_round_left_0_0 = TensorMap(
    '5077_Number-of-letters-correct-in-round-left_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'5077_Number-of-letters-correct-in-round-left_0_0': 0},
)
field_id_5074_number_of_letters_shown_in_round_left_0_0 = TensorMap(
    '5074_Number-of-letters-shown-in-round-left_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '5074_Number-of-letters-shown-in-round-left_0_0': 0,
    },
)
field_id_5193_duration_at_which_refractometer_first_shown_left_0_0 = TensorMap(
    '5193_Duration-at-which-refractometer-first-shown-left_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'5193_Duration-at-which-refractometer-first-shown-left_0_0': 0},
)
field_id_5190_duration_at_which_refractometer_first_shown_right_0_0 = TensorMap(
    '5190_Duration-at-which-refractometer-first-shown-right_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'5190_Duration-at-which-refractometer-first-shown-right_0_0': 0},
)
field_id_5201_logmar_final_right_0_0 = TensorMap(
    '5201_logMAR-final-right_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'5201_logMAR-final-right_0_0': 0},
)
field_id_5208_logmar_final_left_0_0 = TensorMap(
    '5208_logMAR-final-left_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'5208_logMAR-final-left_0_0': 0},
)
field_id_5364_average_weekly_intake_of_other_alcoholic_drinks_0_0 = TensorMap(
    '5364_Average-weekly-intake-of-other-alcoholic-drinks_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'5364_Average-weekly-intake-of-other-alcoholic-drinks_0_0': 0},
)
field_id_5221_index_of_best_refractometry_result_right_0_0 = TensorMap(
    '5221_Index-of-best-refractometry-result-right_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'5221_Index-of-best-refractometry-result-right_0_0': 0},
)
field_id_5215_vertex_distance_right_0_0 = TensorMap(
    '5215_Vertex-distance-right_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'5215_Vertex-distance-right_0_0': 0},
)
field_id_5088_astigmatism_angle_right_0_0 = TensorMap(
    '5088_Astigmatism-angle-right_0_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'5088_Astigmatism-angle-right_0_0': 0},
)
field_id_5087_cylindrical_power_right_0_0 = TensorMap(
    '5087_Cylindrical-power-right_0_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'5087_Cylindrical-power-right_0_0': 0},
)
field_id_5084_spherical_power_right_0_0 = TensorMap(
    '5084_Spherical-power-right_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'5084_Spherical-power-right_0_0': 0},
)
field_id_5088_astigmatism_angle_right_0_1 = TensorMap(
    '5088_Astigmatism-angle-right_0_1', path_prefix='continuous',
    loss='logcosh',
    channel_map={'5088_Astigmatism-angle-right_0_1': 0},
)
field_id_5087_cylindrical_power_right_0_1 = TensorMap(
    '5087_Cylindrical-power-right_0_1', path_prefix='continuous',
    loss='logcosh',
    channel_map={'5087_Cylindrical-power-right_0_1': 0},
)
field_id_5084_spherical_power_right_0_1 = TensorMap(
    '5084_Spherical-power-right_0_1', path_prefix='continuous',
    loss='logcosh', channel_map={'5084_Spherical-power-right_0_1': 0},
)
field_id_5088_astigmatism_angle_right_0_2 = TensorMap(
    '5088_Astigmatism-angle-right_0_2', path_prefix='continuous',
    loss='logcosh',
    channel_map={'5088_Astigmatism-angle-right_0_2': 0},
)
field_id_5087_cylindrical_power_right_0_2 = TensorMap(
    '5087_Cylindrical-power-right_0_2', path_prefix='continuous',
    loss='logcosh',
    channel_map={'5087_Cylindrical-power-right_0_2': 0},
)
field_id_5084_spherical_power_right_0_2 = TensorMap(
    '5084_Spherical-power-right_0_2', path_prefix='continuous',
    loss='logcosh', channel_map={'5084_Spherical-power-right_0_2': 0},
)
field_id_22661_number_of_gap_periods_0_0 = TensorMap(
    '22661_Number-of-gap-periods_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'22661_Number-of-gap-periods_0_0': 0},
)
field_id_22599_number_of_jobs_held_0_0 = TensorMap(
    '22599_Number-of-jobs-held_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'22599_Number-of-jobs-held_0_0': 0},
)
field_id_30414_volume_of_rna_held_by_ukb_0_0 = TensorMap(
    '30414_Volume-of-RNA-held-by-UKB_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'30414_Volume-of-RNA-held-by-UKB_0_0': 0},
)
field_id_5276_index_of_best_refractometry_result_left_0_0 = TensorMap(
    '5276_Index-of-best-refractometry-result-left_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'5276_Index-of-best-refractometry-result-left_0_0': 0},
)
field_id_5274_vertex_distance_left_0_0 = TensorMap(
    '5274_Vertex-distance-left_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'5274_Vertex-distance-left_0_0': 0},
)
field_id_5089_astigmatism_angle_left_0_0 = TensorMap(
    '5089_Astigmatism-angle-left_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'5089_Astigmatism-angle-left_0_0': 0},
)
field_id_5086_cylindrical_power_left_0_0 = TensorMap(
    '5086_Cylindrical-power-left_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'5086_Cylindrical-power-left_0_0': 0},
)
field_id_5085_spherical_power_left_0_0 = TensorMap(
    '5085_Spherical-power-left_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'5085_Spherical-power-left_0_0': 0},
)
field_id_5089_astigmatism_angle_left_0_1 = TensorMap(
    '5089_Astigmatism-angle-left_0_1', path_prefix='continuous',
    loss='logcosh', channel_map={'5089_Astigmatism-angle-left_0_1': 0},
)
field_id_5086_cylindrical_power_left_0_1 = TensorMap(
    '5086_Cylindrical-power-left_0_1', path_prefix='continuous',
    loss='logcosh', channel_map={'5086_Cylindrical-power-left_0_1': 0},
)
field_id_5085_spherical_power_left_0_1 = TensorMap(
    '5085_Spherical-power-left_0_1', path_prefix='continuous',
    loss='logcosh', channel_map={'5085_Spherical-power-left_0_1': 0},
)
field_id_5089_astigmatism_angle_left_0_2 = TensorMap(
    '5089_Astigmatism-angle-left_0_2', path_prefix='continuous',
    loss='logcosh', channel_map={'5089_Astigmatism-angle-left_0_2': 0},
)
field_id_5086_cylindrical_power_left_0_2 = TensorMap(
    '5086_Cylindrical-power-left_0_2', path_prefix='continuous',
    loss='logcosh', channel_map={'5086_Cylindrical-power-left_0_2': 0},
)
field_id_5085_spherical_power_left_0_2 = TensorMap(
    '5085_Spherical-power-left_0_2', path_prefix='continuous',
    loss='logcosh', channel_map={'5085_Spherical-power-left_0_2': 0},
)
field_id_2897_age_stopped_smoking_0_0 = TensorMap(
    '2897_Age-stopped-smoking_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'2897_Age-stopped-smoking_0_0': 0},
)
field_id_2867_age_started_smoking_in_former_smokers_0_0 = TensorMap(
    '2867_Age-started-smoking-in-former-smokers_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '2867_Age-started-smoking-in-former-smokers_0_0': 0,
    },
)
field_id_5257_corneal_resistance_factor_right_0_0 = TensorMap(
    '5257_Corneal-resistance-factor-right_0_0',
    path_prefix='continuous', loss='logcosh', channel_map={
        '5257_Corneal-resistance-factor-right_0_0': 0,
    },
)
field_id_5256_corneal_hysteresis_right_0_0 = TensorMap(
    '5256_Corneal-hysteresis-right_0_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'5256_Corneal-hysteresis-right_0_0': 0},
)
field_id_5255_intraocular_pressure_goldmanncorrelated_right_0_0 = TensorMap(
    '5255_Intraocular-pressure-Goldmanncorrelated-right_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'5255_Intraocular-pressure-Goldmanncorrelated-right_0_0': 0},
)
field_id_5254_intraocular_pressure_cornealcompensated_right_0_0 = TensorMap(
    '5254_Intraocular-pressure-cornealcompensated-right_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'5254_Intraocular-pressure-cornealcompensated-right_0_0': 0},
)
field_id_2926_number_of_unsuccessful_stopsmoking_attempts_0_0 = TensorMap(
    '2926_Number-of-unsuccessful-stopsmoking-attempts_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'2926_Number-of-unsuccessful-stopsmoking-attempts_0_0': 0},
)
field_id_5265_corneal_resistance_factor_left_0_0 = TensorMap(
    '5265_Corneal-resistance-factor-left_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'5265_Corneal-resistance-factor-left_0_0': 0},
)
field_id_5264_corneal_hysteresis_left_0_0 = TensorMap(
    '5264_Corneal-hysteresis-left_0_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'5264_Corneal-hysteresis-left_0_0': 0},
)
field_id_5263_intraocular_pressure_goldmanncorrelated_left_0_0 = TensorMap(
    '5263_Intraocular-pressure-Goldmanncorrelated-left_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'5263_Intraocular-pressure-Goldmanncorrelated-left_0_0': 0},
)
field_id_5262_intraocular_pressure_cornealcompensated_left_0_0 = TensorMap(
    '5262_Intraocular-pressure-cornealcompensated-left_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'5262_Intraocular-pressure-cornealcompensated-left_0_0': 0},
)
field_id_5292_3mm_index_of_best_keratometry_results_left_0_0 = TensorMap(
    '5292_3mm-index-of-best-keratometry-results-left_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'5292_3mm-index-of-best-keratometry-results-left_0_0': 0},
)
field_id_5135_3mm_strong_meridian_left_0_0 = TensorMap(
    '5135_3mm-strong-meridian-left_0_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'5135_3mm-strong-meridian-left_0_0': 0},
)
field_id_5119_3mm_cylindrical_power_left_0_0 = TensorMap(
    '5119_3mm-cylindrical-power-left_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'5119_3mm-cylindrical-power-left_0_0': 0},
)
field_id_5112_3mm_cylindrical_power_angle_left_0_0 = TensorMap(
    '5112_3mm-cylindrical-power-angle-left_0_0',
    path_prefix='continuous', loss='logcosh', channel_map={
        '5112_3mm-cylindrical-power-angle-left_0_0': 0,
    },
)
field_id_5104_3mm_strong_meridian_angle_left_0_0 = TensorMap(
    '5104_3mm-strong-meridian-angle-left_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'5104_3mm-strong-meridian-angle-left_0_0': 0},
)
field_id_5103_3mm_weak_meridian_angle_left_0_0 = TensorMap(
    '5103_3mm-weak-meridian-angle-left_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'5103_3mm-weak-meridian-angle-left_0_0': 0},
)
field_id_5096_3mm_weak_meridian_left_0_0 = TensorMap(
    '5096_3mm-weak-meridian-left_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'5096_3mm-weak-meridian-left_0_0': 0},
)
field_id_5237_3mm_index_of_best_keratometry_results_right_0_0 = TensorMap(
    '5237_3mm-index-of-best-keratometry-results-right_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'5237_3mm-index-of-best-keratometry-results-right_0_0': 0},
)
field_id_5132_3mm_strong_meridian_right_0_0 = TensorMap(
    '5132_3mm-strong-meridian-right_0_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'5132_3mm-strong-meridian-right_0_0': 0},
)
field_id_5116_3mm_cylindrical_power_right_0_0 = TensorMap(
    '5116_3mm-cylindrical-power-right_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'5116_3mm-cylindrical-power-right_0_0': 0},
)
field_id_5107_3mm_strong_meridian_angle_right_0_0 = TensorMap(
    '5107_3mm-strong-meridian-angle-right_0_0',
    path_prefix='continuous', loss='logcosh', channel_map={
        '5107_3mm-strong-meridian-angle-right_0_0': 0,
    },
)
field_id_5100_3mm_weak_meridian_angle_right_0_0 = TensorMap(
    '5100_3mm-weak-meridian-angle-right_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'5100_3mm-weak-meridian-angle-right_0_0': 0},
)
field_id_5099_3mm_weak_meridian_right_0_0 = TensorMap(
    '5099_3mm-weak-meridian-right_0_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'5099_3mm-weak-meridian-right_0_0': 0},
)
field_id_5115_3mm_cylindrical_power_angle_right_0_0 = TensorMap(
    '5115_3mm-cylindrical-power-angle-right_0_0',
    path_prefix='continuous', loss='logcosh', channel_map={
        '5115_3mm-cylindrical-power-angle-right_0_0': 0,
    },
)
field_id_2887_number_of_cigarettes_previously_smoked_daily_0_0 = TensorMap(
    '2887_Number-of-cigarettes-previously-smoked-daily_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'2887_Number-of-cigarettes-previously-smoked-daily_0_0': 0},
)
field_id_5135_3mm_strong_meridian_left_0_1 = TensorMap(
    '5135_3mm-strong-meridian-left_0_1', path_prefix='continuous',
    loss='logcosh',
    channel_map={'5135_3mm-strong-meridian-left_0_1': 0},
)
field_id_5119_3mm_cylindrical_power_left_0_1 = TensorMap(
    '5119_3mm-cylindrical-power-left_0_1',
    path_prefix='continuous', loss='logcosh',
    channel_map={'5119_3mm-cylindrical-power-left_0_1': 0},
)
field_id_5104_3mm_strong_meridian_angle_left_0_1 = TensorMap(
    '5104_3mm-strong-meridian-angle-left_0_1',
    path_prefix='continuous', loss='logcosh',
    channel_map={'5104_3mm-strong-meridian-angle-left_0_1': 0},
)
field_id_5103_3mm_weak_meridian_angle_left_0_1 = TensorMap(
    '5103_3mm-weak-meridian-angle-left_0_1',
    path_prefix='continuous', loss='logcosh',
    channel_map={'5103_3mm-weak-meridian-angle-left_0_1': 0},
)
field_id_5096_3mm_weak_meridian_left_0_1 = TensorMap(
    '5096_3mm-weak-meridian-left_0_1', path_prefix='continuous',
    loss='logcosh', channel_map={'5096_3mm-weak-meridian-left_0_1': 0},
)
field_id_5112_3mm_cylindrical_power_angle_left_0_1 = TensorMap(
    '5112_3mm-cylindrical-power-angle-left_0_1',
    path_prefix='continuous', loss='logcosh', channel_map={
        '5112_3mm-cylindrical-power-angle-left_0_1': 0,
    },
)
field_id_5160_3mm_regularity_index_right_0_0 = TensorMap(
    '5160_3mm-regularity-index-right_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'5160_3mm-regularity-index-right_0_0': 0},
)
field_id_5159_3mm_asymmetry_index_right_0_0 = TensorMap(
    '5159_3mm-asymmetry-index-right_0_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'5159_3mm-asymmetry-index-right_0_0': 0},
)
field_id_5108_3mm_asymmetry_angle_right_0_0 = TensorMap(
    '5108_3mm-asymmetry-angle-right_0_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'5108_3mm-asymmetry-angle-right_0_0': 0},
)
field_id_5132_3mm_strong_meridian_right_0_1 = TensorMap(
    '5132_3mm-strong-meridian-right_0_1', path_prefix='continuous',
    loss='logcosh',
    channel_map={'5132_3mm-strong-meridian-right_0_1': 0},
)
field_id_5116_3mm_cylindrical_power_right_0_1 = TensorMap(
    '5116_3mm-cylindrical-power-right_0_1',
    path_prefix='continuous', loss='logcosh',
    channel_map={'5116_3mm-cylindrical-power-right_0_1': 0},
)
field_id_5107_3mm_strong_meridian_angle_right_0_1 = TensorMap(
    '5107_3mm-strong-meridian-angle-right_0_1',
    path_prefix='continuous', loss='logcosh', channel_map={
        '5107_3mm-strong-meridian-angle-right_0_1': 0,
    },
)
field_id_5100_3mm_weak_meridian_angle_right_0_1 = TensorMap(
    '5100_3mm-weak-meridian-angle-right_0_1',
    path_prefix='continuous', loss='logcosh',
    channel_map={'5100_3mm-weak-meridian-angle-right_0_1': 0},
)
field_id_5099_3mm_weak_meridian_right_0_1 = TensorMap(
    '5099_3mm-weak-meridian-right_0_1', path_prefix='continuous',
    loss='logcosh',
    channel_map={'5099_3mm-weak-meridian-right_0_1': 0},
)
field_id_3546_age_last_used_hormonereplacement_therapy_hrt_0_0 = TensorMap(
    '3546_Age-last-used-hormonereplacement-therapy-HRT_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'3546_Age-last-used-hormonereplacement-therapy-HRT_0_0': 0},
)
field_id_3536_age_started_hormonereplacement_therapy_hrt_0_0 = TensorMap(
    '3536_Age-started-hormonereplacement-therapy-HRT_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'3536_Age-started-hormonereplacement-therapy-HRT_0_0': 0},
)
field_id_5115_3mm_cylindrical_power_angle_right_0_1 = TensorMap(
    '5115_3mm-cylindrical-power-angle-right_0_1',
    path_prefix='continuous', loss='logcosh', channel_map={
        '5115_3mm-cylindrical-power-angle-right_0_1': 0,
    },
)
field_id_90013_standard_deviation_of_acceleration_0_0 = TensorMap(
    '90013_Standard-deviation-of-acceleration_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '90013_Standard-deviation-of-acceleration_0_0': 0,
    },
)
field_id_90012_overall_acceleration_average_0_0 = TensorMap(
    '90012_Overall-acceleration-average_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'90012_Overall-acceleration-average_0_0': 0},
)
field_id_5163_3mm_regularity_index_left_0_0 = TensorMap(
    '5163_3mm-regularity-index-left_0_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'5163_3mm-regularity-index-left_0_0': 0},
)
field_id_5156_3mm_asymmetry_index_left_0_0 = TensorMap(
    '5156_3mm-asymmetry-index-left_0_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'5156_3mm-asymmetry-index-left_0_0': 0},
)
field_id_5111_3mm_asymmetry_angle_left_0_0 = TensorMap(
    '5111_3mm-asymmetry-angle-left_0_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'5111_3mm-asymmetry-angle-left_0_0': 0},
)
field_id_5160_3mm_regularity_index_right_0_1 = TensorMap(
    '5160_3mm-regularity-index-right_0_1',
    path_prefix='continuous', loss='logcosh',
    channel_map={'5160_3mm-regularity-index-right_0_1': 0},
)
field_id_5159_3mm_asymmetry_index_right_0_1 = TensorMap(
    '5159_3mm-asymmetry-index-right_0_1', path_prefix='continuous',
    loss='logcosh',
    channel_map={'5159_3mm-asymmetry-index-right_0_1': 0},
)
field_id_5108_3mm_asymmetry_angle_right_0_1 = TensorMap(
    '5108_3mm-asymmetry-angle-right_0_1', path_prefix='continuous',
    loss='logcosh',
    channel_map={'5108_3mm-asymmetry-angle-right_0_1': 0},
)
field_id_5163_3mm_regularity_index_left_0_1 = TensorMap(
    '5163_3mm-regularity-index-left_0_1', path_prefix='continuous',
    loss='logcosh',
    channel_map={'5163_3mm-regularity-index-left_0_1': 0},
)
field_id_5156_3mm_asymmetry_index_left_0_1 = TensorMap(
    '5156_3mm-asymmetry-index-left_0_1', path_prefix='continuous',
    loss='logcosh',
    channel_map={'5156_3mm-asymmetry-index-left_0_1': 0},
)
field_id_5111_3mm_asymmetry_angle_left_0_1 = TensorMap(
    '5111_3mm-asymmetry-angle-left_0_1', path_prefix='continuous',
    loss='logcosh',
    channel_map={'5111_3mm-asymmetry-angle-left_0_1': 0},
)
field_id_5078_logmar_in_round_left_0_1 = TensorMap(
    '5078_logMAR-in-round-left_0_1', path_prefix='continuous',
    loss='logcosh', channel_map={'5078_logMAR-in-round-left_0_1': 0},
)
field_id_5077_number_of_letters_correct_in_round_left_0_1 = TensorMap(
    '5077_Number-of-letters-correct-in-round-left_0_1', path_prefix='continuous', loss='logcosh',
    channel_map={'5077_Number-of-letters-correct-in-round-left_0_1': 0},
)
field_id_5074_number_of_letters_shown_in_round_left_0_1 = TensorMap(
    '5074_Number-of-letters-shown-in-round-left_0_1',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '5074_Number-of-letters-shown-in-round-left_0_1': 0,
    },
)
field_id_5135_3mm_strong_meridian_left_0_2 = TensorMap(
    '5135_3mm-strong-meridian-left_0_2', path_prefix='continuous',
    loss='logcosh',
    channel_map={'5135_3mm-strong-meridian-left_0_2': 0},
)
field_id_5119_3mm_cylindrical_power_left_0_2 = TensorMap(
    '5119_3mm-cylindrical-power-left_0_2',
    path_prefix='continuous', loss='logcosh',
    channel_map={'5119_3mm-cylindrical-power-left_0_2': 0},
)
field_id_5104_3mm_strong_meridian_angle_left_0_2 = TensorMap(
    '5104_3mm-strong-meridian-angle-left_0_2',
    path_prefix='continuous', loss='logcosh',
    channel_map={'5104_3mm-strong-meridian-angle-left_0_2': 0},
)
field_id_5103_3mm_weak_meridian_angle_left_0_2 = TensorMap(
    '5103_3mm-weak-meridian-angle-left_0_2',
    path_prefix='continuous', loss='logcosh',
    channel_map={'5103_3mm-weak-meridian-angle-left_0_2': 0},
)
field_id_5096_3mm_weak_meridian_left_0_2 = TensorMap(
    '5096_3mm-weak-meridian-left_0_2', path_prefix='continuous',
    loss='logcosh', channel_map={'5096_3mm-weak-meridian-left_0_2': 0},
)
field_id_5079_logmar_in_round_right_0_1 = TensorMap(
    '5079_logMAR-in-round-right_0_1', path_prefix='continuous',
    loss='logcosh', channel_map={'5079_logMAR-in-round-right_0_1': 0},
)
field_id_5076_number_of_letters_correct_in_round_right_0_1 = TensorMap(
    '5076_Number-of-letters-correct-in-round-right_0_1', path_prefix='continuous', loss='logcosh',
    channel_map={'5076_Number-of-letters-correct-in-round-right_0_1': 0},
)
field_id_5075_number_of_letters_shown_in_round_right_0_1 = TensorMap(
    '5075_Number-of-letters-shown-in-round-right_0_1',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '5075_Number-of-letters-shown-in-round-right_0_1': 0,
    },
)
field_id_5112_3mm_cylindrical_power_angle_left_0_2 = TensorMap(
    '5112_3mm-cylindrical-power-angle-left_0_2',
    path_prefix='continuous', loss='logcosh', channel_map={
        '5112_3mm-cylindrical-power-angle-left_0_2': 0,
    },
)
field_id_5163_3mm_regularity_index_left_0_2 = TensorMap(
    '5163_3mm-regularity-index-left_0_2', path_prefix='continuous',
    loss='logcosh',
    channel_map={'5163_3mm-regularity-index-left_0_2': 0},
)
field_id_5156_3mm_asymmetry_index_left_0_2 = TensorMap(
    '5156_3mm-asymmetry-index-left_0_2', path_prefix='continuous',
    loss='logcosh',
    channel_map={'5156_3mm-asymmetry-index-left_0_2': 0},
)
field_id_5111_3mm_asymmetry_angle_left_0_2 = TensorMap(
    '5111_3mm-asymmetry-angle-left_0_2', path_prefix='continuous',
    loss='logcosh',
    channel_map={'5111_3mm-asymmetry-angle-left_0_2': 0},
)
field_id_5132_3mm_strong_meridian_right_0_2 = TensorMap(
    '5132_3mm-strong-meridian-right_0_2', path_prefix='continuous',
    loss='logcosh',
    channel_map={'5132_3mm-strong-meridian-right_0_2': 0},
)
field_id_5116_3mm_cylindrical_power_right_0_2 = TensorMap(
    '5116_3mm-cylindrical-power-right_0_2',
    path_prefix='continuous', loss='logcosh',
    channel_map={'5116_3mm-cylindrical-power-right_0_2': 0},
)
field_id_5107_3mm_strong_meridian_angle_right_0_2 = TensorMap(
    '5107_3mm-strong-meridian-angle-right_0_2',
    path_prefix='continuous', loss='logcosh', channel_map={
        '5107_3mm-strong-meridian-angle-right_0_2': 0,
    },
)
field_id_5100_3mm_weak_meridian_angle_right_0_2 = TensorMap(
    '5100_3mm-weak-meridian-angle-right_0_2',
    path_prefix='continuous', loss='logcosh',
    channel_map={'5100_3mm-weak-meridian-angle-right_0_2': 0},
)
field_id_5099_3mm_weak_meridian_right_0_2 = TensorMap(
    '5099_3mm-weak-meridian-right_0_2', path_prefix='continuous',
    loss='logcosh',
    channel_map={'5099_3mm-weak-meridian-right_0_2': 0},
)
field_id_5115_3mm_cylindrical_power_angle_right_0_2 = TensorMap(
    '5115_3mm-cylindrical-power-angle-right_0_2',
    path_prefix='continuous', loss='logcosh', channel_map={
        '5115_3mm-cylindrical-power-angle-right_0_2': 0,
    },
)
field_id_5306_6mm_index_of_best_keratometry_results_left_0_0 = TensorMap(
    '5306_6mm-index-of-best-keratometry-results-left_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'5306_6mm-index-of-best-keratometry-results-left_0_0': 0},
)
field_id_5134_6mm_strong_meridian_left_0_0 = TensorMap(
    '5134_6mm-strong-meridian-left_0_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'5134_6mm-strong-meridian-left_0_0': 0},
)
field_id_5118_6mm_cylindrical_power_left_0_0 = TensorMap(
    '5118_6mm-cylindrical-power-left_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'5118_6mm-cylindrical-power-left_0_0': 0},
)
field_id_5113_6mm_cylindrical_power_angle_left_0_0 = TensorMap(
    '5113_6mm-cylindrical-power-angle-left_0_0',
    path_prefix='continuous', loss='logcosh', channel_map={
        '5113_6mm-cylindrical-power-angle-left_0_0': 0,
    },
)
field_id_5105_6mm_strong_meridian_angle_left_0_0 = TensorMap(
    '5105_6mm-strong-meridian-angle-left_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'5105_6mm-strong-meridian-angle-left_0_0': 0},
)
field_id_5102_6mm_weak_meridian_angle_left_0_0 = TensorMap(
    '5102_6mm-weak-meridian-angle-left_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'5102_6mm-weak-meridian-angle-left_0_0': 0},
)
field_id_5097_6mm_weak_meridian_left_0_0 = TensorMap(
    '5097_6mm-weak-meridian-left_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'5097_6mm-weak-meridian-left_0_0': 0},
)
field_id_5251_6mm_index_of_best_keratometry_results_right_0_0 = TensorMap(
    '5251_6mm-index-of-best-keratometry-results-right_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'5251_6mm-index-of-best-keratometry-results-right_0_0': 0},
)
field_id_5133_6mm_strong_meridian_right_0_0 = TensorMap(
    '5133_6mm-strong-meridian-right_0_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'5133_6mm-strong-meridian-right_0_0': 0},
)
field_id_5117_6mm_cylindrical_power_right_0_0 = TensorMap(
    '5117_6mm-cylindrical-power-right_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'5117_6mm-cylindrical-power-right_0_0': 0},
)
field_id_5106_6mm_strong_meridian_angle_right_0_0 = TensorMap(
    '5106_6mm-strong-meridian-angle-right_0_0',
    path_prefix='continuous', loss='logcosh', channel_map={
        '5106_6mm-strong-meridian-angle-right_0_0': 0,
    },
)
field_id_5101_6mm_weak_meridian_angle_right_0_0 = TensorMap(
    '5101_6mm-weak-meridian-angle-right_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'5101_6mm-weak-meridian-angle-right_0_0': 0},
)
field_id_5098_6mm_weak_meridian_right_0_0 = TensorMap(
    '5098_6mm-weak-meridian-right_0_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'5098_6mm-weak-meridian-right_0_0': 0},
)
field_id_5160_3mm_regularity_index_right_0_2 = TensorMap(
    '5160_3mm-regularity-index-right_0_2',
    path_prefix='continuous', loss='logcosh',
    channel_map={'5160_3mm-regularity-index-right_0_2': 0},
)
field_id_5159_3mm_asymmetry_index_right_0_2 = TensorMap(
    '5159_3mm-asymmetry-index-right_0_2', path_prefix='continuous',
    loss='logcosh',
    channel_map={'5159_3mm-asymmetry-index-right_0_2': 0},
)
field_id_5108_3mm_asymmetry_angle_right_0_2 = TensorMap(
    '5108_3mm-asymmetry-angle-right_0_2', path_prefix='continuous',
    loss='logcosh',
    channel_map={'5108_3mm-asymmetry-angle-right_0_2': 0},
)
field_id_5114_6mm_cylindrical_power_angle_right_0_0 = TensorMap(
    '5114_6mm-cylindrical-power-angle-right_0_0',
    path_prefix='continuous', loss='logcosh', channel_map={
        '5114_6mm-cylindrical-power-angle-right_0_0': 0,
    },
)
field_id_22664_year_gap_ended_0_0 = TensorMap(
    '22664_Year-gap-ended_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'22664_Year-gap-ended_0_0': 0},
)
field_id_22663_year_gap_started_0_0 = TensorMap(
    '22663_Year-gap-started_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'22663_Year-gap-started_0_0': 0},
)
field_id_40009_reported_occurrences_of_cancer_0_0 = TensorMap(
    '40009_Reported-occurrences-of-cancer_0_0',
    path_prefix='continuous', loss='logcosh', channel_map={
        '40009_Reported-occurrences-of-cancer_0_0': 0,
    },
)
field_id_40008_age_at_cancer_diagnosis_0_0 = TensorMap(
    '40008_Age-at-cancer-diagnosis_0_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'40008_Age-at-cancer-diagnosis_0_0': 0},
)
field_id_5134_6mm_strong_meridian_left_0_1 = TensorMap(
    '5134_6mm-strong-meridian-left_0_1', path_prefix='continuous',
    loss='logcosh',
    channel_map={'5134_6mm-strong-meridian-left_0_1': 0},
)
field_id_5118_6mm_cylindrical_power_left_0_1 = TensorMap(
    '5118_6mm-cylindrical-power-left_0_1',
    path_prefix='continuous', loss='logcosh',
    channel_map={'5118_6mm-cylindrical-power-left_0_1': 0},
)
field_id_5113_6mm_cylindrical_power_angle_left_0_1 = TensorMap(
    '5113_6mm-cylindrical-power-angle-left_0_1',
    path_prefix='continuous', loss='logcosh', channel_map={
        '5113_6mm-cylindrical-power-angle-left_0_1': 0,
    },
)
field_id_5105_6mm_strong_meridian_angle_left_0_1 = TensorMap(
    '5105_6mm-strong-meridian-angle-left_0_1',
    path_prefix='continuous', loss='logcosh',
    channel_map={'5105_6mm-strong-meridian-angle-left_0_1': 0},
)
field_id_5102_6mm_weak_meridian_angle_left_0_1 = TensorMap(
    '5102_6mm-weak-meridian-angle-left_0_1',
    path_prefix='continuous', loss='logcosh',
    channel_map={'5102_6mm-weak-meridian-angle-left_0_1': 0},
)
field_id_5097_6mm_weak_meridian_left_0_1 = TensorMap(
    '5097_6mm-weak-meridian-left_0_1', path_prefix='continuous',
    loss='logcosh', channel_map={'5097_6mm-weak-meridian-left_0_1': 0},
)
field_id_22603_year_job_ended_0_1 = TensorMap(
    '22603_Year-job-ended_0_1', path_prefix='continuous', loss='logcosh',
    channel_map={'22603_Year-job-ended_0_1': 0},
)
field_id_22602_year_job_started_0_1 = TensorMap(
    '22602_Year-job-started_0_1', path_prefix='continuous', loss='logcosh',
    channel_map={'22602_Year-job-started_0_1': 0},
)
field_id_5133_6mm_strong_meridian_right_0_1 = TensorMap(
    '5133_6mm-strong-meridian-right_0_1', path_prefix='continuous',
    loss='logcosh',
    channel_map={'5133_6mm-strong-meridian-right_0_1': 0},
)
field_id_5117_6mm_cylindrical_power_right_0_1 = TensorMap(
    '5117_6mm-cylindrical-power-right_0_1',
    path_prefix='continuous', loss='logcosh',
    channel_map={'5117_6mm-cylindrical-power-right_0_1': 0},
)
field_id_5114_6mm_cylindrical_power_angle_right_0_1 = TensorMap(
    '5114_6mm-cylindrical-power-angle-right_0_1',
    path_prefix='continuous', loss='logcosh', channel_map={
        '5114_6mm-cylindrical-power-angle-right_0_1': 0,
    },
)
field_id_5106_6mm_strong_meridian_angle_right_0_1 = TensorMap(
    '5106_6mm-strong-meridian-angle-right_0_1',
    path_prefix='continuous', loss='logcosh', channel_map={
        '5106_6mm-strong-meridian-angle-right_0_1': 0,
    },
)
field_id_5101_6mm_weak_meridian_angle_right_0_1 = TensorMap(
    '5101_6mm-weak-meridian-angle-right_0_1',
    path_prefix='continuous', loss='logcosh',
    channel_map={'5101_6mm-weak-meridian-angle-right_0_1': 0},
)
field_id_5098_6mm_weak_meridian_right_0_1 = TensorMap(
    '5098_6mm-weak-meridian-right_0_1', path_prefix='continuous',
    loss='logcosh',
    channel_map={'5098_6mm-weak-meridian-right_0_1': 0},
)
field_id_3849_number_of_pregnancy_terminations_0_0 = TensorMap(
    '3849_Number-of-pregnancy-terminations_0_0',
    path_prefix='continuous', loss='logcosh', channel_map={
        '3849_Number-of-pregnancy-terminations_0_0': 0,
    },
)
field_id_3839_number_of_spontaneous_miscarriages_0_0 = TensorMap(
    '3839_Number-of-spontaneous-miscarriages_0_0',
    path_prefix='continuous', loss='logcosh', channel_map={
        '3839_Number-of-spontaneous-miscarriages_0_0': 0,
    },
)
field_id_3829_number_of_stillbirths_0_0 = TensorMap(
    '3829_Number-of-stillbirths_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'3829_Number-of-stillbirths_0_0': 0},
)
field_id_6073_duration_at_which_oct_screen_shown_left_0_0 = TensorMap(
    '6073_Duration-at-which-OCT-screen-shown-left_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'6073_Duration-at-which-OCT-screen-shown-left_0_0': 0},
)
field_id_6071_duration_at_which_oct_screen_shown_right_0_0 = TensorMap(
    '6071_Duration-at-which-OCT-screen-shown-right_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'6071_Duration-at-which-OCT-screen-shown-right_0_0': 0},
)
field_id_6039_duration_of_fitness_test_0_0 = TensorMap(
    '6039_Duration-of-fitness-test_0_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'6039_Duration-of-fitness-test_0_0': 0},
)
field_id_6038_number_of_trend_entries_0_0 = TensorMap(
    '6038_Number-of-trend-entries_0_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'6038_Number-of-trend-entries_0_0': 0},
)
field_id_6033_maximum_heart_rate_during_fitness_test_0_0 = TensorMap(
    '6033_Maximum-heart-rate-during-fitness-test_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '6033_Maximum-heart-rate-during-fitness-test_0_0': 0,
    },
)
field_id_6032_maximum_workload_during_fitness_test_0_0 = TensorMap(
    '6032_Maximum-workload-during-fitness-test_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '6032_Maximum-workload-during-fitness-test_0_0': 0,
    },
)
field_id_5134_6mm_strong_meridian_left_0_2 = TensorMap(
    '5134_6mm-strong-meridian-left_0_2', path_prefix='continuous',
    loss='logcosh',
    channel_map={'5134_6mm-strong-meridian-left_0_2': 0},
)
field_id_5118_6mm_cylindrical_power_left_0_2 = TensorMap(
    '5118_6mm-cylindrical-power-left_0_2',
    path_prefix='continuous', loss='logcosh',
    channel_map={'5118_6mm-cylindrical-power-left_0_2': 0},
)
field_id_5113_6mm_cylindrical_power_angle_left_0_2 = TensorMap(
    '5113_6mm-cylindrical-power-angle-left_0_2',
    path_prefix='continuous', loss='logcosh', channel_map={
        '5113_6mm-cylindrical-power-angle-left_0_2': 0,
    },
)
field_id_5105_6mm_strong_meridian_angle_left_0_2 = TensorMap(
    '5105_6mm-strong-meridian-angle-left_0_2',
    path_prefix='continuous', loss='logcosh',
    channel_map={'5105_6mm-strong-meridian-angle-left_0_2': 0},
)
field_id_5102_6mm_weak_meridian_angle_left_0_2 = TensorMap(
    '5102_6mm-weak-meridian-angle-left_0_2',
    path_prefix='continuous', loss='logcosh',
    channel_map={'5102_6mm-weak-meridian-angle-left_0_2': 0},
)
field_id_5097_6mm_weak_meridian_left_0_2 = TensorMap(
    '5097_6mm-weak-meridian-left_0_2', path_prefix='continuous',
    loss='logcosh', channel_map={'5097_6mm-weak-meridian-left_0_2': 0},
)
field_id_87_noncancer_illness_yearage_first_occurred_0_3 = TensorMap(
    '87_Noncancer-illness-yearage-first-occurred_0_3',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '87_Noncancer-illness-yearage-first-occurred_0_3': 0,
    },
)
field_id_20009_interpolated_age_of_participant_when_noncancer_illness_first_diagnosed_0_3 = TensorMap(
    '20009_Interpolated-Age-of-participant-when-noncancer-illness-first-diagnosed_0_3', path_prefix='continuous',
    loss='logcosh', channel_map={'20009_Interpolated-Age-of-participant-when-noncancer-illness-first-diagnosed_0_3': 0},
)
field_id_30800_oestradiol_0_0 = TensorMap(
    '30800_Oestradiol_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'30800_Oestradiol_0_0': 0},
)
field_id_22603_year_job_ended_0_2 = TensorMap(
    '22603_Year-job-ended_0_2', path_prefix='continuous', loss='logcosh',
    channel_map={'22603_Year-job-ended_0_2': 0},
)
field_id_22602_year_job_started_0_2 = TensorMap(
    '22602_Year-job-started_0_2', path_prefix='continuous', loss='logcosh',
    channel_map={'22602_Year-job-started_0_2': 0},
)
field_id_5133_6mm_strong_meridian_right_0_2 = TensorMap(
    '5133_6mm-strong-meridian-right_0_2', path_prefix='continuous',
    loss='logcosh',
    channel_map={'5133_6mm-strong-meridian-right_0_2': 0},
)
field_id_5117_6mm_cylindrical_power_right_0_2 = TensorMap(
    '5117_6mm-cylindrical-power-right_0_2',
    path_prefix='continuous', loss='logcosh',
    channel_map={'5117_6mm-cylindrical-power-right_0_2': 0},
)
field_id_5106_6mm_strong_meridian_angle_right_0_2 = TensorMap(
    '5106_6mm-strong-meridian-angle-right_0_2',
    path_prefix='continuous', loss='logcosh', channel_map={
        '5106_6mm-strong-meridian-angle-right_0_2': 0,
    },
)
field_id_5101_6mm_weak_meridian_angle_right_0_2 = TensorMap(
    '5101_6mm-weak-meridian-angle-right_0_2',
    path_prefix='continuous', loss='logcosh',
    channel_map={'5101_6mm-weak-meridian-angle-right_0_2': 0},
)
field_id_5098_6mm_weak_meridian_right_0_2 = TensorMap(
    '5098_6mm-weak-meridian-right_0_2', path_prefix='continuous',
    loss='logcosh',
    channel_map={'5098_6mm-weak-meridian-right_0_2': 0},
)
field_id_5114_6mm_cylindrical_power_angle_right_0_2 = TensorMap(
    '5114_6mm-cylindrical-power-angle-right_0_2',
    path_prefix='continuous', loss='logcosh', channel_map={
        '5114_6mm-cylindrical-power-angle-right_0_2': 0,
    },
)
field_id_5078_logmar_in_round_left_0_2 = TensorMap(
    '5078_logMAR-in-round-left_0_2', path_prefix='continuous',
    loss='logcosh', channel_map={'5078_logMAR-in-round-left_0_2': 0},
)
field_id_5077_number_of_letters_correct_in_round_left_0_2 = TensorMap(
    '5077_Number-of-letters-correct-in-round-left_0_2', path_prefix='continuous', loss='logcosh',
    channel_map={'5077_Number-of-letters-correct-in-round-left_0_2': 0},
)
field_id_5074_number_of_letters_shown_in_round_left_0_2 = TensorMap(
    '5074_Number-of-letters-shown-in-round-left_0_2',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '5074_Number-of-letters-shown-in-round-left_0_2': 0,
    },
)
field_id_92_operation_yearage_first_occurred_0_3 = TensorMap(
    '92_Operation-yearage-first-occurred_0_3',
    path_prefix='continuous', loss='logcosh',
    channel_map={'92_Operation-yearage-first-occurred_0_3': 0},
)
field_id_20011_interpolated_age_of_participant_when_operation_took_place_0_3 = TensorMap(
    '20011_Interpolated-Age-of-participant-when-operation-took-place_0_3', path_prefix='continuous', loss='logcosh',
    channel_map={'20011_Interpolated-Age-of-participant-when-operation-took-place_0_3': 0},
)
field_id_3710_length_of_menstrual_cycle_0_0 = TensorMap(
    '3710_Length-of-menstrual-cycle_0_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'3710_Length-of-menstrual-cycle_0_0': 0},
)
field_id_3700_time_since_last_menstrual_period_0_0 = TensorMap(
    '3700_Time-since-last-menstrual-period_0_0',
    path_prefix='continuous', loss='logcosh', channel_map={
        '3700_Time-since-last-menstrual-period_0_0': 0,
    },
)
field_id_3809_time_since_last_prostate_specific_antigen_psa_test_0_0 = TensorMap(
    '3809_Time-since-last-prostate-specific-antigen-PSA-test_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'3809_Time-since-last-prostate-specific-antigen-PSA-test_0_0': 0},
)
field_id_5079_logmar_in_round_right_0_2 = TensorMap(
    '5079_logMAR-in-round-right_0_2', path_prefix='continuous',
    loss='logcosh', channel_map={'5079_logMAR-in-round-right_0_2': 0},
)
field_id_5076_number_of_letters_correct_in_round_right_0_2 = TensorMap(
    '5076_Number-of-letters-correct-in-round-right_0_2', path_prefix='continuous', loss='logcosh',
    channel_map={'5076_Number-of-letters-correct-in-round-right_0_2': 0},
)
field_id_5075_number_of_letters_shown_in_round_right_0_2 = TensorMap(
    '5075_Number-of-letters-shown-in-round-right_0_2',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '5075_Number-of-letters-shown-in-round-right_0_2': 0,
    },
)
field_id_3786_age_asthma_diagnosed_0_0 = TensorMap(
    '3786_Age-asthma-diagnosed_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'3786_Age-asthma-diagnosed_0_0': 0},
)
field_id_5162_6mm_regularity_index_left_0_0 = TensorMap(
    '5162_6mm-regularity-index-left_0_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'5162_6mm-regularity-index-left_0_0': 0},
)
field_id_5157_6mm_asymmetry_index_left_0_0 = TensorMap(
    '5157_6mm-asymmetry-index-left_0_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'5157_6mm-asymmetry-index-left_0_0': 0},
)
field_id_5110_6mm_asymmetry_angle_left_0_0 = TensorMap(
    '5110_6mm-asymmetry-angle-left_0_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'5110_6mm-asymmetry-angle-left_0_0': 0},
)
field_id_5162_6mm_regularity_index_left_0_1 = TensorMap(
    '5162_6mm-regularity-index-left_0_1', path_prefix='continuous',
    loss='logcosh',
    channel_map={'5162_6mm-regularity-index-left_0_1': 0},
)
field_id_5157_6mm_asymmetry_index_left_0_1 = TensorMap(
    '5157_6mm-asymmetry-index-left_0_1', path_prefix='continuous',
    loss='logcosh',
    channel_map={'5157_6mm-asymmetry-index-left_0_1': 0},
)
field_id_5110_6mm_asymmetry_angle_left_0_1 = TensorMap(
    '5110_6mm-asymmetry-angle-left_0_1', path_prefix='continuous',
    loss='logcosh',
    channel_map={'5110_6mm-asymmetry-angle-left_0_1': 0},
)
field_id_2824_age_at_hysterectomy_0_0 = TensorMap(
    '2824_Age-at-hysterectomy_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'2824_Age-at-hysterectomy_0_0': 0},
)
field_id_5161_6mm_regularity_index_right_0_1 = TensorMap(
    '5161_6mm-regularity-index-right_0_1',
    path_prefix='continuous', loss='logcosh',
    channel_map={'5161_6mm-regularity-index-right_0_1': 0},
)
field_id_5161_6mm_regularity_index_right_0_0 = TensorMap(
    '5161_6mm-regularity-index-right_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'5161_6mm-regularity-index-right_0_0': 0},
)
field_id_5158_6mm_asymmetry_index_right_0_1 = TensorMap(
    '5158_6mm-asymmetry-index-right_0_1', path_prefix='continuous',
    loss='logcosh',
    channel_map={'5158_6mm-asymmetry-index-right_0_1': 0},
)
field_id_5158_6mm_asymmetry_index_right_0_0 = TensorMap(
    '5158_6mm-asymmetry-index-right_0_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'5158_6mm-asymmetry-index-right_0_0': 0},
)
field_id_5109_6mm_asymmetry_angle_right_0_1 = TensorMap(
    '5109_6mm-asymmetry-angle-right_0_1', path_prefix='continuous',
    loss='logcosh',
    channel_map={'5109_6mm-asymmetry-angle-right_0_1': 0},
)
field_id_5109_6mm_asymmetry_angle_right_0_0 = TensorMap(
    '5109_6mm-asymmetry-angle-right_0_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'5109_6mm-asymmetry-angle-right_0_0': 0},
)
field_id_5162_6mm_regularity_index_left_0_2 = TensorMap(
    '5162_6mm-regularity-index-left_0_2', path_prefix='continuous',
    loss='logcosh',
    channel_map={'5162_6mm-regularity-index-left_0_2': 0},
)
field_id_5157_6mm_asymmetry_index_left_0_2 = TensorMap(
    '5157_6mm-asymmetry-index-left_0_2', path_prefix='continuous',
    loss='logcosh',
    channel_map={'5157_6mm-asymmetry-index-left_0_2': 0},
)
field_id_5110_6mm_asymmetry_angle_left_0_2 = TensorMap(
    '5110_6mm-asymmetry-angle-left_0_2', path_prefix='continuous',
    loss='logcosh',
    channel_map={'5110_6mm-asymmetry-angle-left_0_2': 0},
)
field_id_21003_age_when_attended_assessment_centre_2_0 = TensorMap(
    '21003_Age-when-attended-assessment-centre_2_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '21003_Age-when-attended-assessment-centre_2_0': 0,
    },
)
field_id_904_number_of_daysweek_of_vigorous_physical_activity_10_minutes_2_0 = TensorMap(
    '904_Number-of-daysweek-of-vigorous-physical-activity-10-minutes_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'904_Number-of-daysweek-of-vigorous-physical-activity-10-minutes_2_0': 0},
)
field_id_884_number_of_daysweek_of_moderate_physical_activity_10_minutes_2_0 = TensorMap(
    '884_Number-of-daysweek-of-moderate-physical-activity-10-minutes_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'884_Number-of-daysweek-of-moderate-physical-activity-10-minutes_2_0': 0},
)
field_id_864_number_of_daysweek_walked_10_minutes_2_0 = TensorMap(
    '864_Number-of-daysweek-walked-10-minutes_2_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '864_Number-of-daysweek-walked-10-minutes_2_0': 0,
    },
)
field_id_699_length_of_time_at_current_address_2_0 = TensorMap(
    '699_Length-of-time-at-current-address_2_0',
    path_prefix='continuous', loss='logcosh', channel_map={
        '699_Length-of-time-at-current-address_2_0': 0,
    },
)
field_id_2277_frequency_of_solariumsunlamp_use_2_0 = TensorMap(
    '2277_Frequency-of-solariumsunlamp-use_2_0',
    path_prefix='continuous', loss='logcosh', channel_map={
        '2277_Frequency-of-solariumsunlamp-use_2_0': 0,
    },
)
field_id_1528_water_intake_2_0 = TensorMap(
    '1528_Water-intake_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'1528_Water-intake_2_0': 0},
)
field_id_1498_coffee_intake_2_0 = TensorMap(
    '1498_Coffee-intake_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'1498_Coffee-intake_2_0': 0},
)
field_id_1488_tea_intake_2_0 = TensorMap(
    '1488_Tea-intake_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'1488_Tea-intake_2_0': 0},
)
field_id_1458_cereal_intake_2_0 = TensorMap(
    '1458_Cereal-intake_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'1458_Cereal-intake_2_0': 0},
)
field_id_1438_bread_intake_2_0 = TensorMap(
    '1438_Bread-intake_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'1438_Bread-intake_2_0': 0},
)
field_id_1319_dried_fruit_intake_2_0 = TensorMap(
    '1319_Dried-fruit-intake_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'1319_Dried-fruit-intake_2_0': 0},
)
field_id_1309_fresh_fruit_intake_2_0 = TensorMap(
    '1309_Fresh-fruit-intake_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'1309_Fresh-fruit-intake_2_0': 0},
)
field_id_1299_salad_raw_vegetable_intake_2_0 = TensorMap(
    '1299_Salad-raw-vegetable-intake_2_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'1299_Salad-raw-vegetable-intake_2_0': 0},
)
field_id_1289_cooked_vegetable_intake_2_0 = TensorMap(
    '1289_Cooked-vegetable-intake_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'1289_Cooked-vegetable-intake_2_0': 0},
)
field_id_1090_time_spent_driving_2_0 = TensorMap(
    '1090_Time-spent-driving_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'1090_Time-spent-driving_2_0': 0},
)
field_id_1080_time_spent_using_computer_2_0 = TensorMap(
    '1080_Time-spent-using-computer_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'1080_Time-spent-using-computer_2_0': 0},
)
field_id_1070_time_spent_watching_television_tv_2_0 = TensorMap(
    '1070_Time-spent-watching-television-TV_2_0',
    path_prefix='continuous', loss='logcosh', channel_map={
        '1070_Time-spent-watching-television-TV_2_0': 0,
    },
)
field_id_1060_time_spent_outdoors_in_winter_2_0 = TensorMap(
    '1060_Time-spent-outdoors-in-winter_2_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'1060_Time-spent-outdoors-in-winter_2_0': 0},
)
field_id_1050_time_spend_outdoors_in_summer_2_0 = TensorMap(
    '1050_Time-spend-outdoors-in-summer_2_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'1050_Time-spend-outdoors-in-summer_2_0': 0},
)
field_id_709_number_in_household_2_0 = TensorMap(
    '709_Number-in-household_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'709_Number-in-household_2_0': 0},
)
field_id_4272_duration_of_hearing_test_left_2_0 = TensorMap(
    '4272_Duration-of-hearing-test-left_2_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'4272_Duration-of-hearing-test-left_2_0': 0},
)
field_id_4269_number_of_triplets_attempted_left_2_0 = TensorMap(
    '4269_Number-of-triplets-attempted-left_2_0',
    path_prefix='continuous', loss='logcosh', channel_map={
        '4269_Number-of-triplets-attempted-left_2_0': 0,
    },
)
field_id_874_duration_of_walks_2_0 = TensorMap(
    '874_Duration-of-walks_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'874_Duration-of-walks_2_0': 0},
)
field_id_1883_number_of_full_sisters_2_0 = TensorMap(
    '1883_Number-of-full-sisters_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'1883_Number-of-full-sisters_2_0': 0},
)
field_id_1873_number_of_full_brothers_2_0 = TensorMap(
    '1873_Number-of-full-brothers_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'1873_Number-of-full-brothers_2_0': 0},
)
field_id_4279_duration_of_hearing_test_right_2_0 = TensorMap(
    '4279_Duration-of-hearing-test-right_2_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'4279_Duration-of-hearing-test-right_2_0': 0},
)
field_id_4276_number_of_triplets_attempted_right_2_0 = TensorMap(
    '4276_Number-of-triplets-attempted-right_2_0',
    path_prefix='continuous', loss='logcosh', channel_map={
        '4276_Number-of-triplets-attempted-right_2_0': 0,
    },
)
field_id_1279_exposure_to_tobacco_smoke_outside_home_2_0 = TensorMap(
    '1279_Exposure-to-tobacco-smoke-outside-home_2_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '1279_Exposure-to-tobacco-smoke-outside-home_2_0': 0,
    },
)
field_id_1269_exposure_to_tobacco_smoke_at_home_2_0 = TensorMap(
    '1269_Exposure-to-tobacco-smoke-at-home_2_0',
    path_prefix='continuous', loss='logcosh', channel_map={
        '1269_Exposure-to-tobacco-smoke-at-home_2_0': 0,
    },
)
field_id_4285_time_to_complete_test_0_0 = TensorMap(
    '4285_Time-to-complete-test_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'4285_Time-to-complete-test_0_0': 0},
)
field_id_4283_number_of_rounds_of_numeric_memory_test_performed_0_0 = TensorMap(
    '4283_Number-of-rounds-of-numeric-memory-test-performed_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'4283_Number-of-rounds-of-numeric-memory-test-performed_0_0': 0},
)
field_id_4282_maximum_digits_remembered_correctly_0_0 = TensorMap(
    '4282_Maximum-digits-remembered-correctly_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '4282_Maximum-digits-remembered-correctly_0_0': 0,
    },
)
field_id_4260_round_of_numeric_memory_test_0_2 = TensorMap(
    '4260_Round-of-numeric-memory-test_0_2',
    path_prefix='continuous', loss='logcosh',
    channel_map={'4260_Round-of-numeric-memory-test_0_2': 0},
)
field_id_4260_round_of_numeric_memory_test_0_1 = TensorMap(
    '4260_Round-of-numeric-memory-test_0_1',
    path_prefix='continuous', loss='logcosh',
    channel_map={'4260_Round-of-numeric-memory-test_0_1': 0},
)
field_id_4260_round_of_numeric_memory_test_0_0 = TensorMap(
    '4260_Round-of-numeric-memory-test_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'4260_Round-of-numeric-memory-test_0_0': 0},
)
field_id_4256_time_elapsed_0_2 = TensorMap(
    '4256_Time-elapsed_0_2', path_prefix='continuous', loss='logcosh',
    channel_map={'4256_Time-elapsed_0_2': 0},
)
field_id_4256_time_elapsed_0_1 = TensorMap(
    '4256_Time-elapsed_0_1', path_prefix='continuous', loss='logcosh',
    channel_map={'4256_Time-elapsed_0_1': 0},
)
field_id_4256_time_elapsed_0_0 = TensorMap(
    '4256_Time-elapsed_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'4256_Time-elapsed_0_0': 0},
)
field_id_51_seated_height_2_0 = TensorMap(
    '51_Seated-height_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'51_Seated-height_2_0': 0},
)
field_id_50_standing_height_2_0 = TensorMap(
    '50_Standing-height_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'50_Standing-height_2_0': 0},
)
field_id_49_hip_circumference_2_0 = TensorMap(
    '49_Hip-circumference_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'49_Hip-circumference_2_0': 0},
)
field_id_48_waist_circumference_2_0 = TensorMap(
    '48_Waist-circumference_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'48_Waist-circumference_2_0': 0},
)
field_id_21002_weight_2_0 = TensorMap(
    '21002_Weight_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'21002_Weight_2_0': 0},
)
field_id_20015_sitting_height_2_0 = TensorMap(
    '20015_Sitting-height_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'20015_Sitting-height_2_0': 0},
)
field_id_4260_round_of_numeric_memory_test_0_3 = TensorMap(
    '4260_Round-of-numeric-memory-test_0_3',
    path_prefix='continuous', loss='logcosh',
    channel_map={'4260_Round-of-numeric-memory-test_0_3': 0},
)
field_id_4256_time_elapsed_0_3 = TensorMap(
    '4256_Time-elapsed_0_3', path_prefix='continuous', loss='logcosh',
    channel_map={'4256_Time-elapsed_0_3': 0},
)
field_id_47_hand_grip_strength_right_2_0 = TensorMap(
    '47_Hand-grip-strength-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'47_Hand-grip-strength-right_2_0': 0},
)
field_id_46_hand_grip_strength_left_2_0 = TensorMap(
    '46_Hand-grip-strength-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'46_Hand-grip-strength-left_2_0': 0},
)
field_id_21001_body_mass_index_bmi_2_0 = TensorMap(
    '21001_Body-mass-index-BMI_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'21001_Body-mass-index-BMI_2_0': 0},
)
field_id_20019_speechreceptionthreshold_srt_estimate_left_2_0 = TensorMap(
    '20019_Speechreceptionthreshold-SRT-estimate-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'20019_Speechreceptionthreshold-SRT-estimate-left_2_0': 0},
)
field_id_4260_round_of_numeric_memory_test_0_4 = TensorMap(
    '4260_Round-of-numeric-memory-test_0_4',
    path_prefix='continuous', loss='logcosh',
    channel_map={'4260_Round-of-numeric-memory-test_0_4': 0},
)
field_id_4256_time_elapsed_0_4 = TensorMap(
    '4256_Time-elapsed_0_4', path_prefix='continuous', loss='logcosh',
    channel_map={'4256_Time-elapsed_0_4': 0},
)
field_id_20021_speechreceptionthreshold_srt_estimate_right_2_0 = TensorMap(
    '20021_Speechreceptionthreshold-SRT-estimate-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'20021_Speechreceptionthreshold-SRT-estimate-right_2_0': 0},
)
field_id_22603_year_job_ended_0_3 = TensorMap(
    '22603_Year-job-ended_0_3', path_prefix='continuous', loss='logcosh',
    channel_map={'22603_Year-job-ended_0_3': 0},
)
field_id_22602_year_job_started_0_3 = TensorMap(
    '22602_Year-job-started_0_3', path_prefix='continuous', loss='logcosh',
    channel_map={'22602_Year-job-started_0_3': 0},
)
field_id_23130_trunk_predicted_mass_2_0 = TensorMap(
    '23130_Trunk-predicted-mass_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'23130_Trunk-predicted-mass_2_0': 0},
)
field_id_23129_trunk_fatfree_mass_2_0 = TensorMap(
    '23129_Trunk-fatfree-mass_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'23129_Trunk-fatfree-mass_2_0': 0},
)
field_id_23128_trunk_fat_mass_2_0 = TensorMap(
    '23128_Trunk-fat-mass_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'23128_Trunk-fat-mass_2_0': 0},
)
field_id_23127_trunk_fat_percentage_2_0 = TensorMap(
    '23127_Trunk-fat-percentage_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'23127_Trunk-fat-percentage_2_0': 0},
)
field_id_23126_arm_predicted_mass_left_2_0 = TensorMap(
    '23126_Arm-predicted-mass-left_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'23126_Arm-predicted-mass-left_2_0': 0},
)
field_id_23125_arm_fatfree_mass_left_2_0 = TensorMap(
    '23125_Arm-fatfree-mass-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'23125_Arm-fatfree-mass-left_2_0': 0},
)
field_id_23124_arm_fat_mass_left_2_0 = TensorMap(
    '23124_Arm-fat-mass-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'23124_Arm-fat-mass-left_2_0': 0},
)
field_id_23123_arm_fat_percentage_left_2_0 = TensorMap(
    '23123_Arm-fat-percentage-left_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'23123_Arm-fat-percentage-left_2_0': 0},
)
field_id_23122_arm_predicted_mass_right_2_0 = TensorMap(
    '23122_Arm-predicted-mass-right_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'23122_Arm-predicted-mass-right_2_0': 0},
)
field_id_23121_arm_fatfree_mass_right_2_0 = TensorMap(
    '23121_Arm-fatfree-mass-right_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'23121_Arm-fatfree-mass-right_2_0': 0},
)
field_id_23120_arm_fat_mass_right_2_0 = TensorMap(
    '23120_Arm-fat-mass-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'23120_Arm-fat-mass-right_2_0': 0},
)
field_id_23119_arm_fat_percentage_right_2_0 = TensorMap(
    '23119_Arm-fat-percentage-right_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'23119_Arm-fat-percentage-right_2_0': 0},
)
field_id_23118_leg_predicted_mass_left_2_0 = TensorMap(
    '23118_Leg-predicted-mass-left_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'23118_Leg-predicted-mass-left_2_0': 0},
)
field_id_23117_leg_fatfree_mass_left_2_0 = TensorMap(
    '23117_Leg-fatfree-mass-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'23117_Leg-fatfree-mass-left_2_0': 0},
)
field_id_23116_leg_fat_mass_left_2_0 = TensorMap(
    '23116_Leg-fat-mass-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'23116_Leg-fat-mass-left_2_0': 0},
)
field_id_23115_leg_fat_percentage_left_2_0 = TensorMap(
    '23115_Leg-fat-percentage-left_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'23115_Leg-fat-percentage-left_2_0': 0},
)
field_id_23114_leg_predicted_mass_right_2_0 = TensorMap(
    '23114_Leg-predicted-mass-right_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'23114_Leg-predicted-mass-right_2_0': 0},
)
field_id_23113_leg_fatfree_mass_right_2_0 = TensorMap(
    '23113_Leg-fatfree-mass-right_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'23113_Leg-fatfree-mass-right_2_0': 0},
)
field_id_23112_leg_fat_mass_right_2_0 = TensorMap(
    '23112_Leg-fat-mass-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'23112_Leg-fat-mass-right_2_0': 0},
)
field_id_23111_leg_fat_percentage_right_2_0 = TensorMap(
    '23111_Leg-fat-percentage-right_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'23111_Leg-fat-percentage-right_2_0': 0},
)
field_id_23110_impedance_of_arm_left_2_0 = TensorMap(
    '23110_Impedance-of-arm-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'23110_Impedance-of-arm-left_2_0': 0},
)
field_id_23109_impedance_of_arm_right_2_0 = TensorMap(
    '23109_Impedance-of-arm-right_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'23109_Impedance-of-arm-right_2_0': 0},
)
field_id_23108_impedance_of_leg_left_2_0 = TensorMap(
    '23108_Impedance-of-leg-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'23108_Impedance-of-leg-left_2_0': 0},
)
field_id_23107_impedance_of_leg_right_2_0 = TensorMap(
    '23107_Impedance-of-leg-right_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'23107_Impedance-of-leg-right_2_0': 0},
)
field_id_23106_impedance_of_whole_body_2_0 = TensorMap(
    '23106_Impedance-of-whole-body_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'23106_Impedance-of-whole-body_2_0': 0},
)
field_id_23105_basal_metabolic_rate_2_0 = TensorMap(
    '23105_Basal-metabolic-rate_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'23105_Basal-metabolic-rate_2_0': 0},
)
field_id_23104_body_mass_index_bmi_2_0 = TensorMap(
    '23104_Body-mass-index-BMI_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'23104_Body-mass-index-BMI_2_0': 0},
)
field_id_23102_whole_body_water_mass_2_0 = TensorMap(
    '23102_Whole-body-water-mass_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'23102_Whole-body-water-mass_2_0': 0},
)
field_id_23101_whole_body_fatfree_mass_2_0 = TensorMap(
    '23101_Whole-body-fatfree-mass_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'23101_Whole-body-fatfree-mass_2_0': 0},
)
field_id_23100_whole_body_fat_mass_2_0 = TensorMap(
    '23100_Whole-body-fat-mass_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'23100_Whole-body-fat-mass_2_0': 0},
)
field_id_23099_body_fat_percentage_2_0 = TensorMap(
    '23099_Body-fat-percentage_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'23099_Body-fat-percentage_2_0': 0},
)
field_id_23098_weight_2_0 = TensorMap(
    '23098_Weight_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'23098_Weight_2_0': 0},
)
field_id_2217_age_started_wearing_glasses_or_contact_lenses_2_0 = TensorMap(
    '2217_Age-started-wearing-glasses-or-contact-lenses_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'2217_Age-started-wearing-glasses-or-contact-lenses_2_0': 0},
)
field_id_4291_number_of_attempts_2_0 = TensorMap(
    '4291_Number-of-attempts_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'4291_Number-of-attempts_2_0': 0},
)
field_id_4290_duration_screen_displayed_2_0 = TensorMap(
    '4290_Duration-screen-displayed_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'4290_Duration-screen-displayed_2_0': 0},
)
field_id_4288_time_to_answer_2_0 = TensorMap(
    '4288_Time-to-answer_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'4288_Time-to-answer_2_0': 0},
)
field_id_400_time_to_complete_round_2_2 = TensorMap(
    '400_Time-to-complete-round_2_2', path_prefix='continuous',
    loss='logcosh', channel_map={'400_Time-to-complete-round_2_2': 0},
)
field_id_400_time_to_complete_round_2_1 = TensorMap(
    '400_Time-to-complete-round_2_1', path_prefix='continuous',
    loss='logcosh', channel_map={'400_Time-to-complete-round_2_1': 0},
)
field_id_399_number_of_incorrect_matches_in_round_2_2 = TensorMap(
    '399_Number-of-incorrect-matches-in-round_2_2',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '399_Number-of-incorrect-matches-in-round_2_2': 0,
    },
)
field_id_399_number_of_incorrect_matches_in_round_2_1 = TensorMap(
    '399_Number-of-incorrect-matches-in-round_2_1',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '399_Number-of-incorrect-matches-in-round_2_1': 0,
    },
)
field_id_398_number_of_correct_matches_in_round_2_2 = TensorMap(
    '398_Number-of-correct-matches-in-round_2_2',
    path_prefix='continuous', loss='logcosh', channel_map={
        '398_Number-of-correct-matches-in-round_2_2': 0,
    },
)
field_id_398_number_of_correct_matches_in_round_2_1 = TensorMap(
    '398_Number-of-correct-matches-in-round_2_1',
    path_prefix='continuous', loss='logcosh', channel_map={
        '398_Number-of-correct-matches-in-round_2_1': 0,
    },
)
field_id_397_number_of_rows_displayed_in_round_2_2 = TensorMap(
    '397_Number-of-rows-displayed-in-round_2_2',
    path_prefix='continuous', loss='logcosh', channel_map={
        '397_Number-of-rows-displayed-in-round_2_2': 0,
    },
)
field_id_397_number_of_rows_displayed_in_round_2_1 = TensorMap(
    '397_Number-of-rows-displayed-in-round_2_1',
    path_prefix='continuous', loss='logcosh', channel_map={
        '397_Number-of-rows-displayed-in-round_2_1': 0,
    },
)
field_id_396_number_of_columns_displayed_in_round_2_2 = TensorMap(
    '396_Number-of-columns-displayed-in-round_2_2',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '396_Number-of-columns-displayed-in-round_2_2': 0,
    },
)
field_id_396_number_of_columns_displayed_in_round_2_1 = TensorMap(
    '396_Number-of-columns-displayed-in-round_2_1',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '396_Number-of-columns-displayed-in-round_2_1': 0,
    },
)
field_id_404_duration_to_first_press_of_snapbutton_in_each_round_2_7 = TensorMap(
    '404_Duration-to-first-press-of-snapbutton-in-each-round_2_7', path_prefix='continuous', loss='logcosh',
    channel_map={'404_Duration-to-first-press-of-snapbutton-in-each-round_2_7': 0},
)
field_id_404_duration_to_first_press_of_snapbutton_in_each_round_2_5 = TensorMap(
    '404_Duration-to-first-press-of-snapbutton-in-each-round_2_5', path_prefix='continuous', loss='logcosh',
    channel_map={'404_Duration-to-first-press-of-snapbutton-in-each-round_2_5': 0},
)
field_id_404_duration_to_first_press_of_snapbutton_in_each_round_2_11 = TensorMap(
    '404_Duration-to-first-press-of-snapbutton-in-each-round_2_11', path_prefix='continuous', loss='logcosh',
    channel_map={'404_Duration-to-first-press-of-snapbutton-in-each-round_2_11': 0},
)
field_id_20023_mean_time_to_correctly_identify_matches_2_0 = TensorMap(
    '20023_Mean-time-to-correctly-identify-matches_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'20023_Mean-time-to-correctly-identify-matches_2_0': 0},
)
field_id_3659_year_immigrated_to_uk_united_kingdom_0_0 = TensorMap(
    '3659_Year-immigrated-to-UK-United-Kingdom_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '3659_Year-immigrated-to-UK-United-Kingdom_0_0': 0,
    },
)
field_id_20128_number_of_fluid_intelligence_questions_attempted_within_time_limit_2_0 = TensorMap(
    '20128_Number-of-fluid-intelligence-questions-attempted-within-time-limit_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'20128_Number-of-fluid-intelligence-questions-attempted-within-time-limit_2_0': 0},
)
field_id_20016_fluid_intelligence_score_2_0 = TensorMap(
    '20016_Fluid-intelligence-score_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'20016_Fluid-intelligence-score_2_0': 0},
)
field_id_404_duration_to_first_press_of_snapbutton_in_each_round_2_10 = TensorMap(
    '404_Duration-to-first-press-of-snapbutton-in-each-round_2_10', path_prefix='continuous', loss='logcosh',
    channel_map={'404_Duration-to-first-press-of-snapbutton-in-each-round_2_10': 0},
)
field_id_4260_round_of_numeric_memory_test_0_5 = TensorMap(
    '4260_Round-of-numeric-memory-test_0_5',
    path_prefix='continuous', loss='logcosh',
    channel_map={'4260_Round-of-numeric-memory-test_0_5': 0},
)
field_id_4256_time_elapsed_0_5 = TensorMap(
    '4256_Time-elapsed_0_5', path_prefix='continuous', loss='logcosh',
    channel_map={'4256_Time-elapsed_0_5': 0},
)
field_id_5057_number_of_older_siblings_2_0 = TensorMap(
    '5057_Number-of-older-siblings_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'5057_Number-of-older-siblings_2_0': 0},
)
field_id_137_number_of_treatmentsmedications_taken_2_0 = TensorMap(
    '137_Number-of-treatmentsmedications-taken_2_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '137_Number-of-treatmentsmedications-taken_2_0': 0,
    },
)
field_id_136_number_of_operations_selfreported_2_0 = TensorMap(
    '136_Number-of-operations-selfreported_2_0',
    path_prefix='continuous', loss='logcosh', channel_map={
        '136_Number-of-operations-selfreported_2_0': 0,
    },
)
field_id_135_number_of_selfreported_noncancer_illnesses_2_0 = TensorMap(
    '135_Number-of-selfreported-noncancer-illnesses_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'135_Number-of-selfreported-noncancer-illnesses_2_0': 0},
)
field_id_134_number_of_selfreported_cancers_2_0 = TensorMap(
    '134_Number-of-selfreported-cancers_2_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'134_Number-of-selfreported-cancers_2_0': 0},
)
field_id_22664_year_gap_ended_0_1 = TensorMap(
    '22664_Year-gap-ended_0_1', path_prefix='continuous', loss='logcosh',
    channel_map={'22664_Year-gap-ended_0_1': 0},
)
field_id_22663_year_gap_started_0_1 = TensorMap(
    '22663_Year-gap-started_0_1', path_prefix='continuous', loss='logcosh',
    channel_map={'22663_Year-gap-started_0_1': 0},
)
field_id_894_duration_of_moderate_activity_2_0 = TensorMap(
    '894_Duration-of-moderate-activity_2_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'894_Duration-of-moderate-activity_2_0': 0},
)
field_id_5161_6mm_regularity_index_right_0_2 = TensorMap(
    '5161_6mm-regularity-index-right_0_2',
    path_prefix='continuous', loss='logcosh',
    channel_map={'5161_6mm-regularity-index-right_0_2': 0},
)
field_id_5158_6mm_asymmetry_index_right_0_2 = TensorMap(
    '5158_6mm-asymmetry-index-right_0_2', path_prefix='continuous',
    loss='logcosh',
    channel_map={'5158_6mm-asymmetry-index-right_0_2': 0},
)
field_id_5109_6mm_asymmetry_angle_right_0_2 = TensorMap(
    '5109_6mm-asymmetry-angle-right_0_2', path_prefix='continuous',
    loss='logcosh',
    channel_map={'5109_6mm-asymmetry-angle-right_0_2': 0},
)
field_id_3064_peak_expiratory_flow_pef_2_1 = TensorMap(
    '3064_Peak-expiratory-flow-PEF_2_1', path_prefix='continuous',
    loss='logcosh',
    channel_map={'3064_Peak-expiratory-flow-PEF_2_1': 0},
)
field_id_3064_peak_expiratory_flow_pef_2_0 = TensorMap(
    '3064_Peak-expiratory-flow-PEF_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'3064_Peak-expiratory-flow-PEF_2_0': 0},
)
field_id_3063_forced_expiratory_volume_in_1second_fev1_2_1 = TensorMap(
    '3063_Forced-expiratory-volume-in-1second-FEV1_2_1', path_prefix='continuous', loss='logcosh',
    channel_map={'3063_Forced-expiratory-volume-in-1second-FEV1_2_1': 0},
)
field_id_3063_forced_expiratory_volume_in_1second_fev1_2_0 = TensorMap(
    '3063_Forced-expiratory-volume-in-1second-FEV1_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'3063_Forced-expiratory-volume-in-1second-FEV1_2_0': 0},
)
field_id_3062_forced_vital_capacity_fvc_2_1 = TensorMap(
    '3062_Forced-vital-capacity-FVC_2_1', path_prefix='continuous',
    loss='logcosh',
    channel_map={'3062_Forced-vital-capacity-FVC_2_1': 0},
)
field_id_3062_forced_vital_capacity_fvc_2_0 = TensorMap(
    '3062_Forced-vital-capacity-FVC_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'3062_Forced-vital-capacity-FVC_2_0': 0},
)
field_id_1807_fathers_age_at_death_2_0 = TensorMap(
    '1807_Fathers-age-at-death_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'1807_Fathers-age-at-death_2_0': 0},
)
field_id_87_noncancer_illness_yearage_first_occurred_0_4 = TensorMap(
    '87_Noncancer-illness-yearage-first-occurred_0_4',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '87_Noncancer-illness-yearage-first-occurred_0_4': 0,
    },
)
field_id_20009_interpolated_age_of_participant_when_noncancer_illness_first_diagnosed_0_4 = TensorMap(
    '20009_Interpolated-Age-of-participant-when-noncancer-illness-first-diagnosed_0_4', path_prefix='continuous',
    loss='logcosh', channel_map={'20009_Interpolated-Age-of-participant-when-noncancer-illness-first-diagnosed_0_4': 0},
)
field_id_12651_duration_of_eprime_test_2_0 = TensorMap(
    '12651_Duration-of-eprime-test_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'12651_Duration-of-eprime-test_2_0': 0},
)
field_id_4200_position_of_the_shoulder_on_the_pulse_waveform_2_0 = TensorMap(
    '4200_Position-of-the-shoulder-on-the-pulse-waveform_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'4200_Position-of-the-shoulder-on-the-pulse-waveform_2_0': 0},
)
field_id_4199_position_of_pulse_wave_notch_2_0 = TensorMap(
    '4199_Position-of-pulse-wave-notch_2_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'4199_Position-of-pulse-wave-notch_2_0': 0},
)
field_id_4198_position_of_the_pulse_wave_peak_2_0 = TensorMap(
    '4198_Position-of-the-pulse-wave-peak_2_0',
    path_prefix='continuous', loss='logcosh', channel_map={
        '4198_Position-of-the-pulse-wave-peak_2_0': 0,
    },
)
field_id_4195_pulse_wave_reflection_index_2_0 = TensorMap(
    '4195_Pulse-wave-reflection-index_2_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'4195_Pulse-wave-reflection-index_2_0': 0},
)
field_id_4194_pulse_rate_2_0 = TensorMap(
    '4194_Pulse-rate_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'4194_Pulse-rate_2_0': 0},
)
field_id_4196_pulse_wave_peak_to_peak_time_2_0 = TensorMap(
    '4196_Pulse-wave-peak-to-peak-time_2_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'4196_Pulse-wave-peak-to-peak-time_2_0': 0},
)
field_id_4462_average_monthly_intake_of_other_alcoholic_drinks_0_0 = TensorMap(
    '4462_Average-monthly-intake-of-other-alcoholic-drinks_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'4462_Average-monthly-intake-of-other-alcoholic-drinks_0_0': 0},
)
field_id_4451_average_monthly_fortified_wine_intake_0_0 = TensorMap(
    '4451_Average-monthly-fortified-wine-intake_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '4451_Average-monthly-fortified-wine-intake_0_0': 0,
    },
)
field_id_4440_average_monthly_spirits_intake_0_0 = TensorMap(
    '4440_Average-monthly-spirits-intake_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'4440_Average-monthly-spirits-intake_0_0': 0},
)
field_id_4429_average_monthly_beer_plus_cider_intake_0_0 = TensorMap(
    '4429_Average-monthly-beer-plus-cider-intake_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '4429_Average-monthly-beer-plus-cider-intake_0_0': 0,
    },
)
field_id_4418_average_monthly_champagne_plus_white_wine_intake_0_0 = TensorMap(
    '4418_Average-monthly-champagne-plus-white-wine-intake_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'4418_Average-monthly-champagne-plus-white-wine-intake_0_0': 0},
)
field_id_4407_average_monthly_red_wine_intake_0_0 = TensorMap(
    '4407_Average-monthly-red-wine-intake_0_0',
    path_prefix='continuous', loss='logcosh', channel_map={
        '4407_Average-monthly-red-wine-intake_0_0': 0,
    },
)
field_id_21021_pulse_wave_arterial_stiffness_index_2_0 = TensorMap(
    '21021_Pulse-wave-Arterial-Stiffness-index_2_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '21021_Pulse-wave-Arterial-Stiffness-index_2_0': 0,
    },
)
field_id_84_cancer_yearage_first_occurred_0_0 = TensorMap(
    '84_Cancer-yearage-first-occurred_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'84_Cancer-yearage-first-occurred_0_0': 0},
)
field_id_20007_interpolated_age_of_participant_when_cancer_first_diagnosed_0_0 = TensorMap(
    '20007_Interpolated-Age-of-participant-when-cancer-first-diagnosed_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'20007_Interpolated-Age-of-participant-when-cancer-first-diagnosed_0_0': 0},
)
field_id_12699_number_of_pwa_tests_performed_2_0 = TensorMap(
    '12699_Number-of-PWA-tests-performed_2_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'12699_Number-of-PWA-tests-performed_2_0': 0},
)
field_id_12698_diastolic_brachial_blood_pressure_2_0 = TensorMap(
    '12698_Diastolic-brachial-blood-pressure_2_0',
    path_prefix='continuous', loss='logcosh', channel_map={
        '12698_Diastolic-brachial-blood-pressure_2_0': 0,
    },
)
field_id_12697_systolic_brachial_blood_pressure_2_0 = TensorMap(
    '12697_Systolic-brachial-blood-pressure_2_0',
    path_prefix='continuous', loss='logcosh', channel_map={
        '12697_Systolic-brachial-blood-pressure_2_0': 0,
    },
)
field_id_4260_round_of_numeric_memory_test_0_6 = TensorMap(
    '4260_Round-of-numeric-memory-test_0_6',
    path_prefix='continuous', loss='logcosh',
    channel_map={'4260_Round-of-numeric-memory-test_0_6': 0},
)
field_id_4256_time_elapsed_0_6 = TensorMap(
    '4256_Time-elapsed_0_6', path_prefix='continuous', loss='logcosh',
    channel_map={'4256_Time-elapsed_0_6': 0},
)
field_id_4080_systolic_blood_pressure_automated_reading_2_0 = TensorMap(
    '4080_Systolic-blood-pressure-automated-reading_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'4080_Systolic-blood-pressure-automated-reading_2_0': 0},
)
field_id_4079_diastolic_blood_pressure_automated_reading_2_0 = TensorMap(
    '4079_Diastolic-blood-pressure-automated-reading_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'4079_Diastolic-blood-pressure-automated-reading_2_0': 0},
)
field_id_102_pulse_rate_automated_reading_2_0 = TensorMap(
    '102_Pulse-rate-automated-reading_2_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'102_Pulse-rate-automated-reading_2_0': 0},
)
field_id_12681_augmentation_index_for_pwa_2_0 = TensorMap(
    '12681_Augmentation-index-for-PWA_2_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'12681_Augmentation-index-for-PWA_2_0': 0},
)
field_id_12679_number_of_beats_in_waveform_average_for_pwa_2_0 = TensorMap(
    '12679_Number-of-beats-in-waveform-average-for-PWA_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'12679_Number-of-beats-in-waveform-average-for-PWA_2_0': 0},
)
field_id_12673_heart_rate_during_pwa_2_0 = TensorMap(
    '12673_Heart-rate-during-PWA_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'12673_Heart-rate-during-PWA_2_0': 0},
)
field_id_3436_age_started_smoking_in_current_smokers_0_0 = TensorMap(
    '3436_Age-started-smoking-in-current-smokers_0_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '3436_Age-started-smoking-in-current-smokers_0_0': 0,
    },
)
field_id_12687_mean_arterial_pressure_during_pwa_2_0 = TensorMap(
    '12687_Mean-arterial-pressure-during-PWA_2_0',
    path_prefix='continuous', loss='logcosh', channel_map={
        '12687_Mean-arterial-pressure-during-PWA_2_0': 0,
    },
)
field_id_12685_total_peripheral_resistance_during_pwa_2_0 = TensorMap(
    '12685_Total-peripheral-resistance-during-PWA_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'12685_Total-peripheral-resistance-during-PWA_2_0': 0},
)
field_id_12683_end_systolic_pressure_during_pwa_2_0 = TensorMap(
    '12683_End-systolic-pressure-during-PWA_2_0',
    path_prefix='continuous', loss='logcosh', channel_map={
        '12683_End-systolic-pressure-during-PWA_2_0': 0,
    },
)
field_id_12680_central_augmentation_pressure_during_pwa_2_0 = TensorMap(
    '12680_Central-augmentation-pressure-during-PWA_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'12680_Central-augmentation-pressure-during-PWA_2_0': 0},
)
field_id_12678_central_pulse_pressure_during_pwa_2_0 = TensorMap(
    '12678_Central-pulse-pressure-during-PWA_2_0',
    path_prefix='continuous', loss='logcosh', channel_map={
        '12678_Central-pulse-pressure-during-PWA_2_0': 0,
    },
)
field_id_12677_central_systolic_blood_pressure_during_pwa_2_0 = TensorMap(
    '12677_Central-systolic-blood-pressure-during-PWA_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'12677_Central-systolic-blood-pressure-during-PWA_2_0': 0},
)
field_id_12676_peripheral_pulse_pressure_during_pwa_2_0 = TensorMap(
    '12676_Peripheral-pulse-pressure-during-PWA_2_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '12676_Peripheral-pulse-pressure-during-PWA_2_0': 0,
    },
)
field_id_12675_diastolic_brachial_blood_pressure_during_pwa_2_0 = TensorMap(
    '12675_Diastolic-brachial-blood-pressure-during-PWA_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'12675_Diastolic-brachial-blood-pressure-during-PWA_2_0': 0},
)
field_id_12674_systolic_brachial_blood_pressure_during_pwa_2_0 = TensorMap(
    '12674_Systolic-brachial-blood-pressure-during-PWA_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'12674_Systolic-brachial-blood-pressure-during-PWA_2_0': 0},
)
field_id_95_pulse_rate_during_bloodpressure_measurement_0_1 = TensorMap(
    '95_Pulse-rate-during-bloodpressure-measurement_0_1', path_prefix='continuous', loss='logcosh',
    channel_map={'95_Pulse-rate-during-bloodpressure-measurement_0_1': 0},
)
field_id_94_diastolic_blood_pressure_manual_reading_0_1 = TensorMap(
    '94_Diastolic-blood-pressure-manual-reading_0_1',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '94_Diastolic-blood-pressure-manual-reading_0_1': 0,
    },
)
field_id_93_systolic_blood_pressure_manual_reading_0_1 = TensorMap(
    '93_Systolic-blood-pressure-manual-reading_0_1',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '93_Systolic-blood-pressure-manual-reading_0_1': 0,
    },
)
field_id_4080_systolic_blood_pressure_automated_reading_2_1 = TensorMap(
    '4080_Systolic-blood-pressure-automated-reading_2_1', path_prefix='continuous', loss='logcosh',
    channel_map={'4080_Systolic-blood-pressure-automated-reading_2_1': 0},
)
field_id_4079_diastolic_blood_pressure_automated_reading_2_1 = TensorMap(
    '4079_Diastolic-blood-pressure-automated-reading_2_1', path_prefix='continuous', loss='logcosh',
    channel_map={'4079_Diastolic-blood-pressure-automated-reading_2_1': 0},
)
field_id_102_pulse_rate_automated_reading_2_1 = TensorMap(
    '102_Pulse-rate-automated-reading_2_1',
    path_prefix='continuous', loss='logcosh',
    channel_map={'102_Pulse-rate-automated-reading_2_1': 0},
)
field_id_12681_augmentation_index_for_pwa_2_1 = TensorMap(
    '12681_Augmentation-index-for-PWA_2_1',
    path_prefix='continuous', loss='logcosh',
    channel_map={'12681_Augmentation-index-for-PWA_2_1': 0},
)
field_id_12679_number_of_beats_in_waveform_average_for_pwa_2_1 = TensorMap(
    '12679_Number-of-beats-in-waveform-average-for-PWA_2_1', path_prefix='continuous', loss='logcosh',
    channel_map={'12679_Number-of-beats-in-waveform-average-for-PWA_2_1': 0},
)
field_id_12673_heart_rate_during_pwa_2_1 = TensorMap(
    '12673_Heart-rate-during-PWA_2_1', path_prefix='continuous',
    loss='logcosh', channel_map={'12673_Heart-rate-during-PWA_2_1': 0},
)
field_id_3086_speed_of_sound_through_heel_manual_entry_0_0 = TensorMap(
    '3086_Speed-of-sound-through-heel-manual-entry_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'3086_Speed-of-sound-through-heel-manual-entry_0_0': 0},
)
field_id_3085_heel_broadband_ultrasound_attenuation_bua_manual_entry_0_0 = TensorMap(
    '3085_Heel-Broadband-ultrasound-attenuation-BUA-manual-entry_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'3085_Heel-Broadband-ultrasound-attenuation-BUA-manual-entry_0_0': 0},
)
field_id_3084_heel_bone_mineral_density_bmd_manual_entry_0_0 = TensorMap(
    '3084_Heel-bone-mineral-density-BMD-manual-entry_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'3084_Heel-bone-mineral-density-BMD-manual-entry_0_0': 0},
)
field_id_3083_heel_quantitative_ultrasound_index_qui_manual_entry_0_0 = TensorMap(
    '3083_Heel-quantitative-ultrasound-index-QUI-manual-entry_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'3083_Heel-quantitative-ultrasound-index-QUI-manual-entry_0_0': 0},
)
field_id_12687_mean_arterial_pressure_during_pwa_2_1 = TensorMap(
    '12687_Mean-arterial-pressure-during-PWA_2_1',
    path_prefix='continuous', loss='logcosh', channel_map={
        '12687_Mean-arterial-pressure-during-PWA_2_1': 0,
    },
)
field_id_12685_total_peripheral_resistance_during_pwa_2_1 = TensorMap(
    '12685_Total-peripheral-resistance-during-PWA_2_1', path_prefix='continuous', loss='logcosh',
    channel_map={'12685_Total-peripheral-resistance-during-PWA_2_1': 0},
)
field_id_12683_end_systolic_pressure_during_pwa_2_1 = TensorMap(
    '12683_End-systolic-pressure-during-PWA_2_1',
    path_prefix='continuous', loss='logcosh', channel_map={
        '12683_End-systolic-pressure-during-PWA_2_1': 0,
    },
)
field_id_12680_central_augmentation_pressure_during_pwa_2_1 = TensorMap(
    '12680_Central-augmentation-pressure-during-PWA_2_1', path_prefix='continuous', loss='logcosh',
    channel_map={'12680_Central-augmentation-pressure-during-PWA_2_1': 0},
)
field_id_12678_central_pulse_pressure_during_pwa_2_1 = TensorMap(
    '12678_Central-pulse-pressure-during-PWA_2_1',
    path_prefix='continuous', loss='logcosh', channel_map={
        '12678_Central-pulse-pressure-during-PWA_2_1': 0,
    },
)
field_id_12677_central_systolic_blood_pressure_during_pwa_2_1 = TensorMap(
    '12677_Central-systolic-blood-pressure-during-PWA_2_1', path_prefix='continuous', loss='logcosh',
    channel_map={'12677_Central-systolic-blood-pressure-during-PWA_2_1': 0},
)
field_id_12676_peripheral_pulse_pressure_during_pwa_2_1 = TensorMap(
    '12676_Peripheral-pulse-pressure-during-PWA_2_1',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '12676_Peripheral-pulse-pressure-during-PWA_2_1': 0,
    },
)
field_id_12675_diastolic_brachial_blood_pressure_during_pwa_2_1 = TensorMap(
    '12675_Diastolic-brachial-blood-pressure-during-PWA_2_1', path_prefix='continuous', loss='logcosh',
    channel_map={'12675_Diastolic-brachial-blood-pressure-during-PWA_2_1': 0},
)
field_id_12674_systolic_brachial_blood_pressure_during_pwa_2_1 = TensorMap(
    '12674_Systolic-brachial-blood-pressure-during-PWA_2_1', path_prefix='continuous', loss='logcosh',
    channel_map={'12674_Systolic-brachial-blood-pressure-during-PWA_2_1': 0},
)
field_id_12686_stroke_volume_during_pwa_2_0 = TensorMap(
    '12686_Stroke-volume-during-PWA_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'12686_Stroke-volume-during-PWA_2_0': 0},
)
field_id_12682_cardiac_output_during_pwa_2_0 = TensorMap(
    '12682_Cardiac-output-during-PWA_2_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'12682_Cardiac-output-during-PWA_2_0': 0},
)
field_id_25920_volume_of_grey_matter_in_x_cerebellum_right_2_0 = TensorMap(
    '25920_Volume-of-grey-matter-in-X-Cerebellum-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25920_Volume-of-grey-matter-in-X-Cerebellum-right_2_0': 0},
)
field_id_25919_volume_of_grey_matter_in_x_cerebellum_vermis_2_0 = TensorMap(
    '25919_Volume-of-grey-matter-in-X-Cerebellum-vermis_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25919_Volume-of-grey-matter-in-X-Cerebellum-vermis_2_0': 0},
)
field_id_25918_volume_of_grey_matter_in_x_cerebellum_left_2_0 = TensorMap(
    '25918_Volume-of-grey-matter-in-X-Cerebellum-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25918_Volume-of-grey-matter-in-X-Cerebellum-left_2_0': 0},
)
field_id_25917_volume_of_grey_matter_in_ix_cerebellum_right_2_0 = TensorMap(
    '25917_Volume-of-grey-matter-in-IX-Cerebellum-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25917_Volume-of-grey-matter-in-IX-Cerebellum-right_2_0': 0},
)
field_id_25916_volume_of_grey_matter_in_ix_cerebellum_vermis_2_0 = TensorMap(
    '25916_Volume-of-grey-matter-in-IX-Cerebellum-vermis_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25916_Volume-of-grey-matter-in-IX-Cerebellum-vermis_2_0': 0},
)
field_id_25915_volume_of_grey_matter_in_ix_cerebellum_left_2_0 = TensorMap(
    '25915_Volume-of-grey-matter-in-IX-Cerebellum-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25915_Volume-of-grey-matter-in-IX-Cerebellum-left_2_0': 0},
)
field_id_25914_volume_of_grey_matter_in_viiib_cerebellum_right_2_0 = TensorMap(
    '25914_Volume-of-grey-matter-in-VIIIb-Cerebellum-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25914_Volume-of-grey-matter-in-VIIIb-Cerebellum-right_2_0': 0},
)
field_id_25913_volume_of_grey_matter_in_viiib_cerebellum_vermis_2_0 = TensorMap(
    '25913_Volume-of-grey-matter-in-VIIIb-Cerebellum-vermis_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25913_Volume-of-grey-matter-in-VIIIb-Cerebellum-vermis_2_0': 0},
)
field_id_25912_volume_of_grey_matter_in_viiib_cerebellum_left_2_0 = TensorMap(
    '25912_Volume-of-grey-matter-in-VIIIb-Cerebellum-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25912_Volume-of-grey-matter-in-VIIIb-Cerebellum-left_2_0': 0},
)
field_id_25911_volume_of_grey_matter_in_viiia_cerebellum_right_2_0 = TensorMap(
    '25911_Volume-of-grey-matter-in-VIIIa-Cerebellum-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25911_Volume-of-grey-matter-in-VIIIa-Cerebellum-right_2_0': 0},
)
field_id_25910_volume_of_grey_matter_in_viiia_cerebellum_vermis_2_0 = TensorMap(
    '25910_Volume-of-grey-matter-in-VIIIa-Cerebellum-vermis_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25910_Volume-of-grey-matter-in-VIIIa-Cerebellum-vermis_2_0': 0},
)
field_id_25909_volume_of_grey_matter_in_viiia_cerebellum_left_2_0 = TensorMap(
    '25909_Volume-of-grey-matter-in-VIIIa-Cerebellum-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25909_Volume-of-grey-matter-in-VIIIa-Cerebellum-left_2_0': 0},
)
field_id_25908_volume_of_grey_matter_in_viib_cerebellum_right_2_0 = TensorMap(
    '25908_Volume-of-grey-matter-in-VIIb-Cerebellum-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25908_Volume-of-grey-matter-in-VIIb-Cerebellum-right_2_0': 0},
)
field_id_25907_volume_of_grey_matter_in_viib_cerebellum_vermis_2_0 = TensorMap(
    '25907_Volume-of-grey-matter-in-VIIb-Cerebellum-vermis_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25907_Volume-of-grey-matter-in-VIIb-Cerebellum-vermis_2_0': 0},
)
field_id_25906_volume_of_grey_matter_in_viib_cerebellum_left_2_0 = TensorMap(
    '25906_Volume-of-grey-matter-in-VIIb-Cerebellum-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25906_Volume-of-grey-matter-in-VIIb-Cerebellum-left_2_0': 0},
)
field_id_25905_volume_of_grey_matter_in_crus_ii_cerebellum_right_2_0 = TensorMap(
    '25905_Volume-of-grey-matter-in-Crus-II-Cerebellum-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25905_Volume-of-grey-matter-in-Crus-II-Cerebellum-right_2_0': 0},
)
field_id_25904_volume_of_grey_matter_in_crus_ii_cerebellum_vermis_2_0 = TensorMap(
    '25904_Volume-of-grey-matter-in-Crus-II-Cerebellum-vermis_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25904_Volume-of-grey-matter-in-Crus-II-Cerebellum-vermis_2_0': 0},
)
field_id_25903_volume_of_grey_matter_in_crus_ii_cerebellum_left_2_0 = TensorMap(
    '25903_Volume-of-grey-matter-in-Crus-II-Cerebellum-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25903_Volume-of-grey-matter-in-Crus-II-Cerebellum-left_2_0': 0},
)
field_id_25902_volume_of_grey_matter_in_crus_i_cerebellum_right_2_0 = TensorMap(
    '25902_Volume-of-grey-matter-in-Crus-I-Cerebellum-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25902_Volume-of-grey-matter-in-Crus-I-Cerebellum-right_2_0': 0},
)
field_id_25901_volume_of_grey_matter_in_crus_i_cerebellum_vermis_2_0 = TensorMap(
    '25901_Volume-of-grey-matter-in-Crus-I-Cerebellum-vermis_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25901_Volume-of-grey-matter-in-Crus-I-Cerebellum-vermis_2_0': 0},
)
field_id_25900_volume_of_grey_matter_in_crus_i_cerebellum_left_2_0 = TensorMap(
    '25900_Volume-of-grey-matter-in-Crus-I-Cerebellum-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25900_Volume-of-grey-matter-in-Crus-I-Cerebellum-left_2_0': 0},
)
field_id_25899_volume_of_grey_matter_in_vi_cerebellum_right_2_0 = TensorMap(
    '25899_Volume-of-grey-matter-in-VI-Cerebellum-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25899_Volume-of-grey-matter-in-VI-Cerebellum-right_2_0': 0},
)
field_id_25898_volume_of_grey_matter_in_vi_cerebellum_vermis_2_0 = TensorMap(
    '25898_Volume-of-grey-matter-in-VI-Cerebellum-vermis_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25898_Volume-of-grey-matter-in-VI-Cerebellum-vermis_2_0': 0},
)
field_id_25897_volume_of_grey_matter_in_vi_cerebellum_left_2_0 = TensorMap(
    '25897_Volume-of-grey-matter-in-VI-Cerebellum-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25897_Volume-of-grey-matter-in-VI-Cerebellum-left_2_0': 0},
)
field_id_25896_volume_of_grey_matter_in_v_cerebellum_right_2_0 = TensorMap(
    '25896_Volume-of-grey-matter-in-V-Cerebellum-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25896_Volume-of-grey-matter-in-V-Cerebellum-right_2_0': 0},
)
field_id_25895_volume_of_grey_matter_in_v_cerebellum_left_2_0 = TensorMap(
    '25895_Volume-of-grey-matter-in-V-Cerebellum-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25895_Volume-of-grey-matter-in-V-Cerebellum-left_2_0': 0},
)
field_id_25894_volume_of_grey_matter_in_iiv_cerebellum_right_2_0 = TensorMap(
    '25894_Volume-of-grey-matter-in-IIV-Cerebellum-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25894_Volume-of-grey-matter-in-IIV-Cerebellum-right_2_0': 0},
)
field_id_25893_volume_of_grey_matter_in_iiv_cerebellum_left_2_0 = TensorMap(
    '25893_Volume-of-grey-matter-in-IIV-Cerebellum-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25893_Volume-of-grey-matter-in-IIV-Cerebellum-left_2_0': 0},
)
field_id_25892_volume_of_grey_matter_in_brainstem_2_0 = TensorMap(
    '25892_Volume-of-grey-matter-in-BrainStem_2_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '25892_Volume-of-grey-matter-in-BrainStem_2_0': 0,
    },
)
field_id_25891_volume_of_grey_matter_in_ventral_striatum_right_2_0 = TensorMap(
    '25891_Volume-of-grey-matter-in-Ventral-Striatum-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25891_Volume-of-grey-matter-in-Ventral-Striatum-right_2_0': 0},
)
field_id_25890_volume_of_grey_matter_in_ventral_striatum_left_2_0 = TensorMap(
    '25890_Volume-of-grey-matter-in-Ventral-Striatum-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25890_Volume-of-grey-matter-in-Ventral-Striatum-left_2_0': 0},
)
field_id_25889_volume_of_grey_matter_in_amygdala_right_2_0 = TensorMap(
    '25889_Volume-of-grey-matter-in-Amygdala-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25889_Volume-of-grey-matter-in-Amygdala-right_2_0': 0},
)
field_id_25888_volume_of_grey_matter_in_amygdala_left_2_0 = TensorMap(
    '25888_Volume-of-grey-matter-in-Amygdala-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25888_Volume-of-grey-matter-in-Amygdala-left_2_0': 0},
)
field_id_25887_volume_of_grey_matter_in_hippocampus_right_2_0 = TensorMap(
    '25887_Volume-of-grey-matter-in-Hippocampus-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25887_Volume-of-grey-matter-in-Hippocampus-right_2_0': 0},
)
field_id_25886_volume_of_grey_matter_in_hippocampus_left_2_0 = TensorMap(
    '25886_Volume-of-grey-matter-in-Hippocampus-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25886_Volume-of-grey-matter-in-Hippocampus-left_2_0': 0},
)
field_id_25885_volume_of_grey_matter_in_pallidum_right_2_0 = TensorMap(
    '25885_Volume-of-grey-matter-in-Pallidum-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25885_Volume-of-grey-matter-in-Pallidum-right_2_0': 0},
)
field_id_25884_volume_of_grey_matter_in_pallidum_left_2_0 = TensorMap(
    '25884_Volume-of-grey-matter-in-Pallidum-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25884_Volume-of-grey-matter-in-Pallidum-left_2_0': 0},
)
field_id_25883_volume_of_grey_matter_in_putamen_right_2_0 = TensorMap(
    '25883_Volume-of-grey-matter-in-Putamen-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25883_Volume-of-grey-matter-in-Putamen-right_2_0': 0},
)
field_id_25882_volume_of_grey_matter_in_putamen_left_2_0 = TensorMap(
    '25882_Volume-of-grey-matter-in-Putamen-left_2_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '25882_Volume-of-grey-matter-in-Putamen-left_2_0': 0,
    },
)
field_id_25881_volume_of_grey_matter_in_caudate_right_2_0 = TensorMap(
    '25881_Volume-of-grey-matter-in-Caudate-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25881_Volume-of-grey-matter-in-Caudate-right_2_0': 0},
)
field_id_25880_volume_of_grey_matter_in_caudate_left_2_0 = TensorMap(
    '25880_Volume-of-grey-matter-in-Caudate-left_2_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '25880_Volume-of-grey-matter-in-Caudate-left_2_0': 0,
    },
)
field_id_25879_volume_of_grey_matter_in_thalamus_right_2_0 = TensorMap(
    '25879_Volume-of-grey-matter-in-Thalamus-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25879_Volume-of-grey-matter-in-Thalamus-right_2_0': 0},
)
field_id_25878_volume_of_grey_matter_in_thalamus_left_2_0 = TensorMap(
    '25878_Volume-of-grey-matter-in-Thalamus-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25878_Volume-of-grey-matter-in-Thalamus-left_2_0': 0},
)
field_id_25877_volume_of_grey_matter_in_occipital_pole_right_2_0 = TensorMap(
    '25877_Volume-of-grey-matter-in-Occipital-Pole-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25877_Volume-of-grey-matter-in-Occipital-Pole-right_2_0': 0},
)
field_id_25876_volume_of_grey_matter_in_occipital_pole_left_2_0 = TensorMap(
    '25876_Volume-of-grey-matter-in-Occipital-Pole-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25876_Volume-of-grey-matter-in-Occipital-Pole-left_2_0': 0},
)
field_id_25875_volume_of_grey_matter_in_supracalcarine_cortex_right_2_0 = TensorMap(
    '25875_Volume-of-grey-matter-in-Supracalcarine-Cortex-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25875_Volume-of-grey-matter-in-Supracalcarine-Cortex-right_2_0': 0},
)
field_id_25874_volume_of_grey_matter_in_supracalcarine_cortex_left_2_0 = TensorMap(
    '25874_Volume-of-grey-matter-in-Supracalcarine-Cortex-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25874_Volume-of-grey-matter-in-Supracalcarine-Cortex-left_2_0': 0},
)
field_id_25873_volume_of_grey_matter_in_planum_temporale_right_2_0 = TensorMap(
    '25873_Volume-of-grey-matter-in-Planum-Temporale-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25873_Volume-of-grey-matter-in-Planum-Temporale-right_2_0': 0},
)
field_id_25872_volume_of_grey_matter_in_planum_temporale_left_2_0 = TensorMap(
    '25872_Volume-of-grey-matter-in-Planum-Temporale-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25872_Volume-of-grey-matter-in-Planum-Temporale-left_2_0': 0},
)
field_id_25871_volume_of_grey_matter_in_heschls_gyrus_includes_h1_and_h2_right_2_0 = TensorMap(
    '25871_Volume-of-grey-matter-in-Heschls-Gyrus-includes-H1-and-H2-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25871_Volume-of-grey-matter-in-Heschls-Gyrus-includes-H1-and-H2-right_2_0': 0},
)
field_id_25870_volume_of_grey_matter_in_heschls_gyrus_includes_h1_and_h2_left_2_0 = TensorMap(
    '25870_Volume-of-grey-matter-in-Heschls-Gyrus-includes-H1-and-H2-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25870_Volume-of-grey-matter-in-Heschls-Gyrus-includes-H1-and-H2-left_2_0': 0},
)
field_id_25869_volume_of_grey_matter_in_planum_polare_right_2_0 = TensorMap(
    '25869_Volume-of-grey-matter-in-Planum-Polare-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25869_Volume-of-grey-matter-in-Planum-Polare-right_2_0': 0},
)
field_id_25868_volume_of_grey_matter_in_planum_polare_left_2_0 = TensorMap(
    '25868_Volume-of-grey-matter-in-Planum-Polare-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25868_Volume-of-grey-matter-in-Planum-Polare-left_2_0': 0},
)
field_id_25867_volume_of_grey_matter_in_parietal_operculum_cortex_right_2_0 = TensorMap(
    '25867_Volume-of-grey-matter-in-Parietal-Operculum-Cortex-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25867_Volume-of-grey-matter-in-Parietal-Operculum-Cortex-right_2_0': 0},
)
field_id_25866_volume_of_grey_matter_in_parietal_operculum_cortex_left_2_0 = TensorMap(
    '25866_Volume-of-grey-matter-in-Parietal-Operculum-Cortex-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25866_Volume-of-grey-matter-in-Parietal-Operculum-Cortex-left_2_0': 0},
)
field_id_25865_volume_of_grey_matter_in_central_opercular_cortex_right_2_0 = TensorMap(
    '25865_Volume-of-grey-matter-in-Central-Opercular-Cortex-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25865_Volume-of-grey-matter-in-Central-Opercular-Cortex-right_2_0': 0},
)
field_id_25864_volume_of_grey_matter_in_central_opercular_cortex_left_2_0 = TensorMap(
    '25864_Volume-of-grey-matter-in-Central-Opercular-Cortex-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25864_Volume-of-grey-matter-in-Central-Opercular-Cortex-left_2_0': 0},
)
field_id_25863_volume_of_grey_matter_in_frontal_operculum_cortex_right_2_0 = TensorMap(
    '25863_Volume-of-grey-matter-in-Frontal-Operculum-Cortex-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25863_Volume-of-grey-matter-in-Frontal-Operculum-Cortex-right_2_0': 0},
)
field_id_25862_volume_of_grey_matter_in_frontal_operculum_cortex_left_2_0 = TensorMap(
    '25862_Volume-of-grey-matter-in-Frontal-Operculum-Cortex-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25862_Volume-of-grey-matter-in-Frontal-Operculum-Cortex-left_2_0': 0},
)
field_id_25861_volume_of_grey_matter_in_occipital_fusiform_gyrus_right_2_0 = TensorMap(
    '25861_Volume-of-grey-matter-in-Occipital-Fusiform-Gyrus-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25861_Volume-of-grey-matter-in-Occipital-Fusiform-Gyrus-right_2_0': 0},
)
field_id_25860_volume_of_grey_matter_in_occipital_fusiform_gyrus_left_2_0 = TensorMap(
    '25860_Volume-of-grey-matter-in-Occipital-Fusiform-Gyrus-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25860_Volume-of-grey-matter-in-Occipital-Fusiform-Gyrus-left_2_0': 0},
)
field_id_25859_volume_of_grey_matter_in_temporal_occipital_fusiform_cortex_right_2_0 = TensorMap(
    '25859_Volume-of-grey-matter-in-Temporal-Occipital-Fusiform-Cortex-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25859_Volume-of-grey-matter-in-Temporal-Occipital-Fusiform-Cortex-right_2_0': 0},
)
field_id_25858_volume_of_grey_matter_in_temporal_occipital_fusiform_cortex_left_2_0 = TensorMap(
    '25858_Volume-of-grey-matter-in-Temporal-Occipital-Fusiform-Cortex-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25858_Volume-of-grey-matter-in-Temporal-Occipital-Fusiform-Cortex-left_2_0': 0},
)
field_id_25857_volume_of_grey_matter_in_temporal_fusiform_cortex_posterior_division_right_2_0 = TensorMap(
    '25857_Volume-of-grey-matter-in-Temporal-Fusiform-Cortex-posterior-division-right_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'25857_Volume-of-grey-matter-in-Temporal-Fusiform-Cortex-posterior-division-right_2_0': 0},
)
field_id_25856_volume_of_grey_matter_in_temporal_fusiform_cortex_posterior_division_left_2_0 = TensorMap(
    '25856_Volume-of-grey-matter-in-Temporal-Fusiform-Cortex-posterior-division-left_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'25856_Volume-of-grey-matter-in-Temporal-Fusiform-Cortex-posterior-division-left_2_0': 0},
)
field_id_25855_volume_of_grey_matter_in_temporal_fusiform_cortex_anterior_division_right_2_0 = TensorMap(
    '25855_Volume-of-grey-matter-in-Temporal-Fusiform-Cortex-anterior-division-right_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'25855_Volume-of-grey-matter-in-Temporal-Fusiform-Cortex-anterior-division-right_2_0': 0},
)
field_id_25854_volume_of_grey_matter_in_temporal_fusiform_cortex_anterior_division_left_2_0 = TensorMap(
    '25854_Volume-of-grey-matter-in-Temporal-Fusiform-Cortex-anterior-division-left_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'25854_Volume-of-grey-matter-in-Temporal-Fusiform-Cortex-anterior-division-left_2_0': 0},
)
field_id_25853_volume_of_grey_matter_in_lingual_gyrus_right_2_0 = TensorMap(
    '25853_Volume-of-grey-matter-in-Lingual-Gyrus-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25853_Volume-of-grey-matter-in-Lingual-Gyrus-right_2_0': 0},
)
field_id_25852_volume_of_grey_matter_in_lingual_gyrus_left_2_0 = TensorMap(
    '25852_Volume-of-grey-matter-in-Lingual-Gyrus-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25852_Volume-of-grey-matter-in-Lingual-Gyrus-left_2_0': 0},
)
field_id_25851_volume_of_grey_matter_in_parahippocampal_gyrus_posterior_division_right_2_0 = TensorMap(
    '25851_Volume-of-grey-matter-in-Parahippocampal-Gyrus-posterior-division-right_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'25851_Volume-of-grey-matter-in-Parahippocampal-Gyrus-posterior-division-right_2_0': 0},
)
field_id_25850_volume_of_grey_matter_in_parahippocampal_gyrus_posterior_division_left_2_0 = TensorMap(
    '25850_Volume-of-grey-matter-in-Parahippocampal-Gyrus-posterior-division-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25850_Volume-of-grey-matter-in-Parahippocampal-Gyrus-posterior-division-left_2_0': 0},
)
field_id_25849_volume_of_grey_matter_in_parahippocampal_gyrus_anterior_division_right_2_0 = TensorMap(
    '25849_Volume-of-grey-matter-in-Parahippocampal-Gyrus-anterior-division-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25849_Volume-of-grey-matter-in-Parahippocampal-Gyrus-anterior-division-right_2_0': 0},
)
field_id_25848_volume_of_grey_matter_in_parahippocampal_gyrus_anterior_division_left_2_0 = TensorMap(
    '25848_Volume-of-grey-matter-in-Parahippocampal-Gyrus-anterior-division-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25848_Volume-of-grey-matter-in-Parahippocampal-Gyrus-anterior-division-left_2_0': 0},
)
field_id_25847_volume_of_grey_matter_in_frontal_orbital_cortex_right_2_0 = TensorMap(
    '25847_Volume-of-grey-matter-in-Frontal-Orbital-Cortex-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25847_Volume-of-grey-matter-in-Frontal-Orbital-Cortex-right_2_0': 0},
)
field_id_25846_volume_of_grey_matter_in_frontal_orbital_cortex_left_2_0 = TensorMap(
    '25846_Volume-of-grey-matter-in-Frontal-Orbital-Cortex-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25846_Volume-of-grey-matter-in-Frontal-Orbital-Cortex-left_2_0': 0},
)
field_id_25845_volume_of_grey_matter_in_cuneal_cortex_right_2_0 = TensorMap(
    '25845_Volume-of-grey-matter-in-Cuneal-Cortex-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25845_Volume-of-grey-matter-in-Cuneal-Cortex-right_2_0': 0},
)
field_id_25844_volume_of_grey_matter_in_cuneal_cortex_left_2_0 = TensorMap(
    '25844_Volume-of-grey-matter-in-Cuneal-Cortex-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25844_Volume-of-grey-matter-in-Cuneal-Cortex-left_2_0': 0},
)
field_id_25843_volume_of_grey_matter_in_precuneous_cortex_right_2_0 = TensorMap(
    '25843_Volume-of-grey-matter-in-Precuneous-Cortex-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25843_Volume-of-grey-matter-in-Precuneous-Cortex-right_2_0': 0},
)
field_id_25842_volume_of_grey_matter_in_precuneous_cortex_left_2_0 = TensorMap(
    '25842_Volume-of-grey-matter-in-Precuneous-Cortex-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25842_Volume-of-grey-matter-in-Precuneous-Cortex-left_2_0': 0},
)
field_id_25841_volume_of_grey_matter_in_cingulate_gyrus_posterior_division_right_2_0 = TensorMap(
    '25841_Volume-of-grey-matter-in-Cingulate-Gyrus-posterior-division-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25841_Volume-of-grey-matter-in-Cingulate-Gyrus-posterior-division-right_2_0': 0},
)
field_id_25840_volume_of_grey_matter_in_cingulate_gyrus_posterior_division_left_2_0 = TensorMap(
    '25840_Volume-of-grey-matter-in-Cingulate-Gyrus-posterior-division-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25840_Volume-of-grey-matter-in-Cingulate-Gyrus-posterior-division-left_2_0': 0},
)
field_id_25839_volume_of_grey_matter_in_cingulate_gyrus_anterior_division_right_2_0 = TensorMap(
    '25839_Volume-of-grey-matter-in-Cingulate-Gyrus-anterior-division-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25839_Volume-of-grey-matter-in-Cingulate-Gyrus-anterior-division-right_2_0': 0},
)
field_id_25838_volume_of_grey_matter_in_cingulate_gyrus_anterior_division_left_2_0 = TensorMap(
    '25838_Volume-of-grey-matter-in-Cingulate-Gyrus-anterior-division-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25838_Volume-of-grey-matter-in-Cingulate-Gyrus-anterior-division-left_2_0': 0},
)
field_id_25837_volume_of_grey_matter_in_paracingulate_gyrus_right_2_0 = TensorMap(
    '25837_Volume-of-grey-matter-in-Paracingulate-Gyrus-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25837_Volume-of-grey-matter-in-Paracingulate-Gyrus-right_2_0': 0},
)
field_id_25836_volume_of_grey_matter_in_paracingulate_gyrus_left_2_0 = TensorMap(
    '25836_Volume-of-grey-matter-in-Paracingulate-Gyrus-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25836_Volume-of-grey-matter-in-Paracingulate-Gyrus-left_2_0': 0},
)
field_id_25835_volume_of_grey_matter_in_subcallosal_cortex_right_2_0 = TensorMap(
    '25835_Volume-of-grey-matter-in-Subcallosal-Cortex-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25835_Volume-of-grey-matter-in-Subcallosal-Cortex-right_2_0': 0},
)
field_id_25834_volume_of_grey_matter_in_subcallosal_cortex_left_2_0 = TensorMap(
    '25834_Volume-of-grey-matter-in-Subcallosal-Cortex-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25834_Volume-of-grey-matter-in-Subcallosal-Cortex-left_2_0': 0},
)
field_id_25833_volume_of_grey_matter_in_juxtapositional_lobule_cortex_formerly_supplementary_motor_cortex_right_2_0 = TensorMap(
    '25833_Volume-of-grey-matter-in-Juxtapositional-Lobule-Cortex-formerly-Supplementary-Motor-Cortex-right_2_0',
    path_prefix='continuous', loss='logcosh', channel_map={
        '25833_Volume-of-grey-matter-in-Juxtapositional-Lobule-Cortex-formerly-Supplementary-Motor-Cortex-right_2_0': 0,
    },
)
field_id_25832_volume_of_grey_matter_in_juxtapositional_lobule_cortex_formerly_supplementary_motor_cortex_left_2_0 = TensorMap(
    '25832_Volume-of-grey-matter-in-Juxtapositional-Lobule-Cortex-formerly-Supplementary-Motor-Cortex-left_2_0',
    path_prefix='continuous', loss='logcosh', channel_map={
        '25832_Volume-of-grey-matter-in-Juxtapositional-Lobule-Cortex-formerly-Supplementary-Motor-Cortex-left_2_0': 0,
    },
)
field_id_25831_volume_of_grey_matter_in_frontal_medial_cortex_right_2_0 = TensorMap(
    '25831_Volume-of-grey-matter-in-Frontal-Medial-Cortex-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25831_Volume-of-grey-matter-in-Frontal-Medial-Cortex-right_2_0': 0},
)
field_id_25830_volume_of_grey_matter_in_frontal_medial_cortex_left_2_0 = TensorMap(
    '25830_Volume-of-grey-matter-in-Frontal-Medial-Cortex-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25830_Volume-of-grey-matter-in-Frontal-Medial-Cortex-left_2_0': 0},
)
field_id_25829_volume_of_grey_matter_in_intracalcarine_cortex_right_2_0 = TensorMap(
    '25829_Volume-of-grey-matter-in-Intracalcarine-Cortex-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25829_Volume-of-grey-matter-in-Intracalcarine-Cortex-right_2_0': 0},
)
field_id_25828_volume_of_grey_matter_in_intracalcarine_cortex_left_2_0 = TensorMap(
    '25828_Volume-of-grey-matter-in-Intracalcarine-Cortex-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25828_Volume-of-grey-matter-in-Intracalcarine-Cortex-left_2_0': 0},
)
field_id_25827_volume_of_grey_matter_in_lateral_occipital_cortex_inferior_division_right_2_0 = TensorMap(
    '25827_Volume-of-grey-matter-in-Lateral-Occipital-Cortex-inferior-division-right_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'25827_Volume-of-grey-matter-in-Lateral-Occipital-Cortex-inferior-division-right_2_0': 0},
)
field_id_25826_volume_of_grey_matter_in_lateral_occipital_cortex_inferior_division_left_2_0 = TensorMap(
    '25826_Volume-of-grey-matter-in-Lateral-Occipital-Cortex-inferior-division-left_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'25826_Volume-of-grey-matter-in-Lateral-Occipital-Cortex-inferior-division-left_2_0': 0},
)
field_id_25825_volume_of_grey_matter_in_lateral_occipital_cortex_superior_division_right_2_0 = TensorMap(
    '25825_Volume-of-grey-matter-in-Lateral-Occipital-Cortex-superior-division-right_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'25825_Volume-of-grey-matter-in-Lateral-Occipital-Cortex-superior-division-right_2_0': 0},
)
field_id_25824_volume_of_grey_matter_in_lateral_occipital_cortex_superior_division_left_2_0 = TensorMap(
    '25824_Volume-of-grey-matter-in-Lateral-Occipital-Cortex-superior-division-left_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'25824_Volume-of-grey-matter-in-Lateral-Occipital-Cortex-superior-division-left_2_0': 0},
)
field_id_25823_volume_of_grey_matter_in_angular_gyrus_right_2_0 = TensorMap(
    '25823_Volume-of-grey-matter-in-Angular-Gyrus-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25823_Volume-of-grey-matter-in-Angular-Gyrus-right_2_0': 0},
)
field_id_25822_volume_of_grey_matter_in_angular_gyrus_left_2_0 = TensorMap(
    '25822_Volume-of-grey-matter-in-Angular-Gyrus-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25822_Volume-of-grey-matter-in-Angular-Gyrus-left_2_0': 0},
)
field_id_25821_volume_of_grey_matter_in_supramarginal_gyrus_posterior_division_right_2_0 = TensorMap(
    '25821_Volume-of-grey-matter-in-Supramarginal-Gyrus-posterior-division-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25821_Volume-of-grey-matter-in-Supramarginal-Gyrus-posterior-division-right_2_0': 0},
)
field_id_25820_volume_of_grey_matter_in_supramarginal_gyrus_posterior_division_left_2_0 = TensorMap(
    '25820_Volume-of-grey-matter-in-Supramarginal-Gyrus-posterior-division-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25820_Volume-of-grey-matter-in-Supramarginal-Gyrus-posterior-division-left_2_0': 0},
)
field_id_25819_volume_of_grey_matter_in_supramarginal_gyrus_anterior_division_right_2_0 = TensorMap(
    '25819_Volume-of-grey-matter-in-Supramarginal-Gyrus-anterior-division-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25819_Volume-of-grey-matter-in-Supramarginal-Gyrus-anterior-division-right_2_0': 0},
)
field_id_25818_volume_of_grey_matter_in_supramarginal_gyrus_anterior_division_left_2_0 = TensorMap(
    '25818_Volume-of-grey-matter-in-Supramarginal-Gyrus-anterior-division-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25818_Volume-of-grey-matter-in-Supramarginal-Gyrus-anterior-division-left_2_0': 0},
)
field_id_25817_volume_of_grey_matter_in_superior_parietal_lobule_right_2_0 = TensorMap(
    '25817_Volume-of-grey-matter-in-Superior-Parietal-Lobule-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25817_Volume-of-grey-matter-in-Superior-Parietal-Lobule-right_2_0': 0},
)
field_id_25816_volume_of_grey_matter_in_superior_parietal_lobule_left_2_0 = TensorMap(
    '25816_Volume-of-grey-matter-in-Superior-Parietal-Lobule-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25816_Volume-of-grey-matter-in-Superior-Parietal-Lobule-left_2_0': 0},
)
field_id_25815_volume_of_grey_matter_in_postcentral_gyrus_right_2_0 = TensorMap(
    '25815_Volume-of-grey-matter-in-Postcentral-Gyrus-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25815_Volume-of-grey-matter-in-Postcentral-Gyrus-right_2_0': 0},
)
field_id_25814_volume_of_grey_matter_in_postcentral_gyrus_left_2_0 = TensorMap(
    '25814_Volume-of-grey-matter-in-Postcentral-Gyrus-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25814_Volume-of-grey-matter-in-Postcentral-Gyrus-left_2_0': 0},
)
field_id_25813_volume_of_grey_matter_in_inferior_temporal_gyrus_temporooccipital_part_right_2_0 = TensorMap(
    '25813_Volume-of-grey-matter-in-Inferior-Temporal-Gyrus-temporooccipital-part-right_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'25813_Volume-of-grey-matter-in-Inferior-Temporal-Gyrus-temporooccipital-part-right_2_0': 0},
)
field_id_25812_volume_of_grey_matter_in_inferior_temporal_gyrus_temporooccipital_part_left_2_0 = TensorMap(
    '25812_Volume-of-grey-matter-in-Inferior-Temporal-Gyrus-temporooccipital-part-left_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'25812_Volume-of-grey-matter-in-Inferior-Temporal-Gyrus-temporooccipital-part-left_2_0': 0},
)
field_id_25811_volume_of_grey_matter_in_inferior_temporal_gyrus_posterior_division_right_2_0 = TensorMap(
    '25811_Volume-of-grey-matter-in-Inferior-Temporal-Gyrus-posterior-division-right_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'25811_Volume-of-grey-matter-in-Inferior-Temporal-Gyrus-posterior-division-right_2_0': 0},
)
field_id_25810_volume_of_grey_matter_in_inferior_temporal_gyrus_posterior_division_left_2_0 = TensorMap(
    '25810_Volume-of-grey-matter-in-Inferior-Temporal-Gyrus-posterior-division-left_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'25810_Volume-of-grey-matter-in-Inferior-Temporal-Gyrus-posterior-division-left_2_0': 0},
)
field_id_25809_volume_of_grey_matter_in_inferior_temporal_gyrus_anterior_division_right_2_0 = TensorMap(
    '25809_Volume-of-grey-matter-in-Inferior-Temporal-Gyrus-anterior-division-right_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'25809_Volume-of-grey-matter-in-Inferior-Temporal-Gyrus-anterior-division-right_2_0': 0},
)
field_id_25808_volume_of_grey_matter_in_inferior_temporal_gyrus_anterior_division_left_2_0 = TensorMap(
    '25808_Volume-of-grey-matter-in-Inferior-Temporal-Gyrus-anterior-division-left_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'25808_Volume-of-grey-matter-in-Inferior-Temporal-Gyrus-anterior-division-left_2_0': 0},
)
field_id_25807_volume_of_grey_matter_in_middle_temporal_gyrus_temporooccipital_part_right_2_0 = TensorMap(
    '25807_Volume-of-grey-matter-in-Middle-Temporal-Gyrus-temporooccipital-part-right_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'25807_Volume-of-grey-matter-in-Middle-Temporal-Gyrus-temporooccipital-part-right_2_0': 0},
)
field_id_25806_volume_of_grey_matter_in_middle_temporal_gyrus_temporooccipital_part_left_2_0 = TensorMap(
    '25806_Volume-of-grey-matter-in-Middle-Temporal-Gyrus-temporooccipital-part-left_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'25806_Volume-of-grey-matter-in-Middle-Temporal-Gyrus-temporooccipital-part-left_2_0': 0},
)
field_id_25805_volume_of_grey_matter_in_middle_temporal_gyrus_posterior_division_right_2_0 = TensorMap(
    '25805_Volume-of-grey-matter-in-Middle-Temporal-Gyrus-posterior-division-right_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'25805_Volume-of-grey-matter-in-Middle-Temporal-Gyrus-posterior-division-right_2_0': 0},
)
field_id_25804_volume_of_grey_matter_in_middle_temporal_gyrus_posterior_division_left_2_0 = TensorMap(
    '25804_Volume-of-grey-matter-in-Middle-Temporal-Gyrus-posterior-division-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25804_Volume-of-grey-matter-in-Middle-Temporal-Gyrus-posterior-division-left_2_0': 0},
)
field_id_25803_volume_of_grey_matter_in_middle_temporal_gyrus_anterior_division_right_2_0 = TensorMap(
    '25803_Volume-of-grey-matter-in-Middle-Temporal-Gyrus-anterior-division-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25803_Volume-of-grey-matter-in-Middle-Temporal-Gyrus-anterior-division-right_2_0': 0},
)
field_id_25802_volume_of_grey_matter_in_middle_temporal_gyrus_anterior_division_left_2_0 = TensorMap(
    '25802_Volume-of-grey-matter-in-Middle-Temporal-Gyrus-anterior-division-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25802_Volume-of-grey-matter-in-Middle-Temporal-Gyrus-anterior-division-left_2_0': 0},
)
field_id_25801_volume_of_grey_matter_in_superior_temporal_gyrus_posterior_division_right_2_0 = TensorMap(
    '25801_Volume-of-grey-matter-in-Superior-Temporal-Gyrus-posterior-division-right_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'25801_Volume-of-grey-matter-in-Superior-Temporal-Gyrus-posterior-division-right_2_0': 0},
)
field_id_25800_volume_of_grey_matter_in_superior_temporal_gyrus_posterior_division_left_2_0 = TensorMap(
    '25800_Volume-of-grey-matter-in-Superior-Temporal-Gyrus-posterior-division-left_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'25800_Volume-of-grey-matter-in-Superior-Temporal-Gyrus-posterior-division-left_2_0': 0},
)
field_id_25799_volume_of_grey_matter_in_superior_temporal_gyrus_anterior_division_right_2_0 = TensorMap(
    '25799_Volume-of-grey-matter-in-Superior-Temporal-Gyrus-anterior-division-right_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'25799_Volume-of-grey-matter-in-Superior-Temporal-Gyrus-anterior-division-right_2_0': 0},
)
field_id_25798_volume_of_grey_matter_in_superior_temporal_gyrus_anterior_division_left_2_0 = TensorMap(
    '25798_Volume-of-grey-matter-in-Superior-Temporal-Gyrus-anterior-division-left_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'25798_Volume-of-grey-matter-in-Superior-Temporal-Gyrus-anterior-division-left_2_0': 0},
)
field_id_25797_volume_of_grey_matter_in_temporal_pole_right_2_0 = TensorMap(
    '25797_Volume-of-grey-matter-in-Temporal-Pole-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25797_Volume-of-grey-matter-in-Temporal-Pole-right_2_0': 0},
)
field_id_25796_volume_of_grey_matter_in_temporal_pole_left_2_0 = TensorMap(
    '25796_Volume-of-grey-matter-in-Temporal-Pole-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25796_Volume-of-grey-matter-in-Temporal-Pole-left_2_0': 0},
)
field_id_25795_volume_of_grey_matter_in_precentral_gyrus_right_2_0 = TensorMap(
    '25795_Volume-of-grey-matter-in-Precentral-Gyrus-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25795_Volume-of-grey-matter-in-Precentral-Gyrus-right_2_0': 0},
)
field_id_25794_volume_of_grey_matter_in_precentral_gyrus_left_2_0 = TensorMap(
    '25794_Volume-of-grey-matter-in-Precentral-Gyrus-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25794_Volume-of-grey-matter-in-Precentral-Gyrus-left_2_0': 0},
)
field_id_25793_volume_of_grey_matter_in_inferior_frontal_gyrus_pars_opercularis_right_2_0 = TensorMap(
    '25793_Volume-of-grey-matter-in-Inferior-Frontal-Gyrus-pars-opercularis-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25793_Volume-of-grey-matter-in-Inferior-Frontal-Gyrus-pars-opercularis-right_2_0': 0},
)
field_id_25792_volume_of_grey_matter_in_inferior_frontal_gyrus_pars_opercularis_left_2_0 = TensorMap(
    '25792_Volume-of-grey-matter-in-Inferior-Frontal-Gyrus-pars-opercularis-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25792_Volume-of-grey-matter-in-Inferior-Frontal-Gyrus-pars-opercularis-left_2_0': 0},
)
field_id_25791_volume_of_grey_matter_in_inferior_frontal_gyrus_pars_triangularis_right_2_0 = TensorMap(
    '25791_Volume-of-grey-matter-in-Inferior-Frontal-Gyrus-pars-triangularis-right_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'25791_Volume-of-grey-matter-in-Inferior-Frontal-Gyrus-pars-triangularis-right_2_0': 0},
)
field_id_25790_volume_of_grey_matter_in_inferior_frontal_gyrus_pars_triangularis_left_2_0 = TensorMap(
    '25790_Volume-of-grey-matter-in-Inferior-Frontal-Gyrus-pars-triangularis-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25790_Volume-of-grey-matter-in-Inferior-Frontal-Gyrus-pars-triangularis-left_2_0': 0},
)
field_id_25789_volume_of_grey_matter_in_middle_frontal_gyrus_right_2_0 = TensorMap(
    '25789_Volume-of-grey-matter-in-Middle-Frontal-Gyrus-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25789_Volume-of-grey-matter-in-Middle-Frontal-Gyrus-right_2_0': 0},
)
field_id_25788_volume_of_grey_matter_in_middle_frontal_gyrus_left_2_0 = TensorMap(
    '25788_Volume-of-grey-matter-in-Middle-Frontal-Gyrus-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25788_Volume-of-grey-matter-in-Middle-Frontal-Gyrus-left_2_0': 0},
)
field_id_25787_volume_of_grey_matter_in_superior_frontal_gyrus_right_2_0 = TensorMap(
    '25787_Volume-of-grey-matter-in-Superior-Frontal-Gyrus-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25787_Volume-of-grey-matter-in-Superior-Frontal-Gyrus-right_2_0': 0},
)
field_id_25786_volume_of_grey_matter_in_superior_frontal_gyrus_left_2_0 = TensorMap(
    '25786_Volume-of-grey-matter-in-Superior-Frontal-Gyrus-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25786_Volume-of-grey-matter-in-Superior-Frontal-Gyrus-left_2_0': 0},
)
field_id_25785_volume_of_grey_matter_in_insular_cortex_right_2_0 = TensorMap(
    '25785_Volume-of-grey-matter-in-Insular-Cortex-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25785_Volume-of-grey-matter-in-Insular-Cortex-right_2_0': 0},
)
field_id_25784_volume_of_grey_matter_in_insular_cortex_left_2_0 = TensorMap(
    '25784_Volume-of-grey-matter-in-Insular-Cortex-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25784_Volume-of-grey-matter-in-Insular-Cortex-left_2_0': 0},
)
field_id_25783_volume_of_grey_matter_in_frontal_pole_right_2_0 = TensorMap(
    '25783_Volume-of-grey-matter-in-Frontal-Pole-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25783_Volume-of-grey-matter-in-Frontal-Pole-right_2_0': 0},
)
field_id_25782_volume_of_grey_matter_in_frontal_pole_left_2_0 = TensorMap(
    '25782_Volume-of-grey-matter-in-Frontal-Pole-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25782_Volume-of-grey-matter-in-Frontal-Pole-left_2_0': 0},
)
field_id_25735_inverted_contrasttonoise_ratio_in_t1_2_0 = TensorMap(
    '25735_Inverted-contrasttonoise-ratio-in-T1_2_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '25735_Inverted-contrasttonoise-ratio-in-T1_2_0': 0,
    },
)
field_id_25734_inverted_signaltonoise_ratio_in_t1_2_0 = TensorMap(
    '25734_Inverted-signaltonoise-ratio-in-T1_2_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '25734_Inverted-signaltonoise-ratio-in-T1_2_0': 0,
    },
)
field_id_25732_discrepancy_between_t1_brain_image_and_standardspace_brain_template_nonlinearlyaligned_2_0 = TensorMap(
    '25732_Discrepancy-between-T1-brain-image-and-standardspace-brain-template-nonlinearlyaligned_2_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'25732_Discrepancy-between-T1-brain-image-and-standardspace-brain-template-nonlinearlyaligned_2_0': 0},
)
field_id_25731_discrepancy_between_t1_brain_image_and_standardspace_brain_template_linearlyaligned_2_0 = TensorMap(
    '25731_Discrepancy-between-T1-brain-image-and-standardspace-brain-template-linearlyaligned_2_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'25731_Discrepancy-between-T1-brain-image-and-standardspace-brain-template-linearlyaligned_2_0': 0},
)
field_id_25025_volume_of_brain_stem_4th_ventricle_2_0 = TensorMap(
    '25025_Volume-of-brain-stem-4th-ventricle_2_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '25025_Volume-of-brain-stem-4th-ventricle_2_0': 0,
    },
)
field_id_25024_volume_of_accumbens_right_2_0 = TensorMap(
    '25024_Volume-of-accumbens-right_2_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'25024_Volume-of-accumbens-right_2_0': 0},
)
field_id_25023_volume_of_accumbens_left_2_0 = TensorMap(
    '25023_Volume-of-accumbens-left_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'25023_Volume-of-accumbens-left_2_0': 0},
)
field_id_25022_volume_of_amygdala_right_2_0 = TensorMap(
    '25022_Volume-of-amygdala-right_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'25022_Volume-of-amygdala-right_2_0': 0},
)
field_id_25021_volume_of_amygdala_left_2_0 = TensorMap(
    '25021_Volume-of-amygdala-left_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'25021_Volume-of-amygdala-left_2_0': 0},
)
field_id_25020_volume_of_hippocampus_right_2_0 = TensorMap(
    '25020_Volume-of-hippocampus-right_2_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'25020_Volume-of-hippocampus-right_2_0': 0},
)
field_id_25019_volume_of_hippocampus_left_2_0 = TensorMap(
    '25019_Volume-of-hippocampus-left_2_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={'25019_Volume-of-hippocampus-left_2_0': 0},
)
field_id_25018_volume_of_pallidum_right_2_0 = TensorMap(
    '25018_Volume-of-pallidum-right_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'25018_Volume-of-pallidum-right_2_0': 0},
)
field_id_25017_volume_of_pallidum_left_2_0 = TensorMap(
    '25017_Volume-of-pallidum-left_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'25017_Volume-of-pallidum-left_2_0': 0},
)
field_id_25016_volume_of_putamen_right_2_0 = TensorMap(
    '25016_Volume-of-putamen-right_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'25016_Volume-of-putamen-right_2_0': 0},
)
field_id_25015_volume_of_putamen_left_2_0 = TensorMap(
    '25015_Volume-of-putamen-left_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'25015_Volume-of-putamen-left_2_0': 0},
)
field_id_25014_volume_of_caudate_right_2_0 = TensorMap(
    '25014_Volume-of-caudate-right_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'25014_Volume-of-caudate-right_2_0': 0},
)
field_id_25013_volume_of_caudate_left_2_0 = TensorMap(
    '25013_Volume-of-caudate-left_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'25013_Volume-of-caudate-left_2_0': 0},
)
field_id_25012_volume_of_thalamus_right_2_0 = TensorMap(
    '25012_Volume-of-thalamus-right_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'25012_Volume-of-thalamus-right_2_0': 0},
)
field_id_25011_volume_of_thalamus_left_2_0 = TensorMap(
    '25011_Volume-of-thalamus-left_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'25011_Volume-of-thalamus-left_2_0': 0},
)
field_id_25010_volume_of_brain_greywhite_matter_2_0 = TensorMap(
    '25010_Volume-of-brain-greywhite-matter_2_0',
    path_prefix='continuous', loss='logcosh', channel_map={
        '25010_Volume-of-brain-greywhite-matter_2_0': 0,
    },
)
field_id_25009_volume_of_brain_greywhite_matter_normalised_for_head_size_2_0 = TensorMap(
    '25009_Volume-of-brain-greywhite-matter-normalised-for-head-size_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25009_Volume-of-brain-greywhite-matter-normalised-for-head-size_2_0': 0},
)
field_id_25008_volume_of_white_matter_2_0 = TensorMap(
    '25008_Volume-of-white-matter_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'25008_Volume-of-white-matter_2_0': 0},
)
field_id_25007_volume_of_white_matter_normalised_for_head_size_2_0 = TensorMap(
    '25007_Volume-of-white-matter-normalised-for-head-size_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25007_Volume-of-white-matter-normalised-for-head-size_2_0': 0},
)
field_id_25006_volume_of_grey_matter_2_0 = TensorMap(
    '25006_Volume-of-grey-matter_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25006_Volume-of-grey-matter_2_0': 0},
)
field_id_25005_volume_of_grey_matter_normalised_for_head_size_2_0 = TensorMap(
    '25005_Volume-of-grey-matter-normalised-for-head-size_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25005_Volume-of-grey-matter-normalised-for-head-size_2_0': 0},
)
field_id_25004_volume_of_ventricular_cerebrospinal_fluid_2_0 = TensorMap(
    '25004_Volume-of-ventricular-cerebrospinal-fluid_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25004_Volume-of-ventricular-cerebrospinal-fluid_2_0': 0},
)
field_id_25003_volume_of_ventricular_cerebrospinal_fluid_normalised_for_head_size_2_0 = TensorMap(
    '25003_Volume-of-ventricular-cerebrospinal-fluid-normalised-for-head-size_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25003_Volume-of-ventricular-cerebrospinal-fluid-normalised-for-head-size_2_0': 0},
)
field_id_25002_volume_of_peripheral_cortical_grey_matter_2_0 = TensorMap(
    '25002_Volume-of-peripheral-cortical-grey-matter_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25002_Volume-of-peripheral-cortical-grey-matter_2_0': 0},
)
field_id_25001_volume_of_peripheral_cortical_grey_matter_normalised_for_head_size_2_0 = TensorMap(
    '25001_Volume-of-peripheral-cortical-grey-matter-normalised-for-head-size_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25001_Volume-of-peripheral-cortical-grey-matter-normalised-for-head-size_2_0': 0},
)
field_id_25000_volumetric_scaling_from_t1_head_image_to_standard_space_2_0 = TensorMap(
    '25000_Volumetric-scaling-from-T1-head-image-to-standard-space_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25000_Volumetric-scaling-from-T1-head-image-to-standard-space_2_0': 0},
)
field_id_12684_end_systolic_pressure_index_during_pwa_2_0 = TensorMap(
    '12684_End-systolic-pressure-index-during-PWA_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'12684_End-systolic-pressure-index-during-PWA_2_0': 0},
)
field_id_3456_number_of_cigarettes_currently_smoked_daily_current_cigarette_smokers_0_0 = TensorMap(
    '3456_Number-of-cigarettes-currently-smoked-daily-current-cigarette-smokers_0_0', path_prefix='continuous',
    loss='logcosh', channel_map={'3456_Number-of-cigarettes-currently-smoked-daily-current-cigarette-smokers_0_0': 0},
)
field_id_25781_total_volume_of_white_matter_hyperintensities_from_t1_and_t2flair_images_2_0 = TensorMap(
    '25781_Total-volume-of-white-matter-hyperintensities-from-T1-and-T2FLAIR-images_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'25781_Total-volume-of-white-matter-hyperintensities-from-T1-and-T2FLAIR-images_2_0': 0},
)
field_id_25739_discrepancy_between_rfmri_brain_image_and_t1_brain_image_2_0 = TensorMap(
    '25739_Discrepancy-between-rfMRI-brain-image-and-T1-brain-image_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25739_Discrepancy-between-rfMRI-brain-image-and-T1-brain-image_2_0': 0},
)
field_id_25737_discrepancy_between_dmri_brain_image_and_t1_brain_image_2_0 = TensorMap(
    '25737_Discrepancy-between-dMRI-brain-image-and-T1-brain-image_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25737_Discrepancy-between-dMRI-brain-image-and-T1-brain-image_2_0': 0},
)
field_id_25736_discrepancy_between_t2_flair_brain_image_and_t1_brain_image_2_0 = TensorMap(
    '25736_Discrepancy-between-T2-FLAIR-brain-image-and-T1-brain-image_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25736_Discrepancy-between-T2-FLAIR-brain-image-and-T1-brain-image_2_0': 0},
)
field_id_12686_stroke_volume_during_pwa_2_1 = TensorMap(
    '12686_Stroke-volume-during-PWA_2_1', path_prefix='continuous',
    loss='logcosh',
    channel_map={'12686_Stroke-volume-during-PWA_2_1': 0},
)
field_id_12682_cardiac_output_during_pwa_2_1 = TensorMap(
    '12682_Cardiac-output-during-PWA_2_1',
    path_prefix='continuous', loss='logcosh',
    channel_map={'12682_Cardiac-output-during-PWA_2_1': 0},
)
field_id_12702_cardiac_index_during_pwa_2_0 = TensorMap(
    '12702_Cardiac-index-during-PWA_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'12702_Cardiac-index-during-PWA_2_0': 0},
)
field_id_12684_end_systolic_pressure_index_during_pwa_2_1 = TensorMap(
    '12684_End-systolic-pressure-index-during-PWA_2_1', path_prefix='continuous', loss='logcosh',
    channel_map={'12684_End-systolic-pressure-index-during-PWA_2_1': 0},
)
field_id_87_noncancer_illness_yearage_first_occurred_2_0 = TensorMap(
    '87_Noncancer-illness-yearage-first-occurred_2_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '87_Noncancer-illness-yearage-first-occurred_2_0': 0,
    },
)
field_id_25730_weightedmean_isovf_in_tract_uncinate_fasciculus_right_2_0 = TensorMap(
    '25730_Weightedmean-ISOVF-in-tract-uncinate-fasciculus-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25730_Weightedmean-ISOVF-in-tract-uncinate-fasciculus-right_2_0': 0},
)
field_id_25729_weightedmean_isovf_in_tract_uncinate_fasciculus_left_2_0 = TensorMap(
    '25729_Weightedmean-ISOVF-in-tract-uncinate-fasciculus-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25729_Weightedmean-ISOVF-in-tract-uncinate-fasciculus-left_2_0': 0},
)
field_id_25728_weightedmean_isovf_in_tract_superior_thalamic_radiation_right_2_0 = TensorMap(
    '25728_Weightedmean-ISOVF-in-tract-superior-thalamic-radiation-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25728_Weightedmean-ISOVF-in-tract-superior-thalamic-radiation-right_2_0': 0},
)
field_id_25727_weightedmean_isovf_in_tract_superior_thalamic_radiation_left_2_0 = TensorMap(
    '25727_Weightedmean-ISOVF-in-tract-superior-thalamic-radiation-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25727_Weightedmean-ISOVF-in-tract-superior-thalamic-radiation-left_2_0': 0},
)
field_id_25726_weightedmean_isovf_in_tract_superior_longitudinal_fasciculus_right_2_0 = TensorMap(
    '25726_Weightedmean-ISOVF-in-tract-superior-longitudinal-fasciculus-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25726_Weightedmean-ISOVF-in-tract-superior-longitudinal-fasciculus-right_2_0': 0},
)
field_id_25725_weightedmean_isovf_in_tract_superior_longitudinal_fasciculus_left_2_0 = TensorMap(
    '25725_Weightedmean-ISOVF-in-tract-superior-longitudinal-fasciculus-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25725_Weightedmean-ISOVF-in-tract-superior-longitudinal-fasciculus-left_2_0': 0},
)
field_id_25724_weightedmean_isovf_in_tract_posterior_thalamic_radiation_right_2_0 = TensorMap(
    '25724_Weightedmean-ISOVF-in-tract-posterior-thalamic-radiation-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25724_Weightedmean-ISOVF-in-tract-posterior-thalamic-radiation-right_2_0': 0},
)
field_id_25723_weightedmean_isovf_in_tract_posterior_thalamic_radiation_left_2_0 = TensorMap(
    '25723_Weightedmean-ISOVF-in-tract-posterior-thalamic-radiation-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25723_Weightedmean-ISOVF-in-tract-posterior-thalamic-radiation-left_2_0': 0},
)
field_id_25722_weightedmean_isovf_in_tract_medial_lemniscus_right_2_0 = TensorMap(
    '25722_Weightedmean-ISOVF-in-tract-medial-lemniscus-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25722_Weightedmean-ISOVF-in-tract-medial-lemniscus-right_2_0': 0},
)
field_id_25721_weightedmean_isovf_in_tract_medial_lemniscus_left_2_0 = TensorMap(
    '25721_Weightedmean-ISOVF-in-tract-medial-lemniscus-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25721_Weightedmean-ISOVF-in-tract-medial-lemniscus-left_2_0': 0},
)
field_id_25720_weightedmean_isovf_in_tract_middle_cerebellar_peduncle_2_0 = TensorMap(
    '25720_Weightedmean-ISOVF-in-tract-middle-cerebellar-peduncle_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25720_Weightedmean-ISOVF-in-tract-middle-cerebellar-peduncle_2_0': 0},
)
field_id_25719_weightedmean_isovf_in_tract_inferior_longitudinal_fasciculus_right_2_0 = TensorMap(
    '25719_Weightedmean-ISOVF-in-tract-inferior-longitudinal-fasciculus-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25719_Weightedmean-ISOVF-in-tract-inferior-longitudinal-fasciculus-right_2_0': 0},
)
field_id_25718_weightedmean_isovf_in_tract_inferior_longitudinal_fasciculus_left_2_0 = TensorMap(
    '25718_Weightedmean-ISOVF-in-tract-inferior-longitudinal-fasciculus-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25718_Weightedmean-ISOVF-in-tract-inferior-longitudinal-fasciculus-left_2_0': 0},
)
field_id_25717_weightedmean_isovf_in_tract_inferior_frontooccipital_fasciculus_right_2_0 = TensorMap(
    '25717_Weightedmean-ISOVF-in-tract-inferior-frontooccipital-fasciculus-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25717_Weightedmean-ISOVF-in-tract-inferior-frontooccipital-fasciculus-right_2_0': 0},
)
field_id_25716_weightedmean_isovf_in_tract_inferior_frontooccipital_fasciculus_left_2_0 = TensorMap(
    '25716_Weightedmean-ISOVF-in-tract-inferior-frontooccipital-fasciculus-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25716_Weightedmean-ISOVF-in-tract-inferior-frontooccipital-fasciculus-left_2_0': 0},
)
field_id_25715_weightedmean_isovf_in_tract_forceps_minor_2_0 = TensorMap(
    '25715_Weightedmean-ISOVF-in-tract-forceps-minor_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25715_Weightedmean-ISOVF-in-tract-forceps-minor_2_0': 0},
)
field_id_25714_weightedmean_isovf_in_tract_forceps_major_2_0 = TensorMap(
    '25714_Weightedmean-ISOVF-in-tract-forceps-major_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25714_Weightedmean-ISOVF-in-tract-forceps-major_2_0': 0},
)
field_id_25713_weightedmean_isovf_in_tract_corticospinal_tract_right_2_0 = TensorMap(
    '25713_Weightedmean-ISOVF-in-tract-corticospinal-tract-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25713_Weightedmean-ISOVF-in-tract-corticospinal-tract-right_2_0': 0},
)
field_id_25712_weightedmean_isovf_in_tract_corticospinal_tract_left_2_0 = TensorMap(
    '25712_Weightedmean-ISOVF-in-tract-corticospinal-tract-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25712_Weightedmean-ISOVF-in-tract-corticospinal-tract-left_2_0': 0},
)
field_id_25711_weightedmean_isovf_in_tract_parahippocampal_part_of_cingulum_right_2_0 = TensorMap(
    '25711_Weightedmean-ISOVF-in-tract-parahippocampal-part-of-cingulum-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25711_Weightedmean-ISOVF-in-tract-parahippocampal-part-of-cingulum-right_2_0': 0},
)
field_id_25710_weightedmean_isovf_in_tract_parahippocampal_part_of_cingulum_left_2_0 = TensorMap(
    '25710_Weightedmean-ISOVF-in-tract-parahippocampal-part-of-cingulum-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25710_Weightedmean-ISOVF-in-tract-parahippocampal-part-of-cingulum-left_2_0': 0},
)
field_id_25709_weightedmean_isovf_in_tract_cingulate_gyrus_part_of_cingulum_right_2_0 = TensorMap(
    '25709_Weightedmean-ISOVF-in-tract-cingulate-gyrus-part-of-cingulum-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25709_Weightedmean-ISOVF-in-tract-cingulate-gyrus-part-of-cingulum-right_2_0': 0},
)
field_id_25708_weightedmean_isovf_in_tract_cingulate_gyrus_part_of_cingulum_left_2_0 = TensorMap(
    '25708_Weightedmean-ISOVF-in-tract-cingulate-gyrus-part-of-cingulum-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25708_Weightedmean-ISOVF-in-tract-cingulate-gyrus-part-of-cingulum-left_2_0': 0},
)
field_id_25707_weightedmean_isovf_in_tract_anterior_thalamic_radiation_right_2_0 = TensorMap(
    '25707_Weightedmean-ISOVF-in-tract-anterior-thalamic-radiation-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25707_Weightedmean-ISOVF-in-tract-anterior-thalamic-radiation-right_2_0': 0},
)
field_id_25706_weightedmean_isovf_in_tract_anterior_thalamic_radiation_left_2_0 = TensorMap(
    '25706_Weightedmean-ISOVF-in-tract-anterior-thalamic-radiation-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25706_Weightedmean-ISOVF-in-tract-anterior-thalamic-radiation-left_2_0': 0},
)
field_id_25705_weightedmean_isovf_in_tract_acoustic_radiation_right_2_0 = TensorMap(
    '25705_Weightedmean-ISOVF-in-tract-acoustic-radiation-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25705_Weightedmean-ISOVF-in-tract-acoustic-radiation-right_2_0': 0},
)
field_id_25704_weightedmean_isovf_in_tract_acoustic_radiation_left_2_0 = TensorMap(
    '25704_Weightedmean-ISOVF-in-tract-acoustic-radiation-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25704_Weightedmean-ISOVF-in-tract-acoustic-radiation-left_2_0': 0},
)
field_id_25703_weightedmean_od_in_tract_uncinate_fasciculus_right_2_0 = TensorMap(
    '25703_Weightedmean-OD-in-tract-uncinate-fasciculus-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25703_Weightedmean-OD-in-tract-uncinate-fasciculus-right_2_0': 0},
)
field_id_25702_weightedmean_od_in_tract_uncinate_fasciculus_left_2_0 = TensorMap(
    '25702_Weightedmean-OD-in-tract-uncinate-fasciculus-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25702_Weightedmean-OD-in-tract-uncinate-fasciculus-left_2_0': 0},
)
field_id_25701_weightedmean_od_in_tract_superior_thalamic_radiation_right_2_0 = TensorMap(
    '25701_Weightedmean-OD-in-tract-superior-thalamic-radiation-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25701_Weightedmean-OD-in-tract-superior-thalamic-radiation-right_2_0': 0},
)
field_id_25700_weightedmean_od_in_tract_superior_thalamic_radiation_left_2_0 = TensorMap(
    '25700_Weightedmean-OD-in-tract-superior-thalamic-radiation-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25700_Weightedmean-OD-in-tract-superior-thalamic-radiation-left_2_0': 0},
)
field_id_25699_weightedmean_od_in_tract_superior_longitudinal_fasciculus_right_2_0 = TensorMap(
    '25699_Weightedmean-OD-in-tract-superior-longitudinal-fasciculus-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25699_Weightedmean-OD-in-tract-superior-longitudinal-fasciculus-right_2_0': 0},
)
field_id_25698_weightedmean_od_in_tract_superior_longitudinal_fasciculus_left_2_0 = TensorMap(
    '25698_Weightedmean-OD-in-tract-superior-longitudinal-fasciculus-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25698_Weightedmean-OD-in-tract-superior-longitudinal-fasciculus-left_2_0': 0},
)
field_id_25697_weightedmean_od_in_tract_posterior_thalamic_radiation_right_2_0 = TensorMap(
    '25697_Weightedmean-OD-in-tract-posterior-thalamic-radiation-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25697_Weightedmean-OD-in-tract-posterior-thalamic-radiation-right_2_0': 0},
)
field_id_25696_weightedmean_od_in_tract_posterior_thalamic_radiation_left_2_0 = TensorMap(
    '25696_Weightedmean-OD-in-tract-posterior-thalamic-radiation-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25696_Weightedmean-OD-in-tract-posterior-thalamic-radiation-left_2_0': 0},
)
field_id_25695_weightedmean_od_in_tract_medial_lemniscus_right_2_0 = TensorMap(
    '25695_Weightedmean-OD-in-tract-medial-lemniscus-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25695_Weightedmean-OD-in-tract-medial-lemniscus-right_2_0': 0},
)
field_id_25694_weightedmean_od_in_tract_medial_lemniscus_left_2_0 = TensorMap(
    '25694_Weightedmean-OD-in-tract-medial-lemniscus-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25694_Weightedmean-OD-in-tract-medial-lemniscus-left_2_0': 0},
)
field_id_25693_weightedmean_od_in_tract_middle_cerebellar_peduncle_2_0 = TensorMap(
    '25693_Weightedmean-OD-in-tract-middle-cerebellar-peduncle_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25693_Weightedmean-OD-in-tract-middle-cerebellar-peduncle_2_0': 0},
)
field_id_25692_weightedmean_od_in_tract_inferior_longitudinal_fasciculus_right_2_0 = TensorMap(
    '25692_Weightedmean-OD-in-tract-inferior-longitudinal-fasciculus-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25692_Weightedmean-OD-in-tract-inferior-longitudinal-fasciculus-right_2_0': 0},
)
field_id_25691_weightedmean_od_in_tract_inferior_longitudinal_fasciculus_left_2_0 = TensorMap(
    '25691_Weightedmean-OD-in-tract-inferior-longitudinal-fasciculus-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25691_Weightedmean-OD-in-tract-inferior-longitudinal-fasciculus-left_2_0': 0},
)
field_id_25690_weightedmean_od_in_tract_inferior_frontooccipital_fasciculus_right_2_0 = TensorMap(
    '25690_Weightedmean-OD-in-tract-inferior-frontooccipital-fasciculus-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25690_Weightedmean-OD-in-tract-inferior-frontooccipital-fasciculus-right_2_0': 0},
)
field_id_25689_weightedmean_od_in_tract_inferior_frontooccipital_fasciculus_left_2_0 = TensorMap(
    '25689_Weightedmean-OD-in-tract-inferior-frontooccipital-fasciculus-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25689_Weightedmean-OD-in-tract-inferior-frontooccipital-fasciculus-left_2_0': 0},
)
field_id_25688_weightedmean_od_in_tract_forceps_minor_2_0 = TensorMap(
    '25688_Weightedmean-OD-in-tract-forceps-minor_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25688_Weightedmean-OD-in-tract-forceps-minor_2_0': 0},
)
field_id_25687_weightedmean_od_in_tract_forceps_major_2_0 = TensorMap(
    '25687_Weightedmean-OD-in-tract-forceps-major_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25687_Weightedmean-OD-in-tract-forceps-major_2_0': 0},
)
field_id_25686_weightedmean_od_in_tract_corticospinal_tract_right_2_0 = TensorMap(
    '25686_Weightedmean-OD-in-tract-corticospinal-tract-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25686_Weightedmean-OD-in-tract-corticospinal-tract-right_2_0': 0},
)
field_id_25685_weightedmean_od_in_tract_corticospinal_tract_left_2_0 = TensorMap(
    '25685_Weightedmean-OD-in-tract-corticospinal-tract-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25685_Weightedmean-OD-in-tract-corticospinal-tract-left_2_0': 0},
)
field_id_25684_weightedmean_od_in_tract_parahippocampal_part_of_cingulum_right_2_0 = TensorMap(
    '25684_Weightedmean-OD-in-tract-parahippocampal-part-of-cingulum-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25684_Weightedmean-OD-in-tract-parahippocampal-part-of-cingulum-right_2_0': 0},
)
field_id_25683_weightedmean_od_in_tract_parahippocampal_part_of_cingulum_left_2_0 = TensorMap(
    '25683_Weightedmean-OD-in-tract-parahippocampal-part-of-cingulum-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25683_Weightedmean-OD-in-tract-parahippocampal-part-of-cingulum-left_2_0': 0},
)
field_id_25682_weightedmean_od_in_tract_cingulate_gyrus_part_of_cingulum_right_2_0 = TensorMap(
    '25682_Weightedmean-OD-in-tract-cingulate-gyrus-part-of-cingulum-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25682_Weightedmean-OD-in-tract-cingulate-gyrus-part-of-cingulum-right_2_0': 0},
)
field_id_25681_weightedmean_od_in_tract_cingulate_gyrus_part_of_cingulum_left_2_0 = TensorMap(
    '25681_Weightedmean-OD-in-tract-cingulate-gyrus-part-of-cingulum-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25681_Weightedmean-OD-in-tract-cingulate-gyrus-part-of-cingulum-left_2_0': 0},
)
field_id_25680_weightedmean_od_in_tract_anterior_thalamic_radiation_right_2_0 = TensorMap(
    '25680_Weightedmean-OD-in-tract-anterior-thalamic-radiation-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25680_Weightedmean-OD-in-tract-anterior-thalamic-radiation-right_2_0': 0},
)
field_id_25679_weightedmean_od_in_tract_anterior_thalamic_radiation_left_2_0 = TensorMap(
    '25679_Weightedmean-OD-in-tract-anterior-thalamic-radiation-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25679_Weightedmean-OD-in-tract-anterior-thalamic-radiation-left_2_0': 0},
)
field_id_25678_weightedmean_od_in_tract_acoustic_radiation_right_2_0 = TensorMap(
    '25678_Weightedmean-OD-in-tract-acoustic-radiation-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25678_Weightedmean-OD-in-tract-acoustic-radiation-right_2_0': 0},
)
field_id_25677_weightedmean_od_in_tract_acoustic_radiation_left_2_0 = TensorMap(
    '25677_Weightedmean-OD-in-tract-acoustic-radiation-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25677_Weightedmean-OD-in-tract-acoustic-radiation-left_2_0': 0},
)
field_id_25676_weightedmean_icvf_in_tract_uncinate_fasciculus_right_2_0 = TensorMap(
    '25676_Weightedmean-ICVF-in-tract-uncinate-fasciculus-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25676_Weightedmean-ICVF-in-tract-uncinate-fasciculus-right_2_0': 0},
)
field_id_25675_weightedmean_icvf_in_tract_uncinate_fasciculus_left_2_0 = TensorMap(
    '25675_Weightedmean-ICVF-in-tract-uncinate-fasciculus-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25675_Weightedmean-ICVF-in-tract-uncinate-fasciculus-left_2_0': 0},
)
field_id_25674_weightedmean_icvf_in_tract_superior_thalamic_radiation_right_2_0 = TensorMap(
    '25674_Weightedmean-ICVF-in-tract-superior-thalamic-radiation-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25674_Weightedmean-ICVF-in-tract-superior-thalamic-radiation-right_2_0': 0},
)
field_id_25673_weightedmean_icvf_in_tract_superior_thalamic_radiation_left_2_0 = TensorMap(
    '25673_Weightedmean-ICVF-in-tract-superior-thalamic-radiation-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25673_Weightedmean-ICVF-in-tract-superior-thalamic-radiation-left_2_0': 0},
)
field_id_25672_weightedmean_icvf_in_tract_superior_longitudinal_fasciculus_right_2_0 = TensorMap(
    '25672_Weightedmean-ICVF-in-tract-superior-longitudinal-fasciculus-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25672_Weightedmean-ICVF-in-tract-superior-longitudinal-fasciculus-right_2_0': 0},
)
field_id_25671_weightedmean_icvf_in_tract_superior_longitudinal_fasciculus_left_2_0 = TensorMap(
    '25671_Weightedmean-ICVF-in-tract-superior-longitudinal-fasciculus-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25671_Weightedmean-ICVF-in-tract-superior-longitudinal-fasciculus-left_2_0': 0},
)
field_id_25670_weightedmean_icvf_in_tract_posterior_thalamic_radiation_right_2_0 = TensorMap(
    '25670_Weightedmean-ICVF-in-tract-posterior-thalamic-radiation-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25670_Weightedmean-ICVF-in-tract-posterior-thalamic-radiation-right_2_0': 0},
)
field_id_25669_weightedmean_icvf_in_tract_posterior_thalamic_radiation_left_2_0 = TensorMap(
    '25669_Weightedmean-ICVF-in-tract-posterior-thalamic-radiation-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25669_Weightedmean-ICVF-in-tract-posterior-thalamic-radiation-left_2_0': 0},
)
field_id_25668_weightedmean_icvf_in_tract_medial_lemniscus_right_2_0 = TensorMap(
    '25668_Weightedmean-ICVF-in-tract-medial-lemniscus-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25668_Weightedmean-ICVF-in-tract-medial-lemniscus-right_2_0': 0},
)
field_id_25667_weightedmean_icvf_in_tract_medial_lemniscus_left_2_0 = TensorMap(
    '25667_Weightedmean-ICVF-in-tract-medial-lemniscus-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25667_Weightedmean-ICVF-in-tract-medial-lemniscus-left_2_0': 0},
)
field_id_25666_weightedmean_icvf_in_tract_middle_cerebellar_peduncle_2_0 = TensorMap(
    '25666_Weightedmean-ICVF-in-tract-middle-cerebellar-peduncle_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25666_Weightedmean-ICVF-in-tract-middle-cerebellar-peduncle_2_0': 0},
)
field_id_25665_weightedmean_icvf_in_tract_inferior_longitudinal_fasciculus_right_2_0 = TensorMap(
    '25665_Weightedmean-ICVF-in-tract-inferior-longitudinal-fasciculus-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25665_Weightedmean-ICVF-in-tract-inferior-longitudinal-fasciculus-right_2_0': 0},
)
field_id_25664_weightedmean_icvf_in_tract_inferior_longitudinal_fasciculus_left_2_0 = TensorMap(
    '25664_Weightedmean-ICVF-in-tract-inferior-longitudinal-fasciculus-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25664_Weightedmean-ICVF-in-tract-inferior-longitudinal-fasciculus-left_2_0': 0},
)
field_id_25663_weightedmean_icvf_in_tract_inferior_frontooccipital_fasciculus_right_2_0 = TensorMap(
    '25663_Weightedmean-ICVF-in-tract-inferior-frontooccipital-fasciculus-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25663_Weightedmean-ICVF-in-tract-inferior-frontooccipital-fasciculus-right_2_0': 0},
)
field_id_25662_weightedmean_icvf_in_tract_inferior_frontooccipital_fasciculus_left_2_0 = TensorMap(
    '25662_Weightedmean-ICVF-in-tract-inferior-frontooccipital-fasciculus-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25662_Weightedmean-ICVF-in-tract-inferior-frontooccipital-fasciculus-left_2_0': 0},
)
field_id_25661_weightedmean_icvf_in_tract_forceps_minor_2_0 = TensorMap(
    '25661_Weightedmean-ICVF-in-tract-forceps-minor_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25661_Weightedmean-ICVF-in-tract-forceps-minor_2_0': 0},
)
field_id_25660_weightedmean_icvf_in_tract_forceps_major_2_0 = TensorMap(
    '25660_Weightedmean-ICVF-in-tract-forceps-major_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25660_Weightedmean-ICVF-in-tract-forceps-major_2_0': 0},
)
field_id_25659_weightedmean_icvf_in_tract_corticospinal_tract_right_2_0 = TensorMap(
    '25659_Weightedmean-ICVF-in-tract-corticospinal-tract-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25659_Weightedmean-ICVF-in-tract-corticospinal-tract-right_2_0': 0},
)
field_id_25658_weightedmean_icvf_in_tract_corticospinal_tract_left_2_0 = TensorMap(
    '25658_Weightedmean-ICVF-in-tract-corticospinal-tract-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25658_Weightedmean-ICVF-in-tract-corticospinal-tract-left_2_0': 0},
)
field_id_25657_weightedmean_icvf_in_tract_parahippocampal_part_of_cingulum_right_2_0 = TensorMap(
    '25657_Weightedmean-ICVF-in-tract-parahippocampal-part-of-cingulum-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25657_Weightedmean-ICVF-in-tract-parahippocampal-part-of-cingulum-right_2_0': 0},
)
field_id_25656_weightedmean_icvf_in_tract_parahippocampal_part_of_cingulum_left_2_0 = TensorMap(
    '25656_Weightedmean-ICVF-in-tract-parahippocampal-part-of-cingulum-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25656_Weightedmean-ICVF-in-tract-parahippocampal-part-of-cingulum-left_2_0': 0},
)
field_id_25655_weightedmean_icvf_in_tract_cingulate_gyrus_part_of_cingulum_right_2_0 = TensorMap(
    '25655_Weightedmean-ICVF-in-tract-cingulate-gyrus-part-of-cingulum-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25655_Weightedmean-ICVF-in-tract-cingulate-gyrus-part-of-cingulum-right_2_0': 0},
)
field_id_25654_weightedmean_icvf_in_tract_cingulate_gyrus_part_of_cingulum_left_2_0 = TensorMap(
    '25654_Weightedmean-ICVF-in-tract-cingulate-gyrus-part-of-cingulum-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25654_Weightedmean-ICVF-in-tract-cingulate-gyrus-part-of-cingulum-left_2_0': 0},
)
field_id_25653_weightedmean_icvf_in_tract_anterior_thalamic_radiation_right_2_0 = TensorMap(
    '25653_Weightedmean-ICVF-in-tract-anterior-thalamic-radiation-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25653_Weightedmean-ICVF-in-tract-anterior-thalamic-radiation-right_2_0': 0},
)
field_id_25652_weightedmean_icvf_in_tract_anterior_thalamic_radiation_left_2_0 = TensorMap(
    '25652_Weightedmean-ICVF-in-tract-anterior-thalamic-radiation-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25652_Weightedmean-ICVF-in-tract-anterior-thalamic-radiation-left_2_0': 0},
)
field_id_25651_weightedmean_icvf_in_tract_acoustic_radiation_right_2_0 = TensorMap(
    '25651_Weightedmean-ICVF-in-tract-acoustic-radiation-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25651_Weightedmean-ICVF-in-tract-acoustic-radiation-right_2_0': 0},
)
field_id_25650_weightedmean_icvf_in_tract_acoustic_radiation_left_2_0 = TensorMap(
    '25650_Weightedmean-ICVF-in-tract-acoustic-radiation-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25650_Weightedmean-ICVF-in-tract-acoustic-radiation-left_2_0': 0},
)
field_id_25649_weightedmean_l3_in_tract_uncinate_fasciculus_right_2_0 = TensorMap(
    '25649_Weightedmean-L3-in-tract-uncinate-fasciculus-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25649_Weightedmean-L3-in-tract-uncinate-fasciculus-right_2_0': 0},
)
field_id_25648_weightedmean_l3_in_tract_uncinate_fasciculus_left_2_0 = TensorMap(
    '25648_Weightedmean-L3-in-tract-uncinate-fasciculus-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25648_Weightedmean-L3-in-tract-uncinate-fasciculus-left_2_0': 0},
)
field_id_25647_weightedmean_l3_in_tract_superior_thalamic_radiation_right_2_0 = TensorMap(
    '25647_Weightedmean-L3-in-tract-superior-thalamic-radiation-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25647_Weightedmean-L3-in-tract-superior-thalamic-radiation-right_2_0': 0},
)
field_id_25646_weightedmean_l3_in_tract_superior_thalamic_radiation_left_2_0 = TensorMap(
    '25646_Weightedmean-L3-in-tract-superior-thalamic-radiation-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25646_Weightedmean-L3-in-tract-superior-thalamic-radiation-left_2_0': 0},
)
field_id_25645_weightedmean_l3_in_tract_superior_longitudinal_fasciculus_right_2_0 = TensorMap(
    '25645_Weightedmean-L3-in-tract-superior-longitudinal-fasciculus-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25645_Weightedmean-L3-in-tract-superior-longitudinal-fasciculus-right_2_0': 0},
)
field_id_25644_weightedmean_l3_in_tract_superior_longitudinal_fasciculus_left_2_0 = TensorMap(
    '25644_Weightedmean-L3-in-tract-superior-longitudinal-fasciculus-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25644_Weightedmean-L3-in-tract-superior-longitudinal-fasciculus-left_2_0': 0},
)
field_id_25643_weightedmean_l3_in_tract_posterior_thalamic_radiation_right_2_0 = TensorMap(
    '25643_Weightedmean-L3-in-tract-posterior-thalamic-radiation-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25643_Weightedmean-L3-in-tract-posterior-thalamic-radiation-right_2_0': 0},
)
field_id_25642_weightedmean_l3_in_tract_posterior_thalamic_radiation_left_2_0 = TensorMap(
    '25642_Weightedmean-L3-in-tract-posterior-thalamic-radiation-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25642_Weightedmean-L3-in-tract-posterior-thalamic-radiation-left_2_0': 0},
)
field_id_25641_weightedmean_l3_in_tract_medial_lemniscus_right_2_0 = TensorMap(
    '25641_Weightedmean-L3-in-tract-medial-lemniscus-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25641_Weightedmean-L3-in-tract-medial-lemniscus-right_2_0': 0},
)
field_id_25640_weightedmean_l3_in_tract_medial_lemniscus_left_2_0 = TensorMap(
    '25640_Weightedmean-L3-in-tract-medial-lemniscus-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25640_Weightedmean-L3-in-tract-medial-lemniscus-left_2_0': 0},
)
field_id_25639_weightedmean_l3_in_tract_middle_cerebellar_peduncle_2_0 = TensorMap(
    '25639_Weightedmean-L3-in-tract-middle-cerebellar-peduncle_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25639_Weightedmean-L3-in-tract-middle-cerebellar-peduncle_2_0': 0},
)
field_id_25638_weightedmean_l3_in_tract_inferior_longitudinal_fasciculus_right_2_0 = TensorMap(
    '25638_Weightedmean-L3-in-tract-inferior-longitudinal-fasciculus-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25638_Weightedmean-L3-in-tract-inferior-longitudinal-fasciculus-right_2_0': 0},
)
field_id_25637_weightedmean_l3_in_tract_inferior_longitudinal_fasciculus_left_2_0 = TensorMap(
    '25637_Weightedmean-L3-in-tract-inferior-longitudinal-fasciculus-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25637_Weightedmean-L3-in-tract-inferior-longitudinal-fasciculus-left_2_0': 0},
)
field_id_25636_weightedmean_l3_in_tract_inferior_frontooccipital_fasciculus_right_2_0 = TensorMap(
    '25636_Weightedmean-L3-in-tract-inferior-frontooccipital-fasciculus-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25636_Weightedmean-L3-in-tract-inferior-frontooccipital-fasciculus-right_2_0': 0},
)
field_id_25635_weightedmean_l3_in_tract_inferior_frontooccipital_fasciculus_left_2_0 = TensorMap(
    '25635_Weightedmean-L3-in-tract-inferior-frontooccipital-fasciculus-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25635_Weightedmean-L3-in-tract-inferior-frontooccipital-fasciculus-left_2_0': 0},
)
field_id_25634_weightedmean_l3_in_tract_forceps_minor_2_0 = TensorMap(
    '25634_Weightedmean-L3-in-tract-forceps-minor_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25634_Weightedmean-L3-in-tract-forceps-minor_2_0': 0},
)
field_id_25633_weightedmean_l3_in_tract_forceps_major_2_0 = TensorMap(
    '25633_Weightedmean-L3-in-tract-forceps-major_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25633_Weightedmean-L3-in-tract-forceps-major_2_0': 0},
)
field_id_25632_weightedmean_l3_in_tract_corticospinal_tract_right_2_0 = TensorMap(
    '25632_Weightedmean-L3-in-tract-corticospinal-tract-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25632_Weightedmean-L3-in-tract-corticospinal-tract-right_2_0': 0},
)
field_id_25631_weightedmean_l3_in_tract_corticospinal_tract_left_2_0 = TensorMap(
    '25631_Weightedmean-L3-in-tract-corticospinal-tract-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25631_Weightedmean-L3-in-tract-corticospinal-tract-left_2_0': 0},
)
field_id_25630_weightedmean_l3_in_tract_parahippocampal_part_of_cingulum_right_2_0 = TensorMap(
    '25630_Weightedmean-L3-in-tract-parahippocampal-part-of-cingulum-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25630_Weightedmean-L3-in-tract-parahippocampal-part-of-cingulum-right_2_0': 0},
)
field_id_25629_weightedmean_l3_in_tract_parahippocampal_part_of_cingulum_left_2_0 = TensorMap(
    '25629_Weightedmean-L3-in-tract-parahippocampal-part-of-cingulum-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25629_Weightedmean-L3-in-tract-parahippocampal-part-of-cingulum-left_2_0': 0},
)
field_id_25628_weightedmean_l3_in_tract_cingulate_gyrus_part_of_cingulum_right_2_0 = TensorMap(
    '25628_Weightedmean-L3-in-tract-cingulate-gyrus-part-of-cingulum-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25628_Weightedmean-L3-in-tract-cingulate-gyrus-part-of-cingulum-right_2_0': 0},
)
field_id_25627_weightedmean_l3_in_tract_cingulate_gyrus_part_of_cingulum_left_2_0 = TensorMap(
    '25627_Weightedmean-L3-in-tract-cingulate-gyrus-part-of-cingulum-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25627_Weightedmean-L3-in-tract-cingulate-gyrus-part-of-cingulum-left_2_0': 0},
)
field_id_25626_weightedmean_l3_in_tract_anterior_thalamic_radiation_right_2_0 = TensorMap(
    '25626_Weightedmean-L3-in-tract-anterior-thalamic-radiation-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25626_Weightedmean-L3-in-tract-anterior-thalamic-radiation-right_2_0': 0},
)
field_id_25625_weightedmean_l3_in_tract_anterior_thalamic_radiation_left_2_0 = TensorMap(
    '25625_Weightedmean-L3-in-tract-anterior-thalamic-radiation-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25625_Weightedmean-L3-in-tract-anterior-thalamic-radiation-left_2_0': 0},
)
field_id_25624_weightedmean_l3_in_tract_acoustic_radiation_right_2_0 = TensorMap(
    '25624_Weightedmean-L3-in-tract-acoustic-radiation-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25624_Weightedmean-L3-in-tract-acoustic-radiation-right_2_0': 0},
)
field_id_25623_weightedmean_l3_in_tract_acoustic_radiation_left_2_0 = TensorMap(
    '25623_Weightedmean-L3-in-tract-acoustic-radiation-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25623_Weightedmean-L3-in-tract-acoustic-radiation-left_2_0': 0},
)
field_id_25622_weightedmean_l2_in_tract_uncinate_fasciculus_right_2_0 = TensorMap(
    '25622_Weightedmean-L2-in-tract-uncinate-fasciculus-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25622_Weightedmean-L2-in-tract-uncinate-fasciculus-right_2_0': 0},
)
field_id_25621_weightedmean_l2_in_tract_uncinate_fasciculus_left_2_0 = TensorMap(
    '25621_Weightedmean-L2-in-tract-uncinate-fasciculus-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25621_Weightedmean-L2-in-tract-uncinate-fasciculus-left_2_0': 0},
)
field_id_25620_weightedmean_l2_in_tract_superior_thalamic_radiation_right_2_0 = TensorMap(
    '25620_Weightedmean-L2-in-tract-superior-thalamic-radiation-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25620_Weightedmean-L2-in-tract-superior-thalamic-radiation-right_2_0': 0},
)
field_id_25619_weightedmean_l2_in_tract_superior_thalamic_radiation_left_2_0 = TensorMap(
    '25619_Weightedmean-L2-in-tract-superior-thalamic-radiation-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25619_Weightedmean-L2-in-tract-superior-thalamic-radiation-left_2_0': 0},
)
field_id_25618_weightedmean_l2_in_tract_superior_longitudinal_fasciculus_right_2_0 = TensorMap(
    '25618_Weightedmean-L2-in-tract-superior-longitudinal-fasciculus-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25618_Weightedmean-L2-in-tract-superior-longitudinal-fasciculus-right_2_0': 0},
)
field_id_25617_weightedmean_l2_in_tract_superior_longitudinal_fasciculus_left_2_0 = TensorMap(
    '25617_Weightedmean-L2-in-tract-superior-longitudinal-fasciculus-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25617_Weightedmean-L2-in-tract-superior-longitudinal-fasciculus-left_2_0': 0},
)
field_id_25616_weightedmean_l2_in_tract_posterior_thalamic_radiation_right_2_0 = TensorMap(
    '25616_Weightedmean-L2-in-tract-posterior-thalamic-radiation-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25616_Weightedmean-L2-in-tract-posterior-thalamic-radiation-right_2_0': 0},
)
field_id_25615_weightedmean_l2_in_tract_posterior_thalamic_radiation_left_2_0 = TensorMap(
    '25615_Weightedmean-L2-in-tract-posterior-thalamic-radiation-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25615_Weightedmean-L2-in-tract-posterior-thalamic-radiation-left_2_0': 0},
)
field_id_25614_weightedmean_l2_in_tract_medial_lemniscus_right_2_0 = TensorMap(
    '25614_Weightedmean-L2-in-tract-medial-lemniscus-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25614_Weightedmean-L2-in-tract-medial-lemniscus-right_2_0': 0},
)
field_id_25613_weightedmean_l2_in_tract_medial_lemniscus_left_2_0 = TensorMap(
    '25613_Weightedmean-L2-in-tract-medial-lemniscus-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25613_Weightedmean-L2-in-tract-medial-lemniscus-left_2_0': 0},
)
field_id_25612_weightedmean_l2_in_tract_middle_cerebellar_peduncle_2_0 = TensorMap(
    '25612_Weightedmean-L2-in-tract-middle-cerebellar-peduncle_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25612_Weightedmean-L2-in-tract-middle-cerebellar-peduncle_2_0': 0},
)
field_id_25611_weightedmean_l2_in_tract_inferior_longitudinal_fasciculus_right_2_0 = TensorMap(
    '25611_Weightedmean-L2-in-tract-inferior-longitudinal-fasciculus-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25611_Weightedmean-L2-in-tract-inferior-longitudinal-fasciculus-right_2_0': 0},
)
field_id_25610_weightedmean_l2_in_tract_inferior_longitudinal_fasciculus_left_2_0 = TensorMap(
    '25610_Weightedmean-L2-in-tract-inferior-longitudinal-fasciculus-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25610_Weightedmean-L2-in-tract-inferior-longitudinal-fasciculus-left_2_0': 0},
)
field_id_25609_weightedmean_l2_in_tract_inferior_frontooccipital_fasciculus_right_2_0 = TensorMap(
    '25609_Weightedmean-L2-in-tract-inferior-frontooccipital-fasciculus-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25609_Weightedmean-L2-in-tract-inferior-frontooccipital-fasciculus-right_2_0': 0},
)
field_id_25608_weightedmean_l2_in_tract_inferior_frontooccipital_fasciculus_left_2_0 = TensorMap(
    '25608_Weightedmean-L2-in-tract-inferior-frontooccipital-fasciculus-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25608_Weightedmean-L2-in-tract-inferior-frontooccipital-fasciculus-left_2_0': 0},
)
field_id_25607_weightedmean_l2_in_tract_forceps_minor_2_0 = TensorMap(
    '25607_Weightedmean-L2-in-tract-forceps-minor_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25607_Weightedmean-L2-in-tract-forceps-minor_2_0': 0},
)
field_id_25606_weightedmean_l2_in_tract_forceps_major_2_0 = TensorMap(
    '25606_Weightedmean-L2-in-tract-forceps-major_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25606_Weightedmean-L2-in-tract-forceps-major_2_0': 0},
)
field_id_25605_weightedmean_l2_in_tract_corticospinal_tract_right_2_0 = TensorMap(
    '25605_Weightedmean-L2-in-tract-corticospinal-tract-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25605_Weightedmean-L2-in-tract-corticospinal-tract-right_2_0': 0},
)
field_id_25604_weightedmean_l2_in_tract_corticospinal_tract_left_2_0 = TensorMap(
    '25604_Weightedmean-L2-in-tract-corticospinal-tract-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25604_Weightedmean-L2-in-tract-corticospinal-tract-left_2_0': 0},
)
field_id_25603_weightedmean_l2_in_tract_parahippocampal_part_of_cingulum_right_2_0 = TensorMap(
    '25603_Weightedmean-L2-in-tract-parahippocampal-part-of-cingulum-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25603_Weightedmean-L2-in-tract-parahippocampal-part-of-cingulum-right_2_0': 0},
)
field_id_25602_weightedmean_l2_in_tract_parahippocampal_part_of_cingulum_left_2_0 = TensorMap(
    '25602_Weightedmean-L2-in-tract-parahippocampal-part-of-cingulum-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25602_Weightedmean-L2-in-tract-parahippocampal-part-of-cingulum-left_2_0': 0},
)
field_id_25601_weightedmean_l2_in_tract_cingulate_gyrus_part_of_cingulum_right_2_0 = TensorMap(
    '25601_Weightedmean-L2-in-tract-cingulate-gyrus-part-of-cingulum-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25601_Weightedmean-L2-in-tract-cingulate-gyrus-part-of-cingulum-right_2_0': 0},
)
field_id_25600_weightedmean_l2_in_tract_cingulate_gyrus_part_of_cingulum_left_2_0 = TensorMap(
    '25600_Weightedmean-L2-in-tract-cingulate-gyrus-part-of-cingulum-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25600_Weightedmean-L2-in-tract-cingulate-gyrus-part-of-cingulum-left_2_0': 0},
)
field_id_25599_weightedmean_l2_in_tract_anterior_thalamic_radiation_right_2_0 = TensorMap(
    '25599_Weightedmean-L2-in-tract-anterior-thalamic-radiation-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25599_Weightedmean-L2-in-tract-anterior-thalamic-radiation-right_2_0': 0},
)
field_id_25598_weightedmean_l2_in_tract_anterior_thalamic_radiation_left_2_0 = TensorMap(
    '25598_Weightedmean-L2-in-tract-anterior-thalamic-radiation-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25598_Weightedmean-L2-in-tract-anterior-thalamic-radiation-left_2_0': 0},
)
field_id_25597_weightedmean_l2_in_tract_acoustic_radiation_right_2_0 = TensorMap(
    '25597_Weightedmean-L2-in-tract-acoustic-radiation-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25597_Weightedmean-L2-in-tract-acoustic-radiation-right_2_0': 0},
)
field_id_25596_weightedmean_l2_in_tract_acoustic_radiation_left_2_0 = TensorMap(
    '25596_Weightedmean-L2-in-tract-acoustic-radiation-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25596_Weightedmean-L2-in-tract-acoustic-radiation-left_2_0': 0},
)
field_id_25595_weightedmean_l1_in_tract_uncinate_fasciculus_right_2_0 = TensorMap(
    '25595_Weightedmean-L1-in-tract-uncinate-fasciculus-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25595_Weightedmean-L1-in-tract-uncinate-fasciculus-right_2_0': 0},
)
field_id_25594_weightedmean_l1_in_tract_uncinate_fasciculus_left_2_0 = TensorMap(
    '25594_Weightedmean-L1-in-tract-uncinate-fasciculus-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25594_Weightedmean-L1-in-tract-uncinate-fasciculus-left_2_0': 0},
)
field_id_25593_weightedmean_l1_in_tract_superior_thalamic_radiation_right_2_0 = TensorMap(
    '25593_Weightedmean-L1-in-tract-superior-thalamic-radiation-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25593_Weightedmean-L1-in-tract-superior-thalamic-radiation-right_2_0': 0},
)
field_id_25592_weightedmean_l1_in_tract_superior_thalamic_radiation_left_2_0 = TensorMap(
    '25592_Weightedmean-L1-in-tract-superior-thalamic-radiation-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25592_Weightedmean-L1-in-tract-superior-thalamic-radiation-left_2_0': 0},
)
field_id_25591_weightedmean_l1_in_tract_superior_longitudinal_fasciculus_right_2_0 = TensorMap(
    '25591_Weightedmean-L1-in-tract-superior-longitudinal-fasciculus-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25591_Weightedmean-L1-in-tract-superior-longitudinal-fasciculus-right_2_0': 0},
)
field_id_25590_weightedmean_l1_in_tract_superior_longitudinal_fasciculus_left_2_0 = TensorMap(
    '25590_Weightedmean-L1-in-tract-superior-longitudinal-fasciculus-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25590_Weightedmean-L1-in-tract-superior-longitudinal-fasciculus-left_2_0': 0},
)
field_id_25589_weightedmean_l1_in_tract_posterior_thalamic_radiation_right_2_0 = TensorMap(
    '25589_Weightedmean-L1-in-tract-posterior-thalamic-radiation-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25589_Weightedmean-L1-in-tract-posterior-thalamic-radiation-right_2_0': 0},
)
field_id_25588_weightedmean_l1_in_tract_posterior_thalamic_radiation_left_2_0 = TensorMap(
    '25588_Weightedmean-L1-in-tract-posterior-thalamic-radiation-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25588_Weightedmean-L1-in-tract-posterior-thalamic-radiation-left_2_0': 0},
)
field_id_25587_weightedmean_l1_in_tract_medial_lemniscus_right_2_0 = TensorMap(
    '25587_Weightedmean-L1-in-tract-medial-lemniscus-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25587_Weightedmean-L1-in-tract-medial-lemniscus-right_2_0': 0},
)
field_id_25586_weightedmean_l1_in_tract_medial_lemniscus_left_2_0 = TensorMap(
    '25586_Weightedmean-L1-in-tract-medial-lemniscus-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25586_Weightedmean-L1-in-tract-medial-lemniscus-left_2_0': 0},
)
field_id_25585_weightedmean_l1_in_tract_middle_cerebellar_peduncle_2_0 = TensorMap(
    '25585_Weightedmean-L1-in-tract-middle-cerebellar-peduncle_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25585_Weightedmean-L1-in-tract-middle-cerebellar-peduncle_2_0': 0},
)
field_id_25584_weightedmean_l1_in_tract_inferior_longitudinal_fasciculus_right_2_0 = TensorMap(
    '25584_Weightedmean-L1-in-tract-inferior-longitudinal-fasciculus-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25584_Weightedmean-L1-in-tract-inferior-longitudinal-fasciculus-right_2_0': 0},
)
field_id_25583_weightedmean_l1_in_tract_inferior_longitudinal_fasciculus_left_2_0 = TensorMap(
    '25583_Weightedmean-L1-in-tract-inferior-longitudinal-fasciculus-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25583_Weightedmean-L1-in-tract-inferior-longitudinal-fasciculus-left_2_0': 0},
)
field_id_25582_weightedmean_l1_in_tract_inferior_frontooccipital_fasciculus_right_2_0 = TensorMap(
    '25582_Weightedmean-L1-in-tract-inferior-frontooccipital-fasciculus-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25582_Weightedmean-L1-in-tract-inferior-frontooccipital-fasciculus-right_2_0': 0},
)
field_id_25581_weightedmean_l1_in_tract_inferior_frontooccipital_fasciculus_left_2_0 = TensorMap(
    '25581_Weightedmean-L1-in-tract-inferior-frontooccipital-fasciculus-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25581_Weightedmean-L1-in-tract-inferior-frontooccipital-fasciculus-left_2_0': 0},
)
field_id_25580_weightedmean_l1_in_tract_forceps_minor_2_0 = TensorMap(
    '25580_Weightedmean-L1-in-tract-forceps-minor_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25580_Weightedmean-L1-in-tract-forceps-minor_2_0': 0},
)
field_id_25579_weightedmean_l1_in_tract_forceps_major_2_0 = TensorMap(
    '25579_Weightedmean-L1-in-tract-forceps-major_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25579_Weightedmean-L1-in-tract-forceps-major_2_0': 0},
)
field_id_25578_weightedmean_l1_in_tract_corticospinal_tract_right_2_0 = TensorMap(
    '25578_Weightedmean-L1-in-tract-corticospinal-tract-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25578_Weightedmean-L1-in-tract-corticospinal-tract-right_2_0': 0},
)
field_id_25577_weightedmean_l1_in_tract_corticospinal_tract_left_2_0 = TensorMap(
    '25577_Weightedmean-L1-in-tract-corticospinal-tract-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25577_Weightedmean-L1-in-tract-corticospinal-tract-left_2_0': 0},
)
field_id_25576_weightedmean_l1_in_tract_parahippocampal_part_of_cingulum_right_2_0 = TensorMap(
    '25576_Weightedmean-L1-in-tract-parahippocampal-part-of-cingulum-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25576_Weightedmean-L1-in-tract-parahippocampal-part-of-cingulum-right_2_0': 0},
)
field_id_25575_weightedmean_l1_in_tract_parahippocampal_part_of_cingulum_left_2_0 = TensorMap(
    '25575_Weightedmean-L1-in-tract-parahippocampal-part-of-cingulum-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25575_Weightedmean-L1-in-tract-parahippocampal-part-of-cingulum-left_2_0': 0},
)
field_id_25574_weightedmean_l1_in_tract_cingulate_gyrus_part_of_cingulum_right_2_0 = TensorMap(
    '25574_Weightedmean-L1-in-tract-cingulate-gyrus-part-of-cingulum-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25574_Weightedmean-L1-in-tract-cingulate-gyrus-part-of-cingulum-right_2_0': 0},
)
field_id_25573_weightedmean_l1_in_tract_cingulate_gyrus_part_of_cingulum_left_2_0 = TensorMap(
    '25573_Weightedmean-L1-in-tract-cingulate-gyrus-part-of-cingulum-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25573_Weightedmean-L1-in-tract-cingulate-gyrus-part-of-cingulum-left_2_0': 0},
)
field_id_25572_weightedmean_l1_in_tract_anterior_thalamic_radiation_right_2_0 = TensorMap(
    '25572_Weightedmean-L1-in-tract-anterior-thalamic-radiation-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25572_Weightedmean-L1-in-tract-anterior-thalamic-radiation-right_2_0': 0},
)
field_id_25571_weightedmean_l1_in_tract_anterior_thalamic_radiation_left_2_0 = TensorMap(
    '25571_Weightedmean-L1-in-tract-anterior-thalamic-radiation-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25571_Weightedmean-L1-in-tract-anterior-thalamic-radiation-left_2_0': 0},
)
field_id_25570_weightedmean_l1_in_tract_acoustic_radiation_right_2_0 = TensorMap(
    '25570_Weightedmean-L1-in-tract-acoustic-radiation-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25570_Weightedmean-L1-in-tract-acoustic-radiation-right_2_0': 0},
)
field_id_25569_weightedmean_l1_in_tract_acoustic_radiation_left_2_0 = TensorMap(
    '25569_Weightedmean-L1-in-tract-acoustic-radiation-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25569_Weightedmean-L1-in-tract-acoustic-radiation-left_2_0': 0},
)
field_id_25568_weightedmean_mo_in_tract_uncinate_fasciculus_right_2_0 = TensorMap(
    '25568_Weightedmean-MO-in-tract-uncinate-fasciculus-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25568_Weightedmean-MO-in-tract-uncinate-fasciculus-right_2_0': 0},
)
field_id_25567_weightedmean_mo_in_tract_uncinate_fasciculus_left_2_0 = TensorMap(
    '25567_Weightedmean-MO-in-tract-uncinate-fasciculus-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25567_Weightedmean-MO-in-tract-uncinate-fasciculus-left_2_0': 0},
)
field_id_25566_weightedmean_mo_in_tract_superior_thalamic_radiation_right_2_0 = TensorMap(
    '25566_Weightedmean-MO-in-tract-superior-thalamic-radiation-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25566_Weightedmean-MO-in-tract-superior-thalamic-radiation-right_2_0': 0},
)
field_id_25565_weightedmean_mo_in_tract_superior_thalamic_radiation_left_2_0 = TensorMap(
    '25565_Weightedmean-MO-in-tract-superior-thalamic-radiation-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25565_Weightedmean-MO-in-tract-superior-thalamic-radiation-left_2_0': 0},
)
field_id_25564_weightedmean_mo_in_tract_superior_longitudinal_fasciculus_right_2_0 = TensorMap(
    '25564_Weightedmean-MO-in-tract-superior-longitudinal-fasciculus-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25564_Weightedmean-MO-in-tract-superior-longitudinal-fasciculus-right_2_0': 0},
)
field_id_25563_weightedmean_mo_in_tract_superior_longitudinal_fasciculus_left_2_0 = TensorMap(
    '25563_Weightedmean-MO-in-tract-superior-longitudinal-fasciculus-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25563_Weightedmean-MO-in-tract-superior-longitudinal-fasciculus-left_2_0': 0},
)
field_id_25562_weightedmean_mo_in_tract_posterior_thalamic_radiation_right_2_0 = TensorMap(
    '25562_Weightedmean-MO-in-tract-posterior-thalamic-radiation-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25562_Weightedmean-MO-in-tract-posterior-thalamic-radiation-right_2_0': 0},
)
field_id_25561_weightedmean_mo_in_tract_posterior_thalamic_radiation_left_2_0 = TensorMap(
    '25561_Weightedmean-MO-in-tract-posterior-thalamic-radiation-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25561_Weightedmean-MO-in-tract-posterior-thalamic-radiation-left_2_0': 0},
)
field_id_25560_weightedmean_mo_in_tract_medial_lemniscus_right_2_0 = TensorMap(
    '25560_Weightedmean-MO-in-tract-medial-lemniscus-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25560_Weightedmean-MO-in-tract-medial-lemniscus-right_2_0': 0},
)
field_id_25559_weightedmean_mo_in_tract_medial_lemniscus_left_2_0 = TensorMap(
    '25559_Weightedmean-MO-in-tract-medial-lemniscus-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25559_Weightedmean-MO-in-tract-medial-lemniscus-left_2_0': 0},
)
field_id_25558_weightedmean_mo_in_tract_middle_cerebellar_peduncle_2_0 = TensorMap(
    '25558_Weightedmean-MO-in-tract-middle-cerebellar-peduncle_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25558_Weightedmean-MO-in-tract-middle-cerebellar-peduncle_2_0': 0},
)
field_id_25557_weightedmean_mo_in_tract_inferior_longitudinal_fasciculus_right_2_0 = TensorMap(
    '25557_Weightedmean-MO-in-tract-inferior-longitudinal-fasciculus-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25557_Weightedmean-MO-in-tract-inferior-longitudinal-fasciculus-right_2_0': 0},
)
field_id_25556_weightedmean_mo_in_tract_inferior_longitudinal_fasciculus_left_2_0 = TensorMap(
    '25556_Weightedmean-MO-in-tract-inferior-longitudinal-fasciculus-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25556_Weightedmean-MO-in-tract-inferior-longitudinal-fasciculus-left_2_0': 0},
)
field_id_25555_weightedmean_mo_in_tract_inferior_frontooccipital_fasciculus_right_2_0 = TensorMap(
    '25555_Weightedmean-MO-in-tract-inferior-frontooccipital-fasciculus-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25555_Weightedmean-MO-in-tract-inferior-frontooccipital-fasciculus-right_2_0': 0},
)
field_id_25554_weightedmean_mo_in_tract_inferior_frontooccipital_fasciculus_left_2_0 = TensorMap(
    '25554_Weightedmean-MO-in-tract-inferior-frontooccipital-fasciculus-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25554_Weightedmean-MO-in-tract-inferior-frontooccipital-fasciculus-left_2_0': 0},
)
field_id_25553_weightedmean_mo_in_tract_forceps_minor_2_0 = TensorMap(
    '25553_Weightedmean-MO-in-tract-forceps-minor_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25553_Weightedmean-MO-in-tract-forceps-minor_2_0': 0},
)
field_id_25552_weightedmean_mo_in_tract_forceps_major_2_0 = TensorMap(
    '25552_Weightedmean-MO-in-tract-forceps-major_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25552_Weightedmean-MO-in-tract-forceps-major_2_0': 0},
)
field_id_25551_weightedmean_mo_in_tract_corticospinal_tract_right_2_0 = TensorMap(
    '25551_Weightedmean-MO-in-tract-corticospinal-tract-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25551_Weightedmean-MO-in-tract-corticospinal-tract-right_2_0': 0},
)
field_id_25550_weightedmean_mo_in_tract_corticospinal_tract_left_2_0 = TensorMap(
    '25550_Weightedmean-MO-in-tract-corticospinal-tract-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25550_Weightedmean-MO-in-tract-corticospinal-tract-left_2_0': 0},
)
field_id_25549_weightedmean_mo_in_tract_parahippocampal_part_of_cingulum_right_2_0 = TensorMap(
    '25549_Weightedmean-MO-in-tract-parahippocampal-part-of-cingulum-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25549_Weightedmean-MO-in-tract-parahippocampal-part-of-cingulum-right_2_0': 0},
)
field_id_25548_weightedmean_mo_in_tract_parahippocampal_part_of_cingulum_left_2_0 = TensorMap(
    '25548_Weightedmean-MO-in-tract-parahippocampal-part-of-cingulum-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25548_Weightedmean-MO-in-tract-parahippocampal-part-of-cingulum-left_2_0': 0},
)
field_id_25547_weightedmean_mo_in_tract_cingulate_gyrus_part_of_cingulum_right_2_0 = TensorMap(
    '25547_Weightedmean-MO-in-tract-cingulate-gyrus-part-of-cingulum-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25547_Weightedmean-MO-in-tract-cingulate-gyrus-part-of-cingulum-right_2_0': 0},
)
field_id_25546_weightedmean_mo_in_tract_cingulate_gyrus_part_of_cingulum_left_2_0 = TensorMap(
    '25546_Weightedmean-MO-in-tract-cingulate-gyrus-part-of-cingulum-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25546_Weightedmean-MO-in-tract-cingulate-gyrus-part-of-cingulum-left_2_0': 0},
)
field_id_25545_weightedmean_mo_in_tract_anterior_thalamic_radiation_right_2_0 = TensorMap(
    '25545_Weightedmean-MO-in-tract-anterior-thalamic-radiation-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25545_Weightedmean-MO-in-tract-anterior-thalamic-radiation-right_2_0': 0},
)
field_id_25544_weightedmean_mo_in_tract_anterior_thalamic_radiation_left_2_0 = TensorMap(
    '25544_Weightedmean-MO-in-tract-anterior-thalamic-radiation-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25544_Weightedmean-MO-in-tract-anterior-thalamic-radiation-left_2_0': 0},
)
field_id_25543_weightedmean_mo_in_tract_acoustic_radiation_right_2_0 = TensorMap(
    '25543_Weightedmean-MO-in-tract-acoustic-radiation-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25543_Weightedmean-MO-in-tract-acoustic-radiation-right_2_0': 0},
)
field_id_25542_weightedmean_mo_in_tract_acoustic_radiation_left_2_0 = TensorMap(
    '25542_Weightedmean-MO-in-tract-acoustic-radiation-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25542_Weightedmean-MO-in-tract-acoustic-radiation-left_2_0': 0},
)
field_id_25541_weightedmean_md_in_tract_uncinate_fasciculus_right_2_0 = TensorMap(
    '25541_Weightedmean-MD-in-tract-uncinate-fasciculus-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25541_Weightedmean-MD-in-tract-uncinate-fasciculus-right_2_0': 0},
)
field_id_25540_weightedmean_md_in_tract_uncinate_fasciculus_left_2_0 = TensorMap(
    '25540_Weightedmean-MD-in-tract-uncinate-fasciculus-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25540_Weightedmean-MD-in-tract-uncinate-fasciculus-left_2_0': 0},
)
field_id_25539_weightedmean_md_in_tract_superior_thalamic_radiation_right_2_0 = TensorMap(
    '25539_Weightedmean-MD-in-tract-superior-thalamic-radiation-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25539_Weightedmean-MD-in-tract-superior-thalamic-radiation-right_2_0': 0},
)
field_id_25538_weightedmean_md_in_tract_superior_thalamic_radiation_left_2_0 = TensorMap(
    '25538_Weightedmean-MD-in-tract-superior-thalamic-radiation-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25538_Weightedmean-MD-in-tract-superior-thalamic-radiation-left_2_0': 0},
)
field_id_25537_weightedmean_md_in_tract_superior_longitudinal_fasciculus_right_2_0 = TensorMap(
    '25537_Weightedmean-MD-in-tract-superior-longitudinal-fasciculus-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25537_Weightedmean-MD-in-tract-superior-longitudinal-fasciculus-right_2_0': 0},
)
field_id_25536_weightedmean_md_in_tract_superior_longitudinal_fasciculus_left_2_0 = TensorMap(
    '25536_Weightedmean-MD-in-tract-superior-longitudinal-fasciculus-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25536_Weightedmean-MD-in-tract-superior-longitudinal-fasciculus-left_2_0': 0},
)
field_id_25535_weightedmean_md_in_tract_posterior_thalamic_radiation_right_2_0 = TensorMap(
    '25535_Weightedmean-MD-in-tract-posterior-thalamic-radiation-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25535_Weightedmean-MD-in-tract-posterior-thalamic-radiation-right_2_0': 0},
)
field_id_25534_weightedmean_md_in_tract_posterior_thalamic_radiation_left_2_0 = TensorMap(
    '25534_Weightedmean-MD-in-tract-posterior-thalamic-radiation-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25534_Weightedmean-MD-in-tract-posterior-thalamic-radiation-left_2_0': 0},
)
field_id_25533_weightedmean_md_in_tract_medial_lemniscus_right_2_0 = TensorMap(
    '25533_Weightedmean-MD-in-tract-medial-lemniscus-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25533_Weightedmean-MD-in-tract-medial-lemniscus-right_2_0': 0},
)
field_id_25532_weightedmean_md_in_tract_medial_lemniscus_left_2_0 = TensorMap(
    '25532_Weightedmean-MD-in-tract-medial-lemniscus-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25532_Weightedmean-MD-in-tract-medial-lemniscus-left_2_0': 0},
)
field_id_25531_weightedmean_md_in_tract_middle_cerebellar_peduncle_2_0 = TensorMap(
    '25531_Weightedmean-MD-in-tract-middle-cerebellar-peduncle_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25531_Weightedmean-MD-in-tract-middle-cerebellar-peduncle_2_0': 0},
)
field_id_25530_weightedmean_md_in_tract_inferior_longitudinal_fasciculus_right_2_0 = TensorMap(
    '25530_Weightedmean-MD-in-tract-inferior-longitudinal-fasciculus-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25530_Weightedmean-MD-in-tract-inferior-longitudinal-fasciculus-right_2_0': 0},
)
field_id_25529_weightedmean_md_in_tract_inferior_longitudinal_fasciculus_left_2_0 = TensorMap(
    '25529_Weightedmean-MD-in-tract-inferior-longitudinal-fasciculus-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25529_Weightedmean-MD-in-tract-inferior-longitudinal-fasciculus-left_2_0': 0},
)
field_id_25528_weightedmean_md_in_tract_inferior_frontooccipital_fasciculus_right_2_0 = TensorMap(
    '25528_Weightedmean-MD-in-tract-inferior-frontooccipital-fasciculus-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25528_Weightedmean-MD-in-tract-inferior-frontooccipital-fasciculus-right_2_0': 0},
)
field_id_25527_weightedmean_md_in_tract_inferior_frontooccipital_fasciculus_left_2_0 = TensorMap(
    '25527_Weightedmean-MD-in-tract-inferior-frontooccipital-fasciculus-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25527_Weightedmean-MD-in-tract-inferior-frontooccipital-fasciculus-left_2_0': 0},
)
field_id_25526_weightedmean_md_in_tract_forceps_minor_2_0 = TensorMap(
    '25526_Weightedmean-MD-in-tract-forceps-minor_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25526_Weightedmean-MD-in-tract-forceps-minor_2_0': 0},
)
field_id_25525_weightedmean_md_in_tract_forceps_major_2_0 = TensorMap(
    '25525_Weightedmean-MD-in-tract-forceps-major_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25525_Weightedmean-MD-in-tract-forceps-major_2_0': 0},
)
field_id_25524_weightedmean_md_in_tract_corticospinal_tract_right_2_0 = TensorMap(
    '25524_Weightedmean-MD-in-tract-corticospinal-tract-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25524_Weightedmean-MD-in-tract-corticospinal-tract-right_2_0': 0},
)
field_id_25523_weightedmean_md_in_tract_corticospinal_tract_left_2_0 = TensorMap(
    '25523_Weightedmean-MD-in-tract-corticospinal-tract-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25523_Weightedmean-MD-in-tract-corticospinal-tract-left_2_0': 0},
)
field_id_25522_weightedmean_md_in_tract_parahippocampal_part_of_cingulum_right_2_0 = TensorMap(
    '25522_Weightedmean-MD-in-tract-parahippocampal-part-of-cingulum-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25522_Weightedmean-MD-in-tract-parahippocampal-part-of-cingulum-right_2_0': 0},
)
field_id_25521_weightedmean_md_in_tract_parahippocampal_part_of_cingulum_left_2_0 = TensorMap(
    '25521_Weightedmean-MD-in-tract-parahippocampal-part-of-cingulum-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25521_Weightedmean-MD-in-tract-parahippocampal-part-of-cingulum-left_2_0': 0},
)
field_id_25520_weightedmean_md_in_tract_cingulate_gyrus_part_of_cingulum_right_2_0 = TensorMap(
    '25520_Weightedmean-MD-in-tract-cingulate-gyrus-part-of-cingulum-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25520_Weightedmean-MD-in-tract-cingulate-gyrus-part-of-cingulum-right_2_0': 0},
)
field_id_25519_weightedmean_md_in_tract_cingulate_gyrus_part_of_cingulum_left_2_0 = TensorMap(
    '25519_Weightedmean-MD-in-tract-cingulate-gyrus-part-of-cingulum-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25519_Weightedmean-MD-in-tract-cingulate-gyrus-part-of-cingulum-left_2_0': 0},
)
field_id_25518_weightedmean_md_in_tract_anterior_thalamic_radiation_right_2_0 = TensorMap(
    '25518_Weightedmean-MD-in-tract-anterior-thalamic-radiation-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25518_Weightedmean-MD-in-tract-anterior-thalamic-radiation-right_2_0': 0},
)
field_id_25517_weightedmean_md_in_tract_anterior_thalamic_radiation_left_2_0 = TensorMap(
    '25517_Weightedmean-MD-in-tract-anterior-thalamic-radiation-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25517_Weightedmean-MD-in-tract-anterior-thalamic-radiation-left_2_0': 0},
)
field_id_25516_weightedmean_md_in_tract_acoustic_radiation_right_2_0 = TensorMap(
    '25516_Weightedmean-MD-in-tract-acoustic-radiation-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25516_Weightedmean-MD-in-tract-acoustic-radiation-right_2_0': 0},
)
field_id_25515_weightedmean_md_in_tract_acoustic_radiation_left_2_0 = TensorMap(
    '25515_Weightedmean-MD-in-tract-acoustic-radiation-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25515_Weightedmean-MD-in-tract-acoustic-radiation-left_2_0': 0},
)
field_id_25514_weightedmean_fa_in_tract_uncinate_fasciculus_right_2_0 = TensorMap(
    '25514_Weightedmean-FA-in-tract-uncinate-fasciculus-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25514_Weightedmean-FA-in-tract-uncinate-fasciculus-right_2_0': 0},
)
field_id_25513_weightedmean_fa_in_tract_uncinate_fasciculus_left_2_0 = TensorMap(
    '25513_Weightedmean-FA-in-tract-uncinate-fasciculus-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25513_Weightedmean-FA-in-tract-uncinate-fasciculus-left_2_0': 0},
)
field_id_25512_weightedmean_fa_in_tract_superior_thalamic_radiation_right_2_0 = TensorMap(
    '25512_Weightedmean-FA-in-tract-superior-thalamic-radiation-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25512_Weightedmean-FA-in-tract-superior-thalamic-radiation-right_2_0': 0},
)
field_id_25511_weightedmean_fa_in_tract_superior_thalamic_radiation_left_2_0 = TensorMap(
    '25511_Weightedmean-FA-in-tract-superior-thalamic-radiation-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25511_Weightedmean-FA-in-tract-superior-thalamic-radiation-left_2_0': 0},
)
field_id_25510_weightedmean_fa_in_tract_superior_longitudinal_fasciculus_right_2_0 = TensorMap(
    '25510_Weightedmean-FA-in-tract-superior-longitudinal-fasciculus-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25510_Weightedmean-FA-in-tract-superior-longitudinal-fasciculus-right_2_0': 0},
)
field_id_25509_weightedmean_fa_in_tract_superior_longitudinal_fasciculus_left_2_0 = TensorMap(
    '25509_Weightedmean-FA-in-tract-superior-longitudinal-fasciculus-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25509_Weightedmean-FA-in-tract-superior-longitudinal-fasciculus-left_2_0': 0},
)
field_id_25508_weightedmean_fa_in_tract_posterior_thalamic_radiation_right_2_0 = TensorMap(
    '25508_Weightedmean-FA-in-tract-posterior-thalamic-radiation-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25508_Weightedmean-FA-in-tract-posterior-thalamic-radiation-right_2_0': 0},
)
field_id_25507_weightedmean_fa_in_tract_posterior_thalamic_radiation_left_2_0 = TensorMap(
    '25507_Weightedmean-FA-in-tract-posterior-thalamic-radiation-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25507_Weightedmean-FA-in-tract-posterior-thalamic-radiation-left_2_0': 0},
)
field_id_25506_weightedmean_fa_in_tract_medial_lemniscus_right_2_0 = TensorMap(
    '25506_Weightedmean-FA-in-tract-medial-lemniscus-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25506_Weightedmean-FA-in-tract-medial-lemniscus-right_2_0': 0},
)
field_id_25505_weightedmean_fa_in_tract_medial_lemniscus_left_2_0 = TensorMap(
    '25505_Weightedmean-FA-in-tract-medial-lemniscus-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25505_Weightedmean-FA-in-tract-medial-lemniscus-left_2_0': 0},
)
field_id_25504_weightedmean_fa_in_tract_middle_cerebellar_peduncle_2_0 = TensorMap(
    '25504_Weightedmean-FA-in-tract-middle-cerebellar-peduncle_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25504_Weightedmean-FA-in-tract-middle-cerebellar-peduncle_2_0': 0},
)
field_id_25503_weightedmean_fa_in_tract_inferior_longitudinal_fasciculus_right_2_0 = TensorMap(
    '25503_Weightedmean-FA-in-tract-inferior-longitudinal-fasciculus-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25503_Weightedmean-FA-in-tract-inferior-longitudinal-fasciculus-right_2_0': 0},
)
field_id_25502_weightedmean_fa_in_tract_inferior_longitudinal_fasciculus_left_2_0 = TensorMap(
    '25502_Weightedmean-FA-in-tract-inferior-longitudinal-fasciculus-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25502_Weightedmean-FA-in-tract-inferior-longitudinal-fasciculus-left_2_0': 0},
)
field_id_25501_weightedmean_fa_in_tract_inferior_frontooccipital_fasciculus_right_2_0 = TensorMap(
    '25501_Weightedmean-FA-in-tract-inferior-frontooccipital-fasciculus-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25501_Weightedmean-FA-in-tract-inferior-frontooccipital-fasciculus-right_2_0': 0},
)
field_id_25500_weightedmean_fa_in_tract_inferior_frontooccipital_fasciculus_left_2_0 = TensorMap(
    '25500_Weightedmean-FA-in-tract-inferior-frontooccipital-fasciculus-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25500_Weightedmean-FA-in-tract-inferior-frontooccipital-fasciculus-left_2_0': 0},
)
field_id_25499_weightedmean_fa_in_tract_forceps_minor_2_0 = TensorMap(
    '25499_Weightedmean-FA-in-tract-forceps-minor_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25499_Weightedmean-FA-in-tract-forceps-minor_2_0': 0},
)
field_id_25498_weightedmean_fa_in_tract_forceps_major_2_0 = TensorMap(
    '25498_Weightedmean-FA-in-tract-forceps-major_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25498_Weightedmean-FA-in-tract-forceps-major_2_0': 0},
)
field_id_25497_weightedmean_fa_in_tract_corticospinal_tract_right_2_0 = TensorMap(
    '25497_Weightedmean-FA-in-tract-corticospinal-tract-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25497_Weightedmean-FA-in-tract-corticospinal-tract-right_2_0': 0},
)
field_id_25496_weightedmean_fa_in_tract_corticospinal_tract_left_2_0 = TensorMap(
    '25496_Weightedmean-FA-in-tract-corticospinal-tract-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25496_Weightedmean-FA-in-tract-corticospinal-tract-left_2_0': 0},
)
field_id_25495_weightedmean_fa_in_tract_parahippocampal_part_of_cingulum_right_2_0 = TensorMap(
    '25495_Weightedmean-FA-in-tract-parahippocampal-part-of-cingulum-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25495_Weightedmean-FA-in-tract-parahippocampal-part-of-cingulum-right_2_0': 0},
)
field_id_25494_weightedmean_fa_in_tract_parahippocampal_part_of_cingulum_left_2_0 = TensorMap(
    '25494_Weightedmean-FA-in-tract-parahippocampal-part-of-cingulum-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25494_Weightedmean-FA-in-tract-parahippocampal-part-of-cingulum-left_2_0': 0},
)
field_id_25493_weightedmean_fa_in_tract_cingulate_gyrus_part_of_cingulum_right_2_0 = TensorMap(
    '25493_Weightedmean-FA-in-tract-cingulate-gyrus-part-of-cingulum-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25493_Weightedmean-FA-in-tract-cingulate-gyrus-part-of-cingulum-right_2_0': 0},
)
field_id_25492_weightedmean_fa_in_tract_cingulate_gyrus_part_of_cingulum_left_2_0 = TensorMap(
    '25492_Weightedmean-FA-in-tract-cingulate-gyrus-part-of-cingulum-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25492_Weightedmean-FA-in-tract-cingulate-gyrus-part-of-cingulum-left_2_0': 0},
)
field_id_25491_weightedmean_fa_in_tract_anterior_thalamic_radiation_right_2_0 = TensorMap(
    '25491_Weightedmean-FA-in-tract-anterior-thalamic-radiation-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25491_Weightedmean-FA-in-tract-anterior-thalamic-radiation-right_2_0': 0},
)
field_id_25490_weightedmean_fa_in_tract_anterior_thalamic_radiation_left_2_0 = TensorMap(
    '25490_Weightedmean-FA-in-tract-anterior-thalamic-radiation-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25490_Weightedmean-FA-in-tract-anterior-thalamic-radiation-left_2_0': 0},
)
field_id_25489_weightedmean_fa_in_tract_acoustic_radiation_right_2_0 = TensorMap(
    '25489_Weightedmean-FA-in-tract-acoustic-radiation-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25489_Weightedmean-FA-in-tract-acoustic-radiation-right_2_0': 0},
)
field_id_25488_weightedmean_fa_in_tract_acoustic_radiation_left_2_0 = TensorMap(
    '25488_Weightedmean-FA-in-tract-acoustic-radiation-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25488_Weightedmean-FA-in-tract-acoustic-radiation-left_2_0': 0},
)
field_id_25487_mean_isovf_in_tapetum_on_fa_skeleton_left_2_0 = TensorMap(
    '25487_Mean-ISOVF-in-tapetum-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25487_Mean-ISOVF-in-tapetum-on-FA-skeleton-left_2_0': 0},
)
field_id_25486_mean_isovf_in_tapetum_on_fa_skeleton_right_2_0 = TensorMap(
    '25486_Mean-ISOVF-in-tapetum-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25486_Mean-ISOVF-in-tapetum-on-FA-skeleton-right_2_0': 0},
)
field_id_25485_mean_isovf_in_uncinate_fasciculus_on_fa_skeleton_left_2_0 = TensorMap(
    '25485_Mean-ISOVF-in-uncinate-fasciculus-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25485_Mean-ISOVF-in-uncinate-fasciculus-on-FA-skeleton-left_2_0': 0},
)
field_id_25484_mean_isovf_in_uncinate_fasciculus_on_fa_skeleton_right_2_0 = TensorMap(
    '25484_Mean-ISOVF-in-uncinate-fasciculus-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25484_Mean-ISOVF-in-uncinate-fasciculus-on-FA-skeleton-right_2_0': 0},
)
field_id_25483_mean_isovf_in_superior_frontooccipital_fasciculus_on_fa_skeleton_left_2_0 = TensorMap(
    '25483_Mean-ISOVF-in-superior-frontooccipital-fasciculus-on-FA-skeleton-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25483_Mean-ISOVF-in-superior-frontooccipital-fasciculus-on-FA-skeleton-left_2_0': 0},
)
field_id_25482_mean_isovf_in_superior_frontooccipital_fasciculus_on_fa_skeleton_right_2_0 = TensorMap(
    '25482_Mean-ISOVF-in-superior-frontooccipital-fasciculus-on-FA-skeleton-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25482_Mean-ISOVF-in-superior-frontooccipital-fasciculus-on-FA-skeleton-right_2_0': 0},
)
field_id_25481_mean_isovf_in_superior_longitudinal_fasciculus_on_fa_skeleton_left_2_0 = TensorMap(
    '25481_Mean-ISOVF-in-superior-longitudinal-fasciculus-on-FA-skeleton-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25481_Mean-ISOVF-in-superior-longitudinal-fasciculus-on-FA-skeleton-left_2_0': 0},
)
field_id_25480_mean_isovf_in_superior_longitudinal_fasciculus_on_fa_skeleton_right_2_0 = TensorMap(
    '25480_Mean-ISOVF-in-superior-longitudinal-fasciculus-on-FA-skeleton-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25480_Mean-ISOVF-in-superior-longitudinal-fasciculus-on-FA-skeleton-right_2_0': 0},
)
field_id_25479_mean_isovf_in_fornix_cresstria_terminalis_on_fa_skeleton_left_2_0 = TensorMap(
    '25479_Mean-ISOVF-in-fornix-cresstria-terminalis-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25479_Mean-ISOVF-in-fornix-cresstria-terminalis-on-FA-skeleton-left_2_0': 0},
)
field_id_25478_mean_isovf_in_fornix_cresstria_terminalis_on_fa_skeleton_right_2_0 = TensorMap(
    '25478_Mean-ISOVF-in-fornix-cresstria-terminalis-on-FA-skeleton-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25478_Mean-ISOVF-in-fornix-cresstria-terminalis-on-FA-skeleton-right_2_0': 0},
)
field_id_25477_mean_isovf_in_cingulum_hippocampus_on_fa_skeleton_left_2_0 = TensorMap(
    '25477_Mean-ISOVF-in-cingulum-hippocampus-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25477_Mean-ISOVF-in-cingulum-hippocampus-on-FA-skeleton-left_2_0': 0},
)
field_id_25476_mean_isovf_in_cingulum_hippocampus_on_fa_skeleton_right_2_0 = TensorMap(
    '25476_Mean-ISOVF-in-cingulum-hippocampus-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25476_Mean-ISOVF-in-cingulum-hippocampus-on-FA-skeleton-right_2_0': 0},
)
field_id_25475_mean_isovf_in_cingulum_cingulate_gyrus_on_fa_skeleton_left_2_0 = TensorMap(
    '25475_Mean-ISOVF-in-cingulum-cingulate-gyrus-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25475_Mean-ISOVF-in-cingulum-cingulate-gyrus-on-FA-skeleton-left_2_0': 0},
)
field_id_25474_mean_isovf_in_cingulum_cingulate_gyrus_on_fa_skeleton_right_2_0 = TensorMap(
    '25474_Mean-ISOVF-in-cingulum-cingulate-gyrus-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25474_Mean-ISOVF-in-cingulum-cingulate-gyrus-on-FA-skeleton-right_2_0': 0},
)
field_id_25473_mean_isovf_in_external_capsule_on_fa_skeleton_left_2_0 = TensorMap(
    '25473_Mean-ISOVF-in-external-capsule-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25473_Mean-ISOVF-in-external-capsule-on-FA-skeleton-left_2_0': 0},
)
field_id_25472_mean_isovf_in_external_capsule_on_fa_skeleton_right_2_0 = TensorMap(
    '25472_Mean-ISOVF-in-external-capsule-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25472_Mean-ISOVF-in-external-capsule-on-FA-skeleton-right_2_0': 0},
)
field_id_25471_mean_isovf_in_sagittal_stratum_on_fa_skeleton_left_2_0 = TensorMap(
    '25471_Mean-ISOVF-in-sagittal-stratum-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25471_Mean-ISOVF-in-sagittal-stratum-on-FA-skeleton-left_2_0': 0},
)
field_id_25470_mean_isovf_in_sagittal_stratum_on_fa_skeleton_right_2_0 = TensorMap(
    '25470_Mean-ISOVF-in-sagittal-stratum-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25470_Mean-ISOVF-in-sagittal-stratum-on-FA-skeleton-right_2_0': 0},
)
field_id_25469_mean_isovf_in_posterior_thalamic_radiation_on_fa_skeleton_left_2_0 = TensorMap(
    '25469_Mean-ISOVF-in-posterior-thalamic-radiation-on-FA-skeleton-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25469_Mean-ISOVF-in-posterior-thalamic-radiation-on-FA-skeleton-left_2_0': 0},
)
field_id_25468_mean_isovf_in_posterior_thalamic_radiation_on_fa_skeleton_right_2_0 = TensorMap(
    '25468_Mean-ISOVF-in-posterior-thalamic-radiation-on-FA-skeleton-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25468_Mean-ISOVF-in-posterior-thalamic-radiation-on-FA-skeleton-right_2_0': 0},
)
field_id_25467_mean_isovf_in_posterior_corona_radiata_on_fa_skeleton_left_2_0 = TensorMap(
    '25467_Mean-ISOVF-in-posterior-corona-radiata-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25467_Mean-ISOVF-in-posterior-corona-radiata-on-FA-skeleton-left_2_0': 0},
)
field_id_25466_mean_isovf_in_posterior_corona_radiata_on_fa_skeleton_right_2_0 = TensorMap(
    '25466_Mean-ISOVF-in-posterior-corona-radiata-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25466_Mean-ISOVF-in-posterior-corona-radiata-on-FA-skeleton-right_2_0': 0},
)
field_id_25465_mean_isovf_in_superior_corona_radiata_on_fa_skeleton_left_2_0 = TensorMap(
    '25465_Mean-ISOVF-in-superior-corona-radiata-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25465_Mean-ISOVF-in-superior-corona-radiata-on-FA-skeleton-left_2_0': 0},
)
field_id_25464_mean_isovf_in_superior_corona_radiata_on_fa_skeleton_right_2_0 = TensorMap(
    '25464_Mean-ISOVF-in-superior-corona-radiata-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25464_Mean-ISOVF-in-superior-corona-radiata-on-FA-skeleton-right_2_0': 0},
)
field_id_25463_mean_isovf_in_anterior_corona_radiata_on_fa_skeleton_left_2_0 = TensorMap(
    '25463_Mean-ISOVF-in-anterior-corona-radiata-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25463_Mean-ISOVF-in-anterior-corona-radiata-on-FA-skeleton-left_2_0': 0},
)
field_id_25462_mean_isovf_in_anterior_corona_radiata_on_fa_skeleton_right_2_0 = TensorMap(
    '25462_Mean-ISOVF-in-anterior-corona-radiata-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25462_Mean-ISOVF-in-anterior-corona-radiata-on-FA-skeleton-right_2_0': 0},
)
field_id_25461_mean_isovf_in_retrolenticular_part_of_internal_capsule_on_fa_skeleton_left_2_0 = TensorMap(
    '25461_Mean-ISOVF-in-retrolenticular-part-of-internal-capsule-on-FA-skeleton-left_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'25461_Mean-ISOVF-in-retrolenticular-part-of-internal-capsule-on-FA-skeleton-left_2_0': 0},
)
field_id_25460_mean_isovf_in_retrolenticular_part_of_internal_capsule_on_fa_skeleton_right_2_0 = TensorMap(
    '25460_Mean-ISOVF-in-retrolenticular-part-of-internal-capsule-on-FA-skeleton-right_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'25460_Mean-ISOVF-in-retrolenticular-part-of-internal-capsule-on-FA-skeleton-right_2_0': 0},
)
field_id_25459_mean_isovf_in_posterior_limb_of_internal_capsule_on_fa_skeleton_left_2_0 = TensorMap(
    '25459_Mean-ISOVF-in-posterior-limb-of-internal-capsule-on-FA-skeleton-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25459_Mean-ISOVF-in-posterior-limb-of-internal-capsule-on-FA-skeleton-left_2_0': 0},
)
field_id_25458_mean_isovf_in_posterior_limb_of_internal_capsule_on_fa_skeleton_right_2_0 = TensorMap(
    '25458_Mean-ISOVF-in-posterior-limb-of-internal-capsule-on-FA-skeleton-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25458_Mean-ISOVF-in-posterior-limb-of-internal-capsule-on-FA-skeleton-right_2_0': 0},
)
field_id_25457_mean_isovf_in_anterior_limb_of_internal_capsule_on_fa_skeleton_left_2_0 = TensorMap(
    '25457_Mean-ISOVF-in-anterior-limb-of-internal-capsule-on-FA-skeleton-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25457_Mean-ISOVF-in-anterior-limb-of-internal-capsule-on-FA-skeleton-left_2_0': 0},
)
field_id_25456_mean_isovf_in_anterior_limb_of_internal_capsule_on_fa_skeleton_right_2_0 = TensorMap(
    '25456_Mean-ISOVF-in-anterior-limb-of-internal-capsule-on-FA-skeleton-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25456_Mean-ISOVF-in-anterior-limb-of-internal-capsule-on-FA-skeleton-right_2_0': 0},
)
field_id_25455_mean_isovf_in_cerebral_peduncle_on_fa_skeleton_left_2_0 = TensorMap(
    '25455_Mean-ISOVF-in-cerebral-peduncle-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25455_Mean-ISOVF-in-cerebral-peduncle-on-FA-skeleton-left_2_0': 0},
)
field_id_25454_mean_isovf_in_cerebral_peduncle_on_fa_skeleton_right_2_0 = TensorMap(
    '25454_Mean-ISOVF-in-cerebral-peduncle-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25454_Mean-ISOVF-in-cerebral-peduncle-on-FA-skeleton-right_2_0': 0},
)
field_id_25453_mean_isovf_in_superior_cerebellar_peduncle_on_fa_skeleton_left_2_0 = TensorMap(
    '25453_Mean-ISOVF-in-superior-cerebellar-peduncle-on-FA-skeleton-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25453_Mean-ISOVF-in-superior-cerebellar-peduncle-on-FA-skeleton-left_2_0': 0},
)
field_id_25452_mean_isovf_in_superior_cerebellar_peduncle_on_fa_skeleton_right_2_0 = TensorMap(
    '25452_Mean-ISOVF-in-superior-cerebellar-peduncle-on-FA-skeleton-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25452_Mean-ISOVF-in-superior-cerebellar-peduncle-on-FA-skeleton-right_2_0': 0},
)
field_id_25451_mean_isovf_in_inferior_cerebellar_peduncle_on_fa_skeleton_left_2_0 = TensorMap(
    '25451_Mean-ISOVF-in-inferior-cerebellar-peduncle-on-FA-skeleton-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25451_Mean-ISOVF-in-inferior-cerebellar-peduncle-on-FA-skeleton-left_2_0': 0},
)
field_id_25450_mean_isovf_in_inferior_cerebellar_peduncle_on_fa_skeleton_right_2_0 = TensorMap(
    '25450_Mean-ISOVF-in-inferior-cerebellar-peduncle-on-FA-skeleton-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25450_Mean-ISOVF-in-inferior-cerebellar-peduncle-on-FA-skeleton-right_2_0': 0},
)
field_id_25449_mean_isovf_in_medial_lemniscus_on_fa_skeleton_left_2_0 = TensorMap(
    '25449_Mean-ISOVF-in-medial-lemniscus-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25449_Mean-ISOVF-in-medial-lemniscus-on-FA-skeleton-left_2_0': 0},
)
field_id_25448_mean_isovf_in_medial_lemniscus_on_fa_skeleton_right_2_0 = TensorMap(
    '25448_Mean-ISOVF-in-medial-lemniscus-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25448_Mean-ISOVF-in-medial-lemniscus-on-FA-skeleton-right_2_0': 0},
)
field_id_25447_mean_isovf_in_corticospinal_tract_on_fa_skeleton_left_2_0 = TensorMap(
    '25447_Mean-ISOVF-in-corticospinal-tract-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25447_Mean-ISOVF-in-corticospinal-tract-on-FA-skeleton-left_2_0': 0},
)
field_id_25446_mean_isovf_in_corticospinal_tract_on_fa_skeleton_right_2_0 = TensorMap(
    '25446_Mean-ISOVF-in-corticospinal-tract-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25446_Mean-ISOVF-in-corticospinal-tract-on-FA-skeleton-right_2_0': 0},
)
field_id_25445_mean_isovf_in_fornix_on_fa_skeleton_2_0 = TensorMap(
    '25445_Mean-ISOVF-in-fornix-on-FA-skeleton_2_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '25445_Mean-ISOVF-in-fornix-on-FA-skeleton_2_0': 0,
    },
)
field_id_25444_mean_isovf_in_splenium_of_corpus_callosum_on_fa_skeleton_2_0 = TensorMap(
    '25444_Mean-ISOVF-in-splenium-of-corpus-callosum-on-FA-skeleton_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25444_Mean-ISOVF-in-splenium-of-corpus-callosum-on-FA-skeleton_2_0': 0},
)
field_id_25443_mean_isovf_in_body_of_corpus_callosum_on_fa_skeleton_2_0 = TensorMap(
    '25443_Mean-ISOVF-in-body-of-corpus-callosum-on-FA-skeleton_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25443_Mean-ISOVF-in-body-of-corpus-callosum-on-FA-skeleton_2_0': 0},
)
field_id_25442_mean_isovf_in_genu_of_corpus_callosum_on_fa_skeleton_2_0 = TensorMap(
    '25442_Mean-ISOVF-in-genu-of-corpus-callosum-on-FA-skeleton_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25442_Mean-ISOVF-in-genu-of-corpus-callosum-on-FA-skeleton_2_0': 0},
)
field_id_25441_mean_isovf_in_pontine_crossing_tract_on_fa_skeleton_2_0 = TensorMap(
    '25441_Mean-ISOVF-in-pontine-crossing-tract-on-FA-skeleton_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25441_Mean-ISOVF-in-pontine-crossing-tract-on-FA-skeleton_2_0': 0},
)
field_id_25440_mean_isovf_in_middle_cerebellar_peduncle_on_fa_skeleton_2_0 = TensorMap(
    '25440_Mean-ISOVF-in-middle-cerebellar-peduncle-on-FA-skeleton_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25440_Mean-ISOVF-in-middle-cerebellar-peduncle-on-FA-skeleton_2_0': 0},
)
field_id_25439_mean_od_in_tapetum_on_fa_skeleton_left_2_0 = TensorMap(
    '25439_Mean-OD-in-tapetum-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25439_Mean-OD-in-tapetum-on-FA-skeleton-left_2_0': 0},
)
field_id_25438_mean_od_in_tapetum_on_fa_skeleton_right_2_0 = TensorMap(
    '25438_Mean-OD-in-tapetum-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25438_Mean-OD-in-tapetum-on-FA-skeleton-right_2_0': 0},
)
field_id_25437_mean_od_in_uncinate_fasciculus_on_fa_skeleton_left_2_0 = TensorMap(
    '25437_Mean-OD-in-uncinate-fasciculus-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25437_Mean-OD-in-uncinate-fasciculus-on-FA-skeleton-left_2_0': 0},
)
field_id_25436_mean_od_in_uncinate_fasciculus_on_fa_skeleton_right_2_0 = TensorMap(
    '25436_Mean-OD-in-uncinate-fasciculus-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25436_Mean-OD-in-uncinate-fasciculus-on-FA-skeleton-right_2_0': 0},
)
field_id_25435_mean_od_in_superior_frontooccipital_fasciculus_on_fa_skeleton_left_2_0 = TensorMap(
    '25435_Mean-OD-in-superior-frontooccipital-fasciculus-on-FA-skeleton-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25435_Mean-OD-in-superior-frontooccipital-fasciculus-on-FA-skeleton-left_2_0': 0},
)
field_id_25434_mean_od_in_superior_frontooccipital_fasciculus_on_fa_skeleton_right_2_0 = TensorMap(
    '25434_Mean-OD-in-superior-frontooccipital-fasciculus-on-FA-skeleton-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25434_Mean-OD-in-superior-frontooccipital-fasciculus-on-FA-skeleton-right_2_0': 0},
)
field_id_25433_mean_od_in_superior_longitudinal_fasciculus_on_fa_skeleton_left_2_0 = TensorMap(
    '25433_Mean-OD-in-superior-longitudinal-fasciculus-on-FA-skeleton-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25433_Mean-OD-in-superior-longitudinal-fasciculus-on-FA-skeleton-left_2_0': 0},
)
field_id_25432_mean_od_in_superior_longitudinal_fasciculus_on_fa_skeleton_right_2_0 = TensorMap(
    '25432_Mean-OD-in-superior-longitudinal-fasciculus-on-FA-skeleton-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25432_Mean-OD-in-superior-longitudinal-fasciculus-on-FA-skeleton-right_2_0': 0},
)
field_id_25431_mean_od_in_fornix_cresstria_terminalis_on_fa_skeleton_left_2_0 = TensorMap(
    '25431_Mean-OD-in-fornix-cresstria-terminalis-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25431_Mean-OD-in-fornix-cresstria-terminalis-on-FA-skeleton-left_2_0': 0},
)
field_id_25430_mean_od_in_fornix_cresstria_terminalis_on_fa_skeleton_right_2_0 = TensorMap(
    '25430_Mean-OD-in-fornix-cresstria-terminalis-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25430_Mean-OD-in-fornix-cresstria-terminalis-on-FA-skeleton-right_2_0': 0},
)
field_id_25429_mean_od_in_cingulum_hippocampus_on_fa_skeleton_left_2_0 = TensorMap(
    '25429_Mean-OD-in-cingulum-hippocampus-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25429_Mean-OD-in-cingulum-hippocampus-on-FA-skeleton-left_2_0': 0},
)
field_id_25428_mean_od_in_cingulum_hippocampus_on_fa_skeleton_right_2_0 = TensorMap(
    '25428_Mean-OD-in-cingulum-hippocampus-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25428_Mean-OD-in-cingulum-hippocampus-on-FA-skeleton-right_2_0': 0},
)
field_id_25427_mean_od_in_cingulum_cingulate_gyrus_on_fa_skeleton_left_2_0 = TensorMap(
    '25427_Mean-OD-in-cingulum-cingulate-gyrus-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25427_Mean-OD-in-cingulum-cingulate-gyrus-on-FA-skeleton-left_2_0': 0},
)
field_id_25426_mean_od_in_cingulum_cingulate_gyrus_on_fa_skeleton_right_2_0 = TensorMap(
    '25426_Mean-OD-in-cingulum-cingulate-gyrus-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25426_Mean-OD-in-cingulum-cingulate-gyrus-on-FA-skeleton-right_2_0': 0},
)
field_id_25425_mean_od_in_external_capsule_on_fa_skeleton_left_2_0 = TensorMap(
    '25425_Mean-OD-in-external-capsule-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25425_Mean-OD-in-external-capsule-on-FA-skeleton-left_2_0': 0},
)
field_id_25424_mean_od_in_external_capsule_on_fa_skeleton_right_2_0 = TensorMap(
    '25424_Mean-OD-in-external-capsule-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25424_Mean-OD-in-external-capsule-on-FA-skeleton-right_2_0': 0},
)
field_id_25423_mean_od_in_sagittal_stratum_on_fa_skeleton_left_2_0 = TensorMap(
    '25423_Mean-OD-in-sagittal-stratum-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25423_Mean-OD-in-sagittal-stratum-on-FA-skeleton-left_2_0': 0},
)
field_id_25422_mean_od_in_sagittal_stratum_on_fa_skeleton_right_2_0 = TensorMap(
    '25422_Mean-OD-in-sagittal-stratum-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25422_Mean-OD-in-sagittal-stratum-on-FA-skeleton-right_2_0': 0},
)
field_id_25421_mean_od_in_posterior_thalamic_radiation_on_fa_skeleton_left_2_0 = TensorMap(
    '25421_Mean-OD-in-posterior-thalamic-radiation-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25421_Mean-OD-in-posterior-thalamic-radiation-on-FA-skeleton-left_2_0': 0},
)
field_id_25420_mean_od_in_posterior_thalamic_radiation_on_fa_skeleton_right_2_0 = TensorMap(
    '25420_Mean-OD-in-posterior-thalamic-radiation-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25420_Mean-OD-in-posterior-thalamic-radiation-on-FA-skeleton-right_2_0': 0},
)
field_id_25419_mean_od_in_posterior_corona_radiata_on_fa_skeleton_left_2_0 = TensorMap(
    '25419_Mean-OD-in-posterior-corona-radiata-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25419_Mean-OD-in-posterior-corona-radiata-on-FA-skeleton-left_2_0': 0},
)
field_id_25418_mean_od_in_posterior_corona_radiata_on_fa_skeleton_right_2_0 = TensorMap(
    '25418_Mean-OD-in-posterior-corona-radiata-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25418_Mean-OD-in-posterior-corona-radiata-on-FA-skeleton-right_2_0': 0},
)
field_id_25417_mean_od_in_superior_corona_radiata_on_fa_skeleton_left_2_0 = TensorMap(
    '25417_Mean-OD-in-superior-corona-radiata-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25417_Mean-OD-in-superior-corona-radiata-on-FA-skeleton-left_2_0': 0},
)
field_id_25416_mean_od_in_superior_corona_radiata_on_fa_skeleton_right_2_0 = TensorMap(
    '25416_Mean-OD-in-superior-corona-radiata-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25416_Mean-OD-in-superior-corona-radiata-on-FA-skeleton-right_2_0': 0},
)
field_id_25415_mean_od_in_anterior_corona_radiata_on_fa_skeleton_left_2_0 = TensorMap(
    '25415_Mean-OD-in-anterior-corona-radiata-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25415_Mean-OD-in-anterior-corona-radiata-on-FA-skeleton-left_2_0': 0},
)
field_id_25414_mean_od_in_anterior_corona_radiata_on_fa_skeleton_right_2_0 = TensorMap(
    '25414_Mean-OD-in-anterior-corona-radiata-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25414_Mean-OD-in-anterior-corona-radiata-on-FA-skeleton-right_2_0': 0},
)
field_id_25413_mean_od_in_retrolenticular_part_of_internal_capsule_on_fa_skeleton_left_2_0 = TensorMap(
    '25413_Mean-OD-in-retrolenticular-part-of-internal-capsule-on-FA-skeleton-left_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'25413_Mean-OD-in-retrolenticular-part-of-internal-capsule-on-FA-skeleton-left_2_0': 0},
)
field_id_25412_mean_od_in_retrolenticular_part_of_internal_capsule_on_fa_skeleton_right_2_0 = TensorMap(
    '25412_Mean-OD-in-retrolenticular-part-of-internal-capsule-on-FA-skeleton-right_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'25412_Mean-OD-in-retrolenticular-part-of-internal-capsule-on-FA-skeleton-right_2_0': 0},
)
field_id_25411_mean_od_in_posterior_limb_of_internal_capsule_on_fa_skeleton_left_2_0 = TensorMap(
    '25411_Mean-OD-in-posterior-limb-of-internal-capsule-on-FA-skeleton-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25411_Mean-OD-in-posterior-limb-of-internal-capsule-on-FA-skeleton-left_2_0': 0},
)
field_id_25410_mean_od_in_posterior_limb_of_internal_capsule_on_fa_skeleton_right_2_0 = TensorMap(
    '25410_Mean-OD-in-posterior-limb-of-internal-capsule-on-FA-skeleton-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25410_Mean-OD-in-posterior-limb-of-internal-capsule-on-FA-skeleton-right_2_0': 0},
)
field_id_25409_mean_od_in_anterior_limb_of_internal_capsule_on_fa_skeleton_left_2_0 = TensorMap(
    '25409_Mean-OD-in-anterior-limb-of-internal-capsule-on-FA-skeleton-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25409_Mean-OD-in-anterior-limb-of-internal-capsule-on-FA-skeleton-left_2_0': 0},
)
field_id_25408_mean_od_in_anterior_limb_of_internal_capsule_on_fa_skeleton_right_2_0 = TensorMap(
    '25408_Mean-OD-in-anterior-limb-of-internal-capsule-on-FA-skeleton-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25408_Mean-OD-in-anterior-limb-of-internal-capsule-on-FA-skeleton-right_2_0': 0},
)
field_id_25407_mean_od_in_cerebral_peduncle_on_fa_skeleton_left_2_0 = TensorMap(
    '25407_Mean-OD-in-cerebral-peduncle-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25407_Mean-OD-in-cerebral-peduncle-on-FA-skeleton-left_2_0': 0},
)
field_id_25406_mean_od_in_cerebral_peduncle_on_fa_skeleton_right_2_0 = TensorMap(
    '25406_Mean-OD-in-cerebral-peduncle-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25406_Mean-OD-in-cerebral-peduncle-on-FA-skeleton-right_2_0': 0},
)
field_id_25405_mean_od_in_superior_cerebellar_peduncle_on_fa_skeleton_left_2_0 = TensorMap(
    '25405_Mean-OD-in-superior-cerebellar-peduncle-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25405_Mean-OD-in-superior-cerebellar-peduncle-on-FA-skeleton-left_2_0': 0},
)
field_id_25404_mean_od_in_superior_cerebellar_peduncle_on_fa_skeleton_right_2_0 = TensorMap(
    '25404_Mean-OD-in-superior-cerebellar-peduncle-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25404_Mean-OD-in-superior-cerebellar-peduncle-on-FA-skeleton-right_2_0': 0},
)
field_id_25403_mean_od_in_inferior_cerebellar_peduncle_on_fa_skeleton_left_2_0 = TensorMap(
    '25403_Mean-OD-in-inferior-cerebellar-peduncle-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25403_Mean-OD-in-inferior-cerebellar-peduncle-on-FA-skeleton-left_2_0': 0},
)
field_id_25402_mean_od_in_inferior_cerebellar_peduncle_on_fa_skeleton_right_2_0 = TensorMap(
    '25402_Mean-OD-in-inferior-cerebellar-peduncle-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25402_Mean-OD-in-inferior-cerebellar-peduncle-on-FA-skeleton-right_2_0': 0},
)
field_id_25401_mean_od_in_medial_lemniscus_on_fa_skeleton_left_2_0 = TensorMap(
    '25401_Mean-OD-in-medial-lemniscus-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25401_Mean-OD-in-medial-lemniscus-on-FA-skeleton-left_2_0': 0},
)
field_id_25400_mean_od_in_medial_lemniscus_on_fa_skeleton_right_2_0 = TensorMap(
    '25400_Mean-OD-in-medial-lemniscus-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25400_Mean-OD-in-medial-lemniscus-on-FA-skeleton-right_2_0': 0},
)
field_id_25399_mean_od_in_corticospinal_tract_on_fa_skeleton_left_2_0 = TensorMap(
    '25399_Mean-OD-in-corticospinal-tract-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25399_Mean-OD-in-corticospinal-tract-on-FA-skeleton-left_2_0': 0},
)
field_id_25398_mean_od_in_corticospinal_tract_on_fa_skeleton_right_2_0 = TensorMap(
    '25398_Mean-OD-in-corticospinal-tract-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25398_Mean-OD-in-corticospinal-tract-on-FA-skeleton-right_2_0': 0},
)
field_id_25397_mean_od_in_fornix_on_fa_skeleton_2_0 = TensorMap(
    '25397_Mean-OD-in-fornix-on-FA-skeleton_2_0',
    path_prefix='continuous', loss='logcosh', channel_map={
        '25397_Mean-OD-in-fornix-on-FA-skeleton_2_0': 0,
    },
)
field_id_25396_mean_od_in_splenium_of_corpus_callosum_on_fa_skeleton_2_0 = TensorMap(
    '25396_Mean-OD-in-splenium-of-corpus-callosum-on-FA-skeleton_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25396_Mean-OD-in-splenium-of-corpus-callosum-on-FA-skeleton_2_0': 0},
)
field_id_25395_mean_od_in_body_of_corpus_callosum_on_fa_skeleton_2_0 = TensorMap(
    '25395_Mean-OD-in-body-of-corpus-callosum-on-FA-skeleton_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25395_Mean-OD-in-body-of-corpus-callosum-on-FA-skeleton_2_0': 0},
)
field_id_25394_mean_od_in_genu_of_corpus_callosum_on_fa_skeleton_2_0 = TensorMap(
    '25394_Mean-OD-in-genu-of-corpus-callosum-on-FA-skeleton_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25394_Mean-OD-in-genu-of-corpus-callosum-on-FA-skeleton_2_0': 0},
)
field_id_25393_mean_od_in_pontine_crossing_tract_on_fa_skeleton_2_0 = TensorMap(
    '25393_Mean-OD-in-pontine-crossing-tract-on-FA-skeleton_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25393_Mean-OD-in-pontine-crossing-tract-on-FA-skeleton_2_0': 0},
)
field_id_25392_mean_od_in_middle_cerebellar_peduncle_on_fa_skeleton_2_0 = TensorMap(
    '25392_Mean-OD-in-middle-cerebellar-peduncle-on-FA-skeleton_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25392_Mean-OD-in-middle-cerebellar-peduncle-on-FA-skeleton_2_0': 0},
)
field_id_25391_mean_icvf_in_tapetum_on_fa_skeleton_left_2_0 = TensorMap(
    '25391_Mean-ICVF-in-tapetum-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25391_Mean-ICVF-in-tapetum-on-FA-skeleton-left_2_0': 0},
)
field_id_25390_mean_icvf_in_tapetum_on_fa_skeleton_right_2_0 = TensorMap(
    '25390_Mean-ICVF-in-tapetum-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25390_Mean-ICVF-in-tapetum-on-FA-skeleton-right_2_0': 0},
)
field_id_25389_mean_icvf_in_uncinate_fasciculus_on_fa_skeleton_left_2_0 = TensorMap(
    '25389_Mean-ICVF-in-uncinate-fasciculus-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25389_Mean-ICVF-in-uncinate-fasciculus-on-FA-skeleton-left_2_0': 0},
)
field_id_25388_mean_icvf_in_uncinate_fasciculus_on_fa_skeleton_right_2_0 = TensorMap(
    '25388_Mean-ICVF-in-uncinate-fasciculus-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25388_Mean-ICVF-in-uncinate-fasciculus-on-FA-skeleton-right_2_0': 0},
)
field_id_25387_mean_icvf_in_superior_frontooccipital_fasciculus_on_fa_skeleton_left_2_0 = TensorMap(
    '25387_Mean-ICVF-in-superior-frontooccipital-fasciculus-on-FA-skeleton-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25387_Mean-ICVF-in-superior-frontooccipital-fasciculus-on-FA-skeleton-left_2_0': 0},
)
field_id_25386_mean_icvf_in_superior_frontooccipital_fasciculus_on_fa_skeleton_right_2_0 = TensorMap(
    '25386_Mean-ICVF-in-superior-frontooccipital-fasciculus-on-FA-skeleton-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25386_Mean-ICVF-in-superior-frontooccipital-fasciculus-on-FA-skeleton-right_2_0': 0},
)
field_id_25385_mean_icvf_in_superior_longitudinal_fasciculus_on_fa_skeleton_left_2_0 = TensorMap(
    '25385_Mean-ICVF-in-superior-longitudinal-fasciculus-on-FA-skeleton-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25385_Mean-ICVF-in-superior-longitudinal-fasciculus-on-FA-skeleton-left_2_0': 0},
)
field_id_25384_mean_icvf_in_superior_longitudinal_fasciculus_on_fa_skeleton_right_2_0 = TensorMap(
    '25384_Mean-ICVF-in-superior-longitudinal-fasciculus-on-FA-skeleton-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25384_Mean-ICVF-in-superior-longitudinal-fasciculus-on-FA-skeleton-right_2_0': 0},
)
field_id_25383_mean_icvf_in_fornix_cresstria_terminalis_on_fa_skeleton_left_2_0 = TensorMap(
    '25383_Mean-ICVF-in-fornix-cresstria-terminalis-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25383_Mean-ICVF-in-fornix-cresstria-terminalis-on-FA-skeleton-left_2_0': 0},
)
field_id_25382_mean_icvf_in_fornix_cresstria_terminalis_on_fa_skeleton_right_2_0 = TensorMap(
    '25382_Mean-ICVF-in-fornix-cresstria-terminalis-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25382_Mean-ICVF-in-fornix-cresstria-terminalis-on-FA-skeleton-right_2_0': 0},
)
field_id_25381_mean_icvf_in_cingulum_hippocampus_on_fa_skeleton_left_2_0 = TensorMap(
    '25381_Mean-ICVF-in-cingulum-hippocampus-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25381_Mean-ICVF-in-cingulum-hippocampus-on-FA-skeleton-left_2_0': 0},
)
field_id_25380_mean_icvf_in_cingulum_hippocampus_on_fa_skeleton_right_2_0 = TensorMap(
    '25380_Mean-ICVF-in-cingulum-hippocampus-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25380_Mean-ICVF-in-cingulum-hippocampus-on-FA-skeleton-right_2_0': 0},
)
field_id_25379_mean_icvf_in_cingulum_cingulate_gyrus_on_fa_skeleton_left_2_0 = TensorMap(
    '25379_Mean-ICVF-in-cingulum-cingulate-gyrus-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25379_Mean-ICVF-in-cingulum-cingulate-gyrus-on-FA-skeleton-left_2_0': 0},
)
field_id_25378_mean_icvf_in_cingulum_cingulate_gyrus_on_fa_skeleton_right_2_0 = TensorMap(
    '25378_Mean-ICVF-in-cingulum-cingulate-gyrus-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25378_Mean-ICVF-in-cingulum-cingulate-gyrus-on-FA-skeleton-right_2_0': 0},
)
field_id_25377_mean_icvf_in_external_capsule_on_fa_skeleton_left_2_0 = TensorMap(
    '25377_Mean-ICVF-in-external-capsule-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25377_Mean-ICVF-in-external-capsule-on-FA-skeleton-left_2_0': 0},
)
field_id_25376_mean_icvf_in_external_capsule_on_fa_skeleton_right_2_0 = TensorMap(
    '25376_Mean-ICVF-in-external-capsule-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25376_Mean-ICVF-in-external-capsule-on-FA-skeleton-right_2_0': 0},
)
field_id_25375_mean_icvf_in_sagittal_stratum_on_fa_skeleton_left_2_0 = TensorMap(
    '25375_Mean-ICVF-in-sagittal-stratum-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25375_Mean-ICVF-in-sagittal-stratum-on-FA-skeleton-left_2_0': 0},
)
field_id_25374_mean_icvf_in_sagittal_stratum_on_fa_skeleton_right_2_0 = TensorMap(
    '25374_Mean-ICVF-in-sagittal-stratum-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25374_Mean-ICVF-in-sagittal-stratum-on-FA-skeleton-right_2_0': 0},
)
field_id_25373_mean_icvf_in_posterior_thalamic_radiation_on_fa_skeleton_left_2_0 = TensorMap(
    '25373_Mean-ICVF-in-posterior-thalamic-radiation-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25373_Mean-ICVF-in-posterior-thalamic-radiation-on-FA-skeleton-left_2_0': 0},
)
field_id_25372_mean_icvf_in_posterior_thalamic_radiation_on_fa_skeleton_right_2_0 = TensorMap(
    '25372_Mean-ICVF-in-posterior-thalamic-radiation-on-FA-skeleton-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25372_Mean-ICVF-in-posterior-thalamic-radiation-on-FA-skeleton-right_2_0': 0},
)
field_id_25371_mean_icvf_in_posterior_corona_radiata_on_fa_skeleton_left_2_0 = TensorMap(
    '25371_Mean-ICVF-in-posterior-corona-radiata-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25371_Mean-ICVF-in-posterior-corona-radiata-on-FA-skeleton-left_2_0': 0},
)
field_id_25370_mean_icvf_in_posterior_corona_radiata_on_fa_skeleton_right_2_0 = TensorMap(
    '25370_Mean-ICVF-in-posterior-corona-radiata-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25370_Mean-ICVF-in-posterior-corona-radiata-on-FA-skeleton-right_2_0': 0},
)
field_id_25369_mean_icvf_in_superior_corona_radiata_on_fa_skeleton_left_2_0 = TensorMap(
    '25369_Mean-ICVF-in-superior-corona-radiata-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25369_Mean-ICVF-in-superior-corona-radiata-on-FA-skeleton-left_2_0': 0},
)
field_id_25368_mean_icvf_in_superior_corona_radiata_on_fa_skeleton_right_2_0 = TensorMap(
    '25368_Mean-ICVF-in-superior-corona-radiata-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25368_Mean-ICVF-in-superior-corona-radiata-on-FA-skeleton-right_2_0': 0},
)
field_id_25367_mean_icvf_in_anterior_corona_radiata_on_fa_skeleton_left_2_0 = TensorMap(
    '25367_Mean-ICVF-in-anterior-corona-radiata-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25367_Mean-ICVF-in-anterior-corona-radiata-on-FA-skeleton-left_2_0': 0},
)
field_id_25366_mean_icvf_in_anterior_corona_radiata_on_fa_skeleton_right_2_0 = TensorMap(
    '25366_Mean-ICVF-in-anterior-corona-radiata-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25366_Mean-ICVF-in-anterior-corona-radiata-on-FA-skeleton-right_2_0': 0},
)
field_id_25365_mean_icvf_in_retrolenticular_part_of_internal_capsule_on_fa_skeleton_left_2_0 = TensorMap(
    '25365_Mean-ICVF-in-retrolenticular-part-of-internal-capsule-on-FA-skeleton-left_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'25365_Mean-ICVF-in-retrolenticular-part-of-internal-capsule-on-FA-skeleton-left_2_0': 0},
)
field_id_25364_mean_icvf_in_retrolenticular_part_of_internal_capsule_on_fa_skeleton_right_2_0 = TensorMap(
    '25364_Mean-ICVF-in-retrolenticular-part-of-internal-capsule-on-FA-skeleton-right_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'25364_Mean-ICVF-in-retrolenticular-part-of-internal-capsule-on-FA-skeleton-right_2_0': 0},
)
field_id_25363_mean_icvf_in_posterior_limb_of_internal_capsule_on_fa_skeleton_left_2_0 = TensorMap(
    '25363_Mean-ICVF-in-posterior-limb-of-internal-capsule-on-FA-skeleton-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25363_Mean-ICVF-in-posterior-limb-of-internal-capsule-on-FA-skeleton-left_2_0': 0},
)
field_id_25362_mean_icvf_in_posterior_limb_of_internal_capsule_on_fa_skeleton_right_2_0 = TensorMap(
    '25362_Mean-ICVF-in-posterior-limb-of-internal-capsule-on-FA-skeleton-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25362_Mean-ICVF-in-posterior-limb-of-internal-capsule-on-FA-skeleton-right_2_0': 0},
)
field_id_25361_mean_icvf_in_anterior_limb_of_internal_capsule_on_fa_skeleton_left_2_0 = TensorMap(
    '25361_Mean-ICVF-in-anterior-limb-of-internal-capsule-on-FA-skeleton-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25361_Mean-ICVF-in-anterior-limb-of-internal-capsule-on-FA-skeleton-left_2_0': 0},
)
field_id_25360_mean_icvf_in_anterior_limb_of_internal_capsule_on_fa_skeleton_right_2_0 = TensorMap(
    '25360_Mean-ICVF-in-anterior-limb-of-internal-capsule-on-FA-skeleton-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25360_Mean-ICVF-in-anterior-limb-of-internal-capsule-on-FA-skeleton-right_2_0': 0},
)
field_id_25359_mean_icvf_in_cerebral_peduncle_on_fa_skeleton_left_2_0 = TensorMap(
    '25359_Mean-ICVF-in-cerebral-peduncle-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25359_Mean-ICVF-in-cerebral-peduncle-on-FA-skeleton-left_2_0': 0},
)
field_id_25358_mean_icvf_in_cerebral_peduncle_on_fa_skeleton_right_2_0 = TensorMap(
    '25358_Mean-ICVF-in-cerebral-peduncle-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25358_Mean-ICVF-in-cerebral-peduncle-on-FA-skeleton-right_2_0': 0},
)
field_id_25357_mean_icvf_in_superior_cerebellar_peduncle_on_fa_skeleton_left_2_0 = TensorMap(
    '25357_Mean-ICVF-in-superior-cerebellar-peduncle-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25357_Mean-ICVF-in-superior-cerebellar-peduncle-on-FA-skeleton-left_2_0': 0},
)
field_id_25356_mean_icvf_in_superior_cerebellar_peduncle_on_fa_skeleton_right_2_0 = TensorMap(
    '25356_Mean-ICVF-in-superior-cerebellar-peduncle-on-FA-skeleton-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25356_Mean-ICVF-in-superior-cerebellar-peduncle-on-FA-skeleton-right_2_0': 0},
)
field_id_25355_mean_icvf_in_inferior_cerebellar_peduncle_on_fa_skeleton_left_2_0 = TensorMap(
    '25355_Mean-ICVF-in-inferior-cerebellar-peduncle-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25355_Mean-ICVF-in-inferior-cerebellar-peduncle-on-FA-skeleton-left_2_0': 0},
)
field_id_25354_mean_icvf_in_inferior_cerebellar_peduncle_on_fa_skeleton_right_2_0 = TensorMap(
    '25354_Mean-ICVF-in-inferior-cerebellar-peduncle-on-FA-skeleton-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25354_Mean-ICVF-in-inferior-cerebellar-peduncle-on-FA-skeleton-right_2_0': 0},
)
field_id_25353_mean_icvf_in_medial_lemniscus_on_fa_skeleton_left_2_0 = TensorMap(
    '25353_Mean-ICVF-in-medial-lemniscus-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25353_Mean-ICVF-in-medial-lemniscus-on-FA-skeleton-left_2_0': 0},
)
field_id_25352_mean_icvf_in_medial_lemniscus_on_fa_skeleton_right_2_0 = TensorMap(
    '25352_Mean-ICVF-in-medial-lemniscus-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25352_Mean-ICVF-in-medial-lemniscus-on-FA-skeleton-right_2_0': 0},
)
field_id_25351_mean_icvf_in_corticospinal_tract_on_fa_skeleton_left_2_0 = TensorMap(
    '25351_Mean-ICVF-in-corticospinal-tract-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25351_Mean-ICVF-in-corticospinal-tract-on-FA-skeleton-left_2_0': 0},
)
field_id_25350_mean_icvf_in_corticospinal_tract_on_fa_skeleton_right_2_0 = TensorMap(
    '25350_Mean-ICVF-in-corticospinal-tract-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25350_Mean-ICVF-in-corticospinal-tract-on-FA-skeleton-right_2_0': 0},
)
field_id_25349_mean_icvf_in_fornix_on_fa_skeleton_2_0 = TensorMap(
    '25349_Mean-ICVF-in-fornix-on-FA-skeleton_2_0',
    path_prefix='continuous', loss='logcosh',
    channel_map={
        '25349_Mean-ICVF-in-fornix-on-FA-skeleton_2_0': 0,
    },
)
field_id_25348_mean_icvf_in_splenium_of_corpus_callosum_on_fa_skeleton_2_0 = TensorMap(
    '25348_Mean-ICVF-in-splenium-of-corpus-callosum-on-FA-skeleton_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25348_Mean-ICVF-in-splenium-of-corpus-callosum-on-FA-skeleton_2_0': 0},
)
field_id_25347_mean_icvf_in_body_of_corpus_callosum_on_fa_skeleton_2_0 = TensorMap(
    '25347_Mean-ICVF-in-body-of-corpus-callosum-on-FA-skeleton_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25347_Mean-ICVF-in-body-of-corpus-callosum-on-FA-skeleton_2_0': 0},
)
field_id_25346_mean_icvf_in_genu_of_corpus_callosum_on_fa_skeleton_2_0 = TensorMap(
    '25346_Mean-ICVF-in-genu-of-corpus-callosum-on-FA-skeleton_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25346_Mean-ICVF-in-genu-of-corpus-callosum-on-FA-skeleton_2_0': 0},
)
field_id_25345_mean_icvf_in_pontine_crossing_tract_on_fa_skeleton_2_0 = TensorMap(
    '25345_Mean-ICVF-in-pontine-crossing-tract-on-FA-skeleton_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25345_Mean-ICVF-in-pontine-crossing-tract-on-FA-skeleton_2_0': 0},
)
field_id_25344_mean_icvf_in_middle_cerebellar_peduncle_on_fa_skeleton_2_0 = TensorMap(
    '25344_Mean-ICVF-in-middle-cerebellar-peduncle-on-FA-skeleton_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25344_Mean-ICVF-in-middle-cerebellar-peduncle-on-FA-skeleton_2_0': 0},
)
field_id_25343_mean_l3_in_tapetum_on_fa_skeleton_left_2_0 = TensorMap(
    '25343_Mean-L3-in-tapetum-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25343_Mean-L3-in-tapetum-on-FA-skeleton-left_2_0': 0},
)
field_id_25342_mean_l3_in_tapetum_on_fa_skeleton_right_2_0 = TensorMap(
    '25342_Mean-L3-in-tapetum-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25342_Mean-L3-in-tapetum-on-FA-skeleton-right_2_0': 0},
)
field_id_25341_mean_l3_in_uncinate_fasciculus_on_fa_skeleton_left_2_0 = TensorMap(
    '25341_Mean-L3-in-uncinate-fasciculus-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25341_Mean-L3-in-uncinate-fasciculus-on-FA-skeleton-left_2_0': 0},
)
field_id_25340_mean_l3_in_uncinate_fasciculus_on_fa_skeleton_right_2_0 = TensorMap(
    '25340_Mean-L3-in-uncinate-fasciculus-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25340_Mean-L3-in-uncinate-fasciculus-on-FA-skeleton-right_2_0': 0},
)
field_id_25339_mean_l3_in_superior_frontooccipital_fasciculus_on_fa_skeleton_left_2_0 = TensorMap(
    '25339_Mean-L3-in-superior-frontooccipital-fasciculus-on-FA-skeleton-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25339_Mean-L3-in-superior-frontooccipital-fasciculus-on-FA-skeleton-left_2_0': 0},
)
field_id_25338_mean_l3_in_superior_frontooccipital_fasciculus_on_fa_skeleton_right_2_0 = TensorMap(
    '25338_Mean-L3-in-superior-frontooccipital-fasciculus-on-FA-skeleton-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25338_Mean-L3-in-superior-frontooccipital-fasciculus-on-FA-skeleton-right_2_0': 0},
)
field_id_25337_mean_l3_in_superior_longitudinal_fasciculus_on_fa_skeleton_left_2_0 = TensorMap(
    '25337_Mean-L3-in-superior-longitudinal-fasciculus-on-FA-skeleton-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25337_Mean-L3-in-superior-longitudinal-fasciculus-on-FA-skeleton-left_2_0': 0},
)
field_id_25336_mean_l3_in_superior_longitudinal_fasciculus_on_fa_skeleton_right_2_0 = TensorMap(
    '25336_Mean-L3-in-superior-longitudinal-fasciculus-on-FA-skeleton-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25336_Mean-L3-in-superior-longitudinal-fasciculus-on-FA-skeleton-right_2_0': 0},
)
field_id_25335_mean_l3_in_fornix_cresstria_terminalis_on_fa_skeleton_left_2_0 = TensorMap(
    '25335_Mean-L3-in-fornix-cresstria-terminalis-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25335_Mean-L3-in-fornix-cresstria-terminalis-on-FA-skeleton-left_2_0': 0},
)
field_id_25334_mean_l3_in_fornix_cresstria_terminalis_on_fa_skeleton_right_2_0 = TensorMap(
    '25334_Mean-L3-in-fornix-cresstria-terminalis-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25334_Mean-L3-in-fornix-cresstria-terminalis-on-FA-skeleton-right_2_0': 0},
)
field_id_25333_mean_l3_in_cingulum_hippocampus_on_fa_skeleton_left_2_0 = TensorMap(
    '25333_Mean-L3-in-cingulum-hippocampus-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25333_Mean-L3-in-cingulum-hippocampus-on-FA-skeleton-left_2_0': 0},
)
field_id_25332_mean_l3_in_cingulum_hippocampus_on_fa_skeleton_right_2_0 = TensorMap(
    '25332_Mean-L3-in-cingulum-hippocampus-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25332_Mean-L3-in-cingulum-hippocampus-on-FA-skeleton-right_2_0': 0},
)
field_id_25331_mean_l3_in_cingulum_cingulate_gyrus_on_fa_skeleton_left_2_0 = TensorMap(
    '25331_Mean-L3-in-cingulum-cingulate-gyrus-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25331_Mean-L3-in-cingulum-cingulate-gyrus-on-FA-skeleton-left_2_0': 0},
)
field_id_25330_mean_l3_in_cingulum_cingulate_gyrus_on_fa_skeleton_right_2_0 = TensorMap(
    '25330_Mean-L3-in-cingulum-cingulate-gyrus-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25330_Mean-L3-in-cingulum-cingulate-gyrus-on-FA-skeleton-right_2_0': 0},
)
field_id_25329_mean_l3_in_external_capsule_on_fa_skeleton_left_2_0 = TensorMap(
    '25329_Mean-L3-in-external-capsule-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25329_Mean-L3-in-external-capsule-on-FA-skeleton-left_2_0': 0},
)
field_id_25328_mean_l3_in_external_capsule_on_fa_skeleton_right_2_0 = TensorMap(
    '25328_Mean-L3-in-external-capsule-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25328_Mean-L3-in-external-capsule-on-FA-skeleton-right_2_0': 0},
)
field_id_25327_mean_l3_in_sagittal_stratum_on_fa_skeleton_left_2_0 = TensorMap(
    '25327_Mean-L3-in-sagittal-stratum-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25327_Mean-L3-in-sagittal-stratum-on-FA-skeleton-left_2_0': 0},
)
field_id_25326_mean_l3_in_sagittal_stratum_on_fa_skeleton_right_2_0 = TensorMap(
    '25326_Mean-L3-in-sagittal-stratum-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25326_Mean-L3-in-sagittal-stratum-on-FA-skeleton-right_2_0': 0},
)
field_id_25325_mean_l3_in_posterior_thalamic_radiation_on_fa_skeleton_left_2_0 = TensorMap(
    '25325_Mean-L3-in-posterior-thalamic-radiation-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25325_Mean-L3-in-posterior-thalamic-radiation-on-FA-skeleton-left_2_0': 0},
)
field_id_25324_mean_l3_in_posterior_thalamic_radiation_on_fa_skeleton_right_2_0 = TensorMap(
    '25324_Mean-L3-in-posterior-thalamic-radiation-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25324_Mean-L3-in-posterior-thalamic-radiation-on-FA-skeleton-right_2_0': 0},
)
field_id_25323_mean_l3_in_posterior_corona_radiata_on_fa_skeleton_left_2_0 = TensorMap(
    '25323_Mean-L3-in-posterior-corona-radiata-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25323_Mean-L3-in-posterior-corona-radiata-on-FA-skeleton-left_2_0': 0},
)
field_id_25322_mean_l3_in_posterior_corona_radiata_on_fa_skeleton_right_2_0 = TensorMap(
    '25322_Mean-L3-in-posterior-corona-radiata-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25322_Mean-L3-in-posterior-corona-radiata-on-FA-skeleton-right_2_0': 0},
)
field_id_25321_mean_l3_in_superior_corona_radiata_on_fa_skeleton_left_2_0 = TensorMap(
    '25321_Mean-L3-in-superior-corona-radiata-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25321_Mean-L3-in-superior-corona-radiata-on-FA-skeleton-left_2_0': 0},
)
field_id_25320_mean_l3_in_superior_corona_radiata_on_fa_skeleton_right_2_0 = TensorMap(
    '25320_Mean-L3-in-superior-corona-radiata-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25320_Mean-L3-in-superior-corona-radiata-on-FA-skeleton-right_2_0': 0},
)
field_id_25319_mean_l3_in_anterior_corona_radiata_on_fa_skeleton_left_2_0 = TensorMap(
    '25319_Mean-L3-in-anterior-corona-radiata-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25319_Mean-L3-in-anterior-corona-radiata-on-FA-skeleton-left_2_0': 0},
)
field_id_25318_mean_l3_in_anterior_corona_radiata_on_fa_skeleton_right_2_0 = TensorMap(
    '25318_Mean-L3-in-anterior-corona-radiata-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25318_Mean-L3-in-anterior-corona-radiata-on-FA-skeleton-right_2_0': 0},
)
field_id_25317_mean_l3_in_retrolenticular_part_of_internal_capsule_on_fa_skeleton_left_2_0 = TensorMap(
    '25317_Mean-L3-in-retrolenticular-part-of-internal-capsule-on-FA-skeleton-left_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'25317_Mean-L3-in-retrolenticular-part-of-internal-capsule-on-FA-skeleton-left_2_0': 0},
)
field_id_25316_mean_l3_in_retrolenticular_part_of_internal_capsule_on_fa_skeleton_right_2_0 = TensorMap(
    '25316_Mean-L3-in-retrolenticular-part-of-internal-capsule-on-FA-skeleton-right_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'25316_Mean-L3-in-retrolenticular-part-of-internal-capsule-on-FA-skeleton-right_2_0': 0},
)
field_id_25315_mean_l3_in_posterior_limb_of_internal_capsule_on_fa_skeleton_left_2_0 = TensorMap(
    '25315_Mean-L3-in-posterior-limb-of-internal-capsule-on-FA-skeleton-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25315_Mean-L3-in-posterior-limb-of-internal-capsule-on-FA-skeleton-left_2_0': 0},
)
field_id_25314_mean_l3_in_posterior_limb_of_internal_capsule_on_fa_skeleton_right_2_0 = TensorMap(
    '25314_Mean-L3-in-posterior-limb-of-internal-capsule-on-FA-skeleton-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25314_Mean-L3-in-posterior-limb-of-internal-capsule-on-FA-skeleton-right_2_0': 0},
)
field_id_25313_mean_l3_in_anterior_limb_of_internal_capsule_on_fa_skeleton_left_2_0 = TensorMap(
    '25313_Mean-L3-in-anterior-limb-of-internal-capsule-on-FA-skeleton-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25313_Mean-L3-in-anterior-limb-of-internal-capsule-on-FA-skeleton-left_2_0': 0},
)
field_id_25312_mean_l3_in_anterior_limb_of_internal_capsule_on_fa_skeleton_right_2_0 = TensorMap(
    '25312_Mean-L3-in-anterior-limb-of-internal-capsule-on-FA-skeleton-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25312_Mean-L3-in-anterior-limb-of-internal-capsule-on-FA-skeleton-right_2_0': 0},
)
field_id_25311_mean_l3_in_cerebral_peduncle_on_fa_skeleton_left_2_0 = TensorMap(
    '25311_Mean-L3-in-cerebral-peduncle-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25311_Mean-L3-in-cerebral-peduncle-on-FA-skeleton-left_2_0': 0},
)
field_id_25310_mean_l3_in_cerebral_peduncle_on_fa_skeleton_right_2_0 = TensorMap(
    '25310_Mean-L3-in-cerebral-peduncle-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25310_Mean-L3-in-cerebral-peduncle-on-FA-skeleton-right_2_0': 0},
)
field_id_25309_mean_l3_in_superior_cerebellar_peduncle_on_fa_skeleton_left_2_0 = TensorMap(
    '25309_Mean-L3-in-superior-cerebellar-peduncle-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25309_Mean-L3-in-superior-cerebellar-peduncle-on-FA-skeleton-left_2_0': 0},
)
field_id_25308_mean_l3_in_superior_cerebellar_peduncle_on_fa_skeleton_right_2_0 = TensorMap(
    '25308_Mean-L3-in-superior-cerebellar-peduncle-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25308_Mean-L3-in-superior-cerebellar-peduncle-on-FA-skeleton-right_2_0': 0},
)
field_id_25307_mean_l3_in_inferior_cerebellar_peduncle_on_fa_skeleton_left_2_0 = TensorMap(
    '25307_Mean-L3-in-inferior-cerebellar-peduncle-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25307_Mean-L3-in-inferior-cerebellar-peduncle-on-FA-skeleton-left_2_0': 0},
)
field_id_25306_mean_l3_in_inferior_cerebellar_peduncle_on_fa_skeleton_right_2_0 = TensorMap(
    '25306_Mean-L3-in-inferior-cerebellar-peduncle-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25306_Mean-L3-in-inferior-cerebellar-peduncle-on-FA-skeleton-right_2_0': 0},
)
field_id_25305_mean_l3_in_medial_lemniscus_on_fa_skeleton_left_2_0 = TensorMap(
    '25305_Mean-L3-in-medial-lemniscus-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25305_Mean-L3-in-medial-lemniscus-on-FA-skeleton-left_2_0': 0},
)
field_id_25304_mean_l3_in_medial_lemniscus_on_fa_skeleton_right_2_0 = TensorMap(
    '25304_Mean-L3-in-medial-lemniscus-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25304_Mean-L3-in-medial-lemniscus-on-FA-skeleton-right_2_0': 0},
)
field_id_25303_mean_l3_in_corticospinal_tract_on_fa_skeleton_left_2_0 = TensorMap(
    '25303_Mean-L3-in-corticospinal-tract-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25303_Mean-L3-in-corticospinal-tract-on-FA-skeleton-left_2_0': 0},
)
field_id_25302_mean_l3_in_corticospinal_tract_on_fa_skeleton_right_2_0 = TensorMap(
    '25302_Mean-L3-in-corticospinal-tract-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25302_Mean-L3-in-corticospinal-tract-on-FA-skeleton-right_2_0': 0},
)
field_id_25301_mean_l3_in_fornix_on_fa_skeleton_2_0 = TensorMap(
    '25301_Mean-L3-in-fornix-on-FA-skeleton_2_0',
    path_prefix='continuous', loss='logcosh', channel_map={
        '25301_Mean-L3-in-fornix-on-FA-skeleton_2_0': 0,
    },
)
field_id_25300_mean_l3_in_splenium_of_corpus_callosum_on_fa_skeleton_2_0 = TensorMap(
    '25300_Mean-L3-in-splenium-of-corpus-callosum-on-FA-skeleton_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25300_Mean-L3-in-splenium-of-corpus-callosum-on-FA-skeleton_2_0': 0},
)
field_id_25299_mean_l3_in_body_of_corpus_callosum_on_fa_skeleton_2_0 = TensorMap(
    '25299_Mean-L3-in-body-of-corpus-callosum-on-FA-skeleton_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25299_Mean-L3-in-body-of-corpus-callosum-on-FA-skeleton_2_0': 0},
)
field_id_25298_mean_l3_in_genu_of_corpus_callosum_on_fa_skeleton_2_0 = TensorMap(
    '25298_Mean-L3-in-genu-of-corpus-callosum-on-FA-skeleton_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25298_Mean-L3-in-genu-of-corpus-callosum-on-FA-skeleton_2_0': 0},
)
field_id_25297_mean_l3_in_pontine_crossing_tract_on_fa_skeleton_2_0 = TensorMap(
    '25297_Mean-L3-in-pontine-crossing-tract-on-FA-skeleton_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25297_Mean-L3-in-pontine-crossing-tract-on-FA-skeleton_2_0': 0},
)
field_id_25296_mean_l3_in_middle_cerebellar_peduncle_on_fa_skeleton_2_0 = TensorMap(
    '25296_Mean-L3-in-middle-cerebellar-peduncle-on-FA-skeleton_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25296_Mean-L3-in-middle-cerebellar-peduncle-on-FA-skeleton_2_0': 0},
)
field_id_25295_mean_l2_in_tapetum_on_fa_skeleton_left_2_0 = TensorMap(
    '25295_Mean-L2-in-tapetum-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25295_Mean-L2-in-tapetum-on-FA-skeleton-left_2_0': 0},
)
field_id_25294_mean_l2_in_tapetum_on_fa_skeleton_right_2_0 = TensorMap(
    '25294_Mean-L2-in-tapetum-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25294_Mean-L2-in-tapetum-on-FA-skeleton-right_2_0': 0},
)
field_id_25293_mean_l2_in_uncinate_fasciculus_on_fa_skeleton_left_2_0 = TensorMap(
    '25293_Mean-L2-in-uncinate-fasciculus-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25293_Mean-L2-in-uncinate-fasciculus-on-FA-skeleton-left_2_0': 0},
)
field_id_25292_mean_l2_in_uncinate_fasciculus_on_fa_skeleton_right_2_0 = TensorMap(
    '25292_Mean-L2-in-uncinate-fasciculus-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25292_Mean-L2-in-uncinate-fasciculus-on-FA-skeleton-right_2_0': 0},
)
field_id_25291_mean_l2_in_superior_frontooccipital_fasciculus_on_fa_skeleton_left_2_0 = TensorMap(
    '25291_Mean-L2-in-superior-frontooccipital-fasciculus-on-FA-skeleton-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25291_Mean-L2-in-superior-frontooccipital-fasciculus-on-FA-skeleton-left_2_0': 0},
)
field_id_25290_mean_l2_in_superior_frontooccipital_fasciculus_on_fa_skeleton_right_2_0 = TensorMap(
    '25290_Mean-L2-in-superior-frontooccipital-fasciculus-on-FA-skeleton-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25290_Mean-L2-in-superior-frontooccipital-fasciculus-on-FA-skeleton-right_2_0': 0},
)
field_id_25289_mean_l2_in_superior_longitudinal_fasciculus_on_fa_skeleton_left_2_0 = TensorMap(
    '25289_Mean-L2-in-superior-longitudinal-fasciculus-on-FA-skeleton-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25289_Mean-L2-in-superior-longitudinal-fasciculus-on-FA-skeleton-left_2_0': 0},
)
field_id_25288_mean_l2_in_superior_longitudinal_fasciculus_on_fa_skeleton_right_2_0 = TensorMap(
    '25288_Mean-L2-in-superior-longitudinal-fasciculus-on-FA-skeleton-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25288_Mean-L2-in-superior-longitudinal-fasciculus-on-FA-skeleton-right_2_0': 0},
)
field_id_25287_mean_l2_in_fornix_cresstria_terminalis_on_fa_skeleton_left_2_0 = TensorMap(
    '25287_Mean-L2-in-fornix-cresstria-terminalis-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25287_Mean-L2-in-fornix-cresstria-terminalis-on-FA-skeleton-left_2_0': 0},
)
field_id_25286_mean_l2_in_fornix_cresstria_terminalis_on_fa_skeleton_right_2_0 = TensorMap(
    '25286_Mean-L2-in-fornix-cresstria-terminalis-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25286_Mean-L2-in-fornix-cresstria-terminalis-on-FA-skeleton-right_2_0': 0},
)
field_id_25285_mean_l2_in_cingulum_hippocampus_on_fa_skeleton_left_2_0 = TensorMap(
    '25285_Mean-L2-in-cingulum-hippocampus-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25285_Mean-L2-in-cingulum-hippocampus-on-FA-skeleton-left_2_0': 0},
)
field_id_25284_mean_l2_in_cingulum_hippocampus_on_fa_skeleton_right_2_0 = TensorMap(
    '25284_Mean-L2-in-cingulum-hippocampus-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25284_Mean-L2-in-cingulum-hippocampus-on-FA-skeleton-right_2_0': 0},
)
field_id_25283_mean_l2_in_cingulum_cingulate_gyrus_on_fa_skeleton_left_2_0 = TensorMap(
    '25283_Mean-L2-in-cingulum-cingulate-gyrus-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25283_Mean-L2-in-cingulum-cingulate-gyrus-on-FA-skeleton-left_2_0': 0},
)
field_id_25282_mean_l2_in_cingulum_cingulate_gyrus_on_fa_skeleton_right_2_0 = TensorMap(
    '25282_Mean-L2-in-cingulum-cingulate-gyrus-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25282_Mean-L2-in-cingulum-cingulate-gyrus-on-FA-skeleton-right_2_0': 0},
)
field_id_25281_mean_l2_in_external_capsule_on_fa_skeleton_left_2_0 = TensorMap(
    '25281_Mean-L2-in-external-capsule-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25281_Mean-L2-in-external-capsule-on-FA-skeleton-left_2_0': 0},
)
field_id_25280_mean_l2_in_external_capsule_on_fa_skeleton_right_2_0 = TensorMap(
    '25280_Mean-L2-in-external-capsule-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25280_Mean-L2-in-external-capsule-on-FA-skeleton-right_2_0': 0},
)
field_id_25279_mean_l2_in_sagittal_stratum_on_fa_skeleton_left_2_0 = TensorMap(
    '25279_Mean-L2-in-sagittal-stratum-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25279_Mean-L2-in-sagittal-stratum-on-FA-skeleton-left_2_0': 0},
)
field_id_25278_mean_l2_in_sagittal_stratum_on_fa_skeleton_right_2_0 = TensorMap(
    '25278_Mean-L2-in-sagittal-stratum-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25278_Mean-L2-in-sagittal-stratum-on-FA-skeleton-right_2_0': 0},
)
field_id_25277_mean_l2_in_posterior_thalamic_radiation_on_fa_skeleton_left_2_0 = TensorMap(
    '25277_Mean-L2-in-posterior-thalamic-radiation-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25277_Mean-L2-in-posterior-thalamic-radiation-on-FA-skeleton-left_2_0': 0},
)
field_id_25276_mean_l2_in_posterior_thalamic_radiation_on_fa_skeleton_right_2_0 = TensorMap(
    '25276_Mean-L2-in-posterior-thalamic-radiation-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25276_Mean-L2-in-posterior-thalamic-radiation-on-FA-skeleton-right_2_0': 0},
)
field_id_25275_mean_l2_in_posterior_corona_radiata_on_fa_skeleton_left_2_0 = TensorMap(
    '25275_Mean-L2-in-posterior-corona-radiata-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25275_Mean-L2-in-posterior-corona-radiata-on-FA-skeleton-left_2_0': 0},
)
field_id_25274_mean_l2_in_posterior_corona_radiata_on_fa_skeleton_right_2_0 = TensorMap(
    '25274_Mean-L2-in-posterior-corona-radiata-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25274_Mean-L2-in-posterior-corona-radiata-on-FA-skeleton-right_2_0': 0},
)
field_id_25273_mean_l2_in_superior_corona_radiata_on_fa_skeleton_left_2_0 = TensorMap(
    '25273_Mean-L2-in-superior-corona-radiata-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25273_Mean-L2-in-superior-corona-radiata-on-FA-skeleton-left_2_0': 0},
)
field_id_25272_mean_l2_in_superior_corona_radiata_on_fa_skeleton_right_2_0 = TensorMap(
    '25272_Mean-L2-in-superior-corona-radiata-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25272_Mean-L2-in-superior-corona-radiata-on-FA-skeleton-right_2_0': 0},
)
field_id_25271_mean_l2_in_anterior_corona_radiata_on_fa_skeleton_left_2_0 = TensorMap(
    '25271_Mean-L2-in-anterior-corona-radiata-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25271_Mean-L2-in-anterior-corona-radiata-on-FA-skeleton-left_2_0': 0},
)
field_id_25270_mean_l2_in_anterior_corona_radiata_on_fa_skeleton_right_2_0 = TensorMap(
    '25270_Mean-L2-in-anterior-corona-radiata-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25270_Mean-L2-in-anterior-corona-radiata-on-FA-skeleton-right_2_0': 0},
)
field_id_25269_mean_l2_in_retrolenticular_part_of_internal_capsule_on_fa_skeleton_left_2_0 = TensorMap(
    '25269_Mean-L2-in-retrolenticular-part-of-internal-capsule-on-FA-skeleton-left_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'25269_Mean-L2-in-retrolenticular-part-of-internal-capsule-on-FA-skeleton-left_2_0': 0},
)
field_id_25268_mean_l2_in_retrolenticular_part_of_internal_capsule_on_fa_skeleton_right_2_0 = TensorMap(
    '25268_Mean-L2-in-retrolenticular-part-of-internal-capsule-on-FA-skeleton-right_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'25268_Mean-L2-in-retrolenticular-part-of-internal-capsule-on-FA-skeleton-right_2_0': 0},
)
field_id_25267_mean_l2_in_posterior_limb_of_internal_capsule_on_fa_skeleton_left_2_0 = TensorMap(
    '25267_Mean-L2-in-posterior-limb-of-internal-capsule-on-FA-skeleton-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25267_Mean-L2-in-posterior-limb-of-internal-capsule-on-FA-skeleton-left_2_0': 0},
)
field_id_25266_mean_l2_in_posterior_limb_of_internal_capsule_on_fa_skeleton_right_2_0 = TensorMap(
    '25266_Mean-L2-in-posterior-limb-of-internal-capsule-on-FA-skeleton-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25266_Mean-L2-in-posterior-limb-of-internal-capsule-on-FA-skeleton-right_2_0': 0},
)
field_id_25265_mean_l2_in_anterior_limb_of_internal_capsule_on_fa_skeleton_left_2_0 = TensorMap(
    '25265_Mean-L2-in-anterior-limb-of-internal-capsule-on-FA-skeleton-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25265_Mean-L2-in-anterior-limb-of-internal-capsule-on-FA-skeleton-left_2_0': 0},
)
field_id_25264_mean_l2_in_anterior_limb_of_internal_capsule_on_fa_skeleton_right_2_0 = TensorMap(
    '25264_Mean-L2-in-anterior-limb-of-internal-capsule-on-FA-skeleton-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25264_Mean-L2-in-anterior-limb-of-internal-capsule-on-FA-skeleton-right_2_0': 0},
)
field_id_25263_mean_l2_in_cerebral_peduncle_on_fa_skeleton_left_2_0 = TensorMap(
    '25263_Mean-L2-in-cerebral-peduncle-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25263_Mean-L2-in-cerebral-peduncle-on-FA-skeleton-left_2_0': 0},
)
field_id_25262_mean_l2_in_cerebral_peduncle_on_fa_skeleton_right_2_0 = TensorMap(
    '25262_Mean-L2-in-cerebral-peduncle-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25262_Mean-L2-in-cerebral-peduncle-on-FA-skeleton-right_2_0': 0},
)
field_id_25261_mean_l2_in_superior_cerebellar_peduncle_on_fa_skeleton_left_2_0 = TensorMap(
    '25261_Mean-L2-in-superior-cerebellar-peduncle-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25261_Mean-L2-in-superior-cerebellar-peduncle-on-FA-skeleton-left_2_0': 0},
)
field_id_25260_mean_l2_in_superior_cerebellar_peduncle_on_fa_skeleton_right_2_0 = TensorMap(
    '25260_Mean-L2-in-superior-cerebellar-peduncle-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25260_Mean-L2-in-superior-cerebellar-peduncle-on-FA-skeleton-right_2_0': 0},
)
field_id_25259_mean_l2_in_inferior_cerebellar_peduncle_on_fa_skeleton_left_2_0 = TensorMap(
    '25259_Mean-L2-in-inferior-cerebellar-peduncle-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25259_Mean-L2-in-inferior-cerebellar-peduncle-on-FA-skeleton-left_2_0': 0},
)
field_id_25258_mean_l2_in_inferior_cerebellar_peduncle_on_fa_skeleton_right_2_0 = TensorMap(
    '25258_Mean-L2-in-inferior-cerebellar-peduncle-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25258_Mean-L2-in-inferior-cerebellar-peduncle-on-FA-skeleton-right_2_0': 0},
)
field_id_25257_mean_l2_in_medial_lemniscus_on_fa_skeleton_left_2_0 = TensorMap(
    '25257_Mean-L2-in-medial-lemniscus-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25257_Mean-L2-in-medial-lemniscus-on-FA-skeleton-left_2_0': 0},
)
field_id_25256_mean_l2_in_medial_lemniscus_on_fa_skeleton_right_2_0 = TensorMap(
    '25256_Mean-L2-in-medial-lemniscus-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25256_Mean-L2-in-medial-lemniscus-on-FA-skeleton-right_2_0': 0},
)
field_id_25255_mean_l2_in_corticospinal_tract_on_fa_skeleton_left_2_0 = TensorMap(
    '25255_Mean-L2-in-corticospinal-tract-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25255_Mean-L2-in-corticospinal-tract-on-FA-skeleton-left_2_0': 0},
)
field_id_25254_mean_l2_in_corticospinal_tract_on_fa_skeleton_right_2_0 = TensorMap(
    '25254_Mean-L2-in-corticospinal-tract-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25254_Mean-L2-in-corticospinal-tract-on-FA-skeleton-right_2_0': 0},
)
field_id_25253_mean_l2_in_fornix_on_fa_skeleton_2_0 = TensorMap(
    '25253_Mean-L2-in-fornix-on-FA-skeleton_2_0',
    path_prefix='continuous', loss='logcosh', channel_map={
        '25253_Mean-L2-in-fornix-on-FA-skeleton_2_0': 0,
    },
)
field_id_25252_mean_l2_in_splenium_of_corpus_callosum_on_fa_skeleton_2_0 = TensorMap(
    '25252_Mean-L2-in-splenium-of-corpus-callosum-on-FA-skeleton_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25252_Mean-L2-in-splenium-of-corpus-callosum-on-FA-skeleton_2_0': 0},
)
field_id_25251_mean_l2_in_body_of_corpus_callosum_on_fa_skeleton_2_0 = TensorMap(
    '25251_Mean-L2-in-body-of-corpus-callosum-on-FA-skeleton_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25251_Mean-L2-in-body-of-corpus-callosum-on-FA-skeleton_2_0': 0},
)
field_id_25250_mean_l2_in_genu_of_corpus_callosum_on_fa_skeleton_2_0 = TensorMap(
    '25250_Mean-L2-in-genu-of-corpus-callosum-on-FA-skeleton_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25250_Mean-L2-in-genu-of-corpus-callosum-on-FA-skeleton_2_0': 0},
)
field_id_25249_mean_l2_in_pontine_crossing_tract_on_fa_skeleton_2_0 = TensorMap(
    '25249_Mean-L2-in-pontine-crossing-tract-on-FA-skeleton_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25249_Mean-L2-in-pontine-crossing-tract-on-FA-skeleton_2_0': 0},
)
field_id_25248_mean_l2_in_middle_cerebellar_peduncle_on_fa_skeleton_2_0 = TensorMap(
    '25248_Mean-L2-in-middle-cerebellar-peduncle-on-FA-skeleton_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25248_Mean-L2-in-middle-cerebellar-peduncle-on-FA-skeleton_2_0': 0},
)
field_id_25247_mean_l1_in_tapetum_on_fa_skeleton_left_2_0 = TensorMap(
    '25247_Mean-L1-in-tapetum-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25247_Mean-L1-in-tapetum-on-FA-skeleton-left_2_0': 0},
)
field_id_25246_mean_l1_in_tapetum_on_fa_skeleton_right_2_0 = TensorMap(
    '25246_Mean-L1-in-tapetum-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25246_Mean-L1-in-tapetum-on-FA-skeleton-right_2_0': 0},
)
field_id_25245_mean_l1_in_uncinate_fasciculus_on_fa_skeleton_left_2_0 = TensorMap(
    '25245_Mean-L1-in-uncinate-fasciculus-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25245_Mean-L1-in-uncinate-fasciculus-on-FA-skeleton-left_2_0': 0},
)
field_id_25244_mean_l1_in_uncinate_fasciculus_on_fa_skeleton_right_2_0 = TensorMap(
    '25244_Mean-L1-in-uncinate-fasciculus-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25244_Mean-L1-in-uncinate-fasciculus-on-FA-skeleton-right_2_0': 0},
)
field_id_25243_mean_l1_in_superior_frontooccipital_fasciculus_on_fa_skeleton_left_2_0 = TensorMap(
    '25243_Mean-L1-in-superior-frontooccipital-fasciculus-on-FA-skeleton-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25243_Mean-L1-in-superior-frontooccipital-fasciculus-on-FA-skeleton-left_2_0': 0},
)
field_id_25242_mean_l1_in_superior_frontooccipital_fasciculus_on_fa_skeleton_right_2_0 = TensorMap(
    '25242_Mean-L1-in-superior-frontooccipital-fasciculus-on-FA-skeleton-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25242_Mean-L1-in-superior-frontooccipital-fasciculus-on-FA-skeleton-right_2_0': 0},
)
field_id_25241_mean_l1_in_superior_longitudinal_fasciculus_on_fa_skeleton_left_2_0 = TensorMap(
    '25241_Mean-L1-in-superior-longitudinal-fasciculus-on-FA-skeleton-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25241_Mean-L1-in-superior-longitudinal-fasciculus-on-FA-skeleton-left_2_0': 0},
)
field_id_25240_mean_l1_in_superior_longitudinal_fasciculus_on_fa_skeleton_right_2_0 = TensorMap(
    '25240_Mean-L1-in-superior-longitudinal-fasciculus-on-FA-skeleton-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25240_Mean-L1-in-superior-longitudinal-fasciculus-on-FA-skeleton-right_2_0': 0},
)
field_id_25239_mean_l1_in_fornix_cresstria_terminalis_on_fa_skeleton_left_2_0 = TensorMap(
    '25239_Mean-L1-in-fornix-cresstria-terminalis-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25239_Mean-L1-in-fornix-cresstria-terminalis-on-FA-skeleton-left_2_0': 0},
)
field_id_25238_mean_l1_in_fornix_cresstria_terminalis_on_fa_skeleton_right_2_0 = TensorMap(
    '25238_Mean-L1-in-fornix-cresstria-terminalis-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25238_Mean-L1-in-fornix-cresstria-terminalis-on-FA-skeleton-right_2_0': 0},
)
field_id_25237_mean_l1_in_cingulum_hippocampus_on_fa_skeleton_left_2_0 = TensorMap(
    '25237_Mean-L1-in-cingulum-hippocampus-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25237_Mean-L1-in-cingulum-hippocampus-on-FA-skeleton-left_2_0': 0},
)
field_id_25236_mean_l1_in_cingulum_hippocampus_on_fa_skeleton_right_2_0 = TensorMap(
    '25236_Mean-L1-in-cingulum-hippocampus-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25236_Mean-L1-in-cingulum-hippocampus-on-FA-skeleton-right_2_0': 0},
)
field_id_25235_mean_l1_in_cingulum_cingulate_gyrus_on_fa_skeleton_left_2_0 = TensorMap(
    '25235_Mean-L1-in-cingulum-cingulate-gyrus-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25235_Mean-L1-in-cingulum-cingulate-gyrus-on-FA-skeleton-left_2_0': 0},
)
field_id_25234_mean_l1_in_cingulum_cingulate_gyrus_on_fa_skeleton_right_2_0 = TensorMap(
    '25234_Mean-L1-in-cingulum-cingulate-gyrus-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25234_Mean-L1-in-cingulum-cingulate-gyrus-on-FA-skeleton-right_2_0': 0},
)
field_id_25233_mean_l1_in_external_capsule_on_fa_skeleton_left_2_0 = TensorMap(
    '25233_Mean-L1-in-external-capsule-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25233_Mean-L1-in-external-capsule-on-FA-skeleton-left_2_0': 0},
)
field_id_25232_mean_l1_in_external_capsule_on_fa_skeleton_right_2_0 = TensorMap(
    '25232_Mean-L1-in-external-capsule-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25232_Mean-L1-in-external-capsule-on-FA-skeleton-right_2_0': 0},
)
field_id_25231_mean_l1_in_sagittal_stratum_on_fa_skeleton_left_2_0 = TensorMap(
    '25231_Mean-L1-in-sagittal-stratum-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25231_Mean-L1-in-sagittal-stratum-on-FA-skeleton-left_2_0': 0},
)
field_id_25230_mean_l1_in_sagittal_stratum_on_fa_skeleton_right_2_0 = TensorMap(
    '25230_Mean-L1-in-sagittal-stratum-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25230_Mean-L1-in-sagittal-stratum-on-FA-skeleton-right_2_0': 0},
)
field_id_25229_mean_l1_in_posterior_thalamic_radiation_on_fa_skeleton_left_2_0 = TensorMap(
    '25229_Mean-L1-in-posterior-thalamic-radiation-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25229_Mean-L1-in-posterior-thalamic-radiation-on-FA-skeleton-left_2_0': 0},
)
field_id_25228_mean_l1_in_posterior_thalamic_radiation_on_fa_skeleton_right_2_0 = TensorMap(
    '25228_Mean-L1-in-posterior-thalamic-radiation-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25228_Mean-L1-in-posterior-thalamic-radiation-on-FA-skeleton-right_2_0': 0},
)
field_id_25227_mean_l1_in_posterior_corona_radiata_on_fa_skeleton_left_2_0 = TensorMap(
    '25227_Mean-L1-in-posterior-corona-radiata-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25227_Mean-L1-in-posterior-corona-radiata-on-FA-skeleton-left_2_0': 0},
)
field_id_25226_mean_l1_in_posterior_corona_radiata_on_fa_skeleton_right_2_0 = TensorMap(
    '25226_Mean-L1-in-posterior-corona-radiata-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25226_Mean-L1-in-posterior-corona-radiata-on-FA-skeleton-right_2_0': 0},
)
field_id_25225_mean_l1_in_superior_corona_radiata_on_fa_skeleton_left_2_0 = TensorMap(
    '25225_Mean-L1-in-superior-corona-radiata-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25225_Mean-L1-in-superior-corona-radiata-on-FA-skeleton-left_2_0': 0},
)
field_id_25224_mean_l1_in_superior_corona_radiata_on_fa_skeleton_right_2_0 = TensorMap(
    '25224_Mean-L1-in-superior-corona-radiata-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25224_Mean-L1-in-superior-corona-radiata-on-FA-skeleton-right_2_0': 0},
)
field_id_25223_mean_l1_in_anterior_corona_radiata_on_fa_skeleton_left_2_0 = TensorMap(
    '25223_Mean-L1-in-anterior-corona-radiata-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25223_Mean-L1-in-anterior-corona-radiata-on-FA-skeleton-left_2_0': 0},
)
field_id_25222_mean_l1_in_anterior_corona_radiata_on_fa_skeleton_right_2_0 = TensorMap(
    '25222_Mean-L1-in-anterior-corona-radiata-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25222_Mean-L1-in-anterior-corona-radiata-on-FA-skeleton-right_2_0': 0},
)
field_id_25221_mean_l1_in_retrolenticular_part_of_internal_capsule_on_fa_skeleton_left_2_0 = TensorMap(
    '25221_Mean-L1-in-retrolenticular-part-of-internal-capsule-on-FA-skeleton-left_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'25221_Mean-L1-in-retrolenticular-part-of-internal-capsule-on-FA-skeleton-left_2_0': 0},
)
field_id_25220_mean_l1_in_retrolenticular_part_of_internal_capsule_on_fa_skeleton_right_2_0 = TensorMap(
    '25220_Mean-L1-in-retrolenticular-part-of-internal-capsule-on-FA-skeleton-right_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'25220_Mean-L1-in-retrolenticular-part-of-internal-capsule-on-FA-skeleton-right_2_0': 0},
)
field_id_25219_mean_l1_in_posterior_limb_of_internal_capsule_on_fa_skeleton_left_2_0 = TensorMap(
    '25219_Mean-L1-in-posterior-limb-of-internal-capsule-on-FA-skeleton-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25219_Mean-L1-in-posterior-limb-of-internal-capsule-on-FA-skeleton-left_2_0': 0},
)
field_id_25218_mean_l1_in_posterior_limb_of_internal_capsule_on_fa_skeleton_right_2_0 = TensorMap(
    '25218_Mean-L1-in-posterior-limb-of-internal-capsule-on-FA-skeleton-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25218_Mean-L1-in-posterior-limb-of-internal-capsule-on-FA-skeleton-right_2_0': 0},
)
field_id_25217_mean_l1_in_anterior_limb_of_internal_capsule_on_fa_skeleton_left_2_0 = TensorMap(
    '25217_Mean-L1-in-anterior-limb-of-internal-capsule-on-FA-skeleton-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25217_Mean-L1-in-anterior-limb-of-internal-capsule-on-FA-skeleton-left_2_0': 0},
)
field_id_25216_mean_l1_in_anterior_limb_of_internal_capsule_on_fa_skeleton_right_2_0 = TensorMap(
    '25216_Mean-L1-in-anterior-limb-of-internal-capsule-on-FA-skeleton-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25216_Mean-L1-in-anterior-limb-of-internal-capsule-on-FA-skeleton-right_2_0': 0},
)
field_id_25215_mean_l1_in_cerebral_peduncle_on_fa_skeleton_left_2_0 = TensorMap(
    '25215_Mean-L1-in-cerebral-peduncle-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25215_Mean-L1-in-cerebral-peduncle-on-FA-skeleton-left_2_0': 0},
)
field_id_25214_mean_l1_in_cerebral_peduncle_on_fa_skeleton_right_2_0 = TensorMap(
    '25214_Mean-L1-in-cerebral-peduncle-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25214_Mean-L1-in-cerebral-peduncle-on-FA-skeleton-right_2_0': 0},
)
field_id_25213_mean_l1_in_superior_cerebellar_peduncle_on_fa_skeleton_left_2_0 = TensorMap(
    '25213_Mean-L1-in-superior-cerebellar-peduncle-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25213_Mean-L1-in-superior-cerebellar-peduncle-on-FA-skeleton-left_2_0': 0},
)
field_id_25212_mean_l1_in_superior_cerebellar_peduncle_on_fa_skeleton_right_2_0 = TensorMap(
    '25212_Mean-L1-in-superior-cerebellar-peduncle-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25212_Mean-L1-in-superior-cerebellar-peduncle-on-FA-skeleton-right_2_0': 0},
)
field_id_25211_mean_l1_in_inferior_cerebellar_peduncle_on_fa_skeleton_left_2_0 = TensorMap(
    '25211_Mean-L1-in-inferior-cerebellar-peduncle-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25211_Mean-L1-in-inferior-cerebellar-peduncle-on-FA-skeleton-left_2_0': 0},
)
field_id_25210_mean_l1_in_inferior_cerebellar_peduncle_on_fa_skeleton_right_2_0 = TensorMap(
    '25210_Mean-L1-in-inferior-cerebellar-peduncle-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25210_Mean-L1-in-inferior-cerebellar-peduncle-on-FA-skeleton-right_2_0': 0},
)
field_id_25209_mean_l1_in_medial_lemniscus_on_fa_skeleton_left_2_0 = TensorMap(
    '25209_Mean-L1-in-medial-lemniscus-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25209_Mean-L1-in-medial-lemniscus-on-FA-skeleton-left_2_0': 0},
)
field_id_25208_mean_l1_in_medial_lemniscus_on_fa_skeleton_right_2_0 = TensorMap(
    '25208_Mean-L1-in-medial-lemniscus-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25208_Mean-L1-in-medial-lemniscus-on-FA-skeleton-right_2_0': 0},
)
field_id_25207_mean_l1_in_corticospinal_tract_on_fa_skeleton_left_2_0 = TensorMap(
    '25207_Mean-L1-in-corticospinal-tract-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25207_Mean-L1-in-corticospinal-tract-on-FA-skeleton-left_2_0': 0},
)
field_id_25206_mean_l1_in_corticospinal_tract_on_fa_skeleton_right_2_0 = TensorMap(
    '25206_Mean-L1-in-corticospinal-tract-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25206_Mean-L1-in-corticospinal-tract-on-FA-skeleton-right_2_0': 0},
)
field_id_25205_mean_l1_in_fornix_on_fa_skeleton_2_0 = TensorMap(
    '25205_Mean-L1-in-fornix-on-FA-skeleton_2_0',
    path_prefix='continuous', loss='logcosh', channel_map={
        '25205_Mean-L1-in-fornix-on-FA-skeleton_2_0': 0,
    },
)
field_id_25204_mean_l1_in_splenium_of_corpus_callosum_on_fa_skeleton_2_0 = TensorMap(
    '25204_Mean-L1-in-splenium-of-corpus-callosum-on-FA-skeleton_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25204_Mean-L1-in-splenium-of-corpus-callosum-on-FA-skeleton_2_0': 0},
)
field_id_25203_mean_l1_in_body_of_corpus_callosum_on_fa_skeleton_2_0 = TensorMap(
    '25203_Mean-L1-in-body-of-corpus-callosum-on-FA-skeleton_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25203_Mean-L1-in-body-of-corpus-callosum-on-FA-skeleton_2_0': 0},
)
field_id_25202_mean_l1_in_genu_of_corpus_callosum_on_fa_skeleton_2_0 = TensorMap(
    '25202_Mean-L1-in-genu-of-corpus-callosum-on-FA-skeleton_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25202_Mean-L1-in-genu-of-corpus-callosum-on-FA-skeleton_2_0': 0},
)
field_id_25201_mean_l1_in_pontine_crossing_tract_on_fa_skeleton_2_0 = TensorMap(
    '25201_Mean-L1-in-pontine-crossing-tract-on-FA-skeleton_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25201_Mean-L1-in-pontine-crossing-tract-on-FA-skeleton_2_0': 0},
)
field_id_25200_mean_l1_in_middle_cerebellar_peduncle_on_fa_skeleton_2_0 = TensorMap(
    '25200_Mean-L1-in-middle-cerebellar-peduncle-on-FA-skeleton_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25200_Mean-L1-in-middle-cerebellar-peduncle-on-FA-skeleton_2_0': 0},
)
field_id_25199_mean_mo_in_tapetum_on_fa_skeleton_left_2_0 = TensorMap(
    '25199_Mean-MO-in-tapetum-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25199_Mean-MO-in-tapetum-on-FA-skeleton-left_2_0': 0},
)
field_id_25198_mean_mo_in_tapetum_on_fa_skeleton_right_2_0 = TensorMap(
    '25198_Mean-MO-in-tapetum-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25198_Mean-MO-in-tapetum-on-FA-skeleton-right_2_0': 0},
)
field_id_25197_mean_mo_in_uncinate_fasciculus_on_fa_skeleton_left_2_0 = TensorMap(
    '25197_Mean-MO-in-uncinate-fasciculus-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25197_Mean-MO-in-uncinate-fasciculus-on-FA-skeleton-left_2_0': 0},
)
field_id_25196_mean_mo_in_uncinate_fasciculus_on_fa_skeleton_right_2_0 = TensorMap(
    '25196_Mean-MO-in-uncinate-fasciculus-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25196_Mean-MO-in-uncinate-fasciculus-on-FA-skeleton-right_2_0': 0},
)
field_id_25195_mean_mo_in_superior_frontooccipital_fasciculus_on_fa_skeleton_left_2_0 = TensorMap(
    '25195_Mean-MO-in-superior-frontooccipital-fasciculus-on-FA-skeleton-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25195_Mean-MO-in-superior-frontooccipital-fasciculus-on-FA-skeleton-left_2_0': 0},
)
field_id_25194_mean_mo_in_superior_frontooccipital_fasciculus_on_fa_skeleton_right_2_0 = TensorMap(
    '25194_Mean-MO-in-superior-frontooccipital-fasciculus-on-FA-skeleton-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25194_Mean-MO-in-superior-frontooccipital-fasciculus-on-FA-skeleton-right_2_0': 0},
)
field_id_25193_mean_mo_in_superior_longitudinal_fasciculus_on_fa_skeleton_left_2_0 = TensorMap(
    '25193_Mean-MO-in-superior-longitudinal-fasciculus-on-FA-skeleton-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25193_Mean-MO-in-superior-longitudinal-fasciculus-on-FA-skeleton-left_2_0': 0},
)
field_id_25192_mean_mo_in_superior_longitudinal_fasciculus_on_fa_skeleton_right_2_0 = TensorMap(
    '25192_Mean-MO-in-superior-longitudinal-fasciculus-on-FA-skeleton-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25192_Mean-MO-in-superior-longitudinal-fasciculus-on-FA-skeleton-right_2_0': 0},
)
field_id_25191_mean_mo_in_fornix_cresstria_terminalis_on_fa_skeleton_left_2_0 = TensorMap(
    '25191_Mean-MO-in-fornix-cresstria-terminalis-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25191_Mean-MO-in-fornix-cresstria-terminalis-on-FA-skeleton-left_2_0': 0},
)
field_id_25190_mean_mo_in_fornix_cresstria_terminalis_on_fa_skeleton_right_2_0 = TensorMap(
    '25190_Mean-MO-in-fornix-cresstria-terminalis-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25190_Mean-MO-in-fornix-cresstria-terminalis-on-FA-skeleton-right_2_0': 0},
)
field_id_25189_mean_mo_in_cingulum_hippocampus_on_fa_skeleton_left_2_0 = TensorMap(
    '25189_Mean-MO-in-cingulum-hippocampus-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25189_Mean-MO-in-cingulum-hippocampus-on-FA-skeleton-left_2_0': 0},
)
field_id_25188_mean_mo_in_cingulum_hippocampus_on_fa_skeleton_right_2_0 = TensorMap(
    '25188_Mean-MO-in-cingulum-hippocampus-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25188_Mean-MO-in-cingulum-hippocampus-on-FA-skeleton-right_2_0': 0},
)
field_id_25187_mean_mo_in_cingulum_cingulate_gyrus_on_fa_skeleton_left_2_0 = TensorMap(
    '25187_Mean-MO-in-cingulum-cingulate-gyrus-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25187_Mean-MO-in-cingulum-cingulate-gyrus-on-FA-skeleton-left_2_0': 0},
)
field_id_25186_mean_mo_in_cingulum_cingulate_gyrus_on_fa_skeleton_right_2_0 = TensorMap(
    '25186_Mean-MO-in-cingulum-cingulate-gyrus-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25186_Mean-MO-in-cingulum-cingulate-gyrus-on-FA-skeleton-right_2_0': 0},
)
field_id_25185_mean_mo_in_external_capsule_on_fa_skeleton_left_2_0 = TensorMap(
    '25185_Mean-MO-in-external-capsule-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25185_Mean-MO-in-external-capsule-on-FA-skeleton-left_2_0': 0},
)
field_id_25184_mean_mo_in_external_capsule_on_fa_skeleton_right_2_0 = TensorMap(
    '25184_Mean-MO-in-external-capsule-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25184_Mean-MO-in-external-capsule-on-FA-skeleton-right_2_0': 0},
)
field_id_25183_mean_mo_in_sagittal_stratum_on_fa_skeleton_left_2_0 = TensorMap(
    '25183_Mean-MO-in-sagittal-stratum-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25183_Mean-MO-in-sagittal-stratum-on-FA-skeleton-left_2_0': 0},
)
field_id_25182_mean_mo_in_sagittal_stratum_on_fa_skeleton_right_2_0 = TensorMap(
    '25182_Mean-MO-in-sagittal-stratum-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25182_Mean-MO-in-sagittal-stratum-on-FA-skeleton-right_2_0': 0},
)
field_id_25181_mean_mo_in_posterior_thalamic_radiation_on_fa_skeleton_left_2_0 = TensorMap(
    '25181_Mean-MO-in-posterior-thalamic-radiation-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25181_Mean-MO-in-posterior-thalamic-radiation-on-FA-skeleton-left_2_0': 0},
)
field_id_25180_mean_mo_in_posterior_thalamic_radiation_on_fa_skeleton_right_2_0 = TensorMap(
    '25180_Mean-MO-in-posterior-thalamic-radiation-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25180_Mean-MO-in-posterior-thalamic-radiation-on-FA-skeleton-right_2_0': 0},
)
field_id_25179_mean_mo_in_posterior_corona_radiata_on_fa_skeleton_left_2_0 = TensorMap(
    '25179_Mean-MO-in-posterior-corona-radiata-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25179_Mean-MO-in-posterior-corona-radiata-on-FA-skeleton-left_2_0': 0},
)
field_id_25178_mean_mo_in_posterior_corona_radiata_on_fa_skeleton_right_2_0 = TensorMap(
    '25178_Mean-MO-in-posterior-corona-radiata-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25178_Mean-MO-in-posterior-corona-radiata-on-FA-skeleton-right_2_0': 0},
)
field_id_25177_mean_mo_in_superior_corona_radiata_on_fa_skeleton_left_2_0 = TensorMap(
    '25177_Mean-MO-in-superior-corona-radiata-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25177_Mean-MO-in-superior-corona-radiata-on-FA-skeleton-left_2_0': 0},
)
field_id_25176_mean_mo_in_superior_corona_radiata_on_fa_skeleton_right_2_0 = TensorMap(
    '25176_Mean-MO-in-superior-corona-radiata-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25176_Mean-MO-in-superior-corona-radiata-on-FA-skeleton-right_2_0': 0},
)
field_id_25175_mean_mo_in_anterior_corona_radiata_on_fa_skeleton_left_2_0 = TensorMap(
    '25175_Mean-MO-in-anterior-corona-radiata-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25175_Mean-MO-in-anterior-corona-radiata-on-FA-skeleton-left_2_0': 0},
)
field_id_25174_mean_mo_in_anterior_corona_radiata_on_fa_skeleton_right_2_0 = TensorMap(
    '25174_Mean-MO-in-anterior-corona-radiata-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25174_Mean-MO-in-anterior-corona-radiata-on-FA-skeleton-right_2_0': 0},
)
field_id_25173_mean_mo_in_retrolenticular_part_of_internal_capsule_on_fa_skeleton_left_2_0 = TensorMap(
    '25173_Mean-MO-in-retrolenticular-part-of-internal-capsule-on-FA-skeleton-left_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'25173_Mean-MO-in-retrolenticular-part-of-internal-capsule-on-FA-skeleton-left_2_0': 0},
)
field_id_25172_mean_mo_in_retrolenticular_part_of_internal_capsule_on_fa_skeleton_right_2_0 = TensorMap(
    '25172_Mean-MO-in-retrolenticular-part-of-internal-capsule-on-FA-skeleton-right_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'25172_Mean-MO-in-retrolenticular-part-of-internal-capsule-on-FA-skeleton-right_2_0': 0},
)
field_id_25171_mean_mo_in_posterior_limb_of_internal_capsule_on_fa_skeleton_left_2_0 = TensorMap(
    '25171_Mean-MO-in-posterior-limb-of-internal-capsule-on-FA-skeleton-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25171_Mean-MO-in-posterior-limb-of-internal-capsule-on-FA-skeleton-left_2_0': 0},
)
field_id_25170_mean_mo_in_posterior_limb_of_internal_capsule_on_fa_skeleton_right_2_0 = TensorMap(
    '25170_Mean-MO-in-posterior-limb-of-internal-capsule-on-FA-skeleton-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25170_Mean-MO-in-posterior-limb-of-internal-capsule-on-FA-skeleton-right_2_0': 0},
)
field_id_25169_mean_mo_in_anterior_limb_of_internal_capsule_on_fa_skeleton_left_2_0 = TensorMap(
    '25169_Mean-MO-in-anterior-limb-of-internal-capsule-on-FA-skeleton-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25169_Mean-MO-in-anterior-limb-of-internal-capsule-on-FA-skeleton-left_2_0': 0},
)
field_id_25168_mean_mo_in_anterior_limb_of_internal_capsule_on_fa_skeleton_right_2_0 = TensorMap(
    '25168_Mean-MO-in-anterior-limb-of-internal-capsule-on-FA-skeleton-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25168_Mean-MO-in-anterior-limb-of-internal-capsule-on-FA-skeleton-right_2_0': 0},
)
field_id_25167_mean_mo_in_cerebral_peduncle_on_fa_skeleton_left_2_0 = TensorMap(
    '25167_Mean-MO-in-cerebral-peduncle-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25167_Mean-MO-in-cerebral-peduncle-on-FA-skeleton-left_2_0': 0},
)
field_id_25166_mean_mo_in_cerebral_peduncle_on_fa_skeleton_right_2_0 = TensorMap(
    '25166_Mean-MO-in-cerebral-peduncle-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25166_Mean-MO-in-cerebral-peduncle-on-FA-skeleton-right_2_0': 0},
)
field_id_25165_mean_mo_in_superior_cerebellar_peduncle_on_fa_skeleton_left_2_0 = TensorMap(
    '25165_Mean-MO-in-superior-cerebellar-peduncle-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25165_Mean-MO-in-superior-cerebellar-peduncle-on-FA-skeleton-left_2_0': 0},
)
field_id_25164_mean_mo_in_superior_cerebellar_peduncle_on_fa_skeleton_right_2_0 = TensorMap(
    '25164_Mean-MO-in-superior-cerebellar-peduncle-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25164_Mean-MO-in-superior-cerebellar-peduncle-on-FA-skeleton-right_2_0': 0},
)
field_id_25163_mean_mo_in_inferior_cerebellar_peduncle_on_fa_skeleton_left_2_0 = TensorMap(
    '25163_Mean-MO-in-inferior-cerebellar-peduncle-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25163_Mean-MO-in-inferior-cerebellar-peduncle-on-FA-skeleton-left_2_0': 0},
)
field_id_25162_mean_mo_in_inferior_cerebellar_peduncle_on_fa_skeleton_right_2_0 = TensorMap(
    '25162_Mean-MO-in-inferior-cerebellar-peduncle-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25162_Mean-MO-in-inferior-cerebellar-peduncle-on-FA-skeleton-right_2_0': 0},
)
field_id_25161_mean_mo_in_medial_lemniscus_on_fa_skeleton_left_2_0 = TensorMap(
    '25161_Mean-MO-in-medial-lemniscus-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25161_Mean-MO-in-medial-lemniscus-on-FA-skeleton-left_2_0': 0},
)
field_id_25160_mean_mo_in_medial_lemniscus_on_fa_skeleton_right_2_0 = TensorMap(
    '25160_Mean-MO-in-medial-lemniscus-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25160_Mean-MO-in-medial-lemniscus-on-FA-skeleton-right_2_0': 0},
)
field_id_25159_mean_mo_in_corticospinal_tract_on_fa_skeleton_left_2_0 = TensorMap(
    '25159_Mean-MO-in-corticospinal-tract-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25159_Mean-MO-in-corticospinal-tract-on-FA-skeleton-left_2_0': 0},
)
field_id_25158_mean_mo_in_corticospinal_tract_on_fa_skeleton_right_2_0 = TensorMap(
    '25158_Mean-MO-in-corticospinal-tract-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25158_Mean-MO-in-corticospinal-tract-on-FA-skeleton-right_2_0': 0},
)
field_id_25157_mean_mo_in_fornix_on_fa_skeleton_2_0 = TensorMap(
    '25157_Mean-MO-in-fornix-on-FA-skeleton_2_0',
    path_prefix='continuous', loss='logcosh', channel_map={
        '25157_Mean-MO-in-fornix-on-FA-skeleton_2_0': 0,
    },
)
field_id_25156_mean_mo_in_splenium_of_corpus_callosum_on_fa_skeleton_2_0 = TensorMap(
    '25156_Mean-MO-in-splenium-of-corpus-callosum-on-FA-skeleton_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25156_Mean-MO-in-splenium-of-corpus-callosum-on-FA-skeleton_2_0': 0},
)
field_id_25155_mean_mo_in_body_of_corpus_callosum_on_fa_skeleton_2_0 = TensorMap(
    '25155_Mean-MO-in-body-of-corpus-callosum-on-FA-skeleton_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25155_Mean-MO-in-body-of-corpus-callosum-on-FA-skeleton_2_0': 0},
)
field_id_25154_mean_mo_in_genu_of_corpus_callosum_on_fa_skeleton_2_0 = TensorMap(
    '25154_Mean-MO-in-genu-of-corpus-callosum-on-FA-skeleton_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25154_Mean-MO-in-genu-of-corpus-callosum-on-FA-skeleton_2_0': 0},
)
field_id_25153_mean_mo_in_pontine_crossing_tract_on_fa_skeleton_2_0 = TensorMap(
    '25153_Mean-MO-in-pontine-crossing-tract-on-FA-skeleton_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25153_Mean-MO-in-pontine-crossing-tract-on-FA-skeleton_2_0': 0},
)
field_id_25152_mean_mo_in_middle_cerebellar_peduncle_on_fa_skeleton_2_0 = TensorMap(
    '25152_Mean-MO-in-middle-cerebellar-peduncle-on-FA-skeleton_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25152_Mean-MO-in-middle-cerebellar-peduncle-on-FA-skeleton_2_0': 0},
)
field_id_25151_mean_md_in_tapetum_on_fa_skeleton_left_2_0 = TensorMap(
    '25151_Mean-MD-in-tapetum-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25151_Mean-MD-in-tapetum-on-FA-skeleton-left_2_0': 0},
)
field_id_25150_mean_md_in_tapetum_on_fa_skeleton_right_2_0 = TensorMap(
    '25150_Mean-MD-in-tapetum-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25150_Mean-MD-in-tapetum-on-FA-skeleton-right_2_0': 0},
)
field_id_25149_mean_md_in_uncinate_fasciculus_on_fa_skeleton_left_2_0 = TensorMap(
    '25149_Mean-MD-in-uncinate-fasciculus-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25149_Mean-MD-in-uncinate-fasciculus-on-FA-skeleton-left_2_0': 0},
)
field_id_25148_mean_md_in_uncinate_fasciculus_on_fa_skeleton_right_2_0 = TensorMap(
    '25148_Mean-MD-in-uncinate-fasciculus-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25148_Mean-MD-in-uncinate-fasciculus-on-FA-skeleton-right_2_0': 0},
)
field_id_25147_mean_md_in_superior_frontooccipital_fasciculus_on_fa_skeleton_left_2_0 = TensorMap(
    '25147_Mean-MD-in-superior-frontooccipital-fasciculus-on-FA-skeleton-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25147_Mean-MD-in-superior-frontooccipital-fasciculus-on-FA-skeleton-left_2_0': 0},
)
field_id_25146_mean_md_in_superior_frontooccipital_fasciculus_on_fa_skeleton_right_2_0 = TensorMap(
    '25146_Mean-MD-in-superior-frontooccipital-fasciculus-on-FA-skeleton-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25146_Mean-MD-in-superior-frontooccipital-fasciculus-on-FA-skeleton-right_2_0': 0},
)
field_id_25145_mean_md_in_superior_longitudinal_fasciculus_on_fa_skeleton_left_2_0 = TensorMap(
    '25145_Mean-MD-in-superior-longitudinal-fasciculus-on-FA-skeleton-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25145_Mean-MD-in-superior-longitudinal-fasciculus-on-FA-skeleton-left_2_0': 0},
)
field_id_25144_mean_md_in_superior_longitudinal_fasciculus_on_fa_skeleton_right_2_0 = TensorMap(
    '25144_Mean-MD-in-superior-longitudinal-fasciculus-on-FA-skeleton-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25144_Mean-MD-in-superior-longitudinal-fasciculus-on-FA-skeleton-right_2_0': 0},
)
field_id_25143_mean_md_in_fornix_cresstria_terminalis_on_fa_skeleton_left_2_0 = TensorMap(
    '25143_Mean-MD-in-fornix-cresstria-terminalis-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25143_Mean-MD-in-fornix-cresstria-terminalis-on-FA-skeleton-left_2_0': 0},
)
field_id_25142_mean_md_in_fornix_cresstria_terminalis_on_fa_skeleton_right_2_0 = TensorMap(
    '25142_Mean-MD-in-fornix-cresstria-terminalis-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25142_Mean-MD-in-fornix-cresstria-terminalis-on-FA-skeleton-right_2_0': 0},
)
field_id_25141_mean_md_in_cingulum_hippocampus_on_fa_skeleton_left_2_0 = TensorMap(
    '25141_Mean-MD-in-cingulum-hippocampus-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25141_Mean-MD-in-cingulum-hippocampus-on-FA-skeleton-left_2_0': 0},
)
field_id_25140_mean_md_in_cingulum_hippocampus_on_fa_skeleton_right_2_0 = TensorMap(
    '25140_Mean-MD-in-cingulum-hippocampus-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25140_Mean-MD-in-cingulum-hippocampus-on-FA-skeleton-right_2_0': 0},
)
field_id_25139_mean_md_in_cingulum_cingulate_gyrus_on_fa_skeleton_left_2_0 = TensorMap(
    '25139_Mean-MD-in-cingulum-cingulate-gyrus-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25139_Mean-MD-in-cingulum-cingulate-gyrus-on-FA-skeleton-left_2_0': 0},
)
field_id_25138_mean_md_in_cingulum_cingulate_gyrus_on_fa_skeleton_right_2_0 = TensorMap(
    '25138_Mean-MD-in-cingulum-cingulate-gyrus-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25138_Mean-MD-in-cingulum-cingulate-gyrus-on-FA-skeleton-right_2_0': 0},
)
field_id_25137_mean_md_in_external_capsule_on_fa_skeleton_left_2_0 = TensorMap(
    '25137_Mean-MD-in-external-capsule-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25137_Mean-MD-in-external-capsule-on-FA-skeleton-left_2_0': 0},
)
field_id_25136_mean_md_in_external_capsule_on_fa_skeleton_right_2_0 = TensorMap(
    '25136_Mean-MD-in-external-capsule-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25136_Mean-MD-in-external-capsule-on-FA-skeleton-right_2_0': 0},
)
field_id_25135_mean_md_in_sagittal_stratum_on_fa_skeleton_left_2_0 = TensorMap(
    '25135_Mean-MD-in-sagittal-stratum-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25135_Mean-MD-in-sagittal-stratum-on-FA-skeleton-left_2_0': 0},
)
field_id_25134_mean_md_in_sagittal_stratum_on_fa_skeleton_right_2_0 = TensorMap(
    '25134_Mean-MD-in-sagittal-stratum-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25134_Mean-MD-in-sagittal-stratum-on-FA-skeleton-right_2_0': 0},
)
field_id_25133_mean_md_in_posterior_thalamic_radiation_on_fa_skeleton_left_2_0 = TensorMap(
    '25133_Mean-MD-in-posterior-thalamic-radiation-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25133_Mean-MD-in-posterior-thalamic-radiation-on-FA-skeleton-left_2_0': 0},
)
field_id_25132_mean_md_in_posterior_thalamic_radiation_on_fa_skeleton_right_2_0 = TensorMap(
    '25132_Mean-MD-in-posterior-thalamic-radiation-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25132_Mean-MD-in-posterior-thalamic-radiation-on-FA-skeleton-right_2_0': 0},
)
field_id_25131_mean_md_in_posterior_corona_radiata_on_fa_skeleton_left_2_0 = TensorMap(
    '25131_Mean-MD-in-posterior-corona-radiata-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25131_Mean-MD-in-posterior-corona-radiata-on-FA-skeleton-left_2_0': 0},
)
field_id_25130_mean_md_in_posterior_corona_radiata_on_fa_skeleton_right_2_0 = TensorMap(
    '25130_Mean-MD-in-posterior-corona-radiata-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25130_Mean-MD-in-posterior-corona-radiata-on-FA-skeleton-right_2_0': 0},
)
field_id_25129_mean_md_in_superior_corona_radiata_on_fa_skeleton_left_2_0 = TensorMap(
    '25129_Mean-MD-in-superior-corona-radiata-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25129_Mean-MD-in-superior-corona-radiata-on-FA-skeleton-left_2_0': 0},
)
field_id_25128_mean_md_in_superior_corona_radiata_on_fa_skeleton_right_2_0 = TensorMap(
    '25128_Mean-MD-in-superior-corona-radiata-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25128_Mean-MD-in-superior-corona-radiata-on-FA-skeleton-right_2_0': 0},
)
field_id_25127_mean_md_in_anterior_corona_radiata_on_fa_skeleton_left_2_0 = TensorMap(
    '25127_Mean-MD-in-anterior-corona-radiata-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25127_Mean-MD-in-anterior-corona-radiata-on-FA-skeleton-left_2_0': 0},
)
field_id_25126_mean_md_in_anterior_corona_radiata_on_fa_skeleton_right_2_0 = TensorMap(
    '25126_Mean-MD-in-anterior-corona-radiata-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25126_Mean-MD-in-anterior-corona-radiata-on-FA-skeleton-right_2_0': 0},
)
field_id_25125_mean_md_in_retrolenticular_part_of_internal_capsule_on_fa_skeleton_left_2_0 = TensorMap(
    '25125_Mean-MD-in-retrolenticular-part-of-internal-capsule-on-FA-skeleton-left_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'25125_Mean-MD-in-retrolenticular-part-of-internal-capsule-on-FA-skeleton-left_2_0': 0},
)
field_id_25124_mean_md_in_retrolenticular_part_of_internal_capsule_on_fa_skeleton_right_2_0 = TensorMap(
    '25124_Mean-MD-in-retrolenticular-part-of-internal-capsule-on-FA-skeleton-right_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'25124_Mean-MD-in-retrolenticular-part-of-internal-capsule-on-FA-skeleton-right_2_0': 0},
)
field_id_25123_mean_md_in_posterior_limb_of_internal_capsule_on_fa_skeleton_left_2_0 = TensorMap(
    '25123_Mean-MD-in-posterior-limb-of-internal-capsule-on-FA-skeleton-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25123_Mean-MD-in-posterior-limb-of-internal-capsule-on-FA-skeleton-left_2_0': 0},
)
field_id_25122_mean_md_in_posterior_limb_of_internal_capsule_on_fa_skeleton_right_2_0 = TensorMap(
    '25122_Mean-MD-in-posterior-limb-of-internal-capsule-on-FA-skeleton-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25122_Mean-MD-in-posterior-limb-of-internal-capsule-on-FA-skeleton-right_2_0': 0},
)
field_id_25121_mean_md_in_anterior_limb_of_internal_capsule_on_fa_skeleton_left_2_0 = TensorMap(
    '25121_Mean-MD-in-anterior-limb-of-internal-capsule-on-FA-skeleton-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25121_Mean-MD-in-anterior-limb-of-internal-capsule-on-FA-skeleton-left_2_0': 0},
)
field_id_25120_mean_md_in_anterior_limb_of_internal_capsule_on_fa_skeleton_right_2_0 = TensorMap(
    '25120_Mean-MD-in-anterior-limb-of-internal-capsule-on-FA-skeleton-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25120_Mean-MD-in-anterior-limb-of-internal-capsule-on-FA-skeleton-right_2_0': 0},
)
field_id_25119_mean_md_in_cerebral_peduncle_on_fa_skeleton_left_2_0 = TensorMap(
    '25119_Mean-MD-in-cerebral-peduncle-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25119_Mean-MD-in-cerebral-peduncle-on-FA-skeleton-left_2_0': 0},
)
field_id_25118_mean_md_in_cerebral_peduncle_on_fa_skeleton_right_2_0 = TensorMap(
    '25118_Mean-MD-in-cerebral-peduncle-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25118_Mean-MD-in-cerebral-peduncle-on-FA-skeleton-right_2_0': 0},
)
field_id_25117_mean_md_in_superior_cerebellar_peduncle_on_fa_skeleton_left_2_0 = TensorMap(
    '25117_Mean-MD-in-superior-cerebellar-peduncle-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25117_Mean-MD-in-superior-cerebellar-peduncle-on-FA-skeleton-left_2_0': 0},
)
field_id_25116_mean_md_in_superior_cerebellar_peduncle_on_fa_skeleton_right_2_0 = TensorMap(
    '25116_Mean-MD-in-superior-cerebellar-peduncle-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25116_Mean-MD-in-superior-cerebellar-peduncle-on-FA-skeleton-right_2_0': 0},
)
field_id_25115_mean_md_in_inferior_cerebellar_peduncle_on_fa_skeleton_left_2_0 = TensorMap(
    '25115_Mean-MD-in-inferior-cerebellar-peduncle-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25115_Mean-MD-in-inferior-cerebellar-peduncle-on-FA-skeleton-left_2_0': 0},
)
field_id_25114_mean_md_in_inferior_cerebellar_peduncle_on_fa_skeleton_right_2_0 = TensorMap(
    '25114_Mean-MD-in-inferior-cerebellar-peduncle-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25114_Mean-MD-in-inferior-cerebellar-peduncle-on-FA-skeleton-right_2_0': 0},
)
field_id_25113_mean_md_in_medial_lemniscus_on_fa_skeleton_left_2_0 = TensorMap(
    '25113_Mean-MD-in-medial-lemniscus-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25113_Mean-MD-in-medial-lemniscus-on-FA-skeleton-left_2_0': 0},
)
field_id_25112_mean_md_in_medial_lemniscus_on_fa_skeleton_right_2_0 = TensorMap(
    '25112_Mean-MD-in-medial-lemniscus-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25112_Mean-MD-in-medial-lemniscus-on-FA-skeleton-right_2_0': 0},
)
field_id_25111_mean_md_in_corticospinal_tract_on_fa_skeleton_left_2_0 = TensorMap(
    '25111_Mean-MD-in-corticospinal-tract-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25111_Mean-MD-in-corticospinal-tract-on-FA-skeleton-left_2_0': 0},
)
field_id_25110_mean_md_in_corticospinal_tract_on_fa_skeleton_right_2_0 = TensorMap(
    '25110_Mean-MD-in-corticospinal-tract-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25110_Mean-MD-in-corticospinal-tract-on-FA-skeleton-right_2_0': 0},
)
field_id_25109_mean_md_in_fornix_on_fa_skeleton_2_0 = TensorMap(
    '25109_Mean-MD-in-fornix-on-FA-skeleton_2_0',
    path_prefix='continuous', loss='logcosh', channel_map={
        '25109_Mean-MD-in-fornix-on-FA-skeleton_2_0': 0,
    },
)
field_id_25108_mean_md_in_splenium_of_corpus_callosum_on_fa_skeleton_2_0 = TensorMap(
    '25108_Mean-MD-in-splenium-of-corpus-callosum-on-FA-skeleton_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25108_Mean-MD-in-splenium-of-corpus-callosum-on-FA-skeleton_2_0': 0},
)
field_id_25107_mean_md_in_body_of_corpus_callosum_on_fa_skeleton_2_0 = TensorMap(
    '25107_Mean-MD-in-body-of-corpus-callosum-on-FA-skeleton_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25107_Mean-MD-in-body-of-corpus-callosum-on-FA-skeleton_2_0': 0},
)
field_id_25106_mean_md_in_genu_of_corpus_callosum_on_fa_skeleton_2_0 = TensorMap(
    '25106_Mean-MD-in-genu-of-corpus-callosum-on-FA-skeleton_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25106_Mean-MD-in-genu-of-corpus-callosum-on-FA-skeleton_2_0': 0},
)
field_id_25105_mean_md_in_pontine_crossing_tract_on_fa_skeleton_2_0 = TensorMap(
    '25105_Mean-MD-in-pontine-crossing-tract-on-FA-skeleton_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25105_Mean-MD-in-pontine-crossing-tract-on-FA-skeleton_2_0': 0},
)
field_id_25104_mean_md_in_middle_cerebellar_peduncle_on_fa_skeleton_2_0 = TensorMap(
    '25104_Mean-MD-in-middle-cerebellar-peduncle-on-FA-skeleton_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25104_Mean-MD-in-middle-cerebellar-peduncle-on-FA-skeleton_2_0': 0},
)
field_id_25103_mean_fa_in_tapetum_on_fa_skeleton_left_2_0 = TensorMap(
    '25103_Mean-FA-in-tapetum-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25103_Mean-FA-in-tapetum-on-FA-skeleton-left_2_0': 0},
)
field_id_25102_mean_fa_in_tapetum_on_fa_skeleton_right_2_0 = TensorMap(
    '25102_Mean-FA-in-tapetum-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25102_Mean-FA-in-tapetum-on-FA-skeleton-right_2_0': 0},
)
field_id_25101_mean_fa_in_uncinate_fasciculus_on_fa_skeleton_left_2_0 = TensorMap(
    '25101_Mean-FA-in-uncinate-fasciculus-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25101_Mean-FA-in-uncinate-fasciculus-on-FA-skeleton-left_2_0': 0},
)
field_id_25100_mean_fa_in_uncinate_fasciculus_on_fa_skeleton_right_2_0 = TensorMap(
    '25100_Mean-FA-in-uncinate-fasciculus-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25100_Mean-FA-in-uncinate-fasciculus-on-FA-skeleton-right_2_0': 0},
)
field_id_25099_mean_fa_in_superior_frontooccipital_fasciculus_on_fa_skeleton_left_2_0 = TensorMap(
    '25099_Mean-FA-in-superior-frontooccipital-fasciculus-on-FA-skeleton-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25099_Mean-FA-in-superior-frontooccipital-fasciculus-on-FA-skeleton-left_2_0': 0},
)
field_id_25098_mean_fa_in_superior_frontooccipital_fasciculus_on_fa_skeleton_right_2_0 = TensorMap(
    '25098_Mean-FA-in-superior-frontooccipital-fasciculus-on-FA-skeleton-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25098_Mean-FA-in-superior-frontooccipital-fasciculus-on-FA-skeleton-right_2_0': 0},
)
field_id_25097_mean_fa_in_superior_longitudinal_fasciculus_on_fa_skeleton_left_2_0 = TensorMap(
    '25097_Mean-FA-in-superior-longitudinal-fasciculus-on-FA-skeleton-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25097_Mean-FA-in-superior-longitudinal-fasciculus-on-FA-skeleton-left_2_0': 0},
)
field_id_25096_mean_fa_in_superior_longitudinal_fasciculus_on_fa_skeleton_right_2_0 = TensorMap(
    '25096_Mean-FA-in-superior-longitudinal-fasciculus-on-FA-skeleton-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25096_Mean-FA-in-superior-longitudinal-fasciculus-on-FA-skeleton-right_2_0': 0},
)
field_id_25095_mean_fa_in_fornix_cresstria_terminalis_on_fa_skeleton_left_2_0 = TensorMap(
    '25095_Mean-FA-in-fornix-cresstria-terminalis-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25095_Mean-FA-in-fornix-cresstria-terminalis-on-FA-skeleton-left_2_0': 0},
)
field_id_25094_mean_fa_in_fornix_cresstria_terminalis_on_fa_skeleton_right_2_0 = TensorMap(
    '25094_Mean-FA-in-fornix-cresstria-terminalis-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25094_Mean-FA-in-fornix-cresstria-terminalis-on-FA-skeleton-right_2_0': 0},
)
field_id_25093_mean_fa_in_cingulum_hippocampus_on_fa_skeleton_left_2_0 = TensorMap(
    '25093_Mean-FA-in-cingulum-hippocampus-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25093_Mean-FA-in-cingulum-hippocampus-on-FA-skeleton-left_2_0': 0},
)
field_id_25092_mean_fa_in_cingulum_hippocampus_on_fa_skeleton_right_2_0 = TensorMap(
    '25092_Mean-FA-in-cingulum-hippocampus-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25092_Mean-FA-in-cingulum-hippocampus-on-FA-skeleton-right_2_0': 0},
)
field_id_25091_mean_fa_in_cingulum_cingulate_gyrus_on_fa_skeleton_left_2_0 = TensorMap(
    '25091_Mean-FA-in-cingulum-cingulate-gyrus-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25091_Mean-FA-in-cingulum-cingulate-gyrus-on-FA-skeleton-left_2_0': 0},
)
field_id_25090_mean_fa_in_cingulum_cingulate_gyrus_on_fa_skeleton_right_2_0 = TensorMap(
    '25090_Mean-FA-in-cingulum-cingulate-gyrus-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25090_Mean-FA-in-cingulum-cingulate-gyrus-on-FA-skeleton-right_2_0': 0},
)
field_id_25089_mean_fa_in_external_capsule_on_fa_skeleton_left_2_0 = TensorMap(
    '25089_Mean-FA-in-external-capsule-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25089_Mean-FA-in-external-capsule-on-FA-skeleton-left_2_0': 0},
)
field_id_25088_mean_fa_in_external_capsule_on_fa_skeleton_right_2_0 = TensorMap(
    '25088_Mean-FA-in-external-capsule-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25088_Mean-FA-in-external-capsule-on-FA-skeleton-right_2_0': 0},
)
field_id_25087_mean_fa_in_sagittal_stratum_on_fa_skeleton_left_2_0 = TensorMap(
    '25087_Mean-FA-in-sagittal-stratum-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25087_Mean-FA-in-sagittal-stratum-on-FA-skeleton-left_2_0': 0},
)
field_id_25086_mean_fa_in_sagittal_stratum_on_fa_skeleton_right_2_0 = TensorMap(
    '25086_Mean-FA-in-sagittal-stratum-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25086_Mean-FA-in-sagittal-stratum-on-FA-skeleton-right_2_0': 0},
)
field_id_25085_mean_fa_in_posterior_thalamic_radiation_on_fa_skeleton_left_2_0 = TensorMap(
    '25085_Mean-FA-in-posterior-thalamic-radiation-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25085_Mean-FA-in-posterior-thalamic-radiation-on-FA-skeleton-left_2_0': 0},
)
field_id_25084_mean_fa_in_posterior_thalamic_radiation_on_fa_skeleton_right_2_0 = TensorMap(
    '25084_Mean-FA-in-posterior-thalamic-radiation-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25084_Mean-FA-in-posterior-thalamic-radiation-on-FA-skeleton-right_2_0': 0},
)
field_id_25083_mean_fa_in_posterior_corona_radiata_on_fa_skeleton_left_2_0 = TensorMap(
    '25083_Mean-FA-in-posterior-corona-radiata-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25083_Mean-FA-in-posterior-corona-radiata-on-FA-skeleton-left_2_0': 0},
)
field_id_25082_mean_fa_in_posterior_corona_radiata_on_fa_skeleton_right_2_0 = TensorMap(
    '25082_Mean-FA-in-posterior-corona-radiata-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25082_Mean-FA-in-posterior-corona-radiata-on-FA-skeleton-right_2_0': 0},
)
field_id_25081_mean_fa_in_superior_corona_radiata_on_fa_skeleton_left_2_0 = TensorMap(
    '25081_Mean-FA-in-superior-corona-radiata-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25081_Mean-FA-in-superior-corona-radiata-on-FA-skeleton-left_2_0': 0},
)
field_id_25080_mean_fa_in_superior_corona_radiata_on_fa_skeleton_right_2_0 = TensorMap(
    '25080_Mean-FA-in-superior-corona-radiata-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25080_Mean-FA-in-superior-corona-radiata-on-FA-skeleton-right_2_0': 0},
)
field_id_25079_mean_fa_in_anterior_corona_radiata_on_fa_skeleton_left_2_0 = TensorMap(
    '25079_Mean-FA-in-anterior-corona-radiata-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25079_Mean-FA-in-anterior-corona-radiata-on-FA-skeleton-left_2_0': 0},
)
field_id_25078_mean_fa_in_anterior_corona_radiata_on_fa_skeleton_right_2_0 = TensorMap(
    '25078_Mean-FA-in-anterior-corona-radiata-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25078_Mean-FA-in-anterior-corona-radiata-on-FA-skeleton-right_2_0': 0},
)
field_id_25077_mean_fa_in_retrolenticular_part_of_internal_capsule_on_fa_skeleton_left_2_0 = TensorMap(
    '25077_Mean-FA-in-retrolenticular-part-of-internal-capsule-on-FA-skeleton-left_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'25077_Mean-FA-in-retrolenticular-part-of-internal-capsule-on-FA-skeleton-left_2_0': 0},
)
field_id_25076_mean_fa_in_retrolenticular_part_of_internal_capsule_on_fa_skeleton_right_2_0 = TensorMap(
    '25076_Mean-FA-in-retrolenticular-part-of-internal-capsule-on-FA-skeleton-right_2_0', path_prefix='continuous',
    loss='logcosh',
    channel_map={'25076_Mean-FA-in-retrolenticular-part-of-internal-capsule-on-FA-skeleton-right_2_0': 0},
)
field_id_25075_mean_fa_in_posterior_limb_of_internal_capsule_on_fa_skeleton_left_2_0 = TensorMap(
    '25075_Mean-FA-in-posterior-limb-of-internal-capsule-on-FA-skeleton-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25075_Mean-FA-in-posterior-limb-of-internal-capsule-on-FA-skeleton-left_2_0': 0},
)
field_id_25074_mean_fa_in_posterior_limb_of_internal_capsule_on_fa_skeleton_right_2_0 = TensorMap(
    '25074_Mean-FA-in-posterior-limb-of-internal-capsule-on-FA-skeleton-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25074_Mean-FA-in-posterior-limb-of-internal-capsule-on-FA-skeleton-right_2_0': 0},
)
field_id_25073_mean_fa_in_anterior_limb_of_internal_capsule_on_fa_skeleton_left_2_0 = TensorMap(
    '25073_Mean-FA-in-anterior-limb-of-internal-capsule-on-FA-skeleton-left_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25073_Mean-FA-in-anterior-limb-of-internal-capsule-on-FA-skeleton-left_2_0': 0},
)
field_id_25072_mean_fa_in_anterior_limb_of_internal_capsule_on_fa_skeleton_right_2_0 = TensorMap(
    '25072_Mean-FA-in-anterior-limb-of-internal-capsule-on-FA-skeleton-right_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'25072_Mean-FA-in-anterior-limb-of-internal-capsule-on-FA-skeleton-right_2_0': 0},
)
field_id_25071_mean_fa_in_cerebral_peduncle_on_fa_skeleton_left_2_0 = TensorMap(
    '25071_Mean-FA-in-cerebral-peduncle-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25071_Mean-FA-in-cerebral-peduncle-on-FA-skeleton-left_2_0': 0},
)
field_id_25070_mean_fa_in_cerebral_peduncle_on_fa_skeleton_right_2_0 = TensorMap(
    '25070_Mean-FA-in-cerebral-peduncle-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25070_Mean-FA-in-cerebral-peduncle-on-FA-skeleton-right_2_0': 0},
)
field_id_25069_mean_fa_in_superior_cerebellar_peduncle_on_fa_skeleton_left_2_0 = TensorMap(
    '25069_Mean-FA-in-superior-cerebellar-peduncle-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25069_Mean-FA-in-superior-cerebellar-peduncle-on-FA-skeleton-left_2_0': 0},
)
field_id_25068_mean_fa_in_superior_cerebellar_peduncle_on_fa_skeleton_right_2_0 = TensorMap(
    '25068_Mean-FA-in-superior-cerebellar-peduncle-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25068_Mean-FA-in-superior-cerebellar-peduncle-on-FA-skeleton-right_2_0': 0},
)
field_id_25067_mean_fa_in_inferior_cerebellar_peduncle_on_fa_skeleton_left_2_0 = TensorMap(
    '25067_Mean-FA-in-inferior-cerebellar-peduncle-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25067_Mean-FA-in-inferior-cerebellar-peduncle-on-FA-skeleton-left_2_0': 0},
)
field_id_25066_mean_fa_in_inferior_cerebellar_peduncle_on_fa_skeleton_right_2_0 = TensorMap(
    '25066_Mean-FA-in-inferior-cerebellar-peduncle-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25066_Mean-FA-in-inferior-cerebellar-peduncle-on-FA-skeleton-right_2_0': 0},
)
field_id_25065_mean_fa_in_medial_lemniscus_on_fa_skeleton_left_2_0 = TensorMap(
    '25065_Mean-FA-in-medial-lemniscus-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25065_Mean-FA-in-medial-lemniscus-on-FA-skeleton-left_2_0': 0},
)
field_id_25064_mean_fa_in_medial_lemniscus_on_fa_skeleton_right_2_0 = TensorMap(
    '25064_Mean-FA-in-medial-lemniscus-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25064_Mean-FA-in-medial-lemniscus-on-FA-skeleton-right_2_0': 0},
)
field_id_25063_mean_fa_in_corticospinal_tract_on_fa_skeleton_left_2_0 = TensorMap(
    '25063_Mean-FA-in-corticospinal-tract-on-FA-skeleton-left_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25063_Mean-FA-in-corticospinal-tract-on-FA-skeleton-left_2_0': 0},
)
field_id_25062_mean_fa_in_corticospinal_tract_on_fa_skeleton_right_2_0 = TensorMap(
    '25062_Mean-FA-in-corticospinal-tract-on-FA-skeleton-right_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25062_Mean-FA-in-corticospinal-tract-on-FA-skeleton-right_2_0': 0},
)
field_id_25061_mean_fa_in_fornix_on_fa_skeleton_2_0 = TensorMap(
    '25061_Mean-FA-in-fornix-on-FA-skeleton_2_0',
    path_prefix='continuous', loss='logcosh', channel_map={
        '25061_Mean-FA-in-fornix-on-FA-skeleton_2_0': 0,
    },
)
field_id_25060_mean_fa_in_splenium_of_corpus_callosum_on_fa_skeleton_2_0 = TensorMap(
    '25060_Mean-FA-in-splenium-of-corpus-callosum-on-FA-skeleton_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25060_Mean-FA-in-splenium-of-corpus-callosum-on-FA-skeleton_2_0': 0},
)
field_id_25059_mean_fa_in_body_of_corpus_callosum_on_fa_skeleton_2_0 = TensorMap(
    '25059_Mean-FA-in-body-of-corpus-callosum-on-FA-skeleton_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25059_Mean-FA-in-body-of-corpus-callosum-on-FA-skeleton_2_0': 0},
)
field_id_25058_mean_fa_in_genu_of_corpus_callosum_on_fa_skeleton_2_0 = TensorMap(
    '25058_Mean-FA-in-genu-of-corpus-callosum-on-FA-skeleton_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25058_Mean-FA-in-genu-of-corpus-callosum-on-FA-skeleton_2_0': 0},
)
field_id_25057_mean_fa_in_pontine_crossing_tract_on_fa_skeleton_2_0 = TensorMap(
    '25057_Mean-FA-in-pontine-crossing-tract-on-FA-skeleton_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25057_Mean-FA-in-pontine-crossing-tract-on-FA-skeleton_2_0': 0},
)
field_id_25056_mean_fa_in_middle_cerebellar_peduncle_on_fa_skeleton_2_0 = TensorMap(
    '25056_Mean-FA-in-middle-cerebellar-peduncle-on-FA-skeleton_2_0', path_prefix='continuous', loss='logcosh',
    channel_map={'25056_Mean-FA-in-middle-cerebellar-peduncle-on-FA-skeleton_2_0': 0},
)
field_id_20009_interpolated_age_of_participant_when_noncancer_illness_first_diagnosed_2_0 = TensorMap(
    '20009_Interpolated-Age-of-participant-when-noncancer-illness-first-diagnosed_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'20009_Interpolated-Age-of-participant-when-noncancer-illness-first-diagnosed_2_0': 0},
)
field_id_3526_mothers_age_at_death_2_0 = TensorMap(
    '3526_Mothers-age-at-death_2_0', path_prefix='continuous',
    loss='logcosh', channel_map={'3526_Mothers-age-at-death_2_0': 0},
)
field_id_3872_age_of_primiparous_women_at_birth_of_child_0_0 = TensorMap(
    '3872_Age-of-primiparous-women-at-birth-of-child_0_0', path_prefix='continuous', loss='logcosh',
    channel_map={'3872_Age-of-primiparous-women-at-birth-of-child_0_0': 0},
)
