from ml4h.defines import StorageType
from ml4h.TensorMap import TensorMap, Interpretation

categorical_21_completeness_80 = TensorMap(
    'categorical_21_completeness_80', Interpretation.CATEGORICAL, shape=(21,),
    loss='mse', path_prefix='categorical', metrics=[],
    channel_map={
        'death': 0, 'Pacemaker_No_0_0': 1, 'Adopted-as-a-child_No_0_0': 2, 'Part-of-a-multiple-birth_No_0_0': 3,
        'Diabetes-diagnosed-by-doctor_No_0_0': 4, 'Alcohol-drinker-status_Current_0_0': 5,
        'Contraindications-for-spirometry_No_0_0': 6, 'Cancer-diagnosed-by-doctor_No_0_0': 7,
        'Used-an-inhaler-for-chest-within-last-hour_No_0_0': 8, 'Result-ranking_best_0_0': 9,
        'Type-of-accommodation-lived-in_A-house-or-bungalow_0_0': 10, 'Result-ranking_second-best_0_1': 11,
        'Caffeine-drink-within-last-hour_No_0_0': 12, 'Handedness-chiralitylaterality_Righthanded_0_0': 13,
        'Fracturedbroken-bones-in-last-5-years_No_0_0': 14, 'Current-tobacco-smoking_No_0_0': 15,
        'Wears-glasses-or-contact-lenses_Yes_0_0': 16, 'Ethnic-background_British_0_0': 17,
        'Other-eye-problems_No_0_0': 18, 'Chest-pain-or-discomfort_No_0_0': 19,
        'Smokingsmokers-in-household_No_0_0': 20,
    },
)

categorical_612_completeness_7 = TensorMap(
    'categorical_612_completeness_7', Interpretation.CATEGORICAL, shape=(612,),
    loss='mse', path_prefix='categorical', metrics=[],
    channel_map={
        'death': 0, 'Pacemaker_No_0_0': 1, 'Adopted-as-a-child_No_0_0': 2, 'Part-of-a-multiple-birth_No_0_0': 3,
        'Diabetes-diagnosed-by-doctor_No_0_0': 4, 'Alcohol-drinker-status_Current_0_0': 5,
        'Contraindications-for-spirometry_No_0_0': 6, 'Cancer-diagnosed-by-doctor_No_0_0': 7,
        'Used-an-inhaler-for-chest-within-last-hour_No_0_0': 8, 'Result-ranking_best_0_0': 9,
        'Type-of-accommodation-lived-in_A-house-or-bungalow_0_0': 10, 'Result-ranking_second-best_0_1': 11,
        'Caffeine-drink-within-last-hour_No_0_0': 12, 'Handedness-chiralitylaterality_Righthanded_0_0': 13,
        'Fracturedbroken-bones-in-last-5-years_No_0_0': 14, 'Current-tobacco-smoking_No_0_0': 15,
        'Wears-glasses-or-contact-lenses_Yes_0_0': 16, 'Ethnic-background_British_0_0': 17,
        'Other-eye-problems_No_0_0': 18, 'Chest-pain-or-discomfort_No_0_0': 19,
        'Smokingsmokers-in-household_No_0_0': 20, 'Falls-in-the-last-year_No-falls_0_0': 21,
        'Never-eat-eggs-dairy-wheat-sugar_I-eat-all-of-the-above_0_0': 22,
        'Country-of-birth-UKelsewhere_England_0_0': 23,
        'Types-of-transport-used-excluding-work_Carmotor-vehicle_0_0': 24,
        'Other-serious-medical-conditiondisability-diagnosed-by-doctor_No_0_0': 25,
        'Wheeze-or-whistling-in-the-chest-in-last-year_No_0_0': 26, 'Father-still-alive_No_0_0': 27,
        'Vascularheart-problems-diagnosed-by-doctor_None-of-the-above_0_0': 28, 'Hearing-difficultyproblems_No_0_0': 29,
        'Types-of-physical-activity-in-last-4-weeks_Walking-for-pleasure-not-as-a-means-of-transport_0_0': 30,
        'Ever-had-bowel-cancer-screening_No_0_0': 31, 'Result-ranking_third-best-ie-worst_0_2': 32,
        'Skin-colour_Fair_0_0': 33,
        'Blood-clot-DVT-bronchitis-emphysema-asthma-rhinitis-eczema-allergy-diagnosed-by-doctor_None-of-the-above_0_0': 34,
        'Hot-drink-temperature_Hot_0_0': 35, 'Vitamin-and-mineral-supplements_None-of-the-above_0_0': 36,
        'Facial-ageing_Younger-than-you-are_0_0': 37, 'Longstanding-illness-disability-or-infirmity_No_0_0': 38,
        'Major-dietary-changes-in-the-last-5-years_No_0_0': 39, 'Milk-type-used_Semiskimmed_0_0': 40,
        'Maternal-smoking-around-birth_No_0_0': 41, 'Illnesses-of-siblings_None-of-the-above-group-2_0_1': 42,
        'Hearing-difficultyproblems-with-background-noise_No_0_0': 43,
        'Mouthteeth-dental-problems_None-of-the-above_0_0': 44,
        'Current-employment-status_In-paid-employment-or-selfemployed_0_0': 45, 'Hearing-aid-user_No_0_0': 46,
        'Ever-smoked_Yes_0_0': 47, 'Mother-still-alive_No_0_0': 48, 'Variation-in-diet_Sometimes_0_0': 49,
        'Lambmutton-intake_Less-than-once-a-week_0_0': 50, 'Smoking-status_Never_0_0': 51,
        'Overall-health-rating_Good_0_0': 52, 'Mineral-and-other-dietary-supplements_None-of-the-above_0_0': 53,
        'Pork-intake_Less-than-once-a-week_0_0': 54, 'Salt-added-to-food_Neverrarely_0_0': 55,
        'Breastfed-as-a-baby_Yes_0_0': 56, 'Birth-weight-known_Yes-pounds-and-ounces_0_0': 57,
        'Illnesses-of-mother_None-of-the-above-group-2_0_1': 58, 'Usual-walking-pace_Steady-average-pace_0_0': 59,
        'Weight-change-compared-with-1-year-ago_No-weigh-about-the-same_0_0': 60, 'Sex_Female_0_0': 61,
        'Pregnant_No_0_0': 62, 'Bread-type_Wholemeal-or-wholegrain_0_0': 63,
        'Taking-other-prescription-medications_No_0_0': 64, 'Spread-type_Other-type-of-spreadmargarine_0_0': 65,
        'Ever-had-cervical-smear-test_Yes_0_0': 66,
        'Medication-for-pain-relief-constipation-heartburn_None-of-the-above_0_0': 67,
        'Comparative-height-size-at-age-10_About-average_0_0': 68,
        'Illnesses-of-father_None-of-the-above-group-2_0_1': 69,
        'Comparative-body-size-at-age-10_About-average_0_0': 70, 'Nonoily-fish-intake_Once-a-week_0_0': 71,
        'Own-or-rent-accommodation-lived-in_Own-outright-by-you-or-someone-in-your-household_0_0': 72,
        'Bilateral-oophorectomy-both-ovaries-removed_No_0_0': 73,
        'Taking-other-prescription-medications_Yes-you-will-be-asked-about-this-later-by-an-interviewer_0_0': 74,
        'Sex_Male_0_0': 75, 'Poultry-intake_24-times-a-week_0_0': 76, 'Beef-intake_Less-than-once-a-week_0_0': 77,
        'Illnesses-of-siblings_None-of-the-above-group-1_0_0': 78, 'FI1-numeric-addition-test_15_0_0': 79,
        'Cheese-intake_24-times-a-week_0_0': 80, 'Birth-weight-known_No_0_0': 81,
        'Ever-taken-oral-contraceptive-pill_Yes_0_0': 82, 'Coffee-type_Instant-coffee_0_0': 83,
        'Ever-had-hysterectomy-womb-removed_No_0_0': 84, 'Ever-had-breast-cancer-screening-mammogram_Yes_0_0': 85,
        'Alcohol-intake-versus-10-years-previously_Less-nowadays_0_0': 86,
        'Past-tobacco-smoking_I-have-never-smoked_0_0': 87, 'Ever-smoked_No_0_0': 88,
        'Drive-faster-than-motorway-speed-limit_Neverrarely_0_0': 89, 'Mother-still-alive_Yes_0_0': 90,
        'Own-or-rent-accommodation-lived-in_Own-with-a-mortgage_0_0': 91,
        'Hair-colour-natural-before-greying_Light-brown_0_0': 92, 'FI4-positional-arithmetic_6_0_0': 93,
        'Pain-types-experienced-in-last-month_None-of-the-above_0_0': 94,
        'Relative-age-voice-broke_About-average-age_0_0': 95,
        'Hearing-difficultyproblems-with-background-noise_Yes_0_0': 96,
        'Ease-of-skin-tanning_Get-moderately-tanned_0_0': 97, 'Usual-walking-pace_Brisk-pace_0_0': 98,
        'Medication-for-cholesterol-blood-pressure-diabetes-or-take-exogenous-hormones_None-of-the-above_0_0': 99,
        'hypertension': 100, 'Oily-fish-intake_Once-a-week_0_0': 101, 'Poultry-intake_Once-a-week_0_0': 102,
        'Types-of-physical-activity-in-last-4-weeks_Other-exercises-eg-swimming-cycling-keep-fit-bowling_0_1': 103,
        'Drive-faster-than-motorway-speed-limit_Sometimes_0_0': 104,
        'Frequency-of-stair-climbing-in-last-4-weeks_610-times-a-day_0_0': 105,
        'Use-of-sunuv-protection_Most-of-the-time_0_0': 106,
        'Ever-had-stillbirth-spontaneous-miscarriage-or-termination_No_0_0': 107,
        'Hair-colour-natural-before-greying_Dark-brown_0_0': 108,
        'Relative-age-of-first-facial-hair_About-average-age_0_0': 109,
        'Had-other-major-operations_Yes-you-will-be-asked-about-this-later-by-an-interviewer_0_0': 110,
        'Types-of-transport-used-excluding-work_Walk_0_1': 111,
        'Alcohol-intake-versus-10-years-previously_About-the-same_0_0': 112,
        'Spread-type_Butterspreadable-butter_0_0': 113, 'Variation-in-diet_Neverrarely_0_0': 114,
        'Alcohol-usually-taken-with-meals_Yes_0_0': 115, 'Qualifications_College-or-University-degree_0_0': 116,
        'Test-completion-status_complete_0_0': 117, 'Cochlear-implant_No_0_0': 118,
        'Stiffness-method_Direct-entry_0_0': 119, 'Oily-fish-intake_Less-than-once-a-week_0_0': 120,
        'Had-menopause_Yes_0_0': 121, 'Ever-used-hormonereplacement-therapy-HRT_No_0_0': 122,
        'Use-of-sunuv-protection_Sometimes_0_0': 123, 'Hearing-test-done_Yes_0_0': 124,
        'Current-employment-status_Retired_0_0': 125, 'Attempted-fluid-intelligence-FI-test_Begin-puzzles_0_0': 126,
        'Fractured-heel-right_no_0_0': 127, 'Fractured-heel-left_no_0_0': 128,
        'Comparative-body-size-at-age-10_Thinner_0_0': 129, 'Longstanding-illness-disability-or-infirmity_Yes_0_0': 130,
        'Heel-ultrasound-method-left_Direct-entry_0_0': 131, 'Completion-status-right_completed_0_0': 132,
        'Smoking-status_Previous_0_0': 133, 'Completion-status-left_completed_0_0': 134,
        'Heel-ultrasound-method-right_Direct-entry_0_0': 135, 'Ever-had-prostate-specific-antigen-PSA-test_No_0_0': 136,
        'PM-final-answer_Orange-circle_0_0': 137, 'Final-attempt-correct_yes_0_0': 138,
        'Beef-intake_Once-a-week_0_0': 139,
        'Medication-for-cholesterol-blood-pressure-or-diabetes_None-of-the-above_0_0': 140,
        'Mineral-and-other-dietary-supplements_Fish-oil-including-cod-liver-oil_0_0': 141,
        'Ever-had-bowel-cancer-screening_Yes_0_0': 142,
        'Weight-change-compared-with-1-year-ago_Yes-gained-weight_0_0': 143,
        'Processed-meat-intake_Less-than-once-a-week_0_0': 144, 'Triplet-correct-right_yes_0_1': 145,
        'Nonoily-fish-intake_Less-than-once-a-week_0_0': 146, 'Processed-meat-intake_Once-a-week_0_0': 147,
        'Had-major-operations_Yes-you-will-be-asked-about-this-later-by-an-interviewer_0_0': 148,
        'Loud-music-exposure-frequency_No_0_0': 149, 'Shortness-of-breath-walking-on-level-ground_No_0_0': 150,
        'Triplet-correct-left_yes_0_1': 151, 'Absence-of-notch-position-in-the-pulse-waveform_False_0_0': 152,
        'Alcohol-usually-taken-with-meals_It-varies_0_0': 153, 'Processed-meat-intake_24-times-a-week_0_0': 154,
        'Salt-added-to-food_Sometimes_0_0': 155,
        'Major-dietary-changes-in-the-last-5-years_Yes-because-of-other-reasons_0_0': 156,
        'Alcohol-intake-frequency_Once-or-twice-a-week_0_0': 157, 'Eye-problemsdisorders_None-of-the-above_0_0': 158,
        'Illnesses-of-mother_None-of-the-above-group-1_0_0': 159, 'Bread-type_White_0_0': 160,
        'Comparative-height-size-at-age-10_Taller_0_0': 161, 'Triplet-correct-right_yes_0_2': 162,
        'Duration-walking-for-pleasure_Between-30-minutes-and-1-hour_0_0': 163, 'Triplet-correct-left_yes_0_2': 164,
        'Prospective-memory-result_Correct-recall-on-first-attempt_0_0': 165,
        'PM-initial-answer_Orange-circle_0_0': 166, 'Noisy-workplace_No_0_0': 167, 'Leg-pain-on-walking_No_0_0': 168,
        'Hearing-difficultyproblems_Yes_0_0': 169, 'FI2-identify-largest-number_987_0_0': 170,
        'Maternal-smoking-around-birth_Yes_0_0': 171, 'Breastfed-as-a-baby_Do-not-know_0_0': 172,
        'Father-still-alive_Yes_0_0': 173, 'Average-total-household-income-before-tax_31000-to-51999_0_0': 174,
        'Tinnitus_No-never_0_0': 175, 'Both-eyes-present_Yes_0_0': 176,
        'Visual-acuity-measured-right_Measurable_0_0': 177,
        'Vascularheart-problems-diagnosed-by-doctor_High-blood-pressure_0_0': 178,
        'Visual-acuity-measured-left_Measurable_0_0': 179, 'Direct-or-mirror-view-right_plain_0_0': 180,
        'Direct-or-mirror-view-left_plain_0_0': 181, 'Current-eye-infection_No_0_0': 182,
        'Types-of-physical-activity-in-last-4-weeks_Light-DIY-eg-pruning-watering-the-lawn_0_1': 183,
        'Pork-intake_Once-a-week_0_0': 184, 'Worked-with-pesticides_Rarelynever_0_0': 185,
        'Overall-health-rating_Fair_0_0': 186, 'Illnesses-of-father_None-of-the-above-group-1_0_0': 187,
        'Breathing-problems-during-period-of-job_No_0_0': 188, 'Autorefraction-method-right_Measurable_0_0': 189,
        'Illnesses-of-mother_High-blood-pressure_0_0': 190, 'Autorefraction-method-left_Measurable_0_0': 191,
        'Past-tobacco-smoking_Smoked-on-most-or-all-days_0_0': 192, 'Lambmutton-intake_Once-a-week_0_0': 193,
        'osteoarthritis': 194, 'Alcohol-intake-frequency_Daily-or-almost-daily_0_0': 195,
        'Intraocular-pressure-IOP-method-right_Measurable_0_0': 196, 'Milk-type-used_Skimmed_0_0': 197,
        'Noncancer-illness-code-selfreported_hypertension_0_0': 198, 'Ever-had-eye-surgery_No_0_0': 199,
        'Facial-ageing_About-your-age_0_0': 200, 'Intraocular-pressure-IOP-method-left_Measurable_0_0': 201,
        'Nonaccidental-death-in-close-genetic-family_No_0_0': 202,
        'Ease-of-skin-tanning_Get-mildly-or-occasionally-tanned_0_0': 203,
        'Cereal-type_Oat-cereal-eg-Ready-Brek-porridge_0_0': 204,
        'Alcohol-intake-frequency_Three-or-four-times-a-week_0_0': 205,
        'Average-total-household-income-before-tax_18000-to-30999_0_0': 206, 'Cheese-intake_Once-a-week_0_0': 207,
        'Qualifications_O-levelsGCSEs-or-equivalent_0_0': 208, 'Breastfed-as-a-baby_No_0_0': 209,
        'Ever-used-hormonereplacement-therapy-HRT_Yes_0_0': 210,
        'Pain-types-experienced-in-last-month_Headache_0_0': 211, 'hypercholesterolemia': 212,
        'Workplace-had-a-lot-of-diesel-exhaust_Rarelynever_0_0': 213,
        'Frequency-of-walking-for-pleasure-in-last-4-weeks_23-times-in-the-last-4-weeks_0_0': 214,
        'Frequency-of-stair-climbing-in-last-4-weeks_15-times-a-day_0_0': 215,
        'Wheeze-or-whistling-in-the-chest-in-last-year_Yes_0_0': 216, 'Ease-of-skin-tanning_Get-very-tanned_0_0': 217,
        'FI3-word-interpolation_adult_0_0': 218, 'Comparative-height-size-at-age-10_Shorter_0_0': 219,
        'Other-serious-medical-conditiondisability-diagnosed-by-doctor_Yes-you-will-be-asked-about-this-later-by-an-interviewer_0_0': 220,
        'Worked-with-paints-thinners-or-glues_Rarelynever_0_0': 221, 'Job-involved-shift-work_No_0_0': 222,
        'Duration-of-other-exercises_Between-30-minutes-and-1-hour_0_0': 223, 'Use-of-sunuv-protection_Always_0_0': 224,
        'Type-of-tobacco-previously-smoked_Manufactured-cigarettes_0_0': 225, 'Back-pain-for-3-months_Yes_0_0': 226,
        'Reason-for-reducing-amount-of-alcohol-drunk_Other-reason_0_0': 227, 'Triplet-correct-right_yes_0_3': 228,
        'Frequency-of-stair-climbing-in-last-4-weeks_1115-times-a-day_0_0': 229,
        'Workplace-full-of-chemical-or-other-fumes_Rarelynever_0_0': 230, 'Skin-colour_Light-olive_0_0': 231,
        'Likelihood-of-resuming-smoking_No-definitely-not_0_0': 232,
        'Worked-with-materials-containing-asbestos_Rarelynever_0_0': 233,
        'Nonbutter-spread-type-details_Polyunsaturatedsunflower-oil-based-spread-eg-Flora_0_0': 234,
        'Triplet-correct-left_yes_0_3': 235, 'anycancer': 236,
        'Types-of-physical-activity-in-last-4-weeks_Light-DIY-eg-pruning-watering-the-lawn_0_2': 237,
        'Blood-clot-DVT-bronchitis-emphysema-asthma-rhinitis-eczema-allergy-diagnosed-by-doctor_Hayfever-allergic-rhinitis-or-eczema_0_0': 238,
        'Had-other-major-operations_No_0_0': 239, 'Average-total-household-income-before-tax_Less-than-18000_0_0': 240,
        'Average-total-household-income-before-tax_52000-to-100000_0_0': 241,
        'Ease-of-skin-tanning_Never-tan-only-burn_0_0': 242, 'Triplet-correct-left_yes_0_5': 243,
        'Types-of-physical-activity-in-last-4-weeks_Heavy-DIY-eg-weeding-lawn-mowing-carpentry-digging_0_2': 244,
        'Triplet-correct-left_yes_0_6': 245, 'Triplet-correct-right_yes_0_8': 246,
        'Qualifications_None-of-the-above_0_0': 247, 'Workplace-very-dusty_Rarelynever_0_0': 248,
        'Coffee-type_Ground-coffee-include-espresso-filter-etc_0_0': 249, 'Triplet-correct-left_yes_0_7': 250,
        'Hot-drink-temperature_Very-hot_0_0': 251, 'Triplet-correct-right_yes_0_6': 252,
        'Cheese-intake_Less-than-once-a-week_0_0': 253, 'Pork-intake_Never_0_0': 254,
        'Lambmutton-intake_Never_0_0': 255, 'FI7-synonym_cease_0_0': 256, 'Triplet-correct-right_yes_0_11': 257,
        'Breathing-problems-during-period-of-job_No_0_1': 258, 'Knee-pain-for-3-months_Yes_0_0': 259,
        'Ever-had-stillbirth-spontaneous-miscarriage-or-termination_Yes_0_0': 260,
        'Worked-with-pesticides_Rarelynever_0_1': 261, 'Triplet-correct-right_no_0_4': 262,
        'Frequency-of-other-exercises-in-last-4-weeks_23-times-a-week_0_0': 263,
        'Cereal-type_Other-eg-Cornflakes-Frosties_0_0': 264, 'Triplet-correct-left_yes_0_9': 265,
        'Vitamin-and-mineral-supplements_Multivitamins-minerals_0_0': 266, 'Triplet-correct-left_yes_0_10': 267,
        'Triplet-correct-left_yes_0_8': 268, 'Oily-fish-intake_24-times-a-week_0_0': 269,
        'Had-major-operations_No_0_0': 270, 'Alcohol-usually-taken-with-meals_No_0_0': 271,
        'Triplet-correct-left_no_0_4': 272, 'Neckshoulder-pain-for-3-months_Yes_0_0': 273,
        'Triplet-correct-right_yes_0_12': 274, 'Cereal-type_Muesli_0_0': 275, 'Triplet-correct-left_yes_0_13': 276,
        'Triplet-correct-left_yes_0_11': 277, 'Triplet-correct-left_yes_0_14': 278,
        'Triplet-correct-right_yes_0_7': 279, 'Duration-of-light-DIY_Between-30-minutes-and-1-hour_0_0': 280,
        'Triplet-correct-right_yes_0_13': 281, 'Triplet-correct-right_yes_0_10': 282,
        'FI6-conditional-arithmetic_69_0_0': 283, 'Workplace-very-cold_Rarelynever_0_0': 284,
        'Triplet-correct-right_yes_0_9': 285, 'Triplet-correct-left_no_0_12': 286, 'Triplet-correct-left_yes_0_15': 287,
        'Triplet-correct-right_no_0_5': 288, 'Triplet-correct-right_yes_0_15': 289,
        'Triplet-correct-right_yes_0_5': 290, 'Triplet-correct-right_yes_0_14': 291,
        'Overall-health-rating_Excellent_0_0': 292, 'Triplet-correct-right_no_0_14': 293,
        'Triplet-correct-right_no_0_15': 294, 'Triplet-correct-left_yes_0_12': 295, 'Triplet-correct-left_no_0_15': 296,
        'Triplet-correct-right_no_0_9': 297, 'Triplet-correct-right_no_0_10': 298, 'Triplet-correct-right_no_0_7': 299,
        'Triplet-correct-right_no_0_13': 300, 'Qualifications_A-levelsAS-levels-or-equivalent_0_1': 301, 'hernia': 302,
        'Chest-pain-felt-outside-physical-activity_No_0_0': 303, 'Triplet-correct-left_no_0_11': 304,
        'composite_mi_cad_stroke_death': 305, 'Comparative-body-size-at-age-10_Plumper_0_0': 306,
        'Triplet-correct-left_no_0_14': 307, 'Job-involved-shift-work_No_0_1': 308,
        'Chest-pain-or-discomfort_Yes_0_0': 309, 'Triplet-correct-left_yes_0_4': 310,
        'Triplet-correct-left_no_0_13': 311, 'composite_mi_cad_stroke_death_exclude_aml': 312,
        'Workplace-had-a-lot-of-diesel-exhaust_Rarelynever_0_1': 313,
        'Doctor-restricts-physical-activity-due-to-heart-condition_No_0_0': 314, 'Triplet-correct-right_no_0_12': 315,
        'Pain-types-experienced-in-last-month_Neck-or-shoulder-pain_0_0': 316,
        'Alcohol-intake-versus-10-years-previously_More-nowadays_0_0': 317,
        'composite_mi_cad_stroke_death_exclude_heme': 318,
        'Frequency-of-walking-for-pleasure-in-last-4-weeks_23-times-a-week_0_0': 319,
        'Triplet-correct-left_no_0_8': 320, 'Triplet-correct-left_no_0_10': 321,
        'Chest-pain-felt-during-physical-activity_No_0_0': 322,
        'Duration-walking-for-pleasure_Between-15-and-30-minutes_0_0': 323, 'Triplet-correct-right_yes_0_4': 324,
        'Triplet-correct-left_no_0_9': 325, 'Able-to-walk-or-cycle-unaided-for-10-minutes_Yes_0_0': 326,
        'Worked-with-paints-thinners-or-glues_Rarelynever_0_1': 327,
        'Past-tobacco-smoking_Just-tried-once-or-twice_0_0': 328, 'Completion-status-of-test_Fully-completed_0_0': 329,
        'Hairbalding-pattern_Pattern-1_0_0': 330, 'Hot-drink-temperature_Warm_0_0': 331,
        'Triplet-correct-right_no_0_11': 332, 'Light-smokers-at-least-100-smokes-in-lifetime_No_0_0': 333,
        'Qualifications_O-levelsGCSEs-or-equivalent_0_2': 334, 'asthma': 335, 'Triplet-correct-right_no_0_6': 336,
        'Triplet-correct-left_no_0_7': 337, 'Cereal-type_Biscuit-cereal-eg-Weetabix_0_0': 338,
        'Coffee-type_Decaffeinated-coffee-any-type_0_0': 339,
        'Types-of-transport-used-excluding-work_Public-transport_0_2': 340,
        'Nonoily-fish-intake_24-times-a-week_0_0': 341,
        'Worked-with-materials-containing-asbestos_Rarelynever_0_1': 342,
        'Workplace-full-of-chemical-or-other-fumes_Rarelynever_0_1': 343, 'Triplet-correct-left_no_0_6': 344,
        'Target-heart-rate-achieved_False_0_0': 345, 'Triplet-correct-right_no_0_8': 346,
        'Triplet-correct-left_no_0_5': 347, 'Weight-change-compared-with-1-year-ago_Yes-lost-weight_0_0': 348,
        'Medication-for-pain-relief-constipation-heartburn_Aspirin_0_0': 349, 'Other-eye-problems_Yes_0_0': 350,
        'Never-eat-eggs-dairy-wheat-sugar_Sugar-or-foodsdrinks-containing-sugar_0_0': 351,
        'ECGbike-method-for-fitness-test_Bicycle_0_0': 352, 'Triplet-correct-left_no_0_3': 353,
        'Illnesses-of-father_High-blood-pressure_0_0': 354, 'OCT-measured-right_Measurable_0_0': 355,
        'Cereal-type_Bran-cereal-eg-All-Bran-Branflakes_0_0': 356, 'imaging': 357,
        'Falls-in-the-last-year_Only-one-fall_0_0': 358,
        'Medication-for-pain-relief-constipation-heartburn_Paracetamol_0_0': 359,
        'Medication-for-pain-relief-constipation-heartburn_Ibuprofen-eg-Nurofen_0_0': 360,
        'FI5-family-relationship-calculation_cousin_0_0': 361, 'OCT-measured-left_Measurable_0_0': 362,
        'Frequency-of-light-DIY-in-last-4-weeks_23-times-in-the-last-4-weeks_0_0': 363,
        'Worked-with-pesticides_Rarelynever_0_2': 364, 'Types-of-transport-used-excluding-work_Walk_0_0': 365,
        'Illnesses-of-siblings_High-blood-pressure_0_0': 366, 'Triplet-correct-right_no_0_3': 367,
        'Breathing-problems-during-period-of-job_No_0_2': 368, 'Menstruating-today_No_0_0': 369,
        'Past-tobacco-smoking_Smoked-occasionally_0_0': 370, 'Workplace-very-dusty_Rarelynever_0_1': 371,
        'Nonbutter-spread-type-details_Olive-oil-based-spread-eg-Bertolli_0_0': 372, 'Had-menopause_No_0_0': 373,
        'Workplace-very-hot_Rarelynever_0_0': 374, 'FI8-chained-arithmetic_26_0_0': 375,
        'Frequency-of-light-DIY-in-last-4-weeks_23-times-a-week_0_0': 376, 'Illnesses-of-father_Heart-disease_0_0': 377,
        'Workplace-very-noisy_Rarelynever_0_0': 378, 'composite_mi_cad_stroke_hf': 379,
        'Worked-with-paints-thinners-or-glues_Rarelynever_0_2': 380,
        'Chest-pain-or-discomfort-walking-normally_No_0_0': 381, 'Volume-level-set-by-participant-left_10_0_0': 382,
        'Job-involved-shift-work_No_0_2': 383, 'Frequency-of-walking-for-pleasure-in-last-4-weeks_Once-a-week_0_0': 384,
        'Ever-had-prostate-specific-antigen-PSA-test_Yes_0_0': 385, 'gastroesophageal_reflux_disease': 386,
        'Light-smokers-at-least-100-smokes-in-lifetime_Yes_0_0': 387,
        'Reason-for-reducing-amount-of-alcohol-drunk_Health-precaution_0_0': 388,
        'Pain-types-experienced-in-last-month_Back-pain_0_0': 389,
        'Workplace-had-a-lot-of-diesel-exhaust_Rarelynever_0_2': 390, 'Salt-added-to-food_Usually_0_0': 391,
        'Illnesses-of-mother_None-of-the-above-group-2_0_2': 392, 'Volume-level-set-by-participant-right_10_0_0': 393,
        'Bread-type_Brown_0_0': 394, 'Maternal-smoking-around-birth_Do-not-know_0_0': 395,
        'Types-of-physical-activity-in-last-4-weeks_Other-exercises-eg-swimming-cycling-keep-fit-bowling_0_0': 396,
        'Mouthteeth-dental-problems_Dentures_0_0': 397,
        'Workplace-full-of-chemical-or-other-fumes_Rarelynever_0_2': 398,
        'Frequency-of-heavy-DIY-in-last-4-weeks_23-times-in-the-last-4-weeks_0_0': 399,
        'Program-category_Category-1-cycle-rising-to-50-level_0_0': 400, 'Oily-fish-intake_Never_0_0': 401,
        'Hairbalding-pattern_Pattern-3_0_0': 402, 'Wears-glasses-or-contact-lenses_No_0_0': 403,
        'composite_mi_cad_stroke': 404, 'Ever-stopped-smoking-for-6-months_No_0_0': 405,
        'Beef-intake_24-times-a-week_0_0': 406, 'composite_mi_cad_stroke_exclude_heme': 407,
        'Duration-of-light-DIY_Between-15-and-30-minutes_0_0': 408, 'coronary_artery_disease_soft': 409,
        'Mineral-and-other-dietary-supplements_Glucosamine_0_1': 410,
        'Worked-with-materials-containing-asbestos_Rarelynever_0_2': 411,
        'Alcohol-intake-frequency_Special-occasions-only_0_0': 412,
        'Workplace-had-a-lot-of-cigarette-smoke-from-other-people-smoking_Rarelynever_0_0': 413,
        'Why-stopped-smoking_Health-precaution_0_0': 414,
        'Alcohol-intake-frequency_One-to-three-times-a-month_0_0': 415, 'Workplace-very-cold_Rarelynever_0_1': 416,
        'Smoking-status_Current_0_0': 417, 'composite_mi_cad_stroke_death_exclude_anycancer': 418,
        'Duration-walking-for-pleasure_Between-1-and-15-hours_0_0': 419,
        'Illnesses-of-father_None-of-the-above-group-2_0_2': 420, 'diverticular_disease': 421,
        'Workplace-had-a-lot-of-cigarette-smoke-from-other-people-smoking_Rarelynever_0_1': 422,
        'Workplace-very-dusty_Rarelynever_0_2': 423, 'Poultry-intake_Less-than-once-a-week_0_0': 424,
        'Mouthteeth-dental-problems_Bleeding-gums_0_0': 425, 'Headaches-for-3-months_No_0_0': 426,
        'Beef-intake_Never_0_0': 427, 'cataract': 428,
        'Blood-clot-DVT-bronchitis-emphysema-asthma-rhinitis-eczema-allergy-diagnosed-by-doctor_Asthma_0_0': 429,
        'Frequency-of-light-DIY-in-last-4-weeks_Once-a-week_0_0': 430,
        'Ever-had-breast-cancer-screening-mammogram_No_0_0': 431,
        'Qualifications_A-levelsAS-levels-or-equivalent_0_0': 432, 'Spread-type_Neverrarely-use-spread_0_0': 433,
        'Hair-colour-natural-before-greying_Blonde_0_0': 434, 'Illnesses-of-mother_None-of-the-above-group-1_0_1': 435,
        'Illnesses-of-father_None-of-the-above-group-1_0_1': 436, 'coronary_artery_disease_intermediate': 437,
        'Duration-of-other-exercises_Between-1-and-15-hours_0_0': 438, 'Operation-code_hysterectomy_0_0': 439,
        'Work-hours-lumped-category_30-to-40-hours_0_0': 440,
        'Frequency-of-heavy-DIY-in-last-4-weeks_Once-a-week_0_0': 441,
        'Types-of-physical-activity-in-last-4-weeks_Heavy-DIY-eg-weeding-lawn-mowing-carpentry-digging_0_3': 442,
        'Treatmentmedication-code_aspirin_0_0': 443,
        'Medication-for-cholesterol-blood-pressure-or-diabetes_Cholesterol-lowering-medication_0_0': 444,
        'Fracturedbroken-bones-in-last-5-years_Yes_0_0': 445, 'composite_mi_death': 446,
        'Duration-of-heavy-DIY_Between-30-minutes-and-1-hour_0_0': 447, 'Use-of-sunuv-protection_Neverrarely_0_0': 448,
        'Hairbalding-pattern_Pattern-2_0_0': 449, 'composite_af_chf_dcm_death': 450,
        'Workplace-very-hot_Rarelynever_0_1': 451,
        'Average-total-household-income-before-tax_Prefer-not-to-answer_0_0': 452,
        'Types-of-transport-used-excluding-work_Public-transport_0_1': 453, 'Workplace-very-noisy_Rarelynever_0_1': 454,
        'Pain-types-experienced-in-last-month_Back-pain_0_1': 455, 'Ever-taken-oral-contraceptive-pill_No_0_0': 456,
        'Ever-stopped-smoking-for-6-months_Yes_0_0': 457, 'Believed-safe-to-perform-DXA-scan_Yes_2_0': 458,
        'Cochlear-implant_No_2_0': 459,
        'Workplace-had-a-lot-of-cigarette-smoke-from-other-people-smoking_Rarelynever_0_2': 460,
        'Nonaccidental-death-in-close-genetic-family_Yes_0_0': 461,
        'Types-of-physical-activity-in-last-4-weeks_Heavy-DIY-eg-weeding-lawn-mowing-carpentry-digging_0_1': 462,
        'Frequency-of-other-exercises-in-last-4-weeks_Once-a-week_0_0': 463, 'Adopted-as-a-child_No_2_0': 464,
        'Volume-level-set-by-participant-right_20_0_0': 465, 'Hearing-test-done_Yes_2_0': 466,
        'Believed-safe-to-perform-brain-MRI-scan_Yes_2_0': 467,
        'Believed-safe-to-perform-abdominal-MRI-scan_Yes_2_0': 468, 'Volume-level-set-by-participant-left_20_0_0': 469,
        'Current-tobacco-smoking_No_2_0': 470, 'Processed-meat-intake_Never_0_0': 471,
        'Illnesses-of-father_Heart-disease_0_1': 472,
        'Major-dietary-changes-in-the-last-5-years_Yes-because-of-illness_0_0': 473, 'Pacemaker_No_2_0': 474,
        'Workplace-very-cold_Rarelynever_0_2': 475, 'Hair-colour-natural-before-greying_Black_0_0': 476,
        'Brain-MRI-measuring-method_Direct-entry_2_0': 477, 'Abdominal-MRI-measuring-method_Direct-entry_2_0': 478,
        'DXA-measuring-method_Direct-entry_2_0': 479, 'Handedness-chiralitylaterality_Lefthanded_0_0': 480,
        'Completion-status-of-numeric-memory-test_stopped_0_0': 481,
        'Drive-faster-than-motorway-speed-limit_Often_0_0': 482, 'Completion-status-left_completed_2_0': 483,
        'Chest-pain-or-discomfort-when-walking-uphill-or-hurrying_No_0_0': 484,
        'Completion-status-right_completed_2_0': 485, 'Type-of-accommodation-lived-in_A-house-or-bungalow_2_0': 486,
        'Diabetes-diagnosed-by-doctor_No_2_0': 487, 'Headaches-for-3-months_Yes_0_0': 488,
        'Qualifications_O-levelsGCSEs-or-equivalent_0_1': 489, 'Digits-entered-correctly_yes_0_1': 490,
        'Reason-for-glassescontact-lenses_For-shortsightedness-ie-only-or-mainly-for-distance-viewing-such-as-driving-cinema-etc-called-myopia_0_0': 491,
        'Wears-glasses-or-contact-lenses_Yes_2_0': 492,
        'Type-of-accommodation-lived-in_A-flat-maisonette-or-apartment_0_0': 493,
        'Workplace-had-a-lot-of-cigarette-smoke-from-other-people-smoking_Sometimes_0_0': 494,
        'Test-completion-status_complete_2_0': 495, 'Smoked-cigarette-or-pipe-within-last-hour_No_0_0': 496,
        'Hearing-aid-user_No_2_0': 497, 'Workplace-very-hot_Sometimes_0_0': 498,
        'Alcohol-drinker-status_Current_2_0': 499, 'Facial-ageing_Do-not-know_0_0': 500,
        'Chest-pain-or-discomfort_No_2_0': 501, 'Attempted-fluid-intelligence-FI-test_Begin-puzzles_2_0': 502,
        'Breathing-problems-during-period-of-job_No_0_3': 503,
        'Medication-for-pain-relief-constipation-heartburn_Paracetamol_0_1': 504,
        'Smokingsmokers-in-household_No_2_0': 505, 'Shortness-of-breath-walking-on-level-ground_No_2_0': 506,
        'depression': 507, 'Worked-with-pesticides_Rarelynever_0_3': 508, 'Digits-entered-correctly_yes_0_0': 509,
        'Triplet-correct-right_yes_2_1': 510,
        'Frequency-of-other-exercises-in-last-4-weeks_23-times-in-the-last-4-weeks_0_0': 511,
        'PM-final-answer_Orange-circle_2_0': 512, 'Final-attempt-correct_yes_2_0': 513,
        'DXA-measurement-completed_Yes_2_0': 514, 'Workplace-very-hot_Rarelynever_0_2': 515,
        'Digits-entered-correctly_yes_0_2': 516, 'Loud-music-exposure-frequency_No_2_0': 517,
        'Fracturedbroken-bones-in-last-5-years_No_2_0': 518,
        'Qualifications_Other-professional-qualifications-eg-nursing-teaching_0_3': 519,
        'Contraindications-for-spirometry_No_2_0': 520,
        'Frequency-of-heavy-DIY-in-last-4-weeks_Once-in-the-last-4-weeks_0_0': 521,
        'Workplace-very-noisy_Rarelynever_0_2': 522, 'Used-an-inhaler-for-chest-within-last-hour_No_2_0': 523,
        'Triplet-correct-left_yes_2_1': 524, 'Frequency-of-walking-for-pleasure-in-last-4-weeks_Every-day_0_0': 525,
        'FI1-numeric-addition-test_15_2_0': 526, 'Hip-pain-for-3-months_Yes_0_0': 527,
        'Workplace-had-a-lot-of-diesel-exhaust_Rarelynever_0_3': 528, 'Job-involved-shift-work_No_0_3': 529,
        'Mouthteeth-dental-problems_Mouth-ulcers_0_0': 530, 'Hairbalding-pattern_Pattern-4_0_0': 531,
        'Illnesses-of-mother_Diabetes_0_0': 532, 'Result-ranking_second-best_2_1': 533, 'Result-ranking_best_2_0': 534,
        'Worked-with-paints-thinners-or-glues_Rarelynever_0_3': 535, 'Cancer-diagnosed-by-doctor_No_2_0': 536,
        'Glasses-wornrequired-right_wearing_0_0': 537, 'Glasses-wornrequired-left_wearing_0_0': 538,
        'Father-still-alive_No_2_0': 539, 'Other-serious-medical-conditiondisability-diagnosed-by-doctor_No_2_0': 540,
        'Smokingsmokers-in-household_Yes-one-household-member-smokes_0_0': 541,
        'Frequency-of-stair-climbing-in-last-4-weeks_1620-times-a-day_0_0': 542,
        'Stiffness-method_Direct-entry_2_0': 543, 'Workplace-very-noisy_Sometimes_0_0': 544,
        'Frequency-of-stair-climbing-in-last-4-weeks_None_0_0': 545,
        'Duration-of-other-exercises_Between-15-and-30-minutes_0_0': 546,
        'Which-eyes-affected-by-myopia-short-sight_Both-eyes_0_0': 547,
        'Operator-indicated-brain-MRI-measurement-completed_yes_2_0': 548, 'Digits-entered-correctly_yes_0_3': 549,
        'Leg-pain-on-walking_No_2_0': 550, 'Worked-with-materials-containing-asbestos_Rarelynever_0_3': 551,
        'Nonbutter-spread-type-details_Flora-ProActive-or-Benecol_0_0': 552, 'Noisy-workplace_No_2_0': 553,
        'Falls-in-the-last-year_No-falls_2_0': 554, 'Workplace-full-of-chemical-or-other-fumes_Rarelynever_0_3': 555,
        'Operation-code_tonsillectomy-adenoids_0_0': 556, 'Eye-problemsdisorders_None-of-the-above_2_0': 557,
        'composite_cad_dcm_hcm_hf_mi': 558, 'Pain-types-experienced-in-last-month_Neck-or-shoulder-pain_0_1': 559,
        'Other-eye-problems_No_2_0': 560, 'Cheese-intake_56-times-a-week_0_0': 561,
        'Country-of-birth-UKelsewhere_Elsewhere_0_0': 562, 'Current-tobacco-smoking_Yes-on-most-or-all-days_0_0': 563,
        'Country-of-birth-UKelsewhere_Scotland_0_0': 564, 'Vicorder-results-plausible_Yes_2_0': 565,
        'Duration-of-light-DIY_Between-1-and-15-hours_0_0': 566, 'Abdominal-MRI-measurement-completed_Yes_2_0': 567,
        'Leg-pain-on-walking_Yes_0_0': 568, 'Prospective-memory-result_Correct-recall-on-first-attempt_2_0': 569,
        'PM-initial-answer_Orange-circle_2_0': 570, 'Variation-in-diet_Often_0_0': 571,
        'Which-eyes-affected-by-presbyopia_Both-eyes_0_0': 572, 'FI4-positional-arithmetic_6_2_0': 573,
        'Cancer-diagnosed-by-doctor_Yes-you-will-be-asked-about-this-later-by-an-interviewer_0_0': 574,
        'Types-of-transport-used-excluding-work_Carmotor-vehicle_2_0': 575,
        'Types-of-physical-activity-in-last-4-weeks_Walking-for-pleasure-not-as-a-means-of-transport_2_0': 576,
        'Usual-walking-pace_Slow-pace_0_0': 577, 'Wheeze-or-whistling-in-the-chest-in-last-year_No_2_0': 578,
        'Back-pain-for-3-months_No_0_0': 579,
        'Frequency-of-walking-for-pleasure-in-last-4-weeks_45-times-a-week_0_0': 580,
        'Neckshoulder-pain-for-3-months_No_0_0': 581, 'Gap-coding_Retired_0_0': 582,
        'Never-eat-eggs-dairy-wheat-sugar_I-eat-all-of-the-above_2_0': 583, 'PM-initial-answer_Blue-square_0_0': 584,
        'Surgeryamputation-of-toe-or-leg_No_0_0': 585, 'Alcohol-intake-frequency_Never_0_0': 586,
        'Mineral-and-other-dietary-supplements_Glucosamine_0_0': 587, 'diabetes_type_2': 588,
        'Illnesses-of-father_Do-not-know-group-2_0_1': 589,
        'Qualifications_Other-professional-qualifications-eg-nursing-teaching_0_1': 590,
        'Triplet-correct-right_yes_2_2': 591, 'Fractured-heel-right_no_2_0': 592, 'imaging_thoracic': 593,
        'coronary_artery_disease_hard': 594,
        'Own-or-rent-accommodation-lived-in_Own-outright-by-you-or-someone-in-your-household_2_0': 595,
        'Fractured-heel-left_no_2_0': 596, 'Workplace-very-dusty_Rarelynever_0_3': 597,
        'Surgery-on-leg-arteries-other-than-for-varicose-veins_No_0_0': 598,
        'Duration-of-heavy-DIY_Between-15-and-30-minutes_0_0': 599, 'Digits-entered-correctly_yes_0_4': 600,
        'Caffeine-drink-within-last-hour_No_2_0': 601,
        'Workplace-had-a-lot-of-cigarette-smoke-from-other-people-smoking_Rarelynever_0_3': 602,
        'Contraindications-for-spirometry_Yes_0_0': 603, 'Noncancer-illness-code-selfreported_asthma_0_0': 604,
        'Triplet-correct-left_yes_2_2': 605,
        'Types-of-physical-activity-in-last-4-weeks_Light-DIY-eg-pruning-watering-the-lawn_0_0': 606,
        'Duration-walking-for-pleasure_Between-15-and-2-hours_0_0': 607, 'Illnesses-of-father_Prostate-cancer_0_0': 608,
        'allergic_rhinitis': 609, 'hypothyroidism': 610, 'Illnesses-of-father_Diabetes_0_0': 611,
    },
)

death = TensorMap('death', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_death': 0, 'death': 1})
pacemaker_no_0_0 = TensorMap('Pacemaker_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Pacemaker_No_0_0': 0, 'Pacemaker_No_0_0': 1})
adopted_as_a_child_no_0_0 = TensorMap('Adopted-as-a-child_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Adopted-as-a-child_No_0_0': 0, 'Adopted-as-a-child_No_0_0': 1})
part_of_a_multiple_birth_no_0_0 = TensorMap('Part-of-a-multiple-birth_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Part-of-a-multiple-birth_No_0_0': 0, 'Part-of-a-multiple-birth_No_0_0': 1})
diabetes_diagnosed_by_doctor_no_0_0 = TensorMap('Diabetes-diagnosed-by-doctor_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Diabetes-diagnosed-by-doctor_No_0_0': 0, 'Diabetes-diagnosed-by-doctor_No_0_0': 1})
alcohol_drinker_status_current_0_0 = TensorMap('Alcohol-drinker-status_Current_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Alcohol-drinker-status_Current_0_0': 0, 'Alcohol-drinker-status_Current_0_0': 1})
contraindications_for_spirometry_no_0_0 = TensorMap('Contraindications-for-spirometry_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Contraindications-for-spirometry_No_0_0': 0, 'Contraindications-for-spirometry_No_0_0': 1})
cancer_diagnosed_by_doctor_no_0_0 = TensorMap('Cancer-diagnosed-by-doctor_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Cancer-diagnosed-by-doctor_No_0_0': 0, 'Cancer-diagnosed-by-doctor_No_0_0': 1})
used_an_inhaler_for_chest_within_last_hour_no_0_0 = TensorMap('Used-an-inhaler-for-chest-within-last-hour_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Used-an-inhaler-for-chest-within-last-hour_No_0_0': 0, 'Used-an-inhaler-for-chest-within-last-hour_No_0_0': 1})
result_ranking_best_0_0 = TensorMap('Result-ranking_best_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Result-ranking_best_0_0': 0, 'Result-ranking_best_0_0': 1})
type_of_accommodation_lived_in_a_house_or_bungalow_0_0 = TensorMap('Type-of-accommodation-lived-in_A-house-or-bungalow_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Type-of-accommodation-lived-in_A-house-or-bungalow_0_0': 0, 'Type-of-accommodation-lived-in_A-house-or-bungalow_0_0': 1})
result_ranking_second_best_0_1 = TensorMap('Result-ranking_second-best_0_1', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Result-ranking_second-best_0_1': 0, 'Result-ranking_second-best_0_1': 1})
caffeine_drink_within_last_hour_no_0_0 = TensorMap('Caffeine-drink-within-last-hour_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Caffeine-drink-within-last-hour_No_0_0': 0, 'Caffeine-drink-within-last-hour_No_0_0': 1})
handedness_chiralitylaterality_righthanded_0_0 = TensorMap('Handedness-chiralitylaterality_Righthanded_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Handedness-chiralitylaterality_Righthanded_0_0': 0, 'Handedness-chiralitylaterality_Righthanded_0_0': 1})
fracturedbroken_bones_in_last_5_years_no_0_0 = TensorMap('Fracturedbroken-bones-in-last-5-years_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Fracturedbroken-bones-in-last-5-years_No_0_0': 0, 'Fracturedbroken-bones-in-last-5-years_No_0_0': 1})
current_tobacco_smoking_no_0_0 = TensorMap('Current-tobacco-smoking_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Current-tobacco-smoking_No_0_0': 0, 'Current-tobacco-smoking_No_0_0': 1})
wears_glasses_or_contact_lenses_yes_0_0 = TensorMap('Wears-glasses-or-contact-lenses_Yes_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Wears-glasses-or-contact-lenses_Yes_0_0': 0, 'Wears-glasses-or-contact-lenses_Yes_0_0': 1})
ethnic_background_british_0_0 = TensorMap('Ethnic-background_British_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Ethnic-background_British_0_0': 0, 'Ethnic-background_British_0_0': 1})
other_eye_problems_no_0_0 = TensorMap('Other-eye-problems_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Other-eye-problems_No_0_0': 0, 'Other-eye-problems_No_0_0': 1})
chest_pain_or_discomfort_no_0_0 = TensorMap('Chest-pain-or-discomfort_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Chest-pain-or-discomfort_No_0_0': 0, 'Chest-pain-or-discomfort_No_0_0': 1})
smokingsmokers_in_household_no_0_0 = TensorMap('Smokingsmokers-in-household_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Smokingsmokers-in-household_No_0_0': 0, 'Smokingsmokers-in-household_No_0_0': 1})
falls_in_the_last_year_no_falls_0_0 = TensorMap('Falls-in-the-last-year_No-falls_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Falls-in-the-last-year_No-falls_0_0': 0, 'Falls-in-the-last-year_No-falls_0_0': 1})
never_eat_eggs_dairy_wheat_sugar_i_eat_all_of_the_above_0_0 = TensorMap('Never-eat-eggs-dairy-wheat-sugar_I-eat-all-of-the-above_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Never-eat-eggs-dairy-wheat-sugar_I-eat-all-of-the-above_0_0': 0, 'Never-eat-eggs-dairy-wheat-sugar_I-eat-all-of-the-above_0_0': 1})
country_of_birth_ukelsewhere_england_0_0 = TensorMap('Country-of-birth-UKelsewhere_England_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Country-of-birth-UKelsewhere_England_0_0': 0, 'Country-of-birth-UKelsewhere_England_0_0': 1})
types_of_transport_used_excluding_work_carmotor_vehicle_0_0 = TensorMap('Types-of-transport-used-excluding-work_Carmotor-vehicle_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Types-of-transport-used-excluding-work_Carmotor-vehicle_0_0': 0, 'Types-of-transport-used-excluding-work_Carmotor-vehicle_0_0': 1})
other_serious_medical_conditiondisability_diagnosed_by_doctor_no_0_0 = TensorMap('Other-serious-medical-conditiondisability-diagnosed-by-doctor_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Other-serious-medical-conditiondisability-diagnosed-by-doctor_No_0_0': 0, 'Other-serious-medical-conditiondisability-diagnosed-by-doctor_No_0_0': 1})
wheeze_or_whistling_in_the_chest_in_last_year_no_0_0 = TensorMap('Wheeze-or-whistling-in-the-chest-in-last-year_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Wheeze-or-whistling-in-the-chest-in-last-year_No_0_0': 0, 'Wheeze-or-whistling-in-the-chest-in-last-year_No_0_0': 1})
father_still_alive_no_0_0 = TensorMap('Father-still-alive_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Father-still-alive_No_0_0': 0, 'Father-still-alive_No_0_0': 1})
vascularheart_problems_diagnosed_by_doctor_none_of_the_above_0_0 = TensorMap('Vascularheart-problems-diagnosed-by-doctor_None-of-the-above_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Vascularheart-problems-diagnosed-by-doctor_None-of-the-above_0_0': 0, 'Vascularheart-problems-diagnosed-by-doctor_None-of-the-above_0_0': 1})
hearing_difficultyproblems_no_0_0 = TensorMap('Hearing-difficultyproblems_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Hearing-difficultyproblems_No_0_0': 0, 'Hearing-difficultyproblems_No_0_0': 1})
types_of_physical_activity_in_last_4_weeks_walking_for_pleasure_not_as_a_means_of_transport_0_0 = TensorMap('Types-of-physical-activity-in-last-4-weeks_Walking-for-pleasure-not-as-a-means-of-transport_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Types-of-physical-activity-in-last-4-weeks_Walking-for-pleasure-not-as-a-means-of-transport_0_0': 0, 'Types-of-physical-activity-in-last-4-weeks_Walking-for-pleasure-not-as-a-means-of-transport_0_0': 1})
ever_had_bowel_cancer_screening_no_0_0 = TensorMap('Ever-had-bowel-cancer-screening_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Ever-had-bowel-cancer-screening_No_0_0': 0, 'Ever-had-bowel-cancer-screening_No_0_0': 1})
result_ranking_third_best_ie_worst_0_2 = TensorMap('Result-ranking_third-best-ie-worst_0_2', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Result-ranking_third-best-ie-worst_0_2': 0, 'Result-ranking_third-best-ie-worst_0_2': 1})
skin_colour_fair_0_0 = TensorMap('Skin-colour_Fair_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Skin-colour_Fair_0_0': 0, 'Skin-colour_Fair_0_0': 1})
blood_clot_dvt_bronchitis_emphysema_asthma_rhinitis_eczema_allergy_diagnosed_by_doctor_none_of_the_above_0_0 = TensorMap('Blood-clot-DVT-bronchitis-emphysema-asthma-rhinitis-eczema-allergy-diagnosed-by-doctor_None-of-the-above_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Blood-clot-DVT-bronchitis-emphysema-asthma-rhinitis-eczema-allergy-diagnosed-by-doctor_None-of-the-above_0_0': 0, 'Blood-clot-DVT-bronchitis-emphysema-asthma-rhinitis-eczema-allergy-diagnosed-by-doctor_None-of-the-above_0_0': 1})
hot_drink_temperature_hot_0_0 = TensorMap('Hot-drink-temperature_Hot_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Hot-drink-temperature_Hot_0_0': 0, 'Hot-drink-temperature_Hot_0_0': 1})
vitamin_and_mineral_supplements_none_of_the_above_0_0 = TensorMap('Vitamin-and-mineral-supplements_None-of-the-above_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Vitamin-and-mineral-supplements_None-of-the-above_0_0': 0, 'Vitamin-and-mineral-supplements_None-of-the-above_0_0': 1})
facial_ageing_younger_than_you_are_0_0 = TensorMap('Facial-ageing_Younger-than-you-are_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Facial-ageing_Younger-than-you-are_0_0': 0, 'Facial-ageing_Younger-than-you-are_0_0': 1})
longstanding_illness_disability_or_infirmity_no_0_0 = TensorMap('Longstanding-illness-disability-or-infirmity_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Longstanding-illness-disability-or-infirmity_No_0_0': 0, 'Longstanding-illness-disability-or-infirmity_No_0_0': 1})
major_dietary_changes_in_the_last_5_years_no_0_0 = TensorMap('Major-dietary-changes-in-the-last-5-years_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Major-dietary-changes-in-the-last-5-years_No_0_0': 0, 'Major-dietary-changes-in-the-last-5-years_No_0_0': 1})
milk_type_used_semiskimmed_0_0 = TensorMap('Milk-type-used_Semiskimmed_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Milk-type-used_Semiskimmed_0_0': 0, 'Milk-type-used_Semiskimmed_0_0': 1})
maternal_smoking_around_birth_no_0_0 = TensorMap('Maternal-smoking-around-birth_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Maternal-smoking-around-birth_No_0_0': 0, 'Maternal-smoking-around-birth_No_0_0': 1})
illnesses_of_siblings_none_of_the_above_group_2_0_1 = TensorMap('Illnesses-of-siblings_None-of-the-above-group-2_0_1', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Illnesses-of-siblings_None-of-the-above-group-2_0_1': 0, 'Illnesses-of-siblings_None-of-the-above-group-2_0_1': 1})
hearing_difficultyproblems_with_background_noise_no_0_0 = TensorMap('Hearing-difficultyproblems-with-background-noise_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Hearing-difficultyproblems-with-background-noise_No_0_0': 0, 'Hearing-difficultyproblems-with-background-noise_No_0_0': 1})
mouthteeth_dental_problems_none_of_the_above_0_0 = TensorMap('Mouthteeth-dental-problems_None-of-the-above_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Mouthteeth-dental-problems_None-of-the-above_0_0': 0, 'Mouthteeth-dental-problems_None-of-the-above_0_0': 1})
current_employment_status_in_paid_employment_or_selfemployed_0_0 = TensorMap('Current-employment-status_In-paid-employment-or-selfemployed_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Current-employment-status_In-paid-employment-or-selfemployed_0_0': 0, 'Current-employment-status_In-paid-employment-or-selfemployed_0_0': 1})
hearing_aid_user_no_0_0 = TensorMap('Hearing-aid-user_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Hearing-aid-user_No_0_0': 0, 'Hearing-aid-user_No_0_0': 1})
ever_smoked_yes_0_0 = TensorMap('Ever-smoked_Yes_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Ever-smoked_Yes_0_0': 0, 'Ever-smoked_Yes_0_0': 1})
mother_still_alive_no_0_0 = TensorMap('Mother-still-alive_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Mother-still-alive_No_0_0': 0, 'Mother-still-alive_No_0_0': 1})
variation_in_diet_sometimes_0_0 = TensorMap('Variation-in-diet_Sometimes_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Variation-in-diet_Sometimes_0_0': 0, 'Variation-in-diet_Sometimes_0_0': 1})
lambmutton_intake_less_than_once_a_week_0_0 = TensorMap('Lambmutton-intake_Less-than-once-a-week_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Lambmutton-intake_Less-than-once-a-week_0_0': 0, 'Lambmutton-intake_Less-than-once-a-week_0_0': 1})
smoking_status_never_0_0 = TensorMap('Smoking-status_Never_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Smoking-status_Never_0_0': 0, 'Smoking-status_Never_0_0': 1})
overall_health_rating_good_0_0 = TensorMap('Overall-health-rating_Good_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Overall-health-rating_Good_0_0': 0, 'Overall-health-rating_Good_0_0': 1})
mineral_and_other_dietary_supplements_none_of_the_above_0_0 = TensorMap('Mineral-and-other-dietary-supplements_None-of-the-above_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Mineral-and-other-dietary-supplements_None-of-the-above_0_0': 0, 'Mineral-and-other-dietary-supplements_None-of-the-above_0_0': 1})
pork_intake_less_than_once_a_week_0_0 = TensorMap('Pork-intake_Less-than-once-a-week_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Pork-intake_Less-than-once-a-week_0_0': 0, 'Pork-intake_Less-than-once-a-week_0_0': 1})
salt_added_to_food_neverrarely_0_0 = TensorMap('Salt-added-to-food_Neverrarely_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Salt-added-to-food_Neverrarely_0_0': 0, 'Salt-added-to-food_Neverrarely_0_0': 1})
breastfed_as_a_baby_yes_0_0 = TensorMap('Breastfed-as-a-baby_Yes_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Breastfed-as-a-baby_Yes_0_0': 0, 'Breastfed-as-a-baby_Yes_0_0': 1})
birth_weight_known_yes_pounds_and_ounces_0_0 = TensorMap('Birth-weight-known_Yes-pounds-and-ounces_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Birth-weight-known_Yes-pounds-and-ounces_0_0': 0, 'Birth-weight-known_Yes-pounds-and-ounces_0_0': 1})
illnesses_of_mother_none_of_the_above_group_2_0_1 = TensorMap('Illnesses-of-mother_None-of-the-above-group-2_0_1', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Illnesses-of-mother_None-of-the-above-group-2_0_1': 0, 'Illnesses-of-mother_None-of-the-above-group-2_0_1': 1})
usual_walking_pace_steady_average_pace_0_0 = TensorMap('Usual-walking-pace_Steady-average-pace_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Usual-walking-pace_Steady-average-pace_0_0': 0, 'Usual-walking-pace_Steady-average-pace_0_0': 1})
weight_change_compared_with_1_year_ago_no_weigh_about_the_same_0_0 = TensorMap('Weight-change-compared-with-1-year-ago_No-weigh-about-the-same_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Weight-change-compared-with-1-year-ago_No-weigh-about-the-same_0_0': 0, 'Weight-change-compared-with-1-year-ago_No-weigh-about-the-same_0_0': 1})
sex_female_0_0 = TensorMap('Sex_Female_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Sex_Female_0_0': 0, 'Sex_Female_0_0': 1})
pregnant_no_0_0 = TensorMap('Pregnant_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Pregnant_No_0_0': 0, 'Pregnant_No_0_0': 1})
bread_type_wholemeal_or_wholegrain_0_0 = TensorMap('Bread-type_Wholemeal-or-wholegrain_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Bread-type_Wholemeal-or-wholegrain_0_0': 0, 'Bread-type_Wholemeal-or-wholegrain_0_0': 1})
taking_other_prescription_medications_no_0_0 = TensorMap('Taking-other-prescription-medications_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Taking-other-prescription-medications_No_0_0': 0, 'Taking-other-prescription-medications_No_0_0': 1})
spread_type_other_type_of_spreadmargarine_0_0 = TensorMap('Spread-type_Other-type-of-spreadmargarine_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Spread-type_Other-type-of-spreadmargarine_0_0': 0, 'Spread-type_Other-type-of-spreadmargarine_0_0': 1})
ever_had_cervical_smear_test_yes_0_0 = TensorMap('Ever-had-cervical-smear-test_Yes_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Ever-had-cervical-smear-test_Yes_0_0': 0, 'Ever-had-cervical-smear-test_Yes_0_0': 1})
medication_for_pain_relief_constipation_heartburn_none_of_the_above_0_0 = TensorMap('Medication-for-pain-relief-constipation-heartburn_None-of-the-above_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Medication-for-pain-relief-constipation-heartburn_None-of-the-above_0_0': 0, 'Medication-for-pain-relief-constipation-heartburn_None-of-the-above_0_0': 1})
comparative_height_size_at_age_10_about_average_0_0 = TensorMap('Comparative-height-size-at-age-10_About-average_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Comparative-height-size-at-age-10_About-average_0_0': 0, 'Comparative-height-size-at-age-10_About-average_0_0': 1})
illnesses_of_father_none_of_the_above_group_2_0_1 = TensorMap('Illnesses-of-father_None-of-the-above-group-2_0_1', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Illnesses-of-father_None-of-the-above-group-2_0_1': 0, 'Illnesses-of-father_None-of-the-above-group-2_0_1': 1})
comparative_body_size_at_age_10_about_average_0_0 = TensorMap('Comparative-body-size-at-age-10_About-average_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Comparative-body-size-at-age-10_About-average_0_0': 0, 'Comparative-body-size-at-age-10_About-average_0_0': 1})
nonoily_fish_intake_once_a_week_0_0 = TensorMap('Nonoily-fish-intake_Once-a-week_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Nonoily-fish-intake_Once-a-week_0_0': 0, 'Nonoily-fish-intake_Once-a-week_0_0': 1})
own_or_rent_accommodation_lived_in_own_outright_by_you_or_someone_in_your_household_0_0 = TensorMap('Own-or-rent-accommodation-lived-in_Own-outright-by-you-or-someone-in-your-household_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Own-or-rent-accommodation-lived-in_Own-outright-by-you-or-someone-in-your-household_0_0': 0, 'Own-or-rent-accommodation-lived-in_Own-outright-by-you-or-someone-in-your-household_0_0': 1})
bilateral_oophorectomy_both_ovaries_removed_no_0_0 = TensorMap('Bilateral-oophorectomy-both-ovaries-removed_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Bilateral-oophorectomy-both-ovaries-removed_No_0_0': 0, 'Bilateral-oophorectomy-both-ovaries-removed_No_0_0': 1})
taking_other_prescription_medications_yes_you_will_be_asked_about_this_later_by_an_interviewer_0_0 = TensorMap('Taking-other-prescription-medications_Yes-you-will-be-asked-about-this-later-by-an-interviewer_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Taking-other-prescription-medications_Yes-you-will-be-asked-about-this-later-by-an-interviewer_0_0': 0, 'Taking-other-prescription-medications_Yes-you-will-be-asked-about-this-later-by-an-interviewer_0_0': 1})
sex_male_0_0 = TensorMap('Sex_Male_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Sex_Male_0_0': 0, 'Sex_Male_0_0': 1})
poultry_intake_24_times_a_week_0_0 = TensorMap('Poultry-intake_24-times-a-week_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Poultry-intake_24-times-a-week_0_0': 0, 'Poultry-intake_24-times-a-week_0_0': 1})
beef_intake_less_than_once_a_week_0_0 = TensorMap('Beef-intake_Less-than-once-a-week_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Beef-intake_Less-than-once-a-week_0_0': 0, 'Beef-intake_Less-than-once-a-week_0_0': 1})
illnesses_of_siblings_none_of_the_above_group_1_0_0 = TensorMap('Illnesses-of-siblings_None-of-the-above-group-1_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Illnesses-of-siblings_None-of-the-above-group-1_0_0': 0, 'Illnesses-of-siblings_None-of-the-above-group-1_0_0': 1})
fi1_numeric_addition_test_15_0_0 = TensorMap('FI1-numeric-addition-test_15_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_FI1-numeric-addition-test_15_0_0': 0, 'FI1-numeric-addition-test_15_0_0': 1})
cheese_intake_24_times_a_week_0_0 = TensorMap('Cheese-intake_24-times-a-week_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Cheese-intake_24-times-a-week_0_0': 0, 'Cheese-intake_24-times-a-week_0_0': 1})
birth_weight_known_no_0_0 = TensorMap('Birth-weight-known_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Birth-weight-known_No_0_0': 0, 'Birth-weight-known_No_0_0': 1})
ever_taken_oral_contraceptive_pill_yes_0_0 = TensorMap('Ever-taken-oral-contraceptive-pill_Yes_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Ever-taken-oral-contraceptive-pill_Yes_0_0': 0, 'Ever-taken-oral-contraceptive-pill_Yes_0_0': 1})
coffee_type_instant_coffee_0_0 = TensorMap('Coffee-type_Instant-coffee_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Coffee-type_Instant-coffee_0_0': 0, 'Coffee-type_Instant-coffee_0_0': 1})
ever_had_hysterectomy_womb_removed_no_0_0 = TensorMap('Ever-had-hysterectomy-womb-removed_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Ever-had-hysterectomy-womb-removed_No_0_0': 0, 'Ever-had-hysterectomy-womb-removed_No_0_0': 1})
ever_had_breast_cancer_screening_mammogram_yes_0_0 = TensorMap('Ever-had-breast-cancer-screening-mammogram_Yes_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Ever-had-breast-cancer-screening-mammogram_Yes_0_0': 0, 'Ever-had-breast-cancer-screening-mammogram_Yes_0_0': 1})
alcohol_intake_versus_10_years_previously_less_nowadays_0_0 = TensorMap('Alcohol-intake-versus-10-years-previously_Less-nowadays_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Alcohol-intake-versus-10-years-previously_Less-nowadays_0_0': 0, 'Alcohol-intake-versus-10-years-previously_Less-nowadays_0_0': 1})
past_tobacco_smoking_i_have_never_smoked_0_0 = TensorMap('Past-tobacco-smoking_I-have-never-smoked_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Past-tobacco-smoking_I-have-never-smoked_0_0': 0, 'Past-tobacco-smoking_I-have-never-smoked_0_0': 1})
ever_smoked_no_0_0 = TensorMap('Ever-smoked_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Ever-smoked_No_0_0': 0, 'Ever-smoked_No_0_0': 1})
drive_faster_than_motorway_speed_limit_neverrarely_0_0 = TensorMap('Drive-faster-than-motorway-speed-limit_Neverrarely_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Drive-faster-than-motorway-speed-limit_Neverrarely_0_0': 0, 'Drive-faster-than-motorway-speed-limit_Neverrarely_0_0': 1})
mother_still_alive_yes_0_0 = TensorMap('Mother-still-alive_Yes_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Mother-still-alive_Yes_0_0': 0, 'Mother-still-alive_Yes_0_0': 1})
own_or_rent_accommodation_lived_in_own_with_a_mortgage_0_0 = TensorMap('Own-or-rent-accommodation-lived-in_Own-with-a-mortgage_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Own-or-rent-accommodation-lived-in_Own-with-a-mortgage_0_0': 0, 'Own-or-rent-accommodation-lived-in_Own-with-a-mortgage_0_0': 1})
hair_colour_natural_before_greying_light_brown_0_0 = TensorMap('Hair-colour-natural-before-greying_Light-brown_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Hair-colour-natural-before-greying_Light-brown_0_0': 0, 'Hair-colour-natural-before-greying_Light-brown_0_0': 1})
fi4_positional_arithmetic_6_0_0 = TensorMap('FI4-positional-arithmetic_6_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_FI4-positional-arithmetic_6_0_0': 0, 'FI4-positional-arithmetic_6_0_0': 1})
pain_types_experienced_in_last_month_none_of_the_above_0_0 = TensorMap('Pain-types-experienced-in-last-month_None-of-the-above_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Pain-types-experienced-in-last-month_None-of-the-above_0_0': 0, 'Pain-types-experienced-in-last-month_None-of-the-above_0_0': 1})
relative_age_voice_broke_about_average_age_0_0 = TensorMap('Relative-age-voice-broke_About-average-age_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Relative-age-voice-broke_About-average-age_0_0': 0, 'Relative-age-voice-broke_About-average-age_0_0': 1})
hearing_difficultyproblems_with_background_noise_yes_0_0 = TensorMap('Hearing-difficultyproblems-with-background-noise_Yes_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Hearing-difficultyproblems-with-background-noise_Yes_0_0': 0, 'Hearing-difficultyproblems-with-background-noise_Yes_0_0': 1})
ease_of_skin_tanning_get_moderately_tanned_0_0 = TensorMap('Ease-of-skin-tanning_Get-moderately-tanned_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Ease-of-skin-tanning_Get-moderately-tanned_0_0': 0, 'Ease-of-skin-tanning_Get-moderately-tanned_0_0': 1})
usual_walking_pace_brisk_pace_0_0 = TensorMap('Usual-walking-pace_Brisk-pace_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Usual-walking-pace_Brisk-pace_0_0': 0, 'Usual-walking-pace_Brisk-pace_0_0': 1})
medication_for_cholesterol_blood_pressure_diabetes_or_take_exogenous_hormones_none_of_the_above_0_0 = TensorMap('Medication-for-cholesterol-blood-pressure-diabetes-or-take-exogenous-hormones_None-of-the-above_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Medication-for-cholesterol-blood-pressure-diabetes-or-take-exogenous-hormones_None-of-the-above_0_0': 0, 'Medication-for-cholesterol-blood-pressure-diabetes-or-take-exogenous-hormones_None-of-the-above_0_0': 1})
hypertension = TensorMap('hypertension', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_hypertension': 0, 'hypertension': 1})
oily_fish_intake_once_a_week_0_0 = TensorMap('Oily-fish-intake_Once-a-week_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Oily-fish-intake_Once-a-week_0_0': 0, 'Oily-fish-intake_Once-a-week_0_0': 1})
poultry_intake_once_a_week_0_0 = TensorMap('Poultry-intake_Once-a-week_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Poultry-intake_Once-a-week_0_0': 0, 'Poultry-intake_Once-a-week_0_0': 1})
types_of_physical_activity_in_last_4_weeks_other_exercises_eg_swimming_cycling_keep_fit_bowling_0_1 = TensorMap('Types-of-physical-activity-in-last-4-weeks_Other-exercises-eg-swimming-cycling-keep-fit-bowling_0_1', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Types-of-physical-activity-in-last-4-weeks_Other-exercises-eg-swimming-cycling-keep-fit-bowling_0_1': 0, 'Types-of-physical-activity-in-last-4-weeks_Other-exercises-eg-swimming-cycling-keep-fit-bowling_0_1': 1})
drive_faster_than_motorway_speed_limit_sometimes_0_0 = TensorMap('Drive-faster-than-motorway-speed-limit_Sometimes_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Drive-faster-than-motorway-speed-limit_Sometimes_0_0': 0, 'Drive-faster-than-motorway-speed-limit_Sometimes_0_0': 1})
frequency_of_stair_climbing_in_last_4_weeks_610_times_a_day_0_0 = TensorMap('Frequency-of-stair-climbing-in-last-4-weeks_610-times-a-day_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Frequency-of-stair-climbing-in-last-4-weeks_610-times-a-day_0_0': 0, 'Frequency-of-stair-climbing-in-last-4-weeks_610-times-a-day_0_0': 1})
use_of_sunuv_protection_most_of_the_time_0_0 = TensorMap('Use-of-sunuv-protection_Most-of-the-time_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Use-of-sunuv-protection_Most-of-the-time_0_0': 0, 'Use-of-sunuv-protection_Most-of-the-time_0_0': 1})
ever_had_stillbirth_spontaneous_miscarriage_or_termination_no_0_0 = TensorMap('Ever-had-stillbirth-spontaneous-miscarriage-or-termination_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Ever-had-stillbirth-spontaneous-miscarriage-or-termination_No_0_0': 0, 'Ever-had-stillbirth-spontaneous-miscarriage-or-termination_No_0_0': 1})
hair_colour_natural_before_greying_dark_brown_0_0 = TensorMap('Hair-colour-natural-before-greying_Dark-brown_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Hair-colour-natural-before-greying_Dark-brown_0_0': 0, 'Hair-colour-natural-before-greying_Dark-brown_0_0': 1})
relative_age_of_first_facial_hair_about_average_age_0_0 = TensorMap('Relative-age-of-first-facial-hair_About-average-age_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Relative-age-of-first-facial-hair_About-average-age_0_0': 0, 'Relative-age-of-first-facial-hair_About-average-age_0_0': 1})
had_other_major_operations_yes_you_will_be_asked_about_this_later_by_an_interviewer_0_0 = TensorMap('Had-other-major-operations_Yes-you-will-be-asked-about-this-later-by-an-interviewer_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Had-other-major-operations_Yes-you-will-be-asked-about-this-later-by-an-interviewer_0_0': 0, 'Had-other-major-operations_Yes-you-will-be-asked-about-this-later-by-an-interviewer_0_0': 1})
types_of_transport_used_excluding_work_walk_0_1 = TensorMap('Types-of-transport-used-excluding-work_Walk_0_1', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Types-of-transport-used-excluding-work_Walk_0_1': 0, 'Types-of-transport-used-excluding-work_Walk_0_1': 1})
alcohol_intake_versus_10_years_previously_about_the_same_0_0 = TensorMap('Alcohol-intake-versus-10-years-previously_About-the-same_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Alcohol-intake-versus-10-years-previously_About-the-same_0_0': 0, 'Alcohol-intake-versus-10-years-previously_About-the-same_0_0': 1})
spread_type_butterspreadable_butter_0_0 = TensorMap('Spread-type_Butterspreadable-butter_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Spread-type_Butterspreadable-butter_0_0': 0, 'Spread-type_Butterspreadable-butter_0_0': 1})
variation_in_diet_neverrarely_0_0 = TensorMap('Variation-in-diet_Neverrarely_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Variation-in-diet_Neverrarely_0_0': 0, 'Variation-in-diet_Neverrarely_0_0': 1})
alcohol_usually_taken_with_meals_yes_0_0 = TensorMap('Alcohol-usually-taken-with-meals_Yes_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Alcohol-usually-taken-with-meals_Yes_0_0': 0, 'Alcohol-usually-taken-with-meals_Yes_0_0': 1})
qualifications_college_or_university_degree_0_0 = TensorMap('Qualifications_College-or-University-degree_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Qualifications_College-or-University-degree_0_0': 0, 'Qualifications_College-or-University-degree_0_0': 1})
test_completion_status_complete_0_0 = TensorMap('Test-completion-status_complete_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Test-completion-status_complete_0_0': 0, 'Test-completion-status_complete_0_0': 1})
cochlear_implant_no_0_0 = TensorMap('Cochlear-implant_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Cochlear-implant_No_0_0': 0, 'Cochlear-implant_No_0_0': 1})
stiffness_method_direct_entry_0_0 = TensorMap('Stiffness-method_Direct-entry_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Stiffness-method_Direct-entry_0_0': 0, 'Stiffness-method_Direct-entry_0_0': 1})
oily_fish_intake_less_than_once_a_week_0_0 = TensorMap('Oily-fish-intake_Less-than-once-a-week_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Oily-fish-intake_Less-than-once-a-week_0_0': 0, 'Oily-fish-intake_Less-than-once-a-week_0_0': 1})
had_menopause_yes_0_0 = TensorMap('Had-menopause_Yes_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Had-menopause_Yes_0_0': 0, 'Had-menopause_Yes_0_0': 1})
ever_used_hormonereplacement_therapy_hrt_no_0_0 = TensorMap('Ever-used-hormonereplacement-therapy-HRT_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Ever-used-hormonereplacement-therapy-HRT_No_0_0': 0, 'Ever-used-hormonereplacement-therapy-HRT_No_0_0': 1})
use_of_sunuv_protection_sometimes_0_0 = TensorMap('Use-of-sunuv-protection_Sometimes_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Use-of-sunuv-protection_Sometimes_0_0': 0, 'Use-of-sunuv-protection_Sometimes_0_0': 1})
hearing_test_done_yes_0_0 = TensorMap('Hearing-test-done_Yes_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Hearing-test-done_Yes_0_0': 0, 'Hearing-test-done_Yes_0_0': 1})
current_employment_status_retired_0_0 = TensorMap('Current-employment-status_Retired_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Current-employment-status_Retired_0_0': 0, 'Current-employment-status_Retired_0_0': 1})
attempted_fluid_intelligence_fi_test_begin_puzzles_0_0 = TensorMap('Attempted-fluid-intelligence-FI-test_Begin-puzzles_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Attempted-fluid-intelligence-FI-test_Begin-puzzles_0_0': 0, 'Attempted-fluid-intelligence-FI-test_Begin-puzzles_0_0': 1})
fractured_heel_right_no_0_0 = TensorMap('Fractured-heel-right_no_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Fractured-heel-right_no_0_0': 0, 'Fractured-heel-right_no_0_0': 1})
fractured_heel_left_no_0_0 = TensorMap('Fractured-heel-left_no_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Fractured-heel-left_no_0_0': 0, 'Fractured-heel-left_no_0_0': 1})
comparative_body_size_at_age_10_thinner_0_0 = TensorMap('Comparative-body-size-at-age-10_Thinner_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Comparative-body-size-at-age-10_Thinner_0_0': 0, 'Comparative-body-size-at-age-10_Thinner_0_0': 1})
longstanding_illness_disability_or_infirmity_yes_0_0 = TensorMap('Longstanding-illness-disability-or-infirmity_Yes_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Longstanding-illness-disability-or-infirmity_Yes_0_0': 0, 'Longstanding-illness-disability-or-infirmity_Yes_0_0': 1})
heel_ultrasound_method_left_direct_entry_0_0 = TensorMap('Heel-ultrasound-method-left_Direct-entry_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Heel-ultrasound-method-left_Direct-entry_0_0': 0, 'Heel-ultrasound-method-left_Direct-entry_0_0': 1})
completion_status_right_completed_0_0 = TensorMap('Completion-status-right_completed_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Completion-status-right_completed_0_0': 0, 'Completion-status-right_completed_0_0': 1})
smoking_status_previous_0_0 = TensorMap('Smoking-status_Previous_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Smoking-status_Previous_0_0': 0, 'Smoking-status_Previous_0_0': 1})
completion_status_left_completed_0_0 = TensorMap('Completion-status-left_completed_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Completion-status-left_completed_0_0': 0, 'Completion-status-left_completed_0_0': 1})
heel_ultrasound_method_right_direct_entry_0_0 = TensorMap('Heel-ultrasound-method-right_Direct-entry_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Heel-ultrasound-method-right_Direct-entry_0_0': 0, 'Heel-ultrasound-method-right_Direct-entry_0_0': 1})
ever_had_prostate_specific_antigen_psa_test_no_0_0 = TensorMap('Ever-had-prostate-specific-antigen-PSA-test_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Ever-had-prostate-specific-antigen-PSA-test_No_0_0': 0, 'Ever-had-prostate-specific-antigen-PSA-test_No_0_0': 1})
pm_final_answer_orange_circle_0_0 = TensorMap('PM-final-answer_Orange-circle_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_PM-final-answer_Orange-circle_0_0': 0, 'PM-final-answer_Orange-circle_0_0': 1})
final_attempt_correct_yes_0_0 = TensorMap('Final-attempt-correct_yes_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Final-attempt-correct_yes_0_0': 0, 'Final-attempt-correct_yes_0_0': 1})
beef_intake_once_a_week_0_0 = TensorMap('Beef-intake_Once-a-week_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Beef-intake_Once-a-week_0_0': 0, 'Beef-intake_Once-a-week_0_0': 1})
medication_for_cholesterol_blood_pressure_or_diabetes_none_of_the_above_0_0 = TensorMap('Medication-for-cholesterol-blood-pressure-or-diabetes_None-of-the-above_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Medication-for-cholesterol-blood-pressure-or-diabetes_None-of-the-above_0_0': 0, 'Medication-for-cholesterol-blood-pressure-or-diabetes_None-of-the-above_0_0': 1})
mineral_and_other_dietary_supplements_fish_oil_including_cod_liver_oil_0_0 = TensorMap('Mineral-and-other-dietary-supplements_Fish-oil-including-cod-liver-oil_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Mineral-and-other-dietary-supplements_Fish-oil-including-cod-liver-oil_0_0': 0, 'Mineral-and-other-dietary-supplements_Fish-oil-including-cod-liver-oil_0_0': 1})
ever_had_bowel_cancer_screening_yes_0_0 = TensorMap('Ever-had-bowel-cancer-screening_Yes_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Ever-had-bowel-cancer-screening_Yes_0_0': 0, 'Ever-had-bowel-cancer-screening_Yes_0_0': 1})
weight_change_compared_with_1_year_ago_yes_gained_weight_0_0 = TensorMap('Weight-change-compared-with-1-year-ago_Yes-gained-weight_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Weight-change-compared-with-1-year-ago_Yes-gained-weight_0_0': 0, 'Weight-change-compared-with-1-year-ago_Yes-gained-weight_0_0': 1})
processed_meat_intake_less_than_once_a_week_0_0 = TensorMap('Processed-meat-intake_Less-than-once-a-week_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Processed-meat-intake_Less-than-once-a-week_0_0': 0, 'Processed-meat-intake_Less-than-once-a-week_0_0': 1})
triplet_correct_right_yes_0_1 = TensorMap('Triplet-correct-right_yes_0_1', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Triplet-correct-right_yes_0_1': 0, 'Triplet-correct-right_yes_0_1': 1})
nonoily_fish_intake_less_than_once_a_week_0_0 = TensorMap('Nonoily-fish-intake_Less-than-once-a-week_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Nonoily-fish-intake_Less-than-once-a-week_0_0': 0, 'Nonoily-fish-intake_Less-than-once-a-week_0_0': 1})
processed_meat_intake_once_a_week_0_0 = TensorMap('Processed-meat-intake_Once-a-week_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Processed-meat-intake_Once-a-week_0_0': 0, 'Processed-meat-intake_Once-a-week_0_0': 1})
had_major_operations_yes_you_will_be_asked_about_this_later_by_an_interviewer_0_0 = TensorMap('Had-major-operations_Yes-you-will-be-asked-about-this-later-by-an-interviewer_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Had-major-operations_Yes-you-will-be-asked-about-this-later-by-an-interviewer_0_0': 0, 'Had-major-operations_Yes-you-will-be-asked-about-this-later-by-an-interviewer_0_0': 1})
loud_music_exposure_frequency_no_0_0 = TensorMap('Loud-music-exposure-frequency_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Loud-music-exposure-frequency_No_0_0': 0, 'Loud-music-exposure-frequency_No_0_0': 1})
shortness_of_breath_walking_on_level_ground_no_0_0 = TensorMap('Shortness-of-breath-walking-on-level-ground_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Shortness-of-breath-walking-on-level-ground_No_0_0': 0, 'Shortness-of-breath-walking-on-level-ground_No_0_0': 1})
triplet_correct_left_yes_0_1 = TensorMap('Triplet-correct-left_yes_0_1', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Triplet-correct-left_yes_0_1': 0, 'Triplet-correct-left_yes_0_1': 1})
absence_of_notch_position_in_the_pulse_waveform_false_0_0 = TensorMap('Absence-of-notch-position-in-the-pulse-waveform_False_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Absence-of-notch-position-in-the-pulse-waveform_False_0_0': 0, 'Absence-of-notch-position-in-the-pulse-waveform_False_0_0': 1})
alcohol_usually_taken_with_meals_it_varies_0_0 = TensorMap('Alcohol-usually-taken-with-meals_It-varies_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Alcohol-usually-taken-with-meals_It-varies_0_0': 0, 'Alcohol-usually-taken-with-meals_It-varies_0_0': 1})
processed_meat_intake_24_times_a_week_0_0 = TensorMap('Processed-meat-intake_24-times-a-week_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Processed-meat-intake_24-times-a-week_0_0': 0, 'Processed-meat-intake_24-times-a-week_0_0': 1})
salt_added_to_food_sometimes_0_0 = TensorMap('Salt-added-to-food_Sometimes_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Salt-added-to-food_Sometimes_0_0': 0, 'Salt-added-to-food_Sometimes_0_0': 1})
major_dietary_changes_in_the_last_5_years_yes_because_of_other_reasons_0_0 = TensorMap('Major-dietary-changes-in-the-last-5-years_Yes-because-of-other-reasons_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Major-dietary-changes-in-the-last-5-years_Yes-because-of-other-reasons_0_0': 0, 'Major-dietary-changes-in-the-last-5-years_Yes-because-of-other-reasons_0_0': 1})
alcohol_intake_frequency_once_or_twice_a_week_0_0 = TensorMap('Alcohol-intake-frequency_Once-or-twice-a-week_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Alcohol-intake-frequency_Once-or-twice-a-week_0_0': 0, 'Alcohol-intake-frequency_Once-or-twice-a-week_0_0': 1})
eye_problemsdisorders_none_of_the_above_0_0 = TensorMap('Eye-problemsdisorders_None-of-the-above_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Eye-problemsdisorders_None-of-the-above_0_0': 0, 'Eye-problemsdisorders_None-of-the-above_0_0': 1})
illnesses_of_mother_none_of_the_above_group_1_0_0 = TensorMap('Illnesses-of-mother_None-of-the-above-group-1_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Illnesses-of-mother_None-of-the-above-group-1_0_0': 0, 'Illnesses-of-mother_None-of-the-above-group-1_0_0': 1})
bread_type_white_0_0 = TensorMap('Bread-type_White_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Bread-type_White_0_0': 0, 'Bread-type_White_0_0': 1})
comparative_height_size_at_age_10_taller_0_0 = TensorMap('Comparative-height-size-at-age-10_Taller_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Comparative-height-size-at-age-10_Taller_0_0': 0, 'Comparative-height-size-at-age-10_Taller_0_0': 1})
triplet_correct_right_yes_0_2 = TensorMap('Triplet-correct-right_yes_0_2', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Triplet-correct-right_yes_0_2': 0, 'Triplet-correct-right_yes_0_2': 1})
duration_walking_for_pleasure_between_30_minutes_and_1_hour_0_0 = TensorMap('Duration-walking-for-pleasure_Between-30-minutes-and-1-hour_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Duration-walking-for-pleasure_Between-30-minutes-and-1-hour_0_0': 0, 'Duration-walking-for-pleasure_Between-30-minutes-and-1-hour_0_0': 1})
triplet_correct_left_yes_0_2 = TensorMap('Triplet-correct-left_yes_0_2', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Triplet-correct-left_yes_0_2': 0, 'Triplet-correct-left_yes_0_2': 1})
prospective_memory_result_correct_recall_on_first_attempt_0_0 = TensorMap('Prospective-memory-result_Correct-recall-on-first-attempt_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Prospective-memory-result_Correct-recall-on-first-attempt_0_0': 0, 'Prospective-memory-result_Correct-recall-on-first-attempt_0_0': 1})
pm_initial_answer_orange_circle_0_0 = TensorMap('PM-initial-answer_Orange-circle_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_PM-initial-answer_Orange-circle_0_0': 0, 'PM-initial-answer_Orange-circle_0_0': 1})
noisy_workplace_no_0_0 = TensorMap('Noisy-workplace_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Noisy-workplace_No_0_0': 0, 'Noisy-workplace_No_0_0': 1})
leg_pain_on_walking_no_0_0 = TensorMap('Leg-pain-on-walking_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Leg-pain-on-walking_No_0_0': 0, 'Leg-pain-on-walking_No_0_0': 1})
hearing_difficultyproblems_yes_0_0 = TensorMap('Hearing-difficultyproblems_Yes_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Hearing-difficultyproblems_Yes_0_0': 0, 'Hearing-difficultyproblems_Yes_0_0': 1})
fi2_identify_largest_number_987_0_0 = TensorMap('FI2-identify-largest-number_987_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_FI2-identify-largest-number_987_0_0': 0, 'FI2-identify-largest-number_987_0_0': 1})
maternal_smoking_around_birth_yes_0_0 = TensorMap('Maternal-smoking-around-birth_Yes_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Maternal-smoking-around-birth_Yes_0_0': 0, 'Maternal-smoking-around-birth_Yes_0_0': 1})
breastfed_as_a_baby_do_not_know_0_0 = TensorMap('Breastfed-as-a-baby_Do-not-know_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Breastfed-as-a-baby_Do-not-know_0_0': 0, 'Breastfed-as-a-baby_Do-not-know_0_0': 1})
father_still_alive_yes_0_0 = TensorMap('Father-still-alive_Yes_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Father-still-alive_Yes_0_0': 0, 'Father-still-alive_Yes_0_0': 1})
average_total_household_income_before_tax_31000_to_51999_0_0 = TensorMap('Average-total-household-income-before-tax_31000-to-51999_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Average-total-household-income-before-tax_31000-to-51999_0_0': 0, 'Average-total-household-income-before-tax_31000-to-51999_0_0': 1})
tinnitus_no_never_0_0 = TensorMap('Tinnitus_No-never_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Tinnitus_No-never_0_0': 0, 'Tinnitus_No-never_0_0': 1})
both_eyes_present_yes_0_0 = TensorMap('Both-eyes-present_Yes_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Both-eyes-present_Yes_0_0': 0, 'Both-eyes-present_Yes_0_0': 1})
visual_acuity_measured_right_measurable_0_0 = TensorMap('Visual-acuity-measured-right_Measurable_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Visual-acuity-measured-right_Measurable_0_0': 0, 'Visual-acuity-measured-right_Measurable_0_0': 1})
vascularheart_problems_diagnosed_by_doctor_high_blood_pressure_0_0 = TensorMap('Vascularheart-problems-diagnosed-by-doctor_High-blood-pressure_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Vascularheart-problems-diagnosed-by-doctor_High-blood-pressure_0_0': 0, 'Vascularheart-problems-diagnosed-by-doctor_High-blood-pressure_0_0': 1})
visual_acuity_measured_left_measurable_0_0 = TensorMap('Visual-acuity-measured-left_Measurable_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Visual-acuity-measured-left_Measurable_0_0': 0, 'Visual-acuity-measured-left_Measurable_0_0': 1})
direct_or_mirror_view_right_plain_0_0 = TensorMap('Direct-or-mirror-view-right_plain_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Direct-or-mirror-view-right_plain_0_0': 0, 'Direct-or-mirror-view-right_plain_0_0': 1})
direct_or_mirror_view_left_plain_0_0 = TensorMap('Direct-or-mirror-view-left_plain_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Direct-or-mirror-view-left_plain_0_0': 0, 'Direct-or-mirror-view-left_plain_0_0': 1})
current_eye_infection_no_0_0 = TensorMap('Current-eye-infection_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Current-eye-infection_No_0_0': 0, 'Current-eye-infection_No_0_0': 1})
types_of_physical_activity_in_last_4_weeks_light_diy_eg_pruning_watering_the_lawn_0_1 = TensorMap('Types-of-physical-activity-in-last-4-weeks_Light-DIY-eg-pruning-watering-the-lawn_0_1', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Types-of-physical-activity-in-last-4-weeks_Light-DIY-eg-pruning-watering-the-lawn_0_1': 0, 'Types-of-physical-activity-in-last-4-weeks_Light-DIY-eg-pruning-watering-the-lawn_0_1': 1})
pork_intake_once_a_week_0_0 = TensorMap('Pork-intake_Once-a-week_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Pork-intake_Once-a-week_0_0': 0, 'Pork-intake_Once-a-week_0_0': 1})
worked_with_pesticides_rarelynever_0_0 = TensorMap('Worked-with-pesticides_Rarelynever_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Worked-with-pesticides_Rarelynever_0_0': 0, 'Worked-with-pesticides_Rarelynever_0_0': 1})
overall_health_rating_fair_0_0 = TensorMap('Overall-health-rating_Fair_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Overall-health-rating_Fair_0_0': 0, 'Overall-health-rating_Fair_0_0': 1})
illnesses_of_father_none_of_the_above_group_1_0_0 = TensorMap('Illnesses-of-father_None-of-the-above-group-1_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Illnesses-of-father_None-of-the-above-group-1_0_0': 0, 'Illnesses-of-father_None-of-the-above-group-1_0_0': 1})
breathing_problems_during_period_of_job_no_0_0 = TensorMap('Breathing-problems-during-period-of-job_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Breathing-problems-during-period-of-job_No_0_0': 0, 'Breathing-problems-during-period-of-job_No_0_0': 1})
autorefraction_method_right_measurable_0_0 = TensorMap('Autorefraction-method-right_Measurable_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Autorefraction-method-right_Measurable_0_0': 0, 'Autorefraction-method-right_Measurable_0_0': 1})
illnesses_of_mother_high_blood_pressure_0_0 = TensorMap('Illnesses-of-mother_High-blood-pressure_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Illnesses-of-mother_High-blood-pressure_0_0': 0, 'Illnesses-of-mother_High-blood-pressure_0_0': 1})
autorefraction_method_left_measurable_0_0 = TensorMap('Autorefraction-method-left_Measurable_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Autorefraction-method-left_Measurable_0_0': 0, 'Autorefraction-method-left_Measurable_0_0': 1})
past_tobacco_smoking_smoked_on_most_or_all_days_0_0 = TensorMap('Past-tobacco-smoking_Smoked-on-most-or-all-days_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Past-tobacco-smoking_Smoked-on-most-or-all-days_0_0': 0, 'Past-tobacco-smoking_Smoked-on-most-or-all-days_0_0': 1})
lambmutton_intake_once_a_week_0_0 = TensorMap('Lambmutton-intake_Once-a-week_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Lambmutton-intake_Once-a-week_0_0': 0, 'Lambmutton-intake_Once-a-week_0_0': 1})
osteoarthritis = TensorMap('osteoarthritis', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_osteoarthritis': 0, 'osteoarthritis': 1})
alcohol_intake_frequency_daily_or_almost_daily_0_0 = TensorMap('Alcohol-intake-frequency_Daily-or-almost-daily_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Alcohol-intake-frequency_Daily-or-almost-daily_0_0': 0, 'Alcohol-intake-frequency_Daily-or-almost-daily_0_0': 1})
intraocular_pressure_iop_method_right_measurable_0_0 = TensorMap('Intraocular-pressure-IOP-method-right_Measurable_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Intraocular-pressure-IOP-method-right_Measurable_0_0': 0, 'Intraocular-pressure-IOP-method-right_Measurable_0_0': 1})
milk_type_used_skimmed_0_0 = TensorMap('Milk-type-used_Skimmed_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Milk-type-used_Skimmed_0_0': 0, 'Milk-type-used_Skimmed_0_0': 1})
noncancer_illness_code_selfreported_hypertension_0_0 = TensorMap('Noncancer-illness-code-selfreported_hypertension_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Noncancer-illness-code-selfreported_hypertension_0_0': 0, 'Noncancer-illness-code-selfreported_hypertension_0_0': 1})
ever_had_eye_surgery_no_0_0 = TensorMap('Ever-had-eye-surgery_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Ever-had-eye-surgery_No_0_0': 0, 'Ever-had-eye-surgery_No_0_0': 1})
facial_ageing_about_your_age_0_0 = TensorMap('Facial-ageing_About-your-age_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Facial-ageing_About-your-age_0_0': 0, 'Facial-ageing_About-your-age_0_0': 1})
intraocular_pressure_iop_method_left_measurable_0_0 = TensorMap('Intraocular-pressure-IOP-method-left_Measurable_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Intraocular-pressure-IOP-method-left_Measurable_0_0': 0, 'Intraocular-pressure-IOP-method-left_Measurable_0_0': 1})
nonaccidental_death_in_close_genetic_family_no_0_0 = TensorMap('Nonaccidental-death-in-close-genetic-family_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Nonaccidental-death-in-close-genetic-family_No_0_0': 0, 'Nonaccidental-death-in-close-genetic-family_No_0_0': 1})
ease_of_skin_tanning_get_mildly_or_occasionally_tanned_0_0 = TensorMap('Ease-of-skin-tanning_Get-mildly-or-occasionally-tanned_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Ease-of-skin-tanning_Get-mildly-or-occasionally-tanned_0_0': 0, 'Ease-of-skin-tanning_Get-mildly-or-occasionally-tanned_0_0': 1})
cereal_type_oat_cereal_eg_ready_brek_porridge_0_0 = TensorMap('Cereal-type_Oat-cereal-eg-Ready-Brek-porridge_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Cereal-type_Oat-cereal-eg-Ready-Brek-porridge_0_0': 0, 'Cereal-type_Oat-cereal-eg-Ready-Brek-porridge_0_0': 1})
alcohol_intake_frequency_three_or_four_times_a_week_0_0 = TensorMap('Alcohol-intake-frequency_Three-or-four-times-a-week_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Alcohol-intake-frequency_Three-or-four-times-a-week_0_0': 0, 'Alcohol-intake-frequency_Three-or-four-times-a-week_0_0': 1})
average_total_household_income_before_tax_18000_to_30999_0_0 = TensorMap('Average-total-household-income-before-tax_18000-to-30999_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Average-total-household-income-before-tax_18000-to-30999_0_0': 0, 'Average-total-household-income-before-tax_18000-to-30999_0_0': 1})
cheese_intake_once_a_week_0_0 = TensorMap('Cheese-intake_Once-a-week_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Cheese-intake_Once-a-week_0_0': 0, 'Cheese-intake_Once-a-week_0_0': 1})
qualifications_o_levelsgcses_or_equivalent_0_0 = TensorMap('Qualifications_O-levelsGCSEs-or-equivalent_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Qualifications_O-levelsGCSEs-or-equivalent_0_0': 0, 'Qualifications_O-levelsGCSEs-or-equivalent_0_0': 1})
breastfed_as_a_baby_no_0_0 = TensorMap('Breastfed-as-a-baby_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Breastfed-as-a-baby_No_0_0': 0, 'Breastfed-as-a-baby_No_0_0': 1})
ever_used_hormonereplacement_therapy_hrt_yes_0_0 = TensorMap('Ever-used-hormonereplacement-therapy-HRT_Yes_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Ever-used-hormonereplacement-therapy-HRT_Yes_0_0': 0, 'Ever-used-hormonereplacement-therapy-HRT_Yes_0_0': 1})
pain_types_experienced_in_last_month_headache_0_0 = TensorMap('Pain-types-experienced-in-last-month_Headache_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Pain-types-experienced-in-last-month_Headache_0_0': 0, 'Pain-types-experienced-in-last-month_Headache_0_0': 1})
hypercholesterolemia = TensorMap('hypercholesterolemia', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_hypercholesterolemia': 0, 'hypercholesterolemia': 1})
workplace_had_a_lot_of_diesel_exhaust_rarelynever_0_0 = TensorMap('Workplace-had-a-lot-of-diesel-exhaust_Rarelynever_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Workplace-had-a-lot-of-diesel-exhaust_Rarelynever_0_0': 0, 'Workplace-had-a-lot-of-diesel-exhaust_Rarelynever_0_0': 1})
frequency_of_walking_for_pleasure_in_last_4_weeks_23_times_in_the_last_4_weeks_0_0 = TensorMap('Frequency-of-walking-for-pleasure-in-last-4-weeks_23-times-in-the-last-4-weeks_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Frequency-of-walking-for-pleasure-in-last-4-weeks_23-times-in-the-last-4-weeks_0_0': 0, 'Frequency-of-walking-for-pleasure-in-last-4-weeks_23-times-in-the-last-4-weeks_0_0': 1})
frequency_of_stair_climbing_in_last_4_weeks_15_times_a_day_0_0 = TensorMap('Frequency-of-stair-climbing-in-last-4-weeks_15-times-a-day_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Frequency-of-stair-climbing-in-last-4-weeks_15-times-a-day_0_0': 0, 'Frequency-of-stair-climbing-in-last-4-weeks_15-times-a-day_0_0': 1})
wheeze_or_whistling_in_the_chest_in_last_year_yes_0_0 = TensorMap('Wheeze-or-whistling-in-the-chest-in-last-year_Yes_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Wheeze-or-whistling-in-the-chest-in-last-year_Yes_0_0': 0, 'Wheeze-or-whistling-in-the-chest-in-last-year_Yes_0_0': 1})
ease_of_skin_tanning_get_very_tanned_0_0 = TensorMap('Ease-of-skin-tanning_Get-very-tanned_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Ease-of-skin-tanning_Get-very-tanned_0_0': 0, 'Ease-of-skin-tanning_Get-very-tanned_0_0': 1})
fi3_word_interpolation_adult_0_0 = TensorMap('FI3-word-interpolation_adult_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_FI3-word-interpolation_adult_0_0': 0, 'FI3-word-interpolation_adult_0_0': 1})
comparative_height_size_at_age_10_shorter_0_0 = TensorMap('Comparative-height-size-at-age-10_Shorter_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Comparative-height-size-at-age-10_Shorter_0_0': 0, 'Comparative-height-size-at-age-10_Shorter_0_0': 1})
other_serious_medical_conditiondisability_diagnosed_by_doctor_yes_you_will_be_asked_about_this_later_by_an_interviewer_0_0 = TensorMap('Other-serious-medical-conditiondisability-diagnosed-by-doctor_Yes-you-will-be-asked-about-this-later-by-an-interviewer_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Other-serious-medical-conditiondisability-diagnosed-by-doctor_Yes-you-will-be-asked-about-this-later-by-an-interviewer_0_0': 0, 'Other-serious-medical-conditiondisability-diagnosed-by-doctor_Yes-you-will-be-asked-about-this-later-by-an-interviewer_0_0': 1})
worked_with_paints_thinners_or_glues_rarelynever_0_0 = TensorMap('Worked-with-paints-thinners-or-glues_Rarelynever_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Worked-with-paints-thinners-or-glues_Rarelynever_0_0': 0, 'Worked-with-paints-thinners-or-glues_Rarelynever_0_0': 1})
job_involved_shift_work_no_0_0 = TensorMap('Job-involved-shift-work_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Job-involved-shift-work_No_0_0': 0, 'Job-involved-shift-work_No_0_0': 1})
duration_of_other_exercises_between_30_minutes_and_1_hour_0_0 = TensorMap('Duration-of-other-exercises_Between-30-minutes-and-1-hour_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Duration-of-other-exercises_Between-30-minutes-and-1-hour_0_0': 0, 'Duration-of-other-exercises_Between-30-minutes-and-1-hour_0_0': 1})
use_of_sunuv_protection_always_0_0 = TensorMap('Use-of-sunuv-protection_Always_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Use-of-sunuv-protection_Always_0_0': 0, 'Use-of-sunuv-protection_Always_0_0': 1})
type_of_tobacco_previously_smoked_manufactured_cigarettes_0_0 = TensorMap('Type-of-tobacco-previously-smoked_Manufactured-cigarettes_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Type-of-tobacco-previously-smoked_Manufactured-cigarettes_0_0': 0, 'Type-of-tobacco-previously-smoked_Manufactured-cigarettes_0_0': 1})
back_pain_for_3_months_yes_0_0 = TensorMap('Back-pain-for-3-months_Yes_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Back-pain-for-3-months_Yes_0_0': 0, 'Back-pain-for-3-months_Yes_0_0': 1})
reason_for_reducing_amount_of_alcohol_drunk_other_reason_0_0 = TensorMap('Reason-for-reducing-amount-of-alcohol-drunk_Other-reason_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Reason-for-reducing-amount-of-alcohol-drunk_Other-reason_0_0': 0, 'Reason-for-reducing-amount-of-alcohol-drunk_Other-reason_0_0': 1})
triplet_correct_right_yes_0_3 = TensorMap('Triplet-correct-right_yes_0_3', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Triplet-correct-right_yes_0_3': 0, 'Triplet-correct-right_yes_0_3': 1})
frequency_of_stair_climbing_in_last_4_weeks_1115_times_a_day_0_0 = TensorMap('Frequency-of-stair-climbing-in-last-4-weeks_1115-times-a-day_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Frequency-of-stair-climbing-in-last-4-weeks_1115-times-a-day_0_0': 0, 'Frequency-of-stair-climbing-in-last-4-weeks_1115-times-a-day_0_0': 1})
workplace_full_of_chemical_or_other_fumes_rarelynever_0_0 = TensorMap('Workplace-full-of-chemical-or-other-fumes_Rarelynever_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Workplace-full-of-chemical-or-other-fumes_Rarelynever_0_0': 0, 'Workplace-full-of-chemical-or-other-fumes_Rarelynever_0_0': 1})
skin_colour_light_olive_0_0 = TensorMap('Skin-colour_Light-olive_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Skin-colour_Light-olive_0_0': 0, 'Skin-colour_Light-olive_0_0': 1})
likelihood_of_resuming_smoking_no_definitely_not_0_0 = TensorMap('Likelihood-of-resuming-smoking_No-definitely-not_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Likelihood-of-resuming-smoking_No-definitely-not_0_0': 0, 'Likelihood-of-resuming-smoking_No-definitely-not_0_0': 1})
worked_with_materials_containing_asbestos_rarelynever_0_0 = TensorMap('Worked-with-materials-containing-asbestos_Rarelynever_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Worked-with-materials-containing-asbestos_Rarelynever_0_0': 0, 'Worked-with-materials-containing-asbestos_Rarelynever_0_0': 1})
nonbutter_spread_type_details_polyunsaturatedsunflower_oil_based_spread_eg_flora_0_0 = TensorMap('Nonbutter-spread-type-details_Polyunsaturatedsunflower-oil-based-spread-eg-Flora_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Nonbutter-spread-type-details_Polyunsaturatedsunflower-oil-based-spread-eg-Flora_0_0': 0, 'Nonbutter-spread-type-details_Polyunsaturatedsunflower-oil-based-spread-eg-Flora_0_0': 1})
triplet_correct_left_yes_0_3 = TensorMap('Triplet-correct-left_yes_0_3', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Triplet-correct-left_yes_0_3': 0, 'Triplet-correct-left_yes_0_3': 1})
anycancer = TensorMap('anycancer', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_anycancer': 0, 'anycancer': 1})
types_of_physical_activity_in_last_4_weeks_light_diy_eg_pruning_watering_the_lawn_0_2 = TensorMap('Types-of-physical-activity-in-last-4-weeks_Light-DIY-eg-pruning-watering-the-lawn_0_2', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Types-of-physical-activity-in-last-4-weeks_Light-DIY-eg-pruning-watering-the-lawn_0_2': 0, 'Types-of-physical-activity-in-last-4-weeks_Light-DIY-eg-pruning-watering-the-lawn_0_2': 1})
blood_clot_dvt_bronchitis_emphysema_asthma_rhinitis_eczema_allergy_diagnosed_by_doctor_hayfever_allergic_rhinitis_or_eczema_0_0 = TensorMap('Blood-clot-DVT-bronchitis-emphysema-asthma-rhinitis-eczema-allergy-diagnosed-by-doctor_Hayfever-allergic-rhinitis-or-eczema_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Blood-clot-DVT-bronchitis-emphysema-asthma-rhinitis-eczema-allergy-diagnosed-by-doctor_Hayfever-allergic-rhinitis-or-eczema_0_0': 0, 'Blood-clot-DVT-bronchitis-emphysema-asthma-rhinitis-eczema-allergy-diagnosed-by-doctor_Hayfever-allergic-rhinitis-or-eczema_0_0': 1})
had_other_major_operations_no_0_0 = TensorMap('Had-other-major-operations_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Had-other-major-operations_No_0_0': 0, 'Had-other-major-operations_No_0_0': 1})
average_total_household_income_before_tax_less_than_18000_0_0 = TensorMap('Average-total-household-income-before-tax_Less-than-18000_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Average-total-household-income-before-tax_Less-than-18000_0_0': 0, 'Average-total-household-income-before-tax_Less-than-18000_0_0': 1})
average_total_household_income_before_tax_52000_to_100000_0_0 = TensorMap('Average-total-household-income-before-tax_52000-to-100000_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Average-total-household-income-before-tax_52000-to-100000_0_0': 0, 'Average-total-household-income-before-tax_52000-to-100000_0_0': 1})
ease_of_skin_tanning_never_tan_only_burn_0_0 = TensorMap('Ease-of-skin-tanning_Never-tan-only-burn_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Ease-of-skin-tanning_Never-tan-only-burn_0_0': 0, 'Ease-of-skin-tanning_Never-tan-only-burn_0_0': 1})
triplet_correct_left_yes_0_5 = TensorMap('Triplet-correct-left_yes_0_5', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Triplet-correct-left_yes_0_5': 0, 'Triplet-correct-left_yes_0_5': 1})
types_of_physical_activity_in_last_4_weeks_heavy_diy_eg_weeding_lawn_mowing_carpentry_digging_0_2 = TensorMap('Types-of-physical-activity-in-last-4-weeks_Heavy-DIY-eg-weeding-lawn-mowing-carpentry-digging_0_2', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Types-of-physical-activity-in-last-4-weeks_Heavy-DIY-eg-weeding-lawn-mowing-carpentry-digging_0_2': 0, 'Types-of-physical-activity-in-last-4-weeks_Heavy-DIY-eg-weeding-lawn-mowing-carpentry-digging_0_2': 1})
triplet_correct_left_yes_0_6 = TensorMap('Triplet-correct-left_yes_0_6', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Triplet-correct-left_yes_0_6': 0, 'Triplet-correct-left_yes_0_6': 1})
triplet_correct_right_yes_0_8 = TensorMap('Triplet-correct-right_yes_0_8', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Triplet-correct-right_yes_0_8': 0, 'Triplet-correct-right_yes_0_8': 1})
qualifications_none_of_the_above_0_0 = TensorMap('Qualifications_None-of-the-above_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Qualifications_None-of-the-above_0_0': 0, 'Qualifications_None-of-the-above_0_0': 1})
workplace_very_dusty_rarelynever_0_0 = TensorMap('Workplace-very-dusty_Rarelynever_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Workplace-very-dusty_Rarelynever_0_0': 0, 'Workplace-very-dusty_Rarelynever_0_0': 1})
coffee_type_ground_coffee_include_espresso_filter_etc_0_0 = TensorMap('Coffee-type_Ground-coffee-include-espresso-filter-etc_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Coffee-type_Ground-coffee-include-espresso-filter-etc_0_0': 0, 'Coffee-type_Ground-coffee-include-espresso-filter-etc_0_0': 1})
triplet_correct_left_yes_0_7 = TensorMap('Triplet-correct-left_yes_0_7', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Triplet-correct-left_yes_0_7': 0, 'Triplet-correct-left_yes_0_7': 1})
hot_drink_temperature_very_hot_0_0 = TensorMap('Hot-drink-temperature_Very-hot_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Hot-drink-temperature_Very-hot_0_0': 0, 'Hot-drink-temperature_Very-hot_0_0': 1})
triplet_correct_right_yes_0_6 = TensorMap('Triplet-correct-right_yes_0_6', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Triplet-correct-right_yes_0_6': 0, 'Triplet-correct-right_yes_0_6': 1})
cheese_intake_less_than_once_a_week_0_0 = TensorMap('Cheese-intake_Less-than-once-a-week_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Cheese-intake_Less-than-once-a-week_0_0': 0, 'Cheese-intake_Less-than-once-a-week_0_0': 1})
pork_intake_never_0_0 = TensorMap('Pork-intake_Never_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Pork-intake_Never_0_0': 0, 'Pork-intake_Never_0_0': 1})
lambmutton_intake_never_0_0 = TensorMap('Lambmutton-intake_Never_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Lambmutton-intake_Never_0_0': 0, 'Lambmutton-intake_Never_0_0': 1})
fi7_synonym_cease_0_0 = TensorMap('FI7-synonym_cease_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_FI7-synonym_cease_0_0': 0, 'FI7-synonym_cease_0_0': 1})
triplet_correct_right_yes_0_11 = TensorMap('Triplet-correct-right_yes_0_11', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Triplet-correct-right_yes_0_11': 0, 'Triplet-correct-right_yes_0_11': 1})
breathing_problems_during_period_of_job_no_0_1 = TensorMap('Breathing-problems-during-period-of-job_No_0_1', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Breathing-problems-during-period-of-job_No_0_1': 0, 'Breathing-problems-during-period-of-job_No_0_1': 1})
knee_pain_for_3_months_yes_0_0 = TensorMap('Knee-pain-for-3-months_Yes_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Knee-pain-for-3-months_Yes_0_0': 0, 'Knee-pain-for-3-months_Yes_0_0': 1})
ever_had_stillbirth_spontaneous_miscarriage_or_termination_yes_0_0 = TensorMap('Ever-had-stillbirth-spontaneous-miscarriage-or-termination_Yes_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Ever-had-stillbirth-spontaneous-miscarriage-or-termination_Yes_0_0': 0, 'Ever-had-stillbirth-spontaneous-miscarriage-or-termination_Yes_0_0': 1})
worked_with_pesticides_rarelynever_0_1 = TensorMap('Worked-with-pesticides_Rarelynever_0_1', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Worked-with-pesticides_Rarelynever_0_1': 0, 'Worked-with-pesticides_Rarelynever_0_1': 1})
triplet_correct_right_no_0_4 = TensorMap('Triplet-correct-right_no_0_4', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Triplet-correct-right_no_0_4': 0, 'Triplet-correct-right_no_0_4': 1})
frequency_of_other_exercises_in_last_4_weeks_23_times_a_week_0_0 = TensorMap('Frequency-of-other-exercises-in-last-4-weeks_23-times-a-week_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Frequency-of-other-exercises-in-last-4-weeks_23-times-a-week_0_0': 0, 'Frequency-of-other-exercises-in-last-4-weeks_23-times-a-week_0_0': 1})
cereal_type_other_eg_cornflakes_frosties_0_0 = TensorMap('Cereal-type_Other-eg-Cornflakes-Frosties_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Cereal-type_Other-eg-Cornflakes-Frosties_0_0': 0, 'Cereal-type_Other-eg-Cornflakes-Frosties_0_0': 1})
triplet_correct_left_yes_0_9 = TensorMap('Triplet-correct-left_yes_0_9', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Triplet-correct-left_yes_0_9': 0, 'Triplet-correct-left_yes_0_9': 1})
vitamin_and_mineral_supplements_multivitamins_minerals_0_0 = TensorMap('Vitamin-and-mineral-supplements_Multivitamins-minerals_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Vitamin-and-mineral-supplements_Multivitamins-minerals_0_0': 0, 'Vitamin-and-mineral-supplements_Multivitamins-minerals_0_0': 1})
triplet_correct_left_yes_0_10 = TensorMap('Triplet-correct-left_yes_0_10', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Triplet-correct-left_yes_0_10': 0, 'Triplet-correct-left_yes_0_10': 1})
triplet_correct_left_yes_0_8 = TensorMap('Triplet-correct-left_yes_0_8', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Triplet-correct-left_yes_0_8': 0, 'Triplet-correct-left_yes_0_8': 1})
oily_fish_intake_24_times_a_week_0_0 = TensorMap('Oily-fish-intake_24-times-a-week_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Oily-fish-intake_24-times-a-week_0_0': 0, 'Oily-fish-intake_24-times-a-week_0_0': 1})
had_major_operations_no_0_0 = TensorMap('Had-major-operations_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Had-major-operations_No_0_0': 0, 'Had-major-operations_No_0_0': 1})
alcohol_usually_taken_with_meals_no_0_0 = TensorMap('Alcohol-usually-taken-with-meals_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Alcohol-usually-taken-with-meals_No_0_0': 0, 'Alcohol-usually-taken-with-meals_No_0_0': 1})
triplet_correct_left_no_0_4 = TensorMap('Triplet-correct-left_no_0_4', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Triplet-correct-left_no_0_4': 0, 'Triplet-correct-left_no_0_4': 1})
neckshoulder_pain_for_3_months_yes_0_0 = TensorMap('Neckshoulder-pain-for-3-months_Yes_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Neckshoulder-pain-for-3-months_Yes_0_0': 0, 'Neckshoulder-pain-for-3-months_Yes_0_0': 1})
triplet_correct_right_yes_0_12 = TensorMap('Triplet-correct-right_yes_0_12', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Triplet-correct-right_yes_0_12': 0, 'Triplet-correct-right_yes_0_12': 1})
cereal_type_muesli_0_0 = TensorMap('Cereal-type_Muesli_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Cereal-type_Muesli_0_0': 0, 'Cereal-type_Muesli_0_0': 1})
triplet_correct_left_yes_0_13 = TensorMap('Triplet-correct-left_yes_0_13', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Triplet-correct-left_yes_0_13': 0, 'Triplet-correct-left_yes_0_13': 1})
triplet_correct_left_yes_0_11 = TensorMap('Triplet-correct-left_yes_0_11', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Triplet-correct-left_yes_0_11': 0, 'Triplet-correct-left_yes_0_11': 1})
triplet_correct_left_yes_0_14 = TensorMap('Triplet-correct-left_yes_0_14', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Triplet-correct-left_yes_0_14': 0, 'Triplet-correct-left_yes_0_14': 1})
triplet_correct_right_yes_0_7 = TensorMap('Triplet-correct-right_yes_0_7', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Triplet-correct-right_yes_0_7': 0, 'Triplet-correct-right_yes_0_7': 1})
duration_of_light_diy_between_30_minutes_and_1_hour_0_0 = TensorMap('Duration-of-light-DIY_Between-30-minutes-and-1-hour_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Duration-of-light-DIY_Between-30-minutes-and-1-hour_0_0': 0, 'Duration-of-light-DIY_Between-30-minutes-and-1-hour_0_0': 1})
triplet_correct_right_yes_0_13 = TensorMap('Triplet-correct-right_yes_0_13', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Triplet-correct-right_yes_0_13': 0, 'Triplet-correct-right_yes_0_13': 1})
triplet_correct_right_yes_0_10 = TensorMap('Triplet-correct-right_yes_0_10', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Triplet-correct-right_yes_0_10': 0, 'Triplet-correct-right_yes_0_10': 1})
fi6_conditional_arithmetic_69_0_0 = TensorMap('FI6-conditional-arithmetic_69_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_FI6-conditional-arithmetic_69_0_0': 0, 'FI6-conditional-arithmetic_69_0_0': 1})
workplace_very_cold_rarelynever_0_0 = TensorMap('Workplace-very-cold_Rarelynever_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Workplace-very-cold_Rarelynever_0_0': 0, 'Workplace-very-cold_Rarelynever_0_0': 1})
triplet_correct_right_yes_0_9 = TensorMap('Triplet-correct-right_yes_0_9', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Triplet-correct-right_yes_0_9': 0, 'Triplet-correct-right_yes_0_9': 1})
triplet_correct_left_no_0_12 = TensorMap('Triplet-correct-left_no_0_12', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Triplet-correct-left_no_0_12': 0, 'Triplet-correct-left_no_0_12': 1})
triplet_correct_left_yes_0_15 = TensorMap('Triplet-correct-left_yes_0_15', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Triplet-correct-left_yes_0_15': 0, 'Triplet-correct-left_yes_0_15': 1})
triplet_correct_right_no_0_5 = TensorMap('Triplet-correct-right_no_0_5', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Triplet-correct-right_no_0_5': 0, 'Triplet-correct-right_no_0_5': 1})
triplet_correct_right_yes_0_15 = TensorMap('Triplet-correct-right_yes_0_15', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Triplet-correct-right_yes_0_15': 0, 'Triplet-correct-right_yes_0_15': 1})
triplet_correct_right_yes_0_5 = TensorMap('Triplet-correct-right_yes_0_5', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Triplet-correct-right_yes_0_5': 0, 'Triplet-correct-right_yes_0_5': 1})
triplet_correct_right_yes_0_14 = TensorMap('Triplet-correct-right_yes_0_14', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Triplet-correct-right_yes_0_14': 0, 'Triplet-correct-right_yes_0_14': 1})
overall_health_rating_excellent_0_0 = TensorMap('Overall-health-rating_Excellent_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Overall-health-rating_Excellent_0_0': 0, 'Overall-health-rating_Excellent_0_0': 1})
triplet_correct_right_no_0_14 = TensorMap('Triplet-correct-right_no_0_14', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Triplet-correct-right_no_0_14': 0, 'Triplet-correct-right_no_0_14': 1})
triplet_correct_right_no_0_15 = TensorMap('Triplet-correct-right_no_0_15', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Triplet-correct-right_no_0_15': 0, 'Triplet-correct-right_no_0_15': 1})
triplet_correct_left_yes_0_12 = TensorMap('Triplet-correct-left_yes_0_12', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Triplet-correct-left_yes_0_12': 0, 'Triplet-correct-left_yes_0_12': 1})
triplet_correct_left_no_0_15 = TensorMap('Triplet-correct-left_no_0_15', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Triplet-correct-left_no_0_15': 0, 'Triplet-correct-left_no_0_15': 1})
triplet_correct_right_no_0_9 = TensorMap('Triplet-correct-right_no_0_9', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Triplet-correct-right_no_0_9': 0, 'Triplet-correct-right_no_0_9': 1})
triplet_correct_right_no_0_10 = TensorMap('Triplet-correct-right_no_0_10', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Triplet-correct-right_no_0_10': 0, 'Triplet-correct-right_no_0_10': 1})
triplet_correct_right_no_0_7 = TensorMap('Triplet-correct-right_no_0_7', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Triplet-correct-right_no_0_7': 0, 'Triplet-correct-right_no_0_7': 1})
triplet_correct_right_no_0_13 = TensorMap('Triplet-correct-right_no_0_13', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Triplet-correct-right_no_0_13': 0, 'Triplet-correct-right_no_0_13': 1})
qualifications_a_levelsas_levels_or_equivalent_0_1 = TensorMap('Qualifications_A-levelsAS-levels-or-equivalent_0_1', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Qualifications_A-levelsAS-levels-or-equivalent_0_1': 0, 'Qualifications_A-levelsAS-levels-or-equivalent_0_1': 1})
hernia = TensorMap('hernia', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_hernia': 0, 'hernia': 1})
chest_pain_felt_outside_physical_activity_no_0_0 = TensorMap('Chest-pain-felt-outside-physical-activity_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Chest-pain-felt-outside-physical-activity_No_0_0': 0, 'Chest-pain-felt-outside-physical-activity_No_0_0': 1})
triplet_correct_left_no_0_11 = TensorMap('Triplet-correct-left_no_0_11', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Triplet-correct-left_no_0_11': 0, 'Triplet-correct-left_no_0_11': 1})
composite_mi_cad_stroke_death = TensorMap('composite_mi_cad_stroke_death', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_composite_mi_cad_stroke_death': 0, 'composite_mi_cad_stroke_death': 1})
comparative_body_size_at_age_10_plumper_0_0 = TensorMap('Comparative-body-size-at-age-10_Plumper_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Comparative-body-size-at-age-10_Plumper_0_0': 0, 'Comparative-body-size-at-age-10_Plumper_0_0': 1})
triplet_correct_left_no_0_14 = TensorMap('Triplet-correct-left_no_0_14', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Triplet-correct-left_no_0_14': 0, 'Triplet-correct-left_no_0_14': 1})
job_involved_shift_work_no_0_1 = TensorMap('Job-involved-shift-work_No_0_1', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Job-involved-shift-work_No_0_1': 0, 'Job-involved-shift-work_No_0_1': 1})
chest_pain_or_discomfort_yes_0_0 = TensorMap('Chest-pain-or-discomfort_Yes_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Chest-pain-or-discomfort_Yes_0_0': 0, 'Chest-pain-or-discomfort_Yes_0_0': 1})
triplet_correct_left_yes_0_4 = TensorMap('Triplet-correct-left_yes_0_4', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Triplet-correct-left_yes_0_4': 0, 'Triplet-correct-left_yes_0_4': 1})
triplet_correct_left_no_0_13 = TensorMap('Triplet-correct-left_no_0_13', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Triplet-correct-left_no_0_13': 0, 'Triplet-correct-left_no_0_13': 1})
composite_mi_cad_stroke_death_exclude_aml = TensorMap('composite_mi_cad_stroke_death_exclude_aml', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_composite_mi_cad_stroke_death_exclude_aml': 0, 'composite_mi_cad_stroke_death_exclude_aml': 1})
workplace_had_a_lot_of_diesel_exhaust_rarelynever_0_1 = TensorMap('Workplace-had-a-lot-of-diesel-exhaust_Rarelynever_0_1', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Workplace-had-a-lot-of-diesel-exhaust_Rarelynever_0_1': 0, 'Workplace-had-a-lot-of-diesel-exhaust_Rarelynever_0_1': 1})
doctor_restricts_physical_activity_due_to_heart_condition_no_0_0 = TensorMap('Doctor-restricts-physical-activity-due-to-heart-condition_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Doctor-restricts-physical-activity-due-to-heart-condition_No_0_0': 0, 'Doctor-restricts-physical-activity-due-to-heart-condition_No_0_0': 1})
triplet_correct_right_no_0_12 = TensorMap('Triplet-correct-right_no_0_12', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Triplet-correct-right_no_0_12': 0, 'Triplet-correct-right_no_0_12': 1})
pain_types_experienced_in_last_month_neck_or_shoulder_pain_0_0 = TensorMap('Pain-types-experienced-in-last-month_Neck-or-shoulder-pain_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Pain-types-experienced-in-last-month_Neck-or-shoulder-pain_0_0': 0, 'Pain-types-experienced-in-last-month_Neck-or-shoulder-pain_0_0': 1})
alcohol_intake_versus_10_years_previously_more_nowadays_0_0 = TensorMap('Alcohol-intake-versus-10-years-previously_More-nowadays_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Alcohol-intake-versus-10-years-previously_More-nowadays_0_0': 0, 'Alcohol-intake-versus-10-years-previously_More-nowadays_0_0': 1})
composite_mi_cad_stroke_death_exclude_heme = TensorMap('composite_mi_cad_stroke_death_exclude_heme', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_composite_mi_cad_stroke_death_exclude_heme': 0, 'composite_mi_cad_stroke_death_exclude_heme': 1})
frequency_of_walking_for_pleasure_in_last_4_weeks_23_times_a_week_0_0 = TensorMap('Frequency-of-walking-for-pleasure-in-last-4-weeks_23-times-a-week_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Frequency-of-walking-for-pleasure-in-last-4-weeks_23-times-a-week_0_0': 0, 'Frequency-of-walking-for-pleasure-in-last-4-weeks_23-times-a-week_0_0': 1})
triplet_correct_left_no_0_8 = TensorMap('Triplet-correct-left_no_0_8', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Triplet-correct-left_no_0_8': 0, 'Triplet-correct-left_no_0_8': 1})
triplet_correct_left_no_0_10 = TensorMap('Triplet-correct-left_no_0_10', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Triplet-correct-left_no_0_10': 0, 'Triplet-correct-left_no_0_10': 1})
chest_pain_felt_during_physical_activity_no_0_0 = TensorMap('Chest-pain-felt-during-physical-activity_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Chest-pain-felt-during-physical-activity_No_0_0': 0, 'Chest-pain-felt-during-physical-activity_No_0_0': 1})
duration_walking_for_pleasure_between_15_and_30_minutes_0_0 = TensorMap('Duration-walking-for-pleasure_Between-15-and-30-minutes_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Duration-walking-for-pleasure_Between-15-and-30-minutes_0_0': 0, 'Duration-walking-for-pleasure_Between-15-and-30-minutes_0_0': 1})
triplet_correct_right_yes_0_4 = TensorMap('Triplet-correct-right_yes_0_4', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Triplet-correct-right_yes_0_4': 0, 'Triplet-correct-right_yes_0_4': 1})
triplet_correct_left_no_0_9 = TensorMap('Triplet-correct-left_no_0_9', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Triplet-correct-left_no_0_9': 0, 'Triplet-correct-left_no_0_9': 1})
able_to_walk_or_cycle_unaided_for_10_minutes_yes_0_0 = TensorMap('Able-to-walk-or-cycle-unaided-for-10-minutes_Yes_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Able-to-walk-or-cycle-unaided-for-10-minutes_Yes_0_0': 0, 'Able-to-walk-or-cycle-unaided-for-10-minutes_Yes_0_0': 1})
worked_with_paints_thinners_or_glues_rarelynever_0_1 = TensorMap('Worked-with-paints-thinners-or-glues_Rarelynever_0_1', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Worked-with-paints-thinners-or-glues_Rarelynever_0_1': 0, 'Worked-with-paints-thinners-or-glues_Rarelynever_0_1': 1})
past_tobacco_smoking_just_tried_once_or_twice_0_0 = TensorMap('Past-tobacco-smoking_Just-tried-once-or-twice_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Past-tobacco-smoking_Just-tried-once-or-twice_0_0': 0, 'Past-tobacco-smoking_Just-tried-once-or-twice_0_0': 1})
completion_status_of_test_fully_completed_0_0 = TensorMap('Completion-status-of-test_Fully-completed_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Completion-status-of-test_Fully-completed_0_0': 0, 'Completion-status-of-test_Fully-completed_0_0': 1})
hairbalding_pattern_pattern_1_0_0 = TensorMap('Hairbalding-pattern_Pattern-1_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Hairbalding-pattern_Pattern-1_0_0': 0, 'Hairbalding-pattern_Pattern-1_0_0': 1})
hot_drink_temperature_warm_0_0 = TensorMap('Hot-drink-temperature_Warm_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Hot-drink-temperature_Warm_0_0': 0, 'Hot-drink-temperature_Warm_0_0': 1})
triplet_correct_right_no_0_11 = TensorMap('Triplet-correct-right_no_0_11', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Triplet-correct-right_no_0_11': 0, 'Triplet-correct-right_no_0_11': 1})
light_smokers_at_least_100_smokes_in_lifetime_no_0_0 = TensorMap('Light-smokers-at-least-100-smokes-in-lifetime_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Light-smokers-at-least-100-smokes-in-lifetime_No_0_0': 0, 'Light-smokers-at-least-100-smokes-in-lifetime_No_0_0': 1})
qualifications_o_levelsgcses_or_equivalent_0_2 = TensorMap('Qualifications_O-levelsGCSEs-or-equivalent_0_2', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Qualifications_O-levelsGCSEs-or-equivalent_0_2': 0, 'Qualifications_O-levelsGCSEs-or-equivalent_0_2': 1})
asthma = TensorMap('asthma', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_asthma': 0, 'asthma': 1})
triplet_correct_right_no_0_6 = TensorMap('Triplet-correct-right_no_0_6', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Triplet-correct-right_no_0_6': 0, 'Triplet-correct-right_no_0_6': 1})
triplet_correct_left_no_0_7 = TensorMap('Triplet-correct-left_no_0_7', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Triplet-correct-left_no_0_7': 0, 'Triplet-correct-left_no_0_7': 1})
cereal_type_biscuit_cereal_eg_weetabix_0_0 = TensorMap('Cereal-type_Biscuit-cereal-eg-Weetabix_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Cereal-type_Biscuit-cereal-eg-Weetabix_0_0': 0, 'Cereal-type_Biscuit-cereal-eg-Weetabix_0_0': 1})
coffee_type_decaffeinated_coffee_any_type_0_0 = TensorMap('Coffee-type_Decaffeinated-coffee-any-type_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Coffee-type_Decaffeinated-coffee-any-type_0_0': 0, 'Coffee-type_Decaffeinated-coffee-any-type_0_0': 1})
types_of_transport_used_excluding_work_public_transport_0_2 = TensorMap('Types-of-transport-used-excluding-work_Public-transport_0_2', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Types-of-transport-used-excluding-work_Public-transport_0_2': 0, 'Types-of-transport-used-excluding-work_Public-transport_0_2': 1})
nonoily_fish_intake_24_times_a_week_0_0 = TensorMap('Nonoily-fish-intake_24-times-a-week_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Nonoily-fish-intake_24-times-a-week_0_0': 0, 'Nonoily-fish-intake_24-times-a-week_0_0': 1})
worked_with_materials_containing_asbestos_rarelynever_0_1 = TensorMap('Worked-with-materials-containing-asbestos_Rarelynever_0_1', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Worked-with-materials-containing-asbestos_Rarelynever_0_1': 0, 'Worked-with-materials-containing-asbestos_Rarelynever_0_1': 1})
workplace_full_of_chemical_or_other_fumes_rarelynever_0_1 = TensorMap('Workplace-full-of-chemical-or-other-fumes_Rarelynever_0_1', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Workplace-full-of-chemical-or-other-fumes_Rarelynever_0_1': 0, 'Workplace-full-of-chemical-or-other-fumes_Rarelynever_0_1': 1})
triplet_correct_left_no_0_6 = TensorMap('Triplet-correct-left_no_0_6', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Triplet-correct-left_no_0_6': 0, 'Triplet-correct-left_no_0_6': 1})
target_heart_rate_achieved_false_0_0 = TensorMap('Target-heart-rate-achieved_False_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Target-heart-rate-achieved_False_0_0': 0, 'Target-heart-rate-achieved_False_0_0': 1})
triplet_correct_right_no_0_8 = TensorMap('Triplet-correct-right_no_0_8', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Triplet-correct-right_no_0_8': 0, 'Triplet-correct-right_no_0_8': 1})
triplet_correct_left_no_0_5 = TensorMap('Triplet-correct-left_no_0_5', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Triplet-correct-left_no_0_5': 0, 'Triplet-correct-left_no_0_5': 1})
weight_change_compared_with_1_year_ago_yes_lost_weight_0_0 = TensorMap('Weight-change-compared-with-1-year-ago_Yes-lost-weight_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Weight-change-compared-with-1-year-ago_Yes-lost-weight_0_0': 0, 'Weight-change-compared-with-1-year-ago_Yes-lost-weight_0_0': 1})
medication_for_pain_relief_constipation_heartburn_aspirin_0_0 = TensorMap('Medication-for-pain-relief-constipation-heartburn_Aspirin_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Medication-for-pain-relief-constipation-heartburn_Aspirin_0_0': 0, 'Medication-for-pain-relief-constipation-heartburn_Aspirin_0_0': 1})
other_eye_problems_yes_0_0 = TensorMap('Other-eye-problems_Yes_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Other-eye-problems_Yes_0_0': 0, 'Other-eye-problems_Yes_0_0': 1})
never_eat_eggs_dairy_wheat_sugar_sugar_or_foodsdrinks_containing_sugar_0_0 = TensorMap('Never-eat-eggs-dairy-wheat-sugar_Sugar-or-foodsdrinks-containing-sugar_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Never-eat-eggs-dairy-wheat-sugar_Sugar-or-foodsdrinks-containing-sugar_0_0': 0, 'Never-eat-eggs-dairy-wheat-sugar_Sugar-or-foodsdrinks-containing-sugar_0_0': 1})
ecgbike_method_for_fitness_test_bicycle_0_0 = TensorMap('ECGbike-method-for-fitness-test_Bicycle_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_ECGbike-method-for-fitness-test_Bicycle_0_0': 0, 'ECGbike-method-for-fitness-test_Bicycle_0_0': 1})
triplet_correct_left_no_0_3 = TensorMap('Triplet-correct-left_no_0_3', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Triplet-correct-left_no_0_3': 0, 'Triplet-correct-left_no_0_3': 1})
illnesses_of_father_high_blood_pressure_0_0 = TensorMap('Illnesses-of-father_High-blood-pressure_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Illnesses-of-father_High-blood-pressure_0_0': 0, 'Illnesses-of-father_High-blood-pressure_0_0': 1})
oct_measured_right_measurable_0_0 = TensorMap('OCT-measured-right_Measurable_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_OCT-measured-right_Measurable_0_0': 0, 'OCT-measured-right_Measurable_0_0': 1})
cereal_type_bran_cereal_eg_all_bran_branflakes_0_0 = TensorMap('Cereal-type_Bran-cereal-eg-All-Bran-Branflakes_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Cereal-type_Bran-cereal-eg-All-Bran-Branflakes_0_0': 0, 'Cereal-type_Bran-cereal-eg-All-Bran-Branflakes_0_0': 1})
imaging = TensorMap('imaging', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_imaging': 0, 'imaging': 1})
falls_in_the_last_year_only_one_fall_0_0 = TensorMap('Falls-in-the-last-year_Only-one-fall_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Falls-in-the-last-year_Only-one-fall_0_0': 0, 'Falls-in-the-last-year_Only-one-fall_0_0': 1})
medication_for_pain_relief_constipation_heartburn_paracetamol_0_0 = TensorMap('Medication-for-pain-relief-constipation-heartburn_Paracetamol_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Medication-for-pain-relief-constipation-heartburn_Paracetamol_0_0': 0, 'Medication-for-pain-relief-constipation-heartburn_Paracetamol_0_0': 1})
medication_for_pain_relief_constipation_heartburn_ibuprofen_eg_nurofen_0_0 = TensorMap('Medication-for-pain-relief-constipation-heartburn_Ibuprofen-eg-Nurofen_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Medication-for-pain-relief-constipation-heartburn_Ibuprofen-eg-Nurofen_0_0': 0, 'Medication-for-pain-relief-constipation-heartburn_Ibuprofen-eg-Nurofen_0_0': 1})
fi5_family_relationship_calculation_cousin_0_0 = TensorMap('FI5-family-relationship-calculation_cousin_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_FI5-family-relationship-calculation_cousin_0_0': 0, 'FI5-family-relationship-calculation_cousin_0_0': 1})
oct_measured_left_measurable_0_0 = TensorMap('OCT-measured-left_Measurable_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_OCT-measured-left_Measurable_0_0': 0, 'OCT-measured-left_Measurable_0_0': 1})
frequency_of_light_diy_in_last_4_weeks_23_times_in_the_last_4_weeks_0_0 = TensorMap('Frequency-of-light-DIY-in-last-4-weeks_23-times-in-the-last-4-weeks_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Frequency-of-light-DIY-in-last-4-weeks_23-times-in-the-last-4-weeks_0_0': 0, 'Frequency-of-light-DIY-in-last-4-weeks_23-times-in-the-last-4-weeks_0_0': 1})
worked_with_pesticides_rarelynever_0_2 = TensorMap('Worked-with-pesticides_Rarelynever_0_2', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Worked-with-pesticides_Rarelynever_0_2': 0, 'Worked-with-pesticides_Rarelynever_0_2': 1})
types_of_transport_used_excluding_work_walk_0_0 = TensorMap('Types-of-transport-used-excluding-work_Walk_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Types-of-transport-used-excluding-work_Walk_0_0': 0, 'Types-of-transport-used-excluding-work_Walk_0_0': 1})
illnesses_of_siblings_high_blood_pressure_0_0 = TensorMap('Illnesses-of-siblings_High-blood-pressure_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Illnesses-of-siblings_High-blood-pressure_0_0': 0, 'Illnesses-of-siblings_High-blood-pressure_0_0': 1})
triplet_correct_right_no_0_3 = TensorMap('Triplet-correct-right_no_0_3', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Triplet-correct-right_no_0_3': 0, 'Triplet-correct-right_no_0_3': 1})
breathing_problems_during_period_of_job_no_0_2 = TensorMap('Breathing-problems-during-period-of-job_No_0_2', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Breathing-problems-during-period-of-job_No_0_2': 0, 'Breathing-problems-during-period-of-job_No_0_2': 1})
menstruating_today_no_0_0 = TensorMap('Menstruating-today_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Menstruating-today_No_0_0': 0, 'Menstruating-today_No_0_0': 1})
past_tobacco_smoking_smoked_occasionally_0_0 = TensorMap('Past-tobacco-smoking_Smoked-occasionally_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Past-tobacco-smoking_Smoked-occasionally_0_0': 0, 'Past-tobacco-smoking_Smoked-occasionally_0_0': 1})
workplace_very_dusty_rarelynever_0_1 = TensorMap('Workplace-very-dusty_Rarelynever_0_1', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Workplace-very-dusty_Rarelynever_0_1': 0, 'Workplace-very-dusty_Rarelynever_0_1': 1})
nonbutter_spread_type_details_olive_oil_based_spread_eg_bertolli_0_0 = TensorMap('Nonbutter-spread-type-details_Olive-oil-based-spread-eg-Bertolli_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Nonbutter-spread-type-details_Olive-oil-based-spread-eg-Bertolli_0_0': 0, 'Nonbutter-spread-type-details_Olive-oil-based-spread-eg-Bertolli_0_0': 1})
had_menopause_no_0_0 = TensorMap('Had-menopause_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Had-menopause_No_0_0': 0, 'Had-menopause_No_0_0': 1})
workplace_very_hot_rarelynever_0_0 = TensorMap('Workplace-very-hot_Rarelynever_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Workplace-very-hot_Rarelynever_0_0': 0, 'Workplace-very-hot_Rarelynever_0_0': 1})
fi8_chained_arithmetic_26_0_0 = TensorMap('FI8-chained-arithmetic_26_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_FI8-chained-arithmetic_26_0_0': 0, 'FI8-chained-arithmetic_26_0_0': 1})
frequency_of_light_diy_in_last_4_weeks_23_times_a_week_0_0 = TensorMap('Frequency-of-light-DIY-in-last-4-weeks_23-times-a-week_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Frequency-of-light-DIY-in-last-4-weeks_23-times-a-week_0_0': 0, 'Frequency-of-light-DIY-in-last-4-weeks_23-times-a-week_0_0': 1})
illnesses_of_father_heart_disease_0_0 = TensorMap('Illnesses-of-father_Heart-disease_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Illnesses-of-father_Heart-disease_0_0': 0, 'Illnesses-of-father_Heart-disease_0_0': 1})
workplace_very_noisy_rarelynever_0_0 = TensorMap('Workplace-very-noisy_Rarelynever_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Workplace-very-noisy_Rarelynever_0_0': 0, 'Workplace-very-noisy_Rarelynever_0_0': 1})
composite_mi_cad_stroke_hf = TensorMap('composite_mi_cad_stroke_hf', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_composite_mi_cad_stroke_hf': 0, 'composite_mi_cad_stroke_hf': 1})
worked_with_paints_thinners_or_glues_rarelynever_0_2 = TensorMap('Worked-with-paints-thinners-or-glues_Rarelynever_0_2', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Worked-with-paints-thinners-or-glues_Rarelynever_0_2': 0, 'Worked-with-paints-thinners-or-glues_Rarelynever_0_2': 1})
chest_pain_or_discomfort_walking_normally_no_0_0 = TensorMap('Chest-pain-or-discomfort-walking-normally_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Chest-pain-or-discomfort-walking-normally_No_0_0': 0, 'Chest-pain-or-discomfort-walking-normally_No_0_0': 1})
volume_level_set_by_participant_left_10_0_0 = TensorMap('Volume-level-set-by-participant-left_10_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Volume-level-set-by-participant-left_10_0_0': 0, 'Volume-level-set-by-participant-left_10_0_0': 1})
job_involved_shift_work_no_0_2 = TensorMap('Job-involved-shift-work_No_0_2', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Job-involved-shift-work_No_0_2': 0, 'Job-involved-shift-work_No_0_2': 1})
frequency_of_walking_for_pleasure_in_last_4_weeks_once_a_week_0_0 = TensorMap('Frequency-of-walking-for-pleasure-in-last-4-weeks_Once-a-week_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Frequency-of-walking-for-pleasure-in-last-4-weeks_Once-a-week_0_0': 0, 'Frequency-of-walking-for-pleasure-in-last-4-weeks_Once-a-week_0_0': 1})
ever_had_prostate_specific_antigen_psa_test_yes_0_0 = TensorMap('Ever-had-prostate-specific-antigen-PSA-test_Yes_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Ever-had-prostate-specific-antigen-PSA-test_Yes_0_0': 0, 'Ever-had-prostate-specific-antigen-PSA-test_Yes_0_0': 1})
gastroesophageal_reflux_disease = TensorMap('gastroesophageal_reflux_disease', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_gastroesophageal_reflux_disease': 0, 'gastroesophageal_reflux_disease': 1})
light_smokers_at_least_100_smokes_in_lifetime_yes_0_0 = TensorMap('Light-smokers-at-least-100-smokes-in-lifetime_Yes_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Light-smokers-at-least-100-smokes-in-lifetime_Yes_0_0': 0, 'Light-smokers-at-least-100-smokes-in-lifetime_Yes_0_0': 1})
reason_for_reducing_amount_of_alcohol_drunk_health_precaution_0_0 = TensorMap('Reason-for-reducing-amount-of-alcohol-drunk_Health-precaution_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Reason-for-reducing-amount-of-alcohol-drunk_Health-precaution_0_0': 0, 'Reason-for-reducing-amount-of-alcohol-drunk_Health-precaution_0_0': 1})
pain_types_experienced_in_last_month_back_pain_0_0 = TensorMap('Pain-types-experienced-in-last-month_Back-pain_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Pain-types-experienced-in-last-month_Back-pain_0_0': 0, 'Pain-types-experienced-in-last-month_Back-pain_0_0': 1})
workplace_had_a_lot_of_diesel_exhaust_rarelynever_0_2 = TensorMap('Workplace-had-a-lot-of-diesel-exhaust_Rarelynever_0_2', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Workplace-had-a-lot-of-diesel-exhaust_Rarelynever_0_2': 0, 'Workplace-had-a-lot-of-diesel-exhaust_Rarelynever_0_2': 1})
salt_added_to_food_usually_0_0 = TensorMap('Salt-added-to-food_Usually_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Salt-added-to-food_Usually_0_0': 0, 'Salt-added-to-food_Usually_0_0': 1})
illnesses_of_mother_none_of_the_above_group_2_0_2 = TensorMap('Illnesses-of-mother_None-of-the-above-group-2_0_2', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Illnesses-of-mother_None-of-the-above-group-2_0_2': 0, 'Illnesses-of-mother_None-of-the-above-group-2_0_2': 1})
volume_level_set_by_participant_right_10_0_0 = TensorMap('Volume-level-set-by-participant-right_10_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Volume-level-set-by-participant-right_10_0_0': 0, 'Volume-level-set-by-participant-right_10_0_0': 1})
bread_type_brown_0_0 = TensorMap('Bread-type_Brown_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Bread-type_Brown_0_0': 0, 'Bread-type_Brown_0_0': 1})
maternal_smoking_around_birth_do_not_know_0_0 = TensorMap('Maternal-smoking-around-birth_Do-not-know_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Maternal-smoking-around-birth_Do-not-know_0_0': 0, 'Maternal-smoking-around-birth_Do-not-know_0_0': 1})
types_of_physical_activity_in_last_4_weeks_other_exercises_eg_swimming_cycling_keep_fit_bowling_0_0 = TensorMap('Types-of-physical-activity-in-last-4-weeks_Other-exercises-eg-swimming-cycling-keep-fit-bowling_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Types-of-physical-activity-in-last-4-weeks_Other-exercises-eg-swimming-cycling-keep-fit-bowling_0_0': 0, 'Types-of-physical-activity-in-last-4-weeks_Other-exercises-eg-swimming-cycling-keep-fit-bowling_0_0': 1})
mouthteeth_dental_problems_dentures_0_0 = TensorMap('Mouthteeth-dental-problems_Dentures_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Mouthteeth-dental-problems_Dentures_0_0': 0, 'Mouthteeth-dental-problems_Dentures_0_0': 1})
workplace_full_of_chemical_or_other_fumes_rarelynever_0_2 = TensorMap('Workplace-full-of-chemical-or-other-fumes_Rarelynever_0_2', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Workplace-full-of-chemical-or-other-fumes_Rarelynever_0_2': 0, 'Workplace-full-of-chemical-or-other-fumes_Rarelynever_0_2': 1})
frequency_of_heavy_diy_in_last_4_weeks_23_times_in_the_last_4_weeks_0_0 = TensorMap('Frequency-of-heavy-DIY-in-last-4-weeks_23-times-in-the-last-4-weeks_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Frequency-of-heavy-DIY-in-last-4-weeks_23-times-in-the-last-4-weeks_0_0': 0, 'Frequency-of-heavy-DIY-in-last-4-weeks_23-times-in-the-last-4-weeks_0_0': 1})
program_category_category_1_cycle_rising_to_50_level_0_0 = TensorMap('Program-category_Category-1-cycle-rising-to-50-level_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Program-category_Category-1-cycle-rising-to-50-level_0_0': 0, 'Program-category_Category-1-cycle-rising-to-50-level_0_0': 1})
oily_fish_intake_never_0_0 = TensorMap('Oily-fish-intake_Never_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Oily-fish-intake_Never_0_0': 0, 'Oily-fish-intake_Never_0_0': 1})
hairbalding_pattern_pattern_3_0_0 = TensorMap('Hairbalding-pattern_Pattern-3_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Hairbalding-pattern_Pattern-3_0_0': 0, 'Hairbalding-pattern_Pattern-3_0_0': 1})
wears_glasses_or_contact_lenses_no_0_0 = TensorMap('Wears-glasses-or-contact-lenses_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Wears-glasses-or-contact-lenses_No_0_0': 0, 'Wears-glasses-or-contact-lenses_No_0_0': 1})
composite_mi_cad_stroke = TensorMap('composite_mi_cad_stroke', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_composite_mi_cad_stroke': 0, 'composite_mi_cad_stroke': 1})
ever_stopped_smoking_for_6_months_no_0_0 = TensorMap('Ever-stopped-smoking-for-6-months_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Ever-stopped-smoking-for-6-months_No_0_0': 0, 'Ever-stopped-smoking-for-6-months_No_0_0': 1})
beef_intake_24_times_a_week_0_0 = TensorMap('Beef-intake_24-times-a-week_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Beef-intake_24-times-a-week_0_0': 0, 'Beef-intake_24-times-a-week_0_0': 1})
composite_mi_cad_stroke_exclude_heme = TensorMap('composite_mi_cad_stroke_exclude_heme', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_composite_mi_cad_stroke_exclude_heme': 0, 'composite_mi_cad_stroke_exclude_heme': 1})
duration_of_light_diy_between_15_and_30_minutes_0_0 = TensorMap('Duration-of-light-DIY_Between-15-and-30-minutes_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Duration-of-light-DIY_Between-15-and-30-minutes_0_0': 0, 'Duration-of-light-DIY_Between-15-and-30-minutes_0_0': 1})
coronary_artery_disease_soft = TensorMap('coronary_artery_disease_soft', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_coronary_artery_disease_soft': 0, 'coronary_artery_disease_soft': 1})
mineral_and_other_dietary_supplements_glucosamine_0_1 = TensorMap('Mineral-and-other-dietary-supplements_Glucosamine_0_1', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Mineral-and-other-dietary-supplements_Glucosamine_0_1': 0, 'Mineral-and-other-dietary-supplements_Glucosamine_0_1': 1})
worked_with_materials_containing_asbestos_rarelynever_0_2 = TensorMap('Worked-with-materials-containing-asbestos_Rarelynever_0_2', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Worked-with-materials-containing-asbestos_Rarelynever_0_2': 0, 'Worked-with-materials-containing-asbestos_Rarelynever_0_2': 1})
alcohol_intake_frequency_special_occasions_only_0_0 = TensorMap('Alcohol-intake-frequency_Special-occasions-only_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Alcohol-intake-frequency_Special-occasions-only_0_0': 0, 'Alcohol-intake-frequency_Special-occasions-only_0_0': 1})
workplace_had_a_lot_of_cigarette_smoke_from_other_people_smoking_rarelynever_0_0 = TensorMap('Workplace-had-a-lot-of-cigarette-smoke-from-other-people-smoking_Rarelynever_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Workplace-had-a-lot-of-cigarette-smoke-from-other-people-smoking_Rarelynever_0_0': 0, 'Workplace-had-a-lot-of-cigarette-smoke-from-other-people-smoking_Rarelynever_0_0': 1})
why_stopped_smoking_health_precaution_0_0 = TensorMap('Why-stopped-smoking_Health-precaution_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Why-stopped-smoking_Health-precaution_0_0': 0, 'Why-stopped-smoking_Health-precaution_0_0': 1})
alcohol_intake_frequency_one_to_three_times_a_month_0_0 = TensorMap('Alcohol-intake-frequency_One-to-three-times-a-month_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Alcohol-intake-frequency_One-to-three-times-a-month_0_0': 0, 'Alcohol-intake-frequency_One-to-three-times-a-month_0_0': 1})
workplace_very_cold_rarelynever_0_1 = TensorMap('Workplace-very-cold_Rarelynever_0_1', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Workplace-very-cold_Rarelynever_0_1': 0, 'Workplace-very-cold_Rarelynever_0_1': 1})
smoking_status_current_0_0 = TensorMap('Smoking-status_Current_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Smoking-status_Current_0_0': 0, 'Smoking-status_Current_0_0': 1})
composite_mi_cad_stroke_death_exclude_anycancer = TensorMap('composite_mi_cad_stroke_death_exclude_anycancer', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_composite_mi_cad_stroke_death_exclude_anycancer': 0, 'composite_mi_cad_stroke_death_exclude_anycancer': 1})
duration_walking_for_pleasure_between_1_and_15_hours_0_0 = TensorMap('Duration-walking-for-pleasure_Between-1-and-15-hours_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Duration-walking-for-pleasure_Between-1-and-15-hours_0_0': 0, 'Duration-walking-for-pleasure_Between-1-and-15-hours_0_0': 1})
illnesses_of_father_none_of_the_above_group_2_0_2 = TensorMap('Illnesses-of-father_None-of-the-above-group-2_0_2', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Illnesses-of-father_None-of-the-above-group-2_0_2': 0, 'Illnesses-of-father_None-of-the-above-group-2_0_2': 1})
diverticular_disease = TensorMap('diverticular_disease', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_diverticular_disease': 0, 'diverticular_disease': 1})
workplace_had_a_lot_of_cigarette_smoke_from_other_people_smoking_rarelynever_0_1 = TensorMap('Workplace-had-a-lot-of-cigarette-smoke-from-other-people-smoking_Rarelynever_0_1', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Workplace-had-a-lot-of-cigarette-smoke-from-other-people-smoking_Rarelynever_0_1': 0, 'Workplace-had-a-lot-of-cigarette-smoke-from-other-people-smoking_Rarelynever_0_1': 1})
workplace_very_dusty_rarelynever_0_2 = TensorMap('Workplace-very-dusty_Rarelynever_0_2', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Workplace-very-dusty_Rarelynever_0_2': 0, 'Workplace-very-dusty_Rarelynever_0_2': 1})
poultry_intake_less_than_once_a_week_0_0 = TensorMap('Poultry-intake_Less-than-once-a-week_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Poultry-intake_Less-than-once-a-week_0_0': 0, 'Poultry-intake_Less-than-once-a-week_0_0': 1})
mouthteeth_dental_problems_bleeding_gums_0_0 = TensorMap('Mouthteeth-dental-problems_Bleeding-gums_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Mouthteeth-dental-problems_Bleeding-gums_0_0': 0, 'Mouthteeth-dental-problems_Bleeding-gums_0_0': 1})
headaches_for_3_months_no_0_0 = TensorMap('Headaches-for-3-months_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Headaches-for-3-months_No_0_0': 0, 'Headaches-for-3-months_No_0_0': 1})
beef_intake_never_0_0 = TensorMap('Beef-intake_Never_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Beef-intake_Never_0_0': 0, 'Beef-intake_Never_0_0': 1})
cataract = TensorMap('cataract', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_cataract': 0, 'cataract': 1})
blood_clot_dvt_bronchitis_emphysema_asthma_rhinitis_eczema_allergy_diagnosed_by_doctor_asthma_0_0 = TensorMap('Blood-clot-DVT-bronchitis-emphysema-asthma-rhinitis-eczema-allergy-diagnosed-by-doctor_Asthma_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Blood-clot-DVT-bronchitis-emphysema-asthma-rhinitis-eczema-allergy-diagnosed-by-doctor_Asthma_0_0': 0, 'Blood-clot-DVT-bronchitis-emphysema-asthma-rhinitis-eczema-allergy-diagnosed-by-doctor_Asthma_0_0': 1})
frequency_of_light_diy_in_last_4_weeks_once_a_week_0_0 = TensorMap('Frequency-of-light-DIY-in-last-4-weeks_Once-a-week_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Frequency-of-light-DIY-in-last-4-weeks_Once-a-week_0_0': 0, 'Frequency-of-light-DIY-in-last-4-weeks_Once-a-week_0_0': 1})
ever_had_breast_cancer_screening_mammogram_no_0_0 = TensorMap('Ever-had-breast-cancer-screening-mammogram_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Ever-had-breast-cancer-screening-mammogram_No_0_0': 0, 'Ever-had-breast-cancer-screening-mammogram_No_0_0': 1})
qualifications_a_levelsas_levels_or_equivalent_0_0 = TensorMap('Qualifications_A-levelsAS-levels-or-equivalent_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Qualifications_A-levelsAS-levels-or-equivalent_0_0': 0, 'Qualifications_A-levelsAS-levels-or-equivalent_0_0': 1})
spread_type_neverrarely_use_spread_0_0 = TensorMap('Spread-type_Neverrarely-use-spread_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Spread-type_Neverrarely-use-spread_0_0': 0, 'Spread-type_Neverrarely-use-spread_0_0': 1})
hair_colour_natural_before_greying_blonde_0_0 = TensorMap('Hair-colour-natural-before-greying_Blonde_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Hair-colour-natural-before-greying_Blonde_0_0': 0, 'Hair-colour-natural-before-greying_Blonde_0_0': 1})
illnesses_of_mother_none_of_the_above_group_1_0_1 = TensorMap('Illnesses-of-mother_None-of-the-above-group-1_0_1', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Illnesses-of-mother_None-of-the-above-group-1_0_1': 0, 'Illnesses-of-mother_None-of-the-above-group-1_0_1': 1})
illnesses_of_father_none_of_the_above_group_1_0_1 = TensorMap('Illnesses-of-father_None-of-the-above-group-1_0_1', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Illnesses-of-father_None-of-the-above-group-1_0_1': 0, 'Illnesses-of-father_None-of-the-above-group-1_0_1': 1})
coronary_artery_disease_intermediate = TensorMap('coronary_artery_disease_intermediate', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_coronary_artery_disease_intermediate': 0, 'coronary_artery_disease_intermediate': 1})
duration_of_other_exercises_between_1_and_15_hours_0_0 = TensorMap('Duration-of-other-exercises_Between-1-and-15-hours_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Duration-of-other-exercises_Between-1-and-15-hours_0_0': 0, 'Duration-of-other-exercises_Between-1-and-15-hours_0_0': 1})
operation_code_hysterectomy_0_0 = TensorMap('Operation-code_hysterectomy_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Operation-code_hysterectomy_0_0': 0, 'Operation-code_hysterectomy_0_0': 1})
work_hours_lumped_category_30_to_40_hours_0_0 = TensorMap('Work-hours-lumped-category_30-to-40-hours_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Work-hours-lumped-category_30-to-40-hours_0_0': 0, 'Work-hours-lumped-category_30-to-40-hours_0_0': 1})
frequency_of_heavy_diy_in_last_4_weeks_once_a_week_0_0 = TensorMap('Frequency-of-heavy-DIY-in-last-4-weeks_Once-a-week_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Frequency-of-heavy-DIY-in-last-4-weeks_Once-a-week_0_0': 0, 'Frequency-of-heavy-DIY-in-last-4-weeks_Once-a-week_0_0': 1})
types_of_physical_activity_in_last_4_weeks_heavy_diy_eg_weeding_lawn_mowing_carpentry_digging_0_3 = TensorMap('Types-of-physical-activity-in-last-4-weeks_Heavy-DIY-eg-weeding-lawn-mowing-carpentry-digging_0_3', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Types-of-physical-activity-in-last-4-weeks_Heavy-DIY-eg-weeding-lawn-mowing-carpentry-digging_0_3': 0, 'Types-of-physical-activity-in-last-4-weeks_Heavy-DIY-eg-weeding-lawn-mowing-carpentry-digging_0_3': 1})
treatmentmedication_code_aspirin_0_0 = TensorMap('Treatmentmedication-code_aspirin_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Treatmentmedication-code_aspirin_0_0': 0, 'Treatmentmedication-code_aspirin_0_0': 1})
medication_for_cholesterol_blood_pressure_or_diabetes_cholesterol_lowering_medication_0_0 = TensorMap('Medication-for-cholesterol-blood-pressure-or-diabetes_Cholesterol-lowering-medication_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Medication-for-cholesterol-blood-pressure-or-diabetes_Cholesterol-lowering-medication_0_0': 0, 'Medication-for-cholesterol-blood-pressure-or-diabetes_Cholesterol-lowering-medication_0_0': 1})
fracturedbroken_bones_in_last_5_years_yes_0_0 = TensorMap('Fracturedbroken-bones-in-last-5-years_Yes_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Fracturedbroken-bones-in-last-5-years_Yes_0_0': 0, 'Fracturedbroken-bones-in-last-5-years_Yes_0_0': 1})
composite_mi_death = TensorMap('composite_mi_death', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_composite_mi_death': 0, 'composite_mi_death': 1})
duration_of_heavy_diy_between_30_minutes_and_1_hour_0_0 = TensorMap('Duration-of-heavy-DIY_Between-30-minutes-and-1-hour_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Duration-of-heavy-DIY_Between-30-minutes-and-1-hour_0_0': 0, 'Duration-of-heavy-DIY_Between-30-minutes-and-1-hour_0_0': 1})
use_of_sunuv_protection_neverrarely_0_0 = TensorMap('Use-of-sunuv-protection_Neverrarely_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Use-of-sunuv-protection_Neverrarely_0_0': 0, 'Use-of-sunuv-protection_Neverrarely_0_0': 1})
hairbalding_pattern_pattern_2_0_0 = TensorMap('Hairbalding-pattern_Pattern-2_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Hairbalding-pattern_Pattern-2_0_0': 0, 'Hairbalding-pattern_Pattern-2_0_0': 1})
composite_af_chf_dcm_death = TensorMap('composite_af_chf_dcm_death', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_composite_af_chf_dcm_death': 0, 'composite_af_chf_dcm_death': 1})
workplace_very_hot_rarelynever_0_1 = TensorMap('Workplace-very-hot_Rarelynever_0_1', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Workplace-very-hot_Rarelynever_0_1': 0, 'Workplace-very-hot_Rarelynever_0_1': 1})
average_total_household_income_before_tax_prefer_not_to_answer_0_0 = TensorMap('Average-total-household-income-before-tax_Prefer-not-to-answer_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Average-total-household-income-before-tax_Prefer-not-to-answer_0_0': 0, 'Average-total-household-income-before-tax_Prefer-not-to-answer_0_0': 1})
types_of_transport_used_excluding_work_public_transport_0_1 = TensorMap('Types-of-transport-used-excluding-work_Public-transport_0_1', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Types-of-transport-used-excluding-work_Public-transport_0_1': 0, 'Types-of-transport-used-excluding-work_Public-transport_0_1': 1})
workplace_very_noisy_rarelynever_0_1 = TensorMap('Workplace-very-noisy_Rarelynever_0_1', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Workplace-very-noisy_Rarelynever_0_1': 0, 'Workplace-very-noisy_Rarelynever_0_1': 1})
pain_types_experienced_in_last_month_back_pain_0_1 = TensorMap('Pain-types-experienced-in-last-month_Back-pain_0_1', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Pain-types-experienced-in-last-month_Back-pain_0_1': 0, 'Pain-types-experienced-in-last-month_Back-pain_0_1': 1})
ever_taken_oral_contraceptive_pill_no_0_0 = TensorMap('Ever-taken-oral-contraceptive-pill_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Ever-taken-oral-contraceptive-pill_No_0_0': 0, 'Ever-taken-oral-contraceptive-pill_No_0_0': 1})
ever_stopped_smoking_for_6_months_yes_0_0 = TensorMap('Ever-stopped-smoking-for-6-months_Yes_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Ever-stopped-smoking-for-6-months_Yes_0_0': 0, 'Ever-stopped-smoking-for-6-months_Yes_0_0': 1})
believed_safe_to_perform_dxa_scan_yes_2_0 = TensorMap('Believed-safe-to-perform-DXA-scan_Yes_2_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Believed-safe-to-perform-DXA-scan_Yes_2_0': 0, 'Believed-safe-to-perform-DXA-scan_Yes_2_0': 1})
cochlear_implant_no_2_0 = TensorMap('Cochlear-implant_No_2_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Cochlear-implant_No_2_0': 0, 'Cochlear-implant_No_2_0': 1})
workplace_had_a_lot_of_cigarette_smoke_from_other_people_smoking_rarelynever_0_2 = TensorMap('Workplace-had-a-lot-of-cigarette-smoke-from-other-people-smoking_Rarelynever_0_2', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Workplace-had-a-lot-of-cigarette-smoke-from-other-people-smoking_Rarelynever_0_2': 0, 'Workplace-had-a-lot-of-cigarette-smoke-from-other-people-smoking_Rarelynever_0_2': 1})
nonaccidental_death_in_close_genetic_family_yes_0_0 = TensorMap('Nonaccidental-death-in-close-genetic-family_Yes_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Nonaccidental-death-in-close-genetic-family_Yes_0_0': 0, 'Nonaccidental-death-in-close-genetic-family_Yes_0_0': 1})
types_of_physical_activity_in_last_4_weeks_heavy_diy_eg_weeding_lawn_mowing_carpentry_digging_0_1 = TensorMap('Types-of-physical-activity-in-last-4-weeks_Heavy-DIY-eg-weeding-lawn-mowing-carpentry-digging_0_1', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Types-of-physical-activity-in-last-4-weeks_Heavy-DIY-eg-weeding-lawn-mowing-carpentry-digging_0_1': 0, 'Types-of-physical-activity-in-last-4-weeks_Heavy-DIY-eg-weeding-lawn-mowing-carpentry-digging_0_1': 1})
frequency_of_other_exercises_in_last_4_weeks_once_a_week_0_0 = TensorMap('Frequency-of-other-exercises-in-last-4-weeks_Once-a-week_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Frequency-of-other-exercises-in-last-4-weeks_Once-a-week_0_0': 0, 'Frequency-of-other-exercises-in-last-4-weeks_Once-a-week_0_0': 1})
adopted_as_a_child_no_2_0 = TensorMap('Adopted-as-a-child_No_2_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Adopted-as-a-child_No_2_0': 0, 'Adopted-as-a-child_No_2_0': 1})
volume_level_set_by_participant_right_20_0_0 = TensorMap('Volume-level-set-by-participant-right_20_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Volume-level-set-by-participant-right_20_0_0': 0, 'Volume-level-set-by-participant-right_20_0_0': 1})
hearing_test_done_yes_2_0 = TensorMap('Hearing-test-done_Yes_2_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Hearing-test-done_Yes_2_0': 0, 'Hearing-test-done_Yes_2_0': 1})
believed_safe_to_perform_brain_mri_scan_yes_2_0 = TensorMap('Believed-safe-to-perform-brain-MRI-scan_Yes_2_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Believed-safe-to-perform-brain-MRI-scan_Yes_2_0': 0, 'Believed-safe-to-perform-brain-MRI-scan_Yes_2_0': 1})
believed_safe_to_perform_abdominal_mri_scan_yes_2_0 = TensorMap('Believed-safe-to-perform-abdominal-MRI-scan_Yes_2_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Believed-safe-to-perform-abdominal-MRI-scan_Yes_2_0': 0, 'Believed-safe-to-perform-abdominal-MRI-scan_Yes_2_0': 1})
volume_level_set_by_participant_left_20_0_0 = TensorMap('Volume-level-set-by-participant-left_20_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Volume-level-set-by-participant-left_20_0_0': 0, 'Volume-level-set-by-participant-left_20_0_0': 1})
current_tobacco_smoking_no_2_0 = TensorMap('Current-tobacco-smoking_No_2_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Current-tobacco-smoking_No_2_0': 0, 'Current-tobacco-smoking_No_2_0': 1})
processed_meat_intake_never_0_0 = TensorMap('Processed-meat-intake_Never_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Processed-meat-intake_Never_0_0': 0, 'Processed-meat-intake_Never_0_0': 1})
illnesses_of_father_heart_disease_0_1 = TensorMap('Illnesses-of-father_Heart-disease_0_1', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Illnesses-of-father_Heart-disease_0_1': 0, 'Illnesses-of-father_Heart-disease_0_1': 1})
major_dietary_changes_in_the_last_5_years_yes_because_of_illness_0_0 = TensorMap('Major-dietary-changes-in-the-last-5-years_Yes-because-of-illness_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Major-dietary-changes-in-the-last-5-years_Yes-because-of-illness_0_0': 0, 'Major-dietary-changes-in-the-last-5-years_Yes-because-of-illness_0_0': 1})
pacemaker_no_2_0 = TensorMap('Pacemaker_No_2_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Pacemaker_No_2_0': 0, 'Pacemaker_No_2_0': 1})
workplace_very_cold_rarelynever_0_2 = TensorMap('Workplace-very-cold_Rarelynever_0_2', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Workplace-very-cold_Rarelynever_0_2': 0, 'Workplace-very-cold_Rarelynever_0_2': 1})
hair_colour_natural_before_greying_black_0_0 = TensorMap('Hair-colour-natural-before-greying_Black_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Hair-colour-natural-before-greying_Black_0_0': 0, 'Hair-colour-natural-before-greying_Black_0_0': 1})
brain_mri_measuring_method_direct_entry_2_0 = TensorMap('Brain-MRI-measuring-method_Direct-entry_2_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Brain-MRI-measuring-method_Direct-entry_2_0': 0, 'Brain-MRI-measuring-method_Direct-entry_2_0': 1})
abdominal_mri_measuring_method_direct_entry_2_0 = TensorMap('Abdominal-MRI-measuring-method_Direct-entry_2_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Abdominal-MRI-measuring-method_Direct-entry_2_0': 0, 'Abdominal-MRI-measuring-method_Direct-entry_2_0': 1})
dxa_measuring_method_direct_entry_2_0 = TensorMap('DXA-measuring-method_Direct-entry_2_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_DXA-measuring-method_Direct-entry_2_0': 0, 'DXA-measuring-method_Direct-entry_2_0': 1})
handedness_chiralitylaterality_lefthanded_0_0 = TensorMap('Handedness-chiralitylaterality_Lefthanded_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Handedness-chiralitylaterality_Lefthanded_0_0': 0, 'Handedness-chiralitylaterality_Lefthanded_0_0': 1})
completion_status_of_numeric_memory_test_stopped_0_0 = TensorMap('Completion-status-of-numeric-memory-test_stopped_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Completion-status-of-numeric-memory-test_stopped_0_0': 0, 'Completion-status-of-numeric-memory-test_stopped_0_0': 1})
drive_faster_than_motorway_speed_limit_often_0_0 = TensorMap('Drive-faster-than-motorway-speed-limit_Often_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Drive-faster-than-motorway-speed-limit_Often_0_0': 0, 'Drive-faster-than-motorway-speed-limit_Often_0_0': 1})
completion_status_left_completed_2_0 = TensorMap('Completion-status-left_completed_2_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Completion-status-left_completed_2_0': 0, 'Completion-status-left_completed_2_0': 1})
chest_pain_or_discomfort_when_walking_uphill_or_hurrying_no_0_0 = TensorMap('Chest-pain-or-discomfort-when-walking-uphill-or-hurrying_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Chest-pain-or-discomfort-when-walking-uphill-or-hurrying_No_0_0': 0, 'Chest-pain-or-discomfort-when-walking-uphill-or-hurrying_No_0_0': 1})
completion_status_right_completed_2_0 = TensorMap('Completion-status-right_completed_2_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Completion-status-right_completed_2_0': 0, 'Completion-status-right_completed_2_0': 1})
type_of_accommodation_lived_in_a_house_or_bungalow_2_0 = TensorMap('Type-of-accommodation-lived-in_A-house-or-bungalow_2_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Type-of-accommodation-lived-in_A-house-or-bungalow_2_0': 0, 'Type-of-accommodation-lived-in_A-house-or-bungalow_2_0': 1})
diabetes_diagnosed_by_doctor_no_2_0 = TensorMap('Diabetes-diagnosed-by-doctor_No_2_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Diabetes-diagnosed-by-doctor_No_2_0': 0, 'Diabetes-diagnosed-by-doctor_No_2_0': 1})
headaches_for_3_months_yes_0_0 = TensorMap('Headaches-for-3-months_Yes_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Headaches-for-3-months_Yes_0_0': 0, 'Headaches-for-3-months_Yes_0_0': 1})
qualifications_o_levelsgcses_or_equivalent_0_1 = TensorMap('Qualifications_O-levelsGCSEs-or-equivalent_0_1', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Qualifications_O-levelsGCSEs-or-equivalent_0_1': 0, 'Qualifications_O-levelsGCSEs-or-equivalent_0_1': 1})
digits_entered_correctly_yes_0_1 = TensorMap('Digits-entered-correctly_yes_0_1', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Digits-entered-correctly_yes_0_1': 0, 'Digits-entered-correctly_yes_0_1': 1})
reason_for_glassescontact_lenses_for_shortsightedness_ie_only_or_mainly_for_distance_viewing_such_as_driving_cinema_etc_called_myopia_0_0 = TensorMap('Reason-for-glassescontact-lenses_For-shortsightedness-ie-only-or-mainly-for-distance-viewing-such-as-driving-cinema-etc-called-myopia_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Reason-for-glassescontact-lenses_For-shortsightedness-ie-only-or-mainly-for-distance-viewing-such-as-driving-cinema-etc-called-myopia_0_0': 0, 'Reason-for-glassescontact-lenses_For-shortsightedness-ie-only-or-mainly-for-distance-viewing-such-as-driving-cinema-etc-called-myopia_0_0': 1})
wears_glasses_or_contact_lenses_yes_2_0 = TensorMap('Wears-glasses-or-contact-lenses_Yes_2_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Wears-glasses-or-contact-lenses_Yes_2_0': 0, 'Wears-glasses-or-contact-lenses_Yes_2_0': 1})
type_of_accommodation_lived_in_a_flat_maisonette_or_apartment_0_0 = TensorMap('Type-of-accommodation-lived-in_A-flat-maisonette-or-apartment_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Type-of-accommodation-lived-in_A-flat-maisonette-or-apartment_0_0': 0, 'Type-of-accommodation-lived-in_A-flat-maisonette-or-apartment_0_0': 1})
workplace_had_a_lot_of_cigarette_smoke_from_other_people_smoking_sometimes_0_0 = TensorMap('Workplace-had-a-lot-of-cigarette-smoke-from-other-people-smoking_Sometimes_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Workplace-had-a-lot-of-cigarette-smoke-from-other-people-smoking_Sometimes_0_0': 0, 'Workplace-had-a-lot-of-cigarette-smoke-from-other-people-smoking_Sometimes_0_0': 1})
test_completion_status_complete_2_0 = TensorMap('Test-completion-status_complete_2_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Test-completion-status_complete_2_0': 0, 'Test-completion-status_complete_2_0': 1})
smoked_cigarette_or_pipe_within_last_hour_no_0_0 = TensorMap('Smoked-cigarette-or-pipe-within-last-hour_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Smoked-cigarette-or-pipe-within-last-hour_No_0_0': 0, 'Smoked-cigarette-or-pipe-within-last-hour_No_0_0': 1})
hearing_aid_user_no_2_0 = TensorMap('Hearing-aid-user_No_2_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Hearing-aid-user_No_2_0': 0, 'Hearing-aid-user_No_2_0': 1})
workplace_very_hot_sometimes_0_0 = TensorMap('Workplace-very-hot_Sometimes_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Workplace-very-hot_Sometimes_0_0': 0, 'Workplace-very-hot_Sometimes_0_0': 1})
alcohol_drinker_status_current_2_0 = TensorMap('Alcohol-drinker-status_Current_2_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Alcohol-drinker-status_Current_2_0': 0, 'Alcohol-drinker-status_Current_2_0': 1})
facial_ageing_do_not_know_0_0 = TensorMap('Facial-ageing_Do-not-know_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Facial-ageing_Do-not-know_0_0': 0, 'Facial-ageing_Do-not-know_0_0': 1})
chest_pain_or_discomfort_no_2_0 = TensorMap('Chest-pain-or-discomfort_No_2_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Chest-pain-or-discomfort_No_2_0': 0, 'Chest-pain-or-discomfort_No_2_0': 1})
attempted_fluid_intelligence_fi_test_begin_puzzles_2_0 = TensorMap('Attempted-fluid-intelligence-FI-test_Begin-puzzles_2_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Attempted-fluid-intelligence-FI-test_Begin-puzzles_2_0': 0, 'Attempted-fluid-intelligence-FI-test_Begin-puzzles_2_0': 1})
breathing_problems_during_period_of_job_no_0_3 = TensorMap('Breathing-problems-during-period-of-job_No_0_3', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Breathing-problems-during-period-of-job_No_0_3': 0, 'Breathing-problems-during-period-of-job_No_0_3': 1})
medication_for_pain_relief_constipation_heartburn_paracetamol_0_1 = TensorMap('Medication-for-pain-relief-constipation-heartburn_Paracetamol_0_1', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Medication-for-pain-relief-constipation-heartburn_Paracetamol_0_1': 0, 'Medication-for-pain-relief-constipation-heartburn_Paracetamol_0_1': 1})
smokingsmokers_in_household_no_2_0 = TensorMap('Smokingsmokers-in-household_No_2_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Smokingsmokers-in-household_No_2_0': 0, 'Smokingsmokers-in-household_No_2_0': 1})
shortness_of_breath_walking_on_level_ground_no_2_0 = TensorMap('Shortness-of-breath-walking-on-level-ground_No_2_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Shortness-of-breath-walking-on-level-ground_No_2_0': 0, 'Shortness-of-breath-walking-on-level-ground_No_2_0': 1})
depression = TensorMap('depression', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_depression': 0, 'depression': 1})
worked_with_pesticides_rarelynever_0_3 = TensorMap('Worked-with-pesticides_Rarelynever_0_3', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Worked-with-pesticides_Rarelynever_0_3': 0, 'Worked-with-pesticides_Rarelynever_0_3': 1})
digits_entered_correctly_yes_0_0 = TensorMap('Digits-entered-correctly_yes_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Digits-entered-correctly_yes_0_0': 0, 'Digits-entered-correctly_yes_0_0': 1})
triplet_correct_right_yes_2_1 = TensorMap('Triplet-correct-right_yes_2_1', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Triplet-correct-right_yes_2_1': 0, 'Triplet-correct-right_yes_2_1': 1})
frequency_of_other_exercises_in_last_4_weeks_23_times_in_the_last_4_weeks_0_0 = TensorMap('Frequency-of-other-exercises-in-last-4-weeks_23-times-in-the-last-4-weeks_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Frequency-of-other-exercises-in-last-4-weeks_23-times-in-the-last-4-weeks_0_0': 0, 'Frequency-of-other-exercises-in-last-4-weeks_23-times-in-the-last-4-weeks_0_0': 1})
pm_final_answer_orange_circle_2_0 = TensorMap('PM-final-answer_Orange-circle_2_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_PM-final-answer_Orange-circle_2_0': 0, 'PM-final-answer_Orange-circle_2_0': 1})
final_attempt_correct_yes_2_0 = TensorMap('Final-attempt-correct_yes_2_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Final-attempt-correct_yes_2_0': 0, 'Final-attempt-correct_yes_2_0': 1})
dxa_measurement_completed_yes_2_0 = TensorMap('DXA-measurement-completed_Yes_2_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_DXA-measurement-completed_Yes_2_0': 0, 'DXA-measurement-completed_Yes_2_0': 1})
workplace_very_hot_rarelynever_0_2 = TensorMap('Workplace-very-hot_Rarelynever_0_2', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Workplace-very-hot_Rarelynever_0_2': 0, 'Workplace-very-hot_Rarelynever_0_2': 1})
digits_entered_correctly_yes_0_2 = TensorMap('Digits-entered-correctly_yes_0_2', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Digits-entered-correctly_yes_0_2': 0, 'Digits-entered-correctly_yes_0_2': 1})
loud_music_exposure_frequency_no_2_0 = TensorMap('Loud-music-exposure-frequency_No_2_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Loud-music-exposure-frequency_No_2_0': 0, 'Loud-music-exposure-frequency_No_2_0': 1})
fracturedbroken_bones_in_last_5_years_no_2_0 = TensorMap('Fracturedbroken-bones-in-last-5-years_No_2_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Fracturedbroken-bones-in-last-5-years_No_2_0': 0, 'Fracturedbroken-bones-in-last-5-years_No_2_0': 1})
qualifications_other_professional_qualifications_eg_nursing_teaching_0_3 = TensorMap('Qualifications_Other-professional-qualifications-eg-nursing-teaching_0_3', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Qualifications_Other-professional-qualifications-eg-nursing-teaching_0_3': 0, 'Qualifications_Other-professional-qualifications-eg-nursing-teaching_0_3': 1})
contraindications_for_spirometry_no_2_0 = TensorMap('Contraindications-for-spirometry_No_2_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Contraindications-for-spirometry_No_2_0': 0, 'Contraindications-for-spirometry_No_2_0': 1})
frequency_of_heavy_diy_in_last_4_weeks_once_in_the_last_4_weeks_0_0 = TensorMap('Frequency-of-heavy-DIY-in-last-4-weeks_Once-in-the-last-4-weeks_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Frequency-of-heavy-DIY-in-last-4-weeks_Once-in-the-last-4-weeks_0_0': 0, 'Frequency-of-heavy-DIY-in-last-4-weeks_Once-in-the-last-4-weeks_0_0': 1})
workplace_very_noisy_rarelynever_0_2 = TensorMap('Workplace-very-noisy_Rarelynever_0_2', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Workplace-very-noisy_Rarelynever_0_2': 0, 'Workplace-very-noisy_Rarelynever_0_2': 1})
used_an_inhaler_for_chest_within_last_hour_no_2_0 = TensorMap('Used-an-inhaler-for-chest-within-last-hour_No_2_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Used-an-inhaler-for-chest-within-last-hour_No_2_0': 0, 'Used-an-inhaler-for-chest-within-last-hour_No_2_0': 1})
triplet_correct_left_yes_2_1 = TensorMap('Triplet-correct-left_yes_2_1', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Triplet-correct-left_yes_2_1': 0, 'Triplet-correct-left_yes_2_1': 1})
frequency_of_walking_for_pleasure_in_last_4_weeks_every_day_0_0 = TensorMap('Frequency-of-walking-for-pleasure-in-last-4-weeks_Every-day_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Frequency-of-walking-for-pleasure-in-last-4-weeks_Every-day_0_0': 0, 'Frequency-of-walking-for-pleasure-in-last-4-weeks_Every-day_0_0': 1})
fi1_numeric_addition_test_15_2_0 = TensorMap('FI1-numeric-addition-test_15_2_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_FI1-numeric-addition-test_15_2_0': 0, 'FI1-numeric-addition-test_15_2_0': 1})
hip_pain_for_3_months_yes_0_0 = TensorMap('Hip-pain-for-3-months_Yes_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Hip-pain-for-3-months_Yes_0_0': 0, 'Hip-pain-for-3-months_Yes_0_0': 1})
workplace_had_a_lot_of_diesel_exhaust_rarelynever_0_3 = TensorMap('Workplace-had-a-lot-of-diesel-exhaust_Rarelynever_0_3', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Workplace-had-a-lot-of-diesel-exhaust_Rarelynever_0_3': 0, 'Workplace-had-a-lot-of-diesel-exhaust_Rarelynever_0_3': 1})
job_involved_shift_work_no_0_3 = TensorMap('Job-involved-shift-work_No_0_3', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Job-involved-shift-work_No_0_3': 0, 'Job-involved-shift-work_No_0_3': 1})
mouthteeth_dental_problems_mouth_ulcers_0_0 = TensorMap('Mouthteeth-dental-problems_Mouth-ulcers_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Mouthteeth-dental-problems_Mouth-ulcers_0_0': 0, 'Mouthteeth-dental-problems_Mouth-ulcers_0_0': 1})
hairbalding_pattern_pattern_4_0_0 = TensorMap('Hairbalding-pattern_Pattern-4_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Hairbalding-pattern_Pattern-4_0_0': 0, 'Hairbalding-pattern_Pattern-4_0_0': 1})
illnesses_of_mother_diabetes_0_0 = TensorMap('Illnesses-of-mother_Diabetes_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Illnesses-of-mother_Diabetes_0_0': 0, 'Illnesses-of-mother_Diabetes_0_0': 1})
result_ranking_second_best_2_1 = TensorMap('Result-ranking_second-best_2_1', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Result-ranking_second-best_2_1': 0, 'Result-ranking_second-best_2_1': 1})
result_ranking_best_2_0 = TensorMap('Result-ranking_best_2_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Result-ranking_best_2_0': 0, 'Result-ranking_best_2_0': 1})
worked_with_paints_thinners_or_glues_rarelynever_0_3 = TensorMap('Worked-with-paints-thinners-or-glues_Rarelynever_0_3', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Worked-with-paints-thinners-or-glues_Rarelynever_0_3': 0, 'Worked-with-paints-thinners-or-glues_Rarelynever_0_3': 1})
cancer_diagnosed_by_doctor_no_2_0 = TensorMap('Cancer-diagnosed-by-doctor_No_2_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Cancer-diagnosed-by-doctor_No_2_0': 0, 'Cancer-diagnosed-by-doctor_No_2_0': 1})
glasses_wornrequired_right_wearing_0_0 = TensorMap('Glasses-wornrequired-right_wearing_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Glasses-wornrequired-right_wearing_0_0': 0, 'Glasses-wornrequired-right_wearing_0_0': 1})
glasses_wornrequired_left_wearing_0_0 = TensorMap('Glasses-wornrequired-left_wearing_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Glasses-wornrequired-left_wearing_0_0': 0, 'Glasses-wornrequired-left_wearing_0_0': 1})
father_still_alive_no_2_0 = TensorMap('Father-still-alive_No_2_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Father-still-alive_No_2_0': 0, 'Father-still-alive_No_2_0': 1})
other_serious_medical_conditiondisability_diagnosed_by_doctor_no_2_0 = TensorMap('Other-serious-medical-conditiondisability-diagnosed-by-doctor_No_2_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Other-serious-medical-conditiondisability-diagnosed-by-doctor_No_2_0': 0, 'Other-serious-medical-conditiondisability-diagnosed-by-doctor_No_2_0': 1})
smokingsmokers_in_household_yes_one_household_member_smokes_0_0 = TensorMap('Smokingsmokers-in-household_Yes-one-household-member-smokes_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Smokingsmokers-in-household_Yes-one-household-member-smokes_0_0': 0, 'Smokingsmokers-in-household_Yes-one-household-member-smokes_0_0': 1})
frequency_of_stair_climbing_in_last_4_weeks_1620_times_a_day_0_0 = TensorMap('Frequency-of-stair-climbing-in-last-4-weeks_1620-times-a-day_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Frequency-of-stair-climbing-in-last-4-weeks_1620-times-a-day_0_0': 0, 'Frequency-of-stair-climbing-in-last-4-weeks_1620-times-a-day_0_0': 1})
stiffness_method_direct_entry_2_0 = TensorMap('Stiffness-method_Direct-entry_2_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Stiffness-method_Direct-entry_2_0': 0, 'Stiffness-method_Direct-entry_2_0': 1})
workplace_very_noisy_sometimes_0_0 = TensorMap('Workplace-very-noisy_Sometimes_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Workplace-very-noisy_Sometimes_0_0': 0, 'Workplace-very-noisy_Sometimes_0_0': 1})
frequency_of_stair_climbing_in_last_4_weeks_none_0_0 = TensorMap('Frequency-of-stair-climbing-in-last-4-weeks_None_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Frequency-of-stair-climbing-in-last-4-weeks_None_0_0': 0, 'Frequency-of-stair-climbing-in-last-4-weeks_None_0_0': 1})
duration_of_other_exercises_between_15_and_30_minutes_0_0 = TensorMap('Duration-of-other-exercises_Between-15-and-30-minutes_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Duration-of-other-exercises_Between-15-and-30-minutes_0_0': 0, 'Duration-of-other-exercises_Between-15-and-30-minutes_0_0': 1})
which_eyes_affected_by_myopia_short_sight_both_eyes_0_0 = TensorMap('Which-eyes-affected-by-myopia-short-sight_Both-eyes_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Which-eyes-affected-by-myopia-short-sight_Both-eyes_0_0': 0, 'Which-eyes-affected-by-myopia-short-sight_Both-eyes_0_0': 1})
operator_indicated_brain_mri_measurement_completed_yes_2_0 = TensorMap('Operator-indicated-brain-MRI-measurement-completed_yes_2_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Operator-indicated-brain-MRI-measurement-completed_yes_2_0': 0, 'Operator-indicated-brain-MRI-measurement-completed_yes_2_0': 1})
digits_entered_correctly_yes_0_3 = TensorMap('Digits-entered-correctly_yes_0_3', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Digits-entered-correctly_yes_0_3': 0, 'Digits-entered-correctly_yes_0_3': 1})
leg_pain_on_walking_no_2_0 = TensorMap('Leg-pain-on-walking_No_2_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Leg-pain-on-walking_No_2_0': 0, 'Leg-pain-on-walking_No_2_0': 1})
worked_with_materials_containing_asbestos_rarelynever_0_3 = TensorMap('Worked-with-materials-containing-asbestos_Rarelynever_0_3', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Worked-with-materials-containing-asbestos_Rarelynever_0_3': 0, 'Worked-with-materials-containing-asbestos_Rarelynever_0_3': 1})
nonbutter_spread_type_details_flora_proactive_or_benecol_0_0 = TensorMap('Nonbutter-spread-type-details_Flora-ProActive-or-Benecol_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Nonbutter-spread-type-details_Flora-ProActive-or-Benecol_0_0': 0, 'Nonbutter-spread-type-details_Flora-ProActive-or-Benecol_0_0': 1})
noisy_workplace_no_2_0 = TensorMap('Noisy-workplace_No_2_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Noisy-workplace_No_2_0': 0, 'Noisy-workplace_No_2_0': 1})
falls_in_the_last_year_no_falls_2_0 = TensorMap('Falls-in-the-last-year_No-falls_2_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Falls-in-the-last-year_No-falls_2_0': 0, 'Falls-in-the-last-year_No-falls_2_0': 1})
workplace_full_of_chemical_or_other_fumes_rarelynever_0_3 = TensorMap('Workplace-full-of-chemical-or-other-fumes_Rarelynever_0_3', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Workplace-full-of-chemical-or-other-fumes_Rarelynever_0_3': 0, 'Workplace-full-of-chemical-or-other-fumes_Rarelynever_0_3': 1})
operation_code_tonsillectomy_adenoids_0_0 = TensorMap('Operation-code_tonsillectomy-adenoids_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Operation-code_tonsillectomy-adenoids_0_0': 0, 'Operation-code_tonsillectomy-adenoids_0_0': 1})
eye_problemsdisorders_none_of_the_above_2_0 = TensorMap('Eye-problemsdisorders_None-of-the-above_2_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Eye-problemsdisorders_None-of-the-above_2_0': 0, 'Eye-problemsdisorders_None-of-the-above_2_0': 1})
composite_cad_dcm_hcm_hf_mi = TensorMap('composite_cad_dcm_hcm_hf_mi', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_composite_cad_dcm_hcm_hf_mi': 0, 'composite_cad_dcm_hcm_hf_mi': 1})
pain_types_experienced_in_last_month_neck_or_shoulder_pain_0_1 = TensorMap('Pain-types-experienced-in-last-month_Neck-or-shoulder-pain_0_1', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Pain-types-experienced-in-last-month_Neck-or-shoulder-pain_0_1': 0, 'Pain-types-experienced-in-last-month_Neck-or-shoulder-pain_0_1': 1})
other_eye_problems_no_2_0 = TensorMap('Other-eye-problems_No_2_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Other-eye-problems_No_2_0': 0, 'Other-eye-problems_No_2_0': 1})
cheese_intake_56_times_a_week_0_0 = TensorMap('Cheese-intake_56-times-a-week_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Cheese-intake_56-times-a-week_0_0': 0, 'Cheese-intake_56-times-a-week_0_0': 1})
country_of_birth_ukelsewhere_elsewhere_0_0 = TensorMap('Country-of-birth-UKelsewhere_Elsewhere_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Country-of-birth-UKelsewhere_Elsewhere_0_0': 0, 'Country-of-birth-UKelsewhere_Elsewhere_0_0': 1})
current_tobacco_smoking_yes_on_most_or_all_days_0_0 = TensorMap('Current-tobacco-smoking_Yes-on-most-or-all-days_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Current-tobacco-smoking_Yes-on-most-or-all-days_0_0': 0, 'Current-tobacco-smoking_Yes-on-most-or-all-days_0_0': 1})
country_of_birth_ukelsewhere_scotland_0_0 = TensorMap('Country-of-birth-UKelsewhere_Scotland_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Country-of-birth-UKelsewhere_Scotland_0_0': 0, 'Country-of-birth-UKelsewhere_Scotland_0_0': 1})
vicorder_results_plausible_yes_2_0 = TensorMap('Vicorder-results-plausible_Yes_2_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Vicorder-results-plausible_Yes_2_0': 0, 'Vicorder-results-plausible_Yes_2_0': 1})
duration_of_light_diy_between_1_and_15_hours_0_0 = TensorMap('Duration-of-light-DIY_Between-1-and-15-hours_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Duration-of-light-DIY_Between-1-and-15-hours_0_0': 0, 'Duration-of-light-DIY_Between-1-and-15-hours_0_0': 1})
abdominal_mri_measurement_completed_yes_2_0 = TensorMap('Abdominal-MRI-measurement-completed_Yes_2_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Abdominal-MRI-measurement-completed_Yes_2_0': 0, 'Abdominal-MRI-measurement-completed_Yes_2_0': 1})
leg_pain_on_walking_yes_0_0 = TensorMap('Leg-pain-on-walking_Yes_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Leg-pain-on-walking_Yes_0_0': 0, 'Leg-pain-on-walking_Yes_0_0': 1})
prospective_memory_result_correct_recall_on_first_attempt_2_0 = TensorMap('Prospective-memory-result_Correct-recall-on-first-attempt_2_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Prospective-memory-result_Correct-recall-on-first-attempt_2_0': 0, 'Prospective-memory-result_Correct-recall-on-first-attempt_2_0': 1})
pm_initial_answer_orange_circle_2_0 = TensorMap('PM-initial-answer_Orange-circle_2_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_PM-initial-answer_Orange-circle_2_0': 0, 'PM-initial-answer_Orange-circle_2_0': 1})
variation_in_diet_often_0_0 = TensorMap('Variation-in-diet_Often_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Variation-in-diet_Often_0_0': 0, 'Variation-in-diet_Often_0_0': 1})
which_eyes_affected_by_presbyopia_both_eyes_0_0 = TensorMap('Which-eyes-affected-by-presbyopia_Both-eyes_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Which-eyes-affected-by-presbyopia_Both-eyes_0_0': 0, 'Which-eyes-affected-by-presbyopia_Both-eyes_0_0': 1})
fi4_positional_arithmetic_6_2_0 = TensorMap('FI4-positional-arithmetic_6_2_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_FI4-positional-arithmetic_6_2_0': 0, 'FI4-positional-arithmetic_6_2_0': 1})
cancer_diagnosed_by_doctor_yes_you_will_be_asked_about_this_later_by_an_interviewer_0_0 = TensorMap('Cancer-diagnosed-by-doctor_Yes-you-will-be-asked-about-this-later-by-an-interviewer_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Cancer-diagnosed-by-doctor_Yes-you-will-be-asked-about-this-later-by-an-interviewer_0_0': 0, 'Cancer-diagnosed-by-doctor_Yes-you-will-be-asked-about-this-later-by-an-interviewer_0_0': 1})
types_of_transport_used_excluding_work_carmotor_vehicle_2_0 = TensorMap('Types-of-transport-used-excluding-work_Carmotor-vehicle_2_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Types-of-transport-used-excluding-work_Carmotor-vehicle_2_0': 0, 'Types-of-transport-used-excluding-work_Carmotor-vehicle_2_0': 1})
types_of_physical_activity_in_last_4_weeks_walking_for_pleasure_not_as_a_means_of_transport_2_0 = TensorMap('Types-of-physical-activity-in-last-4-weeks_Walking-for-pleasure-not-as-a-means-of-transport_2_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Types-of-physical-activity-in-last-4-weeks_Walking-for-pleasure-not-as-a-means-of-transport_2_0': 0, 'Types-of-physical-activity-in-last-4-weeks_Walking-for-pleasure-not-as-a-means-of-transport_2_0': 1})
usual_walking_pace_slow_pace_0_0 = TensorMap('Usual-walking-pace_Slow-pace_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Usual-walking-pace_Slow-pace_0_0': 0, 'Usual-walking-pace_Slow-pace_0_0': 1})
wheeze_or_whistling_in_the_chest_in_last_year_no_2_0 = TensorMap('Wheeze-or-whistling-in-the-chest-in-last-year_No_2_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Wheeze-or-whistling-in-the-chest-in-last-year_No_2_0': 0, 'Wheeze-or-whistling-in-the-chest-in-last-year_No_2_0': 1})
back_pain_for_3_months_no_0_0 = TensorMap('Back-pain-for-3-months_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Back-pain-for-3-months_No_0_0': 0, 'Back-pain-for-3-months_No_0_0': 1})
frequency_of_walking_for_pleasure_in_last_4_weeks_45_times_a_week_0_0 = TensorMap('Frequency-of-walking-for-pleasure-in-last-4-weeks_45-times-a-week_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Frequency-of-walking-for-pleasure-in-last-4-weeks_45-times-a-week_0_0': 0, 'Frequency-of-walking-for-pleasure-in-last-4-weeks_45-times-a-week_0_0': 1})
neckshoulder_pain_for_3_months_no_0_0 = TensorMap('Neckshoulder-pain-for-3-months_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Neckshoulder-pain-for-3-months_No_0_0': 0, 'Neckshoulder-pain-for-3-months_No_0_0': 1})
gap_coding_retired_0_0 = TensorMap('Gap-coding_Retired_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Gap-coding_Retired_0_0': 0, 'Gap-coding_Retired_0_0': 1})
never_eat_eggs_dairy_wheat_sugar_i_eat_all_of_the_above_2_0 = TensorMap('Never-eat-eggs-dairy-wheat-sugar_I-eat-all-of-the-above_2_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Never-eat-eggs-dairy-wheat-sugar_I-eat-all-of-the-above_2_0': 0, 'Never-eat-eggs-dairy-wheat-sugar_I-eat-all-of-the-above_2_0': 1})
pm_initial_answer_blue_square_0_0 = TensorMap('PM-initial-answer_Blue-square_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_PM-initial-answer_Blue-square_0_0': 0, 'PM-initial-answer_Blue-square_0_0': 1})
surgeryamputation_of_toe_or_leg_no_0_0 = TensorMap('Surgeryamputation-of-toe-or-leg_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Surgeryamputation-of-toe-or-leg_No_0_0': 0, 'Surgeryamputation-of-toe-or-leg_No_0_0': 1})
alcohol_intake_frequency_never_0_0 = TensorMap('Alcohol-intake-frequency_Never_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Alcohol-intake-frequency_Never_0_0': 0, 'Alcohol-intake-frequency_Never_0_0': 1})
mineral_and_other_dietary_supplements_glucosamine_0_0 = TensorMap('Mineral-and-other-dietary-supplements_Glucosamine_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Mineral-and-other-dietary-supplements_Glucosamine_0_0': 0, 'Mineral-and-other-dietary-supplements_Glucosamine_0_0': 1})
diabetes_type_2 = TensorMap('diabetes_type_2', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_diabetes_type_2': 0, 'diabetes_type_2': 1})
illnesses_of_father_do_not_know_group_2_0_1 = TensorMap('Illnesses-of-father_Do-not-know-group-2_0_1', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Illnesses-of-father_Do-not-know-group-2_0_1': 0, 'Illnesses-of-father_Do-not-know-group-2_0_1': 1})
qualifications_other_professional_qualifications_eg_nursing_teaching_0_1 = TensorMap('Qualifications_Other-professional-qualifications-eg-nursing-teaching_0_1', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Qualifications_Other-professional-qualifications-eg-nursing-teaching_0_1': 0, 'Qualifications_Other-professional-qualifications-eg-nursing-teaching_0_1': 1})
triplet_correct_right_yes_2_2 = TensorMap('Triplet-correct-right_yes_2_2', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Triplet-correct-right_yes_2_2': 0, 'Triplet-correct-right_yes_2_2': 1})
fractured_heel_right_no_2_0 = TensorMap('Fractured-heel-right_no_2_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Fractured-heel-right_no_2_0': 0, 'Fractured-heel-right_no_2_0': 1})
imaging_thoracic = TensorMap('imaging_thoracic', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_imaging_thoracic': 0, 'imaging_thoracic': 1})
coronary_artery_disease_hard = TensorMap('coronary_artery_disease_hard', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_coronary_artery_disease_hard': 0, 'coronary_artery_disease_hard': 1})
own_or_rent_accommodation_lived_in_own_outright_by_you_or_someone_in_your_household_2_0 = TensorMap('Own-or-rent-accommodation-lived-in_Own-outright-by-you-or-someone-in-your-household_2_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Own-or-rent-accommodation-lived-in_Own-outright-by-you-or-someone-in-your-household_2_0': 0, 'Own-or-rent-accommodation-lived-in_Own-outright-by-you-or-someone-in-your-household_2_0': 1})
fractured_heel_left_no_2_0 = TensorMap('Fractured-heel-left_no_2_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Fractured-heel-left_no_2_0': 0, 'Fractured-heel-left_no_2_0': 1})
workplace_very_dusty_rarelynever_0_3 = TensorMap('Workplace-very-dusty_Rarelynever_0_3', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Workplace-very-dusty_Rarelynever_0_3': 0, 'Workplace-very-dusty_Rarelynever_0_3': 1})
surgery_on_leg_arteries_other_than_for_varicose_veins_no_0_0 = TensorMap('Surgery-on-leg-arteries-other-than-for-varicose-veins_No_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Surgery-on-leg-arteries-other-than-for-varicose-veins_No_0_0': 0, 'Surgery-on-leg-arteries-other-than-for-varicose-veins_No_0_0': 1})
duration_of_heavy_diy_between_15_and_30_minutes_0_0 = TensorMap('Duration-of-heavy-DIY_Between-15-and-30-minutes_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Duration-of-heavy-DIY_Between-15-and-30-minutes_0_0': 0, 'Duration-of-heavy-DIY_Between-15-and-30-minutes_0_0': 1})
digits_entered_correctly_yes_0_4 = TensorMap('Digits-entered-correctly_yes_0_4', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Digits-entered-correctly_yes_0_4': 0, 'Digits-entered-correctly_yes_0_4': 1})
caffeine_drink_within_last_hour_no_2_0 = TensorMap('Caffeine-drink-within-last-hour_No_2_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Caffeine-drink-within-last-hour_No_2_0': 0, 'Caffeine-drink-within-last-hour_No_2_0': 1})
workplace_had_a_lot_of_cigarette_smoke_from_other_people_smoking_rarelynever_0_3 = TensorMap('Workplace-had-a-lot-of-cigarette-smoke-from-other-people-smoking_Rarelynever_0_3', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Workplace-had-a-lot-of-cigarette-smoke-from-other-people-smoking_Rarelynever_0_3': 0, 'Workplace-had-a-lot-of-cigarette-smoke-from-other-people-smoking_Rarelynever_0_3': 1})
contraindications_for_spirometry_yes_0_0 = TensorMap('Contraindications-for-spirometry_Yes_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Contraindications-for-spirometry_Yes_0_0': 0, 'Contraindications-for-spirometry_Yes_0_0': 1})
noncancer_illness_code_selfreported_asthma_0_0 = TensorMap('Noncancer-illness-code-selfreported_asthma_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Noncancer-illness-code-selfreported_asthma_0_0': 0, 'Noncancer-illness-code-selfreported_asthma_0_0': 1})
triplet_correct_left_yes_2_2 = TensorMap('Triplet-correct-left_yes_2_2', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Triplet-correct-left_yes_2_2': 0, 'Triplet-correct-left_yes_2_2': 1})
types_of_physical_activity_in_last_4_weeks_light_diy_eg_pruning_watering_the_lawn_0_0 = TensorMap('Types-of-physical-activity-in-last-4-weeks_Light-DIY-eg-pruning-watering-the-lawn_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Types-of-physical-activity-in-last-4-weeks_Light-DIY-eg-pruning-watering-the-lawn_0_0': 0, 'Types-of-physical-activity-in-last-4-weeks_Light-DIY-eg-pruning-watering-the-lawn_0_0': 1})
duration_walking_for_pleasure_between_15_and_2_hours_0_0 = TensorMap('Duration-walking-for-pleasure_Between-15-and-2-hours_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Duration-walking-for-pleasure_Between-15-and-2-hours_0_0': 0, 'Duration-walking-for-pleasure_Between-15-and-2-hours_0_0': 1})
illnesses_of_father_prostate_cancer_0_0 = TensorMap('Illnesses-of-father_Prostate-cancer_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Illnesses-of-father_Prostate-cancer_0_0': 0, 'Illnesses-of-father_Prostate-cancer_0_0': 1})
allergic_rhinitis = TensorMap('allergic_rhinitis', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_allergic_rhinitis': 0, 'allergic_rhinitis': 1})
hypothyroidism = TensorMap('hypothyroidism', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_hypothyroidism': 0, 'hypothyroidism': 1})
illnesses_of_father_diabetes_0_0 = TensorMap('Illnesses-of-father_Diabetes_0_0', Interpretation.CATEGORICAL, storage_type=StorageType.CATEGORICAL_INDEX, path_prefix='categorical', loss='categorical_crossentropy', channel_map={'no_Illnesses-of-father_Diabetes_0_0': 0, 'Illnesses-of-father_Diabetes_0_0': 1})
