"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BashExecFunction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const lambda = require("@aws-cdk/aws-lambda");
const logs = require("@aws-cdk/aws-logs");
const core_1 = require("@aws-cdk/core");
const cr = require("@aws-cdk/custom-resources");
/**
 * @stability stable
 */
class BashExecFunction extends core_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id);
        const dockerDirPath = path.join(__dirname, '../docker.d');
        const scriptPath = props.script;
        // build a symbolic link so we can add the user script into the docker image
        const mainFile = path.join(dockerDirPath, '/main.sh');
        fs.copyFileSync(scriptPath, mainFile);
        this.handler = new lambda.DockerImageFunction(this, 'BashExecFunction', {
            code: lambda.DockerImageCode.fromImageAsset(dockerDirPath),
            timeout: core_1.Duration.seconds(60),
            logRetention: logs.RetentionDays.ONE_DAY,
        });
        new core_1.CfnOutput(this, 'LogGroup', { value: this.handler.logGroup.logGroupName });
    }
    /**
     * @stability stable
     */
    run() {
        const onEvent = new lambda.DockerImageFunction(this, 'OnEventHandler', {
            code: lambda.DockerImageCode.fromImageAsset(path.join(__dirname, '../docker.d'), {
                cmd: ['function.sh.onEvent'],
            }),
            environment: {
                LAMBDA_FUNCTION_ARN: this.handler.functionArn,
            },
            timeout: core_1.Duration.seconds(60),
        });
        const myProvider = new cr.Provider(this, 'MyProvider', {
            onEventHandler: onEvent,
        });
        new core_1.CustomResource(this, 'RunLambdaBash', { serviceToken: myProvider.serviceToken });
        this.handler.grantInvoke(onEvent.grantPrincipal);
    }
}
exports.BashExecFunction = BashExecFunction;
_a = JSII_RTTI_SYMBOL_1;
BashExecFunction[_a] = { fqn: "cdk-lambda-bash.BashExecFunction", version: "0.0.3" };
//# sourceMappingURL=data:application/json;base64,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