# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/00_plotped.ipynb.

# %% auto 0
__all__ = ['load_attributes', 'readped', 'update_attributes', 'plotped', 'get_args', 'GraphPedCli', 'GraphPed', 'show']

# %% ../nbs/00_plotped.ipynb 4
import yaml
import numpy as np
import pandas as pd
from graphviz import Digraph
from IPython import display

# %% ../nbs/00_plotped.ipynb 5
def load_attributes(yaml_file):
    "Load the self-defined attributes from a yaml file"
    with open(yaml_file, "r") as stream:
        try:
            yml = yaml.safe_load(stream)
        except yaml.YAMLError as exc:
            print(exc)
    return yml

# %% ../nbs/00_plotped.ipynb 9
def readped(file,attrs=None):
    ''' the number of traits in the input file should match with the number of traits in the attribute yaml file'''
    if attrs:
        peds = pd.read_csv(file,header=None,names=['fid','iid','fathid','mothid','sex']+list(attrs.keys()),sep='\t')
    else:
        peds = pd.read_csv(file,header=None,names=['fid','iid','fathid','mothid','sex','trait'],sep='\t')
    return peds

# %% ../nbs/00_plotped.ipynb 13
def update_attributes(r,attrs=None):
    "Assign each node specific attributes"
    #The basic attributes of a node
    attributes={'shape':'polygon','height':'0.3','width':'0.5','regular':'0','style':"filled",'fontcolor':'black'}
    gender = {"m":"box","1":"box",1:"box","f":"ellipse","2":"ellipse",2:"ellipse",0:"polygon"}
    if attrs:
        attributes['shape'] = gender[r.sex]
        for k,v in r[5:].items(): #start from gender to traits
            attr=attrs[k]
            for a,t in attr.items():
                attributes[a] = t[v]
    else:
        trait = {1:'white',2:'dimgrey',-9:'aquamarine3'}
        vcf = {True:"filled,setlinewidth(4)",False:"filled"}
        trim = {True:'darkorange',False:'black'}
        attributes['shape'] = gender[r.sex]
        #traits
        attributes['fillcolor']=trait[r.trait]
        try:
            attributes['style']=vcf[r.vcf]
            attributes['fontcolor'] = trim[r.trim]
        except:
            pass
    return attributes

# %% ../nbs/00_plotped.ipynb 14
def plotped(fi,attrs=None,output=None,format='svg',engine='dot'):
    "The core function of pedigree drawing"
    #nodes
    #create iid nodes
    #create parent nodes
    #edges
    #parent to iid
    #fathid,mothid to parent
    # Create Digraph object
    dot = Digraph()
    dot.engine = engine
    # Add nodes
    parents = []
    for i,r in fi.iterrows():
        dot.node(r.iid,shape='box',_attributes=update_attributes(r,attrs))
        if r.fathid !='0' and r.mothid !='0':
            parents.append(r.fathid+'x'+r.mothid)
            dot.edge(r.fathid+'x'+r.mothid,r.iid)
        #edge to children
        ch_r = (fi.fathid==r.iid) | (fi.mothid==r.iid)
        if ch_r.any():
            for p in fi[ch_r][['fathid','mothid']].agg('x'.join, axis=1).unique():
                dot.edge(r.iid,p)
    for p in set(parents):
        dot.node(p,shape='diamond',label='',height='.1',width='.1')
    if output:
        dot.render(outfile=output+'/'+str(list(fi.fid)[0])+'.'+format,format=format,overwrite_source=True)
    else:
        return dot

# %% ../nbs/00_plotped.ipynb 19
def get_args():
    "The arguments of graphped"
    import argparse
    parser = argparse.ArgumentParser(description="The arguments of graphped",
                                     formatter_class=argparse.ArgumentDefaultsHelpFormatter)
    parser.add_argument("-p", "--ped", help="a ped file or an extended ped file")
    parser.add_argument("-o", "--output", default='./',help="output folder")
    parser.add_argument("-f", "--format", default='svg', help="the format of the output picture")
    parser.add_argument("-a", "--attributes", help="the attributes of the output picture")
    parser.add_argument("-e", "--engine", default='dot', help="the engine of graphviz rendering the output picture")
    return parser

# %% ../nbs/00_plotped.ipynb 23
def GraphPedCli():
    "The command line function of GraphPed"
    #test command line
    #args = get_args().parse_args('-p data/fam.ped -f svg'.split())
    args = get_args().parse_args()
    if args.attributes:
        attrs=load_attributes(args.attributes)
    else:
        attrs=None
    ped=readped(args.ped,attrs)
    GraphPed(ped,attrs,args.output,args.format,args.engine)
    

# %% ../nbs/00_plotped.ipynb 24
def GraphPed(ped,attrs=None,output=None,format='svg',engine='dot'):
    "Draw pedigree plot from ped"
    fids=ped.fid.unique()
    dots=[]
    for i in fids:
        dots.append(plotped(ped[ped.fid ==i],attrs,output,format,engine))
    if output is None:
        return dots

# %% ../nbs/00_plotped.ipynb 28
def show(dot):
    "Plot a pedigree of a list of pedigrees in Jupyter Notebook"
    if isinstance(dot,list):
        for d in dot:
            display.display(d)
    else:
        display.display(dot)
