from enum import Enum


class LoggerInstances(Enum):
    ASKLORAXALPACA = "askloraxalpaca"
    LEDGER = "ledger"
    SCHEDULER = "scheduler"
    OTHER = "other"

    @classmethod
    def has_value(cls, key) -> bool:
        return isinstance(key, cls) or key.upper() in cls.__members__

    @staticmethod
    def from_str(label):
        if not isinstance(label, str):
            raise TypeError("Invalid label")

        if label.lower() in ["askloraxalpaca", "asklora", "alpaca", "apca"]:
            return LoggerInstances.ASKLORAXALPACA
        elif label.lower() in ["ledger", "paymentservice", "payment"]:
            return LoggerInstances.LEDGER
        elif label.lower() in ["scheduler", "celery"]:
            return LoggerInstances.SCHEDULER
        else:
            return LoggerInstances.OTHER
